# -*- coding: utf-8 -*-

# The 'coding' line above was manually added to the autogenerated code
# to prevent the error message on import:
#   SyntaxError: Non-ASCII character '\xef' in file concrete/nitf/ttypes.py

#
# Autogenerated by Thrift Compiler (1.0.0-dev)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style,utf8strings
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException

from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None



class NITFInfo(object):
  """
  Attributes:
   - alternateURL: This field specifies the location on nytimes.com of the article. When
  present, this URL is preferred to the URL field on articles published on
  or after April 02, 2006, as the linked page will have richer content.
   - articleAbstract: This field is a summary of the article written by the New York Times
  Indexing Service.
   - authorBiography: This field specifies the biography of the author of the article.
  Generally, this field is specified for guest authors not for New York
  Times reporters. When this field is specified for Times reporters, it is
  usually used to provide the author's email address.
   - banner: The banner field is used to indicate if there has been additional
  information appended to the articles since its publication. Examples of
  banners include ('Correction Appended' and 'Editor's Note Appended').
   - biographicalCategories: When present, the biographical category field generally indicates that a
  document focuses on a particular individual. The value of the field
  indicates the area or category in which this individual is best known.
  This field is most often defined for Obituaries and Book Reviews. These
  tags are hand-assigned by a team of library scientists working for the
  New York Times Indexing service.

  <ol>
  <li>Politics and Government (U.S.) <li>Books and Magazines <li>Royalty
  </ol>
   - body: The body field is the text content of the article. Please note that this
  value includes the lead paragraph.
   - byline: This field specifies the byline of the article as it appeared in the
  print edition of the New York Times. Please note that not every article
  in this collection has a byline, as editorials and other types of
  articles are generally unsigned.
  <P>
  Sample byline:
  <ul>
  <li>By James Reston
  <li>By JAMES GLANZ; William J. Broad contributed reporting for this
  article.
  <li>By ADAM NAGOURNEY and JEFF ZELENY
  </ul>
   - columnName: If the article is part of a regular column, this field specifies the name
  of that column.
  <p>
  Sample Column Names:
  <p>
  <ol>
  <li>World News Briefs
  <li>WEDDINGS
  <li>The Accessories Channel
  </ol>

   - columnNumber: This field specifies the column in which the article starts in the print
  paper. A typical printed page in the paper has six columns numbered from
  right to left. As a consequence most, but not all, of the values for this
  field fall in the range 1-6.
   - correctionDate: This field specifies the date on which a correction was made to the
  article. Generally, if the correction date is specified, the correction
  text will also be specified (and vice versa).
   - correctionText: For articles corrected following publication, this field specifies the
  correction. Generally, if the correction text is specified, the
  correction date will also be specified (and vice versa).
   - credit: This field indicates the entity that produced the editorial content of
  this document. For this collection, the credit will always be set to 'The
  New York Times'.
   - dateline: The �dateline� field is the dateline of the article. Generally a dateline
  is the name of the geographic location from which the article was filed
  followed by a comma and the month and day of the filing.
  <p>
  Sample datelines:
  <ul>
  <li>WASHINGTON, April 30
  <li>RIYADH, Saudi Arabia, March 29
  <li>ONTARIO, N.Y., Jan. 26
  </ul>
  Please note:
  <ol>
  <li>The dateline location is the location from which the article was
  filed. Often times this location is related to the content of the
  article, but this is not guaranteed.
  <li>The date specified for the dateline is often but not always the day
  previous to the publication date.
  <li>The date is usually but not always specified.
  </ol>
   - dayOfWeek: This field specifies the day of week on which the article was published.
  <ul>
  <li>Monday <li>Tuesday <li>Wednesday <li>Thursday <li>Friday <li>Saturday
  <li>Sunday
  </ul>
   - descriptors: The �descriptors� field specifies a list of descriptive terms drawn from
  a normalized controlled vocabulary corresponding to subjects mentioned in
  the article. These tags are hand-assigned by a team of library scientists
  working in the New York Times Indexing service.
  <p>
  Examples Include:
  <ol>
  <li>ECONOMIC CONDITIONS AND TRENDS
  <li>AIRPLANES
  <li>VIOLINS
  </ol>
   - featurePage: The
   - generalOnlineDescriptors: The �general online descriptors� field specifies a list of descriptors
  that are at a higher level of generality than the other tags associated
  with the article. These tags are algorithmically assigned and manually
  verified by nytimes.com production staff.
  <p>
  Examples Include:
  <ol>
  <li>Surfing
  <li>Venice Biennale
  <li>Ranches
  </ol>
   - guid: The GUID field specifies a an integer that is guaranteed to be unique for
  every document in the corpus.
   - headline: This field specifies the headline of the article as it appeared in the
  print edition of the New York Times.
   - kicker: The kicker is an additional piece of information printed as an
  accompaniment to a news headline.
   - leadParagraph: The �lead Paragraph� field is the lead paragraph of the article.
  Generally this field is populated with the first two paragraphs from the
  article.
   - locations: The �locations� field specifies a list of geographic descriptors drawn
  from a normalized controlled vocabulary that correspond to places
  mentioned in the article. These tags are hand-assigned by a team of
  library scientists working for the New York Times Indexing service.
  <p>
  Examples Include:
  <ol>
  <li>Wellsboro (Pa)
  <li>Kansas City (Kan)
  <li>Park Slope (NYC)
  </ol>
   - names: The �names� field specifies a list of names mentioned in the article.
  These tags are hand-assigned by a team of library scientists working for
  the New York Times Indexing service.
  <p>
  Examples Include:
  <ol>
  <li>Azza Fahmy
  <li>George C. Izenour
  <li>Chris Schenkel
  </ol>
   - newsDesk: This field specifies the desk in the New York Times newsroom that
  produced the article. The desk is related to, but is not the same as the
  section in which the article appears.
   - normalizedByline: The Normalized Byline field is the byline normalized to the form (last
  name, first name).
   - onlineDescriptors: This field specifies a list of descriptors from a normalized controlled
  vocabulary that correspond to topics mentioned in the article. These tags
  are algorithmically assigned and manually verified by nytimes.com
  production staff.
  <p>
  Examples Include:
  <ol>
  <li>Marriages
  <li>Parks and Other Recreation Areas
  <li>Cooking and Cookbooks
  </ol>
   - onlineHeadline: This field specifies the headline displayed with the article on
  nytimes.com. Often this differs from the headline used in print.
   - onlineLeadParagraph: This field specifies the lead paragraph as defined by the producers at
  nytimes.com.
   - onlineLocations: This field specifies a list of place names that correspond to geographic
  locations mentioned in the article. These tags are algorithmically
  assigned and manually verified by nytimes.com production staff.
  <p>
  Examples Include:
  <ol>
  <li>Hollywood
  <li>Los Angeles
  <li>Arcadia
  </ol>
   - onlineOrganizations: This field specifies a list of organizations that correspond to
  organizations mentioned in the article. These tags are algorithmically
  assigned and manually verified by nytimes.com production staff.
  <p>
  Examples Include:
  <ol>
  <li>Nintendo Company Limited
  <li>Yeshiva University
  <li>Rose Center
  </ol>
   - onlinePeople: This field specifies a list of people that correspond to individuals
  mentioned in the article. These tags are algorithmically assigned and
  manually verified by nytimes.com production staff.
  <p>
  Examples Include:
  <ol>
  <li>Lopez, Jennifer
  <li>Joyce, James
  <li>Robinson, Jackie
  </ol>
   - onlineSection: This field specifies the section(s) on nytimes.com in which the article
  is placed. If the article is placed in multiple sections, this field will
  be specified as a �;� delineated list.
   - onlineTitles: This field specifies a list of authored works mentioned in the article.
  These tags are algorithmically assigned and manually verified by
  nytimes.com production staff.
  <p>
  Examples Include:
  <ol>
  <li>Matchstick Men (Movie)
  <li>Blades of Glory (Movie)
  <li>Bridge & Tunnel (Play)
  </ol>
   - organizations: This field specifies a list of organization names drawn from a normalized
  controlled vocabulary that correspond to organizations mentioned in the
  article. These tags are hand-assigned by a team of library scientists
  working in the New York Times Indexing service.
  <p>
  Examples Include:
  <ol>
  <li>Circuit City Stores Inc
  <li>Delaware County Community College (Pa)
  <li>CONNECTICUT GRAND OPERA
  </ol>
   - page: This field specifies the page of the section in the paper in which the
  article appears. This is not an absolute pagination. An article that
  appears on page 3 in section A occurs in the physical paper before an
  article that occurs on page 1 of section F.
   - people: This field specifies a list of people from a normalized controlled
  vocabulary that correspond to individuals mentioned in the article. These
  tags are hand-assigned by a team of library scientists working in the New
  York Times Indexing service.
  <p>
  Examples Include:
  <ol>
  <li>REAGAN, RONALD WILSON (PRES)
  <li>BEGIN, MENACHEM (PRIME MIN)
  <li>COLLINS, GLENN
  </ol>
   - publicationDate: This field specifies the date of the article�s publication.
   - publicationDayOfMonth: This field specifies the day of the month on which the article was
  published, always in the range 1-31.
   - publicationMonth: This field specifies the month on which the article was published in the
  range 1-12 where 1 is January 2 is February etc.
   - publicationYear: This field specifies the year in which the article was published. This
  value is in the range 1987-2007 for this collection.
   - section: This field specifies the section of the paper in which the article
  appears. This is not the name of the section, but rather a letter or
  number that indicates the section.
   - seriesName: If the article is part of a regular series, this field specifies the name
  of that column.
   - slug: The slug is a short string that uniquely identifies an article from all
  other articles published on the same day. Please note, however, that
  different articles on different days may have the same slug.
  <ul>
  <li>30other <li>12reunion
  </ul>
   - sourceFilePath: The file from which this object was read.
   - taxonomicClassifiers: This field specifies a list of taxonomic classifiers that place this
  article into a hierarchy of articles. The individual terms of each
  taxonomic classifier are separated with the '/' character. These tags are
  algorithmically assigned and manually verified by nytimes.com production
  staff. These tags are algorithmically assigned and manually verified by
  nytimes.com production staff.
  <p>
  Examples Include:
  <ol>
  <li>Top/Features/Travel/Guides/Destinations/North America/United
  States/Arizona
  <li>Top/News/U.S./Rockies
  <li>Top/Opinion
  </ol>
   - titles: This field specifies a list of authored works that correspond to works
  mentioned in the article. These tags are hand-assigned by a team of
  library scientists working in the New York Times Indexing service.
  <p>
  Examples Include:
  <ol>
  <li>Greystoke: The Legend of Tarzan, Lord of the Apes (Movie)
  <li>Law & Order (TV Program)
  <li>BATTLEFIELD EARTH (BOOK)
  </ol>
   - typesOfMaterial: This field specifies a normalized list of terms describing the general
  editorial category of the article. These tags are algorithmically
  assigned and manually verified by nytimes.com production staff.
  <p>
  Examples Include:
  <ol>
  <li>REVIEW
  <li>OBITUARY
  <li>ANALYSIS
  </ol>
   - url: This field specifies the location on nytimes.com of the article. The
  �Alternative Url� field is preferred to this field on articles published
  on or after April 02, 2006, as the linked page will have richer content.
   - wordCount: This field specifies the number of words in the body of the article,
  including the lead paragraph.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'alternateURL', None, None, ), # 1
    (2, TType.STRING, 'articleAbstract', None, None, ), # 2
    (3, TType.STRING, 'authorBiography', None, None, ), # 3
    (4, TType.STRING, 'banner', None, None, ), # 4
    (5, TType.LIST, 'biographicalCategories', (TType.STRING,None), None, ), # 5
    (6, TType.STRING, 'body', None, None, ), # 6
    (7, TType.STRING, 'byline', None, None, ), # 7
    (8, TType.STRING, 'columnName', None, None, ), # 8
    (9, TType.I32, 'columnNumber', None, None, ), # 9
    (10, TType.I64, 'correctionDate', None, None, ), # 10
    (11, TType.STRING, 'correctionText', None, None, ), # 11
    (12, TType.STRING, 'credit', None, None, ), # 12
    (13, TType.STRING, 'dateline', None, None, ), # 13
    (14, TType.STRING, 'dayOfWeek', None, None, ), # 14
    (15, TType.LIST, 'descriptors', (TType.STRING,None), None, ), # 15
    (16, TType.STRING, 'featurePage', None, None, ), # 16
    (17, TType.LIST, 'generalOnlineDescriptors', (TType.STRING,None), None, ), # 17
    (18, TType.I32, 'guid', None, None, ), # 18
    (19, TType.STRING, 'headline', None, None, ), # 19
    (20, TType.STRING, 'kicker', None, None, ), # 20
    (21, TType.STRING, 'leadParagraph', None, None, ), # 21
    (22, TType.LIST, 'locations', (TType.STRING,None), None, ), # 22
    (23, TType.LIST, 'names', (TType.STRING,None), None, ), # 23
    (24, TType.STRING, 'newsDesk', None, None, ), # 24
    (25, TType.STRING, 'normalizedByline', None, None, ), # 25
    (26, TType.LIST, 'onlineDescriptors', (TType.STRING,None), None, ), # 26
    (27, TType.STRING, 'onlineHeadline', None, None, ), # 27
    (28, TType.STRING, 'onlineLeadParagraph', None, None, ), # 28
    (29, TType.LIST, 'onlineLocations', (TType.STRING,None), None, ), # 29
    (30, TType.LIST, 'onlineOrganizations', (TType.STRING,None), None, ), # 30
    (31, TType.LIST, 'onlinePeople', (TType.STRING,None), None, ), # 31
    (32, TType.STRING, 'onlineSection', None, None, ), # 32
    (33, TType.LIST, 'onlineTitles', (TType.STRING,None), None, ), # 33
    (34, TType.LIST, 'organizations', (TType.STRING,None), None, ), # 34
    (35, TType.I32, 'page', None, None, ), # 35
    (36, TType.LIST, 'people', (TType.STRING,None), None, ), # 36
    (37, TType.I64, 'publicationDate', None, None, ), # 37
    (38, TType.I32, 'publicationDayOfMonth', None, None, ), # 38
    (39, TType.I32, 'publicationMonth', None, None, ), # 39
    (40, TType.I32, 'publicationYear', None, None, ), # 40
    (41, TType.STRING, 'section', None, None, ), # 41
    (42, TType.STRING, 'seriesName', None, None, ), # 42
    (43, TType.STRING, 'slug', None, None, ), # 43
    (44, TType.STRING, 'sourceFilePath', None, None, ), # 44
    (45, TType.LIST, 'taxonomicClassifiers', (TType.STRING,None), None, ), # 45
    (46, TType.LIST, 'titles', (TType.STRING,None), None, ), # 46
    (47, TType.LIST, 'typesOfMaterial', (TType.STRING,None), None, ), # 47
    (48, TType.STRING, 'url', None, None, ), # 48
    (49, TType.I32, 'wordCount', None, None, ), # 49
  )

  def __init__(self, alternateURL=None, articleAbstract=None, authorBiography=None, banner=None, biographicalCategories=None, body=None, byline=None, columnName=None, columnNumber=None, correctionDate=None, correctionText=None, credit=None, dateline=None, dayOfWeek=None, descriptors=None, featurePage=None, generalOnlineDescriptors=None, guid=None, headline=None, kicker=None, leadParagraph=None, locations=None, names=None, newsDesk=None, normalizedByline=None, onlineDescriptors=None, onlineHeadline=None, onlineLeadParagraph=None, onlineLocations=None, onlineOrganizations=None, onlinePeople=None, onlineSection=None, onlineTitles=None, organizations=None, page=None, people=None, publicationDate=None, publicationDayOfMonth=None, publicationMonth=None, publicationYear=None, section=None, seriesName=None, slug=None, sourceFilePath=None, taxonomicClassifiers=None, titles=None, typesOfMaterial=None, url=None, wordCount=None,):
    self.alternateURL = alternateURL
    self.articleAbstract = articleAbstract
    self.authorBiography = authorBiography
    self.banner = banner
    self.biographicalCategories = biographicalCategories
    self.body = body
    self.byline = byline
    self.columnName = columnName
    self.columnNumber = columnNumber
    self.correctionDate = correctionDate
    self.correctionText = correctionText
    self.credit = credit
    self.dateline = dateline
    self.dayOfWeek = dayOfWeek
    self.descriptors = descriptors
    self.featurePage = featurePage
    self.generalOnlineDescriptors = generalOnlineDescriptors
    self.guid = guid
    self.headline = headline
    self.kicker = kicker
    self.leadParagraph = leadParagraph
    self.locations = locations
    self.names = names
    self.newsDesk = newsDesk
    self.normalizedByline = normalizedByline
    self.onlineDescriptors = onlineDescriptors
    self.onlineHeadline = onlineHeadline
    self.onlineLeadParagraph = onlineLeadParagraph
    self.onlineLocations = onlineLocations
    self.onlineOrganizations = onlineOrganizations
    self.onlinePeople = onlinePeople
    self.onlineSection = onlineSection
    self.onlineTitles = onlineTitles
    self.organizations = organizations
    self.page = page
    self.people = people
    self.publicationDate = publicationDate
    self.publicationDayOfMonth = publicationDayOfMonth
    self.publicationMonth = publicationMonth
    self.publicationYear = publicationYear
    self.section = section
    self.seriesName = seriesName
    self.slug = slug
    self.sourceFilePath = sourceFilePath
    self.taxonomicClassifiers = taxonomicClassifiers
    self.titles = titles
    self.typesOfMaterial = typesOfMaterial
    self.url = url
    self.wordCount = wordCount

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.alternateURL = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.articleAbstract = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.authorBiography = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.banner = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.LIST:
          self.biographicalCategories = []
          (_etype3, _size0) = iprot.readListBegin()
          for _i4 in xrange(_size0):
            _elem5 = iprot.readString().decode('utf-8')
            self.biographicalCategories.append(_elem5)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.body = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRING:
          self.byline = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.STRING:
          self.columnName = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.I32:
          self.columnNumber = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.I64:
          self.correctionDate = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.STRING:
          self.correctionText = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.STRING:
          self.credit = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.STRING:
          self.dateline = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.STRING:
          self.dayOfWeek = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 15:
        if ftype == TType.LIST:
          self.descriptors = []
          (_etype9, _size6) = iprot.readListBegin()
          for _i10 in xrange(_size6):
            _elem11 = iprot.readString().decode('utf-8')
            self.descriptors.append(_elem11)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 16:
        if ftype == TType.STRING:
          self.featurePage = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 17:
        if ftype == TType.LIST:
          self.generalOnlineDescriptors = []
          (_etype15, _size12) = iprot.readListBegin()
          for _i16 in xrange(_size12):
            _elem17 = iprot.readString().decode('utf-8')
            self.generalOnlineDescriptors.append(_elem17)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 18:
        if ftype == TType.I32:
          self.guid = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 19:
        if ftype == TType.STRING:
          self.headline = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 20:
        if ftype == TType.STRING:
          self.kicker = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 21:
        if ftype == TType.STRING:
          self.leadParagraph = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 22:
        if ftype == TType.LIST:
          self.locations = []
          (_etype21, _size18) = iprot.readListBegin()
          for _i22 in xrange(_size18):
            _elem23 = iprot.readString().decode('utf-8')
            self.locations.append(_elem23)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 23:
        if ftype == TType.LIST:
          self.names = []
          (_etype27, _size24) = iprot.readListBegin()
          for _i28 in xrange(_size24):
            _elem29 = iprot.readString().decode('utf-8')
            self.names.append(_elem29)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 24:
        if ftype == TType.STRING:
          self.newsDesk = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 25:
        if ftype == TType.STRING:
          self.normalizedByline = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 26:
        if ftype == TType.LIST:
          self.onlineDescriptors = []
          (_etype33, _size30) = iprot.readListBegin()
          for _i34 in xrange(_size30):
            _elem35 = iprot.readString().decode('utf-8')
            self.onlineDescriptors.append(_elem35)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 27:
        if ftype == TType.STRING:
          self.onlineHeadline = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 28:
        if ftype == TType.STRING:
          self.onlineLeadParagraph = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 29:
        if ftype == TType.LIST:
          self.onlineLocations = []
          (_etype39, _size36) = iprot.readListBegin()
          for _i40 in xrange(_size36):
            _elem41 = iprot.readString().decode('utf-8')
            self.onlineLocations.append(_elem41)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 30:
        if ftype == TType.LIST:
          self.onlineOrganizations = []
          (_etype45, _size42) = iprot.readListBegin()
          for _i46 in xrange(_size42):
            _elem47 = iprot.readString().decode('utf-8')
            self.onlineOrganizations.append(_elem47)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 31:
        if ftype == TType.LIST:
          self.onlinePeople = []
          (_etype51, _size48) = iprot.readListBegin()
          for _i52 in xrange(_size48):
            _elem53 = iprot.readString().decode('utf-8')
            self.onlinePeople.append(_elem53)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 32:
        if ftype == TType.STRING:
          self.onlineSection = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 33:
        if ftype == TType.LIST:
          self.onlineTitles = []
          (_etype57, _size54) = iprot.readListBegin()
          for _i58 in xrange(_size54):
            _elem59 = iprot.readString().decode('utf-8')
            self.onlineTitles.append(_elem59)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 34:
        if ftype == TType.LIST:
          self.organizations = []
          (_etype63, _size60) = iprot.readListBegin()
          for _i64 in xrange(_size60):
            _elem65 = iprot.readString().decode('utf-8')
            self.organizations.append(_elem65)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 35:
        if ftype == TType.I32:
          self.page = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 36:
        if ftype == TType.LIST:
          self.people = []
          (_etype69, _size66) = iprot.readListBegin()
          for _i70 in xrange(_size66):
            _elem71 = iprot.readString().decode('utf-8')
            self.people.append(_elem71)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 37:
        if ftype == TType.I64:
          self.publicationDate = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 38:
        if ftype == TType.I32:
          self.publicationDayOfMonth = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 39:
        if ftype == TType.I32:
          self.publicationMonth = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 40:
        if ftype == TType.I32:
          self.publicationYear = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 41:
        if ftype == TType.STRING:
          self.section = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 42:
        if ftype == TType.STRING:
          self.seriesName = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 43:
        if ftype == TType.STRING:
          self.slug = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 44:
        if ftype == TType.STRING:
          self.sourceFilePath = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 45:
        if ftype == TType.LIST:
          self.taxonomicClassifiers = []
          (_etype75, _size72) = iprot.readListBegin()
          for _i76 in xrange(_size72):
            _elem77 = iprot.readString().decode('utf-8')
            self.taxonomicClassifiers.append(_elem77)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 46:
        if ftype == TType.LIST:
          self.titles = []
          (_etype81, _size78) = iprot.readListBegin()
          for _i82 in xrange(_size78):
            _elem83 = iprot.readString().decode('utf-8')
            self.titles.append(_elem83)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 47:
        if ftype == TType.LIST:
          self.typesOfMaterial = []
          (_etype87, _size84) = iprot.readListBegin()
          for _i88 in xrange(_size84):
            _elem89 = iprot.readString().decode('utf-8')
            self.typesOfMaterial.append(_elem89)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 48:
        if ftype == TType.STRING:
          self.url = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 49:
        if ftype == TType.I32:
          self.wordCount = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NITFInfo')
    if self.alternateURL is not None:
      oprot.writeFieldBegin('alternateURL', TType.STRING, 1)
      oprot.writeString(self.alternateURL.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.articleAbstract is not None:
      oprot.writeFieldBegin('articleAbstract', TType.STRING, 2)
      oprot.writeString(self.articleAbstract.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.authorBiography is not None:
      oprot.writeFieldBegin('authorBiography', TType.STRING, 3)
      oprot.writeString(self.authorBiography.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.banner is not None:
      oprot.writeFieldBegin('banner', TType.STRING, 4)
      oprot.writeString(self.banner.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.biographicalCategories is not None:
      oprot.writeFieldBegin('biographicalCategories', TType.LIST, 5)
      oprot.writeListBegin(TType.STRING, len(self.biographicalCategories))
      for iter90 in self.biographicalCategories:
        oprot.writeString(iter90.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.body is not None:
      oprot.writeFieldBegin('body', TType.STRING, 6)
      oprot.writeString(self.body.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.byline is not None:
      oprot.writeFieldBegin('byline', TType.STRING, 7)
      oprot.writeString(self.byline.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.columnName is not None:
      oprot.writeFieldBegin('columnName', TType.STRING, 8)
      oprot.writeString(self.columnName.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.columnNumber is not None:
      oprot.writeFieldBegin('columnNumber', TType.I32, 9)
      oprot.writeI32(self.columnNumber)
      oprot.writeFieldEnd()
    if self.correctionDate is not None:
      oprot.writeFieldBegin('correctionDate', TType.I64, 10)
      oprot.writeI64(self.correctionDate)
      oprot.writeFieldEnd()
    if self.correctionText is not None:
      oprot.writeFieldBegin('correctionText', TType.STRING, 11)
      oprot.writeString(self.correctionText.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.credit is not None:
      oprot.writeFieldBegin('credit', TType.STRING, 12)
      oprot.writeString(self.credit.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.dateline is not None:
      oprot.writeFieldBegin('dateline', TType.STRING, 13)
      oprot.writeString(self.dateline.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.dayOfWeek is not None:
      oprot.writeFieldBegin('dayOfWeek', TType.STRING, 14)
      oprot.writeString(self.dayOfWeek.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.descriptors is not None:
      oprot.writeFieldBegin('descriptors', TType.LIST, 15)
      oprot.writeListBegin(TType.STRING, len(self.descriptors))
      for iter91 in self.descriptors:
        oprot.writeString(iter91.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.featurePage is not None:
      oprot.writeFieldBegin('featurePage', TType.STRING, 16)
      oprot.writeString(self.featurePage.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.generalOnlineDescriptors is not None:
      oprot.writeFieldBegin('generalOnlineDescriptors', TType.LIST, 17)
      oprot.writeListBegin(TType.STRING, len(self.generalOnlineDescriptors))
      for iter92 in self.generalOnlineDescriptors:
        oprot.writeString(iter92.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.I32, 18)
      oprot.writeI32(self.guid)
      oprot.writeFieldEnd()
    if self.headline is not None:
      oprot.writeFieldBegin('headline', TType.STRING, 19)
      oprot.writeString(self.headline.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.kicker is not None:
      oprot.writeFieldBegin('kicker', TType.STRING, 20)
      oprot.writeString(self.kicker.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.leadParagraph is not None:
      oprot.writeFieldBegin('leadParagraph', TType.STRING, 21)
      oprot.writeString(self.leadParagraph.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.locations is not None:
      oprot.writeFieldBegin('locations', TType.LIST, 22)
      oprot.writeListBegin(TType.STRING, len(self.locations))
      for iter93 in self.locations:
        oprot.writeString(iter93.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.names is not None:
      oprot.writeFieldBegin('names', TType.LIST, 23)
      oprot.writeListBegin(TType.STRING, len(self.names))
      for iter94 in self.names:
        oprot.writeString(iter94.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.newsDesk is not None:
      oprot.writeFieldBegin('newsDesk', TType.STRING, 24)
      oprot.writeString(self.newsDesk.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.normalizedByline is not None:
      oprot.writeFieldBegin('normalizedByline', TType.STRING, 25)
      oprot.writeString(self.normalizedByline.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.onlineDescriptors is not None:
      oprot.writeFieldBegin('onlineDescriptors', TType.LIST, 26)
      oprot.writeListBegin(TType.STRING, len(self.onlineDescriptors))
      for iter95 in self.onlineDescriptors:
        oprot.writeString(iter95.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.onlineHeadline is not None:
      oprot.writeFieldBegin('onlineHeadline', TType.STRING, 27)
      oprot.writeString(self.onlineHeadline.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.onlineLeadParagraph is not None:
      oprot.writeFieldBegin('onlineLeadParagraph', TType.STRING, 28)
      oprot.writeString(self.onlineLeadParagraph.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.onlineLocations is not None:
      oprot.writeFieldBegin('onlineLocations', TType.LIST, 29)
      oprot.writeListBegin(TType.STRING, len(self.onlineLocations))
      for iter96 in self.onlineLocations:
        oprot.writeString(iter96.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.onlineOrganizations is not None:
      oprot.writeFieldBegin('onlineOrganizations', TType.LIST, 30)
      oprot.writeListBegin(TType.STRING, len(self.onlineOrganizations))
      for iter97 in self.onlineOrganizations:
        oprot.writeString(iter97.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.onlinePeople is not None:
      oprot.writeFieldBegin('onlinePeople', TType.LIST, 31)
      oprot.writeListBegin(TType.STRING, len(self.onlinePeople))
      for iter98 in self.onlinePeople:
        oprot.writeString(iter98.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.onlineSection is not None:
      oprot.writeFieldBegin('onlineSection', TType.STRING, 32)
      oprot.writeString(self.onlineSection.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.onlineTitles is not None:
      oprot.writeFieldBegin('onlineTitles', TType.LIST, 33)
      oprot.writeListBegin(TType.STRING, len(self.onlineTitles))
      for iter99 in self.onlineTitles:
        oprot.writeString(iter99.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.organizations is not None:
      oprot.writeFieldBegin('organizations', TType.LIST, 34)
      oprot.writeListBegin(TType.STRING, len(self.organizations))
      for iter100 in self.organizations:
        oprot.writeString(iter100.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.page is not None:
      oprot.writeFieldBegin('page', TType.I32, 35)
      oprot.writeI32(self.page)
      oprot.writeFieldEnd()
    if self.people is not None:
      oprot.writeFieldBegin('people', TType.LIST, 36)
      oprot.writeListBegin(TType.STRING, len(self.people))
      for iter101 in self.people:
        oprot.writeString(iter101.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.publicationDate is not None:
      oprot.writeFieldBegin('publicationDate', TType.I64, 37)
      oprot.writeI64(self.publicationDate)
      oprot.writeFieldEnd()
    if self.publicationDayOfMonth is not None:
      oprot.writeFieldBegin('publicationDayOfMonth', TType.I32, 38)
      oprot.writeI32(self.publicationDayOfMonth)
      oprot.writeFieldEnd()
    if self.publicationMonth is not None:
      oprot.writeFieldBegin('publicationMonth', TType.I32, 39)
      oprot.writeI32(self.publicationMonth)
      oprot.writeFieldEnd()
    if self.publicationYear is not None:
      oprot.writeFieldBegin('publicationYear', TType.I32, 40)
      oprot.writeI32(self.publicationYear)
      oprot.writeFieldEnd()
    if self.section is not None:
      oprot.writeFieldBegin('section', TType.STRING, 41)
      oprot.writeString(self.section.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.seriesName is not None:
      oprot.writeFieldBegin('seriesName', TType.STRING, 42)
      oprot.writeString(self.seriesName.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.slug is not None:
      oprot.writeFieldBegin('slug', TType.STRING, 43)
      oprot.writeString(self.slug.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.sourceFilePath is not None:
      oprot.writeFieldBegin('sourceFilePath', TType.STRING, 44)
      oprot.writeString(self.sourceFilePath.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.taxonomicClassifiers is not None:
      oprot.writeFieldBegin('taxonomicClassifiers', TType.LIST, 45)
      oprot.writeListBegin(TType.STRING, len(self.taxonomicClassifiers))
      for iter102 in self.taxonomicClassifiers:
        oprot.writeString(iter102.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.titles is not None:
      oprot.writeFieldBegin('titles', TType.LIST, 46)
      oprot.writeListBegin(TType.STRING, len(self.titles))
      for iter103 in self.titles:
        oprot.writeString(iter103.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.typesOfMaterial is not None:
      oprot.writeFieldBegin('typesOfMaterial', TType.LIST, 47)
      oprot.writeListBegin(TType.STRING, len(self.typesOfMaterial))
      for iter104 in self.typesOfMaterial:
        oprot.writeString(iter104.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.url is not None:
      oprot.writeFieldBegin('url', TType.STRING, 48)
      oprot.writeString(self.url.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.wordCount is not None:
      oprot.writeFieldBegin('wordCount', TType.I32, 49)
      oprot.writeI32(self.wordCount)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
