# 
#  setup.py
#  consoleLog
#  
#  Created by Lars Yencken on 2008-06-12.
#  Copyright 2008-2009 Lars Yencken. All rights reserved.
# 

"Setup script for consoleLog module."

import os
from setuptools import setup

VERSION = '0.2.2'

f = open('src/__version__.py', 'w')
f.write('# autogenerated by setup.py\n')
f.write('version = "%s"\n' % VERSION)
f.close()

setup(
        name='consoleLog',
        version=VERSION,
        description='Console logger with progress bars and color',
        long_description="""
        A Hierarchical console logger which allows nested human-readable
        logging and display, with progress bars and color output.
        """,
        author='Lars Yencken',
        author_email='lljy@csse.unimelb.edu.au',
        license='BSD',
        url='http://bitbucket.org/lars512/consolelog/',
        packages=['consoleLog'],
        package_dir={'consoleLog': 'src'}
    )
