#! /usr/bin/env python
"""Stops the tgtap device drivers on all 10GbE interfaces on the ROACH boards.
Author: Jason Manley
Rev
2010-07-28  JRM Port to corr-0.5.0
"""
import corr, time, sys, numpy, os, logging

def exit_fail():
    print 'FAILURE DETECTED. Log entries:\n',lh.printMessages()
    print "Unexpected error:", sys.exc_info()

    try:
        c.disconnect_all()
    except: pass
    time.sleep(1)
    raise
    exit()

def exit_clean():
    try:
        c.disconnect_all()
    except: pass
    exit()

if __name__ == '__main__':
    from optparse import OptionParser

    p = OptionParser()
    p.set_usage('%prog CONFIG_FILE')
    p.set_description(__doc__)

    opts, args = p.parse_args(sys.argv[1:])

    if args==[]:
        print 'Please specify a configuration file! \nExiting.'
        exit()

try:
    print 'Connecting...',
    c=corr.corr_functions.Correlator(args[0],lh)
    for logger in c.loggers: logger.setLevel(10)
    print 'done.'

    print('\nKilling all 10GbE tgtap drivers...'),
    sys.stdout.flush()
    c.deconfig_roach_10gbe_ports()
    print 'done.'
        

except KeyboardInterrupt:
    exit_clean()
except:
    exit_fail()
exit()
