#!/usr/bin/env python
"""
dbSNP - genetic variation within and across different species
"""

# We can another GATK resource since it's pretty much the same
from example import Resource as iResource


class Resource(iResource):
  """docstring for dbSNP Resource"""
  def __init__(self):
    super(Resource, self).__init__()

    self.id = "indels"

    self.parts = 1
    self.names = ["hapmap_3.3.vcf.gz"]

  def paths(self, version):
    # 1 file
    base = "{base}/{v}/b37".format(base=self.baseUrl, v=version)
    f = "hapmap_3.3.b37.vcf.gz"

    return ["{base}/{file}".format(base=base, file=f)]
