# -*- coding: utf-8 -*-
#
#   Copyright 2009 Andrew Wilkinson <andrewjwilkinson@gmail.com>
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

import unittest

from base_test import BaseTest

class TestMultipleWhereExpr(BaseTest):
    def setUp(self):
        BaseTest.setUp(self)
        for i in range(1, 11):
            self.db.create({ "x": i, "y": 2})

    def testMultipleStatic(self):
        c = self.db.cursor()
        c.execute("SELECT * FROM _ WHERE x = 1 AND y = 2")
        r = c.fetchall()

        self.assert_(len(r) == 1, "Got %i documents not 1." % (len(r), ))
        for doc in r:
            self.assert_(doc.has_key("x") and doc["x"] == 1, "Document %s doesn't have the expected 'x' key." % (repr(doc), ))
            self.assert_(doc.has_key("y") and doc["y"] == 2, "Document %s doesn't have the expected 'y' key." % (repr(doc), ))

    def testMultipleDynamic(self):
        c = self.db.cursor()
        c.execute("SELECT * FROM _ WHERE x = %s AND y = %s", (1, 2))
        r = c.fetchall()

        self.assert_(len(r) == 1, "Got %i documents not 1." % (len(r), ))
        for doc in r:
            self.assert_(doc.has_key("x") and doc["x"] == 1, "Document %s doesn't have the expected 'x' key." % (repr(doc), ))
            self.assert_(doc.has_key("y") and doc["y"] == 2, "Document %s doesn't have the expected 'y' key." % (repr(doc), ))
