# -*- coding: utf-8 -*-
#
#   Copyright 2009 Andrew Wilkinson <andrewjwilkinson@gmail.com>
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

import couchdb
import unittest

from base_test import BaseTest

class TestTemporaryViews(BaseTest):
    def setUp(self):
        BaseTest.setUp(self)
        for i in range(0, 100):
            self.db.create({ "x": i })

    def testSavedView(self):
        c = self.db.cursor()
        c.execute("SELECT * FROM _ WHERE x = %s", (0, ), temporary=False)
        c.fetchall()

        self.assertTrue(len(self.db.view(c.query.view_name)))

    def testTemporaryView(self):
        c = self.db.cursor()
        c.execute("SELECT * FROM _ WHERE y = %s", (100, ), temporary=True)
        c.fetchall()

        self.assertRaises(couchdb.ResourceNotFound, lambda: len(self.db.view(c.query.view_name)))
