#!/usr/bin/python
# -*- encoding: utf-8 -*-

"""Author: (Chowroc)
Date: 2006-12-01
Email: chowroc.z@gmail.com

ûİϵͳ
* úͲִгʼװжԴԼбҰļѯضļİͲѯϢĲ

* ÿһԼӦû飬еļǸû

* Ӧû/ڲָĬΪ

* ÿû $HOME Ŀ¼(/usr/src/$PACKAGE)´ŸðĹ鵵ͲڼеıݺͻָϵͳǨƣһ $HOME ǰ׺· $HOMEPRE(/usr/src)

* ԰֧֣"."ֿռ(ûҲ԰".")

* ÿϢԼ $HOME Ŀ¼($HOME/.config)һһϢļ

* Ϣ֡汾鵵λáװҪʱ估Լϵ(ϵ)

* ָͨʹϢļֱӰװ
״̬ԶаװϵͳıݡָԼǨƻ

* һбļгаֺͰ汾ţһһļΪ $PKGLIST($HOMEPRE/packages.list)
*** 룺ڰװʱɹӦ $PKGLIST ӦĿжʱӦɾ֮ļѯѯϢĲӦȼǷ

*** 汾ʽԼ

ûİϵͳĻԭԲο LFS hints
More Control and Package Management using Package Users (v1.2)
http://www.linuxfromscratch.org/hints/downloads/files/more_control_and_pkg_man.txt

crablfs Copyright (c) 2006 (chowroc.z@gmail.com)

This file is part of crablfs.

crablfs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

crablfs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Foobar; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA"""

__version__ = '0.1'

import os
import sys
import re
import getopt
import shutil
import pwd
import grp
import time

from crablfs.plainconf import getconf, setconf
from crablfs import filetools
from crablfs import shadow

PREFIX = '/usr/local'

homepre = '/usr/src'
pkglist = '%s/packages.list' % homepre
lists = '/etc/userpack.dirs:%s/etc/userpack.dirs:directories' % PREFIX
admin = 'install'
timefmt = '%Y%m%d %H:%M:%S %a'
tartype = '.tar.gz'
PACKS_DIR = ''
uprefix = ''
options = ['homepre', 'pkglist', 'lists', 'admin', 'timefmt', 'tartype', 'PACKS_DIR', 'uprefix']
# ڲЧУ
#  plainconf/xmlconf/ldapconf õȫ(δʵ)
cpforce = False
autocmd = False
# confile = '.config'
confile = ''
# pregexp = r'^(?P<pkgname>(\w+-{0,1})+)(-(?P<version>(\d[\w\.]*-{0,1})+))'
# pregexp = '^(?P<pkgname>(\w+-{0,1})+)(-(?P<version>(\d[\w]*[-\.])*\d[\w]*))'
pregexp = '^(?P<pkgname>(\w+[-\.]{0,1})+)(-(?P<version>(\d[\w]*[-\.])*\d[\w]*))'

def __init__():
	"""ֻܸı directories бָĿ¼ȨޣܰĿ¼ļ
Բʹõݹ飬Ҫȳʼ"""
	global lists
	for option in options:
		exec "temp = option"
		if type(temp) is not str:
			strerr = "%s: %s is not a valid option." % (program, option)
			sys.stderr.write('%s\n' % strerr)
			sys.exit(1)
	temp = lists
	lists = ''
	for dl in temp.split(':'):
		if os.access(dl, os.R_OK): lists = dl; break
	if not lists:
		strerr = "%s: No initializing directories list file found" % program
		sys.stderr.write('%s\n' % strerr) #
		sys.exit(1)

def install(user='', group='', groups=[], package='', archive='', patches=[]):
	"""װ
* еİϢ汾ļ͸ļ

* 趨ûûѴͨ˵ѴڣӦʾ(δʵ)
ûԴӰװļ(profile)жȡпԸ֮
ûָʹ pkgname Ϊû

* лû( shell)ִӦĿ $HOME Ŀ¼
ָ˾·İͲ $HOMEϢʹĬϰ

* Դͨûӽ̣亯 __user_process() """
	global confile

	try:
		mo = re.match(pregexp, package)
		pkgname = mo.group('pkgname')
		version = mo.group('version')
	except AttributeError: 
	# ûƥ
		strerr = "%s: Not a valid argument, lack of package name or version" % program
		sys.stderr.write('%s\n' % strerr)
		sys.exit(1)

	# Read user/group name from profile !!! 
	uname = ''
	gname = ''
	gnames = ''
	if os.path.isfile(confile):
		try:
			config = open(confile, 'r')
			optmap = getconf(config, 'norm', 'user', 'group', 'groups')
			uname = optmap['user']
			gname = optmap['group']
			gnames = optmap['groups']
			config.close()
		except KeyError:
			pass

	if not user: 
		if uname: user = '%s' % uname 
		else: user = os.path.join(uprefix, pkgname)
	home = os.path.join(homepre, pkgname)
	# ʹ version Էע home  pkgname
	if not group:
		if gname: group = '%s' % gname
		else: group = user
	if not groups:
		if gnames: groups = gnames.split(',')

	try:
		exists = grp.getgrnam(admin)[2]
		admin_id = exists
	except KeyError:
		strerr = "%s: No admin group %s found" % (program, admin)
		sys.stderr.write("%s\n" % strerr)
		sys.exit(1)

	gids = []
	for g in groups:
		try:
	 		exists = grp.getgrnam(g)[2]
			gids.append(exists)
		except KeyError:
	 		# strerr = "%s: No group '%s' found" % (program, g)
	 		# sys.stderr.write("%s\n" % strerr)
			gids.append(shadow.groupadd(g, 'sysadm'))

	uid, gid = shadow.useradd(user, group, [admin] + groups, home)

	if not confile:
		confile = os.path.join(home, '.config')

	if not archive:
		config = open(confile, 'r')
		optmap = getconf(config, 'norm', 'archive')
		# ûҵĬΪָİ install е package ֵ
		archive = optmap.get('archive', archive)
		config.close()
		if not patches:
		# patches is optional
		# but the configuration must not overwrite command line parameters.
			config = open(confile, 'r')
			# ϴζȡ֮͵ļβҲˣҪ´һ
			# ȻⲻǺõĽרŵöȡģ
			optmap = getconf(config, 'seq', 'patch')
			patches = optmap.get('patch', patches)
			config.close()

	commands = []
	if autocmd:
		config = open(confile, 'r')
		optmap = getconf(config, 'seq', 'command')
		commands = optmap['command']
		config.close()

	pid = os.fork()
	if pid == 0:
		os.setregid(gid, gid)
		os.setgroups([gid, admin_id] + gids)
		# ȷ飬װʱִ /usr/bin/install 
		os.setreuid(uid, uid)
		os.chdir(home)
		__user_process(user, group, groups, pkgname, version, archive, patches, commands)
		#  __user_process() һ"ԭӲ"
		# __user_process() κδ󵽻ᵼԷ 0 ״̬˳
		sys.exit(0)
		# ˳֤ȷ˳״̬
	else:
		status = (not os.wait()[1])
		if status:
			filetools.push_list(pkglist, '%s-%s' % (pkgname, version))
		else:
			try:
				filetools.find_list(pkglist, '%s-%s' % (pkgname, version))
				# If the item could be found, it means that the package
				# 	have been installed successfully the previous time
			except "find_list_error":
				__remove_files(pkgname)
				os.remove('%s/.files' % home)
			# ɾʧܵ __user_process ϵͳвĲļ
			# Ա֤ԭ
			# Ǹǰװɾ
			# *** Ƕ install ͽֹǰװ upgrade ɣ ***
			sys.exit(1)
			#  crablfs ãҪ֪ʧܣֹ crablfs

def __user_process(user, group, groups, pkgname, version, archive, patches=[], commands=[]):
	"""ӽ̣
* ¼صİϢӦϢļ

* ϢӦðʱ

* Ӹðбļ pkglist

* һʽнִаװ¼Ϣļ

* ָͨʹϢļʹ÷ǽװģʽ

*** Ҫ__user_process() һ"ԭӲ" install() Ҳǣ
ζ pkglist ӱ __user_process ɹʱܽ
 install() ԭӲҪӦӵûɾʵ

* ΪﵽԭӲҪ __user_process κγ뵼¸()Է 0 ״̬˳"""
	home = '%s/%s' % (homepre, pkgname)
	# cmdline ܻ chdir .config д $HOM 棬Ҫõ home. 
	global confile
	if os.path.isfile(confile):
		confile = __get_copy(confile, '.config')
	#	'$HOME/.config' for example.
	# *** ж confile Чԣ***
	# ã optmap δգȻ׳ KeyError͹

	archive = os.path.join(PACKS_DIR, archive)
	archive = __get_copy(archive)
	for i in range(len(patches)):
		file = patches[i]
		file = os.path.join(PACKS_DIR, file)
		patches[i] = __get_copy(file)

	from crablfs.cmdline import cmdline
	instcli = cmdline()
	success = 1
	if not autocmd:
		instcli.cmdloop()
		success = instcli.success
		if not success:
			strerr = "%s: installation failed or terminated" % program
			print >> sys.stderr, strerr
			sys.exit(1)
	else:
		if not commands:
			strerr = "%s: No command found for noninteractive mode" % program
			print >> sys.stderr, strerr
			sys.exit(1)
		# *** When redirect output to log installation, How to print some infomations? *** 
		### fifo = '/tmp/crablfs.fifo'
		### if not os.path.exists(fifo): os.mkfifo(fifo)
		for cmd in commands:
			line = "[33mcrablfs> [32m%s[00m" % cmd
			print line
			### open(fifo, 'w').write("%s\n" % line)
			if not instcli.do_command(cmd):
				strerr = "%s: noninteractive execution failed" % program
				print >> sys.stderr, strerr
				success = 0
				sys.exit(1)
		### os.remove(fifo)

	# Writing profile must be after 'commit'
	config = open('%s/.config' % home, 'w')
	# 'cmdline' maybe chdirso specify 'home' here
	# *** Whether adding file lock is necessary? ***
	setconf(config, 'w', user=user, group=group, groups=','.join(groups), pkgname=pkgname, version=version, archive=archive)
	for patch in patches: setconf(config, 'a', patch=patch)
	# configuration path prefix !!!!!!
	for cmd in instcli.commands:
		setconf(config, 'a', command=cmd)
		# *** ˳ļα֣ ***
	setconf(config, 'a', time=time.strftime(timefmt, time.localtime()))
	config.close()

	__list_files(pkgname, record=1)
	# record all files to '$HOME/.files' for future manipulations
	print "[32minstallation success[00m"

def __get_copy(fsrc, rename=''):
	"""صǰĿ¼ÿ HOME Ŀ¼"""
	rtv = os.path.basename(fsrc)
	if (not os.path.exists(rtv)) or cpforce:
		from crablfs import filetrans
		fto = filetrans.build(remote=fsrc)
		fto.getfile(force=cpforce)
	if rename:
		shutil.move(rtv, rename)
		rtv = rename
	os.chmod(rtv, 0664)
	return rtv

def __remove_files(pkgname):
	allfiles = __list_files(pkgname)
	topfiles = __find_topdirs(allfiles)
	for file in topfiles:
		try:
			if os.path.isdir(file):
				shutil.rmtree(file)
			else:
				os.remove(file)
		except OSError, (errno, errstr):
			strerr = "%s: remove file faild: %d, %s" % (program, errno, errstr)
			sys.stderr.write("%s\n" % strerr)

def remove(pkgname, version):
	try:
		# try:
		home = os.path.join(homepre, pkgname)
		filetools.find_list(pkglist, '%s-%s' % (pkgname, version))
		filetools.pull_list(pkglist, '%s-%s' % (pkgname, version))
		# find_list() ִвѯԼһĿǷ
		# 粻ڻ׳쳣
		# finally:
		__remove_files(pkgname)
		os.remove('%s/.files' % home)
	except "find_list_error":
		strerr = "%s: No package %s found" % (program, package)
		print >> sys.stderr, strerr #
		sys.exit(1)
	except "pull_list_error":
		strerr = "%s: remove package item from list failed" % program
		print >> sys.stderr, strerr
		sys.exit(1)

def init(lists):
	"""ʼ install 鼰 install ҪĿ¼ install 鲢 write  sticky λ"""
	gid = shadow.groupadd(admin, 'sysadm')

	try:
		for dir in open(lists, 'r'):
			dir = dir.strip()
			if not os.access(dir, os.F_OK):
				os.makedirs(dir)	# mkdir -p <dir>
			os.lchown(dir, -1, gid)
			os.chmod(dir, 01775)	# chmod g+w,o+t <dir>
	except (IOError, OSError), strerr:
		sys.stderr.write('%s\n' % strerr)

def list_packs():
	"""геİ

ֻǵʹ userpack İôͨѯ install ûҲԵõеİб(ҪѯصϢļ)ǵ LFS (crablfs)ǨƵҪһʵڵıиĺô

 install 飬Ҫ install() ԭӲ"""
	try:
		for line in open(pkglist, 'r'):
			line = line.strip()
			print line
	except IOError, (errno, errstr):
		strerr = "%s: No packages list found: %d, %s" % (program, errno, errstr)
		sys.stderr.write("%s\n" % strerr)
		sys.exit(1)

def __list_files(pkgname, record=0):
	home = os.path.join(homepre, pkgname)
	tmpl = open(lists, 'r').readlines()
	tmpl.sort()
	# ҳеĶĿ¼Խб
	topdirs = __find_topdirs(tmpl)
	config = open('%s/.config' % home, 'r')
	optmap = getconf(config, 'norm', 'user', 'group')
	user = optmap['user']
	group = optmap['group']
	config.close()
	allFiles = []
	if os.path.isfile('%s/.files' % home) and not record:
		for file in open('%s/.files' % home, 'r'):
			allFiles.append(file.strip())
		return allFiles
	dotfiles = open('%s/.files' % home, 'w')
	for dir1 in topdirs:
		if not os.path.isdir(dir1):
			strerr = "[31m%s is not a valid directory[00m" % dir1
			sys.stderr.write("%s\n" % strerr)
			continue
		# for root, dirs, files in os.walk(dir1):
		FIND = "find %s -path %s -prune -o -user %s -a -print" \
			% (dir1, homepre, user)
		for file in os.popen(FIND):
			dotfiles.write("%s" % file)
			file = file.strip()
			allFiles.append(file)
	dotfiles.close()
	uid = pwd.getpwnam(user)[2]
	gid = grp.getgrnam(group)[2]
	os.lchown('%s/.files' % home, uid, gid)
	return allFiles

def list_files(pkgname, version, force=0):
	"""гĳеļĿ¼"""
	try:
		# if not version:
		#	config = open('%s/.config' % home)
		#	optmap = getconf(config, 'norm', 'version')
		#	version = optmap['version']
		#	config.close()
		filetools.find_list(pkglist, '%s-%s' % (pkgname, version))
		for file in __list_files(pkgname, force): print file
	except "find_list_error":
		strerr = "%s: No package %s found" % (program, package)
		print >> sys.stderr, strerr
		sys.exit(1)

def __find_topdirs(tmpl):
	topdirs = []
	dir1 = ''
	for item in tmpl:
		item = item.strip()
		if not os.path.exists(item):
			strerr = "%s: [31m%s is not a valid file or directory[00m" % (program, item)
			sys.stderr.write("%s\n" % strerr)
			continue
		if not dir1:
			if item == '': continue #
			dir1 = item; topdirs.append(dir1)
		elif dir1 in item:
			continue
		elif item in dir1:
			dir1 = item; topdirs[-1] = dir1
		else:
			dir1 = item; topdirs.append(dir1)
	return topdirs

def find_owner(fname):
	"""ҳĳļİ"""
	try:
		uid = os.stat(fname)[4]
		user = pwd.getpwuid(uid)[0]
		home = pwd.getpwuid(uid)[5]
		config = open('%s/.config' % home, 'r')
		optmap = getconf(config, 'norm', 'pkgname', 'version')
		pkgname = optmap['pkgname']
		version = optmap['version']
		config.close()
		print '%s-%s' % (pkgname, version)
		strerr = ''
	except OSError, (errno, errstr):
		strerr = "%s: %d, %s" % (fname, errno, errstr)
	except IOError:
		strerr = "No configuration file found: %s/.config" % home
		strerr = "This file may not be under the control of %s:\n\t%s" % (program, strerr)
	except KeyError, ostr:
		strerr = "No such configuration option: %s" % ostr
	if strerr:
		strerr = "%s: No package owner found:\n\t%s" % (program, strerr)
		sys.stderr.write("%s\n" % strerr)
		sys.exit(1)

def __parse_name(package):
	try:
		mo = re.match(pregexp, package)
		pkgname = mo.group('pkgname')
		version = mo.group('version')
		return pkgname, version
	except AttributeError:
		strerr = "%s: %s is an invalid package name" % (program, package)
		print >> sys.stderr, strerr
		sys.exit(1)

if __name__ == '__main__':
	program = os.path.basename(sys.argv[0])
	usage = """program usage: %s ACTION [OPTIONS] PACKAGE/FILENAME
	OPTIONS:
	-u $user, װʱָû
	-g $group, װʱָ
	-d|--home-prefix $homepre, аû HOME Ŀ¼ǰ׺Ŀ¼
	-s|--home-source $homesrc, ӵ crablfs HOME ͬĿ¼⹹ǰ׺Ŀ¼
	-f|--archive $archive, װʱָʵʵİĬ $homepre/$PACKAGE
	-p|--patch $patch [-p $patch2 ...], װʱָļĬ homepre/$PACKAGE
	-c|--profile $file, ָϢļ
	-o option=value, ı homepre ò
	-a|--autoʾĬϴ $HOME/.config ȡ(ִ)
	-h, ӡϢ
	-C|--copy-force, 鵵ļ򲹶Ѵڣ򸲸֮""" % program
	location = os.path.dirname(sys.argv[0])
	# os.chdir(location)
	usage_en = """program usage: %s ACTION [OPTIONS] PACKAGE/FILENAME
	OPTIONS:
	-u $user, specify user name while install
	-g $group, specify group name while install
	-G $groups, specify other groups the user belogs to
	-d|--home-prefix $homepre
		the prefix to the abs path of all package users' HOME
	-s|--home-source $homesrc
		the directory tree that has same struct as $homepre
	-f|--archive $archive
		.tar.bz2 or .tar.gz compressed source code archive
	-p|--patch $patch [-p $patch2 ...]
		any supplementary files for installation, such patches
	-c|--profile $file
		appoint the installation profile, usually for noninteractive mode
	-a|--auto, noninteractive mode
	-h, print this help message
	-C|--copy-force
		if the archive or patches exists, cover it up""" % program
	if os.environ['LANG'] not in ['zh', 'zh_CN', 
		'zh_CN.GB2312', 'zh_CN.GB18030', 'zh_CN.UTF-8', 'zh_CN.GBK']:
		usage = usage_en

	argv = sys.argv
	try:
		opts, args = getopt.gnu_getopt(argv[2:], 'u:g:G:d:s:f:p:c:o:ahC',
		[
			'home-prefix', 'home-source', 
			'archive', 'patch', 'confile',
			'auto', 'copy-force'
		])

		user = ''
		group = user
		groups = []
		package = ''
		archive = ''
		patches = []
		actions = [ 'install', 'reset', 'upgrade', 'remove', 'init', 'packs', 'files', 'info', 'owner', 'help' ]
		SHORTS = [ 'i', 'R', 'u', 'r', '0', 'a', 'l', 'L', 'I', 'o' ]
		# 'reset' means rebuild a package with new characterastics with new libraries dependencies
		homesrc = ''

		if len(argv) > 1 and (argv[1] in actions or argv[1] in SHORTS):
			action = argv[1]
		else:
			strerr = "Please clarify the action: %s" % ', '.join(actions)
			sys.stderr.write('%s\n' % strerr)
			print usage
			sys.exit(1)

		for o, v in opts:
			if o == '-u':	user = v
			elif o == '-g':	group = v
			elif o == '-G': groups = v.split(',')
			elif o == '-d' or o == '--home-prefix':
				if not autocmd:
					print "change home prefix may cause problems, contnue?(n/y)"
					if raw_input() != 'y': sys.exit(1)
				# At least a warning message is necessary!!!
				# *** Or move and change all things for user automatically??? ***
				homepre = v
				pkglist = '%s/packages.list' % homepre
			elif o == '-s' or o == '--home-source':
				homesrc = v
				# ϵͳǨƣζǰ˵ϵͳֱ
				# ȴϢ趨
				# Ӻ crablfs script
			elif o == '-f' or o == '--archive': #
				archive = os.path.abspath(v)
			elif o == '-p' or o == '--patch':
				patches.append(os.path.abspath(v))
			elif o == '-c' or o == '--profile':
				confile = os.path.abspath(v)
			elif o == '-o': #  plainconf ĺʵ(δʵ)
				try:
					option, value = re.split('\s*=\s*', v)
					# ʹ plainconf ģȡһ
					if option not in options:
						strerr = "%s is an invalid option, skip it." % option
						sys.stderr.write('%s\n' % strerr)
						# sys.exit(1)
					value = value.strip('"\'')
					# Make value support "" or '' quotation for some especial conditions
					exec "%s = '%s'" % (option, value)
				except ValueError, strerr:
					if strerr == "unpack list of wrong size":
						strerr = "Format error, must be: option=value, skip"
					sys.stderr.write('%s\n' % strerr)
			elif o == '-a' or o == '--auto':
				autocmd = True
			elif o == '-C' or '--copy-force':
				cpforce = True
			elif o == '-h':
				print usage
				sys.exit(0)

		try:
			package = args[0]
		except IndexError:
			if action in ['install', 'i']:
				if archive:
					package = os.path.basename(archive)
				else:
					strerr = "Can't get package name: pkgname-version"
					print >> sys.stderr, strerr
					sys.exit(1)
			elif action in ['upgrade', 'remove', 'files', 'u', 'r', 'l']:
				strerr = "Please give the package name: pkgname-version"
				print >> sys.stderr, strerr
				# print usage
				sys.exit(1)
			elif action in ['owner', 'o']:
				strerr = "No file name is given to find the package owner"
				print >> sys.stderr, strerr
				sys.exit(1)

		__init__()
		if action in ['install', 'i']:
			if homesrc:
				pkgname, version = __parse_name(package)
				temp = os.path.join(homesrc, pkgname)
				PACKS_DIR = os.path.abspath(temp)
				temp = os.path.join(PACKS_DIR, '.config')
				confile = os.path.abspath(temp)
			install(user, group, groups, package, archive, patches)
		elif action in ['init', '0']:
			init(lists)
		elif action in ['remove', 'r']:
			pkgname, version = __parse_name(package)
			remove(pkgname, version)
		elif action in ['packs', 'a']:
			list_packs()
		elif action in ['files', 'l', 'L']:
			pkgname, version = __parse_name(package)
			if action == 'L':
				list_files(pkgname, version, 1)
			else:
				list_files(pkgname, version)
		elif action in ['owner', 'o']:
			fname = package
			find_owner(fname)
			
	except getopt.GetoptError, goEx:
		strerr = 'getopt error: %s, %s' % (goEx.opt, goEx.msg)
		sys.stderr.write('%s\n' % strerr)
		sys.exit(1)
# 
