import os
import operator
import datetime

import pypyodbc as pyodbc
from xlwt import Workbook
import csv

import mytools
import mytools.mycmd

import csql

version = '0.9.6'
author = 'Frederic Aoustin'


def _getunicode(val):
    if val == None:
        return ''
    return unicode(val)

def optimizetable(table = None, optimize = False):
    tmp= []
    k,l = 0,0
    for k in range(0, len(table)):
        tmp2 = []
        for l in range(0,len(table[k])):
            try: 
                tmp2.append(str(_getunicode(table[k][l])).strip())
            except Exception as e: 
                #manage unicode on sqlserver
                tmp2.append("'".join(repr(table[k][l]).split("'")[1:-1]).strip())
        tmp.append(tmp2)
    return tmp

def _getlnblank(i,j):
    try: 
        st = _getunicode(j).strip() 
    except Exception as e: 
        st = "'".join(repr(j).split("'")[1:-1]).strip()
    return i - len(st)



class CmdSql(mytools.mycmd.Cmd):
    _default= '.csql.txt'
    _connect = None
    _cursor = None
    _str_no_return = "No return, No description"
    _str_connected = "You are connected"
    _str_no_connected = "You have not connected or connection not support action"
    _str_close = "you have closed the connection"
    _str_key_not_list = "%s is not keys of list"
    _title ='sql'
    _type = None
    autocommit = False
    intro = 'csql %s by %s' % (version, author)
    autorotate = True

    def  __init__(self, completekey='tab', stdin=None, stdout=None, rc='default'):
        self.color['description']=None
        self.color['connect_info']=None
        mytools.mycmd.Cmd.__init__(self, completekey, stdin, stdout, rc)
        self.do_set("title='%s'" % self._title)
        self._attr_not_print_conf.append('_connect')
        self._attr_not_print_conf.append('_cursor')
        self._attr_not_print_conf.append('_str_no_return')
        self._attr_not_print_conf.append('_str_connected')
        self._attr_not_print_conf.append('_str_no_connected')
        self._attr_not_print_conf.append('_str_close')
        self._attr_not_print_conf.append('_str_key_not_list')
        self._attr_not_print_conf.append('_type')
        self.help_set_txt['_title']='title of application'
        self.help_set_txt['_line_description']='line between description and sql result'
        self.help_set_txt['autocommit']='change mode commit connection True or False'
        self.help_set_txt['autorotate']='if one row as result, inverse columns row value True or False'
        self._last_result = None

    def _redirect_save(self, path_redirect, append):
        if path_redirect.split('.')[-1] == "csv":
            mode = append and 'a' or 'w'
            file = open(os.path.join(os.getcwd(),path_redirect), mode)
            try:
                writer = csv.writer(file)
                r=[]
                for k in self._last_result:
                    r=[]
                    for i in k:
                        r.append(i.rstrip())
                    writer.writerow(r)
            finally:
                file.close()
            pass
        elif path_redirect.split('.')[-1] == "xls":
            book = Workbook()
            feuil1 = book.add_sheet('query')
            j=0
            r=0
            for k in self._last_result:
                for i in k:
                    feuil1.write(r,j,i.rstrip())
                    j = j+1
                r=r+1
                j=0
                
            book.save(os.path.join(os.getcwd(),path_redirect))
        else:
            mytools.mycmd.Cmd._redirect_save(self, path_redirect, append)

    def _reset_result(self):
        mytools.mycmd.Cmd._reset_result(self)
        #for redirect
        self._last_result = None
        
    def do_set(self, arg):
        """manage attribut of console"""
        try:
            name = arg.split('=')[0]
            if name == 'autocommit':
                if self._connect != None and self._type == 'odbc':
                    exec('self._connect.autocommit = %s' % arg.split('=')[1])
                    exec('self.autocommit = %s' % arg.split('=')[1])
                else:
                    self.stdout.write(self._str_no_connected, self.color['error']) 
            else:
                mytools.mycmd.Cmd.do_set(self,arg)
        except Exception as e:
            self.stdout.write("format of set is name = value or name doesnt exist", self.color['error'])
            self.stdout.write(arg, self.color['error'])
        
        
    def do_connect(self, arg):
        """create connection with database"""
        arg = arg.split(' ')
        if arg[0] == '' and self._connect != None:
            t = self._connect.getinfo(pyodbc.SQL_DATA_SOURCE_NAME)
            t = t + ' / ' + self._connect.getinfo(pyodbc.SQL_DBMS_NAME)
            t = t + ' / ' + self._connect.getinfo(pyodbc.SQL_DATABASE_NAME)
            self.stdout.write(t, self.color['connect_info'])
            self.stdout.write('autocommit is %s' % self._connect.autocommit, self.color['connect_info'])
            return
        if self._connect != None:
            self.do_close('')
        try:
            if arg[0] == 'odbc':
                self._type = arg[0]
                self._connect = pyodbc.connect(' '.join(arg[1:]), unicode_results=True)
                self._cursor = self._connect.cursor()
                t = self._connect.getinfo(pyodbc.SQL_DATA_SOURCE_NAME)
                t = t + ' / ' + self._connect.getinfo(pyodbc.SQL_DBMS_NAME)
                t = t + ' / ' + self._connect.getinfo(pyodbc.SQL_DATABASE_NAME)
                self.do_set("autocommit=%s" % str(self.autocommit))
                self.do_set("title='%s'" % t)
                self.stdout.write(self._str_connected, self.color['connect_info'])
            else:
                self.stdout.write(self._str_no_connected, self.color['error']) 
        except Exception as e:
            self.stdout.write(str(e), self.color['error'])  
            self._connect = None
            self._cursor = None
    
    def do_close(self, arg):
        """close connection"""        
        if self._connect != None:
            try:
                if self.autocommit == True:
                    self._connect.commit()
                else:
                    self._connect.rollback()
                self._connect.close()
                self._connect = None
                self._cursor = None
                self.autocommit = False
                self.stdout.write(self._str_close, self.color['connect_info']) 
                self.do_set("title='%s'" % self._title)
            except Exception as e:
                self.stdout.write(str(e), self.color['error']) 
        else:
            self.stdout.write(self._str_no_connected, self.color['error']) 
    
    def do_bye(self, arg):
        """close connection and exit"""
        if self._connect != None:
            self.do_close(arg)
        mytools.mycmd.Cmd.do_bye(self, arg)
    
    def do_list(self, arg):  
        """information of database"""
        # http://code.google.com/p/pyodbc/wiki/Cursor
        arg = arg.split(' ')
        if arg[0] == 'connect':
            for i in self.alias:
                if 'connect ' in self.alias[i]:
                    self.stdout.write(str(i), self.color['console'])
        elif self._connect != None and self._type == 'odbc':
            try:
                if arg[0] == 'tables':
                    self._cursor.tables()
                    self.pp(self._cursor)
                elif arg[0] == 'columns':
                    self._cursor.columns(table=' '.join(arg[1:]))
                    self.pp(self._cursor, cfilter=[3,5,6,10])
                    self.stdout.write('\nInformation: 0: False, 1:True', self.color['console']) 
                elif arg[0] in ('statistics','index'):
                    self._cursor.statistics(table=' '.join(arg[1:]))
                    self.pp(self._cursor, cfilter=[2,3,5,7,8])
                    self.stdout.write('\nInformation: 0: False, 1:True', self.color['console']) 
                elif arg[0] == 'primaryKeys':
                    self._cursor.primaryKeys(table=' '.join(arg[1:]))
                    self.pp(self._cursor)
                elif arg[0] == 'foreignKeys':
                    self._cursor.foreignKeys(table=' '.join(arg[1:]))
                    self.pp(self._cursor)
                elif arg[0] == 'procedures':
                    self._cursor.procedures()
                    self.pp(self._cursor)
                else:
                    self.stdout.write(self._str_key_not_list % arg[0], self.color['error']) 
            except Exception as e:
                self.stdout.write(str(e), self.color['error'])   
        else:
            self.stdout.write(self._str_no_connected, self.color['error']) 
    
    def help_list(self):
        str = """information of database: 
- tables
- columns <table>
- statistics <table>
- index <table>
- primaryKeys <table>
- foreignKeys <table>
- procedures

information connection
- connect"""
        self.stdout.write(str, self.color['console']) 
        
    def do_desc(self, arg):
        """describe table"""
        arg2 = 'columns ' + arg
        self.do_list(arg2)
    
    def do_commit(self, arg):
        """commit database"""
        if self._connect != None:
            self._connect.commit()
        else:
            self.stdout.write(self._str_no_connected, self.color['error']) 
    
    def do_rollback(self, arg):
        """rollback to last commit"""
        if self._connect != None:
            self._connect.rollback()
        else:
            self.stdout.write(self._str_no_connected, self.color['error']) 
    
    def default(self, line):
        if self.treat_alias(line) == False:
            if self._connect != None:
                try:
                    for i in line.split(';\n'):
                        n = datetime.datetime.now()
                        self._cursor.execute(i)
                        m = datetime.datetime.now()
                        self.pp(self._cursor, delta = m-n) 
                except Exception as e:
                    self._last_result=[]
                    for i in e:
                        self._last_result.append(i)
                        self.stdout.write(str(i), self.color['error'])                 
            else:
                self.stdout.write(self._unknowsyntax % line, self.color['error'])
   
    def ppttable(self, table = None, sep1='|', sep2='+' ,sep3='='):  
        #manage filter
        if len(self.stdout.str_filter) > 0:
            str_filter = self.stdout.str_filter
            self.stdout.str_filter = ''
        else:
            str_filter = ''
        tmp = [table[0],]    
        for line in table[1:]:
            if len(str_filter) > 0:
                for i in range(0,len(line)):
                    if _getunicode(line[i]).find(str_filter) != -1:
                        tmp.append(line)
            else:
                tmp.append(line)
        table = tmp
        promptblanck = ' ' * len(self.prompt)
        #manage autorotate
        if self.autorotate and len(table) == 2:
            table = zip(*table)
            table = [['columns','value'],] + table
        ttable = optimizetable(table) 
        ln = [max(len(str(x)) for x in line) for line in zip(*ttable)]
        h = promptblanck + sep2+ sep2.join([(sep3 * ln[i]) for i in range(0,len(ln))]) + sep2
        self.stdout.write(h, self.color['description'])
        self.stdout.cprint(self.color['description'], None, promptblanck + sep1)
        for i in range(0,len(ln)):
            self.stdout.cprint(self.color['description'], None, ttable[0][i])
            self.stdout.cprint(self.color['description'], None, ' ' * _getlnblank(ln[i], ttable[0][i]))
            self.stdout.cprint(self.color['description'], None, sep1)
        self.stdout.cprint(self.color['description'], None, '\n')
        self.stdout.write(h, self.color['description'])
        table = ttable[1:]
        for line in table:
            self.stdout.cprint(self.color['description'], None, promptblanck + sep1)
            for i in range(0,len(ln)):
                self.stdout.cprint(self.color['console'], None, _getunicode(line[i]).strip())
                self.stdout.cprint(self.color['console'], None, ' ' * _getlnblank(ln[i], line[i]))
                self.stdout.cprint(self.color['description'], None, sep1)
            self.stdout.cprint(self.color['console'], None, '\n')             
        self.stdout.write(h, self.color['description'])
        return ttable


    def pp(self, cursor, cfilter = [-1], delta = "00:00:00.000"):
        try:
            impact_row = 0
            if self._cursor.description != None:
                rows = cursor.fetchall()
                rows.insert(0,[i[0] for i in cursor.description])
                impact_row = len(rows) - 1
            else:
                rows = [['Result'],['Ok']]
                impact_row = cursor.rowcount
        except Exception as e:
            rows=[['ERROR']]
            for i in e:
                for k in str(i).split('\n'):
                    rows.append([str(k)])

        if -1 not in cfilter:
            table = []
            for i in rows:
                l = []
                for k in cfilter:
                    l.append(i[k])
                table.append(l)
        else:
            table = rows
        self._last_result = self.ppttable(table) 
        promptblanck = ' ' * len(self.prompt)
        self.stdout.write('', self.color['console'])
        self.stdout.write(promptblanck + 'TIMER                   : ' + str(delta), self.color['console'])
        self.stdout.write(promptblanck + 'ROW UPDATED OR SELECTED : ' + str(impact_row), self.color['console'])
        return None
        
    do_exit = do_bye


   
def load():
    cm = CmdSql(stdout=mytools.mycmd.OutColor())
    cm.cmdloop()
