"""helper for getting properly formatted ast from arbitrary python object"""
import ast
import inspect
import textwrap


def get_ast(obj):
    """
    Return the Python ast for the given object, which may
    be anything that inspect.getsource accepts (incl.
    a module, class, method, function, traceback, frame,
    or code object).
    """
    indented_program_txt = inspect.getsource(obj)
    program_txt = textwrap.dedent(indented_program_txt)
    return ast.parse(program_txt)
