# -*- coding: utf-8 -*-
# copyright 2013 LOGILAB S.A. (Paris, FRANCE), all rights reserved.
# copyright 2013 CEA (Saclay, FRANCE), all rights reserved.
# contact http://www.logilab.fr -- mailto:contact@logilab.fr
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU Lesser General Public License as published by the Free
# Software Foundation, either version 2.1 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
# details.
#
# You should have received a copy of the GNU Lesser General Public License along
# with this program. If not, see <http://www.gnu.org/licenses/>.

"""cubicweb-brainomics postcreate script, executed at instance creation time or when
the cube is added to an existing instance.

You could setup site properties or a workflow here for example.
"""

set_property('ui.site-title', 'Brainomics')

# Create cards
create_entity('Card', content_format=u'text/html', title=u'index', wikiid=u'index',
              content=u"""The BRAINOMICS project is one of the projects chosen by the Agence nationale de la recherche (ANR) in the bioinformatics call of the Investissements d'avenir program.""")

# Standard scores
ecog = session.create_entity('ScoreDefinition', type=u'both', name=u'ECOG')
lansky = session.create_entity('ScoreDefinition', type=u'both', name=u'Lansky')
karnofsky = session.create_entity('ScoreDefinition', type=u'both', name=u'Karnofsky')
