"""some utilities to define forge schema permissions

:organization: Logilab
:copyright: 2008 LOGILAB S.A. (Paris, FRANCE), all rights reserved.
:contact: http://www.logilab.fr/ -- mailto:contact@logilab.fr
"""
__docformat__ = "restructuredtext en"

from rql.utils import quote
from cubicweb.schema import ERQLExpression, RRQLExpression

def _perm(names):
    if isinstance(names, (list, tuple)):
        if len(names) == 1:
            names = quote(names[0])
        else:
            names = 'IN (%s)' % (','.join(quote(name) for name in names))
    else:
        names = quote(names)
    #return u' require_permission P, P name %s, U in_group G, P require_group G' % names
    return u' require_permission P, P name %s, U has_group_permission P' % names


def xperm(*names):
    return 'X' + _perm(names)

def xexpr(*names):
    return ERQLExpression(xperm(*names))

def xrexpr(relation, *names):
    return ERQLExpression('X %s Y, Y %s' % (relation, _perm(names)))

def xorexpr(relation, etype, *names):
    return ERQLExpression('Y %s X, X is %s, Y %s' % (relation, etype, _perm(names)))


def sexpr(*names):
    return RRQLExpression('S' + _perm(names), 'S')

def restricted_sexpr(restriction, *names):
    rql = '%s, %s' % (restriction, 'S' + _perm(names))
    return RRQLExpression(rql, 'S')

def restricted_oexpr(restriction, *names):
    rql = '%s, %s' % (restriction, 'O' + _perm(names))
    return RRQLExpression(rql, 'O')

def oexpr(*names):
    return RRQLExpression('O' + _perm(names), 'O')


# def supdate_perm():
#     return RRQLExpression('U has_update_permission S', 'S')

# def oupdate_perm():
#     return RRQLExpression('U has_update_permission O', 'O')
