/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.0b2_r947
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
(function(G){var q;G.fn.emptyForce=function(){for(var aa=0,ab;(ab=G(this)[aa])!=null;aa++){if(ab.nodeType===1){jQuery.cleanData(ab.getElementsByTagName("*"))}if(G.jqplot_use_excanvas){ab.outerHTML=""}else{while(ab.firstChild){ab.removeChild(ab.firstChild)}}ab=null}return G(this)};G.fn.removeChildForce=function(aa){while(aa.firstChild){this.removeChildForce(aa.firstChild);aa.removeChild(aa.firstChild)}};G.jqplot=function(ag,ad,ab){var ac,aa;if(ab==null){if(jQuery.isArray(ad)){ac=ad;aa=null}else{if(typeof(ad)==="object"){ac=null;aa=ad}}}else{ac=ad;aa=ab}var af=new M();G("#"+ag).removeClass("jqplot-error");if(G.jqplot.config.catchErrors){try{af.init(ag,ac,aa);af.draw();af.themeEngine.init.call(af);return af}catch(ae){var ah=G.jqplot.config.errorMessage||ae.message;G("#"+ag).append('<div class="jqplot-error-message">'+ah+"</div>");G("#"+ag).addClass("jqplot-error");document.getElementById(ag).style.background=G.jqplot.config.errorBackground;document.getElementById(ag).style.border=G.jqplot.config.errorBorder;document.getElementById(ag).style.fontFamily=G.jqplot.config.errorFontFamily;document.getElementById(ag).style.fontSize=G.jqplot.config.errorFontSize;document.getElementById(ag).style.fontStyle=G.jqplot.config.errorFontStyle;document.getElementById(ag).style.fontWeight=G.jqplot.config.errorFontWeight}}else{af.init(ag,ac,aa);af.draw();af.themeEngine.init.call(af);return af}};G.jqplot.version="1.0.0b2_r947";G.jqplot.CanvasManager=function(){if(typeof G.jqplot.CanvasManager.canvases=="undefined"){G.jqplot.CanvasManager.canvases=[];G.jqplot.CanvasManager.free=[]}var aa=[];this.getCanvas=function(){var ad;var ac=true;if(!G.jqplot.use_excanvas){for(var ae=0,ab=G.jqplot.CanvasManager.canvases.length;ae<ab;ae++){if(G.jqplot.CanvasManager.free[ae]===true){ac=false;ad=G.jqplot.CanvasManager.canvases[ae];G.jqplot.CanvasManager.free[ae]=false;aa.push(ae);break}}}if(ac){ad=document.createElement("canvas");aa.push(G.jqplot.CanvasManager.canvases.length);G.jqplot.CanvasManager.canvases.push(ad);G.jqplot.CanvasManager.free.push(false)}return ad};this.initCanvas=function(ab){if(G.jqplot.use_excanvas){return window.G_vmlCanvasManager.initElement(ab)}return ab};this.freeAllCanvases=function(){for(var ac=0,ab=aa.length;ac<ab;ac++){this.freeCanvas(aa[ac])}aa=[]};this.freeCanvas=function(ab){if(G.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==q){window.G_vmlCanvasManager.uninitElement(G.jqplot.CanvasManager.canvases[ab]);G.jqplot.CanvasManager.canvases[ab]=null}else{var ac=G.jqplot.CanvasManager.canvases[ab];ac.getContext("2d").clearRect(0,0,ac.width,ac.height);G(ac).unbind().removeAttr("class").removeAttr("style");G(ac).css({left:"",top:"",position:""});ac.width=0;ac.height=0;G.jqplot.CanvasManager.free[ab]=true}}};G.jqplot.log=function(){if(window.console){window.console.log.apply(window.console,arguments)}};G.jqplot.config={enablePlugins:false,defaultHeight:300,defaultWidth:400,UTCAdjust:false,timezoneOffset:new Date(new Date().getTimezoneOffset()*60000),errorMessage:"",errorBackground:"",errorBorder:"",errorFontFamily:"",errorFontSize:"",errorFontStyle:"",errorFontWeight:"",catchErrors:false,defaultTickFormatString:"%.1f",defaultColors:["#4bb2c5","#EAA228","#c5b47f","#579575","#839557","#958c12","#953579","#4b5de4","#d8b83f","#ff5800","#0085cc","#c747a3","#cddf54","#FBD178","#26B4E3","#bd70c7"],defaultNegativeColors:["#498991","#C08840","#9F9274","#546D61","#646C4A","#6F6621","#6E3F5F","#4F64B0","#A89050","#C45923","#187399","#945381","#959E5C","#C7AF7B","#478396","#907294"],dashLength:4,gapLength:4,dotGapLength:2.5,srcLocation:"jqplot/src/",pluginLocation:"jqplot/src/plugins/"};G.jqplot.arrayMax=function(aa){return Math.max.apply(Math,aa)};G.jqplot.arrayMin=function(aa){return Math.min.apply(Math,aa)};G.jqplot.enablePlugins=G.jqplot.config.enablePlugins;G.jqplot.support_canvas=function(){if(typeof G.jqplot.support_canvas.result=="undefined"){G.jqplot.support_canvas.result=!!document.createElement("canvas").getContext}return G.jqplot.support_canvas.result};G.jqplot.support_canvas_text=function(){if(typeof G.jqplot.support_canvas_text.result=="undefined"){if(window.G_vmlCanvasManager!==q&&window.G_vmlCanvasManager._version>887){G.jqplot.support_canvas_text.result=true}else{G.jqplot.support_canvas_text.result=!!(document.createElement("canvas").getContext&&typeof document.createElement("canvas").getContext("2d").fillText=="function")}}return G.jqplot.support_canvas_text.result};G.jqplot.use_excanvas=(G.browser.msie&&!G.jqplot.support_canvas())?true:false;G.jqplot.preInitHooks=[];G.jqplot.postInitHooks=[];G.jqplot.preParseOptionsHooks=[];G.jqplot.postParseOptionsHooks=[];G.jqplot.preDrawHooks=[];G.jqplot.postDrawHooks=[];G.jqplot.preDrawSeriesHooks=[];G.jqplot.postDrawSeriesHooks=[];G.jqplot.preDrawLegendHooks=[];G.jqplot.addLegendRowHooks=[];G.jqplot.preSeriesInitHooks=[];G.jqplot.postSeriesInitHooks=[];G.jqplot.preParseSeriesOptionsHooks=[];G.jqplot.postParseSeriesOptionsHooks=[];G.jqplot.eventListenerHooks=[];G.jqplot.preDrawSeriesShadowHooks=[];G.jqplot.postDrawSeriesShadowHooks=[];G.jqplot.ElemContainer=function(){this._elem;this._plotWidth;this._plotHeight;this._plotDimensions={height:null,width:null}};G.jqplot.ElemContainer.prototype.createElement=function(ad,af,ab,ac,ag){this._offsets=af;var aa=ab||"jqplot";var ae=document.createElement(ad);this._elem=G(ae);this._elem.addClass(aa);this._elem.css(ac);this._elem.attr(ag);ae=null;return this._elem};G.jqplot.ElemContainer.prototype.getWidth=function(){if(this._elem){return this._elem.outerWidth(true)}else{return null}};G.jqplot.ElemContainer.prototype.getHeight=function(){if(this._elem){return this._elem.outerHeight(true)}else{return null}};G.jqplot.ElemContainer.prototype.getPosition=function(){if(this._elem){return this._elem.position()}else{return{top:null,left:null,bottom:null,right:null}}};G.jqplot.ElemContainer.prototype.getTop=function(){return this.getPosition().top};G.jqplot.ElemContainer.prototype.getLeft=function(){return this.getPosition().left};G.jqplot.ElemContainer.prototype.getBottom=function(){return this._elem.css("bottom")};G.jqplot.ElemContainer.prototype.getRight=function(){return this._elem.css("right")};function r(aa){G.jqplot.ElemContainer.call(this);this.name=aa;this._series=[];this.show=false;this.tickRenderer=G.jqplot.AxisTickRenderer;this.tickOptions={};this.labelRenderer=G.jqplot.AxisLabelRenderer;this.labelOptions={};this.label=null;this.showLabel=true;this.min=null;this.max=null;this.autoscale=false;this.pad=1.2;this.padMax=null;this.padMin=null;this.ticks=[];this.numberTicks;this.tickInterval;this.renderer=G.jqplot.LinearAxisRenderer;this.rendererOptions={};this.showTicks=true;this.showTickMarks=true;this.showMinorTicks=true;this.drawMajorGridlines=true;this.drawMinorGridlines=false;this.drawMajorTickMarks=true;this.drawMinorTickMarks=true;this.useSeriesColor=false;this.borderWidth=null;this.borderColor=null;this._dataBounds={min:null,max:null};this._intervalStats=[];this._offsets={min:null,max:null};this._ticks=[];this._label=null;this.syncTicks=null;this.tickSpacing=75;this._min=null;this._max=null;this._tickInterval=null;this._numberTicks=null;this.__ticks=null;this._options={}}r.prototype=new G.jqplot.ElemContainer();r.prototype.constructor=r;r.prototype.init=function(){this.renderer=new this.renderer();this.tickOptions.axis=this.name;if(this.tickOptions.showMark==null){this.tickOptions.showMark=this.showTicks}if(this.tickOptions.showMark==null){this.tickOptions.showMark=this.showTickMarks}if(this.tickOptions.showLabel==null){this.tickOptions.showLabel=this.showTicks}if(this.label==null||this.label==""){this.showLabel=false}else{this.labelOptions.label=this.label}if(this.showLabel==false){this.labelOptions.show=false}if(this.pad==0){this.pad=1}if(this.padMax==0){this.padMax=1}if(this.padMin==0){this.padMin=1}if(this.padMax==null){this.padMax=(this.pad-1)/2+1}if(this.padMin==null){this.padMin=(this.pad-1)/2+1}this.pad=this.padMax+this.padMin-1;if(this.min!=null||this.max!=null){this.autoscale=false}if(this.syncTicks==null&&this.name.indexOf("y")>-1){this.syncTicks=true}else{if(this.syncTicks==null){this.syncTicks=false}}this.renderer.init.call(this,this.rendererOptions)};r.prototype.draw=function(aa,ab){if(this.__ticks){this.__ticks=null}return this.renderer.draw.call(this,aa,ab)};r.prototype.set=function(){this.renderer.set.call(this)};r.prototype.pack=function(ab,aa){if(this.show){this.renderer.pack.call(this,ab,aa)}if(this._min==null){this._min=this.min;this._max=this.max;this._tickInterval=this.tickInterval;this._numberTicks=this.numberTicks;this.__ticks=this._ticks}};r.prototype.reset=function(){this.renderer.reset.call(this)};r.prototype.resetScale=function(aa){G.extend(true,this,{min:null,max:null,numberTicks:null,tickInterval:null,_ticks:[],ticks:[]},aa);this.resetDataBounds()};r.prototype.resetDataBounds=function(){var ah=this._dataBounds;ah.min=null;ah.max=null;var ab,ai,af;var ac=(this.show)?true:false;for(var ae=0;ae<this._series.length;ae++){ai=this._series[ae];af=ai._plotData;if(ai._type==="line"&&ai.renderer.bands.show&&this.name.charAt(0)!=="x"){af=[[0,ai.renderer.bands._min],[1,ai.renderer.bands._max]]}var aa=1,ag=1;if(ai._type!=null&&ai._type=="ohlc"){aa=3;ag=2}for(var ad=0,ab=af.length;ad<ab;ad++){if(this.name=="xaxis"||this.name=="x2axis"){if((af[ad][0]!=null&&af[ad][0]<ah.min)||ah.min==null){ah.min=af[ad][0]}if((af[ad][0]!=null&&af[ad][0]>ah.max)||ah.max==null){ah.max=af[ad][0]}}else{if((af[ad][aa]!=null&&af[ad][aa]<ah.min)||ah.min==null){ah.min=af[ad][aa]}if((af[ad][ag]!=null&&af[ad][ag]>ah.max)||ah.max==null){ah.max=af[ad][ag]}}}if(ac&&ai.renderer.constructor!==G.jqplot.BarRenderer){ac=false}else{if(ac&&this._options.hasOwnProperty("forceTickAt0")&&this._options.forceTickAt0==false){ac=false}else{if(ac&&ai.renderer.constructor===G.jqplot.BarRenderer){if(ai.barDirection=="vertical"&&this.name!="xaxis"&&this.name!="x2axis"){if(this._options.pad!=null||this._options.padMin!=null){ac=false}}else{if(ai.barDirection=="horizontal"&&(this.name=="xaxis"||this.name=="x2axis")){if(this._options.pad!=null||this._options.padMin!=null){ac=false}}}}}}}if(ac&&this.renderer.constructor===G.jqplot.LinearAxisRenderer&&ah.min>=0){this.padMin=1;this.forceTickAt0=true}};function m(aa){G.jqplot.ElemContainer.call(this);this.show=false;this.location="ne";this.labels=[];this.showLabels=true;this.showSwatches=true;this.placement="insideGrid";this.xoffset=0;this.yoffset=0;this.border;this.background;this.textColor;this.fontFamily;this.fontSize;this.rowSpacing="0.5em";this.renderer=G.jqplot.TableLegendRenderer;this.rendererOptions={};this.preDraw=false;this.marginTop=null;this.marginRight=null;this.marginBottom=null;this.marginLeft=null;this.escapeHtml=false;this._series=[];G.extend(true,this,aa)}m.prototype=new G.jqplot.ElemContainer();m.prototype.constructor=m;m.prototype.setOptions=function(aa){G.extend(true,this,aa);if(this.placement=="inside"){this.placement="insideGrid"}if(this.xoffset>0){if(this.placement=="insideGrid"){switch(this.location){case"nw":case"w":case"sw":if(this.marginLeft==null){this.marginLeft=this.xoffset+"px"}this.marginRight="0px";break;case"ne":case"e":case"se":default:if(this.marginRight==null){this.marginRight=this.xoffset+"px"}this.marginLeft="0px";break}}else{if(this.placement=="outside"){switch(this.location){case"nw":case"w":case"sw":if(this.marginRight==null){this.marginRight=this.xoffset+"px"}this.marginLeft="0px";break;case"ne":case"e":case"se":default:if(this.marginLeft==null){this.marginLeft=this.xoffset+"px"}this.marginRight="0px";break}}}this.xoffset=0}if(this.yoffset>0){if(this.placement=="outside"){switch(this.location){case"sw":case"s":case"se":if(this.marginTop==null){this.marginTop=this.yoffset+"px"}this.marginBottom="0px";break;case"ne":case"n":case"nw":default:if(this.marginBottom==null){this.marginBottom=this.yoffset+"px"}this.marginTop="0px";break}}else{if(this.placement=="insideGrid"){switch(this.location){case"sw":case"s":case"se":if(this.marginBottom==null){this.marginBottom=this.yoffset+"px"}this.marginTop="0px";break;case"ne":case"n":case"nw":default:if(this.marginTop==null){this.marginTop=this.yoffset+"px"}this.marginBottom="0px";break}}}this.yoffset=0}};m.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};m.prototype.draw=function(ab){for(var aa=0;aa<G.jqplot.preDrawLegendHooks.length;aa++){G.jqplot.preDrawLegendHooks[aa].call(this,ab)}return this.renderer.draw.call(this,ab)};m.prototype.pack=function(aa){this.renderer.pack.call(this,aa)};function t(aa){G.jqplot.ElemContainer.call(this);this.text=aa;this.show=true;this.fontFamily;this.fontSize;this.textAlign;this.textColor;this.renderer=G.jqplot.DivTitleRenderer;this.rendererOptions={};this.escapeHtml=false}t.prototype=new G.jqplot.ElemContainer();t.prototype.constructor=t;t.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};t.prototype.draw=function(aa){return this.renderer.draw.call(this,aa)};t.prototype.pack=function(){this.renderer.pack.call(this)};function N(){G.jqplot.ElemContainer.call(this);this.show=true;this.xaxis="xaxis";this._xaxis;this.yaxis="yaxis";this._yaxis;this.gridBorderWidth=2;this.renderer=G.jqplot.LineRenderer;this.rendererOptions={};this.data=[];this.gridData=[];this.label="";this.showLabel=true;this.color;this.negativeColor;this.lineWidth=2.5;this.lineJoin="round";this.lineCap="round";this.linePattern="solid";this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.25;this.shadowDepth=3;this.shadowAlpha="0.1";this.breakOnNull=false;this.markerRenderer=G.jqplot.MarkerRenderer;this.markerOptions={};this.showLine=true;this.showMarker=true;this.index;this.fill=false;this.fillColor;this.fillAlpha;this.fillAndStroke=false;this.disableStack=false;this._stack=false;this.neighborThreshold=4;this.fillToZero=false;this.fillToValue=0;this.fillAxis="y";this.useNegativeColors=true;this._stackData=[];this._plotData=[];this._plotValues={x:[],y:[]};this._intervals={x:{},y:{}};this._prevPlotData=[];this._prevGridData=[];this._stackAxis="y";this._primaryAxis="_xaxis";this.canvas=new G.jqplot.GenericCanvas();this.shadowCanvas=new G.jqplot.GenericCanvas();this.plugins={};this._sumy=0;this._sumx=0;this._type=""}N.prototype=new G.jqplot.ElemContainer();N.prototype.constructor=N;N.prototype.init=function(ac,ag,ae){this.index=ac;this.gridBorderWidth=ag;var af=this.data;var ab=[],ad;for(ad=0;ad<af.length;ad++){if(!this.breakOnNull){if(af[ad]==null||af[ad][0]==null||af[ad][1]==null){continue}else{ab.push(af[ad])}}else{ab.push(af[ad])}}this.data=ab;if(!this.color&&this.show){this.color=ae.colorGenerator.get(this.index)}if(!this.negativeColor&&this.show){this.negativeColor=ae.negativeColorGenerator.get(this.index)}if(!this.fillColor){this.fillColor=this.color}if(this.fillAlpha){var aa=G.jqplot.normalize2rgb(this.fillColor);var aa=G.jqplot.getColorComponents(aa);this.fillColor="rgba("+aa[0]+","+aa[1]+","+aa[2]+","+this.fillAlpha+")"}this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions,ae);this.markerRenderer=new this.markerRenderer();if(!this.markerOptions.color){this.markerOptions.color=this.color}if(this.markerOptions.show==null){this.markerOptions.show=this.showMarker}this.showMarker=this.markerOptions.show;this.markerRenderer.init(this.markerOptions)};N.prototype.draw=function(ag,ad,af){var ab=(ad==q)?{}:ad;ag=(ag==q)?this.canvas._ctx:ag;var aa,ae,ac;for(aa=0;aa<G.jqplot.preDrawSeriesHooks.length;aa++){G.jqplot.preDrawSeriesHooks[aa].call(this,ag,ab)}if(this.show){this.renderer.setGridData.call(this,af);if(!ab.preventJqPlotSeriesDrawTrigger){G(ag.canvas).trigger("jqplotSeriesDraw",[this.data,this.gridData])}ae=[];if(ab.data){ae=ab.data}else{if(!this._stack){ae=this.data}else{ae=this._plotData}}ac=ab.gridData||this.renderer.makeGridData.call(this,ae,af);if(this._type==="line"&&this.renderer.smooth&&this.renderer._smoothedData.length){ac=this.renderer._smoothedData}this.renderer.draw.call(this,ag,ac,ab,af)}for(aa=0;aa<G.jqplot.postDrawSeriesHooks.length;aa++){G.jqplot.postDrawSeriesHooks[aa].call(this,ag,ab)}ag=ad=af=aa=ae=ac=null};N.prototype.drawShadow=function(ag,ad,af){var ab=(ad==q)?{}:ad;ag=(ag==q)?this.shadowCanvas._ctx:ag;var aa,ae,ac;for(aa=0;aa<G.jqplot.preDrawSeriesShadowHooks.length;aa++){G.jqplot.preDrawSeriesShadowHooks[aa].call(this,ag,ab)}if(this.shadow){this.renderer.setGridData.call(this,af);ae=[];if(ab.data){ae=ab.data}else{if(!this._stack){ae=this.data}else{ae=this._plotData}}ac=ab.gridData||this.renderer.makeGridData.call(this,ae,af);this.renderer.drawShadow.call(this,ag,ac,ab)}for(aa=0;aa<G.jqplot.postDrawSeriesShadowHooks.length;aa++){G.jqplot.postDrawSeriesShadowHooks[aa].call(this,ag,ab)}ag=ad=af=aa=ae=ac=null};N.prototype.toggleDisplay=function(ab){var aa,ac;if(ab.data.series){aa=ab.data.series}else{aa=this}if(ab.data.speed){ac=ab.data.speed}if(ac){if(aa.canvas._elem.is(":hidden")){aa.canvas._elem.removeClass("jqplot-series-hidden");if(aa.shadowCanvas._elem){aa.shadowCanvas._elem.fadeIn(ac)}aa.canvas._elem.fadeIn(ac);aa.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+aa.index).fadeIn(ac)}else{aa.canvas._elem.addClass("jqplot-series-hidden");if(aa.shadowCanvas._elem){aa.shadowCanvas._elem.fadeOut(ac)}aa.canvas._elem.fadeOut(ac);aa.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+aa.index).fadeOut(ac)}}else{if(aa.canvas._elem.is(":hidden")){aa.canvas._elem.removeClass("jqplot-series-hidden");if(aa.shadowCanvas._elem){aa.shadowCanvas._elem.show()}aa.canvas._elem.show();aa.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+aa.index).show()}else{aa.canvas._elem.addClass("jqplot-series-hidden");if(aa.shadowCanvas._elem){aa.shadowCanvas._elem.hide()}aa.canvas._elem.hide();aa.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+aa.index).hide()}}};function H(){G.jqplot.ElemContainer.call(this);this.drawGridlines=true;this.gridLineColor="#cccccc";this.gridLineWidth=1;this.background="#fffdf6";this.borderColor="#999999";this.borderWidth=2;this.drawBorder=true;this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.5;this.shadowWidth=3;this.shadowDepth=3;this.shadowColor=null;this.shadowAlpha="0.07";this._left;this._top;this._right;this._bottom;this._width;this._height;this._axes=[];this.renderer=G.jqplot.CanvasGridRenderer;this.rendererOptions={};this._offsets={top:null,bottom:null,left:null,right:null}}H.prototype=new G.jqplot.ElemContainer();H.prototype.constructor=H;H.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};H.prototype.createElement=function(aa,ab){this._offsets=aa;return this.renderer.createElement.call(this,ab)};H.prototype.draw=function(){this.renderer.draw.call(this)};G.jqplot.GenericCanvas=function(){G.jqplot.ElemContainer.call(this);this._ctx};G.jqplot.GenericCanvas.prototype=new G.jqplot.ElemContainer();G.jqplot.GenericCanvas.prototype.constructor=G.jqplot.GenericCanvas;G.jqplot.GenericCanvas.prototype.createElement=function(ae,ac,ab,af){this._offsets=ae;var aa="jqplot";if(ac!=q){aa=ac}var ad;ad=af.canvasManager.getCanvas();if(ab!=null){this._plotDimensions=ab}ad.width=this._plotDimensions.width-this._offsets.left-this._offsets.right;ad.height=this._plotDimensions.height-this._offsets.top-this._offsets.bottom;this._elem=G(ad);this._elem.css({position:"absolute",left:this._offsets.left,top:this._offsets.top});this._elem.addClass(aa);ad=af.canvasManager.initCanvas(ad);ad=null;return this._elem};G.jqplot.GenericCanvas.prototype.setContext=function(){this._ctx=this._elem.get(0).getContext("2d");return this._ctx};G.jqplot.GenericCanvas.prototype.resetCanvas=function(){if(this._elem){if(G.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==q){window.G_vmlCanvasManager.uninitElement(this._elem.get(0))}this._elem.emptyForce()}this._ctx=null};G.jqplot.HooksManager=function(){this.hooks=[]};G.jqplot.HooksManager.prototype.addOnce=function(ab){var ac=false,aa;for(aa=0;aa<this.hooks.length;aa++){if(this.hooks[aa][0]==ab){ac=true}}if(!ac){this.hooks.push(ab)}};G.jqplot.HooksManager.prototype.add=function(aa){this.hooks.push(aa)};G.jqplot.EventListenerManager=function(){this.hooks=[]};G.jqplot.EventListenerManager.prototype.addOnce=function(ad,ac){var ae=false,ab,aa;for(aa=0;aa<this.hooks.length;aa++){ab=this.hooks[aa];if(ab[0]==ad&&ab[1]==ac){ae=true}}if(!ae){this.hooks.push([ad,ac])}};G.jqplot.EventListenerManager.prototype.add=function(ab,aa){this.hooks.push([ab,aa])};var P=["yMidAxis","xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];function M(){this.data=[];this.dataRenderer;this.dataRendererOptions;this.noDataIndicator={show:false,indicator:"Loading Data...",axes:{xaxis:{min:0,max:10,tickInterval:2,show:true},yaxis:{min:0,max:12,tickInterval:3,show:true}}};this.targetId=null;this.target=null;this.defaults={axesDefaults:{},axes:{xaxis:{},yaxis:{},x2axis:{},y2axis:{},y3axis:{},y4axis:{},y5axis:{},y6axis:{},y7axis:{},y8axis:{},y9axis:{},yMidAxis:{}},seriesDefaults:{},series:[]};this.series=[];this.axes={xaxis:new r("xaxis"),yaxis:new r("yaxis"),x2axis:new r("x2axis"),y2axis:new r("y2axis"),y3axis:new r("y3axis"),y4axis:new r("y4axis"),y5axis:new r("y5axis"),y6axis:new r("y6axis"),y7axis:new r("y7axis"),y8axis:new r("y8axis"),y9axis:new r("y9axis"),yMidAxis:new r("yMidAxis")};this.grid=new H();this.legend=new m();this.baseCanvas=new G.jqplot.GenericCanvas();this.seriesStack=[];this.previousSeriesStack=[];this.eventCanvas=new G.jqplot.GenericCanvas();this._width=null;this._height=null;this._plotDimensions={height:null,width:null};this._gridPadding={top:null,right:null,bottom:null,left:null};this._defaultGridPadding={top:10,right:10,bottom:23,left:10};this.syncXTicks=true;this.syncYTicks=true;this.seriesColors=G.jqplot.config.defaultColors;this.negativeSeriesColors=G.jqplot.config.defaultNegativeColors;this.sortData=true;var ac=0;this.textColor;this.fontFamily;this.fontSize;this.title=new t();this.options={};this.stackSeries=false;this.defaultAxisStart=1;this._stackData=[];this._plotData=[];this.plugins={};this._drawCount=0;this.drawIfHidden=false;this.captureRightClick=false;this.themeEngine=new G.jqplot.ThemeEngine();this._sumy=0;this._sumx=0;this.preInitHooks=new G.jqplot.HooksManager();this.postInitHooks=new G.jqplot.HooksManager();this.preParseOptionsHooks=new G.jqplot.HooksManager();this.postParseOptionsHooks=new G.jqplot.HooksManager();this.preDrawHooks=new G.jqplot.HooksManager();this.postDrawHooks=new G.jqplot.HooksManager();this.preDrawSeriesHooks=new G.jqplot.HooksManager();this.postDrawSeriesHooks=new G.jqplot.HooksManager();this.preDrawLegendHooks=new G.jqplot.HooksManager();this.addLegendRowHooks=new G.jqplot.HooksManager();this.preSeriesInitHooks=new G.jqplot.HooksManager();this.postSeriesInitHooks=new G.jqplot.HooksManager();this.preParseSeriesOptionsHooks=new G.jqplot.HooksManager();this.postParseSeriesOptionsHooks=new G.jqplot.HooksManager();this.eventListenerHooks=new G.jqplot.EventListenerManager();this.preDrawSeriesShadowHooks=new G.jqplot.HooksManager();this.postDrawSeriesShadowHooks=new G.jqplot.HooksManager();this.colorGenerator=new G.jqplot.ColorGenerator();this.negativeColorGenerator=new G.jqplot.ColorGenerator();this.canvasManager=new G.jqplot.CanvasManager();this.init=function(ak,ah,am){am=am||{};for(var ai=0;ai<G.jqplot.preInitHooks.length;ai++){G.jqplot.preInitHooks[ai].call(this,ak,ah,am)}for(var ai=0;ai<this.preInitHooks.hooks.length;ai++){this.preInitHooks.hooks[ai].call(this,ak,ah,am)}this.targetId="#"+ak;this.target=G("#"+ak);this.target.removeClass("jqplot-error");if(!this.target.get(0)){throw"No plot target specified"}if(this.target.css("position")=="static"){this.target.css("position","relative")}if(!this.target.hasClass("jqplot-target")){this.target.addClass("jqplot-target")}if(!this.target.height()){var aj;if(am&&am.height){aj=parseInt(am.height,10)}else{if(this.target.attr("data-height")){aj=parseInt(this.target.attr("data-height"),10)}else{aj=parseInt(G.jqplot.config.defaultHeight,10)}}this._height=aj;this.target.css("height",aj+"px")}else{this._height=aj=this.target.height()}if(!this.target.width()){var al;if(am&&am.width){al=parseInt(am.width,10)}else{if(this.target.attr("data-width")){al=parseInt(this.target.attr("data-width"),10)}else{al=parseInt(G.jqplot.config.defaultWidth,10)}}this._width=al;this.target.css("width",al+"px")}else{this._width=al=this.target.width()}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;if(this._height<=0||this._width<=0||!this._height||!this._width){throw"Canvas dimension not set"}if(am.dataRenderer&&jQuery.isFunction(am.dataRenderer)){if(am.dataRendererOptions){this.dataRendererOptions=am.dataRendererOptions}this.dataRenderer=am.dataRenderer;ah=this.dataRenderer(ah,this,this.dataRendererOptions)}if(am.noDataIndicator&&jQuery.isPlainObject(am.noDataIndicator)){G.extend(true,this.noDataIndicator,am.noDataIndicator)}if(ah==null||jQuery.isArray(ah)==false||ah.length==0||jQuery.isArray(ah[0])==false||ah[0].length==0){if(this.noDataIndicator.show==false){throw {name:"DataError",message:"No data to plot."}}else{for(var ae in this.noDataIndicator.axes){for(var af in this.noDataIndicator.axes[ae]){this.axes[ae][af]=this.noDataIndicator.axes[ae][af]}}this.postDrawHooks.add(function(){var at=this.eventCanvas.getHeight();var ap=this.eventCanvas.getWidth();var ao=G('<div class="jqplot-noData-container" style="position:absolute;"></div>');this.target.append(ao);ao.height(at);ao.width(ap);ao.css("top",this.eventCanvas._offsets.top);ao.css("left",this.eventCanvas._offsets.left);var ar=G('<div class="jqplot-noData-contents" style="text-align:center; position:relative; margin-left:auto; margin-right:auto;"></div>');ao.append(ar);ar.html(this.noDataIndicator.indicator);var aq=ar.height();var an=ar.width();ar.height(aq);ar.width(an);ar.css("top",(at-aq)/2+"px")})}}this.data=ah;this.parseOptions(am);if(this.textColor){this.target.css("color",this.textColor)}if(this.fontFamily){this.target.css("font-family",this.fontFamily)}if(this.fontSize){this.target.css("font-size",this.fontSize)}this.title.init();this.legend.init();this._sumy=0;this._sumx=0;for(var ai=0;ai<this.series.length;ai++){this.seriesStack.push(ai);this.previousSeriesStack.push(ai);this.series[ai].shadowCanvas._plotDimensions=this._plotDimensions;this.series[ai].canvas._plotDimensions=this._plotDimensions;for(var ag=0;ag<G.jqplot.preSeriesInitHooks.length;ag++){G.jqplot.preSeriesInitHooks[ag].call(this.series[ai],ak,ah,this.options.seriesDefaults,this.options.series[ai],this)}for(var ag=0;ag<this.preSeriesInitHooks.hooks.length;ag++){this.preSeriesInitHooks.hooks[ag].call(this.series[ai],ak,ah,this.options.seriesDefaults,this.options.series[ai],this)}this.populatePlotData(this.series[ai],ai);this.series[ai]._plotDimensions=this._plotDimensions;this.series[ai].init(ai,this.grid.borderWidth,this);for(var ag=0;ag<G.jqplot.postSeriesInitHooks.length;ag++){G.jqplot.postSeriesInitHooks[ag].call(this.series[ai],ak,ah,this.options.seriesDefaults,this.options.series[ai],this)}for(var ag=0;ag<this.postSeriesInitHooks.hooks.length;ag++){this.postSeriesInitHooks.hooks[ag].call(this.series[ai],ak,ah,this.options.seriesDefaults,this.options.series[ai],this)}this._sumy+=this.series[ai]._sumy;this._sumx+=this.series[ai]._sumx}for(var ai=0;ai<12;ai++){name=P[ai];this.axes[name]._plotDimensions=this._plotDimensions;this.axes[name].init();if(this.axes[name].borderColor==null){if(name.charAt(0)!=="x"&&this.axes[name].useSeriesColor===true&&this.axes[name].show){this.axes[name].borderColor=this.axes[name]._series[0].color}else{this.axes[name].borderColor=this.grid.borderColor}}}if(this.sortData){aa(this.series)}this.grid.init();this.grid._axes=this.axes;this.legend._series=this.series;for(var ai=0;ai<G.jqplot.postInitHooks.length;ai++){G.jqplot.postInitHooks[ai].call(this,ak,ah,am)}for(var ai=0;ai<this.postInitHooks.hooks.length;ai++){this.postInitHooks.hooks[ai].call(this,ak,ah,am)}};this.resetAxesScale=function(aj,af){var ah=af||{};var ai=aj||this.axes;if(ai===true){ai=this.axes}if(jQuery.isArray(ai)){for(var ag=0;ag<ai.length;ag++){this.axes[ai[ag]].resetScale(ah[ai[ag]])}}else{if(typeof(ai)==="object"){for(var ae in ai){this.axes[ae].resetScale(ah[ae])}}}};this.reInitialize=function(){this._height=this.target.height();this._width=this.target.width();if(this._height<=0||this._width<=0||!this._height||!this._width){throw"Target dimension not set"}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;for(var ai in this.axes){this.axes[ai]._plotWidth=this._width;this.axes[ai]._plotHeight=this._height}this.title._plotWidth=this._width;if(this.textColor){this.target.css("color",this.textColor)}if(this.fontFamily){this.target.css("font-family",this.fontFamily)}if(this.fontSize){this.target.css("font-size",this.fontSize)}this._sumy=0;this._sumx=0;for(var ag=0;ag<this.series.length;ag++){this.populatePlotData(this.series[ag],ag);if(this.series[ag]._type==="line"&&this.series[ag].renderer.bands.show){this.series[ag].renderer.initBands.call(this.series[ag],this.series[ag].renderer.options,this)}this.series[ag]._plotDimensions=this._plotDimensions;this.series[ag].canvas._plotDimensions=this._plotDimensions;this._sumy+=this.series[ag]._sumy;this._sumx+=this.series[ag]._sumx}for(var ae=0;ae<12;ae++){name=P[ae];var af=this.axes[name]._ticks;for(var ag=0;ag<af.length;ag++){var ah=af[ag]._elem;if(ah){if(G.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==q){window.G_vmlCanvasManager.uninitElement(ah.get(0))}ah.emptyForce();ah=null;af._elem=null}}af=null;this.axes[name]._plotDimensions=this._plotDimensions;this.axes[name]._ticks=[]}if(this.sortData){aa(this.series)}this.grid._axes=this.axes;this.legend._series=this.series};function aa(ai){var am,an,ao,ae,al;for(var aj=0;aj<ai.length;aj++){var af;var ak=[ai[aj].data,ai[aj]._stackData,ai[aj]._plotData,ai[aj]._prevPlotData];for(var ag=0;ag<4;ag++){af=true;am=ak[ag];if(ai[aj]._stackAxis=="x"){for(var ah=0;ah<am.length;ah++){if(typeof(am[ah][1])!="number"){af=false;break}}if(af){am.sort(function(aq,ap){return aq[1]-ap[1]})}}else{for(var ah=0;ah<am.length;ah++){if(typeof(am[ah][0])!="number"){af=false;break}}if(af){am.sort(function(aq,ap){return aq[0]-ap[0]})}}}}}this.populatePlotData=function(ai,aj){this._plotData=[];this._stackData=[];ai._stackData=[];ai._plotData=[];var am={x:[],y:[]};if(this.stackSeries&&!ai.disableStack){ai._stack=true;var ak=ai._stackAxis=="x"?0:1;var al=ak?0:1;var an=G.extend(true,[],ai.data);var ao=G.extend(true,[],ai.data);for(var ag=0;ag<aj;ag++){var ae=this.series[ag].data;for(var af=0;af<ae.length;af++){an[af][0]+=ae[af][0];an[af][1]+=ae[af][1];ao[af][ak]+=ae[af][ak]}}for(var ah=0;ah<ao.length;ah++){am.x.push(ao[ah][0]);am.y.push(ao[ah][1])}this._plotData.push(ao);this._stackData.push(an);ai._stackData=an;ai._plotData=ao;ai._plotValues=am}else{for(var ah=0;ah<ai.data.length;ah++){am.x.push(ai.data[ah][0]);am.y.push(ai.data[ah][1])}this._stackData.push(ai.data);this.series[aj]._stackData=ai.data;this._plotData.push(ai.data);ai._plotData=ai.data;ai._plotValues=am}if(aj>0){ai._prevPlotData=this.series[aj-1]._plotData}ai._sumy=0;ai._sumx=0;for(ah=ai.data.length-1;ah>-1;ah--){ai._sumy+=ai.data[ah][1];ai._sumx+=ai.data[ah][0]}};this.getNextSeriesColor=(function(af){var ae=0;var ag=af.seriesColors;return function(){if(ae<ag.length){return ag[ae++]}else{ae=0;return ag[ae++]}}})(this);this.parseOptions=function(am){for(var ai=0;ai<this.preParseOptionsHooks.hooks.length;ai++){this.preParseOptionsHooks.hooks[ai].call(this,am)}for(var ai=0;ai<G.jqplot.preParseOptionsHooks.length;ai++){G.jqplot.preParseOptionsHooks[ai].call(this,am)}this.options=G.extend(true,{},this.defaults,am);this.stackSeries=this.options.stackSeries;if(this.options.seriesColors){this.seriesColors=this.options.seriesColors}if(this.options.negativeSeriesColors){this.negativeSeriesColors=this.options.negativeSeriesColors}if(this.options.captureRightClick){this.captureRightClick=this.options.captureRightClick}this.defaultAxisStart=(am&&am.defaultAxisStart!=null)?am.defaultAxisStart:this.defaultAxisStart;this.colorGenerator.setColors(this.seriesColors);this.negativeColorGenerator.setColors(this.negativeSeriesColors);G.extend(true,this._gridPadding,this.options.gridPadding);this.sortData=(this.options.sortData!=null)?this.options.sortData:this.sortData;for(var ai=0;ai<12;ai++){var ae=P[ai];var ag=this.axes[ae];ag._options=G.extend(true,{},this.options.axesDefaults,this.options.axes[ae]);G.extend(true,ag,this.options.axesDefaults,this.options.axes[ae]);ag._plotWidth=this._width;ag._plotHeight=this._height}var ak=function(aq,ao,ar){var an=[];var ap;ao=ao||"vertical";if(!jQuery.isArray(aq[0])){for(ap=0;ap<aq.length;ap++){if(ao=="vertical"){an.push([ar+ap,aq[ap]])}else{an.push([aq[ap],ar+ap])}}}else{G.extend(true,an,aq)}return an};var aj=0;for(var ai=0;ai<this.data.length;ai++){var al=new N();for(var ah=0;ah<G.jqplot.preParseSeriesOptionsHooks.length;ah++){G.jqplot.preParseSeriesOptionsHooks[ah].call(al,this.options.seriesDefaults,this.options.series[ai])}for(var ah=0;ah<this.preParseSeriesOptionsHooks.hooks.length;ah++){this.preParseSeriesOptionsHooks.hooks[ah].call(al,this.options.seriesDefaults,this.options.series[ai])}G.extend(true,al,{seriesColors:this.seriesColors,negativeSeriesColors:this.negativeSeriesColors},this.options.seriesDefaults,this.options.series[ai]);var af="vertical";if(al.renderer===G.jqplot.BarRenderer&&al.rendererOptions&&al.rendererOptions.barDirection=="horizontal"&&al.transposeData===true){af="horizontal"}al.data=ak(this.data[ai],af,this.defaultAxisStart);switch(al.xaxis){case"xaxis":al._xaxis=this.axes.xaxis;break;case"x2axis":al._xaxis=this.axes.x2axis;break;default:break}al._yaxis=this.axes[al.yaxis];al._xaxis._series.push(al);al._yaxis._series.push(al);if(al.show){al._xaxis.show=true;al._yaxis.show=true}if(!al.label){al.label="Series "+(ai+1).toString()}this.series.push(al);for(var ah=0;ah<G.jqplot.postParseSeriesOptionsHooks.length;ah++){G.jqplot.postParseSeriesOptionsHooks[ah].call(this.series[ai],this.options.seriesDefaults,this.options.series[ai])}for(var ah=0;ah<this.postParseSeriesOptionsHooks.hooks.length;ah++){this.postParseSeriesOptionsHooks.hooks[ah].call(this.series[ai],this.options.seriesDefaults,this.options.series[ai])}}G.extend(true,this.grid,this.options.grid);for(var ai=0;ai<12;ai++){var ae=P[ai];var ag=this.axes[ae];if(ag.borderWidth==null){ag.borderWidth=this.grid.borderWidth}}if(typeof this.options.title=="string"){this.title.text=this.options.title}else{if(typeof this.options.title=="object"){G.extend(true,this.title,this.options.title)}}this.title._plotWidth=this._width;this.legend.setOptions(this.options.legend);for(var ai=0;ai<G.jqplot.postParseOptionsHooks.length;ai++){G.jqplot.postParseOptionsHooks[ai].call(this,am)}for(var ai=0;ai<this.postParseOptionsHooks.hooks.length;ai++){this.postParseOptionsHooks.hooks[ai].call(this,am)}};this.destroy=function(){this.canvasManager.freeAllCanvases();if(this.eventCanvas&&this.eventCanvas._elem){this.eventCanvas._elem.unbind()}this.target.empty();this.target[0].innerHTML=""};this.replot=function(af){var ag=af||{};var ae=ag.clear||true;var ah=ag.resetAxes||false;this.target.trigger("jqplotPreReplot");if(ae){this.destroy()}this.reInitialize();if(ah){this.resetAxesScale(ah,ag.axes)}this.draw();this.target.trigger("jqplotPostReplot")};this.redraw=function(ae){ae=(ae!=null)?ae:true;this.target.trigger("jqplotPreRedraw");if(ae){this.canvasManager.freeAllCanvases();this.eventCanvas._elem.unbind();this.target.empty()}for(var ag in this.axes){this.axes[ag]._ticks=[]}for(var af=0;af<this.series.length;af++){this.populatePlotData(this.series[af],af)}this._sumy=0;this._sumx=0;for(af=0;af<this.series.length;af++){this._sumy+=this.series[af]._sumy;this._sumx+=this.series[af]._sumx}this.draw();this.target.trigger("jqplotPostRedraw")};this.draw=function(){if(this.drawIfHidden||this.target.is(":visible")){this.target.trigger("jqplotPreDraw");var al,aj;for(al=0;al<G.jqplot.preDrawHooks.length;al++){G.jqplot.preDrawHooks[al].call(this)}for(al=0;al<this.preDrawHooks.hooks.length;al++){this.preDrawHooks.hooks[al].call(this)}this.target.append(this.baseCanvas.createElement({left:0,right:0,top:0,bottom:0},"jqplot-base-canvas",null,this));this.baseCanvas.setContext();this.target.append(this.title.draw());this.title.pack({top:0,left:0});var au=this.legend.draw();var aq={top:0,left:0,bottom:0,right:0};if(this.legend.placement=="outsideGrid"){this.target.append(au);switch(this.legend.location){case"n":aq.top+=this.legend.getHeight();break;case"s":aq.bottom+=this.legend.getHeight();break;case"ne":case"e":case"se":aq.right+=this.legend.getWidth();break;case"nw":case"w":case"sw":aq.left+=this.legend.getWidth();break;default:aq.right+=this.legend.getWidth();break}au=au.detach()}var ae=this.axes;for(al=0;al<12;al++){name=P[al];this.target.append(ae[name].draw(this.baseCanvas._ctx,this));ae[name].set()}if(ae.yaxis.show){aq.left+=ae.yaxis.getWidth()}var ah=["y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];var af=[0,0,0,0,0,0,0,0];var an=0;var ai;for(ai=0;ai<8;ai++){if(ae[ah[ai]].show){an+=ae[ah[ai]].getWidth();af[ai]=an}}aq.right+=an;if(ae.x2axis.show){aq.top+=ae.x2axis.getHeight()}if(this.title.show){aq.top+=this.title.getHeight()}if(ae.xaxis.show){aq.bottom+=ae.xaxis.getHeight()}if(this.options.gridDimensions&&G.isPlainObject(this.options.gridDimensions)){var ak=parseInt(this.options.gridDimensions.width,10)||0;var ag=parseInt(this.options.gridDimensions.height,10)||0;var ar=(this._width-aq.left-aq.right-ak)/2;var at=(this._height-aq.top-aq.bottom-ag)/2;if(at>=0&&ar>=0){aq.top+=at;aq.bottom+=at;aq.left+=ar;aq.right+=ar}}var am=["top","bottom","left","right"];for(var ai in am){if(this._gridPadding[am[ai]]==null&&aq[am[ai]]>0){this._gridPadding[am[ai]]=aq[am[ai]]}else{if(this._gridPadding[am[ai]]==null){this._gridPadding[am[ai]]=this._defaultGridPadding[am[ai]]}}}var ap=(this.legend.placement=="outsideGrid")?{top:this.title.getHeight(),left:0,right:0,bottom:0}:this._gridPadding;ae.xaxis.pack({position:"absolute",bottom:this._gridPadding.bottom-ae.xaxis.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});ae.yaxis.pack({position:"absolute",top:0,left:this._gridPadding.left-ae.yaxis.getWidth(),height:this._height},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top});ae.x2axis.pack({position:"absolute",top:this._gridPadding.top-ae.x2axis.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});for(al=8;al>0;al--){ae[ah[al-1]].pack({position:"absolute",top:0,right:this._gridPadding.right-af[al-1]},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top})}var ao=(this._width-this._gridPadding.left-this._gridPadding.right)/2+this._gridPadding.left-ae.yMidAxis.getWidth()/2;ae.yMidAxis.pack({position:"absolute",top:0,left:ao,zIndex:9,textAlign:"center"},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top});this.target.append(this.grid.createElement(this._gridPadding,this));this.grid.draw();for(al=0;al<this.series.length;al++){aj=this.seriesStack[al];this.target.append(this.series[aj].shadowCanvas.createElement(this._gridPadding,"jqplot-series-shadowCanvas",null,this));this.series[aj].shadowCanvas.setContext();this.series[aj].shadowCanvas._elem.data("seriesIndex",aj)}for(al=0;al<this.series.length;al++){aj=this.seriesStack[al];this.target.append(this.series[aj].canvas.createElement(this._gridPadding,"jqplot-series-canvas",null,this));this.series[aj].canvas.setContext();this.series[aj].canvas._elem.data("seriesIndex",aj)}this.target.append(this.eventCanvas.createElement(this._gridPadding,"jqplot-event-canvas",null,this));this.eventCanvas.setContext();this.eventCanvas._ctx.fillStyle="rgba(0,0,0,0)";this.eventCanvas._ctx.fillRect(0,0,this.eventCanvas._ctx.canvas.width,this.eventCanvas._ctx.canvas.height);this.bindCustomEvents();if(this.legend.preDraw){this.eventCanvas._elem.before(au);this.legend.pack(ap);if(this.legend._elem){this.drawSeries({legendInfo:{location:this.legend.location,placement:this.legend.placement,width:this.legend.getWidth(),height:this.legend.getHeight(),xoffset:this.legend.xoffset,yoffset:this.legend.yoffset}})}else{this.drawSeries()}}else{this.drawSeries();if(this.series.length){G(this.series[this.series.length-1].canvas._elem).after(au)}this.legend.pack(ap)}for(var al=0;al<G.jqplot.eventListenerHooks.length;al++){this.eventCanvas._elem.bind(G.jqplot.eventListenerHooks[al][0],{plot:this},G.jqplot.eventListenerHooks[al][1])}for(var al=0;al<this.eventListenerHooks.hooks.length;al++){this.eventCanvas._elem.bind(this.eventListenerHooks.hooks[al][0],{plot:this},this.eventListenerHooks.hooks[al][1])}for(var al=0;al<G.jqplot.postDrawHooks.length;al++){G.jqplot.postDrawHooks[al].call(this)}for(var al=0;al<this.postDrawHooks.hooks.length;al++){this.postDrawHooks.hooks[al].call(this)}if(this.target.is(":visible")){this._drawCount+=1}this.target.trigger("jqplotPostDraw",[this])}};this.bindCustomEvents=function(){this.eventCanvas._elem.bind("click",{plot:this},this.onClick);this.eventCanvas._elem.bind("dblclick",{plot:this},this.onDblClick);this.eventCanvas._elem.bind("mousedown",{plot:this},this.onMouseDown);this.eventCanvas._elem.bind("mousemove",{plot:this},this.onMouseMove);this.eventCanvas._elem.bind("mouseenter",{plot:this},this.onMouseEnter);this.eventCanvas._elem.bind("mouseleave",{plot:this},this.onMouseLeave);if(this.captureRightClick){this.eventCanvas._elem.bind("mouseup",{plot:this},this.onRightClick);this.eventCanvas._elem.get(0).oncontextmenu=function(){return false}}else{this.eventCanvas._elem.bind("mouseup",{plot:this},this.onMouseUp)}};function ab(am){var al=am.data.plot;var ah=al.eventCanvas._elem.offset();var ak={x:am.pageX-ah.left,y:am.pageY-ah.top};var ai={xaxis:null,yaxis:null,x2axis:null,y2axis:null,y3axis:null,y4axis:null,y5axis:null,y6axis:null,y7axis:null,y8axis:null,y9axis:null,yMidAxis:null};var aj=["xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis","yMidAxis"];var ae=al.axes;var af,ag;for(af=11;af>0;af--){ag=aj[af-1];if(ae[ag].show){ai[ag]=ae[ag].series_p2u(ak[ag.charAt(0)])}}return{offsets:ah,gridPos:ak,dataPos:ai}}function ad(ae,af){var aj=af.series;var aO,aN,aM,aH,aI,aC,aB,ao,am,ar,at,aD;var aL,aP,aJ,ak,aA,aF;var ag,aG;for(aM=af.seriesStack.length-1;aM>=0;aM--){aO=af.seriesStack[aM];aH=aj[aO];switch(aH.renderer.constructor){case G.jqplot.BarRenderer:case G.jqplot.PyramidRenderer:aC=ae.x;aB=ae.y;for(aN=0;aN<aH._barPoints.length;aN++){aA=aH._barPoints[aN];aJ=aH.gridData[aN];if(aC>aA[0][0]&&aC<aA[2][0]&&aB>aA[2][1]&&aB<aA[0][1]){return{seriesIndex:aH.index,pointIndex:aN,gridData:aJ,data:aH.data[aN],points:aH._barPoints[aN]}}}break;case G.jqplot.DonutRenderer:ar=aH.startAngle/180*Math.PI;aC=ae.x-aH._center[0];aB=ae.y-aH._center[1];aI=Math.sqrt(Math.pow(aC,2)+Math.pow(aB,2));if(aC>0&&-aB>=0){ao=2*Math.PI-Math.atan(-aB/aC)}else{if(aC>0&&-aB<0){ao=-Math.atan(-aB/aC)}else{if(aC<0){ao=Math.PI-Math.atan(-aB/aC)}else{if(aC==0&&-aB>0){ao=3*Math.PI/2}else{if(aC==0&&-aB<0){ao=Math.PI/2}else{if(aC==0&&aB==0){ao=0}}}}}}if(ar){ao-=ar;if(ao<0){ao+=2*Math.PI}else{if(ao>2*Math.PI){ao-=2*Math.PI}}}am=aH.sliceMargin/180*Math.PI;if(aI<aH._radius&&aI>aH._innerRadius){for(aN=0;aN<aH.gridData.length;aN++){at=(aN>0)?aH.gridData[aN-1][1]+am:am;aD=aH.gridData[aN][1];if(ao>at&&ao<aD){return{seriesIndex:aH.index,pointIndex:aN,gridData:aH.gridData[aN],data:aH.data[aN]}}}}break;case G.jqplot.PieRenderer:ar=aH.startAngle/180*Math.PI;aC=ae.x-aH._center[0];aB=ae.y-aH._center[1];aI=Math.sqrt(Math.pow(aC,2)+Math.pow(aB,2));if(aC>0&&-aB>=0){ao=2*Math.PI-Math.atan(-aB/aC)}else{if(aC>0&&-aB<0){ao=-Math.atan(-aB/aC)}else{if(aC<0){ao=Math.PI-Math.atan(-aB/aC)}else{if(aC==0&&-aB>0){ao=3*Math.PI/2}else{if(aC==0&&-aB<0){ao=Math.PI/2}else{if(aC==0&&aB==0){ao=0}}}}}}if(ar){ao-=ar;if(ao<0){ao+=2*Math.PI}else{if(ao>2*Math.PI){ao-=2*Math.PI}}}am=aH.sliceMargin/180*Math.PI;if(aI<aH._radius){for(aN=0;aN<aH.gridData.length;aN++){at=(aN>0)?aH.gridData[aN-1][1]+am:am;aD=aH.gridData[aN][1];if(ao>at&&ao<aD){return{seriesIndex:aH.index,pointIndex:aN,gridData:aH.gridData[aN],data:aH.data[aN]}}}}break;case G.jqplot.BubbleRenderer:aC=ae.x;aB=ae.y;var ay=null;if(aH.show){for(var aN=0;aN<aH.gridData.length;aN++){aJ=aH.gridData[aN];aP=Math.sqrt((aC-aJ[0])*(aC-aJ[0])+(aB-aJ[1])*(aB-aJ[1]));if(aP<=aJ[2]&&(aP<=aL||aL==null)){aL=aP;ay={seriesIndex:aO,pointIndex:aN,gridData:aJ,data:aH.data[aN]}}}if(ay!=null){return ay}}break;case G.jqplot.FunnelRenderer:aC=ae.x;aB=ae.y;var aE=aH._vertices,ai=aE[0],ah=aE[aE.length-1],al,ax,aq;function aK(aS,aU,aT){var aR=(aU[1]-aT[1])/(aU[0]-aT[0]);var aQ=aU[1]-aR*aU[0];var aV=aS+aU[1];return[(aV-aQ)/aR,aV]}al=aK(aB,ai[0],ah[3]);ax=aK(aB,ai[1],ah[2]);for(aN=0;aN<aE.length;aN++){aq=aE[aN];if(aB>=aq[0][1]&&aB<=aq[3][1]&&aC>=al[0]&&aC<=ax[0]){return{seriesIndex:aH.index,pointIndex:aN,gridData:null,data:aH.data[aN]}}}break;case G.jqplot.LineRenderer:aC=ae.x;aB=ae.y;aI=aH.renderer;if(aH.show){if((aH.fill||(aH.renderer.bands.show&&aH.renderer.bands.fill))&&(!af.plugins.highlighter||!af.plugins.highlighter.show)){var ap=false;if(aC>aH._boundingBox[0][0]&&aC<aH._boundingBox[1][0]&&aB>aH._boundingBox[1][1]&&aB<aH._boundingBox[0][1]){var aw=aH._areaPoints.length;var az;var aN=aw-1;for(var az=0;az<aw;az++){var av=[aH._areaPoints[az][0],aH._areaPoints[az][1]];var au=[aH._areaPoints[aN][0],aH._areaPoints[aN][1]];if(av[1]<aB&&au[1]>=aB||au[1]<aB&&av[1]>=aB){if(av[0]+(aB-av[1])/(au[1]-av[1])*(au[0]-av[0])<aC){ap=!ap}}aN=az}}if(ap){return{seriesIndex:aO,pointIndex:null,gridData:aH.gridData,data:aH.data,points:aH._areaPoints}}break}else{aG=aH.markerRenderer.size/2+aH.neighborThreshold;ag=(aG>0)?aG:0;for(var aN=0;aN<aH.gridData.length;aN++){aJ=aH.gridData[aN];if(aI.constructor==G.jqplot.OHLCRenderer){if(aI.candleStick){var an=aH._yaxis.series_u2p;if(aC>=aJ[0]-aI._bodyWidth/2&&aC<=aJ[0]+aI._bodyWidth/2&&aB>=an(aH.data[aN][2])&&aB<=an(aH.data[aN][3])){return{seriesIndex:aO,pointIndex:aN,gridData:aJ,data:aH.data[aN]}}}else{if(!aI.hlc){var an=aH._yaxis.series_u2p;if(aC>=aJ[0]-aI._tickLength&&aC<=aJ[0]+aI._tickLength&&aB>=an(aH.data[aN][2])&&aB<=an(aH.data[aN][3])){return{seriesIndex:aO,pointIndex:aN,gridData:aJ,data:aH.data[aN]}}}else{var an=aH._yaxis.series_u2p;if(aC>=aJ[0]-aI._tickLength&&aC<=aJ[0]+aI._tickLength&&aB>=an(aH.data[aN][1])&&aB<=an(aH.data[aN][2])){return{seriesIndex:aO,pointIndex:aN,gridData:aJ,data:aH.data[aN]}}}}}else{if(aJ[0]!=null&&aJ[1]!=null){aP=Math.sqrt((aC-aJ[0])*(aC-aJ[0])+(aB-aJ[1])*(aB-aJ[1]));if(aP<=ag&&(aP<=aL||aL==null)){aL=aP;return{seriesIndex:aO,pointIndex:aN,gridData:aJ,data:aH.data[aN]}}}}}}}break;default:aC=ae.x;aB=ae.y;aI=aH.renderer;if(aH.show){aG=aH.markerRenderer.size/2+aH.neighborThreshold;ag=(aG>0)?aG:0;for(var aN=0;aN<aH.gridData.length;aN++){aJ=aH.gridData[aN];if(aI.constructor==G.jqplot.OHLCRenderer){if(aI.candleStick){var an=aH._yaxis.series_u2p;if(aC>=aJ[0]-aI._bodyWidth/2&&aC<=aJ[0]+aI._bodyWidth/2&&aB>=an(aH.data[aN][2])&&aB<=an(aH.data[aN][3])){return{seriesIndex:aO,pointIndex:aN,gridData:aJ,data:aH.data[aN]}}}else{if(!aI.hlc){var an=aH._yaxis.series_u2p;if(aC>=aJ[0]-aI._tickLength&&aC<=aJ[0]+aI._tickLength&&aB>=an(aH.data[aN][2])&&aB<=an(aH.data[aN][3])){return{seriesIndex:aO,pointIndex:aN,gridData:aJ,data:aH.data[aN]}}}else{var an=aH._yaxis.series_u2p;if(aC>=aJ[0]-aI._tickLength&&aC<=aJ[0]+aI._tickLength&&aB>=an(aH.data[aN][1])&&aB<=an(aH.data[aN][2])){return{seriesIndex:aO,pointIndex:aN,gridData:aJ,data:aH.data[aN]}}}}}else{aP=Math.sqrt((aC-aJ[0])*(aC-aJ[0])+(aB-aJ[1])*(aB-aJ[1]));if(aP<=ag&&(aP<=aL||aL==null)){aL=aP;return{seriesIndex:aO,pointIndex:aN,gridData:aJ,data:aH.data[aN]}}}}}break}}return null}this.onClick=function(ag){var af=ab(ag);var ai=ag.data.plot;var ah=ad(af.gridPos,ai);var ae=jQuery.Event("jqplotClick");ae.pageX=ag.pageX;ae.pageY=ag.pageY;G(this).trigger(ae,[af.gridPos,af.dataPos,ah,ai])};this.onDblClick=function(ag){var af=ab(ag);var ai=ag.data.plot;var ah=ad(af.gridPos,ai);var ae=jQuery.Event("jqplotDblClick");ae.pageX=ag.pageX;ae.pageY=ag.pageY;G(this).trigger(ae,[af.gridPos,af.dataPos,ah,ai])};this.onMouseDown=function(ag){var af=ab(ag);var ai=ag.data.plot;var ah=ad(af.gridPos,ai);var ae=jQuery.Event("jqplotMouseDown");ae.pageX=ag.pageX;ae.pageY=ag.pageY;G(this).trigger(ae,[af.gridPos,af.dataPos,ah,ai])};this.onMouseUp=function(ag){var af=ab(ag);var ae=jQuery.Event("jqplotMouseUp");ae.pageX=ag.pageX;ae.pageY=ag.pageY;G(this).trigger(ae,[af.gridPos,af.dataPos,null,ag.data.plot])};this.onRightClick=function(ag){var af=ab(ag);var ai=ag.data.plot;var ah=ad(af.gridPos,ai);if(ai.captureRightClick){if(ag.which==3){var ae=jQuery.Event("jqplotRightClick");ae.pageX=ag.pageX;ae.pageY=ag.pageY;G(this).trigger(ae,[af.gridPos,af.dataPos,ah,ai])}else{var ae=jQuery.Event("jqplotMouseUp");ae.pageX=ag.pageX;ae.pageY=ag.pageY;G(this).trigger(ae,[af.gridPos,af.dataPos,ah,ai])}}};this.onMouseMove=function(ag){var af=ab(ag);var ai=ag.data.plot;var ah=ad(af.gridPos,ai);var ae=jQuery.Event("jqplotMouseMove");ae.pageX=ag.pageX;ae.pageY=ag.pageY;G(this).trigger(ae,[af.gridPos,af.dataPos,ah,ai])};this.onMouseEnter=function(ag){var af=ab(ag);var ah=ag.data.plot;var ae=jQuery.Event("jqplotMouseEnter");ae.pageX=ag.pageX;ae.pageY=ag.pageY;ae.relatedTarget=ag.relatedTarget;G(this).trigger(ae,[af.gridPos,af.dataPos,null,ah])};this.onMouseLeave=function(ag){var af=ab(ag);var ah=ag.data.plot;var ae=jQuery.Event("jqplotMouseLeave");ae.pageX=ag.pageX;ae.pageY=ag.pageY;ae.relatedTarget=ag.relatedTarget;G(this).trigger(ae,[af.gridPos,af.dataPos,null,ah])};this.drawSeries=function(ag,ae){var ai,ah,af;ae=(typeof(ag)==="number"&&ae==null)?ag:ae;ag=(typeof(ag)==="object")?ag:{};if(ae!=q){ah=this.series[ae];af=ah.shadowCanvas._ctx;af.clearRect(0,0,af.canvas.width,af.canvas.height);ah.drawShadow(af,ag,this);af=ah.canvas._ctx;af.clearRect(0,0,af.canvas.width,af.canvas.height);ah.draw(af,ag,this);if(ah.renderer.constructor==G.jqplot.BezierCurveRenderer){if(ae<this.series.length-1){this.drawSeries(ae+1)}}}else{for(ai=0;ai<this.series.length;ai++){ah=this.series[ai];af=ah.shadowCanvas._ctx;af.clearRect(0,0,af.canvas.width,af.canvas.height);ah.drawShadow(af,ag,this);af=ah.canvas._ctx;af.clearRect(0,0,af.canvas.width,af.canvas.height);ah.draw(af,ag,this)}}ag=ae=ai=ah=af=null};this.moveSeriesToFront=function(af){af=parseInt(af,10);var ai=G.inArray(af,this.seriesStack);if(ai==-1){return}if(ai==this.seriesStack.length-1){this.previousSeriesStack=this.seriesStack.slice(0);return}var ae=this.seriesStack[this.seriesStack.length-1];var ah=this.series[af].canvas._elem.detach();var ag=this.series[af].shadowCanvas._elem.detach();this.series[ae].shadowCanvas._elem.after(ag);this.series[ae].canvas._elem.after(ah);this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack.splice(ai,1);this.seriesStack.push(af)};this.moveSeriesToBack=function(af){af=parseInt(af,10);var ai=G.inArray(af,this.seriesStack);if(ai==0||ai==-1){return}var ae=this.seriesStack[0];var ah=this.series[af].canvas._elem.detach();var ag=this.series[af].shadowCanvas._elem.detach();this.series[ae].shadowCanvas._elem.before(ag);this.series[ae].canvas._elem.before(ah);this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack.splice(ai,1);this.seriesStack.unshift(af)};this.restorePreviousSeriesOrder=function(){var ak,aj,ai,ah,ag,ae,af;if(this.seriesStack==this.previousSeriesStack){return}for(ak=1;ak<this.previousSeriesStack.length;ak++){ae=this.previousSeriesStack[ak];af=this.previousSeriesStack[ak-1];ai=this.series[ae].canvas._elem.detach();ah=this.series[ae].shadowCanvas._elem.detach();this.series[af].shadowCanvas._elem.after(ah);this.series[af].canvas._elem.after(ai)}ag=this.seriesStack.slice(0);this.seriesStack=this.previousSeriesStack.slice(0);this.previousSeriesStack=ag};this.restoreOriginalSeriesOrder=function(){var ai,ah,ae=[],ag,af;for(ai=0;ai<this.series.length;ai++){ae.push(ai)}if(this.seriesStack==ae){return}this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack=ae;for(ai=1;ai<this.seriesStack.length;ai++){ag=this.series[ai].canvas._elem.detach();af=this.series[ai].shadowCanvas._elem.detach();this.series[ai-1].shadowCanvas._elem.after(af);this.series[ai-1].canvas._elem.after(ag)}};this.activateTheme=function(ae){this.themeEngine.activate(this,ae)}}G.jqplot.computeHighlightColors=function(ab){var ad;if(jQuery.isArray(ab)){ad=[];for(var af=0;af<ab.length;af++){var ae=G.jqplot.getColorComponents(ab[af]);var aa=[ae[0],ae[1],ae[2]];var ag=aa[0]+aa[1]+aa[2];for(var ac=0;ac<3;ac++){aa[ac]=(ag>660)?aa[ac]*0.85:0.73*aa[ac]+90;aa[ac]=parseInt(aa[ac],10);(aa[ac]>255)?255:aa[ac]}aa[3]=0.3+0.35*ae[3];ad.push("rgba("+aa[0]+","+aa[1]+","+aa[2]+","+aa[3]+")")}}else{var ae=G.jqplot.getColorComponents(ab);var aa=[ae[0],ae[1],ae[2]];var ag=aa[0]+aa[1]+aa[2];for(var ac=0;ac<3;ac++){aa[ac]=(ag>660)?aa[ac]*0.85:0.73*aa[ac]+90;aa[ac]=parseInt(aa[ac],10);(aa[ac]>255)?255:aa[ac]}aa[3]=0.3+0.35*ae[3];ad="rgba("+aa[0]+","+aa[1]+","+aa[2]+","+aa[3]+")"}return ad};G.jqplot.ColorGenerator=function(ab){ab=ab||G.jqplot.config.defaultColors;var aa=0;this.next=function(){if(aa<ab.length){return ab[aa++]}else{aa=0;return ab[aa++]}};this.previous=function(){if(aa>0){return ab[aa--]}else{aa=ab.length-1;return ab[aa]}};this.get=function(ad){var ac=ad-ab.length*Math.floor(ad/ab.length);return ab[ac]};this.setColors=function(ac){ab=ac};this.reset=function(){aa=0};this.getIndex=function(){return aa};this.setIndex=function(ac){aa=ac}};G.jqplot.hex2rgb=function(ac,aa){ac=ac.replace("#","");if(ac.length==3){ac=ac.charAt(0)+ac.charAt(0)+ac.charAt(1)+ac.charAt(1)+ac.charAt(2)+ac.charAt(2)}var ab;ab="rgba("+parseInt(ac.slice(0,2),16)+", "+parseInt(ac.slice(2,4),16)+", "+parseInt(ac.slice(4,6),16);if(aa){ab+=", "+aa}ab+=")";return ab};G.jqplot.rgb2hex=function(af){var ac=/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *(?:, *[0-9.]*)?\)/;var aa=af.match(ac);var ae="#";for(var ad=1;ad<4;ad++){var ab;if(aa[ad].search(/%/)!=-1){ab=parseInt(255*aa[ad]/100,10).toString(16);if(ab.length==1){ab="0"+ab}}else{ab=parseInt(aa[ad],10).toString(16);if(ab.length==1){ab="0"+ab}}ae+=ab}return ae};G.jqplot.normalize2rgb=function(ab,aa){if(ab.search(/^ *rgba?\(/)!=-1){return ab}else{if(ab.search(/^ *#?[0-9a-fA-F]?[0-9a-fA-F]/)!=-1){return G.jqplot.hex2rgb(ab,aa)}else{throw"invalid color spec"}}};G.jqplot.getColorComponents=function(af){af=G.jqplot.colorKeywordMap[af]||af;var ad=G.jqplot.normalize2rgb(af);var ac=/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *,? *([0-9.]* *)?\)/;var aa=ad.match(ac);var ab=[];for(var ae=1;ae<4;ae++){if(aa[ae].search(/%/)!=-1){ab[ae-1]=parseInt(255*aa[ae]/100,10)}else{ab[ae-1]=parseInt(aa[ae],10)}}ab[3]=parseFloat(aa[4])?parseFloat(aa[4]):1;return ab};G.jqplot.colorKeywordMap={aliceblue:"rgb(240, 248, 255)",antiquewhite:"rgb(250, 235, 215)",aqua:"rgb( 0, 255, 255)",aquamarine:"rgb(127, 255, 212)",azure:"rgb(240, 255, 255)",beige:"rgb(245, 245, 220)",bisque:"rgb(255, 228, 196)",black:"rgb( 0, 0, 0)",blanchedalmond:"rgb(255, 235, 205)",blue:"rgb( 0, 0, 255)",blueviolet:"rgb(138, 43, 226)",brown:"rgb(165, 42, 42)",burlywood:"rgb(222, 184, 135)",cadetblue:"rgb( 95, 158, 160)",chartreuse:"rgb(127, 255, 0)",chocolate:"rgb(210, 105, 30)",coral:"rgb(255, 127, 80)",cornflowerblue:"rgb(100, 149, 237)",cornsilk:"rgb(255, 248, 220)",crimson:"rgb(220, 20, 60)",cyan:"rgb( 0, 255, 255)",darkblue:"rgb( 0, 0, 139)",darkcyan:"rgb( 0, 139, 139)",darkgoldenrod:"rgb(184, 134, 11)",darkgray:"rgb(169, 169, 169)",darkgreen:"rgb( 0, 100, 0)",darkgrey:"rgb(169, 169, 169)",darkkhaki:"rgb(189, 183, 107)",darkmagenta:"rgb(139, 0, 139)",darkolivegreen:"rgb( 85, 107, 47)",darkorange:"rgb(255, 140, 0)",darkorchid:"rgb(153, 50, 204)",darkred:"rgb(139, 0, 0)",darksalmon:"rgb(233, 150, 122)",darkseagreen:"rgb(143, 188, 143)",darkslateblue:"rgb( 72, 61, 139)",darkslategray:"rgb( 47, 79, 79)",darkslategrey:"rgb( 47, 79, 79)",darkturquoise:"rgb( 0, 206, 209)",darkviolet:"rgb(148, 0, 211)",deeppink:"rgb(255, 20, 147)",deepskyblue:"rgb( 0, 191, 255)",dimgray:"rgb(105, 105, 105)",dimgrey:"rgb(105, 105, 105)",dodgerblue:"rgb( 30, 144, 255)",firebrick:"rgb(178, 34, 34)",floralwhite:"rgb(255, 250, 240)",forestgreen:"rgb( 34, 139, 34)",fuchsia:"rgb(255, 0, 255)",gainsboro:"rgb(220, 220, 220)",ghostwhite:"rgb(248, 248, 255)",gold:"rgb(255, 215, 0)",goldenrod:"rgb(218, 165, 32)",gray:"rgb(128, 128, 128)",grey:"rgb(128, 128, 128)",green:"rgb( 0, 128, 0)",greenyellow:"rgb(173, 255, 47)",honeydew:"rgb(240, 255, 240)",hotpink:"rgb(255, 105, 180)",indianred:"rgb(205, 92, 92)",indigo:"rgb( 75, 0, 130)",ivory:"rgb(255, 255, 240)",khaki:"rgb(240, 230, 140)",lavender:"rgb(230, 230, 250)",lavenderblush:"rgb(255, 240, 245)",lawngreen:"rgb(124, 252, 0)",lemonchiffon:"rgb(255, 250, 205)",lightblue:"rgb(173, 216, 230)",lightcoral:"rgb(240, 128, 128)",lightcyan:"rgb(224, 255, 255)",lightgoldenrodyellow:"rgb(250, 250, 210)",lightgray:"rgb(211, 211, 211)",lightgreen:"rgb(144, 238, 144)",lightgrey:"rgb(211, 211, 211)",lightpink:"rgb(255, 182, 193)",lightsalmon:"rgb(255, 160, 122)",lightseagreen:"rgb( 32, 178, 170)",lightskyblue:"rgb(135, 206, 250)",lightslategray:"rgb(119, 136, 153)",lightslategrey:"rgb(119, 136, 153)",lightsteelblue:"rgb(176, 196, 222)",lightyellow:"rgb(255, 255, 224)",lime:"rgb( 0, 255, 0)",limegreen:"rgb( 50, 205, 50)",linen:"rgb(250, 240, 230)",magenta:"rgb(255, 0, 255)",maroon:"rgb(128, 0, 0)",mediumaquamarine:"rgb(102, 205, 170)",mediumblue:"rgb( 0, 0, 205)",mediumorchid:"rgb(186, 85, 211)",mediumpurple:"rgb(147, 112, 219)",mediumseagreen:"rgb( 60, 179, 113)",mediumslateblue:"rgb(123, 104, 238)",mediumspringgreen:"rgb( 0, 250, 154)",mediumturquoise:"rgb( 72, 209, 204)",mediumvioletred:"rgb(199, 21, 133)",midnightblue:"rgb( 25, 25, 112)",mintcream:"rgb(245, 255, 250)",mistyrose:"rgb(255, 228, 225)",moccasin:"rgb(255, 228, 181)",navajowhite:"rgb(255, 222, 173)",navy:"rgb( 0, 0, 128)",oldlace:"rgb(253, 245, 230)",olive:"rgb(128, 128, 0)",olivedrab:"rgb(107, 142, 35)",orange:"rgb(255, 165, 0)",orangered:"rgb(255, 69, 0)",orchid:"rgb(218, 112, 214)",palegoldenrod:"rgb(238, 232, 170)",palegreen:"rgb(152, 251, 152)",paleturquoise:"rgb(175, 238, 238)",palevioletred:"rgb(219, 112, 147)",papayawhip:"rgb(255, 239, 213)",peachpuff:"rgb(255, 218, 185)",peru:"rgb(205, 133, 63)",pink:"rgb(255, 192, 203)",plum:"rgb(221, 160, 221)",powderblue:"rgb(176, 224, 230)",purple:"rgb(128, 0, 128)",red:"rgb(255, 0, 0)",rosybrown:"rgb(188, 143, 143)",royalblue:"rgb( 65, 105, 225)",saddlebrown:"rgb(139, 69, 19)",salmon:"rgb(250, 128, 114)",sandybrown:"rgb(244, 164, 96)",seagreen:"rgb( 46, 139, 87)",seashell:"rgb(255, 245, 238)",sienna:"rgb(160, 82, 45)",silver:"rgb(192, 192, 192)",skyblue:"rgb(135, 206, 235)",slateblue:"rgb(106, 90, 205)",slategray:"rgb(112, 128, 144)",slategrey:"rgb(112, 128, 144)",snow:"rgb(255, 250, 250)",springgreen:"rgb( 0, 255, 127)",steelblue:"rgb( 70, 130, 180)",tan:"rgb(210, 180, 140)",teal:"rgb( 0, 128, 128)",thistle:"rgb(216, 191, 216)",tomato:"rgb(255, 99, 71)",turquoise:"rgb( 64, 224, 208)",violet:"rgb(238, 130, 238)",wheat:"rgb(245, 222, 179)",white:"rgb(255, 255, 255)",whitesmoke:"rgb(245, 245, 245)",yellow:"rgb(255, 255, 0)",yellowgreen:"rgb(154, 205, 50)"};G.jqplot.AxisLabelRenderer=function(aa){G.jqplot.ElemContainer.call(this);this.axis;this.show=true;this.label="";this.fontFamily=null;this.fontSize=null;this.textColor=null;this._elem;this.escapeHTML=false;G.extend(true,this,aa)};G.jqplot.AxisLabelRenderer.prototype=new G.jqplot.ElemContainer();G.jqplot.AxisLabelRenderer.prototype.constructor=G.jqplot.AxisLabelRenderer;G.jqplot.AxisLabelRenderer.prototype.init=function(aa){G.extend(true,this,aa)};G.jqplot.AxisLabelRenderer.prototype.draw=function(aa,ab){if(this._elem){this._elem.emptyForce();this._elem=null}this._elem=G('<div style="position:absolute;" class="jqplot-'+this.axis+'-label"></div>');if(Number(this.label)){this._elem.css("white-space","nowrap")}if(!this.escapeHTML){this._elem.html(this.label)}else{this._elem.text(this.label)}if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}if(this.fontSize){this._elem.css("font-size",this.fontSize)}if(this.textColor){this._elem.css("color",this.textColor)}return this._elem};G.jqplot.AxisLabelRenderer.prototype.pack=function(){};G.jqplot.AxisTickRenderer=function(aa){G.jqplot.ElemContainer.call(this);this.mark="outside";this.axis;this.showMark=true;this.showGridline=true;this.isMinorTick=false;this.size=4;this.markSize=6;this.show=true;this.showLabel=true;this.label=null;this.value=null;this._styles={};this.formatter=G.jqplot.DefaultTickFormatter;this.prefix="";this.formatString="";this.fontFamily;this.fontSize;this.textColor;this.escapeHTML=false;this._elem;this._breakTick=false;G.extend(true,this,aa)};G.jqplot.AxisTickRenderer.prototype.init=function(aa){G.extend(true,this,aa)};G.jqplot.AxisTickRenderer.prototype=new G.jqplot.ElemContainer();G.jqplot.AxisTickRenderer.prototype.constructor=G.jqplot.AxisTickRenderer;G.jqplot.AxisTickRenderer.prototype.setTick=function(aa,ac,ab){this.value=aa;this.axis=ac;if(ab){this.isMinorTick=true}return this};G.jqplot.AxisTickRenderer.prototype.draw=function(){if(this.label===null){this.label=this.prefix+this.formatter(this.formatString,this.value)}var ab={position:"absolute"};if(Number(this.label)){ab.whitSpace="nowrap"}if(this._elem){this._elem.emptyForce();this._elem=null}this._elem=G(document.createElement("div"));this._elem.addClass("jqplot-"+this.axis+"-tick");if(!this.escapeHTML){this._elem.html(this.label)}else{this._elem.text(this.label)}this._elem.css(ab);for(var aa in this._styles){this._elem.css(aa,this._styles[aa])}if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}if(this.fontSize){this._elem.css("font-size",this.fontSize)}if(this.textColor){this._elem.css("color",this.textColor)}if(this._breakTick){this._elem.addClass("jqplot-breakTick")}return this._elem};G.jqplot.DefaultTickFormatter=function(aa,ab){if(typeof ab=="number"){if(!aa){aa=G.jqplot.config.defaultTickFormatString}return G.jqplot.sprintf(aa,ab)}else{return String(ab)}};G.jqplot.AxisTickRenderer.prototype.pack=function(){};G.jqplot.CanvasGridRenderer=function(){this.shadowRenderer=new G.jqplot.ShadowRenderer()};G.jqplot.CanvasGridRenderer.prototype.init=function(ab){this._ctx;G.extend(true,this,ab);var aa={lineJoin:"miter",lineCap:"round",fill:false,isarc:false,angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.shadowWidth,closePath:false,strokeStyle:this.shadowColor};this.renderer.shadowRenderer.init(aa)};G.jqplot.CanvasGridRenderer.prototype.createElement=function(ad){var ac;if(this._elem){if(G.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==q){ac=this._elem.get(0);window.G_vmlCanvasManager.uninitElement(ac);ac=null}this._elem.emptyForce();this._elem=null}ac=ad.canvasManager.getCanvas();var aa=this._plotDimensions.width;var ab=this._plotDimensions.height;ac.width=aa;ac.height=ab;this._elem=G(ac);this._elem.addClass("jqplot-grid-canvas");this._elem.css({position:"absolute",left:0,top:0});ac=ad.canvasManager.initCanvas(ac);this._top=this._offsets.top;this._bottom=ab-this._offsets.bottom;this._left=this._offsets.left;this._right=aa-this._offsets.right;this._width=this._right-this._left;this._height=this._bottom-this._top;ac=null;return this._elem};G.jqplot.CanvasGridRenderer.prototype.draw=function(){this._ctx=this._elem.get(0).getContext("2d");var al=this._ctx;var ao=this._axes;al.save();al.clearRect(0,0,this._plotDimensions.width,this._plotDimensions.height);al.fillStyle=this.backgroundColor||this.background;al.fillRect(this._left,this._top,this._width,this._height);al.save();al.lineJoin="miter";al.lineCap="butt";al.lineWidth=this.gridLineWidth;al.strokeStyle=this.gridLineColor;var ar,aq,ai,aj;var af=["xaxis","yaxis","x2axis","y2axis"];for(var ap=4;ap>0;ap--){var av=af[ap-1];var aa=ao[av];var at=aa._ticks;var ak=at.length;if(aa.show){if(aa.drawBaseline){var au={};if(aa.baselineWidth!==null){au.lineWidth=aa.baselineWidth}if(aa.baselineColor!==null){au.strokeStyle=aa.baselineColor}switch(av){case"xaxis":ah(this._left,this._bottom,this._right,this._bottom,au);break;case"yaxis":ah(this._left,this._bottom,this._left,this._top,au);break;case"x2axis":ah(this._left,this._bottom,this._right,this._bottom,au);break;case"y2axis":ah(this._right,this._bottom,this._right,this._top,au);break}}for(var am=ak;am>0;am--){var ag=at[am-1];if(ag.show){var ad=Math.round(aa.u2p(ag.value))+0.5;switch(av){case"xaxis":if(ag.showGridline&&this.drawGridlines&&((!ag.isMinorTick&&aa.drawMajorGridlines)||(ag.isMinorTick&&aa.drawMinorGridlines))){ah(ad,this._top,ad,this._bottom)}if(ag.showMark&&ag.mark&&((!ag.isMinorTick&&aa.drawMajorTickMarks)||(ag.isMinorTick&&aa.drawMinorTickMarks))){ai=ag.markSize;aj=ag.mark;var ad=Math.round(aa.u2p(ag.value))+0.5;switch(aj){case"outside":ar=this._bottom;aq=this._bottom+ai;break;case"inside":ar=this._bottom-ai;aq=this._bottom;break;case"cross":ar=this._bottom-ai;aq=this._bottom+ai;break;default:ar=this._bottom;aq=this._bottom+ai;break}if(this.shadow){this.renderer.shadowRenderer.draw(al,[[ad,ar],[ad,aq]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false})}ah(ad,ar,ad,aq)}break;case"yaxis":if(ag.showGridline&&this.drawGridlines&&((!ag.isMinorTick&&aa.drawMajorGridlines)||(ag.isMinorTick&&aa.drawMinorGridlines))){ah(this._right,ad,this._left,ad)}if(ag.showMark&&ag.mark&&((!ag.isMinorTick&&aa.drawMajorTickMarks)||(ag.isMinorTick&&aa.drawMinorTickMarks))){ai=ag.markSize;aj=ag.mark;var ad=Math.round(aa.u2p(ag.value))+0.5;switch(aj){case"outside":ar=this._left-ai;aq=this._left;break;case"inside":ar=this._left;aq=this._left+ai;break;case"cross":ar=this._left-ai;aq=this._left+ai;break;default:ar=this._left-ai;aq=this._left;break}if(this.shadow){this.renderer.shadowRenderer.draw(al,[[ar,ad],[aq,ad]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}ah(ar,ad,aq,ad,{strokeStyle:aa.borderColor})}break;case"x2axis":if(ag.showGridline&&this.drawGridlines&&((!ag.isMinorTick&&aa.drawMajorGridlines)||(ag.isMinorTick&&aa.drawMinorGridlines))){ah(ad,this._bottom,ad,this._top)}if(ag.showMark&&ag.mark&&((!ag.isMinorTick&&aa.drawMajorTickMarks)||(ag.isMinorTick&&aa.drawMinorTickMarks))){ai=ag.markSize;aj=ag.mark;var ad=Math.round(aa.u2p(ag.value))+0.5;switch(aj){case"outside":ar=this._top-ai;aq=this._top;break;case"inside":ar=this._top;aq=this._top+ai;break;case"cross":ar=this._top-ai;aq=this._top+ai;break;default:ar=this._top-ai;aq=this._top;break}if(this.shadow){this.renderer.shadowRenderer.draw(al,[[ad,ar],[ad,aq]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false})}ah(ad,ar,ad,aq)}break;case"y2axis":if(ag.showGridline&&this.drawGridlines&&((!ag.isMinorTick&&aa.drawMajorGridlines)||(ag.isMinorTick&&aa.drawMinorGridlines))){ah(this._left,ad,this._right,ad)}if(ag.showMark&&ag.mark&&((!ag.isMinorTick&&aa.drawMajorTickMarks)||(ag.isMinorTick&&aa.drawMinorTickMarks))){ai=ag.markSize;aj=ag.mark;var ad=Math.round(aa.u2p(ag.value))+0.5;switch(aj){case"outside":ar=this._right;aq=this._right+ai;break;case"inside":ar=this._right-ai;aq=this._right;break;case"cross":ar=this._right-ai;aq=this._right+ai;break;default:ar=this._right;aq=this._right+ai;break}if(this.shadow){this.renderer.shadowRenderer.draw(al,[[ar,ad],[aq,ad]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}ah(ar,ad,aq,ad,{strokeStyle:aa.borderColor})}break;default:break}}}ag=null}aa=null;at=null}af=["y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis","yMidAxis"];for(var ap=7;ap>0;ap--){var aa=ao[af[ap-1]];var at=aa._ticks;if(aa.show){var ab=at[aa.numberTicks-1];var ae=at[0];var ac=aa.getLeft();var an=[[ac,ab.getTop()+ab.getHeight()/2],[ac,ae.getTop()+ae.getHeight()/2+1]];if(this.shadow){this.renderer.shadowRenderer.draw(al,an,{lineCap:"butt",fill:false,closePath:false})}ah(an[0][0],an[0][1],an[1][0],an[1][1],{lineCap:"butt",strokeStyle:aa.borderColor,lineWidth:aa.borderWidth});for(var am=at.length;am>0;am--){var ag=at[am-1];ai=ag.markSize;aj=ag.mark;var ad=Math.round(aa.u2p(ag.value))+0.5;if(ag.showMark&&ag.mark){switch(aj){case"outside":ar=ac;aq=ac+ai;break;case"inside":ar=ac-ai;aq=ac;break;case"cross":ar=ac-ai;aq=ac+ai;break;default:ar=ac;aq=ac+ai;break}an=[[ar,ad],[aq,ad]];if(this.shadow){this.renderer.shadowRenderer.draw(al,an,{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}ah(ar,ad,aq,ad,{strokeStyle:aa.borderColor})}ag=null}ae=null}aa=null;at=null}al.restore();function ah(aA,az,ax,aw,ay){al.save();ay=ay||{};if(ay.lineWidth==null||ay.lineWidth!=0){G.extend(true,al,ay);al.beginPath();al.moveTo(aA,az);al.lineTo(ax,aw);al.stroke();al.restore()}}if(this.shadow){var an=[[this._left,this._bottom],[this._right,this._bottom],[this._right,this._top]];this.renderer.shadowRenderer.draw(al,an)}if(this.borderWidth!=0&&this.drawBorder){ah(this._left,this._top,this._right,this._top,{lineCap:"round",strokeStyle:ao.x2axis.borderColor,lineWidth:ao.x2axis.borderWidth});ah(this._right,this._top,this._right,this._bottom,{lineCap:"round",strokeStyle:ao.y2axis.borderColor,lineWidth:ao.y2axis.borderWidth});ah(this._right,this._bottom,this._left,this._bottom,{lineCap:"round",strokeStyle:ao.xaxis.borderColor,lineWidth:ao.xaxis.borderWidth});ah(this._left,this._bottom,this._left,this._top,{lineCap:"round",strokeStyle:ao.yaxis.borderColor,lineWidth:ao.yaxis.borderWidth})}al.restore();al=null;ao=null};G.jqplot.DivTitleRenderer=function(){};G.jqplot.DivTitleRenderer.prototype.init=function(aa){G.extend(true,this,aa)};G.jqplot.DivTitleRenderer.prototype.draw=function(){if(this._elem){this._elem.emptyForce();this._elem=null}var ad=this.renderer;var ac=document.createElement("div");this._elem=G(ac);this._elem.addClass("jqplot-title");if(!this.text){this.show=false;this._elem.height(0);this._elem.width(0)}else{if(this.text){var aa;if(this.color){aa=this.color}else{if(this.textColor){aa=this.textColor}}var ab={position:"absolute",top:"0px",left:"0px"};if(this._plotWidth){ab.width=this._plotWidth+"px"}if(this.fontSize){ab.fontSize=this.fontSize}if(typeof this.textAlign==="string"){ab.textAlign=this.textAlign}else{ab.textAlign="center"}if(aa){ab.color=aa}if(this.paddingBottom){ab.paddingBottom=this.paddingBottom}if(this.fontFamily){ab.fontFamily=this.fontFamily}this._elem.css(ab);if(this.escapeHtml){this._elem.text(this.text)}else{this._elem.html(this.text)}}}ac=null;return this._elem};G.jqplot.DivTitleRenderer.prototype.pack=function(){};var n=0.1;G.jqplot.LinePattern=function(ao,aj){var ai={dotted:[n,G.jqplot.config.dotGapLength],dashed:[G.jqplot.config.dashLength,G.jqplot.config.gapLength],solid:null};if(typeof aj==="string"){if(aj[0]==="."||aj[0]==="-"){var ap=aj;aj=[];for(var ah=0,ae=ap.length;ah<ae;ah++){if(ap[ah]==="."){aj.push(n)}else{if(ap[ah]==="-"){aj.push(G.jqplot.config.dashLength)}else{continue}}aj.push(G.jqplot.config.gapLength)}}else{aj=ai[aj]}}if(!(aj&&aj.length)){return ao}var ad=0;var ak=aj[0];var am=0;var al=0;var ag=0;var aa=0;var an=function(aq,ar){ao.moveTo(aq,ar);am=aq;al=ar;ag=aq;aa=ar};var ac=function(aq,ax){var av=ao.lineWidth;var at=aq-am;var ar=ax-al;var au=Math.sqrt(at*at+ar*ar);if((au>0)&&(av>0)){at/=au;ar/=au;while(true){var aw=av*ak;if(aw<au){am+=aw*at;al+=aw*ar;if((ad&1)==0){ao.lineTo(am,al)}else{ao.moveTo(am,al)}au-=aw;ad++;if(ad>=aj.length){ad=0}ak=aj[ad]}else{am=aq;al=ax;if((ad&1)==0){ao.lineTo(am,al)}else{ao.moveTo(am,al)}ak-=au/av;break}}}};var ab=function(){ao.beginPath()};var af=function(){ac(ag,aa)};return{moveTo:an,lineTo:ac,beginPath:ab,closePath:af}};G.jqplot.LineRenderer=function(){this.shapeRenderer=new G.jqplot.ShapeRenderer();this.shadowRenderer=new G.jqplot.ShadowRenderer()};G.jqplot.LineRenderer.prototype.init=function(ab,ag){ab=ab||{};this._type="line";this.renderer.smooth=false;this.renderer.tension=null;this.renderer.constrainSmoothing=true;this.renderer._smoothedData=[];this.renderer._smoothedPlotData=[];this.renderer._hiBandGridData=[];this.renderer._lowBandGridData=[];this.renderer._hiBandSmoothedData=[];this.renderer._lowBandSmoothedData=[];this.renderer.bandData=[];this.renderer.bands={show:false,hiData:[],lowData:[],color:this.color,showLines:false,fill:true,fillColor:null,_min:null,_max:null,interval:"3%"};var ae={highlightMouseOver:ab.highlightMouseOver,highlightMouseDown:ab.highlightMouseDown,highlightColor:ab.highlightColor};delete (ab.highlightMouseOver);delete (ab.highlightMouseDown);delete (ab.highlightColor);G.extend(true,this.renderer,ab);this.renderer.options=ab;if(this.renderer.bandData.length>1&&(!ab.bands||ab.bands.show==null)){this.renderer.bands.show=true}else{if(ab.bands&&ab.bands.show==null&&ab.bands.interval!=null){this.renderer.bands.show=true}}if(this.fill){this.renderer.bands.show=false}if(this.renderer.bands.show){this.renderer.initBands.call(this,this.renderer.options,ag)}if(this._stack){this.renderer.smooth=false}var af={lineJoin:this.lineJoin,lineCap:this.lineCap,fill:this.fill,isarc:false,strokeStyle:this.color,fillStyle:this.fillColor,lineWidth:this.lineWidth,linePattern:this.linePattern,closePath:this.fill};this.renderer.shapeRenderer.init(af);var ac=ab.shadowOffset;if(ac==null){if(this.lineWidth>2.5){ac=1.25*(1+(Math.atan((this.lineWidth/2.5))/0.785398163-1)*0.6)}else{ac=1.25*Math.atan((this.lineWidth/2.5))/0.785398163}}var aa={lineJoin:this.lineJoin,lineCap:this.lineCap,fill:this.fill,isarc:false,angle:this.shadowAngle,offset:ac,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.lineWidth,linePattern:this.linePattern,closePath:this.fill};this.renderer.shadowRenderer.init(aa);this._areaPoints=[];this._boundingBox=[[],[]];if(!this.isTrendline&&this.fill||this.renderer.bands.show){this.highlightMouseOver=true;this.highlightMouseDown=false;this.highlightColor=null;if(ae.highlightMouseDown&&ae.highlightMouseOver==null){ae.highlightMouseOver=false}G.extend(true,this,{highlightMouseOver:ae.highlightMouseOver,highlightMouseDown:ae.highlightMouseDown,highlightColor:ae.highlightColor});if(!this.highlightColor){var ad=(this.renderer.bands.show)?this.renderer.bands.fillColor:this.fillColor;this.highlightColor=G.jqplot.computeHighlightColors(ad)}if(this.highlighter){this.highlighter.show=false}}if(!this.isTrendline&&ag){ag.plugins.lineRenderer={};ag.postInitHooks.addOnce(u);ag.postDrawHooks.addOnce(Y);ag.eventListenerHooks.addOnce("jqplotMouseMove",f);ag.eventListenerHooks.addOnce("jqplotMouseDown",c);ag.eventListenerHooks.addOnce("jqplotMouseUp",X);ag.eventListenerHooks.addOnce("jqplotClick",e);ag.eventListenerHooks.addOnce("jqplotRightClick",o)}};G.jqplot.LineRenderer.prototype.initBands=function(ad,an){var ae=ad.bandData||[];var ag=this.renderer.bands;ag.hiData=[];ag.lowData=[];var au=this.data;ag._max=null;ag._min=null;if(ae.length==2){if(G.isArray(ae[0][0])){var ah;var aa=0,ak=0;for(var ao=0,al=ae[0].length;ao<al;ao++){ah=ae[0][ao];if((ah[1]!=null&&ah[1]>ag._max)||ag._max==null){ag._max=ah[1]}if((ah[1]!=null&&ah[1]<ag._min)||ag._min==null){ag._min=ah[1]}}for(var ao=0,al=ae[1].length;ao<al;ao++){ah=ae[1][ao];if((ah[1]!=null&&ah[1]>ag._max)||ag._max==null){ag._max=ah[1];ak=1}if((ah[1]!=null&&ah[1]<ag._min)||ag._min==null){ag._min=ah[1];aa=1}}if(ak===aa){ag.show=false}ag.hiData=ae[ak];ag.lowData=ae[aa]}else{if(ae[0].length===au.length&&ae[1].length===au.length){var ac=(ae[0][0]>ae[1][0])?0:1;var av=(ac)?0:1;for(var ao=0,al=au.length;ao<al;ao++){ag.hiData.push([au[ao][0],ae[ac][ao]]);ag.lowData.push([au[ao][0],ae[av][ao]])}}else{ag.show=false}}}else{if(ae.length>2&&!G.isArray(ae[0][0])){var ac=(ae[0][0]>ae[0][1])?0:1;var av=(ac)?0:1;for(var ao=0,al=ae.length;ao<al;ao++){ag.hiData.push([au[ao][0],ae[ao][ac]]);ag.lowData.push([au[ao][0],ae[ao][av]])}}else{var aj=ag.interval;var at=null;var ar=null;var ab=null;var am=null;if(G.isArray(aj)){at=aj[0];ar=aj[1]}else{at=aj}if(isNaN(at)){if(at.charAt(at.length-1)==="%"){ab="multiply";at=parseFloat(at)/100+1}}else{at=parseFloat(at);ab="add"}if(ar!==null&&isNaN(ar)){if(ar.charAt(ar.length-1)==="%"){am="multiply";ar=parseFloat(ar)/100+1}}else{if(ar!==null){ar=parseFloat(ar);am="add"}}if(at!==null){if(ar===null){ar=-at;am=ab;if(am==="multiply"){ar+=2}}if(at<ar){var ap=at;at=ar;ar=ap;ap=ab;ab=am;am=ap}for(var ao=0,al=au.length;ao<al;ao++){switch(ab){case"add":ag.hiData.push([au[ao][0],au[ao][1]+at]);break;case"multiply":ag.hiData.push([au[ao][0],au[ao][1]*at]);break}switch(am){case"add":ag.lowData.push([au[ao][0],au[ao][1]+ar]);break;case"multiply":ag.lowData.push([au[ao][0],au[ao][1]*ar]);break}}}else{ag.show=false}}}var af=ag.hiData;var ai=ag.lowData;for(var ao=0,al=af.length;ao<al;ao++){if((af[ao][1]!=null&&af[ao][1]>ag._max)||ag._max==null){ag._max=af[ao][1]}}for(var ao=0,al=ai.length;ao<al;ao++){if((ai[ao][1]!=null&&ai[ao][1]<ag._min)||ag._min==null){ag._min=ai[ao][1]}}if(ag.fillColor===null){var aq=G.jqplot.getColorComponents(ag.color);aq[3]=aq[3]*0.5;ag.fillColor="rgba("+aq[0]+", "+aq[1]+", "+aq[2]+", "+aq[3]+")"}};function F(ab,aa){return(3.4182054+aa)*Math.pow(ab,-0.3534992)}function j(ac,ab){var aa=Math.sqrt(Math.pow((ab[0]-ac[0]),2)+Math.pow((ab[1]-ac[1]),2));return 5.7648*Math.log(aa)+7.4456}function v(aa){var ab=(Math.exp(2*aa)-1)/(Math.exp(2*aa)+1);return ab}function E(aC){var al=this.renderer.smooth;var aw=this.canvas.getWidth();var ag=this._xaxis.series_p2u;var az=this._yaxis.series_p2u;var ay=null;var af=null;var ar=aC.length/aw;var ac=[];var aq=[];if(!isNaN(parseFloat(al))){ay=parseFloat(al)}else{ay=F(ar,0.5)}var ao=[];var ad=[];for(var ax=0,at=aC.length;ax<at;ax++){ao.push(aC[ax][1]);ad.push(aC[ax][0])}function an(aD,aE){if(aD-aE==0){return Math.pow(10,10)}else{return aD-aE}}var ap,ak,aj,ai;var aa=aC.length-1;for(var ae=1,au=aC.length;ae<au;ae++){var ab=[];var am=[];for(var av=0;av<2;av++){var ax=ae-1+av;if(ax==0||ax==aa){ab[av]=Math.pow(10,10)}else{if(ao[ax+1]-ao[ax]==0||ao[ax]-ao[ax-1]==0){ab[av]=0}else{if(((ad[ax+1]-ad[ax])/(ao[ax+1]-ao[ax])+(ad[ax]-ad[ax-1])/(ao[ax]-ao[ax-1]))==0){ab[av]=0}else{if((ao[ax+1]-ao[ax])*(ao[ax]-ao[ax-1])<0){ab[av]=0}else{ab[av]=2/(an(ad[ax+1],ad[ax])/(ao[ax+1]-ao[ax])+an(ad[ax],ad[ax-1])/(ao[ax]-ao[ax-1]))}}}}}if(ae==1){ab[0]=3/2*(ao[1]-ao[0])/an(ad[1],ad[0])-ab[1]/2}else{if(ae==aa){ab[1]=3/2*(ao[aa]-ao[aa-1])/an(ad[aa],ad[aa-1])-ab[0]/2}}am[0]=-2*(ab[1]+2*ab[0])/an(ad[ae],ad[ae-1])+6*(ao[ae]-ao[ae-1])/Math.pow(an(ad[ae],ad[ae-1]),2);am[1]=2*(2*ab[1]+ab[0])/an(ad[ae],ad[ae-1])-6*(ao[ae]-ao[ae-1])/Math.pow(an(ad[ae],ad[ae-1]),2);ai=1/6*(am[1]-am[0])/an(ad[ae],ad[ae-1]);aj=1/2*(ad[ae]*am[0]-ad[ae-1]*am[1])/an(ad[ae],ad[ae-1]);ak=(ao[ae]-ao[ae-1]-aj*(Math.pow(ad[ae],2)-Math.pow(ad[ae-1],2))-ai*(Math.pow(ad[ae],3)-Math.pow(ad[ae-1],3)))/an(ad[ae],ad[ae-1]);ap=ao[ae-1]-ak*ad[ae-1]-aj*Math.pow(ad[ae-1],2)-ai*Math.pow(ad[ae-1],3);var aB=(ad[ae]-ad[ae-1])/ay;var aA,ah;for(var av=0,at=ay;av<at;av++){aA=[];ah=ad[ae-1]+av*aB;aA.push(ah);aA.push(ap+ak*ah+aj*Math.pow(ah,2)+ai*Math.pow(ah,3));ac.push(aA);aq.push([ag(aA[0]),az(aA[1])])}}ac.push(aC[ax]);aq.push([ag(aC[ax][0]),az(aC[ax][1])]);return[ac,aq]}function A(ai){var ah=this.renderer.smooth;var aN=this.renderer.tension;var aa=this.canvas.getWidth();var aA=this._xaxis.series_p2u;var aj=this._yaxis.series_p2u;var aB=null;var aC=null;var aM=null;var aH=null;var aF=null;var al=null;var aK=null;var af=null;var aD,aE,aw,av,at,aq;var ad,ab,an,am;var au,ar,aG;var ao=[];var ac=[];var ae=ai.length/aa;var aL,ap,ay,az,ax;var ak=[];var ag=[];if(!isNaN(parseFloat(ah))){aB=parseFloat(ah)}else{aB=F(ae,0.5)}if(!isNaN(parseFloat(aN))){aN=parseFloat(aN)}for(var aJ=0,aI=ai.length-1;aJ<aI;aJ++){if(aN===null){al=Math.abs((ai[aJ+1][1]-ai[aJ][1])/(ai[aJ+1][0]-ai[aJ][0]));aL=0.3;ap=0.6;ay=(ap-aL)/2;az=2.5;ax=-1.4;af=al/az+ax;aH=ay*v(af)-ay*v(ax)+aL;if(aJ>0){aK=Math.abs((ai[aJ][1]-ai[aJ-1][1])/(ai[aJ][0]-ai[aJ-1][0]))}af=aK/az+ax;aF=ay*v(af)-ay*v(ax)+aL;aM=(aH+aF)/2}else{aM=aN}for(aD=0;aD<aB;aD++){aE=aD/aB;aw=(1+2*aE)*Math.pow((1-aE),2);av=aE*Math.pow((1-aE),2);at=Math.pow(aE,2)*(3-2*aE);aq=Math.pow(aE,2)*(aE-1);if(ai[aJ-1]){ad=aM*(ai[aJ+1][0]-ai[aJ-1][0]);ab=aM*(ai[aJ+1][1]-ai[aJ-1][1])}else{ad=aM*(ai[aJ+1][0]-ai[aJ][0]);ab=aM*(ai[aJ+1][1]-ai[aJ][1])}if(ai[aJ+2]){an=aM*(ai[aJ+2][0]-ai[aJ][0]);am=aM*(ai[aJ+2][1]-ai[aJ][1])}else{an=aM*(ai[aJ+1][0]-ai[aJ][0]);am=aM*(ai[aJ+1][1]-ai[aJ][1])}au=aw*ai[aJ][0]+at*ai[aJ+1][0]+av*ad+aq*an;ar=aw*ai[aJ][1]+at*ai[aJ+1][1]+av*ab+aq*am;aG=[au,ar];ak.push(aG);ag.push([aA(au),aj(ar)])}}ak.push(ai[aI]);ag.push([aA(ai[aI][0]),aj(ai[aI][1])]);return[ak,ag]}G.jqplot.LineRenderer.prototype.setGridData=function(ai){var ae=this._xaxis.series_u2p;var aa=this._yaxis.series_u2p;var af=this._plotData;var aj=this._prevPlotData;this.gridData=[];this._prevGridData=[];this.renderer._smoothedData=[];this.renderer._smoothedPlotData=[];this.renderer._hiBandGridData=[];this.renderer._lowBandGridData=[];this.renderer._hiBandSmoothedData=[];this.renderer._lowBandSmoothedData=[];var ad=this.renderer.bands;var ab=false;for(var ag=0,ac=this.data.length;ag<ac;ag++){if(af[ag][0]!=null&&af[ag][1]!=null){this.gridData.push([ae.call(this._xaxis,af[ag][0]),aa.call(this._yaxis,af[ag][1])])}else{if(af[ag][0]==null){ab=true;this.gridData.push([null,aa.call(this._yaxis,af[ag][1])])}else{if(af[ag][1]==null){ab=true;this.gridData.push([ae.call(this._xaxis,af[ag][0]),null])}}}if(aj[ag]!=null&&aj[ag][0]!=null&&aj[ag][1]!=null){this._prevGridData.push([ae.call(this._xaxis,aj[ag][0]),aa.call(this._yaxis,aj[ag][1])])}else{if(aj[ag]!=null&&aj[ag][0]==null){this._prevGridData.push([null,aa.call(this._yaxis,aj[ag][1])])}else{if(aj[ag]!=null&&aj[ag][0]!=null&&aj[ag][1]==null){this._prevGridData.push([ae.call(this._xaxis,aj[ag][0]),null])}}}}if(ab){this.renderer.smooth=false;if(this._type==="line"){ad.show=false}}if(this._type==="line"&&ad.show){for(var ag=0,ac=ad.hiData.length;ag<ac;ag++){this.renderer._hiBandGridData.push([ae.call(this._xaxis,ad.hiData[ag][0]),aa.call(this._yaxis,ad.hiData[ag][1])])}for(var ag=0,ac=ad.lowData.length;ag<ac;ag++){this.renderer._lowBandGridData.push([ae.call(this._xaxis,ad.lowData[ag][0]),aa.call(this._yaxis,ad.lowData[ag][1])])}}if(this._type==="line"&&this.renderer.smooth&&this.gridData.length>2){var ah;if(this.renderer.constrainSmoothing){ah=E.call(this,this.gridData);this.renderer._smoothedData=ah[0];this.renderer._smoothedPlotData=ah[1];if(ad.show){ah=E.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=ah[0];ah=E.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=ah[0]}ah=null}else{ah=A.call(this,this.gridData);this.renderer._smoothedData=ah[0];this.renderer._smoothedPlotData=ah[1];if(ad.show){ah=A.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=ah[0];ah=A.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=ah[0]}ah=null}}};G.jqplot.LineRenderer.prototype.makeGridData=function(ah,aj){var af=this._xaxis.series_u2p;var aa=this._yaxis.series_u2p;var ak=[];var ac=[];this.renderer._smoothedData=[];this.renderer._smoothedPlotData=[];this.renderer._hiBandGridData=[];this.renderer._lowBandGridData=[];this.renderer._hiBandSmoothedData=[];this.renderer._lowBandSmoothedData=[];var ae=this.renderer.bands;var ab=false;for(var ag=0;ag<ah.length;ag++){if(ah[ag][0]!=null&&ah[ag][1]!=null){ak.push([af.call(this._xaxis,ah[ag][0]),aa.call(this._yaxis,ah[ag][1])])}else{if(ah[ag][0]==null){ab=true;ak.push([null,aa.call(this._yaxis,ah[ag][1])])}else{if(ah[ag][1]==null){ab=true;ak.push([af.call(this._xaxis,ah[ag][0]),null])}}}}if(ab){this.renderer.smooth=false;if(this._type==="line"){ae.show=false}}if(this._type==="line"&&ae.show){for(var ag=0,ad=ae.hiData.length;ag<ad;ag++){this.renderer._hiBandGridData.push([af.call(this._xaxis,ae.hiData[ag][0]),aa.call(this._yaxis,ae.hiData[ag][1])])}for(var ag=0,ad=ae.lowData.length;ag<ad;ag++){this.renderer._lowBandGridData.push([af.call(this._xaxis,ae.lowData[ag][0]),aa.call(this._yaxis,ae.lowData[ag][1])])}}if(this._type==="line"&&this.renderer.smooth&&ak.length>2){var ai;if(this.renderer.constrainSmoothing){ai=E.call(this,ak);this.renderer._smoothedData=ai[0];this.renderer._smoothedPlotData=ai[1];if(ae.show){ai=E.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=ai[0];ai=E.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=ai[0]}ai=null}else{ai=A.call(this,ak);this.renderer._smoothedData=ai[0];this.renderer._smoothedPlotData=ai[1];if(ae.show){ai=A.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=ai[0];ai=A.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=ai[0]}ai=null}}return ak};G.jqplot.LineRenderer.prototype.draw=function(ap,aB,ab,au){var av;var aj=G.extend(true,{},ab);var ad=(aj.shadow!=q)?aj.shadow:this.shadow;var aC=(aj.showLine!=q)?aj.showLine:this.showLine;var at=(aj.fill!=q)?aj.fill:this.fill;var aa=(aj.fillAndStroke!=q)?aj.fillAndStroke:this.fillAndStroke;var ak,aq,an,ax;ap.save();if(aB.length){if(aC){if(at){if(this.fillToZero){var ay=this.negativeColor;if(!this.useNegativeColors){ay=aj.fillStyle}var ah=false;var ai=aj.fillStyle;if(aa){var aA=aB.slice(0)}if(this.index==0||!this._stack){var ao=[];var aE=(this.renderer.smooth)?this.renderer._smoothedPlotData:this._plotData;this._areaPoints=[];var az=this._yaxis.series_u2p(this.fillToValue);var ac=this._xaxis.series_u2p(this.fillToValue);aj.closePath=true;if(this.fillAxis=="y"){ao.push([aB[0][0],az]);this._areaPoints.push([aB[0][0],az]);for(var av=0;av<aB.length-1;av++){ao.push(aB[av]);this._areaPoints.push(aB[av]);if(aE[av][1]*aE[av+1][1]<0){if(aE[av][1]<0){ah=true;aj.fillStyle=ay}else{ah=false;aj.fillStyle=ai}var ag=aB[av][0]+(aB[av+1][0]-aB[av][0])*(az-aB[av][1])/(aB[av+1][1]-aB[av][1]);ao.push([ag,az]);this._areaPoints.push([ag,az]);if(ad){this.renderer.shadowRenderer.draw(ap,ao,aj)}this.renderer.shapeRenderer.draw(ap,ao,aj);ao=[[ag,az]]}}if(aE[aB.length-1][1]<0){ah=true;aj.fillStyle=ay}else{ah=false;aj.fillStyle=ai}ao.push(aB[aB.length-1]);this._areaPoints.push(aB[aB.length-1]);ao.push([aB[aB.length-1][0],az]);this._areaPoints.push([aB[aB.length-1][0],az])}if(ad){this.renderer.shadowRenderer.draw(ap,ao,aj)}this.renderer.shapeRenderer.draw(ap,ao,aj)}else{var am=this._prevGridData;for(var av=am.length;av>0;av--){aB.push(am[av-1])}if(ad){this.renderer.shadowRenderer.draw(ap,aB,aj)}this._areaPoints=aB;this.renderer.shapeRenderer.draw(ap,aB,aj)}}else{if(aa){var aA=aB.slice(0)}if(this.index==0||!this._stack){var ae=ap.canvas.height;aB.unshift([aB[0][0],ae]);var aw=aB.length;aB.push([aB[aw-1][0],ae])}else{var am=this._prevGridData;for(var av=am.length;av>0;av--){aB.push(am[av-1])}}this._areaPoints=aB;if(ad){this.renderer.shadowRenderer.draw(ap,aB,aj)}this.renderer.shapeRenderer.draw(ap,aB,aj)}if(aa){var ar=G.extend(true,{},aj,{fill:false,closePath:false});this.renderer.shapeRenderer.draw(ap,aA,ar);if(this.markerRenderer.show){if(this.renderer.smooth){aA=this.gridData}for(av=0;av<aA.length;av++){this.markerRenderer.draw(aA[av][0],aA[av][1],ap,aj.markerOptions)}}}}else{if(this.renderer.bands.show){var af;var aD=G.extend(true,{},aj);if(this.renderer.bands.showLines){af=(this.renderer.smooth)?this.renderer._hiBandSmoothedData:this.renderer._hiBandGridData;this.renderer.shapeRenderer.draw(ap,af,aj);af=(this.renderer.smooth)?this.renderer._lowBandSmoothedData:this.renderer._lowBandGridData;this.renderer.shapeRenderer.draw(ap,af,aD)}if(this.renderer.bands.fill){if(this.renderer.smooth){af=this.renderer._hiBandSmoothedData.concat(this.renderer._lowBandSmoothedData.reverse())}else{af=this.renderer._hiBandGridData.concat(this.renderer._lowBandGridData.reverse())}this._areaPoints=af;aD.closePath=true;aD.fill=true;aD.fillStyle=this.renderer.bands.fillColor;this.renderer.shapeRenderer.draw(ap,af,aD)}}if(ad){this.renderer.shadowRenderer.draw(ap,aB,aj)}this.renderer.shapeRenderer.draw(ap,aB,aj)}}var ak=an=aq=ax=null;for(av=0;av<this._areaPoints.length;av++){var al=this._areaPoints[av];if(ak>al[0]||ak==null){ak=al[0]}if(ax<al[1]||ax==null){ax=al[1]}if(an<al[0]||an==null){an=al[0]}if(aq>al[1]||aq==null){aq=al[1]}}if(this.type==="line"&&this.renderer.bands.show){ax=this._yaxis.series_u2p(this.renderer.bands._min);aq=this._yaxis.series_u2p(this.renderer.bands._max)}this._boundingBox=[[ak,ax],[an,aq]];if(this.markerRenderer.show&&!at){if(this.renderer.smooth){aB=this.gridData}for(av=0;av<aB.length;av++){if(aB[av][0]!=null&&aB[av][1]!=null){this.markerRenderer.draw(aB[av][0],aB[av][1],ap,aj.markerOptions)}}}}ap.restore()};G.jqplot.LineRenderer.prototype.drawShadow=function(aa,ac,ab){};function u(ad,ac,aa){for(var ab=0;ab<this.series.length;ab++){if(this.series[ab].renderer.constructor==G.jqplot.LineRenderer){if(this.series[ab].highlightMouseOver){this.series[ab].highlightMouseDown=false}}}}function Y(){if(this.plugins.lineRenderer&&this.plugins.lineRenderer.highlightCanvas){this.plugins.lineRenderer.highlightCanvas.resetCanvas();this.plugins.lineRenderer.highlightCanvas=null}this.plugins.lineRenderer.highlightedSeriesIndex=null;this.plugins.lineRenderer.highlightCanvas=new G.jqplot.GenericCanvas();this.eventCanvas._elem.before(this.plugins.lineRenderer.highlightCanvas.createElement(this._gridPadding,"jqplot-lineRenderer-highlight-canvas",this._plotDimensions,this));this.plugins.lineRenderer.highlightCanvas.setContext();this.eventCanvas._elem.bind("mouseleave",{plot:this},function(aa){U(aa.data.plot)})}function W(ag,af,ad,ac){var ab=ag.series[af];var aa=ag.plugins.lineRenderer.highlightCanvas;aa._ctx.clearRect(0,0,aa._ctx.canvas.width,aa._ctx.canvas.height);ab._highlightedPoint=ad;ag.plugins.lineRenderer.highlightedSeriesIndex=af;var ae={fillStyle:ab.highlightColor};if(ab.type==="line"&&ab.renderer.bands.show){ae.fill=true;ae.closePath=true}ab.renderer.shapeRenderer.draw(aa._ctx,ac,ae);aa=null}function U(ac){var aa=ac.plugins.lineRenderer.highlightCanvas;aa._ctx.clearRect(0,0,aa._ctx.canvas.width,aa._ctx.canvas.height);for(var ab=0;ab<ac.series.length;ab++){ac.series[ab]._highlightedPoint=null}ac.plugins.lineRenderer.highlightedSeriesIndex=null;ac.target.trigger("jqplotDataUnhighlight");aa=null}function f(ae,ad,ah,ag,af){if(ag){var ac=[ag.seriesIndex,ag.pointIndex,ag.data];var ab=jQuery.Event("jqplotDataMouseOver");ab.pageX=ae.pageX;ab.pageY=ae.pageY;af.target.trigger(ab,ac);if(af.series[ac[0]].highlightMouseOver&&!(ac[0]==af.plugins.lineRenderer.highlightedSeriesIndex)){var aa=jQuery.Event("jqplotDataHighlight");aa.pageX=ae.pageX;aa.pageY=ae.pageY;af.target.trigger(aa,ac);W(af,ag.seriesIndex,ag.pointIndex,ag.points)}}else{if(ag==null){U(af)}}}function c(ad,ac,ag,af,ae){if(af){var ab=[af.seriesIndex,af.pointIndex,af.data];if(ae.series[ab[0]].highlightMouseDown&&!(ab[0]==ae.plugins.lineRenderer.highlightedSeriesIndex)){var aa=jQuery.Event("jqplotDataHighlight");aa.pageX=ad.pageX;aa.pageY=ad.pageY;ae.target.trigger(aa,ab);W(ae,af.seriesIndex,af.pointIndex,af.points)}}else{if(af==null){U(ae)}}}function X(ac,ab,af,ae,ad){var aa=ad.plugins.lineRenderer.highlightedSeriesIndex;if(aa!=null&&ad.series[aa].highlightMouseDown){U(ad)}}function e(ad,ac,ag,af,ae){if(af){var ab=[af.seriesIndex,af.pointIndex,af.data];var aa=jQuery.Event("jqplotDataClick");aa.pageX=ad.pageX;aa.pageY=ad.pageY;ae.target.trigger(aa,ab)}}function o(ae,ad,ah,ag,af){if(ag){var ac=[ag.seriesIndex,ag.pointIndex,ag.data];var aa=af.plugins.lineRenderer.highlightedSeriesIndex;if(aa!=null&&af.series[aa].highlightMouseDown){U(af)}var ab=jQuery.Event("jqplotDataRightClick");ab.pageX=ae.pageX;ab.pageY=ae.pageY;af.target.trigger(ab,ac)}}G.jqplot.LinearAxisRenderer=function(){};G.jqplot.LinearAxisRenderer.prototype.init=function(aa){this.breakPoints=null;this.breakTickLabel="&asymp;";this.drawBaseline=true;this.baselineWidth=null;this.baselineColor=null;this.forceTickAt0=false;this.forceTickAt100=false;this.tickInset=0;this.minorTicks=0;this.alignTicks=false;this._autoFormatString="";this._overrideFormatString=false;this._scalefact=1;G.extend(true,this,aa);if(this.breakPoints){if(!G.isArray(this.breakPoints)){this.breakPoints=null}else{if(this.breakPoints.length<2||this.breakPoints[1]<=this.breakPoints[0]){this.breakPoints=null}}}if(this.numberTicks!=null&&this.numberTicks<2){this.numberTicks=2}this.resetDataBounds()};G.jqplot.LinearAxisRenderer.prototype.draw=function(aa,ah){if(this.show){this.renderer.createTicks.call(this,ah);var ag=0;var ab;if(this._elem){this._elem.emptyForce();this._elem=null}this._elem=G(document.createElement("div"));this._elem.addClass("jqplot-axis jqplot-"+this.name);this._elem.css("position","absolute");if(this.name=="xaxis"||this.name=="x2axis"){this._elem.width(this._plotDimensions.width)}else{this._elem.height(this._plotDimensions.height)}this.labelOptions.axis=this.name;this._label=new this.labelRenderer(this.labelOptions);if(this._label.show){var af=this._label.draw(aa,ah);af.appendTo(this._elem);af=null}var ae=this._ticks;var ad;for(var ac=0;ac<ae.length;ac++){ad=ae[ac];if(ad.show&&ad.showLabel&&(!ad.isMinorTick||this.showMinorTicks)){this._elem.append(ad.draw(aa,ah))}}ad=null;ae=null}return this._elem};G.jqplot.LinearAxisRenderer.prototype.reset=function(){this.min=this._options.min;this.max=this._options.max;this.tickInterval=this._options.tickInterval;this.numberTicks=this._options.numberTicks;this._autoFormatString="";if(this._overrideFormatString&&this.tickOptions&&this.tickOptions.formatString){this.tickOptions.formatString=""}};G.jqplot.LinearAxisRenderer.prototype.set=function(){var ah=0;var ac;var ab=0;var ag=0;var aa=(this._label==null)?false:this._label.show;if(this.show){var af=this._ticks;var ae;for(var ad=0;ad<af.length;ad++){ae=af[ad];if(!ae._breakTick&&ae.show&&ae.showLabel&&(!ae.isMinorTick||this.showMinorTicks)){if(this.name=="xaxis"||this.name=="x2axis"){ac=ae._elem.outerHeight(true)}else{ac=ae._elem.outerWidth(true)}if(ac>ah){ah=ac}}}ae=null;af=null;if(aa){ab=this._label._elem.outerWidth(true);ag=this._label._elem.outerHeight(true)}if(this.name=="xaxis"){ah=ah+ag;this._elem.css({height:ah+"px",left:"0px",bottom:"0px"})}else{if(this.name=="x2axis"){ah=ah+ag;this._elem.css({height:ah+"px",left:"0px",top:"0px"})}else{if(this.name=="yaxis"){ah=ah+ab;this._elem.css({width:ah+"px",left:"0px",top:"0px"});if(aa&&this._label.constructor==G.jqplot.AxisLabelRenderer){this._label._elem.css("width",ab+"px")}}else{ah=ah+ab;this._elem.css({width:ah+"px",right:"0px",top:"0px"});if(aa&&this._label.constructor==G.jqplot.AxisLabelRenderer){this._label._elem.css("width",ab+"px")}}}}}};G.jqplot.LinearAxisRenderer.prototype.createTicks=function(ac){var aM=this._ticks;var aC=this.ticks;var ar=this.name;var au=this._dataBounds;var aa,ag;var aY,aA;var ai,ah;var aW,aT;var az=this.min;var aX=this.max;var aP=this.numberTicks;var a2=this.tickInterval;if(aC.length){for(aT=0;aT<aC.length;aT++){var aG=aC[aT];var aN=new this.tickRenderer(this.tickOptions);if(G.isArray(aG)){aN.value=aG[0];if(this.breakPoints){if(aG[0]==this.breakPoints[0]){aN.label=this.breakTickLabel;aN._breakTick=true;aN.showGridline=false;aN.showMark=false}else{if(aG[0]>this.breakPoints[0]&&aG[0]<=this.breakPoints[1]){aN.show=false;aN.showGridline=false;aN.label=aG[1]}else{aN.label=aG[1]}}}else{aN.label=aG[1]}aN.setTick(aG[0],this.name);this._ticks.push(aN)}else{if(G.isPlainObject(aG)){G.extend(true,aN,aG);aN.axis=this.name;this._ticks.push(aN)}else{aN.value=aG;if(this.breakPoints){if(aG==this.breakPoints[0]){aN.label=this.breakTickLabel;aN._breakTick=true;aN.showGridline=false;aN.showMark=false}else{if(aG>this.breakPoints[0]&&aG<=this.breakPoints[1]){aN.show=false;aN.showGridline=false}}}aN.setTick(aG,this.name);this._ticks.push(aN)}}}this.numberTicks=aC.length;this.min=this._ticks[0].value;this.max=this._ticks[this.numberTicks-1].value;this.tickInterval=(this.max-this.min)/(this.numberTicks-1)}else{if(ar=="xaxis"||ar=="x2axis"){aa=this._plotDimensions.width}else{aa=this._plotDimensions.height}var ap=this.numberTicks;if(this.alignTicks){if(this.name==="x2axis"&&ac.axes.xaxis.show){ap=ac.axes.xaxis.numberTicks}else{if(this.name.charAt(0)==="y"&&this.name!=="yaxis"&&this.name!=="yMidAxis"&&ac.axes.yaxis.show){ap=ac.axes.yaxis.numberTicks}}}aY=((this.min!=null)?this.min:au.min);aA=((this.max!=null)?this.max:au.max);var an=aA-aY;var aL,aq;var al;if(this.tickOptions==null||!this.tickOptions.formatString){this._overrideFormatString=true}if(this.min==null&&this.max==null&&this.tickInterval==null&&!this.autoscale){if(this.forceTickAt0){if(aY>0){aY=0}if(aA<0){aA=0}}if(this.forceTickAt100){if(aY>100){aY=100}if(aA<100){aA=100}}var af=30;var aI=Math.max(aa,af+1);this._scalefact=(aI-af)/300;var aH=G.jqplot.LinearTickGenerator(aY,aA,this._scalefact,ap);var ao=aY+an*(this.padMin-1);var aJ=aA-an*(this.padMax-1);if(aY<ao||aA>aJ){ao=aY-an*(this.padMin-1);aJ=aA+an*(this.padMax-1);aH=G.jqplot.LinearTickGenerator(ao,aJ,this._scalefact,ap)}this.min=aH[0];this.max=aH[1];this.numberTicks=aH[2];this._autoFormatString=aH[3];this.tickInterval=aH[4]}else{if(aY==aA){var ab=0.05;if(aY>0){ab=Math.max(Math.log(aY)/Math.LN10,0.05)}aY-=ab;aA+=ab}if(this.autoscale&&this.min==null&&this.max==null){var ad,ae,ak;var av=false;var aF=false;var at={min:null,max:null,average:null,stddev:null};for(var aT=0;aT<this._series.length;aT++){var aO=this._series[aT];var aw=(aO.fillAxis=="x")?aO._xaxis.name:aO._yaxis.name;if(this.name==aw){var aK=aO._plotValues[aO.fillAxis];var ay=aK[0];var aU=aK[0];for(var aS=1;aS<aK.length;aS++){if(aK[aS]<ay){ay=aK[aS]}else{if(aK[aS]>aU){aU=aK[aS]}}}var am=(aU-ay)/aU;if(aO.renderer.constructor==G.jqplot.BarRenderer){if(ay>=0&&(aO.fillToZero||am>0.1)){av=true}else{av=false;if(aO.fill&&aO.fillToZero&&ay<0&&aU>0){aF=true}else{aF=false}}}else{if(aO.fill){if(ay>=0&&(aO.fillToZero||am>0.1)){av=true}else{if(ay<0&&aU>0&&aO.fillToZero){av=false;aF=true}else{av=false;aF=false}}}else{if(ay<0){av=false}}}}}if(av){this.numberTicks=2+Math.ceil((aa-(this.tickSpacing-1))/this.tickSpacing);this.min=0;az=0;ae=aA/(this.numberTicks-1);al=Math.pow(10,Math.abs(Math.floor(Math.log(ae)/Math.LN10)));if(ae/al==parseInt(ae/al,10)){ae+=al}this.tickInterval=Math.ceil(ae/al)*al;this.max=this.tickInterval*(this.numberTicks-1)}else{if(aF){this.numberTicks=2+Math.ceil((aa-(this.tickSpacing-1))/this.tickSpacing);var aB=Math.ceil(Math.abs(aY)/an*(this.numberTicks-1));var a1=this.numberTicks-1-aB;ae=Math.max(Math.abs(aY/aB),Math.abs(aA/a1));al=Math.pow(10,Math.abs(Math.floor(Math.log(ae)/Math.LN10)));this.tickInterval=Math.ceil(ae/al)*al;this.max=this.tickInterval*a1;this.min=-this.tickInterval*aB}else{if(this.numberTicks==null){if(this.tickInterval){this.numberTicks=3+Math.ceil(an/this.tickInterval)}else{this.numberTicks=2+Math.ceil((aa-(this.tickSpacing-1))/this.tickSpacing)}}if(this.tickInterval==null){ae=an/(this.numberTicks-1);if(ae<1){al=Math.pow(10,Math.abs(Math.floor(Math.log(ae)/Math.LN10)))}else{al=1}this.tickInterval=Math.ceil(ae*al*this.pad)/al}else{al=1/this.tickInterval}ad=this.tickInterval*(this.numberTicks-1);ak=(ad-an)/2;if(this.min==null){this.min=Math.floor(al*(aY-ak))/al}if(this.max==null){this.max=this.min+ad}}}var ax=G.jqplot.getSignificantFigures(this.tickInterval);var aE;if(ax.digitsLeft>=ax.significantDigits){aE="%d"}else{var al=Math.max(0,5-ax.digitsLeft);al=Math.min(al,ax.digitsRight);aE="%."+al+"f"}this._autoFormatString=aE}else{aL=(this.min!=null)?this.min:aY-an*(this.padMin-1);aq=(this.max!=null)?this.max:aA+an*(this.padMax-1);an=aq-aL;if(this.numberTicks==null){if(this.tickInterval!=null){this.numberTicks=Math.ceil((aq-aL)/this.tickInterval)+1}else{if(aa>100){this.numberTicks=parseInt(3+(aa-100)/75,10)}else{this.numberTicks=2}}}if(this.tickInterval==null){this.tickInterval=an/(this.numberTicks-1)}if(this.max==null){aq=aL+this.tickInterval*(this.numberTicks-1)}if(this.min==null){aL=aq-this.tickInterval*(this.numberTicks-1)}var ax=G.jqplot.getSignificantFigures(this.tickInterval);var aE;if(ax.digitsLeft>=ax.significantDigits){aE="%d"}else{var al=Math.max(0,5-ax.digitsLeft);al=Math.min(al,ax.digitsRight);aE="%."+al+"f"}this._autoFormatString=aE;this.min=aL;this.max=aq}if(this.renderer.constructor==G.jqplot.LinearAxisRenderer&&this._autoFormatString==""){an=this.max-this.min;var aZ=new this.tickRenderer(this.tickOptions);var aD=aZ.formatString||G.jqplot.config.defaultTickFormatString;var aD=aD.match(G.jqplot.sprintf.regex)[0];var aV=0;if(aD){if(aD.search(/[fFeEgGpP]/)>-1){var aR=aD.match(/\%\.(\d{0,})?[eEfFgGpP]/);if(aR){aV=parseInt(aR[1],10)}else{aV=6}}else{if(aD.search(/[di]/)>-1){aV=0}}var aj=Math.pow(10,-aV);if(this.tickInterval<aj){if(aP==null&&a2==null){this.tickInterval=aj;if(aX==null&&az==null){this.min=Math.floor(this._dataBounds.min/aj)*aj;if(this.min==this._dataBounds.min){this.min=this._dataBounds.min-this.tickInterval}this.max=Math.ceil(this._dataBounds.max/aj)*aj;if(this.max==this._dataBounds.max){this.max=this._dataBounds.max+this.tickInterval}var aQ=(this.max-this.min)/this.tickInterval;aQ=aQ.toFixed(11);aQ=Math.ceil(aQ);this.numberTicks=aQ+1}else{if(aX==null){var aQ=(this._dataBounds.max-this.min)/this.tickInterval;aQ=aQ.toFixed(11);this.numberTicks=Math.ceil(aQ)+2;this.max=this.min+this.tickInterval*(this.numberTicks-1)}else{if(az==null){var aQ=(this.max-this._dataBounds.min)/this.tickInterval;aQ=aQ.toFixed(11);this.numberTicks=Math.ceil(aQ)+2;this.min=this.max-this.tickInterval*(this.numberTicks-1)}else{this.numberTicks=Math.ceil((aX-az)/this.tickInterval)+1;this.min=Math.floor(az*Math.pow(10,aV))/Math.pow(10,aV);this.max=Math.ceil(aX*Math.pow(10,aV))/Math.pow(10,aV);this.numberTicks=Math.ceil((this.max-this.min)/this.tickInterval)+1}}}}}}}}if(this._overrideFormatString&&this._autoFormatString!=""){this.tickOptions=this.tickOptions||{};this.tickOptions.formatString=this._autoFormatString}var aN,a0;for(var aT=0;aT<this.numberTicks;aT++){aW=this.min+aT*this.tickInterval;aN=new this.tickRenderer(this.tickOptions);aN.setTick(aW,this.name);this._ticks.push(aN);if(aT<this.numberTicks-1){for(var aS=0;aS<this.minorTicks;aS++){aW+=this.tickInterval/(this.minorTicks+1);a0=G.extend(true,{},this.tickOptions,{name:this.name,value:aW,label:"",isMinorTick:true});aN=new this.tickRenderer(a0);this._ticks.push(aN)}}aN=null}}if(this.tickInset){this.min=this.min-this.tickInset*this.tickInterval;this.max=this.max+this.tickInset*this.tickInterval}aM=null};G.jqplot.LinearAxisRenderer.prototype.resetTickValues=function(ac){if(G.isArray(ac)&&ac.length==this._ticks.length){var ab;for(var aa=0;aa<ac.length;aa++){ab=this._ticks[aa];ab.value=ac[aa];ab.label=ab.formatter(ab.formatString,ac[aa]);ab.label=ab.prefix+ab.label;ab._elem.html(ab.label)}ab=null;this.min=G.jqplot.arrayMin(ac);this.max=G.jqplot.arrayMax(ac);this.pack()}};G.jqplot.LinearAxisRenderer.prototype.pack=function(ac,ab){ac=ac||{};ab=ab||this._offsets;var aq=this._ticks;var am=this.max;var al=this.min;var ah=ab.max;var af=ab.min;var aj=(this._label==null)?false:this._label.show;for(var ak in ac){this._elem.css(ak,ac[ak])}this._offsets=ab;var ad=ah-af;var ae=am-al;if(this.breakPoints){ae=ae-this.breakPoints[1]+this.breakPoints[0];this.p2u=function(at){return(at-af)*ae/ad+al};this.u2p=function(at){if(at>this.breakPoints[0]&&at<this.breakPoints[1]){at=this.breakPoints[0]}if(at<=this.breakPoints[0]){return(at-al)*ad/ae+af}else{return(at-this.breakPoints[1]+this.breakPoints[0]-al)*ad/ae+af}};if(this.name.charAt(0)=="x"){this.series_u2p=function(at){if(at>this.breakPoints[0]&&at<this.breakPoints[1]){at=this.breakPoints[0]}if(at<=this.breakPoints[0]){return(at-al)*ad/ae}else{return(at-this.breakPoints[1]+this.breakPoints[0]-al)*ad/ae}};this.series_p2u=function(at){return at*ae/ad+al}}else{this.series_u2p=function(at){if(at>this.breakPoints[0]&&at<this.breakPoints[1]){at=this.breakPoints[0]}if(at>=this.breakPoints[1]){return(at-am)*ad/ae}else{return(at+this.breakPoints[1]-this.breakPoints[0]-am)*ad/ae}};this.series_p2u=function(at){return at*ae/ad+am}}}else{this.p2u=function(at){return(at-af)*ae/ad+al};this.u2p=function(at){return(at-al)*ad/ae+af};if(this.name=="xaxis"||this.name=="x2axis"){this.series_u2p=function(at){return(at-al)*ad/ae};this.series_p2u=function(at){return at*ae/ad+al}}else{this.series_u2p=function(at){return(at-am)*ad/ae};this.series_p2u=function(at){return at*ae/ad+am}}}if(this.show){if(this.name=="xaxis"||this.name=="x2axis"){for(var an=0;an<aq.length;an++){var ai=aq[an];if(ai.show&&ai.showLabel){var aa;if(ai.constructor==G.jqplot.CanvasAxisTickRenderer&&ai.angle){var ap=(this.name=="xaxis")?1:-1;switch(ai.labelPosition){case"auto":if(ap*ai.angle<0){aa=-ai.getWidth()+ai._textRenderer.height*Math.sin(-ai._textRenderer.angle)/2}else{aa=-ai._textRenderer.height*Math.sin(ai._textRenderer.angle)/2}break;case"end":aa=-ai.getWidth()+ai._textRenderer.height*Math.sin(-ai._textRenderer.angle)/2;break;case"start":aa=-ai._textRenderer.height*Math.sin(ai._textRenderer.angle)/2;break;case"middle":aa=-ai.getWidth()/2+ai._textRenderer.height*Math.sin(-ai._textRenderer.angle)/2;break;default:aa=-ai.getWidth()/2+ai._textRenderer.height*Math.sin(-ai._textRenderer.angle)/2;break}}else{aa=-ai.getWidth()/2}var ar=this.u2p(ai.value)+aa+"px";ai._elem.css("left",ar);ai.pack()}}if(aj){var ag=this._label._elem.outerWidth(true);this._label._elem.css("left",af+ad/2-ag/2+"px");if(this.name=="xaxis"){this._label._elem.css("bottom","0px")}else{this._label._elem.css("top","0px")}this._label.pack()}}else{for(var an=0;an<aq.length;an++){var ai=aq[an];if(ai.show&&ai.showLabel){var aa;if(ai.constructor==G.jqplot.CanvasAxisTickRenderer&&ai.angle){var ap=(this.name=="yaxis")?1:-1;switch(ai.labelPosition){case"auto":case"end":if(ap*ai.angle<0){aa=-ai._textRenderer.height*Math.cos(-ai._textRenderer.angle)/2}else{aa=-ai.getHeight()+ai._textRenderer.height*Math.cos(ai._textRenderer.angle)/2}break;case"start":if(ai.angle>0){aa=-ai._textRenderer.height*Math.cos(-ai._textRenderer.angle)/2}else{aa=-ai.getHeight()+ai._textRenderer.height*Math.cos(ai._textRenderer.angle)/2}break;case"middle":aa=-ai.getHeight()/2;break;default:aa=-ai.getHeight()/2;break}}else{aa=-ai.getHeight()/2}var ar=this.u2p(ai.value)+aa+"px";ai._elem.css("top",ar);ai.pack()}}if(aj){var ao=this._label._elem.outerHeight(true);this._label._elem.css("top",ah-ad/2-ao/2+"px");if(this.name=="yaxis"){this._label._elem.css("left","0px")}else{this._label._elem.css("right","0px")}this._label.pack()}}}aq=null};function g(ab){var aa;ab=Math.abs(ab);if(ab>=10){aa="%d"}else{if(ab>1){if(ab===parseInt(ab)){aa="%d"}else{aa="%.1f"}}else{var ac=-Math.floor(Math.log(ab)/Math.LN10);aa="%."+ac+"f"}}return aa}var a=[0.1,0.2,0.3,0.4,0.5,0.8,1,2,3,4,5];var b=function(ab){var aa=a.indexOf(ab);if(aa>0){return a[aa-1]}else{return a[a.length-1]/100}};var h=function(ab){var aa=a.indexOf(ab);if(aa<a.length-1){return a[aa+1]}else{return a[0]*100}};function R(ab,ae){var ad=ab/(ae-1);var ac=Math.pow(10,Math.floor(Math.log(ad)/Math.LN10));var af=ad/ac;var aa;if(ac<1){if(af>5){aa=10*ac}else{if(af>2){aa=5*ac}else{if(af>1){aa=2*ac}else{aa=ac}}}}else{if(af>5){aa=10*ac}else{if(af>4){aa=5*ac}else{if(af>3){aa=4*ac}else{if(af>2){aa=3*ac}else{if(af>1){aa=2*ac}else{aa=ac}}}}}}return aa}function L(ab,aa){var ad=Math.floor(Math.log(ab)/Math.LN10);var af=Math.pow(10,ad);var ae=ab/af;var ac;ae=ae/aa;if(ae<=0.38){ac=0.1}else{if(ae<=1.6){ac=0.2}else{if(ae<=4){ac=0.5}else{if(ae<=8){ac=1}else{if(ae<=16){ac=2}else{ac=5}}}}}return ac*af}function s(ac,ab){var ae=Math.floor(Math.log(ac)/Math.LN10);var ag=Math.pow(10,ae);var af=ac/ag;var aa;var ad;af=af/ab;if(af<=0.38){ad=0.1}else{if(af<=1.6){ad=0.2}else{if(af<=4){ad=0.5}else{if(af<=8){ad=1}else{if(af<=16){ad=2}else{ad=5}}}}}aa=ad*ag;return[aa,ad,ag]}G.jqplot.LinearTickGenerator=function(af,ag,ac,ad){if(af===ag){ag=(ag)?0:1}ac=ac||1;if(ag<af){var ah=ag;ag=af;af=ah}var ab=[];var ai=L(ag-af,ac);if(ad==null){ab[0]=Math.floor(af/ai)*ai;ab[1]=Math.ceil(ag/ai)*ai;ab[2]=Math.round((ab[1]-ab[0])/ai+1);ab[3]=g(ai);ab[4]=ai}else{var ae=[];ae[0]=Math.floor(af/ai)*ai;ae[1]=Math.ceil(ag/ai)*ai;ae[2]=Math.round((ae[1]-ae[0])/ai+1);ae[3]=g(ai);ae[4]=ai;if(ae[2]===ad){ab=ae}else{var aa=R(ae[1]-ae[0],ad);ab[0]=ae[0];ab[2]=ad;ab[4]=aa;ab[3]=g(aa);ab[1]=ab[0]+(ab[2]-1)*ab[4]}}return ab};G.jqplot.LinearTickGenerator.bestLinearInterval=L;G.jqplot.LinearTickGenerator.bestInterval=R;G.jqplot.LinearTickGenerator.bestLinearComponents=s;G.jqplot.MarkerRenderer=function(aa){this.show=true;this.style="filledCircle";this.lineWidth=2;this.size=9;this.color="#666666";this.shadow=true;this.shadowAngle=45;this.shadowOffset=1;this.shadowDepth=3;this.shadowAlpha="0.07";this.shadowRenderer=new G.jqplot.ShadowRenderer();this.shapeRenderer=new G.jqplot.ShapeRenderer();G.extend(true,this,aa)};G.jqplot.MarkerRenderer.prototype.init=function(aa){G.extend(true,this,aa);var ac={angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,lineWidth:this.lineWidth,depth:this.shadowDepth,closePath:true};if(this.style.indexOf("filled")!=-1){ac.fill=true}if(this.style.indexOf("ircle")!=-1){ac.isarc=true;ac.closePath=false}this.shadowRenderer.init(ac);var ab={fill:false,isarc:false,strokeStyle:this.color,fillStyle:this.color,lineWidth:this.lineWidth,closePath:true};if(this.style.indexOf("filled")!=-1){ab.fill=true}if(this.style.indexOf("ircle")!=-1){ab.isarc=true;ab.closePath=false}this.shapeRenderer.init(ab)};G.jqplot.MarkerRenderer.prototype.drawDiamond=function(ac,ab,af,ae,ah){var aa=1.2;var ai=this.size/2/aa;var ag=this.size/2*aa;var ad=[[ac-ai,ab],[ac,ab+ag],[ac+ai,ab],[ac,ab-ag]];if(this.shadow){this.shadowRenderer.draw(af,ad)}this.shapeRenderer.draw(af,ad,ah)};G.jqplot.MarkerRenderer.prototype.drawPlus=function(ad,ac,ag,af,aj){var ab=1;var ak=this.size/2*ab;var ah=this.size/2*ab;var ai=[[ad,ac-ah],[ad,ac+ah]];var ae=[[ad+ak,ac],[ad-ak,ac]];var aa=G.extend(true,{},this.options,{closePath:false});if(this.shadow){this.shadowRenderer.draw(ag,ai,{closePath:false});this.shadowRenderer.draw(ag,ae,{closePath:false})}this.shapeRenderer.draw(ag,ai,aa);this.shapeRenderer.draw(ag,ae,aa)};G.jqplot.MarkerRenderer.prototype.drawX=function(ad,ac,ag,af,aj){var ab=1;var ak=this.size/2*ab;var ah=this.size/2*ab;var aa=G.extend(true,{},this.options,{closePath:false});var ai=[[ad-ak,ac-ah],[ad+ak,ac+ah]];var ae=[[ad-ak,ac+ah],[ad+ak,ac-ah]];if(this.shadow){this.shadowRenderer.draw(ag,ai,{closePath:false});this.shadowRenderer.draw(ag,ae,{closePath:false})}this.shapeRenderer.draw(ag,ai,aa);this.shapeRenderer.draw(ag,ae,aa)};G.jqplot.MarkerRenderer.prototype.drawDash=function(ac,ab,af,ae,ah){var aa=1;var ai=this.size/2*aa;var ag=this.size/2*aa;var ad=[[ac-ai,ab],[ac+ai,ab]];if(this.shadow){this.shadowRenderer.draw(af,ad)}this.shapeRenderer.draw(af,ad,ah)};G.jqplot.MarkerRenderer.prototype.drawLine=function(af,ae,aa,ad,ab){var ac=[af,ae];if(this.shadow){this.shadowRenderer.draw(aa,ac)}this.shapeRenderer.draw(aa,ac,ab)};G.jqplot.MarkerRenderer.prototype.drawSquare=function(ac,ab,af,ae,ah){var aa=1;var ai=this.size/2/aa;var ag=this.size/2*aa;var ad=[[ac-ai,ab-ag],[ac-ai,ab+ag],[ac+ai,ab+ag],[ac+ai,ab-ag]];if(this.shadow){this.shadowRenderer.draw(af,ad)}this.shapeRenderer.draw(af,ad,ah)};G.jqplot.MarkerRenderer.prototype.drawCircle=function(ab,ah,ad,ag,ae){var aa=this.size/2;var ac=2*Math.PI;var af=[ab,ah,aa,0,ac,true];if(this.shadow){this.shadowRenderer.draw(ad,af)}this.shapeRenderer.draw(ad,af,ae)};G.jqplot.MarkerRenderer.prototype.draw=function(aa,ad,ab,ac){ac=ac||{};if(ac.show==null||ac.show!=false){if(ac.color&&!ac.fillStyle){ac.fillStyle=ac.color}if(ac.color&&!ac.strokeStyle){ac.strokeStyle=ac.color}switch(this.style){case"diamond":this.drawDiamond(aa,ad,ab,false,ac);break;case"filledDiamond":this.drawDiamond(aa,ad,ab,true,ac);break;case"circle":this.drawCircle(aa,ad,ab,false,ac);break;case"filledCircle":this.drawCircle(aa,ad,ab,true,ac);break;case"square":this.drawSquare(aa,ad,ab,false,ac);break;case"filledSquare":this.drawSquare(aa,ad,ab,true,ac);break;case"x":this.drawX(aa,ad,ab,true,ac);break;case"plus":this.drawPlus(aa,ad,ab,true,ac);break;case"dash":this.drawDash(aa,ad,ab,true,ac);break;case"line":this.drawLine(aa,ad,ab,false,ac);break;default:this.drawDiamond(aa,ad,ab,false,ac);break}}};G.jqplot.ShadowRenderer=function(aa){this.angle=45;this.offset=1;this.alpha=0.07;this.lineWidth=1.5;this.lineJoin="miter";this.lineCap="round";this.closePath=false;this.fill=false;this.depth=3;this.strokeStyle="rgba(0,0,0,0.1)";this.isarc=false;G.extend(true,this,aa)};G.jqplot.ShadowRenderer.prototype.init=function(aa){G.extend(true,this,aa)};G.jqplot.ShadowRenderer.prototype.draw=function(an,al,ap){an.save();var aa=(ap!=null)?ap:{};var am=(aa.fill!=null)?aa.fill:this.fill;var ai=(aa.fillRect!=null)?aa.fillRect:this.fillRect;var ah=(aa.closePath!=null)?aa.closePath:this.closePath;var ae=(aa.offset!=null)?aa.offset:this.offset;var ac=(aa.alpha!=null)?aa.alpha:this.alpha;var ag=(aa.depth!=null)?aa.depth:this.depth;var ao=(aa.isarc!=null)?aa.isarc:this.isarc;var aj=(aa.linePattern!=null)?aa.linePattern:this.linePattern;an.lineWidth=(aa.lineWidth!=null)?aa.lineWidth:this.lineWidth;an.lineJoin=(aa.lineJoin!=null)?aa.lineJoin:this.lineJoin;an.lineCap=(aa.lineCap!=null)?aa.lineCap:this.lineCap;an.strokeStyle=aa.strokeStyle||this.strokeStyle||"rgba(0,0,0,"+ac+")";an.fillStyle=aa.fillStyle||this.fillStyle||"rgba(0,0,0,"+ac+")";for(var ad=0;ad<ag;ad++){var ak=G.jqplot.LinePattern(an,aj);an.translate(Math.cos(this.angle*Math.PI/180)*ae,Math.sin(this.angle*Math.PI/180)*ae);ak.beginPath();if(ao){an.arc(al[0],al[1],al[2],al[3],al[4],true)}else{if(ai){if(ai){an.fillRect(al[0],al[1],al[2],al[3])}}else{if(al&&al.length){var ab=true;for(var af=0;af<al.length;af++){if(al[af][0]!=null&&al[af][1]!=null){if(ab){ak.moveTo(al[af][0],al[af][1]);ab=false}else{ak.lineTo(al[af][0],al[af][1])}}else{ab=true}}}}}if(ah){ak.closePath()}if(am){an.fill()}else{an.stroke()}}an.restore()};G.jqplot.ShapeRenderer=function(aa){this.lineWidth=1.5;this.linePattern="solid";this.lineJoin="miter";this.lineCap="round";this.closePath=false;this.fill=false;this.isarc=false;this.fillRect=false;this.strokeRect=false;this.clearRect=false;this.strokeStyle="#999999";this.fillStyle="#999999";G.extend(true,this,aa)};G.jqplot.ShapeRenderer.prototype.init=function(aa){G.extend(true,this,aa)};G.jqplot.ShapeRenderer.prototype.draw=function(al,aj,an){al.save();var aa=(an!=null)?an:{};var ak=(aa.fill!=null)?aa.fill:this.fill;var af=(aa.closePath!=null)?aa.closePath:this.closePath;var ag=(aa.fillRect!=null)?aa.fillRect:this.fillRect;var ad=(aa.strokeRect!=null)?aa.strokeRect:this.strokeRect;var ab=(aa.clearRect!=null)?aa.clearRect:this.clearRect;var am=(aa.isarc!=null)?aa.isarc:this.isarc;var ah=(aa.linePattern!=null)?aa.linePattern:this.linePattern;var ai=G.jqplot.LinePattern(al,ah);al.lineWidth=aa.lineWidth||this.lineWidth;al.lineJoin=aa.lineJoin||this.lineJoin;al.lineCap=aa.lineCap||this.lineCap;al.strokeStyle=(aa.strokeStyle||aa.color)||this.strokeStyle;al.fillStyle=aa.fillStyle||this.fillStyle;al.beginPath();if(am){al.arc(aj[0],aj[1],aj[2],aj[3],aj[4],true);if(af){al.closePath()}if(ak){al.fill()}else{al.stroke()}al.restore();return}else{if(ab){al.clearRect(aj[0],aj[1],aj[2],aj[3]);al.restore();return}else{if(ag||ad){if(ag){al.fillRect(aj[0],aj[1],aj[2],aj[3])}if(ad){al.strokeRect(aj[0],aj[1],aj[2],aj[3]);al.restore();return}}else{if(aj&&aj.length){var ac=true;for(var ae=0;ae<aj.length;ae++){if(aj[ae][0]!=null&&aj[ae][1]!=null){if(ac){ai.moveTo(aj[ae][0],aj[ae][1]);ac=false}else{ai.lineTo(aj[ae][0],aj[ae][1])}}else{ac=true}}if(af){ai.closePath()}if(ak){al.fill()}else{al.stroke()}}}}}al.restore()};G.jqplot.TableLegendRenderer=function(){};G.jqplot.TableLegendRenderer.prototype.init=function(aa){G.extend(true,this,aa)};G.jqplot.TableLegendRenderer.prototype.addrow=function(aj,ad,aa,ah){var ae=(aa)?this.rowSpacing+"px":"0px";var ai;var ac;var ab;var ag;var af;ab=document.createElement("tr");ai=G(ab);ai.addClass("jqplot-table-legend");ab=null;if(ah){ai.prependTo(this._elem)}else{ai.appendTo(this._elem)}if(this.showSwatches){ac=G(document.createElement("td"));ac.addClass("jqplot-table-legend jqplot-table-legend-swatch");ac.css({textAlign:"center",paddingTop:ae});ag=G(document.createElement("div"));ag.addClass("jqplot-table-legend-swatch-outline");af=G(document.createElement("div"));af.addClass("jqplot-table-legend-swatch");af.css({backgroundColor:ad,borderColor:ad});ai.append(ac.append(ag.append(af)))}if(this.showLabels){ac=G(document.createElement("td"));ac.addClass("jqplot-table-legend jqplot-table-legend-label");ac.css("paddingTop",ae);ai.append(ac);if(this.escapeHtml){ac.text(aj)}else{ac.html(aj)}}ac=null;ag=null;af=null;ai=null;ab=null};G.jqplot.TableLegendRenderer.prototype.draw=function(){if(this._elem){this._elem.emptyForce();this._elem=null}if(this.show){var af=this._series;var ab=document.createElement("table");this._elem=G(ab);this._elem.addClass("jqplot-table-legend");var ak={position:"absolute"};if(this.background){ak.background=this.background}if(this.border){ak.border=this.border}if(this.fontSize){ak.fontSize=this.fontSize}if(this.fontFamily){ak.fontFamily=this.fontFamily}if(this.textColor){ak.textColor=this.textColor}if(this.marginTop!=null){ak.marginTop=this.marginTop}if(this.marginBottom!=null){ak.marginBottom=this.marginBottom}if(this.marginLeft!=null){ak.marginLeft=this.marginLeft}if(this.marginRight!=null){ak.marginRight=this.marginRight}var aa=false,ah=false,aj;for(var ag=0;ag<af.length;ag++){aj=af[ag];if(aj._stack||aj.renderer.constructor==G.jqplot.BezierCurveRenderer){ah=true}if(aj.show&&aj.showLabel){var ae=this.labels[ag]||aj.label.toString();if(ae){var ac=aj.color;if(ah&&ag<af.length-1){aa=true}else{if(ah&&ag==af.length-1){aa=false}}this.renderer.addrow.call(this,ae,ac,aa,ah);aa=true}for(var ad=0;ad<G.jqplot.addLegendRowHooks.length;ad++){var ai=G.jqplot.addLegendRowHooks[ad].call(this,aj);if(ai){this.renderer.addrow.call(this,ai.label,ai.color,aa);aa=true}}ae=null}}}return this._elem};G.jqplot.TableLegendRenderer.prototype.pack=function(ac){if(this.show){if(this.placement=="insideGrid"){switch(this.location){case"nw":var ab=ac.left;var aa=ac.top;this._elem.css("left",ab);this._elem.css("top",aa);break;case"n":var ab=(ac.left+(this._plotDimensions.width-ac.right))/2-this.getWidth()/2;var aa=ac.top;this._elem.css("left",ab);this._elem.css("top",aa);break;case"ne":var ab=ac.right;var aa=ac.top;this._elem.css({right:ab,top:aa});break;case"e":var ab=ac.right;var aa=(ac.top+(this._plotDimensions.height-ac.bottom))/2-this.getHeight()/2;this._elem.css({right:ab,top:aa});break;case"se":var ab=ac.right;var aa=ac.bottom;this._elem.css({right:ab,bottom:aa});break;case"s":var ab=(ac.left+(this._plotDimensions.width-ac.right))/2-this.getWidth()/2;var aa=ac.bottom;this._elem.css({left:ab,bottom:aa});break;case"sw":var ab=ac.left;var aa=ac.bottom;this._elem.css({left:ab,bottom:aa});break;case"w":var ab=ac.left;var aa=(ac.top+(this._plotDimensions.height-ac.bottom))/2-this.getHeight()/2;this._elem.css({left:ab,top:aa});break;default:var ab=ac.right;var aa=ac.bottom;this._elem.css({right:ab,bottom:aa});break}}else{if(this.placement=="outside"){switch(this.location){case"nw":var ab=this._plotDimensions.width-ac.left;var aa=ac.top;this._elem.css("right",ab);this._elem.css("top",aa);break;case"n":var ab=(ac.left+(this._plotDimensions.width-ac.right))/2-this.getWidth()/2;var aa=this._plotDimensions.height-ac.top;this._elem.css("left",ab);this._elem.css("bottom",aa);break;case"ne":var ab=this._plotDimensions.width-ac.right;var aa=ac.top;this._elem.css({left:ab,top:aa});break;case"e":var ab=this._plotDimensions.width-ac.right;var aa=(ac.top+(this._plotDimensions.height-ac.bottom))/2-this.getHeight()/2;this._elem.css({left:ab,top:aa});break;case"se":var ab=this._plotDimensions.width-ac.right;var aa=ac.bottom;this._elem.css({left:ab,bottom:aa});break;case"s":var ab=(ac.left+(this._plotDimensions.width-ac.right))/2-this.getWidth()/2;var aa=this._plotDimensions.height-ac.bottom;this._elem.css({left:ab,top:aa});break;case"sw":var ab=this._plotDimensions.width-ac.left;var aa=ac.bottom;this._elem.css({right:ab,bottom:aa});break;case"w":var ab=this._plotDimensions.width-ac.left;var aa=(ac.top+(this._plotDimensions.height-ac.bottom))/2-this.getHeight()/2;this._elem.css({right:ab,top:aa});break;default:var ab=ac.right;var aa=ac.bottom;this._elem.css({right:ab,bottom:aa});break}}else{switch(this.location){case"nw":this._elem.css({left:0,top:ac.top});break;case"n":var ab=(ac.left+(this._plotDimensions.width-ac.right))/2-this.getWidth()/2;this._elem.css({left:ab,top:ac.top});break;case"ne":this._elem.css({right:0,top:ac.top});break;case"e":var aa=(ac.top+(this._plotDimensions.height-ac.bottom))/2-this.getHeight()/2;this._elem.css({right:ac.right,top:aa});break;case"se":this._elem.css({right:ac.right,bottom:ac.bottom});break;case"s":var ab=(ac.left+(this._plotDimensions.width-ac.right))/2-this.getWidth()/2;this._elem.css({left:ab,bottom:ac.bottom});break;case"sw":this._elem.css({left:ac.left,bottom:ac.bottom});break;case"w":var aa=(ac.top+(this._plotDimensions.height-ac.bottom))/2-this.getHeight()/2;this._elem.css({left:ac.left,top:aa});break;default:this._elem.css({right:ac.right,bottom:ac.bottom});break}}}}};G.jqplot.ThemeEngine=function(){this.themes={};this.activeTheme=null};G.jqplot.ThemeEngine.prototype.init=function(){var ad=new G.jqplot.Theme({_name:"Default"});var ag,ab,af;for(ag in ad.target){if(ag=="textColor"){ad.target[ag]=this.target.css("color")}else{ad.target[ag]=this.target.css(ag)}}if(this.title.show&&this.title._elem){for(ag in ad.title){if(ag=="textColor"){ad.title[ag]=this.title._elem.css("color")}else{ad.title[ag]=this.title._elem.css(ag)}}}for(ag in ad.grid){ad.grid[ag]=this.grid[ag]}if(ad.grid.backgroundColor==null&&this.grid.background!=null){ad.grid.backgroundColor=this.grid.background}if(this.legend.show&&this.legend._elem){for(ag in ad.legend){if(ag=="textColor"){ad.legend[ag]=this.legend._elem.css("color")}else{ad.legend[ag]=this.legend._elem.css(ag)}}}var ac;for(ab=0;ab<this.series.length;ab++){ac=this.series[ab];if(ac.renderer.constructor==G.jqplot.LineRenderer){ad.series.push(new l())}else{if(ac.renderer.constructor==G.jqplot.BarRenderer){ad.series.push(new O())}else{if(ac.renderer.constructor==G.jqplot.PieRenderer){ad.series.push(new d())}else{if(ac.renderer.constructor==G.jqplot.DonutRenderer){ad.series.push(new B())}else{if(ac.renderer.constructor==G.jqplot.FunnelRenderer){ad.series.push(new T())}else{if(ac.renderer.constructor==G.jqplot.MeterGaugeRenderer){ad.series.push(new y())}else{ad.series.push({})}}}}}}for(ag in ad.series[ab]){ad.series[ab][ag]=ac[ag]}}var aa,ae;for(ag in this.axes){ae=this.axes[ag];aa=ad.axes[ag]=new K();aa.borderColor=ae.borderColor;aa.borderWidth=ae.borderWidth;if(ae._ticks&&ae._ticks[0]){for(af in aa.ticks){if(ae._ticks[0].hasOwnProperty(af)){aa.ticks[af]=ae._ticks[0][af]}else{if(ae._ticks[0]._elem){aa.ticks[af]=ae._ticks[0]._elem.css(af)}}}}if(ae._label&&ae._label.show){for(af in aa.label){if(ae._label[af]){aa.label[af]=ae._label[af]}else{if(ae._label._elem){if(af=="textColor"){aa.label[af]=ae._label._elem.css("color")}else{aa.label[af]=ae._label._elem.css(af)}}}}}}this.themeEngine._add(ad);this.themeEngine.activeTheme=this.themeEngine.themes[ad._name]};G.jqplot.ThemeEngine.prototype.get=function(aa){if(!aa){return this.activeTheme}else{return this.themes[aa]}};function J(ab,aa){return ab-aa}G.jqplot.ThemeEngine.prototype.getThemeNames=function(){var aa=[];for(var ab in this.themes){aa.push(ab)}return aa.sort(J)};G.jqplot.ThemeEngine.prototype.getThemes=function(){var ab=[];var aa=[];for(var ad in this.themes){ab.push(ad)}ab.sort(J);for(var ac=0;ac<ab.length;ac++){aa.push(this.themes[ab[ac]])}return aa};G.jqplot.ThemeEngine.prototype.activate=function(an,at){var aa=false;if(!at&&this.activeTheme&&this.activeTheme._name){at=this.activeTheme._name}if(!this.themes.hasOwnProperty(at)){throw new Error("No theme of that name")}else{var af=this.themes[at];this.activeTheme=af;var ar,al=false,ak=false;var ab=["xaxis","x2axis","yaxis","y2axis"];for(ao=0;ao<ab.length;ao++){var ag=ab[ao];if(af.axesStyles.borderColor!=null){an.axes[ag].borderColor=af.axesStyles.borderColor}if(af.axesStyles.borderWidth!=null){an.axes[ag].borderWidth=af.axesStyles.borderWidth}}for(var aq in an.axes){var ad=an.axes[aq];if(ad.show){var aj=af.axes[aq]||{};var ah=af.axesStyles;var ae=G.jqplot.extend(true,{},aj,ah);ar=(af.axesStyles.borderColor!=null)?af.axesStyles.borderColor:ae.borderColor;if(ae.borderColor!=null){ad.borderColor=ae.borderColor;aa=true}ar=(af.axesStyles.borderWidth!=null)?af.axesStyles.borderWidth:ae.borderWidth;if(ae.borderWidth!=null){ad.borderWidth=ae.borderWidth;aa=true}if(ad._ticks&&ad._ticks[0]){for(var ac in ae.ticks){ar=ae.ticks[ac];if(ar!=null){ad.tickOptions[ac]=ar;ad._ticks=[];aa=true}}}if(ad._label&&ad._label.show){for(var ac in ae.label){ar=ae.label[ac];if(ar!=null){ad.labelOptions[ac]=ar;aa=true}}}}}for(var am in af.grid){if(af.grid[am]!=null){an.grid[am]=af.grid[am]}}if(!aa){an.grid.draw()}if(an.legend.show){for(am in af.legend){if(af.legend[am]!=null){an.legend[am]=af.legend[am]}}}if(an.title.show){for(am in af.title){if(af.title[am]!=null){an.title[am]=af.title[am]}}}var ao;for(ao=0;ao<af.series.length;ao++){var ai={};var ap=false;for(am in af.series[ao]){ar=(af.seriesStyles[am]!=null)?af.seriesStyles[am]:af.series[ao][am];if(ar!=null){ai[am]=ar;if(am=="color"){an.series[ao].renderer.shapeRenderer.fillStyle=ar;an.series[ao].renderer.shapeRenderer.strokeStyle=ar;an.series[ao][am]=ar}else{if((am=="lineWidth")||(am=="linePattern")){an.series[ao].renderer.shapeRenderer[am]=ar;an.series[ao][am]=ar}else{if(am=="markerOptions"){Q(an.series[ao].markerOptions,ar);Q(an.series[ao].markerRenderer,ar)}else{an.series[ao][am]=ar}}}aa=true}}}if(aa){an.target.empty();an.draw()}for(am in af.target){if(af.target[am]!=null){an.target.css(am,af.target[am])}}}};G.jqplot.ThemeEngine.prototype._add=function(ab,aa){if(aa){ab._name=aa}if(!ab._name){ab._name=Date.parse(new Date())}if(!this.themes.hasOwnProperty(ab._name)){this.themes[ab._name]=ab}else{throw new Error("jqplot.ThemeEngine Error: Theme already in use")}};G.jqplot.ThemeEngine.prototype.remove=function(aa){if(aa=="Default"){return false}return delete this.themes[aa]};G.jqplot.ThemeEngine.prototype.newTheme=function(aa,ac){if(typeof(aa)=="object"){ac=ac||aa;aa=null}if(ac&&ac._name){aa=ac._name}else{aa=aa||Date.parse(new Date())}var ab=this.copy(this.themes.Default._name,aa);G.jqplot.extend(ab,ac);return ab};function w(ac){if(ac==null||typeof(ac)!="object"){return ac}var aa=new ac.constructor();for(var ab in ac){aa[ab]=w(ac[ab])}return aa}G.jqplot.clone=w;function Q(ac,ab){if(ab==null||typeof(ab)!="object"){return}for(var aa in ab){if(aa=="highlightColors"){ac[aa]=w(ab[aa])}if(ab[aa]!=null&&typeof(ab[aa])=="object"){if(!ac.hasOwnProperty(aa)){ac[aa]={}}Q(ac[aa],ab[aa])}else{ac[aa]=ab[aa]}}}G.jqplot.merge=Q;G.jqplot.extend=function(){var af=arguments[0]||{},ad=1,ae=arguments.length,aa=false,ac;if(typeof af==="boolean"){aa=af;af=arguments[1]||{};ad=2}if(typeof af!=="object"&&!toString.call(af)==="[object Function]"){af={}}for(;ad<ae;ad++){if((ac=arguments[ad])!=null){for(var ab in ac){var ag=af[ab],ah=ac[ab];if(af===ah){continue}if(aa&&ah&&typeof ah==="object"&&!ah.nodeType){af[ab]=G.jqplot.extend(aa,ag||(ah.length!=null?[]:{}),ah)}else{if(ah!==q){af[ab]=ah}}}}}return af};G.jqplot.ThemeEngine.prototype.rename=function(ab,aa){if(ab=="Default"||aa=="Default"){throw new Error("jqplot.ThemeEngine Error: Cannot rename from/to Default")}if(this.themes.hasOwnProperty(aa)){throw new Error("jqplot.ThemeEngine Error: New name already in use.")}else{if(this.themes.hasOwnProperty(ab)){var ac=this.copy(ab,aa);this.remove(ab);return ac}}throw new Error("jqplot.ThemeEngine Error: Old name or new name invalid")};G.jqplot.ThemeEngine.prototype.copy=function(aa,ac,ae){if(ac=="Default"){throw new Error("jqplot.ThemeEngine Error: Cannot copy over Default theme")}if(!this.themes.hasOwnProperty(aa)){var ab="jqplot.ThemeEngine Error: Source name invalid";throw new Error(ab)}if(this.themes.hasOwnProperty(ac)){var ab="jqplot.ThemeEngine Error: Target name invalid";throw new Error(ab)}else{var ad=w(this.themes[aa]);ad._name=ac;G.jqplot.extend(true,ad,ae);this._add(ad);return ad}};G.jqplot.Theme=function(aa,ab){if(typeof(aa)=="object"){ab=ab||aa;aa=null}aa=aa||Date.parse(new Date());this._name=aa;this.target={backgroundColor:null};this.legend={textColor:null,fontFamily:null,fontSize:null,border:null,background:null};this.title={textColor:null,fontFamily:null,fontSize:null,textAlign:null};this.seriesStyles={};this.series=[];this.grid={drawGridlines:null,gridLineColor:null,gridLineWidth:null,backgroundColor:null,borderColor:null,borderWidth:null,shadow:null};this.axesStyles={label:{},ticks:{}};this.axes={};if(typeof(ab)=="string"){this._name=ab}else{if(typeof(ab)=="object"){G.jqplot.extend(true,this,ab)}}};var K=function(){this.borderColor=null;this.borderWidth=null;this.ticks=new k();this.label=new p()};var k=function(){this.show=null;this.showGridline=null;this.showLabel=null;this.showMark=null;this.size=null;this.textColor=null;this.whiteSpace=null;this.fontSize=null;this.fontFamily=null};var p=function(){this.textColor=null;this.whiteSpace=null;this.fontSize=null;this.fontFamily=null;this.fontWeight=null};var l=function(){this.color=null;this.lineWidth=null;this.linePattern=null;this.shadow=null;this.fillColor=null;this.showMarker=null;this.markerOptions=new D()};var D=function(){this.show=null;this.style=null;this.lineWidth=null;this.size=null;this.color=null;this.shadow=null};var O=function(){this.color=null;this.seriesColors=null;this.lineWidth=null;this.shadow=null;this.barPadding=null;this.barMargin=null;this.barWidth=null;this.highlightColors=null};var d=function(){this.seriesColors=null;this.padding=null;this.sliceMargin=null;this.fill=null;this.shadow=null;this.startAngle=null;this.lineWidth=null;this.highlightColors=null};var B=function(){this.seriesColors=null;this.padding=null;this.sliceMargin=null;this.fill=null;this.shadow=null;this.startAngle=null;this.lineWidth=null;this.innerDiameter=null;this.thickness=null;this.ringMargin=null;this.highlightColors=null};var T=function(){this.color=null;this.lineWidth=null;this.shadow=null;this.padding=null;this.sectionMargin=null;this.seriesColors=null;this.highlightColors=null};var y=function(){this.padding=null;this.backgroundColor=null;this.ringColor=null;this.tickColor=null;this.ringWidth=null;this.intervalColors=null;this.intervalInnerRadius=null;this.intervalOuterRadius=null;this.hubRadius=null;this.needleThickness=null;this.needlePad=null};G.fn.jqplotChildText=function(){return G(this).contents().filter(function(){return this.nodeType==3}).text()};G.fn.jqplotGetComputedFontStyle=function(){var ad=window.getComputedStyle?window.getComputedStyle(this[0]):this[0].currentStyle;var ab=ad["font-style"]?["font-style","font-weight","font-size","font-family"]:["fontStyle","fontWeight","fontSize","fontFamily"];var ae=[];for(var ac=0;ac<ab.length;++ac){var aa=String(ad[ab[ac]]);if(aa&&aa!="normal"){ae.push(aa)}}return ae.join(" ")};G.fn.jqplotToImageCanvas=function(ac){ac=ac||{};var an=(ac.x_offset==null)?0:ac.x_offset;var ap=(ac.y_offset==null)?0:ac.y_offset;var ae=(ac.backgroundColor==null)?"rgb(255,255,255)":ac.backgroundColor;if(G(this).width()==0||G(this).height()==0){return null}if(!G.jqplot.support_canvas){return null}var ag=document.createElement("canvas");var at=G(this).outerHeight(true);var al=G(this).outerWidth(true);var af=G(this).offset();var ah=af.left;var aj=af.top;var am=0,ak=0;var aq=["jqplot-table-legend","jqplot-xaxis-tick","jqplot-x2axis-tick","jqplot-yaxis-tick","jqplot-y2axis-tick","jqplot-y3axis-tick","jqplot-y4axis-tick","jqplot-y5axis-tick","jqplot-y6axis-tick","jqplot-y7axis-tick","jqplot-y8axis-tick","jqplot-y9axis-tick","jqplot-xaxis-label","jqplot-x2axis-label","jqplot-yaxis-label","jqplot-y2axis-label","jqplot-y3axis-label","jqplot-y4axis-label","jqplot-y5axis-label","jqplot-y6axis-label","jqplot-y7axis-label","jqplot-y8axis-label","jqplot-y9axis-label"];var ai,aa,ab,au;for(var ar in aq){G(this).find("."+aq[ar]).each(function(){ai=G(this).offset().top-aj;aa=G(this).offset().left-ah;au=aa+G(this).outerWidth(true)+am;ab=ai+G(this).outerHeight(true)+ak;if(aa<-am){al=al-am-aa;am=-aa}if(ai<-ak){at=at-ak-ai;ak=-ai}if(au>al){al=au}if(ab>at){at=ab}})}ag.width=al+Number(an);ag.height=at+Number(ap);var ad=ag.getContext("2d");ad.save();ad.fillStyle=ae;ad.fillRect(0,0,ag.width,ag.height);ad.restore();ad.translate(am,ak);ad.textAlign="left";ad.textBaseline="top";function av(ax){var ay=parseInt(G(ax).css("line-height"));if(isNaN(ay)){ay=parseInt(G(ax).css("font-size"))*1.2}return ay}function aw(ay,ax,aL,az,aH,aA){var aJ=av(ay);var aD=G(ay).innerWidth();var aE=G(ay).innerHeight();var aG=aL.split(/\s+/);var aK=aG.length;var aI="";var aF=[];var aN=aH;var aM=az;for(var aC=0;aC<aK;aC++){aI+=aG[aC];if(ax.measureText(aI).width>aD){aF.push(aC);aI=""}}if(aF.length===0){if(G(ay).css("textAlign")==="center"){aM=az+(aA-ax.measureText(aI).width)/2-am}ax.fillText(aL,aM,aH)}else{aI=aG.slice(0,aF[0]).join(" ");if(G(ay).css("textAlign")==="center"){aM=az+(aA-ax.measureText(aI).width)/2-am}ax.fillText(aI,aM,aN);aN+=aJ;for(var aC=1,aB=aF.length;aC<aB;aC++){aI=aG.slice(aF[aC-1],aF[aC]).join(" ");if(G(ay).css("textAlign")==="center"){aM=az+(aA-ax.measureText(aI).width)/2-am}ax.fillText(aI,aM,aN);aN+=aJ}aI=aG.slice(aF[aC-1],aG.length).join(" ");if(G(ay).css("textAlign")==="center"){aM=az+(aA-ax.measureText(aI).width)/2-am}ax.fillText(aI,aM,aN)}}function ao(az,aC,ax){var aG=az.tagName.toLowerCase();var ay=G(az).position();var aD=window.getComputedStyle?window.getComputedStyle(az):az.currentStyle;var aB=aC+ay.left+parseInt(aD.marginLeft)+parseInt(aD.borderLeftWidth)+parseInt(aD.paddingLeft);var aE=ax+ay.top+parseInt(aD.marginTop)+parseInt(aD.borderTopWidth)+parseInt(aD.paddingTop);var aF=ag.width;if((aG=="div"||aG=="span")&&!G(az).hasClass("jqplot-highlighter-tooltip")){G(az).children().each(function(){ao(this,aB,aE)});var aH=G(az).jqplotChildText();if(aH){ad.font=G(az).jqplotGetComputedFontStyle();ad.fillStyle=G(az).css("color");aw(az,ad,aH,aB,aE,aF)}}else{if(aG==="table"&&G(az).hasClass("jqplot-table-legend")){ad.strokeStyle=G(az).css("border-top-color");ad.fillStyle=G(az).css("background-color");ad.fillRect(aB,aE,G(az).innerWidth(),G(az).innerHeight());if(parseInt(G(az).css("border-top-width"))>0){ad.strokeRect(aB,aE,G(az).innerWidth(),G(az).innerHeight())}G(az).find("div.jqplot-table-legend-swatch-outline").each(function(){var aN=G(this);ad.strokeStyle=aN.css("border-top-color");var aJ=aB+aN.position().left;var aK=aE+aN.position().top;ad.strokeRect(aJ,aK,aN.innerWidth(),aN.innerHeight());aJ+=parseInt(aN.css("padding-left"));aK+=parseInt(aN.css("padding-top"));var aM=aN.innerHeight()-2*parseInt(aN.css("padding-top"));var aI=aN.innerWidth()-2*parseInt(aN.css("padding-left"));var aL=aN.children("div.jqplot-table-legend-swatch");ad.fillStyle=aL.css("background-color");ad.fillRect(aJ,aK,aI,aM)});G(az).find("td.jqplot-table-legend-label").each(function(){var aK=G(this);var aI=aB+aK.position().left;var aJ=aE+aK.position().top+parseInt(aK.css("padding-top"));ad.font=aK.jqplotGetComputedFontStyle();ad.fillStyle=aK.css("color");ad.fillText(aK.text(),aI,aJ)});var aA=null}else{if(aG=="canvas"){ad.drawImage(az,aB,aE)}}}}G(this).children().each(function(){ao(this,an,ap)});return ag};G.fn.jqplotToImageStr=function(ab){var aa=G(this).jqplotToImageCanvas(ab);if(aa){return aa.toDataURL("image/png")}else{return null}};G.fn.jqplotToImageElem=function(aa){var ab=document.createElement("img");var ac=G(this).jqplotToImageStr(aa);ab.src=ac;return ab};G.fn.jqplotToImageElemStr=function(aa){var ab="<img src="+G(this).jqplotToImageStr(aa)+" />";return ab};G.fn.jqplotSaveImage=function(){var aa=G(this).jqplotToImageStr({});if(aa){window.location.href=aa.replace("image/png","image/octet-stream")}};G.fn.jqplotViewImage=function(){var ab=G(this).jqplotToImageElemStr({});var ac=G(this).jqplotToImageStr({});if(ab){var aa=window.open("");aa.document.open("image/png");aa.document.write(ab);aa.document.close();aa=null}};var Z=function(){this.syntax=Z.config.syntax;this._type="jsDate";this.utcOffset=new Date().getTimezoneOffset*60000;this.proxy=new Date();this.options={};this.locale=Z.regional.getLocale();this.formatString="";this.defaultCentury=Z.config.defaultCentury;switch(arguments.length){case 0:break;case 1:if(i(arguments[0])=="[object Object]"&&arguments[0]._type!="jsDate"){var ac=this.options=arguments[0];this.syntax=ac.syntax||this.syntax;this.defaultCentury=ac.defaultCentury||this.defaultCentury;this.proxy=Z.createDate(ac.date)}else{this.proxy=Z.createDate(arguments[0])}break;default:var aa=[];for(var ab=0;ab<arguments.length;ab++){aa.push(arguments[ab])}this.proxy=new Date(this.utcOffset);this.proxy.setFullYear.apply(this.proxy,aa.slice(0,3));if(aa.slice(3).length){this.proxy.setHours.apply(this.proxy,aa.slice(3))}break}};Z.config={defaultLocale:"en",syntax:"perl",defaultCentury:1900};Z.prototype.add=function(ac,ab){var aa=z[ab]||z.day;if(typeof aa=="number"){this.proxy.setTime(this.proxy.getTime()+(aa*ac))}else{aa.add(this,ac)}return this};Z.prototype.clone=function(){return new Z(this.proxy.getTime())};Z.prototype.diff=function(ab,ae,aa){ab=new Z(ab);if(ab===null){return null}var ac=z[ae]||z.day;if(typeof ac=="number"){var ad=(this.proxy.getTime()-ab.proxy.getTime())/ac}else{var ad=ac.diff(this.proxy,ab.proxy)}return(aa?ad:Math[ad>0?"floor":"ceil"](ad))};Z.prototype.getAbbrDayName=function(){return Z.regional[this.locale]["dayNamesShort"][this.proxy.getDay()]};Z.prototype.getAbbrMonthName=function(){return Z.regional[this.locale]["monthNamesShort"][this.proxy.getMonth()]};Z.prototype.getAMPM=function(){return this.proxy.getHours()>=12?"PM":"AM"};Z.prototype.getAmPm=function(){return this.proxy.getHours()>=12?"pm":"am"};Z.prototype.getCentury=function(){return parseInt(this.proxy.getFullYear()/100,10)};Z.prototype.getDate=function(){return this.proxy.getDate()};Z.prototype.getDay=function(){return this.proxy.getDay()};Z.prototype.getDayOfWeek=function(){var aa=this.proxy.getDay();return aa===0?7:aa};Z.prototype.getDayOfYear=function(){var ab=this.proxy;var aa=ab-new Date(""+ab.getFullYear()+"/1/1 GMT");aa+=ab.getTimezoneOffset()*60000;ab=null;return parseInt(aa/60000/60/24,10)+1};Z.prototype.getDayName=function(){return Z.regional[this.locale]["dayNames"][this.proxy.getDay()]};Z.prototype.getFullWeekOfYear=function(){var ad=this.proxy;var aa=this.getDayOfYear();var ac=6-ad.getDay();var ab=parseInt((aa+ac)/7,10);return ab};Z.prototype.getFullYear=function(){return this.proxy.getFullYear()};Z.prototype.getGmtOffset=function(){var aa=this.proxy.getTimezoneOffset()/60;var ab=aa<0?"+":"-";aa=Math.abs(aa);return ab+I(Math.floor(aa),2)+":"+I((aa%1)*60,2)};Z.prototype.getHours=function(){return this.proxy.getHours()};Z.prototype.getHours12=function(){var aa=this.proxy.getHours();return aa>12?aa-12:(aa==0?12:aa)};Z.prototype.getIsoWeek=function(){var ad=this.proxy;var ac=ad.getWeekOfYear();var aa=(new Date(""+ad.getFullYear()+"/1/1")).getDay();var ab=ac+(aa>4||aa<=1?0:1);if(ab==53&&(new Date(""+ad.getFullYear()+"/12/31")).getDay()<4){ab=1}else{if(ab===0){ad=new Z(new Date(""+(ad.getFullYear()-1)+"/12/31"));ab=ad.getIsoWeek()}}ad=null;return ab};Z.prototype.getMilliseconds=function(){return this.proxy.getMilliseconds()};Z.prototype.getMinutes=function(){return this.proxy.getMinutes()};Z.prototype.getMonth=function(){return this.proxy.getMonth()};Z.prototype.getMonthName=function(){return Z.regional[this.locale]["monthNames"][this.proxy.getMonth()]};Z.prototype.getMonthNumber=function(){return this.proxy.getMonth()+1};Z.prototype.getSeconds=function(){return this.proxy.getSeconds()};Z.prototype.getShortYear=function(){return this.proxy.getYear()%100};Z.prototype.getTime=function(){return this.proxy.getTime()};Z.prototype.getTimezoneAbbr=function(){return this.proxy.toString().replace(/^.*\(([^)]+)\)$/,"$1")};Z.prototype.getTimezoneName=function(){var aa=/(?:\((.+)\)$| ([A-Z]{3}) )/.exec(this.toString());return aa[1]||aa[2]||"GMT"+this.getGmtOffset()};Z.prototype.getTimezoneOffset=function(){return this.proxy.getTimezoneOffset()};Z.prototype.getWeekOfYear=function(){var aa=this.getDayOfYear();var ac=7-this.getDayOfWeek();var ab=parseInt((aa+ac)/7,10);return ab};Z.prototype.getUnix=function(){return Math.round(this.proxy.getTime()/1000,0)};Z.prototype.getYear=function(){return this.proxy.getYear()};Z.prototype.next=function(aa){aa=aa||"day";return this.clone().add(1,aa)};Z.prototype.set=function(){switch(arguments.length){case 0:this.proxy=new Date();break;case 1:if(i(arguments[0])=="[object Object]"&&arguments[0]._type!="jsDate"){var ac=this.options=arguments[0];this.syntax=ac.syntax||this.syntax;this.defaultCentury=ac.defaultCentury||this.defaultCentury;this.proxy=Z.createDate(ac.date)}else{this.proxy=Z.createDate(arguments[0])}break;default:var aa=[];for(var ab=0;ab<arguments.length;ab++){aa.push(arguments[ab])}this.proxy=new Date(this.utcOffset);this.proxy.setFullYear.apply(this.proxy,aa.slice(0,3));if(aa.slice(3).length){this.proxy.setHours.apply(this.proxy,aa.slice(3))}break}};Z.prototype.setDate=function(aa){return this.proxy.setDate(aa)};Z.prototype.setFullYear=function(){return this.proxy.setFullYear.apply(this.proxy,arguments)};Z.prototype.setHours=function(){return this.proxy.setHours.apply(this.proxy,arguments)};Z.prototype.setMilliseconds=function(aa){return this.proxy.setMilliseconds(aa)};Z.prototype.setMinutes=function(){return this.proxy.setMinutes.apply(this.proxy,arguments)};Z.prototype.setMonth=function(){return this.proxy.setMonth.apply(this.proxy,arguments)};Z.prototype.setSeconds=function(){return this.proxy.setSeconds.apply(this.proxy,arguments)};Z.prototype.setTime=function(aa){return this.proxy.setTime(aa)};Z.prototype.setYear=function(){return this.proxy.setYear.apply(this.proxy,arguments)};Z.prototype.strftime=function(aa){aa=aa||this.formatString||Z.regional[this.locale]["formatString"];return Z.strftime(this,aa,this.syntax)};Z.prototype.toString=function(){return this.proxy.toString()};Z.prototype.toYmdInt=function(){return(this.proxy.getFullYear()*10000)+(this.getMonthNumber()*100)+this.proxy.getDate()};Z.regional={en:{monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],monthNamesShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],dayNames:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],dayNamesShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],formatString:"%Y-%m-%d %H:%M:%S"},fr:{monthNames:["Janvier","Février","Mars","Avril","Mai","Juin","Juillet","Août","Septembre","Octobre","Novembre","Décembre"],monthNamesShort:["Jan","Fév","Mar","Avr","Mai","Jun","Jul","Aoû","Sep","Oct","Nov","Déc"],dayNames:["Dimanche","Lundi","Mardi","Mercredi","Jeudi","Vendredi","Samedi"],dayNamesShort:["Dim","Lun","Mar","Mer","Jeu","Ven","Sam"],formatString:"%Y-%m-%d %H:%M:%S"},de:{monthNames:["Januar","Februar","März","April","Mai","Juni","Juli","August","September","Oktober","November","Dezember"],monthNamesShort:["Jan","Feb","Mär","Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Dez"],dayNames:["Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"],dayNamesShort:["So","Mo","Di","Mi","Do","Fr","Sa"],formatString:"%Y-%m-%d %H:%M:%S"},es:{monthNames:["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"],monthNamesShort:["Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic"],dayNames:["Domingo","Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado"],dayNamesShort:["Dom","Lun","Mar","Mi&eacute;","Juv","Vie","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"},ru:{monthNames:["Январь","Февраль","Март","Апрель","Май","Июнь","Июль","Август","Сентябрь","Октябрь","Ноябрь","Декабрь"],monthNamesShort:["Янв","Фев","Мар","Апр","Май","Июн","Июл","Авг","Сен","Окт","Ноя","Дек"],dayNames:["воскресенье","понедельник","вторник","среда","четверг","пятница","суббота"],dayNamesShort:["вск","пнд","втр","срд","чтв","птн","сбт"],formatString:"%Y-%m-%d %H:%M:%S"},ar:{monthNames:["كانون الثاني","شباط","آذار","نيسان","آذار","حزيران","تموز","آب","أيلول","تشرين الأول","تشرين الثاني","كانون الأول"],monthNamesShort:["1","2","3","4","5","6","7","8","9","10","11","12"],dayNames:["السبت","الأحد","الاثنين","الثلاثاء","الأربعاء","الخميس","الجمعة"],dayNamesShort:["سبت","أحد","اثنين","ثلاثاء","أربعاء","خميس","جمعة"],formatString:"%Y-%m-%d %H:%M:%S"},pt:{monthNames:["Janeiro","Fevereiro","Mar&ccedil;o","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],monthNamesShort:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"],dayNames:["Domingo","Segunda-feira","Ter&ccedil;a-feira","Quarta-feira","Quinta-feira","Sexta-feira","S&aacute;bado"],dayNamesShort:["Dom","Seg","Ter","Qua","Qui","Sex","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"},"pt-BR":{monthNames:["Janeiro","Fevereiro","Mar&ccedil;o","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],monthNamesShort:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"],dayNames:["Domingo","Segunda-feira","Ter&ccedil;a-feira","Quarta-feira","Quinta-feira","Sexta-feira","S&aacute;bado"],dayNamesShort:["Dom","Seg","Ter","Qua","Qui","Sex","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"}};Z.regional["en-US"]=Z.regional["en-GB"]=Z.regional.en;Z.regional.getLocale=function(){var aa=Z.config.defaultLocale;if(document&&document.getElementsByTagName("html")&&document.getElementsByTagName("html")[0].lang){aa=document.getElementsByTagName("html")[0].lang;if(!Z.regional.hasOwnProperty(aa)){aa=Z.config.defaultLocale}}return aa};var x=24*60*60*1000;var I=function(aa,ad){aa=String(aa);var ab=ad-aa.length;var ac=String(Math.pow(10,ab)).slice(1);return ac.concat(aa)};var z={millisecond:1,second:1000,minute:60*1000,hour:60*60*1000,day:x,week:7*x,month:{add:function(ac,aa){z.year.add(ac,Math[aa>0?"floor":"ceil"](aa/12));var ab=ac.getMonth()+(aa%12);if(ab==12){ab=0;ac.setYear(ac.getFullYear()+1)}else{if(ab==-1){ab=11;ac.setYear(ac.getFullYear()-1)}}ac.setMonth(ab)},diff:function(ae,ac){var aa=ae.getFullYear()-ac.getFullYear();var ab=ae.getMonth()-ac.getMonth()+(aa*12);var ad=ae.getDate()-ac.getDate();return ab+(ad/30)}},year:{add:function(ab,aa){ab.setYear(ab.getFullYear()+Math[aa>0?"floor":"ceil"](aa))},diff:function(ab,aa){return z.month.diff(ab,aa)/12}}};for(var S in z){if(S.substring(S.length-1)!="s"){z[S+"s"]=z[S]}}var C=function(ae,ad,ab){if(Z.formats[ab]["shortcuts"][ad]){return Z.strftime(ae,Z.formats[ab]["shortcuts"][ad],ab)}else{var aa=(Z.formats[ab]["codes"][ad]||"").split(".");var ac=ae["get"+aa[0]]?ae["get"+aa[0]]():"";if(aa[1]){ac=I(ac,aa[1])}return ac}};Z.strftime=function(ag,ad,ac,ah){var ab="perl";var af=Z.regional.getLocale();if(ac&&Z.formats.hasOwnProperty(ac)){ab=ac}else{if(ac&&Z.regional.hasOwnProperty(ac)){af=ac}}if(ah&&Z.formats.hasOwnProperty(ah)){ab=ah}else{if(ah&&Z.regional.hasOwnProperty(ah)){af=ah}}if(i(ag)!="[object Object]"||ag._type!="jsDate"){ag=new Z(ag);ag.locale=af}if(!ad){ad=ag.formatString||Z.regional[af]["formatString"]}var aa=ad||"%Y-%m-%d",ai="",ae;while(aa.length>0){if(ae=aa.match(Z.formats[ab].codes.matcher)){ai+=aa.slice(0,ae.index);ai+=(ae[1]||"")+C(ag,ae[2],ab);aa=aa.slice(ae.index+ae[0].length)}else{ai+=aa;aa=""}}return ai};Z.formats={ISO:"%Y-%m-%dT%H:%M:%S.%N%G",SQL:"%Y-%m-%d %H:%M:%S"};Z.formats.perl={codes:{matcher:/()%(#?(%|[a-z]))/i,Y:"FullYear",y:"ShortYear.2",m:"MonthNumber.2","#m":"MonthNumber",B:"MonthName",b:"AbbrMonthName",d:"Date.2","#d":"Date",e:"Date",A:"DayName",a:"AbbrDayName",w:"Day",H:"Hours.2","#H":"Hours",I:"Hours12.2","#I":"Hours12",p:"AMPM",M:"Minutes.2","#M":"Minutes",S:"Seconds.2","#S":"Seconds",s:"Unix",N:"Milliseconds.3","#N":"Milliseconds",O:"TimezoneOffset",Z:"TimezoneName",G:"GmtOffset"},shortcuts:{F:"%Y-%m-%d",T:"%H:%M:%S",X:"%H:%M:%S",x:"%m/%d/%y",D:"%m/%d/%y","#c":"%a %b %e %H:%M:%S %Y",v:"%e-%b-%Y",R:"%H:%M",r:"%I:%M:%S %p",t:"\t",n:"\n","%":"%"}};Z.formats.php={codes:{matcher:/()%((%|[a-z]))/i,a:"AbbrDayName",A:"DayName",d:"Date.2",e:"Date",j:"DayOfYear.3",u:"DayOfWeek",w:"Day",U:"FullWeekOfYear.2",V:"IsoWeek.2",W:"WeekOfYear.2",b:"AbbrMonthName",B:"MonthName",m:"MonthNumber.2",h:"AbbrMonthName",C:"Century.2",y:"ShortYear.2",Y:"FullYear",H:"Hours.2",I:"Hours12.2",l:"Hours12",p:"AMPM",P:"AmPm",M:"Minutes.2",S:"Seconds.2",s:"Unix",O:"TimezoneOffset",z:"GmtOffset",Z:"TimezoneAbbr"},shortcuts:{D:"%m/%d/%y",F:"%Y-%m-%d",T:"%H:%M:%S",X:"%H:%M:%S",x:"%m/%d/%y",R:"%H:%M",r:"%I:%M:%S %p",t:"\t",n:"\n","%":"%"}};Z.createDate=function(ac){if(ac==null){return new Date()}if(ac instanceof Date){return ac}if(typeof ac=="number"){return new Date(ac)}var ah=String(ac).replace(/^\s*(.+)\s*$/g,"$1");ah=ah.replace(/^([0-9]{1,4})-([0-9]{1,2})-([0-9]{1,4})/,"$1/$2/$3");ah=ah.replace(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{4})/i,"$1 $2 $3");var ag=ah.match(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{2})\D*/i);if(ag&&ag.length>3){var al=parseFloat(ag[3]);var af=Z.config.defaultCentury+al;af=String(af);ah=ah.replace(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{2})\D*/i,ag[1]+" "+ag[2]+" "+af)}ag=ah.match(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})[^0-9]/);function ak(ap,ao){var av=parseFloat(ao[1]);var au=parseFloat(ao[2]);var at=parseFloat(ao[3]);var ar=Z.config.defaultCentury;var an,am,aw,aq;if(av>31){am=at;aw=au;an=ar+av}else{am=au;aw=av;an=ar+at}aq=aw+"/"+am+"/"+an;return ap.replace(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})/,aq)}if(ag&&ag.length>3){ah=ak(ah,ag)}var ag=ah.match(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})$/);if(ag&&ag.length>3){ah=ak(ah,ag)}var ae=0;var ab=Z.matchers.length;var aj,aa,ai=ah,ad;while(ae<ab){aa=Date.parse(ai);if(!isNaN(aa)){return new Date(aa)}aj=Z.matchers[ae];if(typeof aj=="function"){ad=aj.call(Z,ai);if(ad instanceof Date){return ad}}else{ai=ah.replace(aj[0],aj[1])}ae++}return NaN};Z.daysInMonth=function(aa,ab){if(ab==2){return new Date(aa,1,29).getDate()==29?29:28}return[q,31,q,31,30,31,30,31,31,30,31,30,31][ab]};Z.matchers=[[/(3[01]|[0-2]\d)\s*\.\s*(1[0-2]|0\d)\s*\.\s*([1-9]\d{3})/,"$2/$1/$3"],[/([1-9]\d{3})\s*-\s*(1[0-2]|0\d)\s*-\s*(3[01]|[0-2]\d)/,"$2/$3/$1"],function(ad){var ab=ad.match(/^(?:(.+)\s+)?([012]?\d)(?:\s*\:\s*(\d\d))?(?:\s*\:\s*(\d\d(\.\d*)?))?\s*(am|pm)?\s*$/i);if(ab){if(ab[1]){var ac=this.createDate(ab[1]);if(isNaN(ac)){return}}else{var ac=new Date();ac.setMilliseconds(0)}var aa=parseFloat(ab[2]);if(ab[6]){aa=ab[6].toLowerCase()=="am"?(aa==12?0:aa):(aa==12?12:aa+12)}ac.setHours(aa,parseInt(ab[3]||0,10),parseInt(ab[4]||0,10),((parseFloat(ab[5]||0))||0)*1000);return ac}else{return ad}},function(ad){var ab=ad.match(/^(?:(.+))[T|\s+]([012]\d)(?:\:(\d\d))(?:\:(\d\d))(?:\.\d+)([\+\-]\d\d\:\d\d)$/i);if(ab){if(ab[1]){var ac=this.createDate(ab[1]);if(isNaN(ac)){return}}else{var ac=new Date();ac.setMilliseconds(0)}var aa=parseFloat(ab[2]);ac.setHours(aa,parseInt(ab[3],10),parseInt(ab[4],10),parseFloat(ab[5])*1000);return ac}else{return ad}},function(ae){var ac=ae.match(/^([0-3]?\d)\s*[-\/.\s]{1}\s*([a-zA-Z]{3,9})\s*[-\/.\s]{1}\s*([0-3]?\d)$/);if(ac){var ad=new Date();var af=Z.config.defaultCentury;var ah=parseFloat(ac[1]);var ag=parseFloat(ac[3]);var ab,aa,ai;if(ah>31){aa=ag;ab=af+ah}else{aa=ah;ab=af+ag}var ai=V(ac[2],Z.regional[Z.regional.getLocale()]["monthNamesShort"]);if(ai==-1){ai=V(ac[2],Z.regional[Z.regional.getLocale()]["monthNames"])}ad.setFullYear(ab,ai,aa);ad.setHours(0,0,0,0);return ad}else{return ae}}];function V(ac,ad){if(ad.indexOf){return ad.indexOf(ac)}for(var aa=0,ab=ad.length;aa<ab;aa++){if(ad[aa]===ac){return aa}}return -1}function i(aa){if(aa===null){return"[object Null]"}return Object.prototype.toString.call(aa)}G.jsDate=Z;G.jqplot.sprintf=function(){function ag(am,ai,aj,al){var ak=(am.length>=ai)?"":Array(1+ai-am.length>>>0).join(aj);return al?am+ak:ak+am}function ad(ak){var aj=new String(ak);for(var ai=10;ai>0;ai--){if(aj==(aj=aj.replace(/^(\d+)(\d{3})/,"$1"+G.jqplot.sprintf.thousandsSeparator+"$2"))){break}}return aj}function ac(an,am,ap,ak,al,aj){var ao=ak-an.length;if(ao>0){var ai=" ";if(aj){ai="&nbsp;"}if(ap||!al){an=ag(an,ak,ai,ap)}else{an=an.slice(0,am.length)+ag("",ao,"0",true)+an.slice(am.length)}}return an}function ah(aq,aj,ao,ak,ai,an,ap,am){var al=aq>>>0;ao=ao&&al&&{"2":"0b","8":"0","16":"0x"}[aj]||"";aq=ao+ag(al.toString(aj),an||0,"0",false);return ac(aq,ao,ak,ai,ap,am)}function aa(am,an,ak,ai,al,aj){if(ai!=null){am=am.slice(0,ai)}return ac(am,"",an,ak,al,aj)}var ab=arguments,ae=0,af=ab[ae++];return af.replace(G.jqplot.sprintf.regex,function(aE,ap,aq,au,aG,aB,an){if(aE=="%%"){return"%"}var av=false,ar="",at=false,aD=false,ao=false,am=false;for(var aA=0;aq&&aA<aq.length;aA++){switch(aq.charAt(aA)){case" ":ar=" ";break;case"+":ar="+";break;case"-":av=true;break;case"0":at=true;break;case"#":aD=true;break;case"&":ao=true;break;case"'":am=true;break}}if(!au){au=0}else{if(au=="*"){au=+ab[ae++]}else{if(au.charAt(0)=="*"){au=+ab[au.slice(1,-1)]}else{au=+au}}}if(au<0){au=-au;av=true}if(!isFinite(au)){throw new Error("$.jqplot.sprintf: (minimum-)width must be finite")}if(!aB){aB="fFeE".indexOf(an)>-1?6:(an=="d")?0:void (0)}else{if(aB=="*"){aB=+ab[ae++]}else{if(aB.charAt(0)=="*"){aB=+ab[aB.slice(1,-1)]}else{aB=+aB}}}var ax=ap?ab[ap.slice(0,-1)]:ab[ae++];switch(an){case"s":if(ax==null){return""}return aa(String(ax),av,au,aB,at,ao);case"c":return aa(String.fromCharCode(+ax),av,au,aB,at,ao);case"b":return ah(ax,2,aD,av,au,aB,at,ao);case"o":return ah(ax,8,aD,av,au,aB,at,ao);case"x":return ah(ax,16,aD,av,au,aB,at,ao);case"X":return ah(ax,16,aD,av,au,aB,at,ao).toUpperCase();case"u":return ah(ax,10,aD,av,au,aB,at,ao);case"i":var ak=parseInt(+ax,10);if(isNaN(ak)){return""}var az=ak<0?"-":ar;var aC=am?ad(String(Math.abs(ak))):String(Math.abs(ak));ax=az+ag(aC,aB,"0",false);return ac(ax,az,av,au,at,ao);case"d":var ak=Math.round(+ax);if(isNaN(ak)){return""}var az=ak<0?"-":ar;var aC=am?ad(String(Math.abs(ak))):String(Math.abs(ak));ax=az+ag(aC,aB,"0",false);return ac(ax,az,av,au,at,ao);case"e":case"E":case"f":case"F":case"g":case"G":var ak=+ax;if(isNaN(ak)){return""}var az=ak<0?"-":ar;var al=["toExponential","toFixed","toPrecision"]["efg".indexOf(an.toLowerCase())];var aF=["toString","toUpperCase"]["eEfFgG".indexOf(an)%2];var aC=Math.abs(ak)[al](aB);aC=am?ad(aC):aC;ax=az+aC;return ac(ax,az,av,au,at,ao)[aF]();case"p":case"P":var ak=+ax;if(isNaN(ak)){return""}var az=ak<0?"-":ar;var aw=String(Number(Math.abs(ak)).toExponential()).split(/e|E/);var aj=(aw[0].indexOf(".")!=-1)?aw[0].length-1:aw[0].length;var ay=(aw[1]<0)?-aw[1]-1:0;if(Math.abs(ak)<1){if(aj+ay<=aB){ax=az+Math.abs(ak).toPrecision(aj)}else{if(aj<=aB-1){ax=az+Math.abs(ak).toExponential(aj-1)}else{ax=az+Math.abs(ak).toExponential(aB-1)}}}else{var ai=(aj<=aB)?aj:aB;ax=az+Math.abs(ak).toPrecision(ai)}var aF=["toString","toUpperCase"]["pP".indexOf(an)%2];return ac(ax,az,av,au,at,ao)[aF]();case"n":return"";default:return aE}})};G.jqplot.sprintf.thousandsSeparator=",";G.jqplot.sprintf.regex=/%%|%(\d+\$)?([-+#0&\' ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([nAscboxXuidfegpEGP])/g;G.jqplot.getSignificantFigures=function(ae){var ag=String(Number(Math.abs(ae)).toExponential()).split(/e|E/);var af=(ag[0].indexOf(".")!=-1)?ag[0].length-1:ag[0].length;var ab=(ag[1]<0)?-ag[1]-1:0;var aa=parseInt(ag[1]);var ac=(aa+1>0)?aa+1:0;var ad=(af<=ac)?0:af-aa-1;return{significantDigits:af,digitsLeft:ac,digitsRight:ad,zeros:ab,exponent:aa}};G.jqplot.getPrecision=function(ab){var aa=G.jqplot.getSignificantFigures(ab);var ac=aa[1]-1-parseInt(aa[0][1]);return ac}})(jQuery);