# copyright 2010 LOGILAB S.A. (Paris, FRANCE), all rights reserved.
# contact http://www.logilab.fr -- mailto:contact@logilab.fr
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU Lesser General Public License as published by the Free
# Software Foundation, either version 2.1 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
# details.
#
# You should have received a copy of the GNU Lesser General Public License along
# with this program. If not, see <http://www.gnu.org/licenses/>.

"""cubicweb-openidrelay specific hooks and operations"""

import logging
from openid import oidutil

from cubicweb.server import hook

from cubes.openidrelay.authplugin import OpenIDAuthentifier

class ServerStartupHook(hook.Hook):
    """register authentifier at startup"""
    __regid__ = 'openid-authentifier-register'
    events = ('server_startup',)

    def __call__(self):
        self.debug('registering openid authentifier')
        self.repo.system_source.add_authentifier(OpenIDAuthentifier())


# monkeypatch openid.oidutil logger, which is a bit dump

OPENIDLOGGER = logging.getLogger('cubicweb.openid')

def openidlib_logger(msg):
    OPENIDLOGGER.debug(msg)
oidutil.log = openidlib_logger
