# copyright 2011 LOGILAB S.A. (Paris, FRANCE), all rights reserved.
# contact http://www.logilab.fr -- mailto:contact@logilab.fr
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU Lesser General Public License as published by the Free
# Software Foundation, either version 2.1 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
# details.
#
# You should have received a copy of the GNU Lesser General Public License along
# with this program. If not, see <http://www.gnu.org/licenses/>.
"""cubicweb-vcreview automatic tests"""

import os.path as osp
from shutil import rmtree

from logilab.common.shellutils import unzip

from cubicweb.devtools import testlib

from cubes.vcsfile.testutils import init_vcsrepo

class AutomaticWebTest(testlib.AutomaticWebTest):
    no_auto_populate = ('Repository', 'Revision', 'VersionedFile',
                        'VersionContent', 'DeletedVersionContent',
                        'Patch', 'Comment', 'InsertionPoint',)
    ignored_relations = set(('at_revision', 'parent_revision',
                             'from_repository', 'from_revision',
                             'content_for', 'vc_copy', 'vc_rename',
                             'patch_repository', 'patch_revision',
                             'nosy_list', 'comments', 'depends_on',
                             'point_of'))

    @classmethod
    def setUpClass(cls):
        unzip(cls.repo_path + '.zip', cls.datadir)

    @classmethod
    def tearDownClass(cls):
        try:
            rmtree(cls.repo_path)
        except:
            pass

    # XXX presetup
    def custom_populate(self, how_many, cursor):
        req = self.request()
        req.create_entity('Repository', type=u'mercurial', encoding=u'utf8',
                          path=self.repo_path)
        assert req.execute('SET X has_patch_repository X')
        self.commit()
        init_vcsrepo(self.repo)

AutomaticWebTest.repo_path = osp.join(AutomaticWebTest.datadir, u'patchrepo')

if __name__ == '__main__':
    from logilab.common.testlib import unittest_main
    unittest_main()
