# pylint: disable-msg=W0622
"""cubicweb-vcsfile packaging information"""

distname = "cubicweb-vcsfile"
modname = distname.split('-', 1)[1]

numversion = (1, 0, 1)
version = '.'.join(str(num) for num in numversion)

copyright = '''Copyright (c) 2007-2009 LOGILAB S.A. (Paris, FRANCE).
http://www.logilab.fr/ -- mailto:contact@logilab.fr'''

license = 'LGPL'
author = "Logilab"
author_email = "contact@logilab.fr"
web = 'http://www.cubicweb.org/project/%s' % modname

short_desc = "Interface local versioned files repository content as cubicweb entities"
long_desc = """Cubicweb is a entities / relations bases knowledge management system
developped at Logilab.
.
This package provides a custom source as well as custom entity types and
views to provide transparent access of files versioned in subversion or
mercurial repositories.
.
"""

from os import listdir as _listdir
from os.path import join, isdir
from glob import glob

THIS_CUBE_DIR = join('share', 'cubicweb', 'cubes', modname)

def listdir(dirpath):
    return [join(dirpath, fname) for fname in _listdir(dirpath)
            if fname[0] != '.' and not fname.endswith('.pyc')
            and not fname.endswith('~')
            and not isdir(join(dirpath, fname))]

data_files = [
    # common files
    [THIS_CUBE_DIR, [fname for fname in glob('*.py') if fname != 'setup.py']],
    ]
# check for possible extended cube layout
for dirname in ('entities', 'views', 'sobjects', 'hooks', 'schema', 'data', 'i18n', 'migration'):
    if isdir(dirname):
        data_files.append([join(THIS_CUBE_DIR, dirname), listdir(dirname)])
# Note: here, you'll need to add subdirectories if you want
# them to be included in the debian package

cube_eid = None # XXX
# used packages
__use__ = ()
classifiers = [
           'Environment :: Web Environment',
           'Framework :: CubicWeb',
           'Programming Language :: Python',
           'Programming Language :: JavaScript',
]
