from cubicweb.devtools import DEFAULT_SOURCES
LOGIN, PASSWORD = DEFAULT_SOURCES['admin'].values()

# Generated by the windmill services transformer
from windmill.authoring import WindmillTestClient

def test_creation():
    client = WindmillTestClient(__name__)

    client.open(url=u'/')
    client.waits.forPageLoad(timeout=u'8000')
    client.type(text=LOGIN, id=u'__login')
    client.type(text=PASSWORD, id=u'__password')
    client.click(value=u'log in')
    client.waits.forPageLoad(timeout=u'20000')

    # pre-condition
    client.open(url=u'/cwuser/myuser')
    client.asserts.assertJS(js=u'$(\'#contentmain h1\').text() == "this resource does not exist"')
    client.open(url=u'/?rql=Any U WHERE U is CWUser, U login "myuser"')
    client.asserts.assertJS(js=u'$(\'.searchMessage strong\').text() == "No result matching query"')

    client.open(url=u'/manage')
    client.open(url=u'/add/CWUser')
    client.type(text=u'myuser', id=u'login-subject:A')
    client.type(text=u'myuser', id=u'upassword-subject:A')
    client.type(text=u'myuser', name=u'upassword-subject-confirm:A')
    client.type(text=u'myuser', id=u'firstname-subject:A')
    client.select(option=u'managers', id=u'in_group-subject:A')
    client.waits.forPageLoad(timeout=u'20000')
    client.click(id=u'adduse_email:Alink')
    client.waits.forPageLoad(timeout=u'20000')
    client.type(text=u'myuser@logilab.fr', id=u'address-subject:B')
    client.waits.forPageLoad(timeout=u'20000')
    client.click(value=u'button_ok')
    client.waits.forPageLoad(timeout=u'20000')
    client.waits.sleep(milliseconds=u'5000')
    client.asserts.assertJS(js=u'$(\'.message\').text() == "entity created"')
    client.open(url=u'/?rql=Any U WHERE U is CWUser, U login "myuser"')
    client.waits.forPageLoad(timeout=u'20000')
    client.asserts.assertJS(js=u'$(\'#contentmain h1\').text() == "myuser"')
    client.waits.forPageLoad(timeout=u'8000')
    client.open(url=u'/cwuser/myuser?vid=sameetypelist')
    client.waits.forPageLoad(timeout=u'8000')
    client.asserts.assertJS(js=u'$(\'#contentmain a\').text() == "myuser"')
    client.open(url=u'/cwuser/myuser?vid=text')
    client.waits.forPageLoad(timeout=u'8000')
    client.asserts.assertJS(js=u'$(\'#contentmain\').text() == "\\nmyuser"')
    client.open(url=u'/cwuser/myuser?vid=deleteconf')
    client.waits.forElement(timeout=u'8000', value=u'button_delete')
    client.click(value=u'button_delete')
    client.waits.forPageLoad(timeout=u'8000')
    client.open(url=u'/cwuser/myuser')
    client.asserts.assertJS(js=u'$(\'#contentmain h1\').text() == "this resource does not exist"')
    client.open(url=u'/?rql=Any U WHERE U is CWUser, U login "myuser"')
    client.asserts.assertJS(js=u'$(\'.searchMessage strong\').text() == "No result matching query"')

