# copyright 2003-2010 LOGILAB S.A. (Paris, FRANCE), all rights reserved.
# contact http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This file is part of CubicWeb.
#
# CubicWeb is free software: you can redistribute it and/or modify it under the
# terms of the GNU Lesser General Public License as published by the Free
# Software Foundation, either version 2.1 of the License, or (at your option)
# any later version.
#
# CubicWeb is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
# details.
#
# You should have received a copy of the GNU Lesser General Public License along
# with CubicWeb.  If not, see <http://www.gnu.org/licenses/>.
"""vcard import / export

"""
__docformat__ = "restructuredtext en"

from cubicweb.selectors import is_instance
from cubicweb.view import EntityView

_ = unicode

VCARD_PHONE_TYPES = {'home': 'HOME', 'office': 'WORK', 'mobile': 'CELL', 'fax': 'FAX'}

class VCardCWUserView(EntityView):
    """export a person information as a vcard"""
    __regid__ = 'vcard'
    title = _('vcard')
    templatable = False
    content_type = 'text/x-vcard'
    __select__ = is_instance('CWUser')

    def set_request_content_type(self):
        """overriden to set a .vcf filename"""
        self._cw.set_content_type(self.content_type, filename='vcard.vcf')

    def cell_call(self, row, col):
        self.vcard_header()
        self.vcard_content(self.cw_rset.complete_entity(row, col))
        self.vcard_footer()

    def vcard_header(self):
        self.w(u'BEGIN:vcard\n')
        self.w(u'VERSION:3.0\n')

    def vcard_footer(self):
        self.w(u'NOTE:this card has been generated by CubicWeb\n')
        self.w(u'END:vcard\n')

    def vcard_content(self, entity):
        who = u'%s %s' % (entity.surname or '',
                          entity.firstname or '')
        w = self.w
        w(u'FN:%s\n' % who)
        w(u'N:%s;;;;\n' % entity.login)
        w(u'TITLE:%s\n' % who)
        for email in entity.use_email:
            w(u'EMAIL;TYPE=INTERNET:%s\n' % email.address)

from logilab.common.deprecation import class_renamed
VCardEuserView = VCardEUserView = class_renamed('VCardEuserView', VCardCWUserView)
