# -*- coding: utf-8 -*-
"""unit/functional tests for cubicweb.server.hookhelper

:organization: Logilab
:copyright: 2001-2009 LOGILAB S.A. (Paris, FRANCE), license is LGPL v2.
:contact: http://www.logilab.fr/ -- mailto:contact@logilab.fr
:license: GNU Lesser General Public License, v2.1 - http://www.gnu.org/licenses
"""

from logilab.common.testlib import unittest_main
from cubicweb.devtools.apptest import RepositoryBasedTC

from cubicweb.server.pool import LateOperation, Operation, SingleLastOperation
from cubicweb.server.hookhelper import *


class HookHelpersTC(RepositoryBasedTC):

    def setUp(self):
        RepositoryBasedTC.setUp(self)
        self.hm = self.repo.hm

    def test_late_operation(self):
        session = self.session
        l1 = LateOperation(session)
        l2 = LateOperation(session)
        l3 = Operation(session)
        self.assertEquals(session.pending_operations, [l3, l1, l2])

    def test_single_last_operation(self):
        session = self.session
        l0 = SingleLastOperation(session)
        l1 = LateOperation(session)
        l2 = LateOperation(session)
        l3 = Operation(session)
        self.assertEquals(session.pending_operations, [l3, l1, l2, l0])
        l4 = SingleLastOperation(session)
        self.assertEquals(session.pending_operations, [l3, l1, l2, l4])

    def test_global_operation_order(self):
        from cubicweb.server import hooks, schemahooks
        session = self.session
        op1 = hooks.DelayedDeleteOp(session)
        op2 = schemahooks.DelErdefOp(session)
        # equivalent operation generated by op2 but replace it here by op3 so we
        # can check the result...
        op3 = schemahooks.UpdateSchemaOp(session)
        op4 = hooks.DelayedDeleteOp(session)
        op5 = hooks.CheckORelationOp(session)
        self.assertEquals(session.pending_operations, [op1, op2, op4, op5, op3])


    def test_in_state_notification(self):
        result = []
        # test both email notification and transition_information
        # whatever if we can connect to the default stmp server, transaction
        # should not fail
        def in_state_changed(session, eidfrom, rtype, eidto):
            tr = previous_state(session, eidfrom)
            if tr is None:
                result.append(tr)
                return
            content = u'trÃ€nsition from %s to %s' % (tr.name, entity_name(session, eidto))
            result.append(content)
            SendMailOp(session, msg=content, recipients=['test@logilab.fr'])
        self.hm.register_hook(in_state_changed,
                             'before_add_relation', 'in_state')
        self.execute('INSERT CWUser X: X login "paf", X upassword "wouf", X in_state S, X in_group G WHERE S name "activated", G name "users"')
        self.assertEquals(result, [None])
        searchedops = [op for op in self.session.pending_operations
                       if isinstance(op, SendMailOp)]
        self.assertEquals(len(searchedops), 0,
                          self.session.pending_operations)
        self.commit()
        self.execute('SET X in_state S WHERE X login "paf", S name "deactivated"')
        self.assertEquals(result, [None, u'trÃ€nsition from activated to deactivated'])
        # one to send the mail, one to close the smtp connection
        searchedops = [op for op in self.session.pending_operations
                       if isinstance(op, SendMailOp)]
        self.assertEquals(len(searchedops), 1,
                          self.session.pending_operations)
        self.commit()
        searchedops = [op for op in self.session.pending_operations
                       if isinstance(op, SendMailOp)]
        self.assertEquals(len(searchedops), 0,
                          self.session.pending_operations)

if __name__ == '__main__':
    unittest_main()
