# Currency data from ISO 4217. 
# Currency symbols have been taken from http://www.xe.com/symbols.php

from currency.converter import CurrencyConverterMessageFactory as _

## "Currency Code" : (Name, Unit, Decimal)

currencies = { 
        "AED" : (_(u"UAE Dirham"), u""),
        "AFA" : (_(u"Afghani"), u"\u060b"),
        "ALL" : (_(u"Albanian Lek"), u"Lek"),
        "AMD" : (_(u"Armenian Dram"), u""),
        "ANG" : (_(u"Netherlands Antillian Guilder"), u"\u0192"),
        "AOA" : (_(u"Angola Kwanza"), u""),
        "ARS" : (_(u"Argentine Peso"), u"$"),
        "AUD" : (_(u"Australian Dollar"), u"$"),
        "AWG" : (_(u"Aruban Guilder"), u"\u0192"),
        "AZN" : (_(u"Azerbaijanian New Manats"), u"\u043c\u0430\u043d"),
        "BAM" : (_(u"Convertible Marks"), u"KM"),
        "BBD" : (_(u"Barbados Dollar"), u"$"),
        "BDT" : (_(u"Bangladeshi Taka"), u""),
        "BGL" : (_(u"Bulgarian Lev"), u""),
        "BGN" : (_(u"Bulgarian Lev"), u"\u043b\u0432"),
        "BHD" : (_(u"Bahraini Dinar"), u""),
        "BIF" : (_(u"Burundi Franc"), u""),
        "BMD" : (_(u"Bermudian Dollar"), u"$"),
        "BND" : (_(u"Brunei Dollar"), u"$"),
        "BOB" : (_(u"Boliviano"), u"$b"),
        "BOV" : (_(u"Bolivian Mvdol"), u""),
        "BRL" : (_(u"Brazilian Real"), u"R$"),
        "BSD" : (_(u"Bahamian Dollar"), u"$"),
        "BTN" : (_(u"Bhutan Ngultrum"), u""),
        "BWP" : (_(u"Botswana Pula"), u"P"),
        "BYR" : (_(u"Belarussian Rouble"), u"p."),
        "BZD" : (_(u"Belize Dollar"), u"BZ$"),
        "CAD" : (_(u"Canadian Dollar"), u"$"),
        "CDF" : (_(u"Franc Congolais"), u""),
        "CHF" : (_(u"Swiss Franc"), u"CHF"),
        "CLF" : (_(u"Unidades de fomento"), u""),
        "CLP" : (_(u"Chilean Peso"), u"$"),
        "CNY" : (_(u"Chinese Yuan Renminbi"), u"\u5143"),
        "COP" : (_(u"Colombian Peso"), u"\u20b1"),
        "CRC" : (_(u"Costa Rican Colon"), u"\u20a1"),
        "CUP" : (_(u"Cuban Peso"), u"\u20b1"),
        "CVE" : (_(u"Cap Verde Escudo"), u""),
        "CYP" : (_(u"Cyprus Pound"), u"\xa3"),
        "CZK" : (_(u"Czech Koruna"), u"\x4b\u010d"),
        "DJF" : (_(u"Djibouti Franc"), u""),
        "DKK" : (_(u"Danish Krone"), u"kr"),
        "DOP" : (_(u"Dominican Peso"), u"\RD$"),
        "DZD" : (_(u"Algerian Dinar"), u""),
        "ECV" : (_(u"Unidad de Valor Constante UVC"), u""),
        "EEK" : (_(u"Estonia Kroon"), u"kr"),
        "EGP" : (_(u"Egyptian Pound"), u"\xa3"),
        "ERN" : (_(u"Eritrean Nakfa"), u""),
        "ETB" : (_(u"Ethiopian Birr"), u""),
        "EUR" : (_(u"Euro"), u"\u20ac"),
        "FJD" : (_(u"Fiji Dollar"), u"$"),
        "FKP" : (_(u"Falkland Island Pound"), u"\xa3"),
        "GBP" : (_(u"Pound Sterling"), u"\xa3"),
        "GEL" : (_(u"Georgian Lari"), u""),
        "GHC" : (_(u"Ghanaian Cedi"), u"\xa2"),
        "GIP" : (_(u"Gibraltar Pound"), u"\xa3"),
        "GMD" : (_(u"Gambian Dalasi"), u""),
        "GNF" : (_(u"Guinea Franc"), u""),
        "GTQ" : (_(u"Guatemalan Quetzal"), u"Q"),
        "GWP" : (_(u"Guinea-Bissau Peso"), u""),
        "GYD" : (_(u"Guyana Dollar"), u"$"),
        "HKD" : (_(u"Hong Kong Dollar"), u"HK$"),
        "HNL" : (_(u"Honduran Lempira"), u"L"),
        "HRK" : (_(u"Croatian Kuna"), u"\x6b\x6e"),
        "HTG" : (_(u"Haitian Gourde"), u""),
        "HUF" : (_(u"Hungarian Forint"), u"Ft"),
        "IDR" : (_(u"Indonesian Rupiah"), u""),
        "ILS" : (_(u"Israeli Shekel"), u"\u20aa"),
        "INR" : (_(u"Indian Rupee"), u"\u20a8"),
        "IQD" : (_(u"Iraqi Dinar"), u""),
        "IRR" : (_(u"Iranian Rial"), u"\ufdfc"),
        "ISK" : (_(u"Iceland Krona"), u"kr"),
        "JMD" : (_(u"Jamaican Dollar"), u"J$"),
        "JOD" : (_(u"Jordanian Dinar"), u""),
        "JPY" : (_(u"Japanese Yen"), u"\xa5", 0),
        "KES" : (_(u"Kenyan Shilling"), u""),
        "KGS" : (_(u"Kyrgyzstan Som"), u"\u043b\u0432"),
        "KHR" : (_(u"Cambodian Riel"), u"\u17db"),
        "KMF" : (_(u"Comoro Franc"), u""),
        "KPW" : (_(u"North Korean Won"), u"\u20a9"),
        "KRW" : (_(u"South Korean Won"), u"\u20a9"),
        "KWD" : (_(u"Kuwaiti Dinar"), u""),
        "KYD" : (_(u"Cayman Islands Dollar"), u"$"),
        "KZT" : (_(u"Kazakhstan Tenge"), u"\u043b\u0432"),
        "LAK" : (_(u"Lao Kip"), u"\u20ad"),
        "LBP" : (_(u"Lebanese Pound"), u"\xa3"),
        "LKR" : (_(u"Sri Lanka Rupee"), u"\u20a8"),
        "LRD" : (_(u"Liberian Dollar"), u"$"),
        "LSL" : (_(u"Lesotho Loti"), u""),
        "LTL" : (_(u"Lithuanian Litas"), u"Lt"),
        "LVL" : (_(u"Latvian Lats"), u"Ls"),
        "LYD" : (_(u"Libyan Dinar"), u""),
        "MAD" : (_(u"Moroccan Dirham"), u""),
        "MDL" : (_(u"Moldovan Leu"), u""),
        "MGF" : (_(u"Malagasy Franc"), u""),
        "MKD" : (_(u"Macedonian Denar"), u"\u0434\u0435\u043d"),
        "MMK" : (_(u"Myanmar Kyat"), u""),
        "MNT" : (_(u"Mongolian Tugrik"), u"\u20ae"),
        "MOP" : (_(u"Macao Patacca"), u""),
        "MRO" : (_(u"Mauritanian Ouguiya"), u""),
        "MTL" : (_(u"Maltese Lira"), u"Lm"),
        "MUR" : (_(u"Mauritius Rupee"), u"\u20a8"),
        "MVR" : (_(u"Maldive Rufiyaa"), u""),
        "MWK" : (_(u"Malawi Kwacha"), u""),
        "MXN" : (_(u"Mexican Peso"), u"$"),
        "MXV" : (_(u"Unidad de Inversion (UDI)"), u""),
        "MYR" : (_(u"Malaysian Ringgit"), u"RM"),
        "MZM" : (_(u"Mozambique Metical"), u""),
        "NAD" : (_(u"Namibian Dollar"), u"$"),
        "NGN" : (_(u"Nigerian Naira"), u"\u20a6"),
        "NIO" : (_(u"Nicaraguan Cordoba Oro"), u"C$"),
        "NOK" : (_(u"Norwegian Krone"), u"kr"),
        "NPR" : (_(u"Nepalese Rupee"), u"\u20a8"),
        "NZD" : (_(u"New Zealand Dollar"), u"$"),
        "OMR" : (_(u"Rial Omani"), u"\ufdfc"),
        "PAB" : (_(u"Panamanian Balboa"), u"B/."),
        "PEN" : (_(u"Peruvian Nuevo Sol"), u"S/."),
        "PGK" : (_(u"Papua New Guinea Kina"), u""),
        "PHP" : (_(u"Phillipine Peso"), u"Php"),
        "PKR" : (_(u"Pakistan Rupee"), u"\u20a8"),
        "PLN" : (_(u"Polish Z\u0142oty"), u"z\u0142"),
        "PYG" : (_(u"Paraguay Guarani"), u"Gs"),
        "QAR" : (_(u"Qatari Riyal"), u"\ufdfc"),
        "RON" : (_(u"Romanian Leu"), u""),
        "RUB" : (_(u"Russian Rouble"), u"\u0440\u0443\u0431"),
        "RWF" : (_(u"Rwanda Franc"), u""),
        "SAR" : (_(u"Saudi Riyal"), u"\ufdfc"),
        "SBD" : (_(u"Solomon Islands Dollar"), u"$"),
        "SCR" : (_(u"Seychelles Rupee"), u"\u20a8"),
        "SDD" : (_(u"Sudanese Dinar"), u""),
        "SEK" : (_(u"Swedish Krona"), u"kr"),
        "SGD" : (_(u"Singapur Dollar"), u"$"),
        "SHP" : (_(u"Saint Helena Pound"), u"\xa3"),
        "SIT" : (_(u"Slovenian Tolar"), u""),
        "SKK" : (_(u"Slovak Koruna"), u"SIT"),
        "SLL" : (_(u"Leone"), u""),
        "SOS" : (_(u"Somali Schilling"), u"S"),
        "SRG" : (_(u"Suriname Guilder"), u""),
        "STD" : (_(u"Sao Tome and Principe Dobra"), u""),
        "SVC" : (_(u"El Salvador Colon"), u"$"),
        "SYP" : (_(u"Syrian Pound"), u"\xa3"),
        "SZL" : (_(u"Swaziland Lilangeni"), u""),
        "THB" : (_(u"Thai Baht"), u"\u0e3f"),
        "TJS" : (_(u"Tajik Somoni"), u""),
        "TLE" : (_(u"Timor Escudo"), u""),
        "TMM" : (_(u"Turkmenistan Manat"), u""),
        "TND" : (_(u"Tunisian Dinar"), u""),
        "TOP" : (_(u"Tongan Pa'anga"), u""),
        "TRY" : (_(u"Turkish Lira"), u"\u20a4"),
        "TTD" : (_(u"Trinidad and Tobago Dollar"), u"TT$"),
        "TWD" : (_(u"New Taiwan Dollar"), u"$"),
        "TZS" : (_(u"Tazanian Schilling"), u""),
        "UAH" : (_(u"Ukrainian Hryvnia"), u"\u20b4"),
        "UGX" : (_(u"Ugandan Schilling"), u""),
        "USD" : (_(u"US Dollar"), u"$"),
        "USN" : (_(u"US Dollar (Next day)"), u""),
        "USS" : (_(u"US Dollar (Same day)"), u""),
        "UYU" : (_(u"Peso Uruguayo"), u"\u20b1"),
        "UZS" : (_(u"Uzbekistan Sum"), u""),
        "VEB" : (_(u"Venezuela Bolivar"), u"Bs"),
        "VND" : (_(u"Viet Nam Dong"), u"\u20ab"),
        "VUV" : (_(u"Vanuatu Vatu"), u""),
        "WST" : (_(u"Samoan Tala"), u""),
        "XAF" : (_(u"CFA Franc BEAC"), u""),
        "XAG" : (_(u"Silver"), u""),
        "XAU" : (_(u"Gold"), u""),
        "XBA" : (_(u"Bond Markets Units"), u""),
        "XBB" : (_(u"European Composite Unit EURCO"), u""),
        "XBC" : (_(u"European Monetary Unit EUM"), u""),
        "XBD" : (_(u"European Unit of Account EUA"), u""),
        "XCD" : (_(u"East Caribean Dollar"), u"$"),
        "XDR" : (_(u"Special Drawing Right"), u""),
        "XOF" : (_(u"CFA Franc BCEAO"), u""),
        "XPD" : (_(u"Palladium"), u""),
        "XPF" : (_(u"CFP Franc"), u""),
        "XPT" : (_(u"Platinum"), u""),
        "XTS" : (_(u"Code for testing purposes"), u""),
        "YER" : (_(u"Yemini Rial"), u"\ufdfc"),
        "YUD" : (_(u"Yugoslavian Dinar"), u""),
        "ZAR" : (_(u"South African Rand"), u"R"),
        "ZMK" : (_(u"Zambian Kwacha"), u""),
        "ZWD" : (_(u"Zimbabwe Dollar"), u"Z$"),
        }

