from setuptools import setup

setup(
    name='customnoseplugins',
    version="1.8.7",
    description = 'test plan plugins for the nose testing framework',
    author = 'bao hongbin',
    author_email = 'hongbin.bao@gmail.com',
    license = 'MIT',
    long_description = """\

Extra plugins for the nose testing framework to load test case from a plan file.\n

usage:\n
>>> nosetests --with-plan-loader --plan-file-name path_of_plan_file --plan-loop-number 10\n

plan file content:\n
[tests]\n
packagename.modulename.classname.testcasename = 3\n
packagename.modulename.classname.testcasename = 5\n

FUTURE support plan file content:\n
[tests]\n
packagename.modulename:classname.testcasename = 3\n
packagename.modulename:classname.testcasename = 5\n

1: allow to custom a test plan file. the plan file can define the test cases name list  and the executed  loop count in one loop.\n All tests will be executed from top to end follow it's own loop count.\n
2: allow to define the test cycle number. the test will be executed cyclically until exceed the cycle number. default only\n executed 1 cycle.\n

start from command-line:
    nosetests --with-plan-loader --plan-loop-number 100 --with-file-output --verbosity 2

start programmly:\n
    >>> from customnoseplugins.planloader import PlanLoaderPlugin\n
    >>> nose.run(argv=['--with-plan-loader', '--plan-file-name', 'plan', '--plan-loop-number', '100'], \naddplugins=[PlanLoaderPlugin()])\n
""",
    packages = ['customnoseplugins'],
    entry_points = {
        'nose.plugins': [
            'plan-loader = customnoseplugins.planloader:PlanLoaderPlugin',
            'file-output = customnoseplugins.fileoutput:FileOutputPlugin',
            ],
         },
)

