#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Thu Nov 01 08:57:12 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class MeasureSourceType(GeneratedsSuper):
    """The MeasureSourceType is a complex type representing a description
    of a single cyber observation source.The class attribute is
    optional and enables identification of the high-level class of
    this cyber observation source.The source_type attribute is
    optional and enables identification of the broad type of this
    cyber observation source.The tool_type attribute is optional and
    (when tools are used) enables identification of the type of tool
    leveraged as part of this cyber observation source.The
    information_sourceType attribute is optional and enables
    identification of the type of information source leveraged for
    this cyber observation source.The name attribute is optional and
    enables the assignment of a relevant name to a this Discovery
    Method."""
    subclass = None
    superclass = None
    def __init__(self, source_type=None, tool_type=None, classxx=None, information_source_type=None, name=None, Description=None, Contributors=None, Time=None, Tools=None, Platform=None, System=None, Instance=None):
        self.source_type = _cast(None, source_type)
        self.tool_type = _cast(None, tool_type)
        self.classxx = _cast(None, classxx)
        self.information_source_type = _cast(None, information_source_type)
        self.name = _cast(None, name)
        self.Description = Description
        self.Contributors = Contributors
        self.Time = Time
        self.Tools = Tools
        self.Platform = Platform
        self.System = System
        self.Instance = Instance
    def factory(*args_, **kwargs_):
        if MeasureSourceType.subclass:
            return MeasureSourceType.subclass(*args_, **kwargs_)
        else:
            return MeasureSourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Contributors(self): return self.Contributors
    def set_Contributors(self, Contributors): self.Contributors = Contributors
    def get_Time(self): return self.Time
    def set_Time(self, Time): self.Time = Time
    def get_Tools(self): return self.Tools
    def set_Tools(self, Tools): self.Tools = Tools
    def get_Platform(self): return self.Platform
    def set_Platform(self, Platform): self.Platform = Platform
    def get_System(self): return self.System
    def set_System(self, System): self.System = System
    def get_Instance(self): return self.Instance
    def set_Instance(self, Instance): self.Instance = Instance
    def get_source_type(self): return self.source_type
    def set_source_type(self, source_type): self.source_type = source_type
    def get_tool_type(self): return self.tool_type
    def set_tool_type(self, tool_type): self.tool_type = tool_type
    def get_class(self): return self.classxx
    def set_class(self, classxx): self.classxx = classxx
    def get_information_source_type(self): return self.information_source_type
    def set_information_source_type(self, information_source_type): self.information_source_type = information_source_type
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='Common:', name_='MeasureSourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MeasureSourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='MeasureSourceType'):
        if self.source_type is not None and 'source_type' not in already_processed:
            already_processed.append('source_type')
            outfile.write(' source_type=%s' % (quote_attrib(self.source_type), ))
        if self.tool_type is not None and 'tool_type' not in already_processed:
            already_processed.append('tool_type')
            outfile.write(' tool_type=%s' % (quote_attrib(self.tool_type), ))
        if self.classxx is not None and 'classxx' not in already_processed:
            already_processed.append('classxx')
            outfile.write(' class=%s' % (quote_attrib(self.classxx), ))
        if self.information_source_type is not None and 'information_source_type' not in already_processed:
            already_processed.append('information_source_type')
            outfile.write(' information_source_type=%s' % (quote_attrib(self.information_source_type), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='MeasureSourceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, 'Common:', name_='Description', pretty_print=pretty_print)
        if self.Contributors is not None:
            self.Contributors.export(outfile, level, 'Common:', name_='Contributors', pretty_print=pretty_print)
        if self.Time is not None:
            self.Time.export(outfile, level, 'Common:', name_='Time', pretty_print=pretty_print)
        if self.Tools is not None:
            self.Tools.export(outfile, level, 'Common:', name_='Tools', pretty_print=pretty_print)
        if self.Platform is not None:
            self.Platform.export(outfile, level, 'Common:', name_='Platform', pretty_print=pretty_print)
        if self.System is not None:
            self.System.export(outfile, level, 'Common:', name_='System', pretty_print=pretty_print)
        if self.Instance is not None:
            self.Instance.export(outfile, level, 'Common:', name_='Instance', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Contributors is not None or
            self.Time is not None or
            self.Tools is not None or
            self.Platform is not None or
            self.System is not None or
            self.Instance is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MeasureSourceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.source_type is not None and 'source_type' not in already_processed:
            already_processed.append('source_type')
            showIndent(outfile, level)
            outfile.write('source_type = %s,\n' % (self.source_type,))
        if self.tool_type is not None and 'tool_type' not in already_processed:
            already_processed.append('tool_type')
            showIndent(outfile, level)
            outfile.write('tool_type = %s,\n' % (self.tool_type,))
        if self.classxx is not None and 'classxx' not in already_processed:
            already_processed.append('classxx')
            showIndent(outfile, level)
            outfile.write('classxx = %s,\n' % (self.classxx,))
        if self.information_source_type is not None and 'information_source_type' not in already_processed:
            already_processed.append('information_source_type')
            showIndent(outfile, level)
            outfile.write('information_source_type = %s,\n' % (self.information_source_type,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Contributors is not None:
            showIndent(outfile, level)
            outfile.write('Contributors=model_.PersonnelType(\n')
            self.Contributors.exportLiteral(outfile, level, name_='Contributors')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Time is not None:
            showIndent(outfile, level)
            outfile.write('Time=model_.TimeType(\n')
            self.Time.exportLiteral(outfile, level, name_='Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Tools is not None:
            showIndent(outfile, level)
            outfile.write('Tools=model_.ToolsInformationType(\n')
            self.Tools.exportLiteral(outfile, level, name_='Tools')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Platform is not None:
            showIndent(outfile, level)
            outfile.write('Platform=model_.CPESpecificationType(\n')
            self.Platform.exportLiteral(outfile, level, name_='Platform')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.System is not None:
            showIndent(outfile, level)
            outfile.write('System=model_.system_object_1_3.SystemObjectType(\n')
            self.System.exportLiteral(outfile, level, name_='System')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Instance is not None:
            showIndent(outfile, level)
            outfile.write('Instance=model_.process_object_1_3.ProcessObjectType(\n')
            self.Instance.exportLiteral(outfile, level, name_='Instance')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('source_type', node)
        if value is not None and 'source_type' not in already_processed:
            already_processed.append('source_type')
            self.source_type = value
        value = find_attr_value_('tool_type', node)
        if value is not None and 'tool_type' not in already_processed:
            already_processed.append('tool_type')
            self.tool_type = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.append('class')
            self.classxx = value
        value = find_attr_value_('information_source_type', node)
        if value is not None and 'information_source_type' not in already_processed:
            already_processed.append('information_source_type')
            self.information_source_type = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Contributors':
            obj_ = PersonnelType.factory()
            obj_.build(child_)
            self.set_Contributors(obj_)
        elif nodeName_ == 'Time':
            obj_ = TimeType.factory()
            obj_.build(child_)
            self.set_Time(obj_)
        elif nodeName_ == 'Tools':
            obj_ = ToolsInformationType.factory()
            obj_.build(child_)
            self.set_Tools(obj_)
        elif nodeName_ == 'Platform':
            obj_ = CPESpecificationType.factory()
            obj_.build(child_)
            self.set_Platform(obj_)
        elif nodeName_ == 'System':
            obj_ = system_object_1_3.SystemObjectType.factory()
            obj_.build(child_)
            self.set_System(obj_)
        elif nodeName_ == 'Instance':
            obj_ = process_object_1_3.ProcessObjectType.factory()
            obj_.build(child_)
            self.set_Instance(obj_)
# end class MeasureSourceType

class ContributorType(GeneratedsSuper):
    """The ContributorType represents a description of an individual who
    contributed as a source of cyber observation data."""
    subclass = None
    superclass = None
    def __init__(self, Role=None, Name=None, Email=None, Phone=None, Organization=None, Date=None, Contribution_Location=None):
        self.Role = Role
        self.Name = Name
        self.Email = Email
        self.Phone = Phone
        self.Organization = Organization
        self.Date = Date
        self.Contribution_Location = Contribution_Location
    def factory(*args_, **kwargs_):
        if ContributorType.subclass:
            return ContributorType.subclass(*args_, **kwargs_)
        else:
            return ContributorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Role(self): return self.Role
    def set_Role(self, Role): self.Role = Role
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Email(self): return self.Email
    def set_Email(self, Email): self.Email = Email
    def get_Phone(self): return self.Phone
    def set_Phone(self, Phone): self.Phone = Phone
    def get_Organization(self): return self.Organization
    def set_Organization(self, Organization): self.Organization = Organization
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def get_Contribution_Location(self): return self.Contribution_Location
    def set_Contribution_Location(self, Contribution_Location): self.Contribution_Location = Contribution_Location
    def export(self, outfile, level, namespace_='Common:', name_='ContributorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContributorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ContributorType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ContributorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Role is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRole>%s</%sRole>%s' % ('Common:', self.gds_format_string(quote_xml(self.Role).encode(ExternalEncoding), input_name='Role'), 'Common:', eol_))
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % ('Common:', self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), 'Common:', eol_))
        if self.Email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEmail>%s</%sEmail>%s' % ('Common:', self.gds_format_string(quote_xml(self.Email).encode(ExternalEncoding), input_name='Email'), 'Common:', eol_))
        if self.Phone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPhone>%s</%sPhone>%s' % ('Common:', self.gds_format_string(quote_xml(self.Phone).encode(ExternalEncoding), input_name='Phone'), 'Common:', eol_))
        if self.Organization is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOrganization>%s</%sOrganization>%s' % ('Common:', self.gds_format_string(quote_xml(self.Organization).encode(ExternalEncoding), input_name='Organization'), 'Common:', eol_))
        if self.Date is not None:
            self.Date.export(outfile, level, 'Common:', name_='Date', pretty_print=pretty_print)
        if self.Contribution_Location is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sContribution_Location>%s</%sContribution_Location>%s' % ('Common:', self.gds_format_string(quote_xml(self.Contribution_Location).encode(ExternalEncoding), input_name='Contribution_Location'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Role is not None or
            self.Name is not None or
            self.Email is not None or
            self.Phone is not None or
            self.Organization is not None or
            self.Date is not None or
            self.Contribution_Location is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContributorType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Role is not None:
            showIndent(outfile, level)
            outfile.write('Role=%s,\n' % quote_python(self.Role).encode(ExternalEncoding))
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Email is not None:
            showIndent(outfile, level)
            outfile.write('Email=%s,\n' % quote_python(self.Email).encode(ExternalEncoding))
        if self.Phone is not None:
            showIndent(outfile, level)
            outfile.write('Phone=%s,\n' % quote_python(self.Phone).encode(ExternalEncoding))
        if self.Organization is not None:
            showIndent(outfile, level)
            outfile.write('Organization=%s,\n' % quote_python(self.Organization).encode(ExternalEncoding))
        if self.Date is not None:
            showIndent(outfile, level)
            outfile.write('Date=model_.DateRangeType(\n')
            self.Date.exportLiteral(outfile, level, name_='Date')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Contribution_Location is not None:
            showIndent(outfile, level)
            outfile.write('Contribution_Location=%s,\n' % quote_python(self.Contribution_Location).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Role':
            Role_ = child_.text
            Role_ = self.gds_validate_string(Role_, node, 'Role')
            self.Role = Role_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Email':
            Email_ = child_.text
            Email_ = self.gds_validate_string(Email_, node, 'Email')
            self.Email = Email_
        elif nodeName_ == 'Phone':
            Phone_ = child_.text
            Phone_ = self.gds_validate_string(Phone_, node, 'Phone')
            self.Phone = Phone_
        elif nodeName_ == 'Organization':
            Organization_ = child_.text
            Organization_ = self.gds_validate_string(Organization_, node, 'Organization')
            self.Organization = Organization_
        elif nodeName_ == 'Date':
            obj_ = DateRangeType.factory()
            obj_.build(child_)
            self.set_Date(obj_)
        elif nodeName_ == 'Contribution_Location':
            Contribution_Location_ = child_.text
            Contribution_Location_ = self.gds_validate_string(Contribution_Location_, node, 'Contribution_Location')
            self.Contribution_Location = Contribution_Location_
# end class ContributorType

class DateRangeType(GeneratedsSuper):
    """The DateRangeType specifies a range of dates."""
    subclass = None
    superclass = None
    def __init__(self, Start_Date=None, End_Date=None):
        self.Start_Date = Start_Date
        self.End_Date = End_Date
    def factory(*args_, **kwargs_):
        if DateRangeType.subclass:
            return DateRangeType.subclass(*args_, **kwargs_)
        else:
            return DateRangeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Start_Date(self): return self.Start_Date
    def set_Start_Date(self, Start_Date): self.Start_Date = Start_Date
    def get_End_Date(self): return self.End_Date
    def set_End_Date(self, End_Date): self.End_Date = End_Date
    def export(self, outfile, level, namespace_='Common:', name_='DateRangeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DateRangeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DateRangeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DateRangeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Start_Date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStart_Date>%s</%sStart_Date>%s' % ('Common:', self.gds_format_string(quote_xml(self.Start_Date).encode(ExternalEncoding), input_name='Start_Date'), 'Common:', eol_))
        if self.End_Date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEnd_Date>%s</%sEnd_Date>%s' % ('Common:', self.gds_format_string(quote_xml(self.End_Date).encode(ExternalEncoding), input_name='End_Date'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Start_Date is not None or
            self.End_Date is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DateRangeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Start_Date is not None:
            showIndent(outfile, level)
            outfile.write('Start_Date=%s,\n' % quote_python(self.Start_Date).encode(ExternalEncoding))
        if self.End_Date is not None:
            showIndent(outfile, level)
            outfile.write('End_Date=%s,\n' % quote_python(self.End_Date).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Start_Date':
            Start_Date_ = child_.text
            Start_Date_ = self.gds_validate_string(Start_Date_, node, 'Start_Date')
            self.Start_Date = Start_Date_
        elif nodeName_ == 'End_Date':
            End_Date_ = child_.text
            End_Date_ = self.gds_validate_string(End_Date_, node, 'End_Date')
            self.End_Date = End_Date_
# end class DateRangeType

class PersonnelType(GeneratedsSuper):
    """The PersonnelType is an abstracted data type to standardize the
    description of sets of personnel."""
    subclass = None
    superclass = None
    def __init__(self, Contributor=None):
        if Contributor is None:
            self.Contributor = []
        else:
            self.Contributor = Contributor
    def factory(*args_, **kwargs_):
        if PersonnelType.subclass:
            return PersonnelType.subclass(*args_, **kwargs_)
        else:
            return PersonnelType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Contributor(self): return self.Contributor
    def set_Contributor(self, Contributor): self.Contributor = Contributor
    def add_Contributor(self, value): self.Contributor.append(value)
    def insert_Contributor(self, index, value): self.Contributor[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='PersonnelType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PersonnelType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='PersonnelType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='PersonnelType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Contributor_ in self.Contributor:
            Contributor_.export(outfile, level, 'Common:', name_='Contributor', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Contributor
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PersonnelType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Contributor=[\n')
        level += 1
        for Contributor_ in self.Contributor:
            showIndent(outfile, level)
            outfile.write('model_.ContributorType(\n')
            Contributor_.exportLiteral(outfile, level, name_='ContributorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Contributor':
            obj_ = ContributorType.factory()
            obj_.build(child_)
            self.Contributor.append(obj_)
# end class PersonnelType

class TimeType(GeneratedsSuper):
    """The TimeType specifies various time properties for a cyber
    observation source."""
    subclass = None
    superclass = None
    def __init__(self, Start_Time=None, End_Time=None, Produced_Time=None, Received_Time=None):
        self.Start_Time = Start_Time
        self.End_Time = End_Time
        self.Produced_Time = Produced_Time
        self.Received_Time = Received_Time
    def factory(*args_, **kwargs_):
        if TimeType.subclass:
            return TimeType.subclass(*args_, **kwargs_)
        else:
            return TimeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Start_Time(self): return self.Start_Time
    def set_Start_Time(self, Start_Time): self.Start_Time = Start_Time
    def get_End_Time(self): return self.End_Time
    def set_End_Time(self, End_Time): self.End_Time = End_Time
    def get_Produced_Time(self): return self.Produced_Time
    def set_Produced_Time(self, Produced_Time): self.Produced_Time = Produced_Time
    def get_Received_Time(self): return self.Received_Time
    def set_Received_Time(self, Received_Time): self.Received_Time = Received_Time
    def export(self, outfile, level, namespace_='Common:', name_='TimeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='TimeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='TimeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Start_Time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStart_Time>%s</%sStart_Time>%s' % ('Common:', self.gds_format_string(quote_xml(self.Start_Time).encode(ExternalEncoding), input_name='Start_Time'), 'Common:', eol_))
        if self.End_Time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEnd_Time>%s</%sEnd_Time>%s' % ('Common:', self.gds_format_string(quote_xml(self.End_Time).encode(ExternalEncoding), input_name='End_Time'), 'Common:', eol_))
        if self.Produced_Time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduced_Time>%s</%sProduced_Time>%s' % ('Common:', self.gds_format_string(quote_xml(self.Produced_Time).encode(ExternalEncoding), input_name='Produced_Time'), 'Common:', eol_))
        if self.Received_Time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReceived_Time>%s</%sReceived_Time>%s' % ('Common:', self.gds_format_string(quote_xml(self.Received_Time).encode(ExternalEncoding), input_name='Received_Time'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Start_Time is not None or
            self.End_Time is not None or
            self.Produced_Time is not None or
            self.Received_Time is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TimeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Start_Time is not None:
            showIndent(outfile, level)
            outfile.write('Start_Time=%s,\n' % quote_python(self.Start_Time).encode(ExternalEncoding))
        if self.End_Time is not None:
            showIndent(outfile, level)
            outfile.write('End_Time=%s,\n' % quote_python(self.End_Time).encode(ExternalEncoding))
        if self.Produced_Time is not None:
            showIndent(outfile, level)
            outfile.write('Produced_Time=%s,\n' % quote_python(self.Produced_Time).encode(ExternalEncoding))
        if self.Received_Time is not None:
            showIndent(outfile, level)
            outfile.write('Received_Time=%s,\n' % quote_python(self.Received_Time).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Start_Time':
            Start_Time_ = child_.text
            Start_Time_ = self.gds_validate_string(Start_Time_, node, 'Start_Time')
            self.Start_Time = Start_Time_
        elif nodeName_ == 'End_Time':
            End_Time_ = child_.text
            End_Time_ = self.gds_validate_string(End_Time_, node, 'End_Time')
            self.End_Time = End_Time_
        elif nodeName_ == 'Produced_Time':
            Produced_Time_ = child_.text
            Produced_Time_ = self.gds_validate_string(Produced_Time_, node, 'Produced_Time')
            self.Produced_Time = Produced_Time_
        elif nodeName_ == 'Received_Time':
            Received_Time_ = child_.text
            Received_Time_ = self.gds_validate_string(Received_Time_, node, 'Received_Time')
            self.Received_Time = Received_Time_
# end class TimeType

class ToolSpecificDataType(GeneratedsSuper):
    """The ToolSpecificDataType is an Abstract type placeholder within the
    CybOX schema enabling the inclusion of metadata for a specific
    type of tool through the use of a custom type defined as an
    extension of this base Abstract type."""
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if ToolSpecificDataType.subclass:
            return ToolSpecificDataType.subclass(*args_, **kwargs_)
        else:
            return ToolSpecificDataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='Common:', name_='ToolSpecificDataType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ToolSpecificDataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ToolSpecificDataType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ToolSpecificDataType', fromsubclass_=False, pretty_print=True):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ToolSpecificDataType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ToolSpecificDataType

class ToolsInformationType(GeneratedsSuper):
    """The ToolsInformationType represents a description of a set of
    automated tools."""
    subclass = None
    superclass = None
    def __init__(self, Tool=None):
        if Tool is None:
            self.Tool = []
        else:
            self.Tool = Tool
    def factory(*args_, **kwargs_):
        if ToolsInformationType.subclass:
            return ToolsInformationType.subclass(*args_, **kwargs_)
        else:
            return ToolsInformationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Tool(self): return self.Tool
    def set_Tool(self, Tool): self.Tool = Tool
    def add_Tool(self, value): self.Tool.append(value)
    def insert_Tool(self, index, value): self.Tool[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='ToolsInformationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ToolsInformationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ToolsInformationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ToolsInformationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Tool_ in self.Tool:
            Tool_.export(outfile, level, 'Common:', name_='Tool', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Tool
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ToolsInformationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Tool=[\n')
        level += 1
        for Tool_ in self.Tool:
            showIndent(outfile, level)
            outfile.write('model_.ToolInformationType(\n')
            Tool_.exportLiteral(outfile, level, name_='ToolInformationType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Tool':
            obj_ = ToolInformationType.factory()
            obj_.build(child_)
            self.Tool.append(obj_)
# end class ToolsInformationType

class ToolInformationType(GeneratedsSuper):
    """The ToolInformationType represens a description of a single
    automated tool.The id attribute specifies a unique ID for this
    Tool.The idref attribute specifies reference to a unique ID for
    this Tool."""
    subclass = None
    superclass = None
    def __init__(self, idref=None, id=None, Description=None, Vendor=None, Name=None, Version=None, Service_Pack=None, Tool_specific_Data=None, Tool_Hashes=None, Tool_Configuration=None, Execution_Environment=None, Errors=None, Metadata=None):
        self.idref = _cast(None, idref)
        self.id = _cast(None, id)
        self.Description = Description
        self.Vendor = Vendor
        self.Name = Name
        self.Version = Version
        self.Service_Pack = Service_Pack
        self.Tool_specific_Data = Tool_specific_Data
        self.Tool_Hashes = Tool_Hashes
        self.Tool_Configuration = Tool_Configuration
        self.Execution_Environment = Execution_Environment
        self.Errors = Errors
        if Metadata is None:
            self.Metadata = []
        else:
            self.Metadata = Metadata
    def factory(*args_, **kwargs_):
        if ToolInformationType.subclass:
            return ToolInformationType.subclass(*args_, **kwargs_)
        else:
            return ToolInformationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Vendor(self): return self.Vendor
    def set_Vendor(self, Vendor): self.Vendor = Vendor
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_Service_Pack(self): return self.Service_Pack
    def set_Service_Pack(self, Service_Pack): self.Service_Pack = Service_Pack
    def get_Tool_specific_Data(self): return self.Tool_specific_Data
    def set_Tool_specific_Data(self, Tool_specific_Data): self.Tool_specific_Data = Tool_specific_Data
    def get_Tool_Hashes(self): return self.Tool_Hashes
    def set_Tool_Hashes(self, Tool_Hashes): self.Tool_Hashes = Tool_Hashes
    def get_Tool_Configuration(self): return self.Tool_Configuration
    def set_Tool_Configuration(self, Tool_Configuration): self.Tool_Configuration = Tool_Configuration
    def get_Execution_Environment(self): return self.Execution_Environment
    def set_Execution_Environment(self, Execution_Environment): self.Execution_Environment = Execution_Environment
    def get_Errors(self): return self.Errors
    def set_Errors(self, Errors): self.Errors = Errors
    def get_Metadata(self): return self.Metadata
    def set_Metadata(self, Metadata): self.Metadata = Metadata
    def add_Metadata(self, value): self.Metadata.append(value)
    def insert_Metadata(self, index, value): self.Metadata[index] = value
    def get_idref(self): return self.idref
    def set_idref(self, idref): self.idref = idref
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='Common:', name_='ToolInformationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ToolInformationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ToolInformationType'):
        if self.idref is not None and 'idref' not in already_processed:
            already_processed.append('idref')
            outfile.write(' idref=%s' % (quote_attrib(self.idref), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ToolInformationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, 'Common:', name_='Description', pretty_print=pretty_print)
        if self.Vendor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVendor>%s</%sVendor>%s' % ('Common:', self.gds_format_string(quote_xml(self.Vendor).encode(ExternalEncoding), input_name='Vendor'), 'Common:', eol_))
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % ('Common:', self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), 'Common:', eol_))
        if self.Version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVersion>%s</%sVersion>%s' % ('Common:', self.gds_format_string(quote_xml(self.Version).encode(ExternalEncoding), input_name='Version'), 'Common:', eol_))
        if self.Service_Pack is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sService_Pack>%s</%sService_Pack>%s' % ('Common:', self.gds_format_string(quote_xml(self.Service_Pack).encode(ExternalEncoding), input_name='Service_Pack'), 'Common:', eol_))
        if self.Tool_specific_Data is not None:
            self.Tool_specific_Data.export(outfile, level, 'Common:', name_='Tool_specific_Data', pretty_print=pretty_print)
        if self.Tool_Hashes is not None:
            self.Tool_Hashes.export(outfile, level, 'Common:', name_='Tool_Hashes', pretty_print=pretty_print)
        if self.Tool_Configuration is not None:
            self.Tool_Configuration.export(outfile, level, 'Common:', name_='Tool_Configuration', pretty_print=pretty_print)
        if self.Execution_Environment is not None:
            self.Execution_Environment.export(outfile, level, 'Common:', name_='Execution_Environment', pretty_print=pretty_print)
        if self.Errors is not None:
            self.Errors.export(outfile, level, 'Common:', name_='Errors', pretty_print=pretty_print)
        for Metadata_ in self.Metadata:
            Metadata_.export(outfile, level, 'Common:', name_='Metadata', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Vendor is not None or
            self.Name is not None or
            self.Version is not None or
            self.Service_Pack is not None or
            self.Tool_specific_Data is not None or
            self.Tool_Hashes is not None or
            self.Tool_Configuration is not None or
            self.Execution_Environment is not None or
            self.Errors is not None or
            self.Metadata
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ToolInformationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.idref is not None and 'idref' not in already_processed:
            already_processed.append('idref')
            showIndent(outfile, level)
            outfile.write('idref = %s,\n' % (self.idref,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Vendor is not None:
            showIndent(outfile, level)
            outfile.write('Vendor=%s,\n' % quote_python(self.Vendor).encode(ExternalEncoding))
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('Version=%s,\n' % quote_python(self.Version).encode(ExternalEncoding))
        if self.Service_Pack is not None:
            showIndent(outfile, level)
            outfile.write('Service_Pack=%s,\n' % quote_python(self.Service_Pack).encode(ExternalEncoding))
        if self.ToolSpecificDataType is not None:
            showIndent(outfile, level)
            outfile.write('ToolSpecificDataType=model_.ToolSpecificDataType(\n')
            self.ToolSpecificDataType.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Tool_Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Tool_Hashes=model_.HashListType(\n')
            self.Tool_Hashes.exportLiteral(outfile, level, name_='Tool_Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Tool_Configuration is not None:
            showIndent(outfile, level)
            outfile.write('Tool_Configuration=model_.ToolConfigurationType(\n')
            self.Tool_Configuration.exportLiteral(outfile, level, name_='Tool_Configuration')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Execution_Environment is not None:
            showIndent(outfile, level)
            outfile.write('Execution_Environment=model_.ExecutionEnvironmentType(\n')
            self.Execution_Environment.exportLiteral(outfile, level, name_='Execution_Environment')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Errors is not None:
            showIndent(outfile, level)
            outfile.write('Errors=model_.ErrorsType(\n')
            self.Errors.exportLiteral(outfile, level, name_='Errors')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Metadata=[\n')
        level += 1
        for Metadata_ in self.Metadata:
            showIndent(outfile, level)
            outfile.write('model_.MetadataType(\n')
            Metadata_.exportLiteral(outfile, level, name_='MetadataType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('idref', node)
        if value is not None and 'idref' not in already_processed:
            already_processed.append('idref')
            self.idref = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Vendor':
            Vendor_ = child_.text
            Vendor_ = self.gds_validate_string(Vendor_, node, 'Vendor')
            self.Vendor = Vendor_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Version':
            Version_ = child_.text
            Version_ = self.gds_validate_string(Version_, node, 'Version')
            self.Version = Version_
        elif nodeName_ == 'Service_Pack':
            Service_Pack_ = child_.text
            Service_Pack_ = self.gds_validate_string(Service_Pack_, node, 'Service_Pack')
            self.Service_Pack = Service_Pack_
        elif nodeName_ == 'Tool-specific_Data':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <Tool_specific_Data> element')
            self.set_Tool_specific_Data(obj_)
        elif nodeName_ == 'Tool_Hashes':
            obj_ = HashListType.factory()
            obj_.build(child_)
            self.set_Tool_Hashes(obj_)
        elif nodeName_ == 'Tool_Configuration':
            obj_ = ToolConfigurationType.factory()
            obj_.build(child_)
            self.set_Tool_Configuration(obj_)
        elif nodeName_ == 'Execution_Environment':
            obj_ = ExecutionEnvironmentType.factory()
            obj_.build(child_)
            self.set_Execution_Environment(obj_)
        elif nodeName_ == 'Errors':
            obj_ = ErrorsType.factory()
            obj_.build(child_)
            self.set_Errors(obj_)
        elif nodeName_ == 'Metadata':
            obj_ = MetadataType.factory()
            obj_.build(child_)
            self.Metadata.append(obj_)
# end class ToolInformationType

class ToolConfigurationType(GeneratedsSuper):
    """The ToolConfigurationType characterizes the configuration for a tool
    used as a cyber observation source."""
    subclass = None
    superclass = None
    def __init__(self, Configuration_Settings=None, Dependencies=None, Usage_Context_Assumptions=None, Internationalization_Settings=None, Build_Information=None):
        self.Configuration_Settings = Configuration_Settings
        self.Dependencies = Dependencies
        self.Usage_Context_Assumptions = Usage_Context_Assumptions
        self.Internationalization_Settings = Internationalization_Settings
        self.Build_Information = Build_Information
    def factory(*args_, **kwargs_):
        if ToolConfigurationType.subclass:
            return ToolConfigurationType.subclass(*args_, **kwargs_)
        else:
            return ToolConfigurationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Configuration_Settings(self): return self.Configuration_Settings
    def set_Configuration_Settings(self, Configuration_Settings): self.Configuration_Settings = Configuration_Settings
    def get_Dependencies(self): return self.Dependencies
    def set_Dependencies(self, Dependencies): self.Dependencies = Dependencies
    def get_Usage_Context_Assumptions(self): return self.Usage_Context_Assumptions
    def set_Usage_Context_Assumptions(self, Usage_Context_Assumptions): self.Usage_Context_Assumptions = Usage_Context_Assumptions
    def get_Internationalization_Settings(self): return self.Internationalization_Settings
    def set_Internationalization_Settings(self, Internationalization_Settings): self.Internationalization_Settings = Internationalization_Settings
    def get_Build_Information(self): return self.Build_Information
    def set_Build_Information(self, Build_Information): self.Build_Information = Build_Information
    def export(self, outfile, level, namespace_='Common:', name_='ToolConfigurationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ToolConfigurationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ToolConfigurationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ToolConfigurationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Configuration_Settings is not None:
            self.Configuration_Settings.export(outfile, level, 'Common:', name_='Configuration_Settings', pretty_print=pretty_print)
        if self.Dependencies is not None:
            self.Dependencies.export(outfile, level, 'Common:', name_='Dependencies', pretty_print=pretty_print)
        if self.Usage_Context_Assumptions is not None:
            self.Usage_Context_Assumptions.export(outfile, level, 'Common:', name_='Usage_Context_Assumptions', pretty_print=pretty_print)
        if self.Internationalization_Settings is not None:
            self.Internationalization_Settings.export(outfile, level, 'Common:', name_='Internationalization_Settings', pretty_print=pretty_print)
        if self.Build_Information is not None:
            self.Build_Information.export(outfile, level, 'Common:', name_='Build_Information', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Configuration_Settings is not None or
            self.Dependencies is not None or
            self.Usage_Context_Assumptions is not None or
            self.Internationalization_Settings is not None or
            self.Build_Information is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ToolConfigurationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Configuration_Settings is not None:
            showIndent(outfile, level)
            outfile.write('Configuration_Settings=model_.ConfigurationSettingsType(\n')
            self.Configuration_Settings.exportLiteral(outfile, level, name_='Configuration_Settings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Dependencies is not None:
            showIndent(outfile, level)
            outfile.write('Dependencies=model_.DependenciesType(\n')
            self.Dependencies.exportLiteral(outfile, level, name_='Dependencies')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Usage_Context_Assumptions is not None:
            showIndent(outfile, level)
            outfile.write('Usage_Context_Assumptions=model_.UsageContextAssumptionsType(\n')
            self.Usage_Context_Assumptions.exportLiteral(outfile, level, name_='Usage_Context_Assumptions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Internationalization_Settings is not None:
            showIndent(outfile, level)
            outfile.write('Internationalization_Settings=model_.InternationalizationSettingsType(\n')
            self.Internationalization_Settings.exportLiteral(outfile, level, name_='Internationalization_Settings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Build_Information is not None:
            showIndent(outfile, level)
            outfile.write('Build_Information=model_.BuildInformationType(\n')
            self.Build_Information.exportLiteral(outfile, level, name_='Build_Information')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Configuration_Settings':
            obj_ = ConfigurationSettingsType.factory()
            obj_.build(child_)
            self.set_Configuration_Settings(obj_)
        elif nodeName_ == 'Dependencies':
            obj_ = DependenciesType.factory()
            obj_.build(child_)
            self.set_Dependencies(obj_)
        elif nodeName_ == 'Usage_Context_Assumptions':
            obj_ = UsageContextAssumptionsType.factory()
            obj_.build(child_)
            self.set_Usage_Context_Assumptions(obj_)
        elif nodeName_ == 'Internationalization_Settings':
            obj_ = InternationalizationSettingsType.factory()
            obj_.build(child_)
            self.set_Internationalization_Settings(obj_)
        elif nodeName_ == 'Build_Information':
            obj_ = BuildInformationType.factory()
            obj_.build(child_)
            self.set_Build_Information(obj_)
# end class ToolConfigurationType

class ConfigurationSettingsType(GeneratedsSuper):
    """The ConfigurationSettingsType is a modularized data type used to
    provide a consistent approach to describing configuration
    settings for a tool, application or other cyber object"""
    subclass = None
    superclass = None
    def __init__(self, Configuration_Setting=None):
        if Configuration_Setting is None:
            self.Configuration_Setting = []
        else:
            self.Configuration_Setting = Configuration_Setting
    def factory(*args_, **kwargs_):
        if ConfigurationSettingsType.subclass:
            return ConfigurationSettingsType.subclass(*args_, **kwargs_)
        else:
            return ConfigurationSettingsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Configuration_Setting(self): return self.Configuration_Setting
    def set_Configuration_Setting(self, Configuration_Setting): self.Configuration_Setting = Configuration_Setting
    def add_Configuration_Setting(self, value): self.Configuration_Setting.append(value)
    def insert_Configuration_Setting(self, index, value): self.Configuration_Setting[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='ConfigurationSettingsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigurationSettingsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ConfigurationSettingsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ConfigurationSettingsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Configuration_Setting_ in self.Configuration_Setting:
            Configuration_Setting_.export(outfile, level, 'Common:', name_='Configuration_Setting', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Configuration_Setting
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ConfigurationSettingsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Configuration_Setting=[\n')
        level += 1
        for Configuration_Setting_ in self.Configuration_Setting:
            showIndent(outfile, level)
            outfile.write('model_.ConfigurationSettingType(\n')
            Configuration_Setting_.exportLiteral(outfile, level, name_='ConfigurationSettingType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Configuration_Setting':
            obj_ = ConfigurationSettingType.factory()
            obj_.build(child_)
            self.Configuration_Setting.append(obj_)
# end class ConfigurationSettingsType

class ConfigurationSettingType(GeneratedsSuper):
    """The ConfigurationSettingType is a modularized data type used to
    provide a consistent approach to describing a particular
    configuration setting for a tool, application or other cyber
    object"""
    subclass = None
    superclass = None
    def __init__(self, Item_Name=None, Item_Value=None, Item_Type=None, Item_Description=None):
        self.Item_Name = Item_Name
        self.Item_Value = Item_Value
        self.Item_Type = Item_Type
        self.Item_Description = Item_Description
    def factory(*args_, **kwargs_):
        if ConfigurationSettingType.subclass:
            return ConfigurationSettingType.subclass(*args_, **kwargs_)
        else:
            return ConfigurationSettingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Item_Name(self): return self.Item_Name
    def set_Item_Name(self, Item_Name): self.Item_Name = Item_Name
    def get_Item_Value(self): return self.Item_Value
    def set_Item_Value(self, Item_Value): self.Item_Value = Item_Value
    def get_Item_Type(self): return self.Item_Type
    def set_Item_Type(self, Item_Type): self.Item_Type = Item_Type
    def get_Item_Description(self): return self.Item_Description
    def set_Item_Description(self, Item_Description): self.Item_Description = Item_Description
    def export(self, outfile, level, namespace_='Common:', name_='ConfigurationSettingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigurationSettingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ConfigurationSettingType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ConfigurationSettingType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Item_Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sItem_Name>%s</%sItem_Name>%s' % ('Common:', self.gds_format_string(quote_xml(self.Item_Name).encode(ExternalEncoding), input_name='Item_Name'), 'Common:', eol_))
        if self.Item_Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sItem_Value>%s</%sItem_Value>%s' % ('Common:', self.gds_format_string(quote_xml(self.Item_Value).encode(ExternalEncoding), input_name='Item_Value'), 'Common:', eol_))
        if self.Item_Type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sItem_Type>%s</%sItem_Type>%s' % ('Common:', self.gds_format_string(quote_xml(self.Item_Type).encode(ExternalEncoding), input_name='Item_Type'), 'Common:', eol_))
        if self.Item_Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sItem_Description>%s</%sItem_Description>%s' % ('Common:', self.gds_format_string(quote_xml(self.Item_Description).encode(ExternalEncoding), input_name='Item_Description'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Item_Name is not None or
            self.Item_Value is not None or
            self.Item_Type is not None or
            self.Item_Description is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ConfigurationSettingType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Item_Name is not None:
            showIndent(outfile, level)
            outfile.write('Item_Name=%s,\n' % quote_python(self.Item_Name).encode(ExternalEncoding))
        if self.Item_Value is not None:
            showIndent(outfile, level)
            outfile.write('Item_Value=%s,\n' % quote_python(self.Item_Value).encode(ExternalEncoding))
        if self.Item_Type is not None:
            showIndent(outfile, level)
            outfile.write('Item_Type=%s,\n' % quote_python(self.Item_Type).encode(ExternalEncoding))
        if self.Item_Description is not None:
            showIndent(outfile, level)
            outfile.write('Item_Description=%s,\n' % quote_python(self.Item_Description).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Item_Name':
            Item_Name_ = child_.text
            Item_Name_ = self.gds_validate_string(Item_Name_, node, 'Item_Name')
            self.Item_Name = Item_Name_
        elif nodeName_ == 'Item_Value':
            Item_Value_ = child_.text
            Item_Value_ = self.gds_validate_string(Item_Value_, node, 'Item_Value')
            self.Item_Value = Item_Value_
        elif nodeName_ == 'Item_Type':
            Item_Type_ = child_.text
            Item_Type_ = self.gds_validate_string(Item_Type_, node, 'Item_Type')
            self.Item_Type = Item_Type_
        elif nodeName_ == 'Item_Description':
            Item_Description_ = child_.text
            Item_Description_ = self.gds_validate_string(Item_Description_, node, 'Item_Description')
            self.Item_Description = Item_Description_
# end class ConfigurationSettingType

class DependenciesType(GeneratedsSuper):
    """The DependenciesType contains information describing a set of
    dependencies for this tool."""
    subclass = None
    superclass = None
    def __init__(self, Dependency=None):
        if Dependency is None:
            self.Dependency = []
        else:
            self.Dependency = Dependency
    def factory(*args_, **kwargs_):
        if DependenciesType.subclass:
            return DependenciesType.subclass(*args_, **kwargs_)
        else:
            return DependenciesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Dependency(self): return self.Dependency
    def set_Dependency(self, Dependency): self.Dependency = Dependency
    def add_Dependency(self, value): self.Dependency.append(value)
    def insert_Dependency(self, index, value): self.Dependency[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='DependenciesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DependenciesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DependenciesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DependenciesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Dependency_ in self.Dependency:
            Dependency_.export(outfile, level, 'Common:', name_='Dependency', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Dependency
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DependenciesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Dependency=[\n')
        level += 1
        for Dependency_ in self.Dependency:
            showIndent(outfile, level)
            outfile.write('model_.DependencyType(\n')
            Dependency_.exportLiteral(outfile, level, name_='DependencyType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Dependency':
            obj_ = DependencyType.factory()
            obj_.build(child_)
            self.Dependency.append(obj_)
# end class DependenciesType

class DependencyType(GeneratedsSuper):
    """The DependencyType contains information describing a single
    dependency for this tool."""
    subclass = None
    superclass = None
    def __init__(self, Dependency_Type=None, Dependency_Description=None):
        self.Dependency_Type = Dependency_Type
        self.Dependency_Description = Dependency_Description
    def factory(*args_, **kwargs_):
        if DependencyType.subclass:
            return DependencyType.subclass(*args_, **kwargs_)
        else:
            return DependencyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Dependency_Type(self): return self.Dependency_Type
    def set_Dependency_Type(self, Dependency_Type): self.Dependency_Type = Dependency_Type
    def get_Dependency_Description(self): return self.Dependency_Description
    def set_Dependency_Description(self, Dependency_Description): self.Dependency_Description = Dependency_Description
    def export(self, outfile, level, namespace_='Common:', name_='DependencyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DependencyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DependencyType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DependencyType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Dependency_Type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDependency_Type>%s</%sDependency_Type>%s' % ('Common:', self.gds_format_string(quote_xml(self.Dependency_Type).encode(ExternalEncoding), input_name='Dependency_Type'), 'Common:', eol_))
        if self.Dependency_Description is not None:
            self.Dependency_Description.export(outfile, level, 'Common:', name_='Dependency_Description', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Dependency_Type is not None or
            self.Dependency_Description is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DependencyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Dependency_Type is not None:
            showIndent(outfile, level)
            outfile.write('Dependency_Type=%s,\n' % quote_python(self.Dependency_Type).encode(ExternalEncoding))
        if self.Dependency_Description is not None:
            showIndent(outfile, level)
            outfile.write('Dependency_Description=model_.StructuredTextType(\n')
            self.Dependency_Description.exportLiteral(outfile, level, name_='Dependency_Description')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Dependency_Type':
            Dependency_Type_ = child_.text
            Dependency_Type_ = self.gds_validate_string(Dependency_Type_, node, 'Dependency_Type')
            self.Dependency_Type = Dependency_Type_
        elif nodeName_ == 'Dependency_Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Dependency_Description(obj_)
# end class DependencyType

class UsageContextAssumptionsType(GeneratedsSuper):
    """The UsageContextAssumptionsType contains descriptions of the various
    relevant usage context assumptions for this tool"""
    subclass = None
    superclass = None
    def __init__(self, Usage_Context_Assumption=None):
        if Usage_Context_Assumption is None:
            self.Usage_Context_Assumption = []
        else:
            self.Usage_Context_Assumption = Usage_Context_Assumption
    def factory(*args_, **kwargs_):
        if UsageContextAssumptionsType.subclass:
            return UsageContextAssumptionsType.subclass(*args_, **kwargs_)
        else:
            return UsageContextAssumptionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Usage_Context_Assumption(self): return self.Usage_Context_Assumption
    def set_Usage_Context_Assumption(self, Usage_Context_Assumption): self.Usage_Context_Assumption = Usage_Context_Assumption
    def add_Usage_Context_Assumption(self, value): self.Usage_Context_Assumption.append(value)
    def insert_Usage_Context_Assumption(self, index, value): self.Usage_Context_Assumption[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='UsageContextAssumptionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UsageContextAssumptionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='UsageContextAssumptionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='UsageContextAssumptionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Usage_Context_Assumption_ in self.Usage_Context_Assumption:
            Usage_Context_Assumption_.export(outfile, level, 'Common:', name_='Usage_Context_Assumption', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Usage_Context_Assumption
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='UsageContextAssumptionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Usage_Context_Assumption=[\n')
        level += 1
        for Usage_Context_Assumption_ in self.Usage_Context_Assumption:
            showIndent(outfile, level)
            outfile.write('model_.StructuredTextType(\n')
            Usage_Context_Assumption_.exportLiteral(outfile, level, name_='StructuredTextType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Usage_Context_Assumption':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.Usage_Context_Assumption.append(obj_)
# end class UsageContextAssumptionsType

class InternationalizationSettingsType(GeneratedsSuper):
    """The InternationalizationSettingsType contains information describing
    relevant internationalization setting for this tool"""
    subclass = None
    superclass = None
    def __init__(self, Internal_Strings=None):
        if Internal_Strings is None:
            self.Internal_Strings = []
        else:
            self.Internal_Strings = Internal_Strings
    def factory(*args_, **kwargs_):
        if InternationalizationSettingsType.subclass:
            return InternationalizationSettingsType.subclass(*args_, **kwargs_)
        else:
            return InternationalizationSettingsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Internal_Strings(self): return self.Internal_Strings
    def set_Internal_Strings(self, Internal_Strings): self.Internal_Strings = Internal_Strings
    def add_Internal_Strings(self, value): self.Internal_Strings.append(value)
    def insert_Internal_Strings(self, index, value): self.Internal_Strings[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='InternationalizationSettingsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InternationalizationSettingsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='InternationalizationSettingsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='InternationalizationSettingsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Internal_Strings_ in self.Internal_Strings:
            Internal_Strings_.export(outfile, level, 'Common:', name_='Internal_Strings', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Internal_Strings
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='InternationalizationSettingsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Internal_Strings=[\n')
        level += 1
        for Internal_Strings_ in self.Internal_Strings:
            showIndent(outfile, level)
            outfile.write('model_.InternalStringsType(\n')
            Internal_Strings_.exportLiteral(outfile, level, name_='InternalStringsType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Internal_Strings':
            obj_ = InternalStringsType.factory()
            obj_.build(child_)
            self.Internal_Strings.append(obj_)
# end class InternationalizationSettingsType

class InternalStringsType(GeneratedsSuper):
    """The InternalStringsType contains a single internal string instance
    for this internationalization setting instance."""
    subclass = None
    superclass = None
    def __init__(self, Key=None, Content=None):
        self.Key = Key
        self.Content = Content
    def factory(*args_, **kwargs_):
        if InternalStringsType.subclass:
            return InternalStringsType.subclass(*args_, **kwargs_)
        else:
            return InternalStringsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Key(self): return self.Key
    def set_Key(self, Key): self.Key = Key
    def get_Content(self): return self.Content
    def set_Content(self, Content): self.Content = Content
    def export(self, outfile, level, namespace_='Common:', name_='InternalStringsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InternalStringsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='InternalStringsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='InternalStringsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sKey>%s</%sKey>%s' % ('Common:', self.gds_format_string(quote_xml(self.Key).encode(ExternalEncoding), input_name='Key'), 'Common:', eol_))
        if self.Content is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sContent>%s</%sContent>%s' % ('Common:', self.gds_format_string(quote_xml(self.Content).encode(ExternalEncoding), input_name='Content'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Key is not None or
            self.Content is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='InternalStringsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Key is not None:
            showIndent(outfile, level)
            outfile.write('Key=%s,\n' % quote_python(self.Key).encode(ExternalEncoding))
        if self.Content is not None:
            showIndent(outfile, level)
            outfile.write('Content=%s,\n' % quote_python(self.Content).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Key':
            Key_ = child_.text
            Key_ = self.gds_validate_string(Key_, node, 'Key')
            self.Key = Key_
        elif nodeName_ == 'Content':
            Content_ = child_.text
            Content_ = self.gds_validate_string(Content_, node, 'Content')
            self.Content = Content_
# end class InternalStringsType

class BuildInformationType(GeneratedsSuper):
    """The BuildInformationType contains information describing how this
    tool was built."""
    subclass = None
    superclass = None
    def __init__(self, Build_ID=None, Build_Project=None, Build_Utility=None, Build_Version=None, Build_Label=None, Compilers=None, Compilation_Date=None, Build_Configuration=None, Build_Script=None, Libraries=None, Build_Output_Log=None):
        self.Build_ID = Build_ID
        self.Build_Project = Build_Project
        self.Build_Utility = Build_Utility
        self.Build_Version = Build_Version
        self.Build_Label = Build_Label
        self.Compilers = Compilers
        self.Compilation_Date = Compilation_Date
        self.Build_Configuration = Build_Configuration
        self.Build_Script = Build_Script
        self.Libraries = Libraries
        self.Build_Output_Log = Build_Output_Log
    def factory(*args_, **kwargs_):
        if BuildInformationType.subclass:
            return BuildInformationType.subclass(*args_, **kwargs_)
        else:
            return BuildInformationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Build_ID(self): return self.Build_ID
    def set_Build_ID(self, Build_ID): self.Build_ID = Build_ID
    def get_Build_Project(self): return self.Build_Project
    def set_Build_Project(self, Build_Project): self.Build_Project = Build_Project
    def get_Build_Utility(self): return self.Build_Utility
    def set_Build_Utility(self, Build_Utility): self.Build_Utility = Build_Utility
    def get_Build_Version(self): return self.Build_Version
    def set_Build_Version(self, Build_Version): self.Build_Version = Build_Version
    def get_Build_Label(self): return self.Build_Label
    def set_Build_Label(self, Build_Label): self.Build_Label = Build_Label
    def get_Compilers(self): return self.Compilers
    def set_Compilers(self, Compilers): self.Compilers = Compilers
    def get_Compilation_Date(self): return self.Compilation_Date
    def set_Compilation_Date(self, Compilation_Date): self.Compilation_Date = Compilation_Date
    def get_Build_Configuration(self): return self.Build_Configuration
    def set_Build_Configuration(self, Build_Configuration): self.Build_Configuration = Build_Configuration
    def get_Build_Script(self): return self.Build_Script
    def set_Build_Script(self, Build_Script): self.Build_Script = Build_Script
    def get_Libraries(self): return self.Libraries
    def set_Libraries(self, Libraries): self.Libraries = Libraries
    def get_Build_Output_Log(self): return self.Build_Output_Log
    def set_Build_Output_Log(self, Build_Output_Log): self.Build_Output_Log = Build_Output_Log
    def export(self, outfile, level, namespace_='Common:', name_='BuildInformationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BuildInformationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='BuildInformationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='BuildInformationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Build_ID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBuild_ID>%s</%sBuild_ID>%s' % ('Common:', self.gds_format_string(quote_xml(self.Build_ID).encode(ExternalEncoding), input_name='Build_ID'), 'Common:', eol_))
        if self.Build_Project is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBuild_Project>%s</%sBuild_Project>%s' % ('Common:', self.gds_format_string(quote_xml(self.Build_Project).encode(ExternalEncoding), input_name='Build_Project'), 'Common:', eol_))
        if self.Build_Utility is not None:
            self.Build_Utility.export(outfile, level, 'Common:', name_='Build_Utility', pretty_print=pretty_print)
        if self.Build_Version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBuild_Version>%s</%sBuild_Version>%s' % ('Common:', self.gds_format_string(quote_xml(self.Build_Version).encode(ExternalEncoding), input_name='Build_Version'), 'Common:', eol_))
        if self.Build_Label is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBuild_Label>%s</%sBuild_Label>%s' % ('Common:', self.gds_format_string(quote_xml(self.Build_Label).encode(ExternalEncoding), input_name='Build_Label'), 'Common:', eol_))
        if self.Compilers is not None:
            self.Compilers.export(outfile, level, 'Common:', name_='Compilers', pretty_print=pretty_print)
        if self.Compilation_Date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCompilation_Date>%s</%sCompilation_Date>%s' % ('Common:', self.gds_format_string(quote_xml(self.Compilation_Date).encode(ExternalEncoding), input_name='Compilation_Date'), 'Common:', eol_))
        if self.Build_Configuration is not None:
            self.Build_Configuration.export(outfile, level, 'Common:', name_='Build_Configuration', pretty_print=pretty_print)
        if self.Build_Script is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBuild_Script>%s</%sBuild_Script>%s' % ('Common:', self.gds_format_string(quote_xml(self.Build_Script).encode(ExternalEncoding), input_name='Build_Script'), 'Common:', eol_))
        if self.Libraries is not None:
            self.Libraries.export(outfile, level, 'Common:', name_='Libraries', pretty_print=pretty_print)
        if self.Build_Output_Log is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBuild_Output_Log>%s</%sBuild_Output_Log>%s' % ('Common:', self.gds_format_string(quote_xml(self.Build_Output_Log).encode(ExternalEncoding), input_name='Build_Output_Log'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Build_ID is not None or
            self.Build_Project is not None or
            self.Build_Utility is not None or
            self.Build_Version is not None or
            self.Build_Label is not None or
            self.Compilers is not None or
            self.Compilation_Date is not None or
            self.Build_Configuration is not None or
            self.Build_Script is not None or
            self.Libraries is not None or
            self.Build_Output_Log is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BuildInformationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Build_ID is not None:
            showIndent(outfile, level)
            outfile.write('Build_ID=%s,\n' % quote_python(self.Build_ID).encode(ExternalEncoding))
        if self.Build_Project is not None:
            showIndent(outfile, level)
            outfile.write('Build_Project=%s,\n' % quote_python(self.Build_Project).encode(ExternalEncoding))
        if self.Build_Utility is not None:
            showIndent(outfile, level)
            outfile.write('Build_Utility=model_.BuildUtilityType(\n')
            self.Build_Utility.exportLiteral(outfile, level, name_='Build_Utility')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Build_Version is not None:
            showIndent(outfile, level)
            outfile.write('Build_Version=%s,\n' % quote_python(self.Build_Version).encode(ExternalEncoding))
        if self.Build_Label is not None:
            showIndent(outfile, level)
            outfile.write('Build_Label=%s,\n' % quote_python(self.Build_Label).encode(ExternalEncoding))
        if self.Compilers is not None:
            showIndent(outfile, level)
            outfile.write('Compilers=model_.CompilersType(\n')
            self.Compilers.exportLiteral(outfile, level, name_='Compilers')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Compilation_Date is not None:
            showIndent(outfile, level)
            outfile.write('Compilation_Date=%s,\n' % quote_python(self.Compilation_Date).encode(ExternalEncoding))
        if self.Build_Configuration is not None:
            showIndent(outfile, level)
            outfile.write('Build_Configuration=model_.BuildConfigurationType(\n')
            self.Build_Configuration.exportLiteral(outfile, level, name_='Build_Configuration')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Build_Script is not None:
            showIndent(outfile, level)
            outfile.write('Build_Script=%s,\n' % quote_python(self.Build_Script).encode(ExternalEncoding))
        if self.Libraries is not None:
            showIndent(outfile, level)
            outfile.write('Libraries=model_.LibrariesType(\n')
            self.Libraries.exportLiteral(outfile, level, name_='Libraries')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Build_Output_Log is not None:
            showIndent(outfile, level)
            outfile.write('Build_Output_Log=%s,\n' % quote_python(self.Build_Output_Log).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Build_ID':
            Build_ID_ = child_.text
            Build_ID_ = self.gds_validate_string(Build_ID_, node, 'Build_ID')
            self.Build_ID = Build_ID_
        elif nodeName_ == 'Build_Project':
            Build_Project_ = child_.text
            Build_Project_ = self.gds_validate_string(Build_Project_, node, 'Build_Project')
            self.Build_Project = Build_Project_
        elif nodeName_ == 'Build_Utility':
            obj_ = BuildUtilityType.factory()
            obj_.build(child_)
            self.set_Build_Utility(obj_)
        elif nodeName_ == 'Build_Version':
            Build_Version_ = child_.text
            Build_Version_ = self.gds_validate_string(Build_Version_, node, 'Build_Version')
            self.Build_Version = Build_Version_
        elif nodeName_ == 'Build_Label':
            Build_Label_ = child_.text
            Build_Label_ = self.gds_validate_string(Build_Label_, node, 'Build_Label')
            self.Build_Label = Build_Label_
        elif nodeName_ == 'Compilers':
            obj_ = CompilersType.factory()
            obj_.build(child_)
            self.set_Compilers(obj_)
        elif nodeName_ == 'Compilation_Date':
            Compilation_Date_ = child_.text
            Compilation_Date_ = self.gds_validate_string(Compilation_Date_, node, 'Compilation_Date')
            self.Compilation_Date = Compilation_Date_
        elif nodeName_ == 'Build_Configuration':
            obj_ = BuildConfigurationType.factory()
            obj_.build(child_)
            self.set_Build_Configuration(obj_)
        elif nodeName_ == 'Build_Script':
            Build_Script_ = child_.text
            Build_Script_ = self.gds_validate_string(Build_Script_, node, 'Build_Script')
            self.Build_Script = Build_Script_
        elif nodeName_ == 'Libraries':
            obj_ = LibrariesType.factory()
            obj_.build(child_)
            self.set_Libraries(obj_)
        elif nodeName_ == 'Build_Output_Log':
            Build_Output_Log_ = child_.text
            Build_Output_Log_ = self.gds_validate_string(Build_Output_Log_, node, 'Build_Output_Log')
            self.Build_Output_Log = Build_Output_Log_
# end class BuildInformationType

class BuildUtilityType(GeneratedsSuper):
    """The BuildUtilityType contains information identifying the utility
    used to build this application."""
    subclass = None
    superclass = None
    def __init__(self, Build_Utility_Name=None, Build_Utility_CPE_Specification=None):
        self.Build_Utility_Name = Build_Utility_Name
        self.Build_Utility_CPE_Specification = Build_Utility_CPE_Specification
    def factory(*args_, **kwargs_):
        if BuildUtilityType.subclass:
            return BuildUtilityType.subclass(*args_, **kwargs_)
        else:
            return BuildUtilityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Build_Utility_Name(self): return self.Build_Utility_Name
    def set_Build_Utility_Name(self, Build_Utility_Name): self.Build_Utility_Name = Build_Utility_Name
    def get_Build_Utility_CPE_Specification(self): return self.Build_Utility_CPE_Specification
    def set_Build_Utility_CPE_Specification(self, Build_Utility_CPE_Specification): self.Build_Utility_CPE_Specification = Build_Utility_CPE_Specification
    def export(self, outfile, level, namespace_='Common:', name_='BuildUtilityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BuildUtilityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='BuildUtilityType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='BuildUtilityType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Build_Utility_Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBuild_Utility_Name>%s</%sBuild_Utility_Name>%s' % ('Common:', self.gds_format_string(quote_xml(self.Build_Utility_Name).encode(ExternalEncoding), input_name='Build_Utility_Name'), 'Common:', eol_))
        if self.Build_Utility_CPE_Specification is not None:
            self.Build_Utility_CPE_Specification.export(outfile, level, 'Common:', name_='Build_Utility_CPE_Specification', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Build_Utility_Name is not None or
            self.Build_Utility_CPE_Specification is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BuildUtilityType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Build_Utility_Name is not None:
            showIndent(outfile, level)
            outfile.write('Build_Utility_Name=%s,\n' % quote_python(self.Build_Utility_Name).encode(ExternalEncoding))
        if self.Build_Utility_CPE_Specification is not None:
            showIndent(outfile, level)
            outfile.write('Build_Utility_CPE_Specification=model_.CPESpecificationType(\n')
            self.Build_Utility_CPE_Specification.exportLiteral(outfile, level, name_='Build_Utility_CPE_Specification')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Build_Utility_Name':
            Build_Utility_Name_ = child_.text
            Build_Utility_Name_ = self.gds_validate_string(Build_Utility_Name_, node, 'Build_Utility_Name')
            self.Build_Utility_Name = Build_Utility_Name_
        elif nodeName_ == 'Build_Utility_CPE_Specification':
            obj_ = CPESpecificationType.factory()
            obj_.build(child_)
            self.set_Build_Utility_CPE_Specification(obj_)
# end class BuildUtilityType

class CompilersType(GeneratedsSuper):
    """The CompilersType describes the compilers utilized during this build
    of this application."""
    subclass = None
    superclass = None
    def __init__(self, Compiler=None):
        if Compiler is None:
            self.Compiler = []
        else:
            self.Compiler = Compiler
    def factory(*args_, **kwargs_):
        if CompilersType.subclass:
            return CompilersType.subclass(*args_, **kwargs_)
        else:
            return CompilersType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Compiler(self): return self.Compiler
    def set_Compiler(self, Compiler): self.Compiler = Compiler
    def add_Compiler(self, value): self.Compiler.append(value)
    def insert_Compiler(self, index, value): self.Compiler[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='CompilersType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CompilersType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='CompilersType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='CompilersType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Compiler_ in self.Compiler:
            Compiler_.export(outfile, level, 'Common:', name_='Compiler', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Compiler
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CompilersType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Compiler=[\n')
        level += 1
        for Compiler_ in self.Compiler:
            showIndent(outfile, level)
            outfile.write('model_.CompilerType(\n')
            Compiler_.exportLiteral(outfile, level, name_='CompilerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Compiler':
            obj_ = CompilerType.factory()
            obj_.build(child_)
            self.Compiler.append(obj_)
# end class CompilersType

class CompilerType(GeneratedsSuper):
    """The CompilerType describes a single compiler utilized during this
    build of this application."""
    subclass = None
    superclass = None
    def __init__(self, Compiler_Informal_Description=None, Compiler_CPE_Specification=None):
        self.Compiler_Informal_Description = Compiler_Informal_Description
        self.Compiler_CPE_Specification = Compiler_CPE_Specification
    def factory(*args_, **kwargs_):
        if CompilerType.subclass:
            return CompilerType.subclass(*args_, **kwargs_)
        else:
            return CompilerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Compiler_Informal_Description(self): return self.Compiler_Informal_Description
    def set_Compiler_Informal_Description(self, Compiler_Informal_Description): self.Compiler_Informal_Description = Compiler_Informal_Description
    def get_Compiler_CPE_Specification(self): return self.Compiler_CPE_Specification
    def set_Compiler_CPE_Specification(self, Compiler_CPE_Specification): self.Compiler_CPE_Specification = Compiler_CPE_Specification
    def export(self, outfile, level, namespace_='Common:', name_='CompilerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CompilerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='CompilerType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='CompilerType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Compiler_Informal_Description is not None:
            self.Compiler_Informal_Description.export(outfile, level, 'Common:', name_='Compiler_Informal_Description', pretty_print=pretty_print)
        if self.Compiler_CPE_Specification is not None:
            self.Compiler_CPE_Specification.export(outfile, level, 'Common:', name_='Compiler_CPE_Specification', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Compiler_Informal_Description is not None or
            self.Compiler_CPE_Specification is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CompilerType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Compiler_Informal_Description is not None:
            showIndent(outfile, level)
            outfile.write('Compiler_Informal_Description=model_.CompilerInformalDescriptionType(\n')
            self.Compiler_Informal_Description.exportLiteral(outfile, level, name_='Compiler_Informal_Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Compiler_CPE_Specification is not None:
            showIndent(outfile, level)
            outfile.write('Compiler_CPE_Specification=model_.CPESpecificationType(\n')
            self.Compiler_CPE_Specification.exportLiteral(outfile, level, name_='Compiler_CPE_Specification')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Compiler_Informal_Description':
            obj_ = CompilerInformalDescriptionType.factory()
            obj_.build(child_)
            self.set_Compiler_Informal_Description(obj_)
        elif nodeName_ == 'Compiler_CPE_Specification':
            obj_ = CPESpecificationType.factory()
            obj_.build(child_)
            self.set_Compiler_CPE_Specification(obj_)
# end class CompilerType

class CompilerInformalDescriptionType(GeneratedsSuper):
    """The CompilerInformalDescriptionType contains the informal
    description of this compiler instance."""
    subclass = None
    superclass = None
    def __init__(self, Compiler_Name=None, Compiler_Version=None):
        self.Compiler_Name = Compiler_Name
        self.Compiler_Version = Compiler_Version
    def factory(*args_, **kwargs_):
        if CompilerInformalDescriptionType.subclass:
            return CompilerInformalDescriptionType.subclass(*args_, **kwargs_)
        else:
            return CompilerInformalDescriptionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Compiler_Name(self): return self.Compiler_Name
    def set_Compiler_Name(self, Compiler_Name): self.Compiler_Name = Compiler_Name
    def get_Compiler_Version(self): return self.Compiler_Version
    def set_Compiler_Version(self, Compiler_Version): self.Compiler_Version = Compiler_Version
    def export(self, outfile, level, namespace_='Common:', name_='CompilerInformalDescriptionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CompilerInformalDescriptionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='CompilerInformalDescriptionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='CompilerInformalDescriptionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Compiler_Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCompiler_Name>%s</%sCompiler_Name>%s' % ('Common:', self.gds_format_string(quote_xml(self.Compiler_Name).encode(ExternalEncoding), input_name='Compiler_Name'), 'Common:', eol_))
        if self.Compiler_Version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCompiler_Version>%s</%sCompiler_Version>%s' % ('Common:', self.gds_format_string(quote_xml(self.Compiler_Version).encode(ExternalEncoding), input_name='Compiler_Version'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Compiler_Name is not None or
            self.Compiler_Version is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CompilerInformalDescriptionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Compiler_Name is not None:
            showIndent(outfile, level)
            outfile.write('Compiler_Name=%s,\n' % quote_python(self.Compiler_Name).encode(ExternalEncoding))
        if self.Compiler_Version is not None:
            showIndent(outfile, level)
            outfile.write('Compiler_Version=%s,\n' % quote_python(self.Compiler_Version).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Compiler_Name':
            Compiler_Name_ = child_.text
            Compiler_Name_ = self.gds_validate_string(Compiler_Name_, node, 'Compiler_Name')
            self.Compiler_Name = Compiler_Name_
        elif nodeName_ == 'Compiler_Version':
            Compiler_Version_ = child_.text
            Compiler_Version_ = self.gds_validate_string(Compiler_Version_, node, 'Compiler_Version')
            self.Compiler_Version = Compiler_Version_
# end class CompilerInformalDescriptionType

class BuildConfigurationType(GeneratedsSuper):
    """The BuildConfigurationType describes how the build utility was
    configured for this build of this application."""
    subclass = None
    superclass = None
    def __init__(self, Configuration_Setting_Description=None, Configuration_Settings=None):
        self.Configuration_Setting_Description = Configuration_Setting_Description
        self.Configuration_Settings = Configuration_Settings
    def factory(*args_, **kwargs_):
        if BuildConfigurationType.subclass:
            return BuildConfigurationType.subclass(*args_, **kwargs_)
        else:
            return BuildConfigurationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Configuration_Setting_Description(self): return self.Configuration_Setting_Description
    def set_Configuration_Setting_Description(self, Configuration_Setting_Description): self.Configuration_Setting_Description = Configuration_Setting_Description
    def get_Configuration_Settings(self): return self.Configuration_Settings
    def set_Configuration_Settings(self, Configuration_Settings): self.Configuration_Settings = Configuration_Settings
    def export(self, outfile, level, namespace_='Common:', name_='BuildConfigurationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BuildConfigurationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='BuildConfigurationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='BuildConfigurationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Configuration_Setting_Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConfiguration_Setting_Description>%s</%sConfiguration_Setting_Description>%s' % ('Common:', self.gds_format_string(quote_xml(self.Configuration_Setting_Description).encode(ExternalEncoding), input_name='Configuration_Setting_Description'), 'Common:', eol_))
        if self.Configuration_Settings is not None:
            self.Configuration_Settings.export(outfile, level, 'Common:', name_='Configuration_Settings', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Configuration_Setting_Description is not None or
            self.Configuration_Settings is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BuildConfigurationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Configuration_Setting_Description is not None:
            showIndent(outfile, level)
            outfile.write('Configuration_Setting_Description=%s,\n' % quote_python(self.Configuration_Setting_Description).encode(ExternalEncoding))
        if self.Configuration_Settings is not None:
            showIndent(outfile, level)
            outfile.write('Configuration_Settings=model_.ConfigurationSettingsType(\n')
            self.Configuration_Settings.exportLiteral(outfile, level, name_='Configuration_Settings')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Configuration_Setting_Description':
            Configuration_Setting_Description_ = child_.text
            Configuration_Setting_Description_ = self.gds_validate_string(Configuration_Setting_Description_, node, 'Configuration_Setting_Description')
            self.Configuration_Setting_Description = Configuration_Setting_Description_
        elif nodeName_ == 'Configuration_Settings':
            obj_ = ConfigurationSettingsType.factory()
            obj_.build(child_)
            self.set_Configuration_Settings(obj_)
# end class BuildConfigurationType

class LibrariesType(GeneratedsSuper):
    """The LibrariesType identifies the libraries incorporated into the
    build of the tool."""
    subclass = None
    superclass = None
    def __init__(self, Library=None):
        self.Library = Library
    def factory(*args_, **kwargs_):
        if LibrariesType.subclass:
            return LibrariesType.subclass(*args_, **kwargs_)
        else:
            return LibrariesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Library(self): return self.Library
    def set_Library(self, Library): self.Library = Library
    def export(self, outfile, level, namespace_='Common:', name_='LibrariesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LibrariesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='LibrariesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='LibrariesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Library is not None:
            self.Library.export(outfile, level, 'Common:', name_='Library', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Library is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='LibrariesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Library is not None:
            showIndent(outfile, level)
            outfile.write('Library=model_.LibraryType(\n')
            self.Library.exportLiteral(outfile, level, name_='Library')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Library':
            obj_ = LibraryType.factory()
            obj_.build(child_)
            self.set_Library(obj_)
# end class LibrariesType

class LibraryType(GeneratedsSuper):
    """The LibraryType identifies a single library incorporated into the
    build of the tool.This field identifies the name of the
    library.This field identifies the version of the library."""
    subclass = None
    superclass = None
    def __init__(self, version=None, name=None):
        self.version = _cast(None, version)
        self.name = _cast(None, name)
        pass
    def factory(*args_, **kwargs_):
        if LibraryType.subclass:
            return LibraryType.subclass(*args_, **kwargs_)
        else:
            return LibraryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='Common:', name_='LibraryType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LibraryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='LibraryType'):
        if self.version is not None and 'version' not in already_processed:
            already_processed.append('version')
            outfile.write(' version=%s' % (self.gds_format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='LibraryType', fromsubclass_=False, pretty_print=True):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='LibraryType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.version is not None and 'version' not in already_processed:
            already_processed.append('version')
            showIndent(outfile, level)
            outfile.write('version = "%s",\n' % (self.version,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.append('version')
            self.version = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class LibraryType

class ExecutionEnvironmentType(GeneratedsSuper):
    """The ExecutionEnvironmentType contains information describing the
    execution environment of the tool."""
    subclass = None
    superclass = None
    def __init__(self, System=None, User_Account_Info=None, Command_Line=None, Start_Time=None):
        self.System = System
        self.User_Account_Info = User_Account_Info
        self.Command_Line = Command_Line
        self.Start_Time = Start_Time
    def factory(*args_, **kwargs_):
        if ExecutionEnvironmentType.subclass:
            return ExecutionEnvironmentType.subclass(*args_, **kwargs_)
        else:
            return ExecutionEnvironmentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_System(self): return self.System
    def set_System(self, System): self.System = System
    def get_User_Account_Info(self): return self.User_Account_Info
    def set_User_Account_Info(self, User_Account_Info): self.User_Account_Info = User_Account_Info
    def get_Command_Line(self): return self.Command_Line
    def set_Command_Line(self, Command_Line): self.Command_Line = Command_Line
    def get_Start_Time(self): return self.Start_Time
    def set_Start_Time(self, Start_Time): self.Start_Time = Start_Time
    def export(self, outfile, level, namespace_='Common:', name_='ExecutionEnvironmentType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExecutionEnvironmentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ExecutionEnvironmentType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ExecutionEnvironmentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.System is not None:
            self.System.export(outfile, level, 'Common:', name_='System', pretty_print=pretty_print)
        if self.User_Account_Info is not None:
            self.User_Account_Info.export(outfile, level, 'Common:', name_='User_Account_Info', pretty_print=pretty_print)
        if self.Command_Line is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCommand_Line>%s</%sCommand_Line>%s' % ('Common:', self.gds_format_string(quote_xml(self.Command_Line).encode(ExternalEncoding), input_name='Command_Line'), 'Common:', eol_))
        if self.Start_Time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStart_Time>%s</%sStart_Time>%s' % ('Common:', self.gds_format_string(quote_xml(self.Start_Time).encode(ExternalEncoding), input_name='Start_Time'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.System is not None or
            self.User_Account_Info is not None or
            self.Command_Line is not None or
            self.Start_Time is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ExecutionEnvironmentType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.System is not None:
            showIndent(outfile, level)
            outfile.write('System=model_.system_object_1_3.SystemObjectType(\n')
            self.System.exportLiteral(outfile, level, name_='System')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.User_Account_Info is not None:
            showIndent(outfile, level)
            outfile.write('User_Account_Info=model_.user_account_object_1_2.UserAccountObjectType(\n')
            self.User_Account_Info.exportLiteral(outfile, level, name_='User_Account_Info')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Command_Line is not None:
            showIndent(outfile, level)
            outfile.write('Command_Line=%s,\n' % quote_python(self.Command_Line).encode(ExternalEncoding))
        if self.Start_Time is not None:
            showIndent(outfile, level)
            outfile.write('Start_Time=%s,\n' % quote_python(self.Start_Time).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'System':
            obj_ = system_object_1_3.SystemObjectType.factory()
            obj_.build(child_)
            self.set_System(obj_)
        elif nodeName_ == 'User_Account_Info':
            obj_ = user_account_object_1_2.UserAccountObjectType.factory()
            obj_.build(child_)
            self.set_User_Account_Info(obj_)
        elif nodeName_ == 'Command_Line':
            Command_Line_ = child_.text
            Command_Line_ = self.gds_validate_string(Command_Line_, node, 'Command_Line')
            self.Command_Line = Command_Line_
        elif nodeName_ == 'Start_Time':
            Start_Time_ = child_.text
            Start_Time_ = self.gds_validate_string(Start_Time_, node, 'Start_Time')
            self.Start_Time = Start_Time_
# end class ExecutionEnvironmentType

class ErrorsType(GeneratedsSuper):
    """The ErrorsType captures any errors generated during the run of the
    tool."""
    subclass = None
    superclass = None
    def __init__(self, Error=None):
        if Error is None:
            self.Error = []
        else:
            self.Error = Error
    def factory(*args_, **kwargs_):
        if ErrorsType.subclass:
            return ErrorsType.subclass(*args_, **kwargs_)
        else:
            return ErrorsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Error(self): return self.Error
    def set_Error(self, Error): self.Error = Error
    def add_Error(self, value): self.Error.append(value)
    def insert_Error(self, index, value): self.Error[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='ErrorsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ErrorsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ErrorsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Error_ in self.Error:
            Error_.export(outfile, level, 'Common:', name_='Error', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Error
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ErrorsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Error=[\n')
        level += 1
        for Error_ in self.Error:
            showIndent(outfile, level)
            outfile.write('model_.ErrorType(\n')
            Error_.exportLiteral(outfile, level, name_='ErrorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Error':
            obj_ = ErrorType.factory()
            obj_.build(child_)
            self.Error.append(obj_)
# end class ErrorsType

class ErrorType(GeneratedsSuper):
    """The ErrorType captures a single error generated during the run of
    the tool."""
    subclass = None
    superclass = None
    def __init__(self, Error_Type=None, Error_Count=None, Error_Instances=None):
        self.Error_Type = Error_Type
        self.Error_Count = Error_Count
        self.Error_Instances = Error_Instances
    def factory(*args_, **kwargs_):
        if ErrorType.subclass:
            return ErrorType.subclass(*args_, **kwargs_)
        else:
            return ErrorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Error_Type(self): return self.Error_Type
    def set_Error_Type(self, Error_Type): self.Error_Type = Error_Type
    def get_Error_Count(self): return self.Error_Count
    def set_Error_Count(self, Error_Count): self.Error_Count = Error_Count
    def get_Error_Instances(self): return self.Error_Instances
    def set_Error_Instances(self, Error_Instances): self.Error_Instances = Error_Instances
    def export(self, outfile, level, namespace_='Common:', name_='ErrorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ErrorType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ErrorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Error_Type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sError_Type>%s</%sError_Type>%s' % ('Common:', self.gds_format_string(quote_xml(self.Error_Type).encode(ExternalEncoding), input_name='Error_Type'), 'Common:', eol_))
        if self.Error_Count is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sError_Count>%s</%sError_Count>%s' % ('Common:', self.gds_format_integer(self.Error_Count, input_name='Error_Count'), 'Common:', eol_))
        if self.Error_Instances is not None:
            self.Error_Instances.export(outfile, level, 'Common:', name_='Error_Instances', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Error_Type is not None or
            self.Error_Count is not None or
            self.Error_Instances is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ErrorType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Error_Type is not None:
            showIndent(outfile, level)
            outfile.write('Error_Type=%s,\n' % quote_python(self.Error_Type).encode(ExternalEncoding))
        if self.Error_Count is not None:
            showIndent(outfile, level)
            outfile.write('Error_Count=%d,\n' % self.Error_Count)
        if self.Error_Instances is not None:
            showIndent(outfile, level)
            outfile.write('Error_Instances=model_.ErrorInstancesType(\n')
            self.Error_Instances.exportLiteral(outfile, level, name_='Error_Instances')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Error_Type':
            Error_Type_ = child_.text
            Error_Type_ = self.gds_validate_string(Error_Type_, node, 'Error_Type')
            self.Error_Type = Error_Type_
        elif nodeName_ == 'Error_Count':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Error_Count')
            self.Error_Count = ival_
        elif nodeName_ == 'Error_Instances':
            obj_ = ErrorInstancesType.factory()
            obj_.build(child_)
            self.set_Error_Instances(obj_)
# end class ErrorType

class ErrorInstancesType(GeneratedsSuper):
    """The ErrorInstancesType captures the actual error output for each
    instance of this type of error."""
    subclass = None
    superclass = None
    def __init__(self, Error_Instance=None):
        if Error_Instance is None:
            self.Error_Instance = []
        else:
            self.Error_Instance = Error_Instance
    def factory(*args_, **kwargs_):
        if ErrorInstancesType.subclass:
            return ErrorInstancesType.subclass(*args_, **kwargs_)
        else:
            return ErrorInstancesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Error_Instance(self): return self.Error_Instance
    def set_Error_Instance(self, Error_Instance): self.Error_Instance = Error_Instance
    def add_Error_Instance(self, value): self.Error_Instance.append(value)
    def insert_Error_Instance(self, index, value): self.Error_Instance[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='ErrorInstancesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorInstancesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ErrorInstancesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ErrorInstancesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Error_Instance_ in self.Error_Instance:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sError_Instance>%s</%sError_Instance>%s' % ('Common:', self.gds_format_string(quote_xml(Error_Instance_).encode(ExternalEncoding), input_name='Error_Instance'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Error_Instance
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ErrorInstancesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Error_Instance=[\n')
        level += 1
        for Error_Instance_ in self.Error_Instance:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Error_Instance_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Error_Instance':
            Error_Instance_ = child_.text
            Error_Instance_ = self.gds_validate_string(Error_Instance_, node, 'Error_Instance')
            self.Error_Instance.append(Error_Instance_)
# end class ErrorInstancesType

class DefinedObjectType(GeneratedsSuper):
    """The DefinedObjectType is an Abstract type placeholder within the
    CybOX schema enabling the inclusion of contextually varying
    object descriptions. This Abstract type is leveraged as the
    extension base for all predefined CybOX object schemas. Through
    this extension mechanism any object instance data based on an
    object schema extended from DefinedObjectType (e.g. File_Object,
    Address_Object, etc.) can be directly integrated into any
    instance document where a field is defined as DefinedObjectType.
    For flexibility and extensibility purposes any user of CybOX can
    specify their own externally defined object schemas (outside of
    or derived from the set of predefined objects) extended from
    DefinedObjectType and utilize them as part of their CybOX
    content.The ObjectReference attribute specifies a unique ID
    reference to an Object defined elsewhere. This construct enables
    flexibility in defining Object association within Actions as
    well as specification of Objects within other Objects.The "any"
    attribute enables the capture of custom attributes describing
    this Defined Object specification."""
    subclass = None
    superclass = None
    def __init__(self, object_reference=None):
        self.object_reference = _cast(None, object_reference)
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if DefinedObjectType.subclass:
            return DefinedObjectType.subclass(*args_, **kwargs_)
        else:
            return DefinedObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_object_reference(self): return self.object_reference
    def set_object_reference(self, object_reference): self.object_reference = object_reference
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def export(self, outfile, level, namespace_='Common:', name_='DefinedObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DefinedObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DefinedObjectType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.append(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.append(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.append(name)
                        outfile.write(' %s=%s' % (name, quote_attrib(value), ))
        if self.object_reference is not None and 'object_reference' not in already_processed:
            already_processed.append('object_reference')
            outfile.write(' object_reference=%s' % (quote_attrib(self.object_reference), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DefinedObjectType', fromsubclass_=False, pretty_print=True):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DefinedObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.object_reference is not None and 'object_reference' not in already_processed:
            already_processed.append('object_reference')
            showIndent(outfile, level)
            outfile.write('object_reference = %s,\n' % (self.object_reference,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s = "%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('object_reference', node)
        if value is not None and 'object_reference' not in already_processed:
            already_processed.append('object_reference')
            self.object_reference = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DefinedObjectType

class BaseObjectAttributeType(GeneratedsSuper):
    """The BaseObjectAttibuteType is a complex type representing a common
    typing foundation for the specification of a single Object
    Attribute."""
    subclass = None
    superclass = None
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        self.end_range = _cast(None, end_range)
        self.pattern_type = _cast(None, pattern_type)
        self.has_changed = _cast(bool, has_changed)
        self.value_set = _cast(None, value_set)
        self.datatype = _cast(None, datatype)
        self.refanging_transform = _cast(None, refanging_transform)
        self.refanging_transform_type = _cast(None, refanging_transform_type)
        self.appears_random = _cast(bool, appears_random)
        self.trend = _cast(bool, trend)
        self.defanging_algorithm_ref = _cast(None, defanging_algorithm_ref)
        self.is_obfuscated = _cast(bool, is_obfuscated)
        self.regex_syntax = _cast(None, regex_syntax)
        self.obfuscation_algorithm_ref = _cast(None, obfuscation_algorithm_ref)
        self.start_range = _cast(None, start_range)
        self.idref = _cast(None, idref)
        self.is_defanged = _cast(bool, is_defanged)
        self.id = _cast(None, id)
        self.condition = _cast(None, condition)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if BaseObjectAttributeType.subclass:
            return BaseObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return BaseObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_end_range(self): return self.end_range
    def set_end_range(self, end_range): self.end_range = end_range
    def get_pattern_type(self): return self.pattern_type
    def set_pattern_type(self, pattern_type): self.pattern_type = pattern_type
    def get_has_changed(self): return self.has_changed
    def set_has_changed(self, has_changed): self.has_changed = has_changed
    def get_value_set(self): return self.value_set
    def set_value_set(self, value_set): self.value_set = value_set
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_refanging_transform(self): return self.refanging_transform
    def set_refanging_transform(self, refanging_transform): self.refanging_transform = refanging_transform
    def get_refanging_transform_type(self): return self.refanging_transform_type
    def set_refanging_transform_type(self, refanging_transform_type): self.refanging_transform_type = refanging_transform_type
    def get_appears_random(self): return self.appears_random
    def set_appears_random(self, appears_random): self.appears_random = appears_random
    def get_trend(self): return self.trend
    def set_trend(self, trend): self.trend = trend
    def get_defanging_algorithm_ref(self): return self.defanging_algorithm_ref
    def set_defanging_algorithm_ref(self, defanging_algorithm_ref): self.defanging_algorithm_ref = defanging_algorithm_ref
    def get_is_obfuscated(self): return self.is_obfuscated
    def set_is_obfuscated(self, is_obfuscated): self.is_obfuscated = is_obfuscated
    def get_regex_syntax(self): return self.regex_syntax
    def set_regex_syntax(self, regex_syntax): self.regex_syntax = regex_syntax
    def get_obfuscation_algorithm_ref(self): return self.obfuscation_algorithm_ref
    def set_obfuscation_algorithm_ref(self, obfuscation_algorithm_ref): self.obfuscation_algorithm_ref = obfuscation_algorithm_ref
    def get_start_range(self): return self.start_range
    def set_start_range(self, start_range): self.start_range = start_range
    def get_idref(self): return self.idref
    def set_idref(self, idref): self.idref = idref
    def get_is_defanged(self): return self.is_defanged
    def set_is_defanged(self, is_defanged): self.is_defanged = is_defanged
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_condition(self): return self.condition
    def set_condition(self, condition): self.condition = condition
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='BaseObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='BaseObjectAttributeType'):
        if self.end_range is not None and 'end_range' not in already_processed:
            already_processed.append('end_range')
            outfile.write(' end_range=%s' % (quote_attrib(self.end_range), ))
        if self.pattern_type is not None and 'pattern_type' not in already_processed:
            already_processed.append('pattern_type')
            outfile.write(' pattern_type=%s' % (quote_attrib(self.pattern_type), ))
        if self.has_changed is not None and 'has_changed' not in already_processed:
            already_processed.append('has_changed')
            outfile.write(' has_changed="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.has_changed)), input_name='has_changed'))
        if self.value_set is not None and 'value_set' not in already_processed:
            already_processed.append('value_set')
            outfile.write(' value_set=%s' % (self.gds_format_string(quote_attrib(self.value_set).encode(ExternalEncoding), input_name='value_set'), ))
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
        if self.refanging_transform is not None and 'refanging_transform' not in already_processed:
            already_processed.append('refanging_transform')
            outfile.write(' refanging_transform=%s' % (self.gds_format_string(quote_attrib(self.refanging_transform).encode(ExternalEncoding), input_name='refanging_transform'), ))
        if self.refanging_transform_type is not None and 'refanging_transform_type' not in already_processed:
            already_processed.append('refanging_transform_type')
            outfile.write(' refanging_transform_type=%s' % (self.gds_format_string(quote_attrib(self.refanging_transform_type).encode(ExternalEncoding), input_name='refanging_transform_type'), ))
        if self.appears_random is not None and 'appears_random' not in already_processed:
            already_processed.append('appears_random')
            outfile.write(' appears_random="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.appears_random)), input_name='appears_random'))
        if self.trend is not None and 'trend' not in already_processed:
            already_processed.append('trend')
            outfile.write(' trend="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.trend)), input_name='trend'))
        if self.defanging_algorithm_ref is not None and 'defanging_algorithm_ref' not in already_processed:
            already_processed.append('defanging_algorithm_ref')
            outfile.write(' defanging_algorithm_ref=%s' % (self.gds_format_string(quote_attrib(self.defanging_algorithm_ref).encode(ExternalEncoding), input_name='defanging_algorithm_ref'), ))
        if self.is_obfuscated is not None and 'is_obfuscated' not in already_processed:
            already_processed.append('is_obfuscated')
            outfile.write(' is_obfuscated="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.is_obfuscated)), input_name='is_obfuscated'))
        if self.regex_syntax is not None and 'regex_syntax' not in already_processed:
            already_processed.append('regex_syntax')
            outfile.write(' regex_syntax=%s' % (quote_attrib(self.regex_syntax), ))
        if self.obfuscation_algorithm_ref is not None and 'obfuscation_algorithm_ref' not in already_processed:
            already_processed.append('obfuscation_algorithm_ref')
            outfile.write(' obfuscation_algorithm_ref=%s' % (self.gds_format_string(quote_attrib(self.obfuscation_algorithm_ref).encode(ExternalEncoding), input_name='obfuscation_algorithm_ref'), ))
        if self.start_range is not None and 'start_range' not in already_processed:
            already_processed.append('start_range')
            outfile.write(' start_range=%s' % (quote_attrib(self.start_range), ))
        if self.idref is not None and 'idref' not in already_processed:
            already_processed.append('idref')
            outfile.write(' idref=%s' % (quote_attrib(self.idref), ))
        if self.is_defanged is not None and 'is_defanged' not in already_processed:
            already_processed.append('is_defanged')
            outfile.write(' is_defanged="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.is_defanged)), input_name='is_defanged'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.condition is not None and 'condition' not in already_processed:
            already_processed.append('condition')
            outfile.write(' condition=%s' % (quote_attrib(self.condition), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='BaseObjectAttributeType', fromsubclass_=False, pretty_print=True):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BaseObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.end_range is not None and 'end_range' not in already_processed:
            already_processed.append('end_range')
            showIndent(outfile, level)
            outfile.write('end_range = %s,\n' % (self.end_range,))
        if self.pattern_type is not None and 'pattern_type' not in already_processed:
            already_processed.append('pattern_type')
            showIndent(outfile, level)
            outfile.write('pattern_type = %s,\n' % (self.pattern_type,))
        if self.has_changed is not None and 'has_changed' not in already_processed:
            already_processed.append('has_changed')
            showIndent(outfile, level)
            outfile.write('has_changed = %s,\n' % (self.has_changed,))
        if self.value_set is not None and 'value_set' not in already_processed:
            already_processed.append('value_set')
            showIndent(outfile, level)
            outfile.write('value_set = "%s",\n' % (self.value_set,))
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        if self.refanging_transform is not None and 'refanging_transform' not in already_processed:
            already_processed.append('refanging_transform')
            showIndent(outfile, level)
            outfile.write('refanging_transform = "%s",\n' % (self.refanging_transform,))
        if self.refanging_transform_type is not None and 'refanging_transform_type' not in already_processed:
            already_processed.append('refanging_transform_type')
            showIndent(outfile, level)
            outfile.write('refanging_transform_type = "%s",\n' % (self.refanging_transform_type,))
        if self.appears_random is not None and 'appears_random' not in already_processed:
            already_processed.append('appears_random')
            showIndent(outfile, level)
            outfile.write('appears_random = %s,\n' % (self.appears_random,))
        if self.trend is not None and 'trend' not in already_processed:
            already_processed.append('trend')
            showIndent(outfile, level)
            outfile.write('trend = %s,\n' % (self.trend,))
        if self.defanging_algorithm_ref is not None and 'defanging_algorithm_ref' not in already_processed:
            already_processed.append('defanging_algorithm_ref')
            showIndent(outfile, level)
            outfile.write('defanging_algorithm_ref = "%s",\n' % (self.defanging_algorithm_ref,))
        if self.is_obfuscated is not None and 'is_obfuscated' not in already_processed:
            already_processed.append('is_obfuscated')
            showIndent(outfile, level)
            outfile.write('is_obfuscated = %s,\n' % (self.is_obfuscated,))
        if self.regex_syntax is not None and 'regex_syntax' not in already_processed:
            already_processed.append('regex_syntax')
            showIndent(outfile, level)
            outfile.write('regex_syntax = %s,\n' % (self.regex_syntax,))
        if self.obfuscation_algorithm_ref is not None and 'obfuscation_algorithm_ref' not in already_processed:
            already_processed.append('obfuscation_algorithm_ref')
            showIndent(outfile, level)
            outfile.write('obfuscation_algorithm_ref = "%s",\n' % (self.obfuscation_algorithm_ref,))
        if self.start_range is not None and 'start_range' not in already_processed:
            already_processed.append('start_range')
            showIndent(outfile, level)
            outfile.write('start_range = %s,\n' % (self.start_range,))
        if self.idref is not None and 'idref' not in already_processed:
            already_processed.append('idref')
            showIndent(outfile, level)
            outfile.write('idref = %s,\n' % (self.idref,))
        if self.is_defanged is not None and 'is_defanged' not in already_processed:
            already_processed.append('is_defanged')
            showIndent(outfile, level)
            outfile.write('is_defanged = %s,\n' % (self.is_defanged,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.condition is not None and 'condition' not in already_processed:
            already_processed.append('condition')
            showIndent(outfile, level)
            outfile.write('condition = %s,\n' % (self.condition,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('end_range', node)
        if value is not None and 'end_range' not in already_processed:
            already_processed.append('end_range')
            self.end_range = value
        value = find_attr_value_('pattern_type', node)
        if value is not None and 'pattern_type' not in already_processed:
            already_processed.append('pattern_type')
            self.pattern_type = value
        value = find_attr_value_('has_changed', node)
        if value is not None and 'has_changed' not in already_processed:
            already_processed.append('has_changed')
            if value in ('true', '1'):
                self.has_changed = True
            elif value in ('false', '0'):
                self.has_changed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('value_set', node)
        if value is not None and 'value_set' not in already_processed:
            already_processed.append('value_set')
            self.value_set = value
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        value = find_attr_value_('refanging_transform', node)
        if value is not None and 'refanging_transform' not in already_processed:
            already_processed.append('refanging_transform')
            self.refanging_transform = value
        value = find_attr_value_('refanging_transform_type', node)
        if value is not None and 'refanging_transform_type' not in already_processed:
            already_processed.append('refanging_transform_type')
            self.refanging_transform_type = value
        value = find_attr_value_('appears_random', node)
        if value is not None and 'appears_random' not in already_processed:
            already_processed.append('appears_random')
            if value in ('true', '1'):
                self.appears_random = True
            elif value in ('false', '0'):
                self.appears_random = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('trend', node)
        if value is not None and 'trend' not in already_processed:
            already_processed.append('trend')
            if value in ('true', '1'):
                self.trend = True
            elif value in ('false', '0'):
                self.trend = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('defanging_algorithm_ref', node)
        if value is not None and 'defanging_algorithm_ref' not in already_processed:
            already_processed.append('defanging_algorithm_ref')
            self.defanging_algorithm_ref = value
        value = find_attr_value_('is_obfuscated', node)
        if value is not None and 'is_obfuscated' not in already_processed:
            already_processed.append('is_obfuscated')
            if value in ('true', '1'):
                self.is_obfuscated = True
            elif value in ('false', '0'):
                self.is_obfuscated = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('regex_syntax', node)
        if value is not None and 'regex_syntax' not in already_processed:
            already_processed.append('regex_syntax')
            self.regex_syntax = value
        value = find_attr_value_('obfuscation_algorithm_ref', node)
        if value is not None and 'obfuscation_algorithm_ref' not in already_processed:
            already_processed.append('obfuscation_algorithm_ref')
            self.obfuscation_algorithm_ref = value
        value = find_attr_value_('start_range', node)
        if value is not None and 'start_range' not in already_processed:
            already_processed.append('start_range')
            self.start_range = value
        value = find_attr_value_('idref', node)
        if value is not None and 'idref' not in already_processed:
            already_processed.append('idref')
            self.idref = value
        value = find_attr_value_('is_defanged', node)
        if value is not None and 'is_defanged' not in already_processed:
            already_processed.append('is_defanged')
            if value in ('true', '1'):
                self.is_defanged = True
            elif value in ('false', '0'):
                self.is_defanged = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        value = find_attr_value_('condition', node)
        if value is not None and 'condition' not in already_processed:
            already_processed.append('condition')
            self.condition = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class BaseObjectAttributeType

class IntegerObjectAttributeType(BaseObjectAttributeType):
    """The IntegerObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type Int. This
    type will be assigned to any attribute of a CybOX object that
    should contain content of type Integer and enables the use of
    relevant metadata for the atrribute.This attribute is optional
    and specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='Integer', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(IntegerObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if IntegerObjectAttributeType.subclass:
            return IntegerObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return IntegerObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='IntegerObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IntegerObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='IntegerObjectAttributeType'):
        super(IntegerObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IntegerObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='IntegerObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(IntegerObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(IntegerObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IntegerObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(IntegerObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IntegerObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(IntegerObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class IntegerObjectAttributeType

class StringObjectAttributeType(BaseObjectAttributeType):
    """The StringObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type String. This
    type will be assigned to any attribute of a CybOX object that
    should contain content of type String and enables the use of
    relevant metadata for the atrribute.This attribute is optional
    and specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(StringObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if StringObjectAttributeType.subclass:
            return StringObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return StringObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='StringObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StringObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(quote_xml(self.valueOf_)).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='StringObjectAttributeType'):
        super(StringObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StringObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='StringObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(StringObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(StringObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StringObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(StringObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StringObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(StringObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class StringObjectAttributeType

class NameObjectAttributeType(BaseObjectAttributeType):
    """The NameObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type Name. This
    type will be assigned to any attribute of a CybOX object that
    should contain content of type Name and enables the use of
    relevant metadata for the atrribute.This attribute is optional
    and specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='Name', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(NameObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if NameObjectAttributeType.subclass:
            return NameObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return NameObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='NameObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NameObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='NameObjectAttributeType'):
        super(NameObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NameObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='NameObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(NameObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(NameObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NameObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(NameObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NameObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(NameObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class NameObjectAttributeType

class DateObjectAttributeType(BaseObjectAttributeType):
    """The DateObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type Date. This
    type will be assigned to any attribute of a CybOX object that
    should contain content of type Date and enables the use of
    relevant metadata for the atrribute.This attribute is optional
    and specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='Date', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(DateObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if DateObjectAttributeType.subclass:
            return DateObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return DateObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='DateObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DateObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DateObjectAttributeType'):
        super(DateObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DateObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DateObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(DateObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(DateObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DateObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(DateObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DateObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(DateObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DateObjectAttributeType

class DateTimeObjectAttributeType(BaseObjectAttributeType):
    """The DateTimeObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type DateTime.
    This type will be assigned to any attribute of a CybOX object
    that should contain content of type DateTime and enables the use
    of relevant metadata for the atrribute.This attribute is
    optional and specifies the expected type for the value of the
    specified element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='DateTime', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(DateTimeObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if DateTimeObjectAttributeType.subclass:
            return DateTimeObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return DateTimeObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='DateTimeObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DateTimeObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DateTimeObjectAttributeType'):
        super(DateTimeObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DateTimeObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DateTimeObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(DateTimeObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(DateTimeObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DateTimeObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(DateTimeObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DateTimeObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(DateTimeObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DateTimeObjectAttributeType

class FloatObjectAttributeType(BaseObjectAttributeType):
    """The FloatObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type Float. This
    type will be assigned to any attribute of a CybOX object that
    should contain content of type Float and enables the use of
    relevant metadata for the atrribute.This attribute is optional
    and specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='Float', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(FloatObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if FloatObjectAttributeType.subclass:
            return FloatObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return FloatObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='FloatObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FloatObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='FloatObjectAttributeType'):
        super(FloatObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FloatObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='FloatObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(FloatObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(FloatObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FloatObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(FloatObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FloatObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(FloatObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class FloatObjectAttributeType

class DoubleObjectAttributeType(BaseObjectAttributeType):
    """The DoubleObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type Double. This
    type will be assigned to any attribute of a CybOX object that
    should contain content of type Double and enables the use of
    relevant metadata for the atrribute.This attribute is optional
    and specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='Double', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(DoubleObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if DoubleObjectAttributeType.subclass:
            return DoubleObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return DoubleObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='DoubleObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DoubleObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DoubleObjectAttributeType'):
        super(DoubleObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DoubleObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DoubleObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(DoubleObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(DoubleObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DoubleObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(DoubleObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DoubleObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(DoubleObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DoubleObjectAttributeType

class UnsignedLongObjectAttributeType(BaseObjectAttributeType):
    """The UnsignedLongObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type
    UnsignedLong. This type will be assigned to any attribute of a
    CybOX object that should contain content of type UnsignedLong
    and enables the use of relevant metadata for the atrribute.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='UnsignedLong', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(UnsignedLongObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if UnsignedLongObjectAttributeType.subclass:
            return UnsignedLongObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return UnsignedLongObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='UnsignedLongObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UnsignedLongObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='UnsignedLongObjectAttributeType'):
        super(UnsignedLongObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='UnsignedLongObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='UnsignedLongObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(UnsignedLongObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(UnsignedLongObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='UnsignedLongObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(UnsignedLongObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(UnsignedLongObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(UnsignedLongObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class UnsignedLongObjectAttributeType

class UnsignedIntegerObjectAttributeType(BaseObjectAttributeType):
    """The UnsignedIntegerObjectAttributeType is a complex type (extended
    from BaseObjectAttributeType) representing the specification of
    a single Object attribute whose core value is of type
    UnsignedInt. This type will be assigned to any attribute of a
    CybOX object that should contain content of type UnsignedInteger
    and enables the use of relevant metadata for the atrribute.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='UnsignedInteger', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(UnsignedIntegerObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if UnsignedIntegerObjectAttributeType.subclass:
            return UnsignedIntegerObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return UnsignedIntegerObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='UnsignedIntegerObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UnsignedIntegerObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='UnsignedIntegerObjectAttributeType'):
        super(UnsignedIntegerObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='UnsignedIntegerObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='UnsignedIntegerObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(UnsignedIntegerObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(UnsignedIntegerObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='UnsignedIntegerObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(UnsignedIntegerObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(UnsignedIntegerObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(UnsignedIntegerObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class UnsignedIntegerObjectAttributeType

class PositiveIntegerObjectAttributeType(BaseObjectAttributeType):
    """The PositiveIntegerObjectAttributeType is a complex type (extended
    from BaseObjectAttributeType) representing the specification of
    a single Object attribute whose core value is of type
    PositveInteger. This type will be assigned to any attribute of a
    CybOX object that should contain content of type PositiveInteger
    and enables the use of relevant metadata for the atrribute.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='PositiveInteger', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(PositiveIntegerObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if PositiveIntegerObjectAttributeType.subclass:
            return PositiveIntegerObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return PositiveIntegerObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='PositiveIntegerObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PositiveIntegerObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='PositiveIntegerObjectAttributeType'):
        super(PositiveIntegerObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PositiveIntegerObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='PositiveIntegerObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(PositiveIntegerObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(PositiveIntegerObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PositiveIntegerObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(PositiveIntegerObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(PositiveIntegerObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(PositiveIntegerObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class PositiveIntegerObjectAttributeType

class HexBinaryObjectAttributeType(BaseObjectAttributeType):
    """The HexBinaryObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type HexBinary.
    This type will be assigned to any attribute of a CybOX object
    that should contain content of type HexBinary and enables the
    use of relevant metadata for the atrribute.This attribute is
    optional and specifies the expected type for the value of the
    specified element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='hexBinary', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(HexBinaryObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if HexBinaryObjectAttributeType.subclass:
            return HexBinaryObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return HexBinaryObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='HexBinaryObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HexBinaryObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='HexBinaryObjectAttributeType'):
        super(HexBinaryObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HexBinaryObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='HexBinaryObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(HexBinaryObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(HexBinaryObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HexBinaryObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(HexBinaryObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HexBinaryObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(HexBinaryObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class HexBinaryObjectAttributeType

class LongObjectAttributeType(BaseObjectAttributeType):
    """The LongObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type Long. This
    type will be assigned to any attribute of a CybOX object that
    should contain content of type Long and enables the use of
    relevant metadata for the atrribute.This attribute is optional
    and specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='Long', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(LongObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if LongObjectAttributeType.subclass:
            return LongObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return LongObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='LongObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LongObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='LongObjectAttributeType'):
        super(LongObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LongObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='LongObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(LongObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(LongObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='LongObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(LongObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LongObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(LongObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class LongObjectAttributeType

class NonNegativeIntegerObjectAttributeType(BaseObjectAttributeType):
    """The NonNegativeIntegerObjectAttributeType is a complex type
    (extended from BaseObjectAttributeType) representing the
    specification of a single Object attribute whose core value is
    of type nonNegativeInteger. This type will be assigned to any
    attribute of a CybOX object that should contain content of type
    NonNegativeInteger and enables the use of relevant metadata for
    the atrribute.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='NonNegativeInteger', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(NonNegativeIntegerObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if NonNegativeIntegerObjectAttributeType.subclass:
            return NonNegativeIntegerObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return NonNegativeIntegerObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='NonNegativeIntegerObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NonNegativeIntegerObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='NonNegativeIntegerObjectAttributeType'):
        super(NonNegativeIntegerObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NonNegativeIntegerObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='NonNegativeIntegerObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(NonNegativeIntegerObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(NonNegativeIntegerObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NonNegativeIntegerObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(NonNegativeIntegerObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NonNegativeIntegerObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(NonNegativeIntegerObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class NonNegativeIntegerObjectAttributeType

class AnyURIObjectAttributeType(BaseObjectAttributeType):
    """The AnyURIObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type anyURI. This
    type will be assigned to any attribute of a CybOX object that
    should contain content of type AnyURI and enables the use of
    relevant metadata for the atrribute.This attribute is optional
    and specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='AnyURI', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(AnyURIObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if AnyURIObjectAttributeType.subclass:
            return AnyURIObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return AnyURIObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='AnyURIObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AnyURIObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='AnyURIObjectAttributeType'):
        super(AnyURIObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AnyURIObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='AnyURIObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(AnyURIObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(AnyURIObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AnyURIObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(AnyURIObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AnyURIObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(AnyURIObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class AnyURIObjectAttributeType

class DurationObjectAttributeType(BaseObjectAttributeType):
    """The DurationObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type duration.
    This type will be assigned to any attribute of a CybOX object
    that should contain content of type Duration and enables the use
    of relevant metadata for the atrribute.This attribute is
    optional and specifies the expected type for the value of the
    specified element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='Duration', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(DurationObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if DurationObjectAttributeType.subclass:
            return DurationObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return DurationObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='DurationObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DurationObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DurationObjectAttributeType'):
        super(DurationObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DurationObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DurationObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(DurationObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(DurationObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DurationObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(DurationObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DurationObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(DurationObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DurationObjectAttributeType

class TimeObjectAttributeType(BaseObjectAttributeType):
    """The TimeObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type time. This
    type will be assigned to any attribute of a CybOX object that
    should contain content of type Time and enables the use of
    relevant metadata for the atrribute.This attribute is optional
    and specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='Time', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TimeObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TimeObjectAttributeType.subclass:
            return TimeObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return TimeObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='TimeObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimeObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='TimeObjectAttributeType'):
        super(TimeObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TimeObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='TimeObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(TimeObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TimeObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TimeObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TimeObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TimeObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(TimeObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TimeObjectAttributeType

class Base64BinaryObjectAttributeType(BaseObjectAttributeType):
    """The Base64BinaryObjectAttributeType is a complex type (extended from
    BaseObjectAttributeType) representing the specification of a
    single Object attribute whose core value is of type
    base64Binary. This type will be assigned to any attribute of a
    CybOX object that should contain content of type Base64Binary
    and enables the use of relevant metadata for the atrribute.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='Base64Binary', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(Base64BinaryObjectAttributeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Base64BinaryObjectAttributeType.subclass:
            return Base64BinaryObjectAttributeType.subclass(*args_, **kwargs_)
        else:
            return Base64BinaryObjectAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='Base64BinaryObjectAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Base64BinaryObjectAttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='Base64BinaryObjectAttributeType'):
        super(Base64BinaryObjectAttributeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Base64BinaryObjectAttributeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='Base64BinaryObjectAttributeType', fromsubclass_=False, pretty_print=True):
        super(Base64BinaryObjectAttributeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(Base64BinaryObjectAttributeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Base64BinaryObjectAttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(Base64BinaryObjectAttributeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Base64BinaryObjectAttributeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(Base64BinaryObjectAttributeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Base64BinaryObjectAttributeType

class ExtractedFeaturesType(GeneratedsSuper):
    """The ExtractedFeaturesType is a complex type representing a
    description of features extracted from an object such as a file."""
    subclass = None
    superclass = None
    def __init__(self, Strings=None, Imports=None, Functions=None, Code_Snippets=None):
        self.Strings = Strings
        self.Imports = Imports
        self.Functions = Functions
        self.Code_Snippets = Code_Snippets
    def factory(*args_, **kwargs_):
        if ExtractedFeaturesType.subclass:
            return ExtractedFeaturesType.subclass(*args_, **kwargs_)
        else:
            return ExtractedFeaturesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Strings(self): return self.Strings
    def set_Strings(self, Strings): self.Strings = Strings
    def get_Imports(self): return self.Imports
    def set_Imports(self, Imports): self.Imports = Imports
    def get_Functions(self): return self.Functions
    def set_Functions(self, Functions): self.Functions = Functions
    def get_Code_Snippets(self): return self.Code_Snippets
    def set_Code_Snippets(self, Code_Snippets): self.Code_Snippets = Code_Snippets
    def export(self, outfile, level, namespace_='Common:', name_='ExtractedFeaturesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExtractedFeaturesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ExtractedFeaturesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ExtractedFeaturesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Strings is not None:
            self.Strings.export(outfile, level, 'Common:', name_='Strings', pretty_print=pretty_print)
        if self.Imports is not None:
            self.Imports.export(outfile, level, 'Common:', name_='Imports', pretty_print=pretty_print)
        if self.Functions is not None:
            self.Functions.export(outfile, level, 'Common:', name_='Functions', pretty_print=pretty_print)
        if self.Code_Snippets is not None:
            self.Code_Snippets.export(outfile, level, 'Common:', name_='Code_Snippets', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Strings is not None or
            self.Imports is not None or
            self.Functions is not None or
            self.Code_Snippets is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ExtractedFeaturesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Strings is not None:
            showIndent(outfile, level)
            outfile.write('Strings=model_.ExtractedStringsType(\n')
            self.Strings.exportLiteral(outfile, level, name_='Strings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Imports is not None:
            showIndent(outfile, level)
            outfile.write('Imports=model_.ImportsType(\n')
            self.Imports.exportLiteral(outfile, level, name_='Imports')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Functions is not None:
            showIndent(outfile, level)
            outfile.write('Functions=model_.FunctionsType(\n')
            self.Functions.exportLiteral(outfile, level, name_='Functions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Code_Snippets is not None:
            showIndent(outfile, level)
            outfile.write('Code_Snippets=model_.CodeSnippetsType(\n')
            self.Code_Snippets.exportLiteral(outfile, level, name_='Code_Snippets')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Strings':
            obj_ = ExtractedStringsType.factory()
            obj_.build(child_)
            self.set_Strings(obj_)
        elif nodeName_ == 'Imports':
            obj_ = ImportsType.factory()
            obj_.build(child_)
            self.set_Imports(obj_)
        elif nodeName_ == 'Functions':
            obj_ = FunctionsType.factory()
            obj_.build(child_)
            self.set_Functions(obj_)
        elif nodeName_ == 'Code_Snippets':
            obj_ = CodeSnippetsType.factory()
            obj_.build(child_)
            self.set_Code_Snippets(obj_)
# end class ExtractedFeaturesType

class ExtractedStringsType(GeneratedsSuper):
    """The ExtractedStringsType type is intended as container for strings
    extracted from CybOX objects."""
    subclass = None
    superclass = None
    def __init__(self, String=None):
        if String is None:
            self.String = []
        else:
            self.String = String
    def factory(*args_, **kwargs_):
        if ExtractedStringsType.subclass:
            return ExtractedStringsType.subclass(*args_, **kwargs_)
        else:
            return ExtractedStringsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_String(self): return self.String
    def set_String(self, String): self.String = String
    def add_String(self, value): self.String.append(value)
    def insert_String(self, index, value): self.String[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='ExtractedStringsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExtractedStringsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ExtractedStringsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ExtractedStringsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for String_ in self.String:
            String_.export(outfile, level, 'Common:', name_='String', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.String
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ExtractedStringsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('String=[\n')
        level += 1
        for String_ in self.String:
            showIndent(outfile, level)
            outfile.write('model_.ExtractedStringType(\n')
            String_.exportLiteral(outfile, level, name_='ExtractedStringType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'String':
            obj_ = ExtractedStringType.factory()
            obj_.build(child_)
            self.String.append(obj_)
# end class ExtractedStringsType

class ExtractedStringType(GeneratedsSuper):
    """The ExtractedStringType type is intended as container a single
    string extracted from a CybOX object.The encoding attribute
    refers to the encoding method used for the string extracted from
    the CybOX object."""
    subclass = None
    superclass = None
    def __init__(self, encoding=None, String_Value=None, Hashes=None, Address=None, Length=None, Language=None, English_Translation=None):
        self.encoding = _cast(None, encoding)
        self.String_Value = String_Value
        self.Hashes = Hashes
        self.Address = Address
        self.Length = Length
        self.Language = Language
        self.English_Translation = English_Translation
    def factory(*args_, **kwargs_):
        if ExtractedStringType.subclass:
            return ExtractedStringType.subclass(*args_, **kwargs_)
        else:
            return ExtractedStringType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_String_Value(self): return self.String_Value
    def set_String_Value(self, String_Value): self.String_Value = String_Value
    def validate_StringObjectAttributeType(self, value):
        # Validate type StringObjectAttributeType, a restriction on xs:string.
        pass
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type HexBinaryObjectAttributeType, a restriction on xs:hexBinary.
        pass
    def get_Length(self): return self.Length
    def set_Length(self, Length): self.Length = Length
    def validate_PositiveIntegerObjectAttributeType(self, value):
        # Validate type PositiveIntegerObjectAttributeType, a restriction on None.
        pass
    def get_Language(self): return self.Language
    def set_Language(self, Language): self.Language = Language
    def get_English_Translation(self): return self.English_Translation
    def set_English_Translation(self, English_Translation): self.English_Translation = English_Translation
    def get_encoding(self): return self.encoding
    def set_encoding(self, encoding): self.encoding = encoding
    def export(self, outfile, level, namespace_='Common:', name_='ExtractedStringType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExtractedStringType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ExtractedStringType'):
        if self.encoding is not None and 'encoding' not in already_processed:
            already_processed.append('encoding')
            outfile.write(' encoding=%s' % (quote_attrib(self.encoding), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ExtractedStringType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.String_Value is not None:
            self.String_Value.export(outfile, level, 'Common:', name_='String_Value', pretty_print=pretty_print)
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, 'Common:', name_='Hashes', pretty_print=pretty_print)
        if self.Address is not None:
            self.Address.export(outfile, level, 'Common:', name_='Address', pretty_print=pretty_print)
        if self.Length is not None:
            self.Length.export(outfile, level, 'Common:', name_='Length', pretty_print=pretty_print)
        if self.Language is not None:
            self.Language.export(outfile, level, 'Common:', name_='Language', pretty_print=pretty_print)
        if self.English_Translation is not None:
            self.English_Translation.export(outfile, level, 'Common:', name_='English_Translation', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.String_Value is not None or
            self.Hashes is not None or
            self.Address is not None or
            self.Length is not None or
            self.Language is not None or
            self.English_Translation is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ExtractedStringType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.encoding is not None and 'encoding' not in already_processed:
            already_processed.append('encoding')
            showIndent(outfile, level)
            outfile.write('encoding = %s,\n' % (self.encoding,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.String_Value is not None:
            showIndent(outfile, level)
            outfile.write('String_Value=%s,\n' % quote_python(self.String_Value).encode(ExternalEncoding))
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.HashListType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Address is not None:
            showIndent(outfile, level)
            outfile.write('Address=%s,\n' % quote_python(self.Address).encode(ExternalEncoding))
        if self.Length is not None:
            showIndent(outfile, level)
            outfile.write('Length=model_.PositiveIntegerObjectAttributeType(\n')
            self.Length.exportLiteral(outfile, level, name_='Length')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Language is not None:
            showIndent(outfile, level)
            outfile.write('Language=%s,\n' % quote_python(self.Language).encode(ExternalEncoding))
        if self.English_Translation is not None:
            showIndent(outfile, level)
            outfile.write('English_Translation=%s,\n' % quote_python(self.English_Translation).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('encoding', node)
        if value is not None and 'encoding' not in already_processed:
            already_processed.append('encoding')
            self.encoding = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'String_Value':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_String_Value(obj_)
        elif nodeName_ == 'Hashes':
            obj_ = HashListType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'Address':
            obj_ = HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Address(obj_)
        elif nodeName_ == 'Length':
            obj_ = PositiveIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Length(obj_)
        elif nodeName_ == 'Language':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Language(obj_)
        elif nodeName_ == 'English_Translation':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_English_Translation(obj_)
# end class ExtractedStringType

class ImportsType(GeneratedsSuper):
    """The ImportsType is intended to represent an extracted list of
    imports specified within a CybOX object."""
    subclass = None
    superclass = None
    def __init__(self, Import=None):
        if Import is None:
            self.Import = []
        else:
            self.Import = Import
    def factory(*args_, **kwargs_):
        if ImportsType.subclass:
            return ImportsType.subclass(*args_, **kwargs_)
        else:
            return ImportsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Import(self): return self.Import
    def set_Import(self, Import): self.Import = Import
    def add_Import(self, value): self.Import.append(value)
    def insert_Import(self, index, value): self.Import[index] = value
    def validate_StringObjectAttributeType(self, value):
        # Validate type StringObjectAttributeType, a restriction on xs:string.
        pass
    def export(self, outfile, level, namespace_='Common:', name_='ImportsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImportsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ImportsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ImportsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Import_ in self.Import:
            self.Import.export(outfile, level, 'Common:', name_='Import', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Import
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImportsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Import=[\n')
        level += 1
        for Import_ in self.Import:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Import_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Import':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.Import.append(obj_)
# end class ImportsType

class FunctionsType(GeneratedsSuper):
    """The FunctionsType is intended to represent an extracted list of
    functions leveraged within a CybOX object."""
    subclass = None
    superclass = None
    def __init__(self, Function=None):
        if Function is None:
            self.Function = []
        else:
            self.Function = Function
    def factory(*args_, **kwargs_):
        if FunctionsType.subclass:
            return FunctionsType.subclass(*args_, **kwargs_)
        else:
            return FunctionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Function(self): return self.Function
    def set_Function(self, Function): self.Function = Function
    def add_Function(self, value): self.Function.append(value)
    def insert_Function(self, index, value): self.Function[index] = value
    def validate_StringObjectAttributeType(self, value):
        # Validate type StringObjectAttributeType, a restriction on xs:string.
        pass
    def export(self, outfile, level, namespace_='Common:', name_='FunctionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FunctionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='FunctionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='FunctionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Function_ in self.Function:
            self.Function.export(outfile, level, 'Common:', name_='Function', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Function
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FunctionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Function=[\n')
        level += 1
        for Function_ in self.Function:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Function_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Function':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.Function.append(obj_)
# end class FunctionsType

class CodeSnippetsType(GeneratedsSuper):
    """The CodeSnippetsType is intended to represent an set of code
    snippets extracted from within a CybOX object."""
    subclass = None
    superclass = None
    def __init__(self, Code_Snippet=None):
        if Code_Snippet is None:
            self.Code_Snippet = []
        else:
            self.Code_Snippet = Code_Snippet
    def factory(*args_, **kwargs_):
        if CodeSnippetsType.subclass:
            return CodeSnippetsType.subclass(*args_, **kwargs_)
        else:
            return CodeSnippetsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Code_Snippet(self): return self.Code_Snippet
    def set_Code_Snippet(self, Code_Snippet): self.Code_Snippet = Code_Snippet
    def add_Code_Snippet(self, value): self.Code_Snippet.append(value)
    def insert_Code_Snippet(self, index, value): self.Code_Snippet[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='CodeSnippetsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CodeSnippetsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='CodeSnippetsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='CodeSnippetsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Code_Snippet_ in self.Code_Snippet:
            Code_Snippet_.export(outfile, level, 'Common:', name_='Code_Snippet', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Code_Snippet
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CodeSnippetsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Code_Snippet=[\n')
        level += 1
        for Code_Snippet_ in self.Code_Snippet:
            showIndent(outfile, level)
            outfile.write('model_.code_object_1_1.CodeObjectType(\n')
            Code_Snippet_.exportLiteral(outfile, level, name_='code_object_1_1.CodeObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Code_Snippet':
            obj_ = code_object_1_1.CodeObjectType.factory()
            obj_.build(child_)
            self.Code_Snippet.append(obj_)
# end class CodeSnippetsType

class ByteRunsType(GeneratedsSuper):
    """The ByteRunsType is used for representing a list of byte runs from
    within a raw object."""
    subclass = None
    superclass = None
    def __init__(self, Byte_Run=None):
        if Byte_Run is None:
            self.Byte_Run = []
        else:
            self.Byte_Run = Byte_Run
    def factory(*args_, **kwargs_):
        if ByteRunsType.subclass:
            return ByteRunsType.subclass(*args_, **kwargs_)
        else:
            return ByteRunsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Byte_Run(self): return self.Byte_Run
    def set_Byte_Run(self, Byte_Run): self.Byte_Run = Byte_Run
    def add_Byte_Run(self, value): self.Byte_Run.append(value)
    def insert_Byte_Run(self, index, value): self.Byte_Run[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='ByteRunsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ByteRunsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ByteRunsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ByteRunsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Byte_Run_ in self.Byte_Run:
            Byte_Run_.export(outfile, level, 'Common:', name_='Byte_Run', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Byte_Run
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ByteRunsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Byte_Run=[\n')
        level += 1
        for Byte_Run_ in self.Byte_Run:
            showIndent(outfile, level)
            outfile.write('model_.ByteRunType(\n')
            Byte_Run_.exportLiteral(outfile, level, name_='ByteRunType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Byte_Run':
            obj_ = ByteRunType.factory()
            obj_.build(child_)
            self.Byte_Run.append(obj_)
# end class ByteRunsType

class ByteRunType(GeneratedsSuper):
    """The ByteRunType is used for representing a single byte run from
    within a raw object."""
    subclass = None
    superclass = None
    def __init__(self, Offset=None, File_System_Offset=None, Image_Offset=None, Length=None, Hashes=None, Byte_Run_Data=None):
        self.Offset = Offset
        self.File_System_Offset = File_System_Offset
        self.Image_Offset = Image_Offset
        self.Length = Length
        self.Hashes = Hashes
        self.Byte_Run_Data = Byte_Run_Data
    def factory(*args_, **kwargs_):
        if ByteRunType.subclass:
            return ByteRunType.subclass(*args_, **kwargs_)
        else:
            return ByteRunType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Offset(self): return self.Offset
    def set_Offset(self, Offset): self.Offset = Offset
    def validate_IntegerObjectAttributeType(self, value):
        # Validate type IntegerObjectAttributeType, a restriction on None.
        pass
    def get_File_System_Offset(self): return self.File_System_Offset
    def set_File_System_Offset(self, File_System_Offset): self.File_System_Offset = File_System_Offset
    def get_Image_Offset(self): return self.Image_Offset
    def set_Image_Offset(self, Image_Offset): self.Image_Offset = Image_Offset
    def get_Length(self): return self.Length
    def set_Length(self, Length): self.Length = Length
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Byte_Run_Data(self): return self.Byte_Run_Data
    def set_Byte_Run_Data(self, Byte_Run_Data): self.Byte_Run_Data = Byte_Run_Data
    def export(self, outfile, level, namespace_='Common:', name_='ByteRunType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ByteRunType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ByteRunType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ByteRunType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Offset is not None:
            self.Offset.export(outfile, level, 'Common:', name_='Offset', pretty_print=pretty_print)
        if self.File_System_Offset is not None:
            self.File_System_Offset.export(outfile, level, 'Common:', name_='File_System_Offset', pretty_print=pretty_print)
        if self.Image_Offset is not None:
            self.Image_Offset.export(outfile, level, 'Common:', name_='Image_Offset', pretty_print=pretty_print)
        if self.Length is not None:
            self.Length.export(outfile, level, 'Common:', name_='Length', pretty_print=pretty_print)
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, 'Common:', name_='Hashes', pretty_print=pretty_print)
        if self.Byte_Run_Data is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sByte_Run_Data>%s</%sByte_Run_Data>%s' % ('Common:', self.gds_format_string(quote_xml(self.Byte_Run_Data).encode(ExternalEncoding), input_name='Byte_Run_Data'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Offset is not None or
            self.File_System_Offset is not None or
            self.Image_Offset is not None or
            self.Length is not None or
            self.Hashes is not None or
            self.Byte_Run_Data is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ByteRunType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Offset is not None:
            showIndent(outfile, level)
            outfile.write('Offset=model_.IntegerObjectAttributeType(\n')
            self.Offset.exportLiteral(outfile, level, name_='Offset')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_System_Offset is not None:
            showIndent(outfile, level)
            outfile.write('File_System_Offset=model_.IntegerObjectAttributeType(\n')
            self.File_System_Offset.exportLiteral(outfile, level, name_='File_System_Offset')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Image_Offset is not None:
            showIndent(outfile, level)
            outfile.write('Image_Offset=model_.IntegerObjectAttributeType(\n')
            self.Image_Offset.exportLiteral(outfile, level, name_='Image_Offset')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Length is not None:
            showIndent(outfile, level)
            outfile.write('Length=model_.IntegerObjectAttributeType(\n')
            self.Length.exportLiteral(outfile, level, name_='Length')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.HashListType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Byte_Run_Data is not None:
            showIndent(outfile, level)
            outfile.write('Byte_Run_Data=%s,\n' % quote_python(self.Byte_Run_Data).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Offset':
            obj_ = IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Offset(obj_)
        elif nodeName_ == 'File_System_Offset':
            obj_ = IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_File_System_Offset(obj_)
        elif nodeName_ == 'Image_Offset':
            obj_ = IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Image_Offset(obj_)
        elif nodeName_ == 'Length':
            obj_ = PositiveIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Length(obj_)
        elif nodeName_ == 'Hashes':
            obj_ = HashListType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'Byte_Run_Data':
            Byte_Run_Data_ = child_.text
            Byte_Run_Data_ = self.gds_validate_string(Byte_Run_Data_, node, 'Byte_Run_Data')
            self.Byte_Run_Data = Byte_Run_Data_
# end class ByteRunType

class HashListType(GeneratedsSuper):
    """The HashListType type is used for representing a list of hash
    values."""
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if HashListType.subclass:
            return HashListType.subclass(*args_, **kwargs_)
        else:
            return HashListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='HashListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='HashListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='HashListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, 'Common:', name_='Hash', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class HashListType

class HashValueType(GeneratedsSuper):
    """The HashValueType is used for specifying the resulting value from a
    hash calculation."""
    subclass = None
    superclass = None
    def __init__(self, Simple_Hash_Value=None, Fuzzy_Hash_Value=None):
        self.Simple_Hash_Value = Simple_Hash_Value
        self.Fuzzy_Hash_Value = Fuzzy_Hash_Value
    def factory(*args_, **kwargs_):
        if HashValueType.subclass:
            return HashValueType.subclass(*args_, **kwargs_)
        else:
            return HashValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Simple_Hash_Value(self): return self.Simple_Hash_Value
    def set_Simple_Hash_Value(self, Simple_Hash_Value): self.Simple_Hash_Value = Simple_Hash_Value
    def get_Fuzzy_Hash_Value(self): return self.Fuzzy_Hash_Value
    def set_Fuzzy_Hash_Value(self, Fuzzy_Hash_Value): self.Fuzzy_Hash_Value = Fuzzy_Hash_Value
    def export(self, outfile, level, namespace_='Common:', name_='HashValueType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='HashValueType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='HashValueType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Simple_Hash_Value is not None:
            self.Simple_Hash_Value.export(outfile, level, 'Common:', name_='Simple_Hash_Value', pretty_print=pretty_print)
        if self.Fuzzy_Hash_Value is not None:
            self.Fuzzy_Hash_Value.export(outfile, level, 'Common:', name_='Fuzzy_Hash_Value', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Simple_Hash_Value is not None or
            self.Fuzzy_Hash_Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashValueType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Simple_Hash_Value is not None:
            showIndent(outfile, level)
            outfile.write('Simple_Hash_Value=model_.SimpleHashValueType(\n')
            self.Simple_Hash_Value.exportLiteral(outfile, level, name_='Simple_Hash_Value')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Fuzzy_Hash_Value is not None:
            showIndent(outfile, level)
            outfile.write('Fuzzy_Hash_Value=model_.FuzzyHashValueType(\n')
            self.Fuzzy_Hash_Value.exportLiteral(outfile, level, name_='Fuzzy_Hash_Value')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Simple_Hash_Value':
            obj_ = SimpleHashValueType.factory()
            obj_.build(child_)
            self.set_Simple_Hash_Value(obj_)
        elif nodeName_ == 'Fuzzy_Hash_Value':
            obj_ = FuzzyHashValueType.factory()
            obj_.build(child_)
            self.set_Fuzzy_Hash_Value(obj_)
# end class HashValueType

class SimpleHashValueType(HexBinaryObjectAttributeType):
    """The SimpleHashValueType is used for characterizing the output of
    basic cryptograhic hash functions outputing a single hexbinary
    hash value."""
    subclass = None
    superclass = HexBinaryObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='hexBinary', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(SimpleHashValueType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, )
        self.valueOf_ = valueOf_
        pass
    def factory(*args_, **kwargs_):
        if SimpleHashValueType.subclass:
            return SimpleHashValueType.subclass(*args_, **kwargs_)
        else:
            return SimpleHashValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='SimpleHashValueType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SimpleHashValueType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='SimpleHashValueType'):
        super(SimpleHashValueType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SimpleHashValueType')
    def exportChildren(self, outfile, level, namespace_='Common:', name_='SimpleHashValueType', fromsubclass_=False, pretty_print=True):
        super(SimpleHashValueType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(SimpleHashValueType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SimpleHashValueType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
        
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SimpleHashValueType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SimpleHashValueType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(SimpleHashValueType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SimpleHashValueType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SimpleHashValueType

class FuzzyHashValueType(StringObjectAttributeType):
    """The FuzzyHashValueType is used for characterizing the output of
    cryptograhic fuzzy hash functions outputing a single complex
    string based hash value."""
    subclass = None
    superclass = StringObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None):
        super(FuzzyHashValueType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, )
        pass
    def factory(*args_, **kwargs_):
        if FuzzyHashValueType.subclass:
            return FuzzyHashValueType.subclass(*args_, **kwargs_)
        else:
            return FuzzyHashValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='Common:', name_='FuzzyHashValueType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FuzzyHashValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='FuzzyHashValueType'):
        super(FuzzyHashValueType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FuzzyHashValueType')
    def exportChildren(self, outfile, level, namespace_='Common:', name_='FuzzyHashValueType', fromsubclass_=False, pretty_print=True):
        super(FuzzyHashValueType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            super(FuzzyHashValueType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FuzzyHashValueType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(FuzzyHashValueType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FuzzyHashValueType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(FuzzyHashValueType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FuzzyHashValueType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class FuzzyHashValueType

class FuzzyHashStructureType(GeneratedsSuper):
    """The FuzzyHashStructureType is used for characterizing the internal
    components of a cryptograhic fuzzy hash algorithmic calculation."""
    subclass = None
    superclass = None
    def __init__(self, Block_Size=None, Block_Hash=None):
        self.Block_Size = Block_Size
        self.Block_Hash = Block_Hash
    def factory(*args_, **kwargs_):
        if FuzzyHashStructureType.subclass:
            return FuzzyHashStructureType.subclass(*args_, **kwargs_)
        else:
            return FuzzyHashStructureType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Block_Size(self): return self.Block_Size
    def set_Block_Size(self, Block_Size): self.Block_Size = Block_Size
    def validate_IntegerObjectAttributeType(self, value):
        # Validate type IntegerObjectAttributeType, a restriction on None.
        pass
    def get_Block_Hash(self): return self.Block_Hash
    def set_Block_Hash(self, Block_Hash): self.Block_Hash = Block_Hash
    def export(self, outfile, level, namespace_='Common:', name_='FuzzyHashStructureType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FuzzyHashStructureType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='FuzzyHashStructureType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='FuzzyHashStructureType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Block_Size is not None:
            self.Block_Size.export(outfile, level, 'Common:', name_='Block_Size', pretty_print=pretty_print)
        if self.Block_Hash is not None:
            self.Block_Hash.export(outfile, level, 'Common:', name_='Block_Hash', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Block_Size is not None or
            self.Block_Hash is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FuzzyHashStructureType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Block_Size is not None:
            showIndent(outfile, level)
            outfile.write('Block_Size=model_.IntegerObjectAttributeType(\n')
            self.Block_Size.exportLiteral(outfile, level, name_='Block_Size')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Block_Hash is not None:
            showIndent(outfile, level)
            outfile.write('Block_Hash=model_.FuzzyHashBlockType(\n')
            self.Block_Hash.exportLiteral(outfile, level, name_='Block_Hash')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Block_Size':
            obj_ = IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Block_Size(obj_)
        elif nodeName_ == 'Block_Hash':
            obj_ = FuzzyHashBlockType.factory()
            obj_.build(child_)
            self.set_Block_Hash(obj_)
# end class FuzzyHashStructureType

class FuzzyHashBlockType(GeneratedsSuper):
    """The FuzzyHashBlockType is used for characterizing the internal
    components of a single block in a cryptograhic fuzzy hash
    algorithmic calculation."""
    subclass = None
    superclass = None
    def __init__(self, Block_Hash_Value=None, Segment_Count=None, Segments=None):
        self.Block_Hash_Value = Block_Hash_Value
        self.Segment_Count = Segment_Count
        self.Segments = Segments
    def factory(*args_, **kwargs_):
        if FuzzyHashBlockType.subclass:
            return FuzzyHashBlockType.subclass(*args_, **kwargs_)
        else:
            return FuzzyHashBlockType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Block_Hash_Value(self): return self.Block_Hash_Value
    def set_Block_Hash_Value(self, Block_Hash_Value): self.Block_Hash_Value = Block_Hash_Value
    def get_Segment_Count(self): return self.Segment_Count
    def set_Segment_Count(self, Segment_Count): self.Segment_Count = Segment_Count
    def validate_IntegerObjectAttributeType(self, value):
        # Validate type IntegerObjectAttributeType, a restriction on None.
        pass
    def get_Segments(self): return self.Segments
    def set_Segments(self, Segments): self.Segments = Segments
    def export(self, outfile, level, namespace_='Common:', name_='FuzzyHashBlockType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FuzzyHashBlockType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='FuzzyHashBlockType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='FuzzyHashBlockType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Block_Hash_Value is not None:
            self.Block_Hash_Value.export(outfile, level, 'Common:', name_='Block_Hash_Value', pretty_print=pretty_print)
        if self.Segment_Count is not None:
            self.Segment_Count.export(outfile, level, 'Common:', name_='Segment_Count', pretty_print=pretty_print)
        if self.Segments is not None:
            self.Segments.export(outfile, level, 'Common:', name_='Segments', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Block_Hash_Value is not None or
            self.Segment_Count is not None or
            self.Segments is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FuzzyHashBlockType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Block_Hash_Value is not None:
            showIndent(outfile, level)
            outfile.write('Block_Hash_Value=model_.HashValueType(\n')
            self.Block_Hash_Value.exportLiteral(outfile, level, name_='Block_Hash_Value')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Segment_Count is not None:
            showIndent(outfile, level)
            outfile.write('Segment_Count=model_.IntegerObjectAttributeType(\n')
            self.Segment_Count.exportLiteral(outfile, level, name_='Segment_Count')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Segments is not None:
            showIndent(outfile, level)
            outfile.write('Segments=model_.HashSegmentsType(\n')
            self.Segments.exportLiteral(outfile, level, name_='Segments')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Block_Hash_Value':
            obj_ = HashValueType.factory()
            obj_.build(child_)
            self.set_Block_Hash_Value(obj_)
        elif nodeName_ == 'Segment_Count':
            obj_ = IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Segment_Count(obj_)
        elif nodeName_ == 'Segments':
            obj_ = HashSegmentsType.factory()
            obj_.build(child_)
            self.set_Segments(obj_)
# end class FuzzyHashBlockType

class HashSegmentsType(GeneratedsSuper):
    """The HashSegmentsType is used for characterizing the internal
    components of a set of trigger point-delimited segments in a
    cryptograhic fuzzy hash algorithmic calculation."""
    subclass = None
    superclass = None
    def __init__(self, Segment=None):
        if Segment is None:
            self.Segment = []
        else:
            self.Segment = Segment
    def factory(*args_, **kwargs_):
        if HashSegmentsType.subclass:
            return HashSegmentsType.subclass(*args_, **kwargs_)
        else:
            return HashSegmentsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Segment(self): return self.Segment
    def set_Segment(self, Segment): self.Segment = Segment
    def add_Segment(self, value): self.Segment.append(value)
    def insert_Segment(self, index, value): self.Segment[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='HashSegmentsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashSegmentsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='HashSegmentsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='HashSegmentsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Segment_ in self.Segment:
            Segment_.export(outfile, level, 'Common:', name_='Segment', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Segment
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashSegmentsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Segment=[\n')
        level += 1
        for Segment_ in self.Segment:
            showIndent(outfile, level)
            outfile.write('model_.HashSegmentType(\n')
            Segment_.exportLiteral(outfile, level, name_='HashSegmentType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Segment':
            obj_ = HashSegmentType.factory()
            obj_.build(child_)
            self.Segment.append(obj_)
# end class HashSegmentsType

class HashSegmentType(GeneratedsSuper):
    """The HashSegmentType is used for characterizing the internal
    components of a single trigger point-delimited segment in a
    cryptograhic fuzzy hash algorithmic calculation."""
    subclass = None
    superclass = None
    def __init__(self, Trigger_Point=None, Segment_Hash=None, Raw_Segment_Content=None):
        self.Trigger_Point = Trigger_Point
        self.Segment_Hash = Segment_Hash
        self.Raw_Segment_Content = Raw_Segment_Content
    def factory(*args_, **kwargs_):
        if HashSegmentType.subclass:
            return HashSegmentType.subclass(*args_, **kwargs_)
        else:
            return HashSegmentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Trigger_Point(self): return self.Trigger_Point
    def set_Trigger_Point(self, Trigger_Point): self.Trigger_Point = Trigger_Point
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type HexBinaryObjectAttributeType, a restriction on xs:hexBinary.
        pass
    def get_Segment_Hash(self): return self.Segment_Hash
    def set_Segment_Hash(self, Segment_Hash): self.Segment_Hash = Segment_Hash
    def get_Raw_Segment_Content(self): return self.Raw_Segment_Content
    def set_Raw_Segment_Content(self, Raw_Segment_Content): self.Raw_Segment_Content = Raw_Segment_Content
    def export(self, outfile, level, namespace_='Common:', name_='HashSegmentType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashSegmentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='HashSegmentType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='HashSegmentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Trigger_Point is not None:
            self.Trigger_Point.export(outfile, level, 'Common:', name_='Trigger_Point', pretty_print=pretty_print)
        if self.Segment_Hash is not None:
            self.Segment_Hash.export(outfile, level, 'Common:', name_='Segment_Hash', pretty_print=pretty_print)
        if self.Raw_Segment_Content is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRaw_Segment_Content>%s</%sRaw_Segment_Content>%s' % ('Common:', self.gds_format_string(quote_xml(self.Raw_Segment_Content).encode(ExternalEncoding), input_name='Raw_Segment_Content'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Trigger_Point is not None or
            self.Segment_Hash is not None or
            self.Raw_Segment_Content is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashSegmentType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Trigger_Point is not None:
            showIndent(outfile, level)
            outfile.write('Trigger_Point=%s,\n' % quote_python(self.Trigger_Point).encode(ExternalEncoding))
        if self.Segment_Hash is not None:
            showIndent(outfile, level)
            outfile.write('Segment_Hash=model_.HashValueType(\n')
            self.Segment_Hash.exportLiteral(outfile, level, name_='Segment_Hash')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Raw_Segment_Content is not None:
            showIndent(outfile, level)
            outfile.write('Raw_Segment_Content=%s,\n' % quote_python(self.Raw_Segment_Content).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Trigger_Point':
            obj_ = HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Trigger_Point(obj_)
        elif nodeName_ == 'Segment_Hash':
            obj_ = HashValueType.factory()
            obj_.build(child_)
            self.set_Segment_Hash(obj_)
        elif nodeName_ == 'Raw_Segment_Content':
            Raw_Segment_Content_ = child_.text
            Raw_Segment_Content_ = self.gds_validate_string(Raw_Segment_Content_, node, 'Raw_Segment_Content')
            self.Raw_Segment_Content = Raw_Segment_Content_
# end class HashSegmentType

class HashType(GeneratedsSuper):
    """The HashType type is intended to characterize hash values."""
    subclass = None
    superclass = None
    def __init__(self, Type=None, Other_Type=None, Simple_Hash_Value=None, Fuzzy_Hash_Value=None, Fuzzy_Hash_Structure=None):
        self.Type = Type
        self.Other_Type = Other_Type
        self.Simple_Hash_Value = Simple_Hash_Value
        self.Fuzzy_Hash_Value = Fuzzy_Hash_Value
        if Fuzzy_Hash_Structure is None:
            self.Fuzzy_Hash_Structure = []
        else:
            self.Fuzzy_Hash_Structure = Fuzzy_Hash_Structure
    def factory(*args_, **kwargs_):
        if HashType.subclass:
            return HashType.subclass(*args_, **kwargs_)
        else:
            return HashType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_HashNameType(self, value):
        # Validate type HashNameType, a restriction on None.
        pass
    def get_Other_Type(self): return self.Other_Type
    def set_Other_Type(self, Other_Type): self.Other_Type = Other_Type
    def validate_StringObjectAttributeType(self, value):
        # Validate type StringObjectAttributeType, a restriction on xs:string.
        pass
    def get_Simple_Hash_Value(self): return self.Simple_Hash_Value
    def set_Simple_Hash_Value(self, Simple_Hash_Value): self.Simple_Hash_Value = Simple_Hash_Value
    def get_Fuzzy_Hash_Value(self): return self.Fuzzy_Hash_Value
    def set_Fuzzy_Hash_Value(self, Fuzzy_Hash_Value): self.Fuzzy_Hash_Value = Fuzzy_Hash_Value
    def get_Fuzzy_Hash_Structure(self): return self.Fuzzy_Hash_Structure
    def set_Fuzzy_Hash_Structure(self, Fuzzy_Hash_Structure): self.Fuzzy_Hash_Structure = Fuzzy_Hash_Structure
    def add_Fuzzy_Hash_Structure(self, value): self.Fuzzy_Hash_Structure.append(value)
    def insert_Fuzzy_Hash_Structure(self, index, value): self.Fuzzy_Hash_Structure[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='HashType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='HashType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='HashType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Type is not None:
            self.Type.export(outfile, level, 'Common:', name_='Type', pretty_print=pretty_print)
        if self.Other_Type is not None:
            self.Other_Type.export(outfile, level, 'Common:', name_='Other_Type', pretty_print=pretty_print)
        if self.Simple_Hash_Value is not None:
            self.Simple_Hash_Value.export(outfile, level, 'Common:', name_='Simple_Hash_Value', pretty_print=pretty_print)
        if self.Fuzzy_Hash_Value is not None:
            self.Fuzzy_Hash_Value.export(outfile, level, 'Common:', name_='Fuzzy_Hash_Value', pretty_print=pretty_print)
        for Fuzzy_Hash_Structure_ in self.Fuzzy_Hash_Structure:
            Fuzzy_Hash_Structure_.export(outfile, level, 'Common:', name_='Fuzzy_Hash_Structure', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Type is not None or
            self.Other_Type is not None or
            self.Simple_Hash_Value is not None or
            self.Fuzzy_Hash_Value is not None or
            self.Fuzzy_Hash_Structure
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Type is not None:
            showIndent(outfile, level)
            outfile.write('Type=model_.HashNameType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Other_Type is not None:
            showIndent(outfile, level)
            outfile.write('Other_Type=%s,\n' % quote_python(self.Other_Type).encode(ExternalEncoding))
        if self.Simple_Hash_Value is not None:
            showIndent(outfile, level)
            outfile.write('Simple_Hash_Value=model_.SimpleHashValueType(\n')
            self.Simple_Hash_Value.exportLiteral(outfile, level, name_='Simple_Hash_Value')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Fuzzy_Hash_Value is not None:
            showIndent(outfile, level)
            outfile.write('Fuzzy_Hash_Value=model_.FuzzyHashValueType(\n')
            self.Fuzzy_Hash_Value.exportLiteral(outfile, level, name_='Fuzzy_Hash_Value')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Fuzzy_Hash_Structure=[\n')
        level += 1
        for Fuzzy_Hash_Structure_ in self.Fuzzy_Hash_Structure:
            showIndent(outfile, level)
            outfile.write('model_.FuzzyHashStructureType(\n')
            Fuzzy_Hash_Structure_.exportLiteral(outfile, level, name_='FuzzyHashStructureType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            obj_ = HashNameType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
        elif nodeName_ == 'Other_Type':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Other_Type(obj_)
        elif nodeName_ == 'Simple_Hash_Value':
            obj_ = SimpleHashValueType.factory()
            obj_.build(child_)
            self.set_Simple_Hash_Value(obj_)
        elif nodeName_ == 'Fuzzy_Hash_Value':
            obj_ = FuzzyHashValueType.factory()
            obj_.build(child_)
            self.set_Fuzzy_Hash_Value(obj_)
        elif nodeName_ == 'Fuzzy_Hash_Structure':
            obj_ = FuzzyHashStructureType.factory()
            obj_.build(child_)
            self.Fuzzy_Hash_Structure.append(obj_)
# end class HashType

class HashNameType(BaseObjectAttributeType):
    """HashNameType specifies the name of hashing algorithms, via a union
    of the HashNameEnum type and the atomic xs:string type. Its base
    type is the CybOX Core BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(HashNameType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if HashNameType.subclass:
            return HashNameType.subclass(*args_, **kwargs_)
        else:
            return HashNameType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='HashNameType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashNameType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='HashNameType'):
        super(HashNameType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HashNameType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='HashNameType', fromsubclass_=False, pretty_print=True):
        super(HashNameType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(HashNameType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashNameType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(HashNameType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HashNameType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(HashNameType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class HashNameType

class StructuredTextType(GeneratedsSuper):
    """The StructuredTextType is a complex type representing a generalized
    structure for capturing structured textual information such as
    descriptions of things."""
    subclass = None
    superclass = None
    def __init__(self, Text_Title=None, Text=None, Code_Example_Language=None, Code=None, Comment=None, Images=None, Block=None):
        if Text_Title is None:
            self.Text_Title = []
        else:
            self.Text_Title = Text_Title
        if Text is None:
            self.Text = []
        else:
            self.Text = Text
        if Code_Example_Language is None:
            self.Code_Example_Language = []
        else:
            self.Code_Example_Language = Code_Example_Language
        if Code is None:
            self.Code = []
        else:
            self.Code = Code
        if Comment is None:
            self.Comment = []
        else:
            self.Comment = Comment
        self.Images = Images
        self.Block = Block
    def factory(*args_, **kwargs_):
        if StructuredTextType.subclass:
            return StructuredTextType.subclass(*args_, **kwargs_)
        else:
            return StructuredTextType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Text_Title(self): return self.Text_Title
    def set_Text_Title(self, Text_Title): self.Text_Title = Text_Title
    def add_Text_Title(self, value): self.Text_Title.append(value)
    def insert_Text_Title(self, index, value): self.Text_Title[index] = value
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def add_Text(self, value): self.Text.append(value)
    def insert_Text(self, index, value): self.Text[index] = value
    def get_Code_Example_Language(self): return self.Code_Example_Language
    def set_Code_Example_Language(self, Code_Example_Language): self.Code_Example_Language = Code_Example_Language
    def add_Code_Example_Language(self, value): self.Code_Example_Language.append(value)
    def insert_Code_Example_Language(self, index, value): self.Code_Example_Language[index] = value
    def validate_LanguageTypeEnum(self, value):
        # Validate type LanguageTypeEnum, a restriction on xs:string.
        pass
    def get_Code(self): return self.Code
    def set_Code(self, Code): self.Code = Code
    def add_Code(self, value): self.Code.append(value)
    def insert_Code(self, index, value): self.Code[index] = value
    def get_Comment(self): return self.Comment
    def set_Comment(self, Comment): self.Comment = Comment
    def add_Comment(self, value): self.Comment.append(value)
    def insert_Comment(self, index, value): self.Comment[index] = value
    def get_Images(self): return self.Images
    def set_Images(self, Images): self.Images = Images
    def get_Block(self): return self.Block
    def set_Block(self, Block): self.Block = Block
    def export(self, outfile, level, namespace_='Common:', name_='StructuredTextType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StructuredTextType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='StructuredTextType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='StructuredTextType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Text_Title_ in self.Text_Title:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sText_Title>%s</%sText_Title>%s' % ('Common:', self.gds_format_string(quote_xml(Text_Title_).encode(ExternalEncoding), input_name='Text_Title'), 'Common:', eol_))
        for Text_ in self.Text:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sText>%s</%sText>%s' % ('Common:', self.gds_format_string(quote_xml(Text_).encode(ExternalEncoding), input_name='Text'), 'Common:', eol_))
        for Code_Example_Language_ in self.Code_Example_Language:
            #self.Code_Example_Language.export(outfile, level, 'Common:', name_='Code_Example_Language', pretty_print=pretty_print)
            outfile.write('<%sCode_Example_Language>%s</%sCode_Example_Language>%s' % ('Common:', self.gds_format_string(quote_xml(Code_Example_Language_).encode(ExternalEncoding), input_name='Code_Example_Language'), 'Common:', eol_))
        for Code_ in self.Code:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCode>%s</%sCode>%s' % ('Common:', self.gds_format_string(quote_xml(Code_).encode(ExternalEncoding), input_name='Code'), 'Common:', eol_))
        for Comment_ in self.Comment:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sComment>%s</%sComment>%s' % ('Common:', self.gds_format_string(quote_xml(Comment_).encode(ExternalEncoding), input_name='Comment'), 'Common:', eol_))
        if self.Images is not None:
            self.Images.export(outfile, level, 'Common:', name_='Images', pretty_print=pretty_print)
        if self.Block is not None:
            self.Block.export(outfile, level, 'Common:', name_='Block', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Text_Title or
            self.Text or
            self.Code_Example_Language or
            self.Code or
            self.Comment or
            self.Images is not None or
            self.Block is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StructuredTextType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Text_Title=[\n')
        level += 1
        for Text_Title_ in self.Text_Title:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Text_Title_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Text=[\n')
        level += 1
        for Text_ in self.Text:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Text_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Code_Example_Language=[\n')
        level += 1
        for Code_Example_Language_ in self.Code_Example_Language:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Code_Example_Language_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Code=[\n')
        level += 1
        for Code_ in self.Code:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Code_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Comment=[\n')
        level += 1
        for Comment_ in self.Comment:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Comment_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Images is not None:
            showIndent(outfile, level)
            outfile.write('Images=model_.ImagesType(\n')
            self.Images.exportLiteral(outfile, level, name_='Images')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Block is not None:
            showIndent(outfile, level)
            outfile.write('Block=model_.Block(\n')
            self.Block.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Text_Title':
            Text_Title_ = child_.text
            Text_Title_ = self.gds_validate_string(Text_Title_, node, 'Text_Title')
            self.Text_Title.append(Text_Title_)
        elif nodeName_ == 'Text':
            Text_ = child_.text
            Text_ = self.gds_validate_string(Text_, node, 'Text')
            self.Text.append(Text_)
        elif nodeName_ == 'Code_Example_Language':
            Code_Example_Language_ = child_.text
            Code_Example_Language_ = self.gds_validate_string(Code_Example_Language_, node, 'Code_Example_Language')
            self.Code_Example_Language.append(Code_Example_Language_)

        elif nodeName_ == 'Code':
            Code_ = child_.text
            Code_ = self.gds_validate_string(Code_, node, 'Code')
            self.Code.append(Code_)
        elif nodeName_ == 'Comment':
            Comment_ = child_.text
            Comment_ = self.gds_validate_string(Comment_, node, 'Comment')
            self.Comment.append(Comment_)
        elif nodeName_ == 'Images':
            obj_ = ImagesType.factory()
            obj_.build(child_)
            self.set_Images(obj_)
        elif nodeName_ == 'Block':
            obj_ = Block.factory()
            obj_.build(child_)
            self.set_Block(obj_)
# end class StructuredTextType



class Block(GeneratedsSuper):
    """Block is a Structured_Text element consisting of one of Text_Title,
    Text, Code_Example_Language, or Code followed by another Block
    element. Structured_Text elements help define whitespace and
    text segments. This attribute identifies the nature of the
    content contained within the Block."""
    subclass = None
    superclass = None
    def __init__(self, block_nature=None, Text_Title=None, Text=None, Code_Example_Language=None, Code=None, Comment=None, Images=None, Block=None):
        self.block_nature = _cast(None, block_nature)
        if Text_Title is None:
            self.Text_Title = []
        else:
            self.Text_Title = Text_Title
        if Text is None:
            self.Text = []
        else:
            self.Text = Text
        if Code_Example_Language is None:
            self.Code_Example_Language = []
        else:
            self.Code_Example_Language = Code_Example_Language
        if Code is None:
            self.Code = []
        else:
            self.Code = Code
        if Comment is None:
            self.Comment = []
        else:
            self.Comment = Comment
        self.Images = Images
        self.Block = Block
    def factory(*args_, **kwargs_):
        if Block.subclass:
            return Block.subclass(*args_, **kwargs_)
        else:
            return Block(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Text_Title(self): return self.Text_Title
    def set_Text_Title(self, Text_Title): self.Text_Title = Text_Title
    def add_Text_Title(self, value): self.Text_Title.append(value)
    def insert_Text_Title(self, index, value): self.Text_Title[index] = value
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def add_Text(self, value): self.Text.append(value)
    def insert_Text(self, index, value): self.Text[index] = value
    def get_Code_Example_Language(self): return self.Code_Example_Language
    def set_Code_Example_Language(self, Code_Example_Language): self.Code_Example_Language = Code_Example_Language
    def add_Code_Example_Language(self, value): self.Code_Example_Language.append(value)
    def insert_Code_Example_Language(self, index, value): self.Code_Example_Language[index] = value
    def validate_LanguageTypeEnum(self, value):
        # Validate type LanguageTypeEnum, a restriction on xs:string.
        pass
    def get_Code(self): return self.Code
    def set_Code(self, Code): self.Code = Code
    def add_Code(self, value): self.Code.append(value)
    def insert_Code(self, index, value): self.Code[index] = value
    def get_Comment(self): return self.Comment
    def set_Comment(self, Comment): self.Comment = Comment
    def add_Comment(self, value): self.Comment.append(value)
    def insert_Comment(self, index, value): self.Comment[index] = value
    def get_Images(self): return self.Images
    def set_Images(self, Images): self.Images = Images
    def get_Block(self): return self.Block
    def set_Block(self, Block): self.Block = Block
    def get_block_nature(self): return self.block_nature
    def set_block_nature(self, block_nature): self.block_nature = block_nature
    def export(self, outfile, level, namespace_='Common:', name_='Block', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Block')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='Block'):
        if self.block_nature is not None and 'block_nature' not in already_processed:
            already_processed.append('block_nature')
            outfile.write(' block_nature=%s' % (quote_attrib(self.block_nature), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='Block', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Text_Title_ in self.Text_Title:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sText_Title>%s</%sText_Title>%s' % (namespace_, self.gds_format_string(quote_xml(Text_Title_).encode(ExternalEncoding), input_name='Text_Title'), namespace_, eol_))
        for Text_ in self.Text:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sText>%s</%sText>%s' % (namespace_, self.gds_format_string(quote_xml(Text_).encode(ExternalEncoding), input_name='Text'), namespace_, eol_))
        for Code_Example_Language_ in self.Code_Example_Language:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCode_Example_Language>%s</%sCode_Example_Language>%s' % (namespace_, self.gds_format_string(quote_xml(Code_Example_Language_).encode(ExternalEncoding), input_name='Code_Example_Language'), namespace_, eol_))
        for Code_ in self.Code:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCode>%s</%sCode>%s' % (namespace_, self.gds_format_string(quote_xml(Code_).encode(ExternalEncoding), input_name='Code'), namespace_, eol_))
        for Comment_ in self.Comment:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sComment>%s</%sComment>%s' % (namespace_, self.gds_format_string(quote_xml(Comment_).encode(ExternalEncoding), input_name='Comment'), namespace_, eol_))
        if self.Images is not None:
            self.Images.export(outfile, level, namespace_, name_='Images', pretty_print=pretty_print)
        if self.Block is not None:
            self.Block.export(outfile, level, namespace_, name_='Block', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Text_Title or
            self.Text or
            self.Code_Example_Language or
            self.Code or
            self.Comment or
            self.Images is not None or
            self.Block is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Block'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.block_nature is not None and 'block_nature' not in already_processed:
            already_processed.append('block_nature')
            showIndent(outfile, level)
            outfile.write('block_nature = %s,\n' % (self.block_nature,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Text_Title=[\n')
        level += 1
        for Text_Title_ in self.Text_Title:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Text_Title_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Text=[\n')
        level += 1
        for Text_ in self.Text:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Text_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Code_Example_Language=[\n')
        level += 1
        for Code_Example_Language_ in self.Code_Example_Language:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Code_Example_Language_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Code=[\n')
        level += 1
        for Code_ in self.Code:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Code_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Comment=[\n')
        level += 1
        for Comment_ in self.Comment:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Comment_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Images is not None:
            showIndent(outfile, level)
            outfile.write('Images=model_.ImagesType(\n')
            self.Images.exportLiteral(outfile, level, name_='Images')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Block is not None:
            showIndent(outfile, level)
            outfile.write('Block=model_.Block(\n')
            self.Block.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('block_nature', node)
        if value is not None and 'block_nature' not in already_processed:
            already_processed.append('block_nature')
            self.block_nature = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Text_Title':
            Text_Title_ = child_.text
            Text_Title_ = self.gds_validate_string(Text_Title_, node, 'Text_Title')
            self.Text_Title.append(Text_Title_)
        elif nodeName_ == 'Text':
            Text_ = child_.text
            Text_ = self.gds_validate_string(Text_, node, 'Text')
            self.Text.append(Text_)
        elif nodeName_ == 'Code_Example_Language':
            Code_Example_Language_ = child_.text
            Code_Example_Language_ = self.gds_validate_string(Code_Example_Language_, node, 'Code_Example_Language')
            self.Code_Example_Language.append(Code_Example_Language_)
            self.validate_LanguageTypeEnum(self.Code_Example_Language)    # validate type LanguageTypeEnum
        elif nodeName_ == 'Code':
            Code_ = child_.text
            Code_ = self.gds_validate_string(Code_, node, 'Code')
            self.Code.append(Code_)
        elif nodeName_ == 'Comment':
            Comment_ = child_.text
            Comment_ = self.gds_validate_string(Comment_, node, 'Comment')
            self.Comment.append(Comment_)
        elif nodeName_ == 'Images':
            obj_ = ImagesType.factory()
            obj_.build(child_)
            self.set_Images(obj_)
        elif nodeName_ == 'Block':
            obj_ = Block.factory()
            obj_.build(child_)
            self.set_Block(obj_)
# end class Block


class ImagesType(GeneratedsSuper):
    """The ImagesType specifies a set of images."""
    subclass = None
    superclass = None
    def __init__(self, Image=None):
        if Image is None:
            self.Image = []
        else:
            self.Image = Image
    def factory(*args_, **kwargs_):
        if ImagesType.subclass:
            return ImagesType.subclass(*args_, **kwargs_)
        else:
            return ImagesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image(self): return self.Image
    def set_Image(self, Image): self.Image = Image
    def add_Image(self, value): self.Image.append(value)
    def insert_Image(self, index, value): self.Image[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='ImagesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImagesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ImagesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ImagesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Image_ in self.Image:
            Image_.export(outfile, level, 'Common:', name_='Image', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Image
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImagesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Image=[\n')
        level += 1
        for Image_ in self.Image:
            showIndent(outfile, level)
            outfile.write('model_.ImageType(\n')
            Image_.exportLiteral(outfile, level, name_='ImageType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Image':
            obj_ = ImageType.factory()
            obj_.build(child_)
            self.Image.append(obj_)
# end class ImagesType

class ImageType(GeneratedsSuper):
    """The ImageType specifies an image."""
    subclass = None
    superclass = None
    def __init__(self, Image_Location=None, Image_Title=None):
        self.Image_Location = Image_Location
        self.Image_Title = Image_Title
    def factory(*args_, **kwargs_):
        if ImageType.subclass:
            return ImageType.subclass(*args_, **kwargs_)
        else:
            return ImageType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image_Location(self): return self.Image_Location
    def set_Image_Location(self, Image_Location): self.Image_Location = Image_Location
    def get_Image_Title(self): return self.Image_Title
    def set_Image_Title(self, Image_Title): self.Image_Title = Image_Title
    def export(self, outfile, level, namespace_='Common:', name_='ImageType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImageType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ImageType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ImageType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Image_Location is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sImage_Location>%s</%sImage_Location>%s' % ('Common:', self.gds_format_string(quote_xml(self.Image_Location).encode(ExternalEncoding), input_name='Image_Location'), 'Common:', eol_))
        if self.Image_Title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sImage_Title>%s</%sImage_Title>%s' % ('Common:', self.gds_format_string(quote_xml(self.Image_Title).encode(ExternalEncoding), input_name='Image_Title'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Image_Location is not None or
            self.Image_Title is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImageType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Image_Location is not None:
            showIndent(outfile, level)
            outfile.write('Image_Location=%s,\n' % quote_python(self.Image_Location).encode(ExternalEncoding))
        if self.Image_Title is not None:
            showIndent(outfile, level)
            outfile.write('Image_Title=%s,\n' % quote_python(self.Image_Title).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Image_Location':
            Image_Location_ = child_.text
            Image_Location_ = self.gds_validate_string(Image_Location_, node, 'Image_Location')
            self.Image_Location = Image_Location_
        elif nodeName_ == 'Image_Title':
            Image_Title_ = child_.text
            Image_Title_ = self.gds_validate_string(Image_Title_, node, 'Image_Title')
            self.Image_Title = Image_Title_
# end class ImageType

class ReferenceListType(GeneratedsSuper):
    """The ReferencesListType contains one or more Reference elements, each
    of which provide further reading and insight into the item. This
    should be filled out as appropriate."""
    subclass = None
    superclass = None
    def __init__(self, Reference=None):
        if Reference is None:
            self.Reference = []
        else:
            self.Reference = Reference
    def factory(*args_, **kwargs_):
        if ReferenceListType.subclass:
            return ReferenceListType.subclass(*args_, **kwargs_)
        else:
            return ReferenceListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reference(self): return self.Reference
    def set_Reference(self, Reference): self.Reference = Reference
    def add_Reference(self, value): self.Reference.append(value)
    def insert_Reference(self, index, value): self.Reference[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='ReferenceListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReferenceListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ReferenceListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ReferenceListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Reference_ in self.Reference:
            Reference_.export(outfile, level, 'Common:', name_='Reference', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ReferenceListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Reference=[\n')
        level += 1
        for Reference_ in self.Reference:
            showIndent(outfile, level)
            outfile.write('model_.ReferenceType(\n')
            Reference_.exportLiteral(outfile, level, name_='ReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reference':
            obj_ = ReferenceType.factory()
            obj_.build(child_)
            self.Reference.append(obj_)
# end class ReferenceListType

class ReferenceType(GeneratedsSuper):
    """The ReferenceType is a complex type representing a single reference
    to a source of information. The id attribute is optional and is
    used as a mechanism for citing text in the entry. If an id is
    provided, it is placed between brackets and precedes this
    reference and the matching id should be used inside of the text
    for the entry itself where this reference is applicable. All
    reference ids assigned within an entry must be unique."""
    subclass = None
    superclass = None
    def __init__(self, reference_id=None, Reference_Description=None, Reference_Author=None, Reference_Title=None, Reference_Section=None, Reference_Edition=None, Reference_Publication=None, Reference_Publisher=None, Reference_Date=None, Reference_PubDate=None, Reference_Link=None):
        self.reference_id = _cast(None, reference_id)
        self.Reference_Description = Reference_Description
        if Reference_Author is None:
            self.Reference_Author = []
        else:
            self.Reference_Author = Reference_Author
        self.Reference_Title = Reference_Title
        self.Reference_Section = Reference_Section
        self.Reference_Edition = Reference_Edition
        self.Reference_Publication = Reference_Publication
        self.Reference_Publisher = Reference_Publisher
        self.Reference_Date = Reference_Date
        self.Reference_PubDate = Reference_PubDate
        self.Reference_Link = Reference_Link
    def factory(*args_, **kwargs_):
        if ReferenceType.subclass:
            return ReferenceType.subclass(*args_, **kwargs_)
        else:
            return ReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reference_Description(self): return self.Reference_Description
    def set_Reference_Description(self, Reference_Description): self.Reference_Description = Reference_Description
    def get_Reference_Author(self): return self.Reference_Author
    def set_Reference_Author(self, Reference_Author): self.Reference_Author = Reference_Author
    def add_Reference_Author(self, value): self.Reference_Author.append(value)
    def insert_Reference_Author(self, index, value): self.Reference_Author[index] = value
    def get_Reference_Title(self): return self.Reference_Title
    def set_Reference_Title(self, Reference_Title): self.Reference_Title = Reference_Title
    def get_Reference_Section(self): return self.Reference_Section
    def set_Reference_Section(self, Reference_Section): self.Reference_Section = Reference_Section
    def get_Reference_Edition(self): return self.Reference_Edition
    def set_Reference_Edition(self, Reference_Edition): self.Reference_Edition = Reference_Edition
    def get_Reference_Publication(self): return self.Reference_Publication
    def set_Reference_Publication(self, Reference_Publication): self.Reference_Publication = Reference_Publication
    def get_Reference_Publisher(self): return self.Reference_Publisher
    def set_Reference_Publisher(self, Reference_Publisher): self.Reference_Publisher = Reference_Publisher
    def get_Reference_Date(self): return self.Reference_Date
    def set_Reference_Date(self, Reference_Date): self.Reference_Date = Reference_Date
    def get_Reference_PubDate(self): return self.Reference_PubDate
    def set_Reference_PubDate(self, Reference_PubDate): self.Reference_PubDate = Reference_PubDate
    def get_Reference_Link(self): return self.Reference_Link
    def set_Reference_Link(self, Reference_Link): self.Reference_Link = Reference_Link
    def get_reference_id(self): return self.reference_id
    def set_reference_id(self, reference_id): self.reference_id = reference_id
    def export(self, outfile, level, namespace_='Common:', name_='ReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='ReferenceType'):
        if self.reference_id is not None and 'reference_id' not in already_processed:
            already_processed.append('reference_id')
            outfile.write(' reference_id=%s' % (self.gds_format_string(quote_attrib(self.reference_id).encode(ExternalEncoding), input_name='reference_id'), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='ReferenceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Reference_Description is not None:
            self.Reference_Description.export(outfile, level, 'Common:', name_='Reference_Description', pretty_print=pretty_print)
        for Reference_Author_ in self.Reference_Author:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference_Author>%s</%sReference_Author>%s' % ('Common:', self.gds_format_string(quote_xml(Reference_Author_).encode(ExternalEncoding), input_name='Reference_Author'), 'Common:', eol_))
        if self.Reference_Title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference_Title>%s</%sReference_Title>%s' % ('Common:', self.gds_format_string(quote_xml(self.Reference_Title).encode(ExternalEncoding), input_name='Reference_Title'), 'Common:', eol_))
        if self.Reference_Section is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference_Section>%s</%sReference_Section>%s' % ('Common:', self.gds_format_string(quote_xml(self.Reference_Section).encode(ExternalEncoding), input_name='Reference_Section'), 'Common:', eol_))
        if self.Reference_Edition is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference_Edition>%s</%sReference_Edition>%s' % ('Common:', self.gds_format_string(quote_xml(self.Reference_Edition).encode(ExternalEncoding), input_name='Reference_Edition'), 'Common:', eol_))
        if self.Reference_Publication is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference_Publication>%s</%sReference_Publication>%s' % ('Common:', self.gds_format_string(quote_xml(self.Reference_Publication).encode(ExternalEncoding), input_name='Reference_Publication'), 'Common:', eol_))
        if self.Reference_Publisher is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference_Publisher>%s</%sReference_Publisher>%s' % ('Common:', self.gds_format_string(quote_xml(self.Reference_Publisher).encode(ExternalEncoding), input_name='Reference_Publisher'), 'Common:', eol_))
        if self.Reference_Date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference_Date>%s</%sReference_Date>%s' % ('Common:', self.gds_format_string(quote_xml(self.Reference_Date).encode(ExternalEncoding), input_name='Reference_Date'), 'Common:', eol_))
        if self.Reference_PubDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference_PubDate>%s</%sReference_PubDate>%s' % ('Common:', self.gds_format_string(quote_xml(self.Reference_PubDate).encode(ExternalEncoding), input_name='Reference_PubDate'), 'Common:', eol_))
        if self.Reference_Link is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference_Link>%s</%sReference_Link>%s' % ('Common:', self.gds_format_string(quote_xml(self.Reference_Link).encode(ExternalEncoding), input_name='Reference_Link'), 'Common:', eol_))
    def hasContent_(self):
        if (
            self.Reference_Description is not None or
            self.Reference_Author or
            self.Reference_Title is not None or
            self.Reference_Section is not None or
            self.Reference_Edition is not None or
            self.Reference_Publication is not None or
            self.Reference_Publisher is not None or
            self.Reference_Date is not None or
            self.Reference_PubDate is not None or
            self.Reference_Link is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ReferenceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.reference_id is not None and 'reference_id' not in already_processed:
            already_processed.append('reference_id')
            showIndent(outfile, level)
            outfile.write('reference_id = "%s",\n' % (self.reference_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Reference_Description is not None:
            showIndent(outfile, level)
            outfile.write('Reference_Description=model_.StructuredTextType(\n')
            self.Reference_Description.exportLiteral(outfile, level, name_='Reference_Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Reference_Author=[\n')
        level += 1
        for Reference_Author_ in self.Reference_Author:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Reference_Author_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Reference_Title is not None:
            showIndent(outfile, level)
            outfile.write('Reference_Title=%s,\n' % quote_python(self.Reference_Title).encode(ExternalEncoding))
        if self.Reference_Section is not None:
            showIndent(outfile, level)
            outfile.write('Reference_Section=%s,\n' % quote_python(self.Reference_Section).encode(ExternalEncoding))
        if self.Reference_Edition is not None:
            showIndent(outfile, level)
            outfile.write('Reference_Edition=%s,\n' % quote_python(self.Reference_Edition).encode(ExternalEncoding))
        if self.Reference_Publication is not None:
            showIndent(outfile, level)
            outfile.write('Reference_Publication=%s,\n' % quote_python(self.Reference_Publication).encode(ExternalEncoding))
        if self.Reference_Publisher is not None:
            showIndent(outfile, level)
            outfile.write('Reference_Publisher=%s,\n' % quote_python(self.Reference_Publisher).encode(ExternalEncoding))
        if self.Reference_Date is not None:
            showIndent(outfile, level)
            outfile.write('Reference_Date=%s,\n' % quote_python(self.Reference_Date).encode(ExternalEncoding))
        if self.Reference_PubDate is not None:
            showIndent(outfile, level)
            outfile.write('Reference_PubDate=%s,\n' % quote_python(self.Reference_PubDate).encode(ExternalEncoding))
        if self.Reference_Link is not None:
            showIndent(outfile, level)
            outfile.write('Reference_Link=%s,\n' % quote_python(self.Reference_Link).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('reference_id', node)
        if value is not None and 'reference_id' not in already_processed:
            already_processed.append('reference_id')
            self.reference_id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reference_Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Reference_Description(obj_)
        elif nodeName_ == 'Reference_Author':
            Reference_Author_ = child_.text
            Reference_Author_ = self.gds_validate_string(Reference_Author_, node, 'Reference_Author')
            self.Reference_Author.append(Reference_Author_)
        elif nodeName_ == 'Reference_Title':
            Reference_Title_ = child_.text
            Reference_Title_ = self.gds_validate_string(Reference_Title_, node, 'Reference_Title')
            self.Reference_Title = Reference_Title_
        elif nodeName_ == 'Reference_Section':
            Reference_Section_ = child_.text
            Reference_Section_ = self.gds_validate_string(Reference_Section_, node, 'Reference_Section')
            self.Reference_Section = Reference_Section_
        elif nodeName_ == 'Reference_Edition':
            Reference_Edition_ = child_.text
            Reference_Edition_ = self.gds_validate_string(Reference_Edition_, node, 'Reference_Edition')
            self.Reference_Edition = Reference_Edition_
        elif nodeName_ == 'Reference_Publication':
            Reference_Publication_ = child_.text
            Reference_Publication_ = self.gds_validate_string(Reference_Publication_, node, 'Reference_Publication')
            self.Reference_Publication = Reference_Publication_
        elif nodeName_ == 'Reference_Publisher':
            Reference_Publisher_ = child_.text
            Reference_Publisher_ = self.gds_validate_string(Reference_Publisher_, node, 'Reference_Publisher')
            self.Reference_Publisher = Reference_Publisher_
        elif nodeName_ == 'Reference_Date':
            Reference_Date_ = child_.text
            Reference_Date_ = self.gds_validate_string(Reference_Date_, node, 'Reference_Date')
            self.Reference_Date = Reference_Date_
        elif nodeName_ == 'Reference_PubDate':
            Reference_PubDate_ = child_.text
            Reference_PubDate_ = self.gds_validate_string(Reference_PubDate_, node, 'Reference_PubDate')
            self.Reference_PubDate = Reference_PubDate_
        elif nodeName_ == 'Reference_Link':
            Reference_Link_ = child_.text
            Reference_Link_ = self.gds_validate_string(Reference_Link_, node, 'Reference_Link')
            self.Reference_Link = Reference_Link_
# end class ReferenceType

class DataSegmentType(GeneratedsSuper):
    """The DataSegmentType is intended to provide a relatively abstract way
    of characterizing data segments that may be
    written/read/transmitted or otherwise utilized in actions or
    behaviors. The id attribute specifies a unique id for this data
    segment."""
    subclass = None
    superclass = None
    def __init__(self, id=None, Data_Format=None, Data_Size=None, Data_Segment=None, Offset=None, Search_Distance=None, Search_Within=None):
        self.id = _cast(None, id)
        self.Data_Format = Data_Format
        self.Data_Size = Data_Size
        self.Data_Segment = Data_Segment
        self.Offset = Offset
        self.Search_Distance = Search_Distance
        self.Search_Within = Search_Within
    def factory(*args_, **kwargs_):
        if DataSegmentType.subclass:
            return DataSegmentType.subclass(*args_, **kwargs_)
        else:
            return DataSegmentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Data_Format(self): return self.Data_Format
    def set_Data_Format(self, Data_Format): self.Data_Format = Data_Format
    def validate_DataFormatEnum(self, value):
        # Validate type DataFormatEnum, a restriction on xs:string.
        pass
    def get_Data_Size(self): return self.Data_Size
    def set_Data_Size(self, Data_Size): self.Data_Size = Data_Size
    def get_Data_Segment(self): return self.Data_Segment
    def set_Data_Segment(self, Data_Segment): self.Data_Segment = Data_Segment
    def validate_StringObjectAttributeType(self, value):
        # Validate type StringObjectAttributeType, a restriction on xs:string.
        pass
    def get_Offset(self): return self.Offset
    def set_Offset(self, Offset): self.Offset = Offset
    def validate_IntegerObjectAttributeType(self, value):
        # Validate type IntegerObjectAttributeType, a restriction on None.
        pass
    def get_Search_Distance(self): return self.Search_Distance
    def set_Search_Distance(self, Search_Distance): self.Search_Distance = Search_Distance
    def get_Search_Within(self): return self.Search_Within
    def set_Search_Within(self, Search_Within): self.Search_Within = Search_Within
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='Common:', name_='DataSegmentType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataSegmentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DataSegmentType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DataSegmentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Data_Format is not None:
            self.Data_Format.export(outfile, level, 'Common:', name_='Data_Format', pretty_print=pretty_print)
        if self.Data_Size is not None:
            self.Data_Size.export(outfile, level, 'Common:', name_='Data_Size', pretty_print=pretty_print)
        if self.Data_Segment is not None:
            self.Data_Segment.export(outfile, level, 'Common:', name_='Data_Segment', pretty_print=pretty_print)
        if self.Offset is not None:
            self.Offset.export(outfile, level, 'Common:', name_='Offset', pretty_print=pretty_print)
        if self.Search_Distance is not None:
            self.Search_Distance.export(outfile, level, 'Common:', name_='Search_Distance', pretty_print=pretty_print)
        if self.Search_Within is not None:
            self.Search_Within.export(outfile, level, 'Common:', name_='Search_Within', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Data_Format is not None or
            self.Data_Size is not None or
            self.Data_Segment is not None or
            self.Offset is not None or
            self.Search_Distance is not None or
            self.Search_Within is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DataSegmentType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Data_Format is not None:
            showIndent(outfile, level)
            outfile.write('Data_Format=%s,\n' % quote_python(self.Data_Format).encode(ExternalEncoding))
        if self.Data_Size is not None:
            showIndent(outfile, level)
            outfile.write('Data_Size=model_.DataSizeType(\n')
            self.Data_Size.exportLiteral(outfile, level, name_='Data_Size')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Segment is not None:
            showIndent(outfile, level)
            outfile.write('Data_Segment=%s,\n' % quote_python(self.Data_Segment).encode(ExternalEncoding))
        if self.Offset is not None:
            showIndent(outfile, level)
            outfile.write('Offset=model_.IntegerObjectAttributeType(\n')
            self.Offset.exportLiteral(outfile, level, name_='Offset')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Search_Distance is not None:
            showIndent(outfile, level)
            outfile.write('Search_Distance=model_.IntegerObjectAttributeType(\n')
            self.Search_Distance.exportLiteral(outfile, level, name_='Search_Distance')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Search_Within is not None:
            showIndent(outfile, level)
            outfile.write('Search_Within=model_.IntegerObjectAttributeType(\n')
            self.Search_Within.exportLiteral(outfile, level, name_='Search_Within')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Data_Format':
            obj_ = DataFormatEnum.factory()
            obj_.build(child_)
            self.set_Data_Format(obj_)
        elif nodeName_ == 'Data_Size':
            obj_ = DataSizeType.factory()
            obj_.build(child_)
            self.set_Data_Size(obj_)
        elif nodeName_ == 'Data_Segment':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Data_Segment(obj_)
        elif nodeName_ == 'Offset':
            obj_ = IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Offset(obj_)
        elif nodeName_ == 'Search_Distance':
            obj_ = IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Search_Distance(obj_)
        elif nodeName_ == 'Search_Within':
            obj_ = IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Search_Within(obj_)
# end class DataSegmentType

class DataSizeType(StringObjectAttributeType):
    """The DataSizeType specifies the size of the data segment.This
    attribute represents the Units used in the object size element.
    Possible values are: Bytes, Kilobytes, Megabytes."""
    subclass = None
    superclass = StringObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, units=None, valueOf_=None):
        super(DataSizeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if DataSizeType.subclass:
            return DataSizeType.subclass(*args_, **kwargs_)
        else:
            return DataSizeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='DataSizeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataSizeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DataSizeType'):
        super(DataSizeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DataSizeType')
        if self.units is not None and 'units' not in already_processed:
            already_processed.append('units')
            outfile.write(' units=%s' % (quote_attrib(self.units), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DataSizeType', fromsubclass_=False, pretty_print=True):
        super(DataSizeType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(DataSizeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DataSizeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.units is not None and 'units' not in already_processed:
            already_processed.append('units')
            showIndent(outfile, level)
            outfile.write('units = %s,\n' % (self.units,))
        super(DataSizeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DataSizeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.append('units')
            self.units = value
        super(DataSizeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DataSizeType

class CPESpecificationType(GeneratedsSuper):
    """CPESpecificationType is a modularized data type intended for
    providing a consistent approach to uniquely specifying the
    identity of a specific platform using the Common Platform
    Enumeration (CPE) naming standard. http://cpe.mitre.org/"""
    subclass = None
    superclass = None
    def __init__(self, CPE_Name=None, Title=None, Meta_Item_Metadata=None):
        self.CPE_Name = CPE_Name
        self.Title = Title
        self.Meta_Item_Metadata = Meta_Item_Metadata
    def factory(*args_, **kwargs_):
        if CPESpecificationType.subclass:
            return CPESpecificationType.subclass(*args_, **kwargs_)
        else:
            return CPESpecificationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CPE_Name(self): return self.CPE_Name
    def set_CPE_Name(self, CPE_Name): self.CPE_Name = CPE_Name
    def get_Title(self): return self.Title
    def set_Title(self, Title): self.Title = Title
    def get_Meta_Item_Metadata(self): return self.Meta_Item_Metadata
    def set_Meta_Item_Metadata(self, Meta_Item_Metadata): self.Meta_Item_Metadata = Meta_Item_Metadata
    def export(self, outfile, level, namespace_='Common:', name_='CPESpecificationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CPESpecificationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='CPESpecificationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='CPESpecificationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CPE_Name is not None:
            self.CPE_Name.export(outfile, level, 'Common:', name_='CPE_Name', pretty_print=pretty_print)
        if self.Title is not None:
            self.Title.export(outfile, level, 'Common:', name_='Title', pretty_print=pretty_print)
        if self.Meta_Item_Metadata is not None:
            self.Meta_Item_Metadata.export(outfile, level, 'Common:', name_='Meta_Item_Metadata', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.CPE_Name is not None or
            self.Title is not None or
            self.Meta_Item_Metadata is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CPESpecificationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.CPE_Name is not None:
            showIndent(outfile, level)
            outfile.write('CPE_Name=model_.CPENameType(\n')
            self.CPE_Name.exportLiteral(outfile, level, name_='CPE_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Title is not None:
            showIndent(outfile, level)
            outfile.write('Title=model_.CPETitleType(\n')
            self.Title.exportLiteral(outfile, level, name_='Title')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Meta_Item_Metadata is not None:
            showIndent(outfile, level)
            outfile.write('Meta_Item_Metadata=model_.MetaItemMetadataType(\n')
            self.Meta_Item_Metadata.exportLiteral(outfile, level, name_='Meta_Item_Metadata')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CPE_Name':
            obj_ = CPENameType.factory()
            obj_.build(child_)
            self.set_CPE_Name(obj_)
        elif nodeName_ == 'Title':
            obj_ = CPETitleType.factory()
            obj_.build(child_)
            self.set_Title(obj_)
        elif nodeName_ == 'Meta_Item_Metadata':
            obj_ = MetaItemMetadataType.factory()
            obj_.build(child_)
            self.set_Meta_Item_Metadata(obj_)
# end class CPESpecificationType

class CPENameType(StringObjectAttributeType):
    """The CPENameType contains the CPE Name value for the relevant
    platform.The xmlns_value attribute contains the XML namespace
    descriptor for the CPE namespace relevant to this CPE Name use."""
    subclass = None
    superclass = StringObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, xmlns_value=None):
        super(CPENameType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, )
        self.xmlns_value = _cast(None, xmlns_value)
        pass
    def factory(*args_, **kwargs_):
        if CPENameType.subclass:
            return CPENameType.subclass(*args_, **kwargs_)
        else:
            return CPENameType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_xmlns_value(self): return self.xmlns_value
    def set_xmlns_value(self, xmlns_value): self.xmlns_value = xmlns_value
    def export(self, outfile, level, namespace_='Common:', name_='CPENameType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CPENameType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='CPENameType'):
        super(CPENameType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CPENameType')
        if self.xmlns_value is not None and 'xmlns_value' not in already_processed:
            already_processed.append('xmlns_value')
            outfile.write(' xmlns_value=%s' % (self.gds_format_string(quote_attrib(self.xmlns_value).encode(ExternalEncoding), input_name='xmlns_value'), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='CPENameType', fromsubclass_=False, pretty_print=True):
        super(CPENameType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            super(CPENameType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CPENameType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.xmlns_value is not None and 'xmlns_value' not in already_processed:
            already_processed.append('xmlns_value')
            showIndent(outfile, level)
            outfile.write('xmlns_value = "%s",\n' % (self.xmlns_value,))
        super(CPENameType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CPENameType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xmlns_value', node)
        if value is not None and 'xmlns_value' not in already_processed:
            already_processed.append('xmlns_value')
            self.xmlns_value = value
        super(CPENameType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(CPENameType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class CPENameType

class MetaItemMetadataType(GeneratedsSuper):
    """The MetaItemMetadataType element aggregates the descriptive metadata
    for a CPE Name instance."""
    subclass = None
    superclass = None
    def __init__(self, Modification_Date=None, NVD_ID=None, Status=None, XMLNS_Meta=None):
        self.Modification_Date = Modification_Date
        self.NVD_ID = NVD_ID
        self.Status = Status
        self.XMLNS_Meta = XMLNS_Meta
    def factory(*args_, **kwargs_):
        if MetaItemMetadataType.subclass:
            return MetaItemMetadataType.subclass(*args_, **kwargs_)
        else:
            return MetaItemMetadataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Modification_Date(self): return self.Modification_Date
    def set_Modification_Date(self, Modification_Date): self.Modification_Date = Modification_Date
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_NVD_ID(self): return self.NVD_ID
    def set_NVD_ID(self, NVD_ID): self.NVD_ID = NVD_ID
    def validate_UnsignedIntegerObjectAttributeType(self, value):
        # Validate type UnsignedIntegerObjectAttributeType, a restriction on None.
        pass
    def get_Status(self): return self.Status
    def set_Status(self, Status): self.Status = Status
    def validate_StringObjectAttributeType(self, value):
        # Validate type StringObjectAttributeType, a restriction on xs:string.
        pass
    def get_XMLNS_Meta(self): return self.XMLNS_Meta
    def set_XMLNS_Meta(self, XMLNS_Meta): self.XMLNS_Meta = XMLNS_Meta
    def export(self, outfile, level, namespace_='Common:', name_='MetaItemMetadataType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetaItemMetadataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='MetaItemMetadataType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='MetaItemMetadataType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Modification_Date is not None:
            self.Modification_Date.export(outfile, level, 'Common:', name_='Modification_Date', pretty_print=pretty_print)
        if self.NVD_ID is not None:
            self.NVD_ID.export(outfile, level, 'Common:', name_='NVD_ID', pretty_print=pretty_print)
        if self.Status is not None:
            self.Status.export(outfile, level, 'Common:', name_='Status', pretty_print=pretty_print)
        if self.XMLNS_Meta is not None:
            self.XMLNS_Meta.export(outfile, level, 'Common:', name_='XMLNS_Meta', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Modification_Date is not None or
            self.NVD_ID is not None or
            self.Status is not None or
            self.XMLNS_Meta is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MetaItemMetadataType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Modification_Date is not None:
            showIndent(outfile, level)
            outfile.write('Modification_Date=model_.DateTimeObjectAttributeType(\n')
            self.Modification_Date.exportLiteral(outfile, level, name_='Modification_Date')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.NVD_ID is not None:
            showIndent(outfile, level)
            outfile.write('NVD_ID=model_.UnsignedIntegerObjectAttributeType(\n')
            self.NVD_ID.exportLiteral(outfile, level, name_='NVD_ID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Status is not None:
            showIndent(outfile, level)
            outfile.write('Status=%s,\n' % quote_python(self.Status).encode(ExternalEncoding))
        if self.XMLNS_Meta is not None:
            showIndent(outfile, level)
            outfile.write('XMLNS_Meta=%s,\n' % quote_python(self.XMLNS_Meta).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Modification_Date':
            obj_ = DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Modification_Date(obj_)
        elif nodeName_ == 'NVD_ID':
            obj_ = UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_NVD_ID(obj_)
        elif nodeName_ == 'Status':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Status(obj_)
        elif nodeName_ == 'XMLNS_Meta':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_XMLNS_Meta(obj_)
# end class MetaItemMetadataType

class CPETitleType(StringObjectAttributeType):
    """The CPETitleType contains the plain language descriptive title of
    the relevant platform.This field holds a shortform descriptor
    for the language that the Title field is expressed in.
    Attempting to install the relevant ISO 2- and 3-letter codes as
    the enumerated possible values is probably never going to be a
    realistic possibility. See RFC 3066 at
    http://www.ietf.org/rfc/rfc3066.txt and the IANA registry at
    http://www.iana.org/assignments/lang-tag-apps.htm for further
    information. The union allows for the 'un-declaration' of
    xml:lang with the empty string."""
    subclass = None
    superclass = StringObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, lang=None):
        super(CPETitleType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, )
        self.lang = _cast(None, lang)
        pass
    def factory(*args_, **kwargs_):
        if CPETitleType.subclass:
            return CPETitleType.subclass(*args_, **kwargs_)
        else:
            return CPETitleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def export(self, outfile, level, namespace_='Common:', name_='CPETitleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CPETitleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='CPETitleType'):
        super(CPETitleType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CPETitleType')
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.append('lang')
            outfile.write(' lang=%s' % (self.gds_format_string(quote_attrib(self.lang).encode(ExternalEncoding), input_name='lang'), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='CPETitleType', fromsubclass_=False, pretty_print=True):
        super(CPETitleType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            super(CPETitleType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CPETitleType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.append('lang')
            showIndent(outfile, level)
            outfile.write('lang = "%s",\n' % (self.lang,))
        super(CPETitleType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CPETitleType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.append('lang')
            self.lang = value
        super(CPETitleType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(CPETitleType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class CPETitleType

class MetadataType(GeneratedsSuper):
    """The MetadataType is intended as mechanism to capture any non-
    context-specific metadataThis field specifies the type of name
    of a single metadata field."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, Value=None, SubDatum=None):
        self.type_ = _cast(None, type_)
        self.Value = Value
        if SubDatum is None:
            self.SubDatum = []
        else:
            self.SubDatum = SubDatum
    def factory(*args_, **kwargs_):
        if MetadataType.subclass:
            return MetadataType.subclass(*args_, **kwargs_)
        else:
            return MetadataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_SubDatum(self): return self.SubDatum
    def set_SubDatum(self, SubDatum): self.SubDatum = SubDatum
    def add_SubDatum(self, value): self.SubDatum.append(value)
    def insert_SubDatum(self, index, value): self.SubDatum[index] = value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='Common:', name_='MetadataType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='MetadataType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='MetadataType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            #self.Value.export(outfile, level, 'Common:', name_='Value', pretty_print=pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % ('Common:', self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), 'Common:', eol_))
        for SubDatum_ in self.SubDatum:
            SubDatum_.export(outfile, level, 'Common:', name_='SubDatum', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Value is not None or
            self.SubDatum
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MetadataType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('SubDatum=[\n')
        level += 1
        for SubDatum_ in self.SubDatum:
            showIndent(outfile, level)
            outfile.write('model_.MetadataType(\n')
            SubDatum_.exportLiteral(outfile, level, name_='MetadataType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        elif nodeName_ == 'SubDatum':
            obj_ = MetadataType.factory()
            obj_.build(child_)
            self.SubDatum.append(obj_)
# end class MetadataType

class EnvironmentVariableListType(GeneratedsSuper):
    """The EnvironmentVariableListType type is used for representing a list
    of environment variables."""
    subclass = None
    superclass = None
    def __init__(self, Environment_Variable=None):
        if Environment_Variable is None:
            self.Environment_Variable = []
        else:
            self.Environment_Variable = Environment_Variable
    def factory(*args_, **kwargs_):
        if EnvironmentVariableListType.subclass:
            return EnvironmentVariableListType.subclass(*args_, **kwargs_)
        else:
            return EnvironmentVariableListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Environment_Variable(self): return self.Environment_Variable
    def set_Environment_Variable(self, Environment_Variable): self.Environment_Variable = Environment_Variable
    def add_Environment_Variable(self, value): self.Environment_Variable.append(value)
    def insert_Environment_Variable(self, index, value): self.Environment_Variable[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='EnvironmentVariableListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EnvironmentVariableListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='EnvironmentVariableListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='EnvironmentVariableListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Environment_Variable_ in self.Environment_Variable:
            Environment_Variable_.export(outfile, level, 'Common:', name_='Environment_Variable', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Environment_Variable
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EnvironmentVariableListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Environment_Variable=[\n')
        level += 1
        for Environment_Variable_ in self.Environment_Variable:
            showIndent(outfile, level)
            outfile.write('model_.EnvironmentVariableType(\n')
            Environment_Variable_.exportLiteral(outfile, level, name_='EnvironmentVariableType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Environment_Variable':
            obj_ = EnvironmentVariableType.factory()
            obj_.build(child_)
            self.Environment_Variable.append(obj_)
# end class EnvironmentVariableListType

class EnvironmentVariableType(GeneratedsSuper):
    """The EnvironmentVariableType type is used for representing
    environment variables using a name/value pair."""
    subclass = None
    superclass = None
    def __init__(self, Name=None, Value=None):
        self.Name = Name
        self.Value = Value
    def factory(*args_, **kwargs_):
        if EnvironmentVariableType.subclass:
            return EnvironmentVariableType.subclass(*args_, **kwargs_)
        else:
            return EnvironmentVariableType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type StringObjectAttributeType, a restriction on xs:string.
        pass
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def export(self, outfile, level, namespace_='Common:', name_='EnvironmentVariableType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EnvironmentVariableType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='EnvironmentVariableType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='EnvironmentVariableType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            self.Name.export(outfile, level, 'Common:', name_='Name', pretty_print=pretty_print)
        if self.Value is not None:
            self.Value.export(outfile, level, 'Common:', name_='Value', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EnvironmentVariableType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Value':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Value(obj_)
# end class EnvironmentVariableType

class DigitalSignaturesType(GeneratedsSuper):
    """The DigitalSignaturesType is used for representing a list of digital
    signatures."""
    subclass = None
    superclass = None
    def __init__(self, Digital_Signature=None):
        if Digital_Signature is None:
            self.Digital_Signature = []
        else:
            self.Digital_Signature = Digital_Signature
    def factory(*args_, **kwargs_):
        if DigitalSignaturesType.subclass:
            return DigitalSignaturesType.subclass(*args_, **kwargs_)
        else:
            return DigitalSignaturesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Digital_Signature(self): return self.Digital_Signature
    def set_Digital_Signature(self, Digital_Signature): self.Digital_Signature = Digital_Signature
    def add_Digital_Signature(self, value): self.Digital_Signature.append(value)
    def insert_Digital_Signature(self, index, value): self.Digital_Signature[index] = value
    def export(self, outfile, level, namespace_='Common:', name_='DigitalSignaturesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DigitalSignaturesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DigitalSignaturesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DigitalSignaturesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Digital_Signature_ in self.Digital_Signature:
            Digital_Signature_.export(outfile, level, 'Common:', name_='Digital_Signature', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Digital_Signature
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DigitalSignaturesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Digital_Signature=[\n')
        level += 1
        for Digital_Signature_ in self.Digital_Signature:
            showIndent(outfile, level)
            outfile.write('model_.DigitalSignatureInfoType(\n')
            Digital_Signature_.exportLiteral(outfile, level, name_='DigitalSignatureInfoType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Digital_Signature':
            obj_ = DigitalSignatureInfoType.factory()
            obj_.build(child_)
            self.Digital_Signature.append(obj_)
# end class DigitalSignaturesType

class DigitalSignatureInfoType(GeneratedsSuper):
    """The DigitalSignatureInfoType type is used as a way to represent some
    of the basic information about a digital signature.Specifies
    whether the digital signature exists.Specifies if the digital
    signature is verified."""
    subclass = None
    superclass = None
    def __init__(self, signature_verified=None, signature_exists=None, Certificate_Issuer=None, Certificate_Subject=None, Signature_Description=None):
        self.signature_verified = _cast(bool, signature_verified)
        self.signature_exists = _cast(bool, signature_exists)
        self.Certificate_Issuer = Certificate_Issuer
        self.Certificate_Subject = Certificate_Subject
        self.Signature_Description = Signature_Description
    def factory(*args_, **kwargs_):
        if DigitalSignatureInfoType.subclass:
            return DigitalSignatureInfoType.subclass(*args_, **kwargs_)
        else:
            return DigitalSignatureInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Certificate_Issuer(self): return self.Certificate_Issuer
    def set_Certificate_Issuer(self, Certificate_Issuer): self.Certificate_Issuer = Certificate_Issuer
    def validate_StringObjectAttributeType(self, value):
        # Validate type StringObjectAttributeType, a restriction on xs:string.
        pass
    def get_Certificate_Subject(self): return self.Certificate_Subject
    def set_Certificate_Subject(self, Certificate_Subject): self.Certificate_Subject = Certificate_Subject
    def get_Signature_Description(self): return self.Signature_Description
    def set_Signature_Description(self, Signature_Description): self.Signature_Description = Signature_Description
    def get_signature_verified(self): return self.signature_verified
    def set_signature_verified(self, signature_verified): self.signature_verified = signature_verified
    def get_signature_exists(self): return self.signature_exists
    def set_signature_exists(self, signature_exists): self.signature_exists = signature_exists
    def export(self, outfile, level, namespace_='Common:', name_='DigitalSignatureInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DigitalSignatureInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='DigitalSignatureInfoType'):
        if self.signature_verified is not None and 'signature_verified' not in already_processed:
            already_processed.append('signature_verified')
            outfile.write(' signature_verified="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.signature_verified)), input_name='signature_verified'))
        if self.signature_exists is not None and 'signature_exists' not in already_processed:
            already_processed.append('signature_exists')
            outfile.write(' signature_exists="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.signature_exists)), input_name='signature_exists'))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='DigitalSignatureInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Certificate_Issuer is not None:
            self.Certificate_Issuer.export(outfile, level, 'Common:', name_='Certificate_Issuer', pretty_print=pretty_print)
        if self.Certificate_Subject is not None:
            self.Certificate_Subject.export(outfile, level, 'Common:', name_='Certificate_Subject', pretty_print=pretty_print)
        if self.Signature_Description is not None:
            self.Signature_Description.export(outfile, level, 'Common:', name_='Signature_Description', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Certificate_Issuer is not None or
            self.Certificate_Subject is not None or
            self.Signature_Description is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DigitalSignatureInfoType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.signature_verified is not None and 'signature_verified' not in already_processed:
            already_processed.append('signature_verified')
            showIndent(outfile, level)
            outfile.write('signature_verified = %s,\n' % (self.signature_verified,))
        if self.signature_exists is not None and 'signature_exists' not in already_processed:
            already_processed.append('signature_exists')
            showIndent(outfile, level)
            outfile.write('signature_exists = %s,\n' % (self.signature_exists,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Certificate_Issuer is not None:
            showIndent(outfile, level)
            outfile.write('Certificate_Issuer=%s,\n' % quote_python(self.Certificate_Issuer).encode(ExternalEncoding))
        if self.Certificate_Subject is not None:
            showIndent(outfile, level)
            outfile.write('Certificate_Subject=%s,\n' % quote_python(self.Certificate_Subject).encode(ExternalEncoding))
        if self.Signature_Description is not None:
            showIndent(outfile, level)
            outfile.write('Signature_Description=%s,\n' % quote_python(self.Signature_Description).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('signature_verified', node)
        if value is not None and 'signature_verified' not in already_processed:
            already_processed.append('signature_verified')
            if value in ('true', '1'):
                self.signature_verified = True
            elif value in ('false', '0'):
                self.signature_verified = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('signature_exists', node)
        if value is not None and 'signature_exists' not in already_processed:
            already_processed.append('signature_exists')
            if value in ('true', '1'):
                self.signature_exists = True
            elif value in ('false', '0'):
                self.signature_exists = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Certificate_Issuer':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Certificate_Issuer(obj_)
        elif nodeName_ == 'Certificate_Subject':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Certificate_Subject(obj_)
        elif nodeName_ == 'Signature_Description':
            obj_ = StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Signature_Description(obj_)
# end class DigitalSignatureInfoType

class SIDType(BaseObjectAttributeType):
    """SIDType specifies Windows Security ID (SID) types via a union of the
    SIDTypeEnum type and the atomic xs:string type. Its base type is
    the CybOX Core BaseObjectAttributeType, for permitting complex
    (i.e. regular-expression based) specifications.This attribute is
    optional and specifies the expected type for the value of the
    specified element."""
    subclass = None
    superclass = BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(SIDType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if SIDType.subclass:
            return SIDType.subclass(*args_, **kwargs_)
        else:
            return SIDType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='Common:', name_='SIDType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SIDType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='Common:', name_='SIDType'):
        super(SIDType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SIDType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='Common:', name_='SIDType', fromsubclass_=False, pretty_print=True):
        super(SIDType, self).exportChildren(outfile, level, 'Common:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(SIDType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SIDType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(SIDType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SIDType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(SIDType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SIDType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'MeasureSourceType'
        rootClass = MeasureSourceType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'MeasureSourceType'
        rootClass = MeasureSourceType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="MeasureSourceType",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'MeasureSourceType'
        rootClass = MeasureSourceType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from common_types import *\n\n')
    sys.stdout.write('import common_types as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "Block"
    "MeasureSourceType",
    "ContributorType",
    "DateRangeType",
    "PersonnelType",
    "TimeType",
    "ToolSpecificDataType",
    "ToolsInformationType",
    "ToolInformationType",
    "ToolConfigurationType",
    "ConfigurationSettingsType",
    "ConfigurationSettingType",
    "DependenciesType",
    "DependencyType",
    "UsageContextAssumptionsType",
    "InternationalizationSettingsType",
    "InternalStringsType",
    "BuildInformationType",
    "BuildUtilityType",
    "CompilersType",
    "CompilerType",
    "CompilerInformalDescriptionType",
    "BuildConfigurationType",
    "LibrariesType",
    "LibraryType",
    "ExecutionEnvironmentType",
    "ErrorsType",
    "ErrorType",
    "ErrorInstancesType",
    "DefinedObjectType",
    "BaseObjectAttributeType",
    "IntegerObjectAttributeType",
    "StringObjectAttributeType",
    "NameObjectAttributeType",
    "DateObjectAttributeType",
    "DateTimeObjectAttributeType",
    "FloatObjectAttributeType",
    "DoubleObjectAttributeType",
    "UnsignedLongObjectAttributeType",
    "UnsignedIntegerObjectAttributeType",
    "PositiveIntegerObjectAttributeType",
    "HexBinaryObjectAttributeType",
    "LongObjectAttributeType",
    "NonNegativeIntegerObjectAttributeType",
    "AnyURIObjectAttributeType",
    "DurationObjectAttributeType",
    "TimeObjectAttributeType",
    "Base64BinaryObjectAttributeType",
    "ExtractedFeaturesType",
    "ExtractedStringsType",
    "ExtractedStringType",
    "ImportsType",
    "FunctionsType",
    "CodeSnippetsType",
    "ByteRunsType",
    "ByteRunType",
    "HashListType",
    "HashValueType",
    "SimpleHashValueType",
    "FuzzyHashValueType",
    "FuzzyHashStructureType",
    "FuzzyHashBlockType",
    "HashSegmentsType",
    "HashSegmentType",
    "HashType",
    "HashNameType",
    "StructuredTextType",
    "ImagesType",
    "ImageType",
    "ReferenceListType",
    "ReferenceType",
    "DataSegmentType",
    "DataSizeType",
    "CPESpecificationType",
    "CPENameType",
    "MetaItemMetadataType",
    "CPETitleType",
    "MetadataType",
    "EnvironmentVariableListType",
    "EnvironmentVariableType",
    "DigitalSignaturesType",
    "DigitalSignatureInfoType",
    "SIDType"
    ]

import system_object_1_3
import process_object_1_3
import code_object_1_1
import user_account_object_1_2
