#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:02:44 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import address_object_1_2
import port_object_1_3
import http_session_object_1_0
import dns_query_object_1_0

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class Layer7ConnectionsType(GeneratedsSuper):
    """The Layer7ConnectionsType specifies the different types of
    application (layer 7 in the OSI model) connections that may be
    initiated as part of the network connection."""
    subclass = None
    superclass = None
    def __init__(self, HTTP_Session=None, DNS_Query=None):
        self.HTTP_Session = HTTP_Session
        if DNS_Query is None:
            self.DNS_Query = []
        else:
            self.DNS_Query = DNS_Query
    def factory(*args_, **kwargs_):
        if Layer7ConnectionsType.subclass:
            return Layer7ConnectionsType.subclass(*args_, **kwargs_)
        else:
            return Layer7ConnectionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_HTTP_Session(self): return self.HTTP_Session
    def set_HTTP_Session(self, HTTP_Session): self.HTTP_Session = HTTP_Session
    def get_DNS_Query(self): return self.DNS_Query
    def set_DNS_Query(self, DNS_Query): self.DNS_Query = DNS_Query
    def add_DNS_Query(self, value): self.DNS_Query.append(value)
    def insert_DNS_Query(self, index, value): self.DNS_Query[index] = value
    def export(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer7ConnectionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Layer7ConnectionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='NetworkConnectionObj:', name_='Layer7ConnectionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer7ConnectionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.HTTP_Session is not None:
            self.HTTP_Session.export(outfile, level, 'NetworkConnectionObj:', name_='HTTP_Session', pretty_print=pretty_print)
        for DNS_Query_ in self.DNS_Query:
            self.DNS_Query.export(outfile, level, 'NetworkConnectionObj:', name_='DNS_Query', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.HTTP_Session is not None or
            self.DNS_Query
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Layer7ConnectionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.HTTP_Session is not None:
            showIndent(outfile, level)
            outfile.write('HTTP_Session=model_.http_session_object_1_0.HTTPSessionObjectType(\n')
            self.HTTP_Session.exportLiteral(outfile, level, name_='HTTP_Session')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('DNS_Query=[\n')
        level += 1
        for DNS_Query_ in self.DNS_Query:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(DNS_Query_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'HTTP_Session':
            obj_ = http_session_object_1_0.HTTPSessionObjectType.factory()
            obj_.build(child_)
            self.set_HTTP_Session(obj_)
        elif nodeName_ == 'DNS_Query':
            obj_ = DNSQueryType.factory()
            obj_.build(child_)
            self.DNS_Query.append(obj_)
# end class Layer7ConnectionsType

class NetworkConnectionType(cybox_common_types_1_0.DefinedObjectType):
    """The NetworkConnectionType is intended as a way of characterizing
    local or remote (i.e. Internet) network connections.The tls_used
    attribute specifies whether or not Transport Layer Security
    (TLS) is used in the network connection."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, tls_used=None, Layer3_Protocol=None, Layer4_Protocol=None, Layer7_Protocol=None, Local_IP_Address=None, Local_Port=None, Remote_IP_Address=None, Remote_Port=None, Layer7_Connections=None):
        super(NetworkConnectionType, self).__init__(object_reference, )
        self.tls_used = _cast(bool, tls_used)
        self.Layer3_Protocol = Layer3_Protocol
        self.Layer4_Protocol = Layer4_Protocol
        self.Layer7_Protocol = Layer7_Protocol
        self.Local_IP_Address = Local_IP_Address
        self.Local_Port = Local_Port
        self.Remote_IP_Address = Remote_IP_Address
        self.Remote_Port = Remote_Port
        self.Layer7_Connections = Layer7_Connections
    def factory(*args_, **kwargs_):
        if NetworkConnectionType.subclass:
            return NetworkConnectionType.subclass(*args_, **kwargs_)
        else:
            return NetworkConnectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Layer3_Protocol(self): return self.Layer3_Protocol
    def set_Layer3_Protocol(self, Layer3_Protocol): self.Layer3_Protocol = Layer3_Protocol
    def validate_Layer3ProtocolType(self, value):
        # Validate type Layer3ProtocolType, a restriction on None.
        pass
    def get_Layer4_Protocol(self): return self.Layer4_Protocol
    def set_Layer4_Protocol(self, Layer4_Protocol): self.Layer4_Protocol = Layer4_Protocol
    def validate_Layer4ProtocolType(self, value):
        # Validate type Layer4ProtocolType, a restriction on None.
        pass
    def get_Layer7_Protocol(self): return self.Layer7_Protocol
    def set_Layer7_Protocol(self, Layer7_Protocol): self.Layer7_Protocol = Layer7_Protocol
    def validate_Layer7ProtocolType(self, value):
        # Validate type Layer7ProtocolType, a restriction on None.
        pass
    def get_Local_IP_Address(self): return self.Local_IP_Address
    def set_Local_IP_Address(self, Local_IP_Address): self.Local_IP_Address = Local_IP_Address
    def get_Local_Port(self): return self.Local_Port
    def set_Local_Port(self, Local_Port): self.Local_Port = Local_Port
    def get_Remote_IP_Address(self): return self.Remote_IP_Address
    def set_Remote_IP_Address(self, Remote_IP_Address): self.Remote_IP_Address = Remote_IP_Address
    def get_Remote_Port(self): return self.Remote_Port
    def set_Remote_Port(self, Remote_Port): self.Remote_Port = Remote_Port
    def get_Layer7_Connections(self): return self.Layer7_Connections
    def set_Layer7_Connections(self, Layer7_Connections): self.Layer7_Connections = Layer7_Connections
    def get_tls_used(self): return self.tls_used
    def set_tls_used(self, tls_used): self.tls_used = tls_used
    def export(self, outfile, level, namespace_='NetworkConnectionObj:', name_='NetworkConnectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkConnectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='NetworkConnectionObj:', name_='NetworkConnectionType'):
        super(NetworkConnectionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkConnectionType')
        if self.tls_used is not None and 'tls_used' not in already_processed:
            already_processed.append('tls_used')
            outfile.write(' tls_used="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.tls_used)), input_name='tls_used'))
    def exportChildren(self, outfile, level, namespace_='NetworkConnectionObj:', name_='NetworkConnectionType', fromsubclass_=False, pretty_print=True):
        super(NetworkConnectionType, self).exportChildren(outfile, level, 'NetworkConnectionObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Layer3_Protocol is not None:
            self.Layer3_Protocol.export(outfile, level, 'NetworkConnectionObj:', name_='Layer3_Protocol', pretty_print=pretty_print)
        if self.Layer4_Protocol is not None:
            self.Layer4_Protocol.export(outfile, level, 'NetworkConnectionObj:', name_='Layer4_Protocol', pretty_print=pretty_print)
        if self.Layer7_Protocol is not None:
            self.Layer7_Protocol.export(outfile, level, 'NetworkConnectionObj:', name_='Layer7_Protocol', pretty_print=pretty_print)
        if self.Local_IP_Address is not None:
            self.Local_IP_Address.export(outfile, level, 'NetworkConnectionObj:', name_='Local_IP_Address', pretty_print=pretty_print)
        if self.Local_Port is not None:
            self.Local_Port.export(outfile, level, 'NetworkConnectionObj:', name_='Local_Port', pretty_print=pretty_print)
        if self.Remote_IP_Address is not None:
            self.Remote_IP_Address.export(outfile, level, 'NetworkConnectionObj:', name_='Remote_IP_Address', pretty_print=pretty_print)
        if self.Remote_Port is not None:
            self.Remote_Port.export(outfile, level, 'NetworkConnectionObj:', name_='Remote_Port', pretty_print=pretty_print)
        if self.Layer7_Connections is not None:
            self.Layer7_Connections.export(outfile, level, namespace_, name_='Layer7_Connections', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Layer3_Protocol is not None or
            self.Layer4_Protocol is not None or
            self.Layer7_Protocol is not None or
            self.Local_IP_Address is not None or
            self.Local_Port is not None or
            self.Remote_IP_Address is not None or
            self.Remote_Port is not None or
            self.Layer7_Connections is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NetworkConnectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tls_used is not None and 'tls_used' not in already_processed:
            already_processed.append('tls_used')
            showIndent(outfile, level)
            outfile.write('tls_used = %s,\n' % (self.tls_used,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Layer3_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Layer3_Protocol=model_.Layer3ProtocolType(\n')
            self.Layer3_Protocol.exportLiteral(outfile, level, name_='Layer3_Protocol')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Layer4_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Layer4_Protocol=model_.Layer4ProtocolType(\n')
            self.Layer4_Protocol.exportLiteral(outfile, level, name_='Layer4_Protocol')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Layer7_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Layer7_Protocol=model_.Layer7ProtocolType(\n')
            self.Layer7_Protocol.exportLiteral(outfile, level, name_='Layer7_Protocol')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Local_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('Local_IP_Address=%s,\n' % quote_python(self.Local_IP_Address).encode(ExternalEncoding))
        if self.Local_Port is not None:
            showIndent(outfile, level)
            outfile.write('Local_Port=%s,\n' % quote_python(self.Local_Port).encode(ExternalEncoding))
        if self.Remote_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('Remote_IP_Address=%s,\n' % quote_python(self.Remote_IP_Address).encode(ExternalEncoding))
        if self.Remote_Port is not None:
            showIndent(outfile, level)
            outfile.write('Remote_Port=%s,\n' % quote_python(self.Remote_Port).encode(ExternalEncoding))
        if self.Layer7_Connections is not None:
            showIndent(outfile, level)
            outfile.write('Layer7_Connections=model_.Layer7ConnectionsType(\n')
            self.Layer7_Connections.exportLiteral(outfile, level, name_='Layer7_Connections')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(NetworkConnectionType, self).buildAttributes(node, attrs, already_processed)
        value = find_attr_value_('tls_used', node)
        if value is not None and 'tls_used' not in already_processed:
            already_processed.append('tls_used')
            if value in ('true', '1'):
                self.tls_used = True
            elif value in ('false', '0'):
                self.tls_used = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Layer3_Protocol':
            obj_ = Layer3ProtocolType.factory()
            obj_.build(child_)
            self.set_Layer3_Protocol(obj_)
        elif nodeName_ == 'Layer4_Protocol':
            obj_ = Layer4ProtocolType.factory()
            obj_.build(child_)
            self.set_Layer4_Protocol(obj_)
        elif nodeName_ == 'Layer7_Protocol':
            obj_ = Layer7ProtocolType.factory()
            obj_.build(child_)
            self.set_Layer7_Protocol(obj_)
        elif nodeName_ == 'Local_IP_Address':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_Local_IP_Address(obj_)
        elif nodeName_ == 'Local_Port':
            obj_ = port_object_1_3.PortObjectType.factory()
            obj_.build(child_)
            self.set_Local_Port(obj_)
        elif nodeName_ == 'Remote_IP_Address':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_Remote_IP_Address(obj_)
        elif nodeName_ == 'Remote_Port':
            obj_ = port_object_1_3.PortObjectType.factory()
            obj_.build(child_)
            self.set_Remote_Port(obj_)
        elif nodeName_ == 'Layer7_Connections':
            obj_ = Layer7ConnectionsType.factory()
            obj_.build(child_)
            self.set_Layer7_Connections(obj_)
        super(NetworkConnectionType, self).buildChildren(child_, node, nodeName_, True)
# end class NetworkConnectionType

class Layer4ProtocolType(cybox_common_types_1_0.BaseObjectAttributeType):
    """port_object_1_3.Layer4ProtocolType specifies Layer 4 (OSI model) protocols, via a
    union of the Layer4ProtocolEnum type and the atomic xs:string
    type. Its base type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType,
    for permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(port_object_1_3.Layer4ProtocolType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if port_object_1_3.Layer4ProtocolType.subclass:
            return port_object_1_3.Layer4ProtocolType.subclass(*args_, **kwargs_)
        else:
            return port_object_1_3.Layer4ProtocolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='NetworkConnectionObj:', name_='port_object_1_3.Layer4ProtocolType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='port_object_1_3.Layer4ProtocolType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='NetworkConnectionObj:', name_='port_object_1_3.Layer4ProtocolType'):
        super(port_object_1_3.Layer4ProtocolType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='port_object_1_3.Layer4ProtocolType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='NetworkConnectionObj:', name_='port_object_1_3.Layer4ProtocolType', fromsubclass_=False, pretty_print=True):
        super(port_object_1_3.Layer4ProtocolType, self).exportChildren(outfile, level, 'NetworkConnectionObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(port_object_1_3.Layer4ProtocolType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='port_object_1_3.Layer4ProtocolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(port_object_1_3.Layer4ProtocolType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(port_object_1_3.Layer4ProtocolType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(port_object_1_3.Layer4ProtocolType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class port_object_1_3.Layer4ProtocolType

class Layer7ProtocolType(cybox_common_types_1_0.BaseObjectAttributeType):
    """Layer7ProtocolType specifies Layer 7 protocol types, via a union of
    the Layer7ProtocolEnum type and the atomic xs:string type. Its
    base type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for
    permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(Layer7ProtocolType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Layer7ProtocolType.subclass:
            return Layer7ProtocolType.subclass(*args_, **kwargs_)
        else:
            return Layer7ProtocolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer7ProtocolType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Layer7ProtocolType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='NetworkConnectionObj:', name_='Layer7ProtocolType'):
        super(Layer7ProtocolType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Layer7ProtocolType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer7ProtocolType', fromsubclass_=False, pretty_print=True):
        super(Layer7ProtocolType, self).exportChildren(outfile, level, 'NetworkConnectionObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(Layer7ProtocolType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Layer7ProtocolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(Layer7ProtocolType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Layer7ProtocolType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(Layer7ProtocolType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Layer7ProtocolType

class Layer3ProtocolType(cybox_common_types_1_0.BaseObjectAttributeType):
    """Layer3ProtocolType specifies Layer 3 protocol types, via a union of
    the Layer3ProtocolEnum type and the atomic xs:string type. Its
    base type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for
    permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(Layer3ProtocolType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Layer3ProtocolType.subclass:
            return Layer3ProtocolType.subclass(*args_, **kwargs_)
        else:
            return Layer3ProtocolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer3ProtocolType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Layer3ProtocolType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='NetworkConnectionObj:', name_='Layer3ProtocolType'):
        super(Layer3ProtocolType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Layer3ProtocolType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer3ProtocolType', fromsubclass_=False, pretty_print=True):
        super(Layer3ProtocolType, self).exportChildren(outfile, level, 'NetworkConnectionObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(Layer3ProtocolType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Layer3ProtocolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(Layer3ProtocolType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Layer3ProtocolType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(Layer3ProtocolType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Layer3ProtocolType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Network_Connection'
        rootClass = NetworkConnectionType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Network_Connection'
        rootClass = NetworkConnectionType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Network_Connection",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Network_Connection'
        rootClass = NetworkConnectionType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "NetworkConnectionType",
    "Layer7ConnectionsType",
    "Layer3ProtocolType",
    "Layer4ProtocolType",
    "Layer7ProtocolType"
    ]