#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:03:22 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import address_object_1_2
import port_object_1_3

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class NetworkConnectionType(GeneratedsSuper):
    """The NetworkConnectionType type captures the critical information
    about a TCP or UDP network connection."""
    subclass = None
    superclass = None
    def __init__(self, Creation_Time=None, Destination_IP_Address=None, Destination_Port=None, Source_IP_Address=None, Source_Port=None, TCP_State=None):
        self.Creation_Time = Creation_Time
        self.Destination_IP_Address = Destination_IP_Address
        self.Destination_Port = Destination_Port
        self.Source_IP_Address = Source_IP_Address
        self.Source_Port = Source_Port
        self.TCP_State = TCP_State
    def factory(*args_, **kwargs_):
        if NetworkConnectionType.subclass:
            return NetworkConnectionType.subclass(*args_, **kwargs_)
        else:
            return NetworkConnectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Creation_Time(self): return self.Creation_Time
    def set_Creation_Time(self, Creation_Time): self.Creation_Time = Creation_Time
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Destination_IP_Address(self): return self.Destination_IP_Address
    def set_Destination_IP_Address(self, Destination_IP_Address): self.Destination_IP_Address = Destination_IP_Address
    def get_Destination_Port(self): return self.Destination_Port
    def set_Destination_Port(self, Destination_Port): self.Destination_Port = Destination_Port
    def get_Source_IP_Address(self): return self.Source_IP_Address
    def set_Source_IP_Address(self, Source_IP_Address): self.Source_IP_Address = Source_IP_Address
    def get_Source_Port(self): return self.Source_Port
    def set_Source_Port(self, Source_Port): self.Source_Port = Source_Port
    def get_TCP_State(self): return self.TCP_State
    def set_TCP_State(self, TCP_State): self.TCP_State = TCP_State
    def validate_ConnectionStateType(self, value):
        # Validate type ConnectionStateType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='ProcessObj:', name_='NetworkConnectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkConnectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='NetworkConnectionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='NetworkConnectionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Creation_Time is not None:
            self.Creation_Time.export(outfile, level, 'ProcessObj:', name_='Creation_Time', pretty_print=pretty_print)
        if self.Destination_IP_Address is not None:
            self.Destination_IP_Address.export(outfile, level, 'ProcessObj:', name_='Destination_IP_Address', pretty_print=pretty_print)
        if self.Destination_Port is not None:
            self.Destination_Port.export(outfile, level, 'ProcessObj:', name_='Destination_Port', pretty_print=pretty_print)
        if self.Source_IP_Address is not None:
            self.Source_IP_Address.export(outfile, level, 'ProcessObj:', name_='Source_IP_Address', pretty_print=pretty_print)
        if self.Source_Port is not None:
            self.Source_Port.export(outfile, level, 'ProcessObj:', name_='Source_Port', pretty_print=pretty_print)
        if self.TCP_State is not None:
            self.TCP_State.export(outfile, level, 'ProcessObj:', name_='TCP_State', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Creation_Time is not None or
            self.Destination_IP_Address is not None or
            self.Destination_Port is not None or
            self.Source_IP_Address is not None or
            self.Source_Port is not None or
            self.TCP_State is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NetworkConnectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Creation_Time is not None:
            showIndent(outfile, level)
            outfile.write('Creation_Time=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Creation_Time.exportLiteral(outfile, level, name_='Creation_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Destination_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('Destination_IP_Address=model_.address_object_1_2.AddressObjectType(\n')
            self.Destination_IP_Address.exportLiteral(outfile, level, name_='Destination_IP_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Destination_Port is not None:
            showIndent(outfile, level)
            outfile.write('Destination_Port=model_.port_object_1_3.PortObjectType(\n')
            self.Destination_Port.exportLiteral(outfile, level, name_='Destination_Port')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Source_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('Source_IP_Address=model_.address_object_1_2.AddressObjectType(\n')
            self.Source_IP_Address.exportLiteral(outfile, level, name_='Source_IP_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Source_Port is not None:
            showIndent(outfile, level)
            outfile.write('Source_Port=model_.port_object_1_3.PortObjectType(\n')
            self.Source_Port.exportLiteral(outfile, level, name_='Source_Port')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.TCP_State is not None:
            showIndent(outfile, level)
            outfile.write('TCP_State=model_.ConnectionStateType(\n')
            self.TCP_State.exportLiteral(outfile, level, name_='TCP_State')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Creation_Time':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Creation_Time(obj_)
        elif nodeName_ == 'Destination_IP_Address':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_Destination_IP_Address(obj_)
        elif nodeName_ == 'Destination_Port':
            obj_ = port_object_1_3.PortObjectType.factory()
            obj_.build(child_)
            self.set_Destination_Port(obj_)
        elif nodeName_ == 'Source_IP_Address':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_Source_IP_Address(obj_)
        elif nodeName_ == 'Source_Port':
            obj_ = port_object_1_3.PortObjectType.factory()
            obj_.build(child_)
            self.set_Source_Port(obj_)
        elif nodeName_ == 'TCP_State':
            obj_ = ConnectionStateType.factory()
            obj_.build(child_)
            self.set_TCP_State(obj_)
# end class NetworkConnectionType

class NetworkConnectionListType(GeneratedsSuper):
    """The NetworkConnectionListType type is a list of network connections."""
    subclass = None
    superclass = None
    def __init__(self, Network_Connection=None):
        if Network_Connection is None:
            self.Network_Connection = []
        else:
            self.Network_Connection = Network_Connection
    def factory(*args_, **kwargs_):
        if NetworkConnectionListType.subclass:
            return NetworkConnectionListType.subclass(*args_, **kwargs_)
        else:
            return NetworkConnectionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Network_Connection(self): return self.Network_Connection
    def set_Network_Connection(self, Network_Connection): self.Network_Connection = Network_Connection
    def add_Network_Connection(self, value): self.Network_Connection.append(value)
    def insert_Network_Connection(self, index, value): self.Network_Connection[index] = value
    def export(self, outfile, level, namespace_='ProcessObj:', name_='NetworkConnectionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkConnectionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='NetworkConnectionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='NetworkConnectionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Network_Connection_ in self.Network_Connection:
            Network_Connection_.export(outfile, level, 'ProcessObj:', name_='Network_Connection', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Network_Connection
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NetworkConnectionListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Network_Connection=[\n')
        level += 1
        for Network_Connection_ in self.Network_Connection:
            showIndent(outfile, level)
            outfile.write('model_.NetworkConnectionType(\n')
            Network_Connection_.exportLiteral(outfile, level, name_='NetworkConnectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Network_Connection':
            obj_ = NetworkConnectionType.factory()
            obj_.build(child_)
            self.Network_Connection.append(obj_)
# end class NetworkConnectionListType

class ImageInfoType(GeneratedsSuper):
    """The ImageInfoType type captures information about the process image."""
    subclass = None
    superclass = None
    def __init__(self, File_Name=None, Command_Line=None, Current_Directory=None, Path=None):
        self.File_Name = File_Name
        self.Command_Line = Command_Line
        self.Current_Directory = Current_Directory
        self.Path = Path
    def factory(*args_, **kwargs_):
        if ImageInfoType.subclass:
            return ImageInfoType.subclass(*args_, **kwargs_)
        else:
            return ImageInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File_Name(self): return self.File_Name
    def set_File_Name(self, File_Name): self.File_Name = File_Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Command_Line(self): return self.Command_Line
    def set_Command_Line(self, Command_Line): self.Command_Line = Command_Line
    def get_Current_Directory(self): return self.Current_Directory
    def set_Current_Directory(self, Current_Directory): self.Current_Directory = Current_Directory
    def get_Path(self): return self.Path
    def set_Path(self, Path): self.Path = Path
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ImageInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImageInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ImageInfoType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ImageInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.File_Name is not None:
            self.File_Name.export(outfile, level, 'ProcessObj:', name_='File_Name', pretty_print=pretty_print)
        if self.Command_Line is not None:
            self.Command_Line.export(outfile, level, 'ProcessObj:', name_='Command_Line', pretty_print=pretty_print)
        if self.Current_Directory is not None:
            self.Current_Directory.export(outfile, level, 'ProcessObj:', name_='Current_Directory', pretty_print=pretty_print)
        if self.Path is not None:
            self.Path.export(outfile, level, 'ProcessObj:', name_='Path', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.File_Name is not None or
            self.Command_Line is not None or
            self.Current_Directory is not None or
            self.Path is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImageInfoType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.File_Name is not None:
            showIndent(outfile, level)
            outfile.write('File_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.File_Name.exportLiteral(outfile, level, name_='File_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Command_Line is not None:
            showIndent(outfile, level)
            outfile.write('Command_Line=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Command_Line.exportLiteral(outfile, level, name_='Command_Line')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Current_Directory is not None:
            showIndent(outfile, level)
            outfile.write('Current_Directory=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Current_Directory.exportLiteral(outfile, level, name_='Current_Directory')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Path is not None:
            showIndent(outfile, level)
            outfile.write('Path=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Path.exportLiteral(outfile, level, name_='Path')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_File_Name(obj_)
        elif nodeName_ == 'Command_Line':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Command_Line(obj_)
        elif nodeName_ == 'Current_Directory':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Current_Directory(obj_)
        elif nodeName_ == 'Path':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Path(obj_)
# end class ImageInfoType

class ProcessStatusType(GeneratedsSuper):
    """The ProcessStatusType is used for specifying the status of a running
    or terminated process. Since this property is platform-specific,
    it is created here as an abstract type and then used in the
    platform-specific process CybOX objects."""
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if ProcessStatusType.subclass:
            return ProcessStatusType.subclass(*args_, **kwargs_)
        else:
            return ProcessStatusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ProcessStatusType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProcessStatusType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ProcessStatusType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ProcessStatusType', fromsubclass_=False, pretty_print=True):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ProcessStatusType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ProcessStatusType

class ChildPIDListType(GeneratedsSuper):
    """The ChildPIDListType type captures the PID's of the children of the
    process in a list format."""
    subclass = None
    superclass = None
    def __init__(self, Child_PID=None):
        if Child_PID is None:
            self.Child_PID = []
        else:
            self.Child_PID = Child_PID
    def factory(*args_, **kwargs_):
        if ChildPIDListType.subclass:
            return ChildPIDListType.subclass(*args_, **kwargs_)
        else:
            return ChildPIDListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Child_PID(self): return self.Child_PID
    def set_Child_PID(self, Child_PID): self.Child_PID = Child_PID
    def add_Child_PID(self, value): self.Child_PID.append(value)
    def insert_Child_PID(self, index, value): self.Child_PID[index] = value
    def validate_UnsignedIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedIntegerObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ChildPIDListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChildPIDListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ChildPIDListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ChildPIDListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Child_PID_ in self.Child_PID:
            Child_PID_.export(outfile, level, 'ProcessObj:', name_='Child_PID', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Child_PID
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ChildPIDListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Child_PID=[\n')
        level += 1
        for Child_PID_ in self.Child_PID:
            showIndent(outfile, level)
            outfile.write('model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            Child_PID_.exportLiteral(outfile, level, name_='cybox_common_types_1_0.UnsignedIntegerObjectAttributeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Child_PID':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.Child_PID.append(obj_)
# end class ChildPIDListType

class ArgumentListType(GeneratedsSuper):
    """The ArgumentListType is intended to specify a list of arguments
    utlized in intiating the process."""
    subclass = None
    superclass = None
    def __init__(self, Argument=None):
        self.Argument = Argument
    def factory(*args_, **kwargs_):
        if ArgumentListType.subclass:
            return ArgumentListType.subclass(*args_, **kwargs_)
        else:
            return ArgumentListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Argument(self): return self.Argument
    def set_Argument(self, Argument): self.Argument = Argument
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ArgumentListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ArgumentListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ArgumentListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ArgumentListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Argument is not None:
            self.Argument.export(outfile, level, 'ProcessObj:', name_='Argument', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Argument is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ArgumentListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Argument is not None:
            showIndent(outfile, level)
            outfile.write('Argument=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Argument.exportLiteral(outfile, level, name_='Argument')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Argument':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Argument(obj_)
# end class ArgumentListType

class PortListType(GeneratedsSuper):
    """The PortListType is intended to specify a list of network ports."""
    subclass = None
    superclass = None
    def __init__(self, Port=None):
        if Port is None:
            self.Port = []
        else:
            self.Port = Port
    def factory(*args_, **kwargs_):
        if PortListType.subclass:
            return PortListType.subclass(*args_, **kwargs_)
        else:
            return PortListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Port(self): return self.Port
    def set_Port(self, Port): self.Port = Port
    def add_Port(self, value): self.Port.append(value)
    def insert_Port(self, index, value): self.Port[index] = value
    def export(self, outfile, level, namespace_='ProcessObj:', name_='PortListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PortListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='PortListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='PortListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Port_ in self.Port:
            Port_.export(outfile, level, 'ProcessObj:', name_='Port', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Port
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PortListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Port=[\n')
        level += 1
        for Port_ in self.Port:
            showIndent(outfile, level)
            outfile.write('model_.port_object_1_3.PortObjectType(\n')
            Port_.exportLiteral(outfile, level, name_='port_object_1_3.PortObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Port':
            obj_ = port_object_1_3.PortObjectType.factory()
            obj_.build(child_)
            self.Port.append(obj_)
# end class PortListType

class ProcessObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The ProcessObjectType type is intended to characterize system
    processes.The hidden attribute specifies whether the process is
    hidden or not."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, is_hidden=None, PID=None, Name=None, Creation_Time=None, Parent_PID=None, Child_PID_List=None, Image_Info=None, Argument_List=None, Environment_Variable_List=None, Kernel_Time=None, Port_List=None, Network_Connection_List=None, Start_Time=None, Status=None, String_List=None, Username=None, User_Time=None):
        super(ProcessObjectType, self).__init__(object_reference, )
        self.is_hidden = _cast(bool, is_hidden)
        self.PID = PID
        self.Name = Name
        self.Creation_Time = Creation_Time
        self.Parent_PID = Parent_PID
        self.Child_PID_List = Child_PID_List
        self.Image_Info = Image_Info
        self.Argument_List = Argument_List
        self.Environment_Variable_List = Environment_Variable_List
        self.Kernel_Time = Kernel_Time
        self.Port_List = Port_List
        self.Network_Connection_List = Network_Connection_List
        self.Start_Time = Start_Time
        self.Status = Status
        self.String_List = String_List
        self.Username = Username
        self.User_Time = User_Time
    def factory(*args_, **kwargs_):
        if ProcessObjectType.subclass:
            return ProcessObjectType.subclass(*args_, **kwargs_)
        else:
            return ProcessObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PID(self): return self.PID
    def set_PID(self, PID): self.PID = PID
    def validate_UnsignedIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedIntegerObjectAttributeType, a restriction on None.
        pass
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Creation_Time(self): return self.Creation_Time
    def set_Creation_Time(self, Creation_Time): self.Creation_Time = Creation_Time
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Parent_PID(self): return self.Parent_PID
    def set_Parent_PID(self, Parent_PID): self.Parent_PID = Parent_PID
    def get_Child_PID_List(self): return self.Child_PID_List
    def set_Child_PID_List(self, Child_PID_List): self.Child_PID_List = Child_PID_List
    def get_Image_Info(self): return self.Image_Info
    def set_Image_Info(self, Image_Info): self.Image_Info = Image_Info
    def get_Argument_List(self): return self.Argument_List
    def set_Argument_List(self, Argument_List): self.Argument_List = Argument_List
    def get_Environment_Variable_List(self): return self.Environment_Variable_List
    def set_Environment_Variable_List(self, Environment_Variable_List): self.Environment_Variable_List = Environment_Variable_List
    def get_Kernel_Time(self): return self.Kernel_Time
    def set_Kernel_Time(self, Kernel_Time): self.Kernel_Time = Kernel_Time
    def validate_DurationObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DurationObjectAttributeType, a restriction on None.
        pass
    def get_Port_List(self): return self.Port_List
    def set_Port_List(self, Port_List): self.Port_List = Port_List
    def get_Network_Connection_List(self): return self.Network_Connection_List
    def set_Network_Connection_List(self, Network_Connection_List): self.Network_Connection_List = Network_Connection_List
    def get_Start_Time(self): return self.Start_Time
    def set_Start_Time(self, Start_Time): self.Start_Time = Start_Time
    def get_Status(self): return self.Status
    def set_Status(self, Status): self.Status = Status
    def get_String_List(self): return self.String_List
    def set_String_List(self, String_List): self.String_List = String_List
    def get_Username(self): return self.Username
    def set_Username(self, Username): self.Username = Username
    def get_User_Time(self): return self.User_Time
    def set_User_Time(self, User_Time): self.User_Time = User_Time
    def get_is_hidden(self): return self.is_hidden
    def set_is_hidden(self, is_hidden): self.is_hidden = is_hidden
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ProcessObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProcessObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ProcessObjectType'):
        super(ProcessObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ProcessObjectType')
        if self.is_hidden is not None and 'is_hidden' not in already_processed:
            already_processed.append('is_hidden')
            outfile.write(' is_hidden="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.is_hidden)), input_name='is_hidden'))
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ProcessObjectType', fromsubclass_=False, pretty_print=True):
        super(ProcessObjectType, self).exportChildren(outfile, level, 'ProcessObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PID is not None:
            self.PID.export(outfile, level, 'ProcessObj:', name_='PID', pretty_print=pretty_print)
        if self.Name is not None:
            self.Name.export(outfile, level, 'ProcessObj:', name_='Name', pretty_print=pretty_print)
        if self.Creation_Time is not None:
            self.Creation_Time.export(outfile, level, 'ProcessObj:', name_='Creation_Time', pretty_print=pretty_print)
        if self.Parent_PID is not None:
            self.Parent_PID.export(outfile, level, 'ProcessObj:', name_='Parent_PID', pretty_print=pretty_print)
        if self.Child_PID_List is not None:
            self.Child_PID_List.export(outfile, level, 'ProcessObj:', name_='Child_PID_List', pretty_print=pretty_print)
        if self.Image_Info is not None:
            self.Image_Info.export(outfile, level, 'ProcessObj:', name_='Image_Info', pretty_print=pretty_print)
        if self.Argument_List is not None:
            self.Argument_List.export(outfile, level, 'ProcessObj:', name_='Argument_List', pretty_print=pretty_print)
        if self.Environment_Variable_List is not None:
            self.Environment_Variable_List.export(outfile, level, 'ProcessObj:', name_='Environment_Variable_List', pretty_print=pretty_print)
        if self.Kernel_Time is not None:
            self.Kernel_Time.export(outfile, level, 'ProcessObj:', name_='Kernel_Time', pretty_print=pretty_print)
        if self.Port_List is not None:
            self.Port_List.export(outfile, level, 'ProcessObj:', name_='Port_List', pretty_print=pretty_print)
        if self.Network_Connection_List is not None:
            self.Network_Connection_List.export(outfile, level, 'ProcessObj:', name_='Network_Connection_List', pretty_print=pretty_print)
        if self.Start_Time is not None:
            self.Start_Time.export(outfile, level, 'ProcessObj:', name_='Start_Time', pretty_print=pretty_print)
        if self.Status is not None:
            self.Status.export(outfile, level, 'ProcessObj:', name_='Status', pretty_print=pretty_print)
        if self.String_List is not None:
            self.String_List.export(outfile, level, 'ProcessObj:', name_='String_List', pretty_print=pretty_print)
        if self.Username is not None:
            self.Username.export(outfile, level, 'ProcessObj:', name_='Username', pretty_print=pretty_print)
        if self.User_Time is not None:
            self.User_Time.export(outfile, level, 'ProcessObj:', name_='User_Time', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.PID is not None or
            self.Name is not None or
            self.Creation_Time is not None or
            self.Parent_PID is not None or
            self.Child_PID_List is not None or
            self.Image_Info is not None or
            self.Argument_List is not None or
            self.Environment_Variable_List is not None or
            self.Kernel_Time is not None or
            self.Port_List is not None or
            self.Network_Connection_List is not None or
            self.Start_Time is not None or
            self.Status is not None or
            self.String_List is not None or
            self.Username is not None or
            self.User_Time is not None or
            super(ProcessObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ProcessObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_hidden is not None and 'is_hidden' not in already_processed:
            already_processed.append('is_hidden')
            showIndent(outfile, level)
            outfile.write('is_hidden = %s,\n' % (self.is_hidden,))
        super(ProcessObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ProcessObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.PID is not None:
            showIndent(outfile, level)
            outfile.write('PID=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.PID.exportLiteral(outfile, level, name_='PID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Creation_Time is not None:
            showIndent(outfile, level)
            outfile.write('Creation_Time=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Creation_Time.exportLiteral(outfile, level, name_='Creation_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Parent_PID is not None:
            showIndent(outfile, level)
            outfile.write('Parent_PID=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.Parent_PID.exportLiteral(outfile, level, name_='Parent_PID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Child_PID_List is not None:
            showIndent(outfile, level)
            outfile.write('Child_PID_List=model_.ChildPIDListType(\n')
            self.Child_PID_List.exportLiteral(outfile, level, name_='Child_PID_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Image_Info is not None:
            showIndent(outfile, level)
            outfile.write('Image_Info=model_.ImageInfoType(\n')
            self.Image_Info.exportLiteral(outfile, level, name_='Image_Info')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Argument_List is not None:
            showIndent(outfile, level)
            outfile.write('Argument_List=model_.ArgumentListType(\n')
            self.Argument_List.exportLiteral(outfile, level, name_='Argument_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Environment_Variable_List is not None:
            showIndent(outfile, level)
            outfile.write('Environment_Variable_List=model_.cybox_common_types_1_0.EnvironmentVariableListType(\n')
            self.Environment_Variable_List.exportLiteral(outfile, level, name_='Environment_Variable_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Kernel_Time is not None:
            showIndent(outfile, level)
            outfile.write('Kernel_Time=model_.cybox_common_types_1_0.DurationObjectAttributeType(\n')
            self.Kernel_Time.exportLiteral(outfile, level, name_='Kernel_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Port_List is not None:
            showIndent(outfile, level)
            outfile.write('Port_List=model_.PortListType(\n')
            self.Port_List.exportLiteral(outfile, level, name_='Port_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Network_Connection_List is not None:
            showIndent(outfile, level)
            outfile.write('Network_Connection_List=model_.NetworkConnectionListType(\n')
            self.Network_Connection_List.exportLiteral(outfile, level, name_='Network_Connection_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Start_Time is not None:
            showIndent(outfile, level)
            outfile.write('Start_Time=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Start_Time.exportLiteral(outfile, level, name_='Start_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ProcessStatusType is not None:
            showIndent(outfile, level)
            outfile.write('ProcessStatusType=model_.ProcessStatusType(\n')
            self.ProcessStatusType.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.String_List is not None:
            showIndent(outfile, level)
            outfile.write('String_List=model_.cybox_common_types_1_0.ExtractedStringsType(\n')
            self.String_List.exportLiteral(outfile, level, name_='String_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Username is not None:
            showIndent(outfile, level)
            outfile.write('Username=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Username.exportLiteral(outfile, level, name_='Username')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.User_Time is not None:
            showIndent(outfile, level)
            outfile.write('User_Time=model_.cybox_common_types_1_0.DurationObjectAttributeType(\n')
            self.User_Time.exportLiteral(outfile, level, name_='User_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_hidden', node)
        if value is not None and 'is_hidden' not in already_processed:
            already_processed.append('is_hidden')
            if value in ('true', '1'):
                self.is_hidden = True
            elif value in ('false', '0'):
                self.is_hidden = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(ProcessObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PID':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_PID(obj_)
        elif nodeName_ == 'Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Creation_Time':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Creation_Time(obj_)
        elif nodeName_ == 'Parent_PID':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Parent_PID(obj_)
        elif nodeName_ == 'Child_PID_List':
            obj_ = ChildPIDListType.factory()
            obj_.build(child_)
            self.set_Child_PID_List(obj_)
        elif nodeName_ == 'Image_Info':
            obj_ = ImageInfoType.factory()
            obj_.build(child_)
            self.set_Image_Info(obj_)
        elif nodeName_ == 'Argument_List':
            obj_ = ArgumentListType.factory()
            obj_.build(child_)
            self.set_Argument_List(obj_)
        elif nodeName_ == 'Environment_Variable_List':
            obj_ = cybox_common_types_1_0.EnvironmentVariableListType.factory()
            obj_.build(child_)
            self.set_Environment_Variable_List(obj_)
        elif nodeName_ == 'Kernel_Time':
            obj_ = cybox_common_types_1_0.DurationObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Kernel_Time(obj_)
        elif nodeName_ == 'Port_List':
            obj_ = PortListType.factory()
            obj_.build(child_)
            self.set_Port_List(obj_)
        elif nodeName_ == 'Network_Connection_List':
            obj_ = NetworkConnectionListType.factory()
            obj_.build(child_)
            self.set_Network_Connection_List(obj_)
        elif nodeName_ == 'Start_Time':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Start_Time(obj_)
        elif nodeName_ == 'Status':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <Status> element')
            self.set_Status(obj_)
        elif nodeName_ == 'String_List':
            obj_ = cybox_common_types_1_0.ExtractedStringsType.factory()
            obj_.build(child_)
            self.set_String_List(obj_)
        elif nodeName_ == 'Username':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Username(obj_)
        elif nodeName_ == 'User_Time':
            obj_ = cybox_common_types_1_0.DurationObjectAttributeType.factory()
            obj_.build(child_)
            self.set_User_Time(obj_)
        super(ProcessObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class ProcessObjectType

class ConnectionStateType(cybox_common_types_1_0.BaseObjectAttributeType):
    """ConnectionStateType specifies connection states, via a union of the
    ConnectionStateEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(ConnectionStateType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ConnectionStateType.subclass:
            return ConnectionStateType.subclass(*args_, **kwargs_)
        else:
            return ConnectionStateType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ConnectionStateType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConnectionStateType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ConnectionStateType'):
        super(ConnectionStateType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ConnectionStateType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ConnectionStateType', fromsubclass_=False, pretty_print=True):
        super(ConnectionStateType, self).exportChildren(outfile, level, 'ProcessObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(ConnectionStateType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ConnectionStateType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(ConnectionStateType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ConnectionStateType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(ConnectionStateType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ConnectionStateType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Process'
        rootClass = ProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Process'
        rootClass = ProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Process",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Process'
        rootClass = ProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "ProcessObjectType",
    "NetworkConnectionType",
    "NetworkConnectionListType",
    "ImageInfoType",
    "ProcessStatusType",
    "ChildPIDListType",
    "ConnectionStateType",
    "ArgumentListType",
    "PortListType"
    ]