#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:03:44 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class VolumeOptionsType(GeneratedsSuper):
    """The VolumeOptionsType type specifies the particular options set for
    the volume. This is an abstract type since volume options are
    OS-specific, and is extended by the related OS-specific CybOX
    volume objects."""
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if VolumeOptionsType.subclass:
            return VolumeOptionsType.subclass(*args_, **kwargs_)
        else:
            return VolumeOptionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='VolumeObj:', name_='VolumeOptionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VolumeOptionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='VolumeObj:', name_='VolumeOptionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='VolumeObj:', name_='VolumeOptionsType', fromsubclass_=False, pretty_print=True):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VolumeOptionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class VolumeOptionsType

class FileSystemFlagListType(GeneratedsSuper):
    """The FileSystemFlagListType is a listing of the flags specified for
    the volume by the file system."""
    subclass = None
    superclass = None
    def __init__(self, File_System_Flag=None):
        if File_System_Flag is None:
            self.File_System_Flag = []
        else:
            self.File_System_Flag = File_System_Flag
    def factory(*args_, **kwargs_):
        if FileSystemFlagListType.subclass:
            return FileSystemFlagListType.subclass(*args_, **kwargs_)
        else:
            return FileSystemFlagListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File_System_Flag(self): return self.File_System_Flag
    def set_File_System_Flag(self, File_System_Flag): self.File_System_Flag = File_System_Flag
    def add_File_System_Flag(self, value): self.File_System_Flag.append(value)
    def insert_File_System_Flag(self, index, value): self.File_System_Flag[index] = value
    def validate_VolumeFileSystemFlagType(self, value):
        # Validate type VolumeFileSystemFlagType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='VolumeObj:', name_='FileSystemFlagListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FileSystemFlagListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='VolumeObj:', name_='FileSystemFlagListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='VolumeObj:', name_='FileSystemFlagListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for File_System_Flag_ in self.File_System_Flag:
            File_System_Flag_.export(outfile, level, 'VolumeObj:', name_='File_System_Flag', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.File_System_Flag
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FileSystemFlagListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('File_System_Flag=[\n')
        level += 1
        for File_System_Flag_ in self.File_System_Flag:
            showIndent(outfile, level)
            outfile.write('model_.VolumeFileSystemFlagType(\n')
            File_System_Flag_.exportLiteral(outfile, level, name_='VolumeFileSystemFlagType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File_System_Flag':
            obj_ = VolumeFileSystemFlagType.factory()
            obj_.build(child_)
            self.File_System_Flag.append(obj_)
# end class FileSystemFlagListType

class VolumeFileSystemFlagType(cybox_common_types_1_0.BaseObjectAttributeType):
    """VolumeFileSystemFlagType specifies file system flags, via a union of
    the VolumeFileSystemFlagEnum type and the atomic xs:string type.
    Its base type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for
    permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(VolumeFileSystemFlagType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if VolumeFileSystemFlagType.subclass:
            return VolumeFileSystemFlagType.subclass(*args_, **kwargs_)
        else:
            return VolumeFileSystemFlagType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='VolumeObj:', name_='VolumeFileSystemFlagType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VolumeFileSystemFlagType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='VolumeObj:', name_='VolumeFileSystemFlagType'):
        super(VolumeFileSystemFlagType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VolumeFileSystemFlagType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='VolumeObj:', name_='VolumeFileSystemFlagType', fromsubclass_=False, pretty_print=True):
        super(VolumeFileSystemFlagType, self).exportChildren(outfile, level, 'VolumeObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(VolumeFileSystemFlagType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VolumeFileSystemFlagType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(VolumeFileSystemFlagType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VolumeFileSystemFlagType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(VolumeFileSystemFlagType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class VolumeFileSystemFlagType

class VolumeObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The VolumeObjectType type is intended to characterize generic drive
    volumes.The ismounted attribute specifies whether the volume is
    mounted."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, is_mounted=None, Name=None, Device_Path=None, File_System_Type=None, Total_Allocation_Units=None, Sectors_Per_Allocation_Unit=None, Bytes_Per_Sector=None, Actual_Available_Allocation_Units=None, Creation_Time=None, File_System_Flag_List=None, Serial_Number=None):
        super(VolumeObjectType, self).__init__(object_reference, )
        self.is_mounted = _cast(bool, is_mounted)
        self.Name = Name
        self.Device_Path = Device_Path
        self.File_System_Type = File_System_Type
        self.Total_Allocation_Units = Total_Allocation_Units
        self.Sectors_Per_Allocation_Unit = Sectors_Per_Allocation_Unit
        self.Bytes_Per_Sector = Bytes_Per_Sector
        self.Actual_Available_Allocation_Units = Actual_Available_Allocation_Units
        self.Creation_Time = Creation_Time
        self.File_System_Flag_List = File_System_Flag_List
        self.Serial_Number = Serial_Number
    def factory(*args_, **kwargs_):
        if VolumeObjectType.subclass:
            return VolumeObjectType.subclass(*args_, **kwargs_)
        else:
            return VolumeObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Device_Path(self): return self.Device_Path
    def set_Device_Path(self, Device_Path): self.Device_Path = Device_Path
    def get_File_System_Type(self): return self.File_System_Type
    def set_File_System_Type(self, File_System_Type): self.File_System_Type = File_System_Type
    def get_Total_Allocation_Units(self): return self.Total_Allocation_Units
    def set_Total_Allocation_Units(self, Total_Allocation_Units): self.Total_Allocation_Units = Total_Allocation_Units
    def validate_UnsignedLongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedLongObjectAttributeType, a restriction on None.
        pass
    def get_Sectors_Per_Allocation_Unit(self): return self.Sectors_Per_Allocation_Unit
    def set_Sectors_Per_Allocation_Unit(self, Sectors_Per_Allocation_Unit): self.Sectors_Per_Allocation_Unit = Sectors_Per_Allocation_Unit
    def validate_UnsignedIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedIntegerObjectAttributeType, a restriction on None.
        pass
    def get_Bytes_Per_Sector(self): return self.Bytes_Per_Sector
    def set_Bytes_Per_Sector(self, Bytes_Per_Sector): self.Bytes_Per_Sector = Bytes_Per_Sector
    def validate_PositiveIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.PositiveIntegerObjectAttributeType, a restriction on None.
        pass
    def get_Actual_Available_Allocation_Units(self): return self.Actual_Available_Allocation_Units
    def set_Actual_Available_Allocation_Units(self, Actual_Available_Allocation_Units): self.Actual_Available_Allocation_Units = Actual_Available_Allocation_Units
    def get_Creation_Time(self): return self.Creation_Time
    def set_Creation_Time(self, Creation_Time): self.Creation_Time = Creation_Time
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_File_System_Flag_List(self): return self.File_System_Flag_List
    def set_File_System_Flag_List(self, File_System_Flag_List): self.File_System_Flag_List = File_System_Flag_List
    def get_Serial_Number(self): return self.Serial_Number
    def set_Serial_Number(self, Serial_Number): self.Serial_Number = Serial_Number
    def get_is_mounted(self): return self.is_mounted
    def set_is_mounted(self, is_mounted): self.is_mounted = is_mounted
    def export(self, outfile, level, namespace_='VolumeObj:', name_='VolumeObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VolumeObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='VolumeObj:', name_='VolumeObjectType'):
        super(VolumeObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VolumeObjectType')
        if self.is_mounted is not None and 'is_mounted' not in already_processed:
            already_processed.append('is_mounted')
            outfile.write(' is_mounted="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.is_mounted)), input_name='is_mounted'))
    def exportChildren(self, outfile, level, namespace_='VolumeObj:', name_='VolumeObjectType', fromsubclass_=False, pretty_print=True):
        super(VolumeObjectType, self).exportChildren(outfile, level, 'VolumeObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            self.Name.export(outfile, level, 'VolumeObj:', name_='Name', pretty_print=pretty_print)
        if self.Device_Path is not None:
            self.Device_Path.export(outfile, level, 'VolumeObj:', name_='Device_Path', pretty_print=pretty_print)
        if self.File_System_Type is not None:
            self.File_System_Type.export(outfile, level, 'VolumeObj:', name_='File_System_Type', pretty_print=pretty_print)
        if self.Total_Allocation_Units is not None:
            self.Total_Allocation_Units.export(outfile, level, 'VolumeObj:', name_='Total_Allocation_Units', pretty_print=pretty_print)
        if self.Sectors_Per_Allocation_Unit is not None:
            self.Sectors_Per_Allocation_Unit.export(outfile, level, 'VolumeObj:', name_='Sectors_Per_Allocation_Unit', pretty_print=pretty_print)
        if self.Bytes_Per_Sector is not None:
            self.Bytes_Per_Sector.export(outfile, level, 'VolumeObj:', name_='Bytes_Per_Sector', pretty_print=pretty_print)
        if self.Actual_Available_Allocation_Units is not None:
            self.Actual_Available_Allocation_Units.export(outfile, level, 'VolumeObj:', name_='Actual_Available_Allocation_Units', pretty_print=pretty_print)
        if self.Creation_Time is not None:
            self.Creation_Time.export(outfile, level, 'VolumeObj:', name_='Creation_Time', pretty_print=pretty_print)
        if self.File_System_Flag_List is not None:
            self.File_System_Flag_List.export(outfile, level, 'VolumeObj:', name_='File_System_Flag_List', pretty_print=pretty_print)
        if self.Serial_Number is not None:
            self.Serial_Number.export(outfile, level, 'VolumeObj:', name_='Serial_Number', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Device_Path is not None or
            self.File_System_Type is not None or
            self.Total_Allocation_Units is not None or
            self.Sectors_Per_Allocation_Unit is not None or
            self.Bytes_Per_Sector is not None or
            self.Actual_Available_Allocation_Units is not None or
            self.Creation_Time is not None or
            self.File_System_Flag_List is not None or
            self.Serial_Number is not None or
            super(VolumeObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VolumeObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_mounted is not None and 'is_mounted' not in already_processed:
            already_processed.append('is_mounted')
            showIndent(outfile, level)
            outfile.write('is_mounted = %s,\n' % (self.is_mounted,))
        super(VolumeObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VolumeObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Device_Path is not None:
            showIndent(outfile, level)
            outfile.write('Device_Path=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Device_Path.exportLiteral(outfile, level, name_='Device_Path')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_System_Type is not None:
            showIndent(outfile, level)
            outfile.write('File_System_Type=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.File_System_Type.exportLiteral(outfile, level, name_='File_System_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Total_Allocation_Units is not None:
            showIndent(outfile, level)
            outfile.write('Total_Allocation_Units=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.Total_Allocation_Units.exportLiteral(outfile, level, name_='Total_Allocation_Units')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Sectors_Per_Allocation_Unit is not None:
            showIndent(outfile, level)
            outfile.write('Sectors_Per_Allocation_Unit=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.Sectors_Per_Allocation_Unit.exportLiteral(outfile, level, name_='Sectors_Per_Allocation_Unit')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Bytes_Per_Sector is not None:
            showIndent(outfile, level)
            outfile.write('Bytes_Per_Sector=model_.cybox_common_types_1_0.PositiveIntegerObjectAttributeType(\n')
            self.Bytes_Per_Sector.exportLiteral(outfile, level, name_='Bytes_Per_Sector')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Actual_Available_Allocation_Units is not None:
            showIndent(outfile, level)
            outfile.write('Actual_Available_Allocation_Units=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.Actual_Available_Allocation_Units.exportLiteral(outfile, level, name_='Actual_Available_Allocation_Units')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Creation_Time is not None:
            showIndent(outfile, level)
            outfile.write('Creation_Time=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Creation_Time.exportLiteral(outfile, level, name_='Creation_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_System_Flag_List is not None:
            showIndent(outfile, level)
            outfile.write('File_System_Flag_List=model_.FileSystemFlagListType(\n')
            self.File_System_Flag_List.exportLiteral(outfile, level, name_='File_System_Flag_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Serial_Number is not None:
            showIndent(outfile, level)
            outfile.write('Serial_Number=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Serial_Number.exportLiteral(outfile, level, name_='Serial_Number')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_mounted', node)
        if value is not None and 'is_mounted' not in already_processed:
            already_processed.append('is_mounted')
            if value in ('true', '1'):
                self.is_mounted = True
            elif value in ('false', '0'):
                self.is_mounted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(VolumeObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Device_Path':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Device_Path(obj_)
        elif nodeName_ == 'File_System_Type':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_File_System_Type(obj_)
        elif nodeName_ == 'Total_Allocation_Units':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Total_Allocation_Units(obj_)
        elif nodeName_ == 'Sectors_Per_Allocation_Unit':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Sectors_Per_Allocation_Unit(obj_)
        elif nodeName_ == 'Bytes_Per_Sector':
            obj_ = cybox_common_types_1_0.PositiveIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Bytes_Per_Sector(obj_)
        elif nodeName_ == 'Actual_Available_Allocation_Units':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Actual_Available_Allocation_Units(obj_)
        elif nodeName_ == 'Creation_Time':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Creation_Time(obj_)
        elif nodeName_ == 'File_System_Flag_List':
            obj_ = FileSystemFlagListType.factory()
            obj_.build(child_)
            self.set_File_System_Flag_List(obj_)
        elif nodeName_ == 'Serial_Number':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Serial_Number(obj_)
        super(VolumeObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class VolumeObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Volume'
        rootClass = VolumeObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Volume'
        rootClass = VolumeObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Volume",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Volume'
        rootClass = VolumeObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "VolumeObjectType",
    "VolumeOptionsType",
    "FileSystemFlagListType",
    "VolumeFileSystemFlagType"
    ]