#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:03:47 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import account_object_1_2
import port_object_1_3

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class FullyQualifiedNameType(GeneratedsSuper):
    """The FullyQualifiedNameType type refers to the fully qualified
    name(s) of the Windows computer account."""
    subclass = None
    superclass = None
    def __init__(self, NetBEUI_Name=None, Full_Name=None):
        self.NetBEUI_Name = NetBEUI_Name
        self.Full_Name = Full_Name
    def factory(*args_, **kwargs_):
        if FullyQualifiedNameType.subclass:
            return FullyQualifiedNameType.subclass(*args_, **kwargs_)
        else:
            return FullyQualifiedNameType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NetBEUI_Name(self): return self.NetBEUI_Name
    def set_NetBEUI_Name(self, NetBEUI_Name): self.NetBEUI_Name = NetBEUI_Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Full_Name(self): return self.Full_Name
    def set_Full_Name(self, Full_Name): self.Full_Name = Full_Name
    def export(self, outfile, level, namespace_='WinComputerAccountObj:', name_='FullyQualifiedNameType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FullyQualifiedNameType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinComputerAccountObj:', name_='FullyQualifiedNameType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinComputerAccountObj:', name_='FullyQualifiedNameType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.NetBEUI_Name is not None:
            self.NetBEUI_Name.export(outfile, level, 'WinComputerAccountObj:', name_='NetBEUI_Name', pretty_print=pretty_print)
        if self.Full_Name is not None:
            self.Full_Name.export(outfile, level, 'WinComputerAccountObj:', name_='Full_Name', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.NetBEUI_Name is not None or
            self.Full_Name is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FullyQualifiedNameType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.NetBEUI_Name is not None:
            showIndent(outfile, level)
            outfile.write('NetBEUI_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.NetBEUI_Name.exportLiteral(outfile, level, name_='NetBEUI_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Full_Name is not None:
            showIndent(outfile, level)
            outfile.write('Full_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Full_Name.exportLiteral(outfile, level, name_='Full_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NetBEUI_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_NetBEUI_Name(obj_)
        elif nodeName_ == 'Full_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Full_Name(obj_)
# end class FullyQualifiedNameType

class KerberosType(GeneratedsSuper):
    """The KerberosType type specifies the Kerberos authentication protocol
    specific attributes for the Windows computer account."""
    subclass = None
    superclass = None
    def __init__(self, Delegation=None, Ticket=None):
        self.Delegation = Delegation
        self.Ticket = Ticket
    def factory(*args_, **kwargs_):
        if KerberosType.subclass:
            return KerberosType.subclass(*args_, **kwargs_)
        else:
            return KerberosType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Delegation(self): return self.Delegation
    def set_Delegation(self, Delegation): self.Delegation = Delegation
    def get_Ticket(self): return self.Ticket
    def set_Ticket(self, Ticket): self.Ticket = Ticket
    def validate_UnsignedLongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedLongObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinComputerAccountObj:', name_='KerberosType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='KerberosType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinComputerAccountObj:', name_='KerberosType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinComputerAccountObj:', name_='KerberosType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Delegation is not None:
            self.Delegation.export(outfile, level, 'WinComputerAccountObj:', name_='Delegation', pretty_print=pretty_print)
        if self.Ticket is not None:
            self.Ticket.export(outfile, level, 'WinComputerAccountObj:', name_='Ticket', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Delegation is not None or
            self.Ticket is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='KerberosType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Delegation is not None:
            showIndent(outfile, level)
            outfile.write('Delegation=model_.KerberosDelegationType(\n')
            self.Delegation.exportLiteral(outfile, level, name_='Delegation')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Ticket is not None:
            showIndent(outfile, level)
            outfile.write('Ticket=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.Ticket.exportLiteral(outfile, level, name_='Ticket')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Delegation':
            obj_ = KerberosDelegationType.factory()
            obj_.build(child_)
            self.set_Delegation(obj_)
        elif nodeName_ == 'Ticket':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Ticket(obj_)
# end class KerberosType

class KerberosDelegationType(GeneratedsSuper):
    """The Delegation element specifies the Kerberos delegation used for
    the Windows computer account."""
    subclass = None
    superclass = None
    def __init__(self, Bitmask=None, Service=None):
        self.Bitmask = Bitmask
        self.Service = Service
    def factory(*args_, **kwargs_):
        if KerberosDelegationType.subclass:
            return KerberosDelegationType.subclass(*args_, **kwargs_)
        else:
            return KerberosDelegationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Bitmask(self): return self.Bitmask
    def set_Bitmask(self, Bitmask): self.Bitmask = Bitmask
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Service(self): return self.Service
    def set_Service(self, Service): self.Service = Service
    def export(self, outfile, level, namespace_='WinComputerAccountObj:', name_='KerberosDelegationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='KerberosDelegationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinComputerAccountObj:', name_='KerberosDelegationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinComputerAccountObj:', name_='KerberosDelegationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Bitmask is not None:
            self.Bitmask.export(outfile, level, 'WinComputerAccountObj:', name_='Bitmask', pretty_print=pretty_print)
        if self.Service is not None:
            self.Service.export(outfile, level, 'WinComputerAccountObj:', name_='Service', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Bitmask is not None or
            self.Service is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='KerberosDelegationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Bitmask is not None:
            showIndent(outfile, level)
            outfile.write('Bitmask=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Bitmask.exportLiteral(outfile, level, name_='Bitmask')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Service is not None:
            showIndent(outfile, level)
            outfile.write('Service=model_.KerberosServiceType(\n')
            self.Service.exportLiteral(outfile, level, name_='Service')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Bitmask':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Bitmask(obj_)
        elif nodeName_ == 'Service':
            obj_ = KerberosServiceType.factory()
            obj_.build(child_)
            self.set_Service(obj_)
# end class KerberosDelegationType

class KerberosServiceType(GeneratedsSuper):
    """The KerberosServiceType specifies the attributes of the Kerberos
    delegation service for the Windows computer account."""
    subclass = None
    superclass = None
    def __init__(self, Computer=None, Name=None, Port=None, User=None):
        self.Computer = Computer
        self.Name = Name
        self.Port = Port
        self.User = User
    def factory(*args_, **kwargs_):
        if KerberosServiceType.subclass:
            return KerberosServiceType.subclass(*args_, **kwargs_)
        else:
            return KerberosServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Computer(self): return self.Computer
    def set_Computer(self, Computer): self.Computer = Computer
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Port(self): return self.Port
    def set_Port(self, Port): self.Port = Port
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def export(self, outfile, level, namespace_='WinComputerAccountObj:', name_='KerberosServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='KerberosServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinComputerAccountObj:', name_='KerberosServiceType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinComputerAccountObj:', name_='KerberosServiceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Computer is not None:
            self.Computer.export(outfile, level, 'WinComputerAccountObj:', name_='Computer', pretty_print=pretty_print)
        if self.Name is not None:
            self.Name.export(outfile, level, 'WinComputerAccountObj:', name_='Name', pretty_print=pretty_print)
        if self.Port is not None:
            self.Port.export(outfile, level, 'WinComputerAccountObj:', name_='Port', pretty_print=pretty_print)
        if self.User is not None:
            self.User.export(outfile, level, 'WinComputerAccountObj:', name_='User', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Computer is not None or
            self.Name is not None or
            self.Port is not None or
            self.User is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='KerberosServiceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Computer is not None:
            showIndent(outfile, level)
            outfile.write('Computer=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Computer.exportLiteral(outfile, level, name_='Computer')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Port is not None:
            showIndent(outfile, level)
            outfile.write('Port=model_.port_object_1_3.PortObjectType(\n')
            self.Port.exportLiteral(outfile, level, name_='Port')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.User is not None:
            showIndent(outfile, level)
            outfile.write('User=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.User.exportLiteral(outfile, level, name_='User')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Computer':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Computer(obj_)
        elif nodeName_ == 'Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Port':
            obj_ = port_object_1_3.PortObjectType.factory()
            obj_.build(child_)
            self.set_Port(obj_)
        elif nodeName_ == 'User':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_User(obj_)
# end class KerberosServiceType

class WinComputerAccountObjectType(account_object_1_2.AccountObjectType):
    """The WinComputerAccountObject type is intended to characterize
    Windows computer accounts."""
    subclass = None
    superclass = account_object_1_2.AccountObjectType
    def __init__(self, object_reference=None, disabled=None, locked_out=None, Description=None, Domain=None, Fully_Qualified_Name=None, Kerberos=None, Security_ID=None, Security_Type=None, Type=None):
        super(WinComputerAccountObjectType, self).__init__(object_reference, disabled, locked_out, Description, Domain, )
        self.Fully_Qualified_Name = Fully_Qualified_Name
        self.Kerberos = Kerberos
        self.Security_ID = Security_ID
        self.Security_Type = Security_Type
        self.Type = Type
    def factory(*args_, **kwargs_):
        if WinComputerAccountObjectType.subclass:
            return WinComputerAccountObjectType.subclass(*args_, **kwargs_)
        else:
            return WinComputerAccountObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Fully_Qualified_Name(self): return self.Fully_Qualified_Name
    def set_Fully_Qualified_Name(self, Fully_Qualified_Name): self.Fully_Qualified_Name = Fully_Qualified_Name
    def get_Kerberos(self): return self.Kerberos
    def set_Kerberos(self, Kerberos): self.Kerberos = Kerberos
    def get_Security_ID(self): return self.Security_ID
    def set_Security_ID(self, Security_ID): self.Security_ID = Security_ID
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Security_Type(self): return self.Security_Type
    def set_Security_Type(self, Security_Type): self.Security_Type = Security_Type
    def validate_SIDType(self, value):
        # Validate type cybox_common_types_1_0.SIDType, a restriction on None.
        pass
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def export(self, outfile, level, namespace_='WinComputerAccountObj:', name_='WinComputerAccountObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WinComputerAccountObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinComputerAccountObj:', name_='WinComputerAccountObjectType'):
        super(WinComputerAccountObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WinComputerAccountObjectType')
    def exportChildren(self, outfile, level, namespace_='WinComputerAccountObj:', name_='WinComputerAccountObjectType', fromsubclass_=False, pretty_print=True):
        super(WinComputerAccountObjectType, self).exportChildren(outfile, level, 'WinComputerAccountObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Fully_Qualified_Name is not None:
            self.Fully_Qualified_Name.export(outfile, level, 'WinComputerAccountObj:', name_='Fully_Qualified_Name', pretty_print=pretty_print)
        if self.Kerberos is not None:
            self.Kerberos.export(outfile, level, 'WinComputerAccountObj:', name_='Kerberos', pretty_print=pretty_print)
        if self.Security_ID is not None:
            self.Security_ID.export(outfile, level, 'WinComputerAccountObj:', name_='Security_ID', pretty_print=pretty_print)
        if self.Security_Type is not None:
            self.Security_Type.export(outfile, level, 'WinComputerAccountObj:', name_='Security_Type', pretty_print=pretty_print)
        if self.Type is not None:
            self.Type.export(outfile, level, 'WinComputerAccountObj:', name_='Type', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Fully_Qualified_Name is not None or
            self.Kerberos is not None or
            self.Security_ID is not None or
            self.Security_Type is not None or
            self.Type is not None or
            super(WinComputerAccountObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WinComputerAccountObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WinComputerAccountObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WinComputerAccountObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Fully_Qualified_Name is not None:
            showIndent(outfile, level)
            outfile.write('Fully_Qualified_Name=model_.FullyQualifiedNameType(\n')
            self.Fully_Qualified_Name.exportLiteral(outfile, level, name_='Fully_Qualified_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Kerberos is not None:
            showIndent(outfile, level)
            outfile.write('Kerberos=model_.KerberosType(\n')
            self.Kerberos.exportLiteral(outfile, level, name_='Kerberos')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Security_ID is not None:
            showIndent(outfile, level)
            outfile.write('Security_ID=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Security_ID.exportLiteral(outfile, level, name_='Security_ID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Security_Type is not None:
            showIndent(outfile, level)
            outfile.write('Security_Type=model_.cybox_common_types_1_0.SIDType(\n')
            self.Security_Type.exportLiteral(outfile, level, name_='Security_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Type is not None:
            showIndent(outfile, level)
            outfile.write('Type=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WinComputerAccountObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Fully_Qualified_Name':
            obj_ = FullyQualifiedNameType.factory()
            obj_.build(child_)
            self.set_Fully_Qualified_Name(obj_)
        elif nodeName_ == 'Kerberos':
            obj_ = KerberosType.factory()
            obj_.build(child_)
            self.set_Kerberos(obj_)
        elif nodeName_ == 'Security_ID':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Security_ID(obj_)
        elif nodeName_ == 'Security_Type':
            obj_ = cybox_common_types_1_0.SIDType.factory()
            obj_.build(child_)
            self.set_Security_Type(obj_)
        elif nodeName_ == 'Type':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
        super(WinComputerAccountObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WinComputerAccountObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Computer_Account'
        rootClass = WinComputerAccountObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Computer_Account'
        rootClass = WinComputerAccountObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Computer_Account",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Computer_Account'
        rootClass = WinComputerAccountObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WinComputerAccountObjectType",
    "FullyQualifiedNameType",
    "KerberosType",
    "KerberosDelegationType",
    "KerberosServiceType"
    ]