#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:04:15 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import win_handle_object_1_3
import pipe_object_1_3
import cybox_common_types_1_0

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class WindowsPipeObjectType(pipe_object_1_3.PipeObjectType):
    """The WindowsPipeObjectType type is intended to characterize Windows
    pipes."""
    subclass = None
    superclass = pipe_object_1_3.PipeObjectType
    def __init__(self, object_reference=None, named=None, Name=None, Default_Time_Out=None, Handle=None, In_Buffer_Size=None, Max_Instances=None, Open_Mode=None, Out_Buffer_Size=None, Pipe_Mode=None, Security_Attributes=None):
        super(WindowsPipeObjectType, self).__init__(object_reference, named, Name, )
        self.Default_Time_Out = Default_Time_Out
        self.Handle = Handle
        self.In_Buffer_Size = In_Buffer_Size
        self.Max_Instances = Max_Instances
        self.Open_Mode = Open_Mode
        self.Out_Buffer_Size = Out_Buffer_Size
        self.Pipe_Mode = Pipe_Mode
        self.Security_Attributes = Security_Attributes
    def factory(*args_, **kwargs_):
        if WindowsPipeObjectType.subclass:
            return WindowsPipeObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsPipeObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Default_Time_Out(self): return self.Default_Time_Out
    def set_Default_Time_Out(self, Default_Time_Out): self.Default_Time_Out = Default_Time_Out
    def validate_NonNegativeIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType, a restriction on None.
        pass
    def get_Handle(self): return self.Handle
    def set_Handle(self, Handle): self.Handle = Handle
    def get_In_Buffer_Size(self): return self.In_Buffer_Size
    def set_In_Buffer_Size(self, In_Buffer_Size): self.In_Buffer_Size = In_Buffer_Size
    def get_Max_Instances(self): return self.Max_Instances
    def set_Max_Instances(self, Max_Instances): self.Max_Instances = Max_Instances
    def get_Open_Mode(self): return self.Open_Mode
    def set_Open_Mode(self, Open_Mode): self.Open_Mode = Open_Mode
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Out_Buffer_Size(self): return self.Out_Buffer_Size
    def set_Out_Buffer_Size(self, Out_Buffer_Size): self.Out_Buffer_Size = Out_Buffer_Size
    def get_Pipe_Mode(self): return self.Pipe_Mode
    def set_Pipe_Mode(self, Pipe_Mode): self.Pipe_Mode = Pipe_Mode
    def get_Security_Attributes(self): return self.Security_Attributes
    def set_Security_Attributes(self, Security_Attributes): self.Security_Attributes = Security_Attributes
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinPipeObj:', name_='WindowsPipeObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsPipeObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinPipeObj:', name_='WindowsPipeObjectType'):
        super(WindowsPipeObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsPipeObjectType')
    def exportChildren(self, outfile, level, namespace_='WinPipeObj:', name_='WindowsPipeObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsPipeObjectType, self).exportChildren(outfile, level, 'WinPipeObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Default_Time_Out is not None:
            self.Default_Time_Out.export(outfile, level, 'WinPipeObj:', name_='Default_Time_Out', pretty_print=pretty_print)
        if self.Handle is not None:
            self.Handle.export(outfile, level, 'WinPipeObj:', name_='Handle', pretty_print=pretty_print)
        if self.In_Buffer_Size is not None:
            self.In_Buffer_Size.export(outfile, level, 'WinPipeObj:', name_='In_Buffer_Size', pretty_print=pretty_print)
        if self.Max_Instances is not None:
            self.Max_Instances.export(outfile, level, 'WinPipeObj:', name_='Max_Instances', pretty_print=pretty_print)
        if self.Open_Mode is not None:
            self.Open_Mode.export(outfile, level, 'WinPipeObj:', name_='Open_Mode', pretty_print=pretty_print)
        if self.Out_Buffer_Size is not None:
            self.Out_Buffer_Size.export(outfile, level, 'WinPipeObj:', name_='Out_Buffer_Size', pretty_print=pretty_print)
        if self.Pipe_Mode is not None:
            self.Pipe_Mode.export(outfile, level, 'WinPipeObj:', name_='Pipe_Mode', pretty_print=pretty_print)
        if self.Security_Attributes is not None:
            self.Security_Attributes.export(outfile, level, 'WinPipeObj:', name_='Security_Attributes', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Default_Time_Out is not None or
            self.Handle is not None or
            self.In_Buffer_Size is not None or
            self.Max_Instances is not None or
            self.Open_Mode is not None or
            self.Out_Buffer_Size is not None or
            self.Pipe_Mode is not None or
            self.Security_Attributes is not None or
            super(WindowsPipeObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsPipeObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsPipeObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsPipeObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Default_Time_Out is not None:
            showIndent(outfile, level)
            outfile.write('Default_Time_Out=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.Default_Time_Out.exportLiteral(outfile, level, name_='Default_Time_Out')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Handle is not None:
            showIndent(outfile, level)
            outfile.write('Handle=model_.win_handle_object_1_3.WindowsHandleObjectType(\n')
            self.Handle.exportLiteral(outfile, level, name_='Handle')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.In_Buffer_Size is not None:
            showIndent(outfile, level)
            outfile.write('In_Buffer_Size=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.In_Buffer_Size.exportLiteral(outfile, level, name_='In_Buffer_Size')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Max_Instances is not None:
            showIndent(outfile, level)
            outfile.write('Max_Instances=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.Max_Instances.exportLiteral(outfile, level, name_='Max_Instances')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Open_Mode is not None:
            showIndent(outfile, level)
            outfile.write('Open_Mode=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Open_Mode.exportLiteral(outfile, level, name_='Open_Mode')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Out_Buffer_Size is not None:
            showIndent(outfile, level)
            outfile.write('Out_Buffer_Size=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.Out_Buffer_Size.exportLiteral(outfile, level, name_='Out_Buffer_Size')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pipe_Mode is not None:
            showIndent(outfile, level)
            outfile.write('Pipe_Mode=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Pipe_Mode.exportLiteral(outfile, level, name_='Pipe_Mode')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Security_Attributes=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Security_Attributes.exportLiteral(outfile, level, name_='Security_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsPipeObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Default_Time_Out':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Default_Time_Out(obj_)
        elif nodeName_ == 'Handle':
            obj_ = win_handle_object_1_3.WindowsHandleObjectType.factory()
            obj_.build(child_)
            self.set_Handle(obj_)
        elif nodeName_ == 'In_Buffer_Size':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_In_Buffer_Size(obj_)
        elif nodeName_ == 'Max_Instances':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Max_Instances(obj_)
        elif nodeName_ == 'Open_Mode':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Open_Mode(obj_)
        elif nodeName_ == 'Out_Buffer_Size':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Out_Buffer_Size(obj_)
        elif nodeName_ == 'Pipe_Mode':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Pipe_Mode(obj_)
        elif nodeName_ == 'Security_Attributes':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Security_Attributes(obj_)
        super(WindowsPipeObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsPipeObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Pipe'
        rootClass = WindowsPipeObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Pipe'
        rootClass = WindowsPipeObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Pipe",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Pipe'
        rootClass = WindowsPipeObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsPipeObjectType"
    ]