#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:04:17 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import win_volume_object_1_3
import device_object_1_1

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class AccessedFileListType(GeneratedsSuper):
    """The AccessedFileListType specifies a list of files accessed by a
    prefetch application."""
    subclass = None
    superclass = None
    def __init__(self, Accessed_Filename=None):
        if Accessed_Filename is None:
            self.Accessed_Filename = []
        else:
            self.Accessed_Filename = Accessed_Filename
    def factory(*args_, **kwargs_):
        if AccessedFileListType.subclass:
            return AccessedFileListType.subclass(*args_, **kwargs_)
        else:
            return AccessedFileListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Accessed_Filename(self): return self.Accessed_Filename
    def set_Accessed_Filename(self, Accessed_Filename): self.Accessed_Filename = Accessed_Filename
    def add_Accessed_Filename(self, value): self.Accessed_Filename.append(value)
    def insert_Accessed_Filename(self, index, value): self.Accessed_Filename[index] = value
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinPrefetchObj:', name_='AccessedFileListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AccessedFileListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinPrefetchObj:', name_='AccessedFileListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinPrefetchObj:', name_='AccessedFileListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Accessed_Filename_ in self.Accessed_Filename:
            Accessed_Filename_.export(outfile, level, 'WinPrefetchObj:', name_='Accessed_Filename', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Accessed_Filename
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AccessedFileListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Accessed_Filename=[\n')
        level += 1
        for Accessed_Filename_ in self.Accessed_Filename:
            showIndent(outfile, level)
            outfile.write('model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            Accessed_Filename_.exportLiteral(outfile, level, name_='cybox_common_types_1_0.StringObjectAttributeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Accessed_Filename':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.Accessed_Filename.append(obj_)
# end class AccessedFileListType

class AccessedDirectoryListType(GeneratedsSuper):
    """The AccessedDirectoryListType specifies a list of directories
    accessed by a prefetch application."""
    subclass = None
    superclass = None
    def __init__(self, Accessed_Directory=None):
        if Accessed_Directory is None:
            self.Accessed_Directory = []
        else:
            self.Accessed_Directory = Accessed_Directory
    def factory(*args_, **kwargs_):
        if AccessedDirectoryListType.subclass:
            return AccessedDirectoryListType.subclass(*args_, **kwargs_)
        else:
            return AccessedDirectoryListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Accessed_Directory(self): return self.Accessed_Directory
    def set_Accessed_Directory(self, Accessed_Directory): self.Accessed_Directory = Accessed_Directory
    def add_Accessed_Directory(self, value): self.Accessed_Directory.append(value)
    def insert_Accessed_Directory(self, index, value): self.Accessed_Directory[index] = value
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinPrefetchObj:', name_='AccessedDirectoryListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AccessedDirectoryListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinPrefetchObj:', name_='AccessedDirectoryListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinPrefetchObj:', name_='AccessedDirectoryListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Accessed_Directory_ in self.Accessed_Directory:
            Accessed_Directory_.export(outfile, level, 'WinPrefetchObj:', name_='Accessed_Directory', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Accessed_Directory
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AccessedDirectoryListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Accessed_Directory=[\n')
        level += 1
        for Accessed_Directory_ in self.Accessed_Directory:
            showIndent(outfile, level)
            outfile.write('model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            Accessed_Directory_.exportLiteral(outfile, level, name_='cybox_common_types_1_0.StringObjectAttributeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Accessed_Directory':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.Accessed_Directory.append(obj_)
# end class AccessedDirectoryListType

class VolumeType(GeneratedsSuper):
    """VolumeType characterizes the volume information in the Windows
    prefetch file."""
    subclass = None
    superclass = None
    def __init__(self, VolumeItem=None, DeviceItem=None):
        if VolumeItem is None:
            self.VolumeItem = []
        else:
            self.VolumeItem = VolumeItem
        if DeviceItem is None:
            self.DeviceItem = []
        else:
            self.DeviceItem = DeviceItem
    def factory(*args_, **kwargs_):
        if VolumeType.subclass:
            return VolumeType.subclass(*args_, **kwargs_)
        else:
            return VolumeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_VolumeItem(self): return self.VolumeItem
    def set_VolumeItem(self, VolumeItem): self.VolumeItem = VolumeItem
    def add_VolumeItem(self, value): self.VolumeItem.append(value)
    def insert_VolumeItem(self, index, value): self.VolumeItem[index] = value
    def get_DeviceItem(self): return self.DeviceItem
    def set_DeviceItem(self, DeviceItem): self.DeviceItem = DeviceItem
    def add_DeviceItem(self, value): self.DeviceItem.append(value)
    def insert_DeviceItem(self, index, value): self.DeviceItem[index] = value
    def export(self, outfile, level, namespace_='WinPrefetchObj:', name_='VolumeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VolumeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinPrefetchObj:', name_='VolumeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinPrefetchObj:', name_='VolumeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for VolumeItem_ in self.VolumeItem:
            VolumeItem_.export(outfile, level, 'WinPrefetchObj:', name_='VolumeItem', pretty_print=pretty_print)
        for DeviceItem_ in self.DeviceItem:
            DeviceItem_.export(outfile, level, 'WinPrefetchObj:', name_='DeviceItem', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.VolumeItem or
            self.DeviceItem
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VolumeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('VolumeItem=[\n')
        level += 1
        for VolumeItem_ in self.VolumeItem:
            showIndent(outfile, level)
            outfile.write('model_.win_volume_object_1_3.WindowsVolumeObjectType(\n')
            VolumeItem_.exportLiteral(outfile, level, name_='win_volume_object_1_3.WindowsVolumeObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('DeviceItem=[\n')
        level += 1
        for DeviceItem_ in self.DeviceItem:
            showIndent(outfile, level)
            outfile.write('model_.device_object_1_1.DeviceObjectType(\n')
            DeviceItem_.exportLiteral(outfile, level, name_='device_object_1_1.DeviceObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'VolumeItem':
            obj_ = win_volume_object_1_3.WindowsVolumeObjectType.factory()
            obj_.build(child_)
            self.VolumeItem.append(obj_)
        elif nodeName_ == 'DeviceItem':
            obj_ = device_object_1_1.DeviceObjectType.factory()
            obj_.build(child_)
            self.DeviceItem.append(obj_)
# end class VolumeType

class WindowsPrefetchObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The WindowsPrefetchObjectType type is intended to characterize
    entries in the Windows prefetch files. Starting with Windows XP,
    prefetching was introduced to speed up application startup. The
    prefetch object draws upon the descriptions and XML sample at
    http://www.forensicswiki.org/wiki/Prefetch_XML"""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, Application_File_Name=None, Prefetch_Hash=None, Times_Executed=None, First_Run=None, Last_Run=None, Volume=None, Accessed_File_List=None, Accessed_Directory_List=None):
        super(WindowsPrefetchObjectType, self).__init__(object_reference, )
        self.Application_File_Name = Application_File_Name
        self.Prefetch_Hash = Prefetch_Hash
        self.Times_Executed = Times_Executed
        self.First_Run = First_Run
        self.Last_Run = Last_Run
        self.Volume = Volume
        self.Accessed_File_List = Accessed_File_List
        self.Accessed_Directory_List = Accessed_Directory_List
    def factory(*args_, **kwargs_):
        if WindowsPrefetchObjectType.subclass:
            return WindowsPrefetchObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsPrefetchObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Application_File_Name(self): return self.Application_File_Name
    def set_Application_File_Name(self, Application_File_Name): self.Application_File_Name = Application_File_Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Prefetch_Hash(self): return self.Prefetch_Hash
    def set_Prefetch_Hash(self, Prefetch_Hash): self.Prefetch_Hash = Prefetch_Hash
    def get_Times_Executed(self): return self.Times_Executed
    def set_Times_Executed(self, Times_Executed): self.Times_Executed = Times_Executed
    def validate_LongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.LongObjectAttributeType, a restriction on None.
        pass
    def get_First_Run(self): return self.First_Run
    def set_First_Run(self, First_Run): self.First_Run = First_Run
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Last_Run(self): return self.Last_Run
    def set_Last_Run(self, Last_Run): self.Last_Run = Last_Run
    def get_Volume(self): return self.Volume
    def set_Volume(self, Volume): self.Volume = Volume
    def get_Accessed_File_List(self): return self.Accessed_File_List
    def set_Accessed_File_List(self, Accessed_File_List): self.Accessed_File_List = Accessed_File_List
    def get_Accessed_Directory_List(self): return self.Accessed_Directory_List
    def set_Accessed_Directory_List(self, Accessed_Directory_List): self.Accessed_Directory_List = Accessed_Directory_List
    def export(self, outfile, level, namespace_='WinPrefetchObj:', name_='WindowsPrefetchObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsPrefetchObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinPrefetchObj:', name_='WindowsPrefetchObjectType'):
        super(WindowsPrefetchObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsPrefetchObjectType')
    def exportChildren(self, outfile, level, namespace_='WinPrefetchObj:', name_='WindowsPrefetchObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsPrefetchObjectType, self).exportChildren(outfile, level, 'WinPrefetchObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Application_File_Name is not None:
            self.Application_File_Name.export(outfile, level, 'WinPrefetchObj:', name_='Application_File_Name', pretty_print=pretty_print)
        if self.Prefetch_Hash is not None:
            self.Prefetch_Hash.export(outfile, level, 'WinPrefetchObj:', name_='Prefetch_Hash', pretty_print=pretty_print)
        if self.Times_Executed is not None:
            self.Times_Executed.export(outfile, level, 'WinPrefetchObj:', name_='Times_Executed', pretty_print=pretty_print)
        if self.First_Run is not None:
            self.First_Run.export(outfile, level, 'WinPrefetchObj:', name_='First_Run', pretty_print=pretty_print)
        if self.Last_Run is not None:
            self.Last_Run.export(outfile, level, 'WinPrefetchObj:', name_='Last_Run', pretty_print=pretty_print)
        if self.Volume is not None:
            self.Volume.export(outfile, level, 'WinPrefetchObj:', name_='Volume', pretty_print=pretty_print)
        if self.Accessed_File_List is not None:
            self.Accessed_File_List.export(outfile, level, 'WinPrefetchObj:', name_='Accessed_File_List', pretty_print=pretty_print)
        if self.Accessed_Directory_List is not None:
            self.Accessed_Directory_List.export(outfile, level, 'WinPrefetchObj:', name_='Accessed_Directory_List', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Application_File_Name is not None or
            self.Prefetch_Hash is not None or
            self.Times_Executed is not None or
            self.First_Run is not None or
            self.Last_Run is not None or
            self.Volume is not None or
            self.Accessed_File_List is not None or
            self.Accessed_Directory_List is not None or
            super(WindowsPrefetchObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsPrefetchObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsPrefetchObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsPrefetchObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Application_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Application_File_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Application_File_Name.exportLiteral(outfile, level, name_='Application_File_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Prefetch_Hash is not None:
            showIndent(outfile, level)
            outfile.write('Prefetch_Hash=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Prefetch_Hash.exportLiteral(outfile, level, name_='Prefetch_Hash')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Times_Executed is not None:
            showIndent(outfile, level)
            outfile.write('Times_Executed=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.Times_Executed.exportLiteral(outfile, level, name_='Times_Executed')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.First_Run is not None:
            showIndent(outfile, level)
            outfile.write('First_Run=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.First_Run.exportLiteral(outfile, level, name_='First_Run')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Last_Run is not None:
            showIndent(outfile, level)
            outfile.write('Last_Run=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Last_Run.exportLiteral(outfile, level, name_='Last_Run')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Volume is not None:
            showIndent(outfile, level)
            outfile.write('Volume=model_.VolumeType(\n')
            self.Volume.exportLiteral(outfile, level, name_='Volume')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Accessed_File_List is not None:
            showIndent(outfile, level)
            outfile.write('Accessed_File_List=model_.AccessedFileListType(\n')
            self.Accessed_File_List.exportLiteral(outfile, level, name_='Accessed_File_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Accessed_Directory_List is not None:
            showIndent(outfile, level)
            outfile.write('Accessed_Directory_List=model_.AccessedDirectoryListType(\n')
            self.Accessed_Directory_List.exportLiteral(outfile, level, name_='Accessed_Directory_List')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsPrefetchObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Application_File_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Application_File_Name(obj_)
        elif nodeName_ == 'Prefetch_Hash':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Prefetch_Hash(obj_)
        elif nodeName_ == 'Times_Executed':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Times_Executed(obj_)
        elif nodeName_ == 'First_Run':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_First_Run(obj_)
        elif nodeName_ == 'Last_Run':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Last_Run(obj_)
        elif nodeName_ == 'Volume':
            obj_ = VolumeType.factory()
            obj_.build(child_)
            self.set_Volume(obj_)
        elif nodeName_ == 'Accessed_File_List':
            obj_ = AccessedFileListType.factory()
            obj_.build(child_)
            self.set_Accessed_File_List(obj_)
        elif nodeName_ == 'Accessed_Directory_List':
            obj_ = AccessedDirectoryListType.factory()
            obj_.build(child_)
            self.set_Accessed_Directory_List(obj_)
        super(WindowsPrefetchObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsPrefetchObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Prefetch_Entry'
        rootClass = WindowsPrefetchObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Prefetch_Entry'
        rootClass = WindowsPrefetchObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Prefetch_Entry",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Prefetch_Entry'
        rootClass = WindowsPrefetchObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsPrefetchObjectType",
    "AccessedFileListType",
    "AccessedDirectoryListType",
    "VolumeType"
    ]