#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:04:23 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import win_process_object_1_3

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class ServiceDescriptionListType(GeneratedsSuper):
    """A collection of service descriptions."""
    subclass = None
    superclass = None
    def __init__(self, Description=None):
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
    def factory(*args_, **kwargs_):
        if ServiceDescriptionListType.subclass:
            return ServiceDescriptionListType.subclass(*args_, **kwargs_)
        else:
            return ServiceDescriptionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def add_Description(self, value): self.Description.append(value)
    def insert_Description(self, index, value): self.Description[index] = value
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinServiceObj:', name_='ServiceDescriptionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceDescriptionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinServiceObj:', name_='ServiceDescriptionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinServiceObj:', name_='ServiceDescriptionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Description_ in self.Description:
            Description_.export(outfile, level, 'WinServiceObj:', name_='Description', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Description
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ServiceDescriptionListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Description=[\n')
        level += 1
        for Description_ in self.Description:
            showIndent(outfile, level)
            outfile.write('model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            Description_.exportLiteral(outfile, level, name_='cybox_common_types_1_0.StringObjectAttributeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.Description.append(obj_)
# end class ServiceDescriptionListType

class ServiceType(cybox_common_types_1_0.BaseObjectAttributeType):
    """ServiceType specifies Windows service types via a union of the
    ServiceTypeEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(ServiceType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ServiceType.subclass:
            return ServiceType.subclass(*args_, **kwargs_)
        else:
            return ServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinServiceObj:', name_='ServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinServiceObj:', name_='ServiceType'):
        super(ServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinServiceObj:', name_='ServiceType', fromsubclass_=False, pretty_print=True):
        super(ServiceType, self).exportChildren(outfile, level, 'WinServiceObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(ServiceType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ServiceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(ServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ServiceType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(ServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ServiceType

class ServiceStatusType(cybox_common_types_1_0.BaseObjectAttributeType):
    """ServiceModeType specifies Windows service states via a union of the
    ServiceStatusEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(ServiceStatusType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ServiceStatusType.subclass:
            return ServiceStatusType.subclass(*args_, **kwargs_)
        else:
            return ServiceStatusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinServiceObj:', name_='ServiceStatusType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceStatusType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinServiceObj:', name_='ServiceStatusType'):
        super(ServiceStatusType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceStatusType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinServiceObj:', name_='ServiceStatusType', fromsubclass_=False, pretty_print=True):
        super(ServiceStatusType, self).exportChildren(outfile, level, 'WinServiceObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(ServiceStatusType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ServiceStatusType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(ServiceStatusType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ServiceStatusType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(ServiceStatusType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ServiceStatusType

class ServiceModeType(cybox_common_types_1_0.BaseObjectAttributeType):
    """ServiceModeType specifies Windows service modes via a union of the
    ServiceModeEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(ServiceModeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ServiceModeType.subclass:
            return ServiceModeType.subclass(*args_, **kwargs_)
        else:
            return ServiceModeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinServiceObj:', name_='ServiceModeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceModeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinServiceObj:', name_='ServiceModeType'):
        super(ServiceModeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceModeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinServiceObj:', name_='ServiceModeType', fromsubclass_=False, pretty_print=True):
        super(ServiceModeType, self).exportChildren(outfile, level, 'WinServiceObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(ServiceModeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ServiceModeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(ServiceModeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ServiceModeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(ServiceModeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ServiceModeType

class WindowsServiceObjectType(win_process_object_1_3.WindowsProcessObjectType):
    """The WindowsServiceObjectType type is intended to characterize
    Windows services.Indicates whether or not the DLL is
    signed.Indicates whether or not the DLL's signature was
    verified."""
    subclass = None
    superclass = win_process_object_1_3.WindowsProcessObjectType
    def __init__(self, object_reference=None, is_hidden=None, PID=None, Name=None, Creation_Time=None, Parent_PID=None, Child_PID_List=None, Image_Info=None, Argument_List=None, Environment_Variable_List=None, Kernel_Time=None, Port_List=None, Network_Connection_List=None, Start_Time=None, Status=None, String_List=None, Username=None, User_Time=None, aslr_enabled=None, dep_enabled=None, Handle_List=None, Priority=None, Section_List=None, Security_ID=None, Startup_Info=None, Security_Type=None, Window_Title=None, service_dll_signature_verified=None, service_dll_signature_exists=None, Description_List=None, Display_Name=None, Group_Name=None, Service_Name=None, Service_DLL=None, Service_DLL_Certificate_Issuer=None, Service_DLL_Certificate_Subject=None, Service_DLL_Hashes=None, Service_DLL_Signature_Description=None, Startup_Command_Line=None, Startup_Type=None, Service_Status=None, Service_Type=None, Started_As=None):
        super(WindowsServiceObjectType, self).__init__(object_reference, is_hidden, PID, Name, Creation_Time, Parent_PID, Child_PID_List, Image_Info, Argument_List, Environment_Variable_List, Kernel_Time, Port_List, Network_Connection_List, Start_Time, Status, String_List, Username, User_Time, aslr_enabled, dep_enabled, Handle_List, Priority, Section_List, Security_ID, Startup_Info, Security_Type, Window_Title, )
        self.service_dll_signature_verified = _cast(bool, service_dll_signature_verified)
        self.service_dll_signature_exists = _cast(bool, service_dll_signature_exists)
        self.Description_List = Description_List
        self.Display_Name = Display_Name
        self.Group_Name = Group_Name
        self.Service_Name = Service_Name
        self.Service_DLL = Service_DLL
        self.Service_DLL_Certificate_Issuer = Service_DLL_Certificate_Issuer
        self.Service_DLL_Certificate_Subject = Service_DLL_Certificate_Subject
        self.Service_DLL_Hashes = Service_DLL_Hashes
        self.Service_DLL_Signature_Description = Service_DLL_Signature_Description
        self.Startup_Command_Line = Startup_Command_Line
        self.Startup_Type = Startup_Type
        self.Service_Status = Service_Status
        self.Service_Type = Service_Type
        self.Started_As = Started_As
    def factory(*args_, **kwargs_):
        if WindowsServiceObjectType.subclass:
            return WindowsServiceObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsServiceObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description_List(self): return self.Description_List
    def set_Description_List(self, Description_List): self.Description_List = Description_List
    def get_Display_Name(self): return self.Display_Name
    def set_Display_Name(self, Display_Name): self.Display_Name = Display_Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Group_Name(self): return self.Group_Name
    def set_Group_Name(self, Group_Name): self.Group_Name = Group_Name
    def get_Service_Name(self): return self.Service_Name
    def set_Service_Name(self, Service_Name): self.Service_Name = Service_Name
    def get_Service_DLL(self): return self.Service_DLL
    def set_Service_DLL(self, Service_DLL): self.Service_DLL = Service_DLL
    def get_Service_DLL_Certificate_Issuer(self): return self.Service_DLL_Certificate_Issuer
    def set_Service_DLL_Certificate_Issuer(self, Service_DLL_Certificate_Issuer): self.Service_DLL_Certificate_Issuer = Service_DLL_Certificate_Issuer
    def get_Service_DLL_Certificate_Subject(self): return self.Service_DLL_Certificate_Subject
    def set_Service_DLL_Certificate_Subject(self, Service_DLL_Certificate_Subject): self.Service_DLL_Certificate_Subject = Service_DLL_Certificate_Subject
    def get_Service_DLL_Hashes(self): return self.Service_DLL_Hashes
    def set_Service_DLL_Hashes(self, Service_DLL_Hashes): self.Service_DLL_Hashes = Service_DLL_Hashes
    def get_Service_DLL_Signature_Description(self): return self.Service_DLL_Signature_Description
    def set_Service_DLL_Signature_Description(self, Service_DLL_Signature_Description): self.Service_DLL_Signature_Description = Service_DLL_Signature_Description
    def get_Startup_Command_Line(self): return self.Startup_Command_Line
    def set_Startup_Command_Line(self, Startup_Command_Line): self.Startup_Command_Line = Startup_Command_Line
    def get_Startup_Type(self): return self.Startup_Type
    def set_Startup_Type(self, Startup_Type): self.Startup_Type = Startup_Type
    def validate_ServiceModeType(self, value):
        # Validate type ServiceModeType, a restriction on None.
        pass
    def get_Service_Status(self): return self.Service_Status
    def set_Service_Status(self, Service_Status): self.Service_Status = Service_Status
    def validate_ServiceStatusType(self, value):
        # Validate type ServiceStatusType, a restriction on None.
        pass
    def get_Service_Type(self): return self.Service_Type
    def set_Service_Type(self, Service_Type): self.Service_Type = Service_Type
    def validate_ServiceType(self, value):
        # Validate type ServiceType, a restriction on None.
        pass
    def get_Started_As(self): return self.Started_As
    def set_Started_As(self, Started_As): self.Started_As = Started_As
    def get_service_dll_signature_verified(self): return self.service_dll_signature_verified
    def set_service_dll_signature_verified(self, service_dll_signature_verified): self.service_dll_signature_verified = service_dll_signature_verified
    def get_service_dll_signature_exists(self): return self.service_dll_signature_exists
    def set_service_dll_signature_exists(self, service_dll_signature_exists): self.service_dll_signature_exists = service_dll_signature_exists
    def export(self, outfile, level, namespace_='WinServiceObj:', name_='WindowsServiceObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsServiceObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinServiceObj:', name_='WindowsServiceObjectType'):
        super(WindowsServiceObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsServiceObjectType')
        if self.service_dll_signature_verified is not None and 'service_dll_signature_verified' not in already_processed:
            already_processed.append('service_dll_signature_verified')
            outfile.write(' service_dll_signature_verified="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.service_dll_signature_verified)), input_name='service_dll_signature_verified'))
        if self.service_dll_signature_exists is not None and 'service_dll_signature_exists' not in already_processed:
            already_processed.append('service_dll_signature_exists')
            outfile.write(' service_dll_signature_exists="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.service_dll_signature_exists)), input_name='service_dll_signature_exists'))
    def exportChildren(self, outfile, level, namespace_='WinServiceObj:', name_='WindowsServiceObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsServiceObjectType, self).exportChildren(outfile, level, 'WinServiceObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description_List is not None:
            self.Description_List.export(outfile, level, 'WinServiceObj:', name_='Description_List', pretty_print=pretty_print)
        if self.Display_Name is not None:
            self.Display_Name.export(outfile, level, 'WinServiceObj:', name_='Display_Name', pretty_print=pretty_print)
        if self.Group_Name is not None:
            self.Group_Name.export(outfile, level, 'WinServiceObj:', name_='Group_Name', pretty_print=pretty_print)
        if self.Service_Name is not None:
            self.Service_Name.export(outfile, level, 'WinServiceObj:', name_='Service_Name', pretty_print=pretty_print)
        if self.Service_DLL is not None:
            self.Service_DLL.export(outfile, level, 'WinServiceObj:', name_='Service_DLL', pretty_print=pretty_print)
        if self.Service_DLL_Certificate_Issuer is not None:
            self.Service_DLL_Certificate_Issuer.export(outfile, level, 'WinServiceObj:', name_='Service_DLL_Certificate_Issuer', pretty_print=pretty_print)
        if self.Service_DLL_Certificate_Subject is not None:
            self.Service_DLL_Certificate_Subject.export(outfile, level, 'WinServiceObj:', name_='Service_DLL_Certificate_Subject', pretty_print=pretty_print)
        if self.Service_DLL_Hashes is not None:
            self.Service_DLL_Hashes.export(outfile, level, 'WinServiceObj:', name_='Service_DLL_Hashes', pretty_print=pretty_print)
        if self.Service_DLL_Signature_Description is not None:
            self.Service_DLL_Signature_Description.export(outfile, level, 'WinServiceObj:', name_='Service_DLL_Signature_Description', pretty_print=pretty_print)
        if self.Startup_Command_Line is not None:
            self.Startup_Command_Line.export(outfile, level, 'WinServiceObj:', name_='Startup_Command_Line', pretty_print=pretty_print)
        if self.Startup_Type is not None:
            self.Startup_Type.export(outfile, level, 'WinServiceObj:', name_='Startup_Type', pretty_print=pretty_print)
        if self.Service_Status is not None:
            self.Service_Status.export(outfile, level, 'WinServiceObj:', name_='Service_Status', pretty_print=pretty_print)
        if self.Service_Type is not None:
            self.Service_Type.export(outfile, level, 'WinServiceObj:', name_='Service_Type', pretty_print=pretty_print)
        if self.Started_As is not None:
            self.Started_As.export(outfile, level, 'WinServiceObj:', name_='Started_As', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Description_List is not None or
            self.Display_Name is not None or
            self.Group_Name is not None or
            self.Service_Name is not None or
            self.Service_DLL is not None or
            self.Service_DLL_Certificate_Issuer is not None or
            self.Service_DLL_Certificate_Subject is not None or
            self.Service_DLL_Hashes is not None or
            self.Service_DLL_Signature_Description is not None or
            self.Startup_Command_Line is not None or
            self.Startup_Type is not None or
            self.Service_Status is not None or
            self.Service_Type is not None or
            self.Started_As is not None or
            super(WindowsServiceObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsServiceObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.service_dll_signature_verified is not None and 'service_dll_signature_verified' not in already_processed:
            already_processed.append('service_dll_signature_verified')
            showIndent(outfile, level)
            outfile.write('service_dll_signature_verified = %s,\n' % (self.service_dll_signature_verified,))
        if self.service_dll_signature_exists is not None and 'service_dll_signature_exists' not in already_processed:
            already_processed.append('service_dll_signature_exists')
            showIndent(outfile, level)
            outfile.write('service_dll_signature_exists = %s,\n' % (self.service_dll_signature_exists,))
        super(WindowsServiceObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsServiceObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Description_List is not None:
            showIndent(outfile, level)
            outfile.write('Description_List=model_.ServiceDescriptionListType(\n')
            self.Description_List.exportLiteral(outfile, level, name_='Description_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Display_Name is not None:
            showIndent(outfile, level)
            outfile.write('Display_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Display_Name.exportLiteral(outfile, level, name_='Display_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Group_Name is not None:
            showIndent(outfile, level)
            outfile.write('Group_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Group_Name.exportLiteral(outfile, level, name_='Group_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Service_Name is not None:
            showIndent(outfile, level)
            outfile.write('Service_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Service_Name.exportLiteral(outfile, level, name_='Service_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Service_DLL is not None:
            showIndent(outfile, level)
            outfile.write('Service_DLL=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Service_DLL.exportLiteral(outfile, level, name_='Service_DLL')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Service_DLL_Certificate_Issuer is not None:
            showIndent(outfile, level)
            outfile.write('Service_DLL_Certificate_Issuer=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Service_DLL_Certificate_Issuer.exportLiteral(outfile, level, name_='Service_DLL_Certificate_Issuer')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Service_DLL_Certificate_Subject is not None:
            showIndent(outfile, level)
            outfile.write('Service_DLL_Certificate_Subject=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Service_DLL_Certificate_Subject.exportLiteral(outfile, level, name_='Service_DLL_Certificate_Subject')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Service_DLL_Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Service_DLL_Hashes=model_.cybox_common_types_1_0.HashListType(\n')
            self.Service_DLL_Hashes.exportLiteral(outfile, level, name_='Service_DLL_Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Service_DLL_Signature_Description is not None:
            showIndent(outfile, level)
            outfile.write('Service_DLL_Signature_Description=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Service_DLL_Signature_Description.exportLiteral(outfile, level, name_='Service_DLL_Signature_Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Startup_Command_Line is not None:
            showIndent(outfile, level)
            outfile.write('Startup_Command_Line=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Startup_Command_Line.exportLiteral(outfile, level, name_='Startup_Command_Line')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Startup_Type is not None:
            showIndent(outfile, level)
            outfile.write('Startup_Type=model_.ServiceModeType(\n')
            self.Startup_Type.exportLiteral(outfile, level, name_='Startup_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Service_Status is not None:
            showIndent(outfile, level)
            outfile.write('Service_Status=model_.ServiceStatusType(\n')
            self.Service_Status.exportLiteral(outfile, level, name_='Service_Status')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Service_Type is not None:
            showIndent(outfile, level)
            outfile.write('Service_Type=model_.ServiceType(\n')
            self.Service_Type.exportLiteral(outfile, level, name_='Service_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Started_As is not None:
            showIndent(outfile, level)
            outfile.write('Started_As=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Started_As.exportLiteral(outfile, level, name_='Started_As')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('service_dll_signature_verified', node)
        if value is not None and 'service_dll_signature_verified' not in already_processed:
            already_processed.append('service_dll_signature_verified')
            if value in ('true', '1'):
                self.service_dll_signature_verified = True
            elif value in ('false', '0'):
                self.service_dll_signature_verified = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('service_dll_signature_exists', node)
        if value is not None and 'service_dll_signature_exists' not in already_processed:
            already_processed.append('service_dll_signature_exists')
            if value in ('true', '1'):
                self.service_dll_signature_exists = True
            elif value in ('false', '0'):
                self.service_dll_signature_exists = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(WindowsServiceObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description_List':
            obj_ = ServiceDescriptionListType.factory()
            obj_.build(child_)
            self.set_Description_List(obj_)
        elif nodeName_ == 'Display_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Display_Name(obj_)
        elif nodeName_ == 'Group_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Group_Name(obj_)
        elif nodeName_ == 'Service_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Service_Name(obj_)
        elif nodeName_ == 'Service_DLL':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Service_DLL(obj_)
        elif nodeName_ == 'Service_DLL_Certificate_Issuer':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Service_DLL_Certificate_Issuer(obj_)
        elif nodeName_ == 'Service_DLL_Certificate_Subject':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Service_DLL_Certificate_Subject(obj_)
        elif nodeName_ == 'Service_DLL_Hashes':
            obj_ = cybox_common_types_1_0.HashListType.factory()
            obj_.build(child_)
            self.set_Service_DLL_Hashes(obj_)
        elif nodeName_ == 'Service_DLL_Signature_Description':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Service_DLL_Signature_Description(obj_)
        elif nodeName_ == 'Startup_Command_Line':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Startup_Command_Line(obj_)
        elif nodeName_ == 'Startup_Type':
            obj_ = ServiceModeType.factory()
            obj_.build(child_)
            self.set_Startup_Type(obj_)
        elif nodeName_ == 'Service_Status':
            obj_ = ServiceStatusType.factory()
            obj_.build(child_)
            self.set_Service_Status(obj_)
        elif nodeName_ == 'Service_Type':
            obj_ = ServiceType.factory()
            obj_.build(child_)
            self.set_Service_Type(obj_)
        elif nodeName_ == 'Started_As':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Started_As(obj_)
        super(WindowsServiceObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsServiceObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Service'
        rootClass = WindowsServiceObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Service'
        rootClass = WindowsServiceObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Service",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Service'
        rootClass = WindowsServiceObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsServiceObjectType",
    "ServiceDescriptionListType",
    "ServiceModeType",
    "ServiceStatusType",
    "ServiceType"
    ]