#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:04:28 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import email_message_object_1_2

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class TriggerListType(GeneratedsSuper):
    """The TriggerListType type specifies a set of triggers associated with
    the scheduled task."""
    subclass = None
    superclass = None
    def __init__(self, Trigger=None):
        if Trigger is None:
            self.Trigger = []
        else:
            self.Trigger = Trigger
    def factory(*args_, **kwargs_):
        if TriggerListType.subclass:
            return TriggerListType.subclass(*args_, **kwargs_)
        else:
            return TriggerListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Trigger(self): return self.Trigger
    def set_Trigger(self, Trigger): self.Trigger = Trigger
    def add_Trigger(self, value): self.Trigger.append(value)
    def insert_Trigger(self, index, value): self.Trigger[index] = value
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TriggerListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TriggerListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TriggerListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TriggerListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Trigger_ in self.Trigger:
            Trigger_.export(outfile, level, 'WinTaskObj:', name_='Trigger', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Trigger
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TriggerListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Trigger=[\n')
        level += 1
        for Trigger_ in self.Trigger:
            showIndent(outfile, level)
            outfile.write('model_.TriggerType(\n')
            Trigger_.exportLiteral(outfile, level, name_='TriggerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Trigger':
            obj_ = TriggerType.factory()
            obj_.build(child_)
            self.Trigger.append(obj_)
# end class TriggerListType

class TriggerType(GeneratedsSuper):
    """The TriggerType type characterizes task triggers. See also:
    http://msdn.microsoft.com/en-
    us/library/windows/desktop/aa383868(v=vs.85).aspxThe enabled
    attribute specifies whether the trigger is enabled."""
    subclass = None
    superclass = None
    def __init__(self, enabled=None, Trigger_Begin=None, Trigger_Delay=None, Trigger_End=None, Trigger_Frequency=None, Trigger_Max_Run_Time=None, Trigger_Session_Change_Type=None, Trigger_Type=None):
        self.enabled = _cast(bool, enabled)
        self.Trigger_Begin = Trigger_Begin
        self.Trigger_Delay = Trigger_Delay
        self.Trigger_End = Trigger_End
        self.Trigger_Frequency = Trigger_Frequency
        self.Trigger_Max_Run_Time = Trigger_Max_Run_Time
        self.Trigger_Session_Change_Type = Trigger_Session_Change_Type
        self.Trigger_Type = Trigger_Type
    def factory(*args_, **kwargs_):
        if TriggerType.subclass:
            return TriggerType.subclass(*args_, **kwargs_)
        else:
            return TriggerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Trigger_Begin(self): return self.Trigger_Begin
    def set_Trigger_Begin(self, Trigger_Begin): self.Trigger_Begin = Trigger_Begin
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Trigger_Delay(self): return self.Trigger_Delay
    def set_Trigger_Delay(self, Trigger_Delay): self.Trigger_Delay = Trigger_Delay
    def validate_DurationObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DurationObjectAttributeType, a restriction on None.
        pass
    def get_Trigger_End(self): return self.Trigger_End
    def set_Trigger_End(self, Trigger_End): self.Trigger_End = Trigger_End
    def get_Trigger_Frequency(self): return self.Trigger_Frequency
    def set_Trigger_Frequency(self, Trigger_Frequency): self.Trigger_Frequency = Trigger_Frequency
    def validate_TaskTriggerFrequencyType(self, value):
        # Validate type TaskTriggerFrequencyType, a restriction on None.
        pass
    def get_Trigger_Max_Run_Time(self): return self.Trigger_Max_Run_Time
    def set_Trigger_Max_Run_Time(self, Trigger_Max_Run_Time): self.Trigger_Max_Run_Time = Trigger_Max_Run_Time
    def get_Trigger_Session_Change_Type(self): return self.Trigger_Session_Change_Type
    def set_Trigger_Session_Change_Type(self, Trigger_Session_Change_Type): self.Trigger_Session_Change_Type = Trigger_Session_Change_Type
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Trigger_Type(self): return self.Trigger_Type
    def set_Trigger_Type(self, Trigger_Type): self.Trigger_Type = Trigger_Type
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TriggerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TriggerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TriggerType'):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.append('enabled')
            outfile.write(' enabled="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.enabled)), input_name='enabled'))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TriggerType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Trigger_Begin is not None:
            self.Trigger_Begin.export(outfile, level, 'WinTaskObj:', name_='Trigger_Begin', pretty_print=pretty_print)
        if self.Trigger_Delay is not None:
            self.Trigger_Delay.export(outfile, level, 'WinTaskObj:', name_='Trigger_Delay', pretty_print=pretty_print)
        if self.Trigger_End is not None:
            self.Trigger_End.export(outfile, level, 'WinTaskObj:', name_='Trigger_End', pretty_print=pretty_print)
        if self.Trigger_Frequency is not None:
            self.Trigger_Frequency.export(outfile, level, 'WinTaskObj:', name_='Trigger_Frequency', pretty_print=pretty_print)
        if self.Trigger_Max_Run_Time is not None:
            self.Trigger_Max_Run_Time.export(outfile, level, 'WinTaskObj:', name_='Trigger_Max_Run_Time', pretty_print=pretty_print)
        if self.Trigger_Session_Change_Type is not None:
            self.Trigger_Session_Change_Type.export(outfile, level, 'WinTaskObj:', name_='Trigger_Session_Change_Type', pretty_print=pretty_print)
        if self.Trigger_Type is not None:
            self.Trigger_Type.export(outfile, level, 'WinTaskObj:', name_='Trigger_Type', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Trigger_Begin is not None or
            self.Trigger_Delay is not None or
            self.Trigger_End is not None or
            self.Trigger_Frequency is not None or
            self.Trigger_Max_Run_Time is not None or
            self.Trigger_Session_Change_Type is not None or
            self.Trigger_Type is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TriggerType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.append('enabled')
            showIndent(outfile, level)
            outfile.write('enabled = %s,\n' % (self.enabled,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Trigger_Begin is not None:
            showIndent(outfile, level)
            outfile.write('Trigger_Begin=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Trigger_Begin.exportLiteral(outfile, level, name_='Trigger_Begin')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Trigger_Delay is not None:
            showIndent(outfile, level)
            outfile.write('Trigger_Delay=model_.cybox_common_types_1_0.DurationObjectAttributeType(\n')
            self.Trigger_Delay.exportLiteral(outfile, level, name_='Trigger_Delay')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Trigger_End is not None:
            showIndent(outfile, level)
            outfile.write('Trigger_End=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Trigger_End.exportLiteral(outfile, level, name_='Trigger_End')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Trigger_Frequency is not None:
            showIndent(outfile, level)
            outfile.write('Trigger_Frequency=model_.TaskTriggerFrequencyType(\n')
            self.Trigger_Frequency.exportLiteral(outfile, level, name_='Trigger_Frequency')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Trigger_Max_Run_Time is not None:
            showIndent(outfile, level)
            outfile.write('Trigger_Max_Run_Time=model_.cybox_common_types_1_0.DurationObjectAttributeType(\n')
            self.Trigger_Max_Run_Time.exportLiteral(outfile, level, name_='Trigger_Max_Run_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Trigger_Session_Change_Type is not None:
            showIndent(outfile, level)
            outfile.write('Trigger_Session_Change_Type=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Trigger_Session_Change_Type.exportLiteral(outfile, level, name_='Trigger_Session_Change_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Trigger_Type is not None:
            showIndent(outfile, level)
            outfile.write('Trigger_Type=model_.TriggerType(\n')
            self.Trigger_Type.exportLiteral(outfile, level, name_='Trigger_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('enabled', node)
        if value is not None and 'enabled' not in already_processed:
            already_processed.append('enabled')
            if value in ('true', '1'):
                self.enabled = True
            elif value in ('false', '0'):
                self.enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Trigger_Begin':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Trigger_Begin(obj_)
        elif nodeName_ == 'Trigger_Delay':
            obj_ = cybox_common_types_1_0.DurationObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Trigger_Delay(obj_)
        elif nodeName_ == 'Trigger_End':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Trigger_End(obj_)
        elif nodeName_ == 'Trigger_Frequency':
            obj_ = TaskTriggerFrequencyType.factory()
            obj_.build(child_)
            self.set_Trigger_Frequency(obj_)
        elif nodeName_ == 'Trigger_Max_Run_Time':
            obj_ = cybox_common_types_1_0.DurationObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Trigger_Max_Run_Time(obj_)
        elif nodeName_ == 'Trigger_Session_Change_Type':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Trigger_Session_Change_Type(obj_)
        elif nodeName_ == 'Trigger_Type':
            obj_ = TriggerType.factory()
            obj_.build(child_)
            self.set_Trigger_Type(obj_)
# end class TriggerType

class TaskActionListType(GeneratedsSuper):
    """The TaskActionListType type specifies a list of task actions."""
    subclass = None
    superclass = None
    def __init__(self, Action=None):
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
    def factory(*args_, **kwargs_):
        if TaskActionListType.subclass:
            return TaskActionListType.subclass(*args_, **kwargs_)
        else:
            return TaskActionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskActionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskActionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Action_ in self.Action:
            Action_.export(outfile, level, 'WinTaskObj:', name_='Action', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Action
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaskActionListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            showIndent(outfile, level)
            outfile.write('model_.TaskActionType(\n')
            Action_.exportLiteral(outfile, level, name_='TaskActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action':
            obj_ = TaskActionType.factory()
            obj_.build(child_)
            self.Action.append(obj_)
# end class TaskActionListType

class TaskActionType(GeneratedsSuper):
    """The TaskActionType type characterizes scheduled task actions."""
    subclass = None
    superclass = None
    def __init__(self, Action_Type=None, Action_ID=None, IEmailAction=None, IComHandlerAction=None, IExecAction=None, IShowMessageAction=None):
        self.Action_Type = Action_Type
        self.Action_ID = Action_ID
        self.IEmailAction = IEmailAction
        self.IComHandlerAction = IComHandlerAction
        self.IExecAction = IExecAction
        self.IShowMessageAction = IShowMessageAction
    def factory(*args_, **kwargs_):
        if TaskActionType.subclass:
            return TaskActionType.subclass(*args_, **kwargs_)
        else:
            return TaskActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_Type(self): return self.Action_Type
    def set_Action_Type(self, Action_Type): self.Action_Type = Action_Type
    def validate_TaskActionTypeType(self, value):
        # Validate type TaskActionTypeType, a restriction on None.
        pass
    def get_Action_ID(self): return self.Action_ID
    def set_Action_ID(self, Action_ID): self.Action_ID = Action_ID
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_IEmailAction(self): return self.IEmailAction
    def set_IEmailAction(self, IEmailAction): self.IEmailAction = IEmailAction
    def get_IComHandlerAction(self): return self.IComHandlerAction
    def set_IComHandlerAction(self, IComHandlerAction): self.IComHandlerAction = IComHandlerAction
    def get_IExecAction(self): return self.IExecAction
    def set_IExecAction(self, IExecAction): self.IExecAction = IExecAction
    def get_IShowMessageAction(self): return self.IShowMessageAction
    def set_IShowMessageAction(self, IShowMessageAction): self.IShowMessageAction = IShowMessageAction
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskActionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Action_Type is not None:
            self.Action_Type.export(outfile, level, 'WinTaskObj:', name_='Action_Type', pretty_print=pretty_print)
        if self.Action_ID is not None:
            self.Action_ID.export(outfile, level, 'WinTaskObj:', name_='Action_ID', pretty_print=pretty_print)
        if self.IEmailAction is not None:
            self.IEmailAction.export(outfile, level, 'WinTaskObj:', name_='IEmailAction', pretty_print=pretty_print)
        if self.IComHandlerAction is not None:
            self.IComHandlerAction.export(outfile, level, 'WinTaskObj:', name_='IComHandlerAction', pretty_print=pretty_print)
        if self.IExecAction is not None:
            self.IExecAction.export(outfile, level, 'WinTaskObj:', name_='IExecAction', pretty_print=pretty_print)
        if self.IShowMessageAction is not None:
            self.IShowMessageAction.export(outfile, level, 'WinTaskObj:', name_='IShowMessageAction', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Action_Type is not None or
            self.Action_ID is not None or
            self.IEmailAction is not None or
            self.IComHandlerAction is not None or
            self.IExecAction is not None or
            self.IShowMessageAction is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaskActionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Action_Type is not None:
            showIndent(outfile, level)
            outfile.write('Action_Type=model_.TaskActionTypeType(\n')
            self.Action_Type.exportLiteral(outfile, level, name_='Action_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Action_ID is not None:
            showIndent(outfile, level)
            outfile.write('Action_ID=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Action_ID.exportLiteral(outfile, level, name_='Action_ID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IEmailAction is not None:
            showIndent(outfile, level)
            outfile.write('IEmailAction=model_.email_message_object_1_2.EmailMessageObjectType(\n')
            self.IEmailAction.exportLiteral(outfile, level, name_='IEmailAction')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IComHandlerAction is not None:
            showIndent(outfile, level)
            outfile.write('IComHandlerAction=model_.IComHandlerActionType(\n')
            self.IComHandlerAction.exportLiteral(outfile, level, name_='IComHandlerAction')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IExecAction is not None:
            showIndent(outfile, level)
            outfile.write('IExecAction=model_.IExecActionType(\n')
            self.IExecAction.exportLiteral(outfile, level, name_='IExecAction')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IShowMessageAction is not None:
            showIndent(outfile, level)
            outfile.write('IShowMessageAction=model_.IShowMessageActionType(\n')
            self.IShowMessageAction.exportLiteral(outfile, level, name_='IShowMessageAction')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action_Type':
            obj_ = TaskActionTypeType.factory()
            obj_.build(child_)
            self.set_Action_Type(obj_)
        elif nodeName_ == 'Action_ID':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Action_ID(obj_)
        elif nodeName_ == 'IEmailAction':
            obj_ = email_message_object_1_2.EmailMessageObjectType.factory()
            obj_.build(child_)
            self.set_IEmailAction(obj_)
        elif nodeName_ == 'IComHandlerAction':
            obj_ = IComHandlerActionType.factory()
            obj_.build(child_)
            self.set_IComHandlerAction(obj_)
        elif nodeName_ == 'IExecAction':
            obj_ = IExecActionType.factory()
            obj_.build(child_)
            self.set_IExecAction(obj_)
        elif nodeName_ == 'IShowMessageAction':
            obj_ = IShowMessageActionType.factory()
            obj_.build(child_)
            self.set_IShowMessageAction(obj_)
# end class TaskActionType

class IComHandlerActionType(GeneratedsSuper):
    """The IComHandlerActionType type characterizes IComHandler actions."""
    subclass = None
    superclass = None
    def __init__(self, COM_Data=None, COM_Class_ID=None):
        self.COM_Data = COM_Data
        self.COM_Class_ID = COM_Class_ID
    def factory(*args_, **kwargs_):
        if IComHandlerActionType.subclass:
            return IComHandlerActionType.subclass(*args_, **kwargs_)
        else:
            return IComHandlerActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_COM_Data(self): return self.COM_Data
    def set_COM_Data(self, COM_Data): self.COM_Data = COM_Data
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_COM_Class_ID(self): return self.COM_Class_ID
    def set_COM_Class_ID(self, COM_Class_ID): self.COM_Class_ID = COM_Class_ID
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='IComHandlerActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IComHandlerActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='IComHandlerActionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='IComHandlerActionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.COM_Data is not None:
            self.COM_Data.export(outfile, level, 'WinTaskObj:', name_='COM_Data', pretty_print=pretty_print)
        if self.COM_Class_ID is not None:
            self.COM_Class_ID.export(outfile, level, 'WinTaskObj:', name_='COM_Class_ID', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.COM_Data is not None or
            self.COM_Class_ID is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IComHandlerActionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.COM_Data is not None:
            showIndent(outfile, level)
            outfile.write('COM_Data=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.COM_Data.exportLiteral(outfile, level, name_='COM_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.COM_Class_ID is not None:
            showIndent(outfile, level)
            outfile.write('COM_Class_ID=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.COM_Class_ID.exportLiteral(outfile, level, name_='COM_Class_ID')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'COM_Data':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_COM_Data(obj_)
        elif nodeName_ == 'COM_Class_ID':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_COM_Class_ID(obj_)
# end class IComHandlerActionType

class IExecActionType(GeneratedsSuper):
    """The IExecActionType type characterizes IExec actions."""
    subclass = None
    superclass = None
    def __init__(self, Exec_Arguments=None, Exec_Program_Path=None, Exec_Working_Directory=None, Exec_Program_Hashes=None):
        self.Exec_Arguments = Exec_Arguments
        self.Exec_Program_Path = Exec_Program_Path
        self.Exec_Working_Directory = Exec_Working_Directory
        self.Exec_Program_Hashes = Exec_Program_Hashes
    def factory(*args_, **kwargs_):
        if IExecActionType.subclass:
            return IExecActionType.subclass(*args_, **kwargs_)
        else:
            return IExecActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Exec_Arguments(self): return self.Exec_Arguments
    def set_Exec_Arguments(self, Exec_Arguments): self.Exec_Arguments = Exec_Arguments
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Exec_Program_Path(self): return self.Exec_Program_Path
    def set_Exec_Program_Path(self, Exec_Program_Path): self.Exec_Program_Path = Exec_Program_Path
    def get_Exec_Working_Directory(self): return self.Exec_Working_Directory
    def set_Exec_Working_Directory(self, Exec_Working_Directory): self.Exec_Working_Directory = Exec_Working_Directory
    def get_Exec_Program_Hashes(self): return self.Exec_Program_Hashes
    def set_Exec_Program_Hashes(self, Exec_Program_Hashes): self.Exec_Program_Hashes = Exec_Program_Hashes
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='IExecActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IExecActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='IExecActionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='IExecActionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Exec_Arguments is not None:
            self.Exec_Arguments.export(outfile, level, 'WinTaskObj:', name_='Exec_Arguments', pretty_print=pretty_print)
        if self.Exec_Program_Path is not None:
            self.Exec_Program_Path.export(outfile, level, 'WinTaskObj:', name_='Exec_Program_Path', pretty_print=pretty_print)
        if self.Exec_Working_Directory is not None:
            self.Exec_Working_Directory.export(outfile, level, 'WinTaskObj:', name_='Exec_Working_Directory', pretty_print=pretty_print)
        if self.Exec_Program_Hashes is not None:
            self.Exec_Program_Hashes.export(outfile, level, 'WinTaskObj:', name_='Exec_Program_Hashes', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Exec_Arguments is not None or
            self.Exec_Program_Path is not None or
            self.Exec_Working_Directory is not None or
            self.Exec_Program_Hashes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IExecActionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Exec_Arguments is not None:
            showIndent(outfile, level)
            outfile.write('Exec_Arguments=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Exec_Arguments.exportLiteral(outfile, level, name_='Exec_Arguments')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exec_Program_Path is not None:
            showIndent(outfile, level)
            outfile.write('Exec_Program_Path=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Exec_Program_Path.exportLiteral(outfile, level, name_='Exec_Program_Path')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exec_Working_Directory is not None:
            showIndent(outfile, level)
            outfile.write('Exec_Working_Directory=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Exec_Working_Directory.exportLiteral(outfile, level, name_='Exec_Working_Directory')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exec_Program_Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Exec_Program_Hashes=model_.cybox_common_types_1_0.HashListType(\n')
            self.Exec_Program_Hashes.exportLiteral(outfile, level, name_='Exec_Program_Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Exec_Arguments':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Exec_Arguments(obj_)
        elif nodeName_ == 'Exec_Program_Path':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Exec_Program_Path(obj_)
        elif nodeName_ == 'Exec_Working_Directory':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Exec_Working_Directory(obj_)
        elif nodeName_ == 'Exec_Program_Hashes':
            obj_ = cybox_common_types_1_0.HashListType.factory()
            obj_.build(child_)
            self.set_Exec_Program_Hashes(obj_)
# end class IExecActionType

class IShowMessageActionType(GeneratedsSuper):
    """The IShowMessageActionType type characterizes IShowMessage actions."""
    subclass = None
    superclass = None
    def __init__(self, Show_Message_Body=None, Show_Message_Title=None):
        self.Show_Message_Body = Show_Message_Body
        self.Show_Message_Title = Show_Message_Title
    def factory(*args_, **kwargs_):
        if IShowMessageActionType.subclass:
            return IShowMessageActionType.subclass(*args_, **kwargs_)
        else:
            return IShowMessageActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Show_Message_Body(self): return self.Show_Message_Body
    def set_Show_Message_Body(self, Show_Message_Body): self.Show_Message_Body = Show_Message_Body
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Show_Message_Title(self): return self.Show_Message_Title
    def set_Show_Message_Title(self, Show_Message_Title): self.Show_Message_Title = Show_Message_Title
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='IShowMessageActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IShowMessageActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='IShowMessageActionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='IShowMessageActionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Show_Message_Body is not None:
            self.Show_Message_Body.export(outfile, level, 'WinTaskObj:', name_='Show_Message_Body', pretty_print=pretty_print)
        if self.Show_Message_Title is not None:
            self.Show_Message_Title.export(outfile, level, 'WinTaskObj:', name_='Show_Message_Title', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Show_Message_Body is not None or
            self.Show_Message_Title is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IShowMessageActionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Show_Message_Body is not None:
            showIndent(outfile, level)
            outfile.write('Show_Message_Body=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Show_Message_Body.exportLiteral(outfile, level, name_='Show_Message_Body')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Show_Message_Title is not None:
            showIndent(outfile, level)
            outfile.write('Show_Message_Title=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Show_Message_Title.exportLiteral(outfile, level, name_='Show_Message_Title')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Show_Message_Body':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Show_Message_Body(obj_)
        elif nodeName_ == 'Show_Message_Title':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Show_Message_Title(obj_)
# end class IShowMessageActionType

class TaskStatusType(cybox_common_types_1_0.BaseObjectAttributeType):
    """The TaskStatusType type specifies Windows Task states via a union of
    the TaskStatusEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskStatusType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskStatusType.subclass:
            return TaskStatusType.subclass(*args_, **kwargs_)
        else:
            return TaskStatusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskStatusType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskStatusType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskStatusType'):
        super(TaskStatusType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskStatusType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskStatusType', fromsubclass_=False, pretty_print=True):
        super(TaskStatusType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskStatusType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaskStatusType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskStatusType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskStatusType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(TaskStatusType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskStatusType

class TaskTriggerType(cybox_common_types_1_0.BaseObjectAttributeType):
    """The TaskTriggerType type specifies Windows Task trigger types via a
    union of the TriggerTypeEnum enumeration and the atomic
    xs:string type. Its base type is the CybOX Core
    cybox_common_types_1_0.BaseObjectAttributeType, for permitting complex (i.e. regular-
    expression based) specifications.This attribute is optional and
    specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskTriggerType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskTriggerType.subclass:
            return TaskTriggerType.subclass(*args_, **kwargs_)
        else:
            return TaskTriggerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskTriggerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskTriggerType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskTriggerType'):
        super(TaskTriggerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskTriggerType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskTriggerType', fromsubclass_=False, pretty_print=True):
        super(TaskTriggerType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskTriggerType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaskTriggerType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskTriggerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskTriggerType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(TaskTriggerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskTriggerType

class TaskTriggerFrequencyType(cybox_common_types_1_0.BaseObjectAttributeType):
    """The TaskTriggerFrequencyType type specifies Windows Task trigger
    frequency types via a union of the TriggerFrequencyEnum type and
    the atomic xs:string type. Its base type is the CybOX Core
    cybox_common_types_1_0.BaseObjectAttributeType, for permitting complex (i.e. regular-
    expression based) specifications.This attribute is optional and
    specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskTriggerFrequencyType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskTriggerFrequencyType.subclass:
            return TaskTriggerFrequencyType.subclass(*args_, **kwargs_)
        else:
            return TaskTriggerFrequencyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskTriggerFrequencyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskTriggerFrequencyType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskTriggerFrequencyType'):
        super(TaskTriggerFrequencyType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskTriggerFrequencyType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskTriggerFrequencyType', fromsubclass_=False, pretty_print=True):
        super(TaskTriggerFrequencyType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskTriggerFrequencyType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaskTriggerFrequencyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskTriggerFrequencyType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskTriggerFrequencyType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(TaskTriggerFrequencyType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskTriggerFrequencyType

class TaskPriorityType(cybox_common_types_1_0.BaseObjectAttributeType):
    """The TaskPriorityType type specifies Windows Task priority types via
    a union of the TaskPriorityEnum type and the atomic xs:string
    type. Its base type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType,
    for permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskPriorityType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskPriorityType.subclass:
            return TaskPriorityType.subclass(*args_, **kwargs_)
        else:
            return TaskPriorityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskPriorityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskPriorityType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskPriorityType'):
        super(TaskPriorityType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskPriorityType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskPriorityType', fromsubclass_=False, pretty_print=True):
        super(TaskPriorityType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskPriorityType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaskPriorityType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskPriorityType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskPriorityType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(TaskPriorityType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskPriorityType

class TaskFlagType(cybox_common_types_1_0.BaseObjectAttributeType):
    """The TaskFlagType type specifies Windows Task flag types via a union
    of the TaskFlagEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskFlagType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskFlagType.subclass:
            return TaskFlagType.subclass(*args_, **kwargs_)
        else:
            return TaskFlagType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskFlagType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskFlagType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskFlagType'):
        super(TaskFlagType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskFlagType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskFlagType', fromsubclass_=False, pretty_print=True):
        super(TaskFlagType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskFlagType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaskFlagType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskFlagType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskFlagType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(TaskFlagType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskFlagType

class TaskActionTypeType(cybox_common_types_1_0.BaseObjectAttributeType):
    """The TaskActionTypeType characterizes the specific types of task
    actions.This attribute is optional and specifies the expected
    type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskActionTypeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskActionTypeType.subclass:
            return TaskActionTypeType.subclass(*args_, **kwargs_)
        else:
            return TaskActionTypeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionTypeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskActionTypeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskActionTypeType'):
        super(TaskActionTypeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskActionTypeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionTypeType', fromsubclass_=False, pretty_print=True):
        super(TaskActionTypeType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskActionTypeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaskActionTypeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskActionTypeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskActionTypeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(TaskActionTypeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskActionTypeType

class WindowsTaskObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The WindowsTaskObjectType type is intended to characterize Windows
    task scheduler tasks. See Also: http://msdn.microsoft.com/en-
    us/library/windows/desktop/aa381311(v=vs.85).aspx"""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, Status=None, Priority=None, Name=None, Application_Name=None, Parameters=None, Flags=None, Account_Name=None, Account_Run_Level=None, Account_Logon_Type=None, Creator=None, Creation_Date=None, Most_Recent_Run_Time=None, Exit_Code=None, Max_Run_Time=None, Next_Run_Time=None, Action_List=None, Trigger_List=None, Comment=None, Working_Directory=None, Work_Item_Data=None):
        super(WindowsTaskObjectType, self).__init__(object_reference, )
        self.Status = Status
        self.Priority = Priority
        self.Name = Name
        self.Application_Name = Application_Name
        self.Parameters = Parameters
        self.Flags = Flags
        self.Account_Name = Account_Name
        self.Account_Run_Level = Account_Run_Level
        self.Account_Logon_Type = Account_Logon_Type
        self.Creator = Creator
        self.Creation_Date = Creation_Date
        self.Most_Recent_Run_Time = Most_Recent_Run_Time
        self.Exit_Code = Exit_Code
        self.Max_Run_Time = Max_Run_Time
        self.Next_Run_Time = Next_Run_Time
        self.Action_List = Action_List
        self.Trigger_List = Trigger_List
        self.Comment = Comment
        self.Working_Directory = Working_Directory
        self.Work_Item_Data = Work_Item_Data
    def factory(*args_, **kwargs_):
        if WindowsTaskObjectType.subclass:
            return WindowsTaskObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsTaskObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Status(self): return self.Status
    def set_Status(self, Status): self.Status = Status
    def validate_TaskStatusType(self, value):
        # Validate type TaskStatusType, a restriction on None.
        pass
    def get_Priority(self): return self.Priority
    def set_Priority(self, Priority): self.Priority = Priority
    def validate_TaskPriorityType(self, value):
        # Validate type TaskPriorityType, a restriction on None.
        pass
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Application_Name(self): return self.Application_Name
    def set_Application_Name(self, Application_Name): self.Application_Name = Application_Name
    def get_Parameters(self): return self.Parameters
    def set_Parameters(self, Parameters): self.Parameters = Parameters
    def get_Flags(self): return self.Flags
    def set_Flags(self, Flags): self.Flags = Flags
    def validate_TaskFlagType(self, value):
        # Validate type TaskFlagType, a restriction on None.
        pass
    def get_Account_Name(self): return self.Account_Name
    def set_Account_Name(self, Account_Name): self.Account_Name = Account_Name
    def get_Account_Run_Level(self): return self.Account_Run_Level
    def set_Account_Run_Level(self, Account_Run_Level): self.Account_Run_Level = Account_Run_Level
    def get_Account_Logon_Type(self): return self.Account_Logon_Type
    def set_Account_Logon_Type(self, Account_Logon_Type): self.Account_Logon_Type = Account_Logon_Type
    def get_Creator(self): return self.Creator
    def set_Creator(self, Creator): self.Creator = Creator
    def get_Creation_Date(self): return self.Creation_Date
    def set_Creation_Date(self, Creation_Date): self.Creation_Date = Creation_Date
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Most_Recent_Run_Time(self): return self.Most_Recent_Run_Time
    def set_Most_Recent_Run_Time(self, Most_Recent_Run_Time): self.Most_Recent_Run_Time = Most_Recent_Run_Time
    def get_Exit_Code(self): return self.Exit_Code
    def set_Exit_Code(self, Exit_Code): self.Exit_Code = Exit_Code
    def validate_LongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.LongObjectAttributeType, a restriction on None.
        pass
    def get_Max_Run_Time(self): return self.Max_Run_Time
    def set_Max_Run_Time(self, Max_Run_Time): self.Max_Run_Time = Max_Run_Time
    def validate_UnsignedLongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedLongObjectAttributeType, a restriction on None.
        pass
    def get_Next_Run_Time(self): return self.Next_Run_Time
    def set_Next_Run_Time(self, Next_Run_Time): self.Next_Run_Time = Next_Run_Time
    def get_Action_List(self): return self.Action_List
    def set_Action_List(self, Action_List): self.Action_List = Action_List
    def get_Trigger_List(self): return self.Trigger_List
    def set_Trigger_List(self, Trigger_List): self.Trigger_List = Trigger_List
    def get_Comment(self): return self.Comment
    def set_Comment(self, Comment): self.Comment = Comment
    def get_Working_Directory(self): return self.Working_Directory
    def set_Working_Directory(self, Working_Directory): self.Working_Directory = Working_Directory
    def get_Work_Item_Data(self): return self.Work_Item_Data
    def set_Work_Item_Data(self, Work_Item_Data): self.Work_Item_Data = Work_Item_Data
    def validate_Base64BinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.Base64BinaryObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='WindowsTaskObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsTaskObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='WindowsTaskObjectType'):
        super(WindowsTaskObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsTaskObjectType')
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='WindowsTaskObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsTaskObjectType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Status is not None:
            self.Status.export(outfile, level, 'WinTaskObj:', name_='Status', pretty_print=pretty_print)
        if self.Priority is not None:
            self.Priority.export(outfile, level, 'WinTaskObj:', name_='Priority', pretty_print=pretty_print)
        if self.Name is not None:
            self.Name.export(outfile, level, 'WinTaskObj:', name_='Name', pretty_print=pretty_print)
        if self.Application_Name is not None:
            self.Application_Name.export(outfile, level, 'WinTaskObj:', name_='Application_Name', pretty_print=pretty_print)
        if self.Parameters is not None:
            self.Parameters.export(outfile, level, 'WinTaskObj:', name_='Parameters', pretty_print=pretty_print)
        if self.Flags is not None:
            self.Flags.export(outfile, level, 'WinTaskObj:', name_='Flags', pretty_print=pretty_print)
        if self.Account_Name is not None:
            self.Account_Name.export(outfile, level, 'WinTaskObj:', name_='Account_Name', pretty_print=pretty_print)
        if self.Account_Run_Level is not None:
            self.Account_Run_Level.export(outfile, level, 'WinTaskObj:', name_='Account_Run_Level', pretty_print=pretty_print)
        if self.Account_Logon_Type is not None:
            self.Account_Logon_Type.export(outfile, level, 'WinTaskObj:', name_='Account_Logon_Type', pretty_print=pretty_print)
        if self.Creator is not None:
            self.Creator.export(outfile, level, 'WinTaskObj:', name_='Creator', pretty_print=pretty_print)
        if self.Creation_Date is not None:
            self.Creation_Date.export(outfile, level, 'WinTaskObj:', name_='Creation_Date', pretty_print=pretty_print)
        if self.Most_Recent_Run_Time is not None:
            self.Most_Recent_Run_Time.export(outfile, level, 'WinTaskObj:', name_='Most_Recent_Run_Time', pretty_print=pretty_print)
        if self.Exit_Code is not None:
            self.Exit_Code.export(outfile, level, 'WinTaskObj:', name_='Exit_Code', pretty_print=pretty_print)
        if self.Max_Run_Time is not None:
            self.Max_Run_Time.export(outfile, level, 'WinTaskObj:', name_='Max_Run_Time', pretty_print=pretty_print)
        if self.Next_Run_Time is not None:
            self.Next_Run_Time.export(outfile, level, 'WinTaskObj:', name_='Next_Run_Time', pretty_print=pretty_print)
        if self.Action_List is not None:
            self.Action_List.export(outfile, level, 'WinTaskObj:', name_='Action_List', pretty_print=pretty_print)
        if self.Trigger_List is not None:
            self.Trigger_List.export(outfile, level, 'WinTaskObj:', name_='Trigger_List', pretty_print=pretty_print)
        if self.Comment is not None:
            self.Comment.export(outfile, level, 'WinTaskObj:', name_='Comment', pretty_print=pretty_print)
        if self.Working_Directory is not None:
            self.Working_Directory.export(outfile, level, 'WinTaskObj:', name_='Working_Directory', pretty_print=pretty_print)
        if self.Work_Item_Data is not None:
            self.Work_Item_Data.export(outfile, level, 'WinTaskObj:', name_='Work_Item_Data', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Status is not None or
            self.Priority is not None or
            self.Name is not None or
            self.Application_Name is not None or
            self.Parameters is not None or
            self.Flags is not None or
            self.Account_Name is not None or
            self.Account_Run_Level is not None or
            self.Account_Logon_Type is not None or
            self.Creator is not None or
            self.Creation_Date is not None or
            self.Most_Recent_Run_Time is not None or
            self.Exit_Code is not None or
            self.Max_Run_Time is not None or
            self.Next_Run_Time is not None or
            self.Action_List is not None or
            self.Trigger_List is not None or
            self.Comment is not None or
            self.Working_Directory is not None or
            self.Work_Item_Data is not None or
            super(WindowsTaskObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsTaskObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsTaskObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsTaskObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Status is not None:
            showIndent(outfile, level)
            outfile.write('Status=model_.TaskStatusType(\n')
            self.Status.exportLiteral(outfile, level, name_='Status')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Priority is not None:
            showIndent(outfile, level)
            outfile.write('Priority=model_.TaskPriorityType(\n')
            self.Priority.exportLiteral(outfile, level, name_='Priority')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Application_Name is not None:
            showIndent(outfile, level)
            outfile.write('Application_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Application_Name.exportLiteral(outfile, level, name_='Application_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Parameters is not None:
            showIndent(outfile, level)
            outfile.write('Parameters=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Parameters.exportLiteral(outfile, level, name_='Parameters')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('Flags=model_.TaskFlagType(\n')
            self.Flags.exportLiteral(outfile, level, name_='Flags')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Account_Name is not None:
            showIndent(outfile, level)
            outfile.write('Account_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Account_Name.exportLiteral(outfile, level, name_='Account_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Account_Run_Level is not None:
            showIndent(outfile, level)
            outfile.write('Account_Run_Level=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Account_Run_Level.exportLiteral(outfile, level, name_='Account_Run_Level')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Account_Logon_Type is not None:
            showIndent(outfile, level)
            outfile.write('Account_Logon_Type=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Account_Logon_Type.exportLiteral(outfile, level, name_='Account_Logon_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Creator is not None:
            showIndent(outfile, level)
            outfile.write('Creator=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Creator.exportLiteral(outfile, level, name_='Creator')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Creation_Date is not None:
            showIndent(outfile, level)
            outfile.write('Creation_Date=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Creation_Date.exportLiteral(outfile, level, name_='Creation_Date')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Most_Recent_Run_Time is not None:
            showIndent(outfile, level)
            outfile.write('Most_Recent_Run_Time=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Most_Recent_Run_Time.exportLiteral(outfile, level, name_='Most_Recent_Run_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exit_Code is not None:
            showIndent(outfile, level)
            outfile.write('Exit_Code=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.Exit_Code.exportLiteral(outfile, level, name_='Exit_Code')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Max_Run_Time is not None:
            showIndent(outfile, level)
            outfile.write('Max_Run_Time=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.Max_Run_Time.exportLiteral(outfile, level, name_='Max_Run_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Next_Run_Time is not None:
            showIndent(outfile, level)
            outfile.write('Next_Run_Time=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Next_Run_Time.exportLiteral(outfile, level, name_='Next_Run_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Action_List is not None:
            showIndent(outfile, level)
            outfile.write('Action_List=model_.TaskActionListType(\n')
            self.Action_List.exportLiteral(outfile, level, name_='Action_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Trigger_List is not None:
            showIndent(outfile, level)
            outfile.write('Trigger_List=model_.TriggerListType(\n')
            self.Trigger_List.exportLiteral(outfile, level, name_='Trigger_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Comment is not None:
            showIndent(outfile, level)
            outfile.write('Comment=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Comment.exportLiteral(outfile, level, name_='Comment')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Working_Directory is not None:
            showIndent(outfile, level)
            outfile.write('Working_Directory=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Working_Directory.exportLiteral(outfile, level, name_='Working_Directory')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Work_Item_Data is not None:
            showIndent(outfile, level)
            outfile.write('Work_Item_Data=model_.cybox_common_types_1_0.Base64BinaryObjectAttributeType(\n')
            self.Work_Item_Data.exportLiteral(outfile, level, name_='Work_Item_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsTaskObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Status':
            obj_ = TaskStatusType.factory()
            obj_.build(child_)
            self.set_Status(obj_)
        elif nodeName_ == 'Priority':
            obj_ = TaskPriorityType.factory()
            obj_.build(child_)
            self.set_Priority(obj_)
        elif nodeName_ == 'Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Application_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Application_Name(obj_)
        elif nodeName_ == 'Parameters':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Parameters(obj_)
        elif nodeName_ == 'Flags':
            obj_ = TaskFlagType.factory()
            obj_.build(child_)
            self.set_Flags(obj_)
        elif nodeName_ == 'Account_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Account_Name(obj_)
        elif nodeName_ == 'Account_Run_Level':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Account_Run_Level(obj_)
        elif nodeName_ == 'Account_Logon_Type':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Account_Logon_Type(obj_)
        elif nodeName_ == 'Creator':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Creator(obj_)
        elif nodeName_ == 'Creation_Date':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Creation_Date(obj_)
        elif nodeName_ == 'Most_Recent_Run_Time':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Most_Recent_Run_Time(obj_)
        elif nodeName_ == 'Exit_Code':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Exit_Code(obj_)
        elif nodeName_ == 'Max_Run_Time':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Max_Run_Time(obj_)
        elif nodeName_ == 'Next_Run_Time':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Next_Run_Time(obj_)
        elif nodeName_ == 'Action_List':
            obj_ = TaskActionListType.factory()
            obj_.build(child_)
            self.set_Action_List(obj_)
        elif nodeName_ == 'Trigger_List':
            obj_ = TriggerListType.factory()
            obj_.build(child_)
            self.set_Trigger_List(obj_)
        elif nodeName_ == 'Comment':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Comment(obj_)
        elif nodeName_ == 'Working_Directory':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Working_Directory(obj_)
        elif nodeName_ == 'Work_Item_Data':
            obj_ = cybox_common_types_1_0.Base64BinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Work_Item_Data(obj_)
        super(WindowsTaskObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsTaskObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Task'
        rootClass = WindowsTaskObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Task'
        rootClass = WindowsTaskObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Task",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Task'
        rootClass = WindowsTaskObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsTaskObjectType",
    "TriggerListType",
    "TriggerType",
    "TaskActionListType",
    "TaskActionType",
    "TaskActionTypeType",
    "IComHandlerActionType",
    "IExecActionType",
    "IShowMessageActionType",
    "TaskFlagType",
    "TaskPriorityType",
    "TaskTriggerFrequencyType",
    "TaskTriggerType",
    "TaskStatusType"
    ]