#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:04:35 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class X509CertificateType(GeneratedsSuper):
    """The X509CertificateType type represents the contents of an X.509
    certificate, including items such as issuer, subject, and
    others."""
    subclass = None
    superclass = None
    def __init__(self, Issuer=None, Serial_Number=None, Signature_Algorithm=None, Subject=None, Subject_Public_Key=None, Validity=None, Version=None):
        self.Issuer = Issuer
        self.Serial_Number = Serial_Number
        self.Signature_Algorithm = Signature_Algorithm
        self.Subject = Subject
        self.Subject_Public_Key = Subject_Public_Key
        self.Validity = Validity
        self.Version = Version
    def factory(*args_, **kwargs_):
        if X509CertificateType.subclass:
            return X509CertificateType.subclass(*args_, **kwargs_)
        else:
            return X509CertificateType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Issuer(self): return self.Issuer
    def set_Issuer(self, Issuer): self.Issuer = Issuer
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Serial_Number(self): return self.Serial_Number
    def set_Serial_Number(self, Serial_Number): self.Serial_Number = Serial_Number
    def validate_IntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.IntegerObjectAttributeType, a restriction on None.
        pass
    def get_Signature_Algorithm(self): return self.Signature_Algorithm
    def set_Signature_Algorithm(self, Signature_Algorithm): self.Signature_Algorithm = Signature_Algorithm
    def get_Subject(self): return self.Subject
    def set_Subject(self, Subject): self.Subject = Subject
    def get_Subject_Public_Key(self): return self.Subject_Public_Key
    def set_Subject_Public_Key(self, Subject_Public_Key): self.Subject_Public_Key = Subject_Public_Key
    def get_Validity(self): return self.Validity
    def set_Validity(self, Validity): self.Validity = Validity
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def export(self, outfile, level, namespace_='X509CertificateObj:', name_='X509CertificateType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='X509CertificateType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='X509CertificateObj:', name_='X509CertificateType'):
        pass
    def exportChildren(self, outfile, level, namespace_='X509CertificateObj:', name_='X509CertificateType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Issuer is not None:
            self.Issuer.export(outfile, level, 'X509CertificateObj:', name_='Issuer', pretty_print=pretty_print)
        if self.Serial_Number is not None:
            self.Serial_Number.export(outfile, level, 'X509CertificateObj:', name_='Serial_Number', pretty_print=pretty_print)
        if self.Signature_Algorithm is not None:
            self.Signature_Algorithm.export(outfile, level, 'X509CertificateObj:', name_='Signature_Algorithm', pretty_print=pretty_print)
        if self.Subject is not None:
            self.Subject.export(outfile, level, 'X509CertificateObj:', name_='Subject', pretty_print=pretty_print)
        if self.Subject_Public_Key is not None:
            self.Subject_Public_Key.export(outfile, level, 'X509CertificateObj:', name_='Subject_Public_Key', pretty_print=pretty_print)
        if self.Validity is not None:
            self.Validity.export(outfile, level, 'X509CertificateObj:', name_='Validity', pretty_print=pretty_print)
        if self.Version is not None:
            self.Version.export(outfile, level, 'X509CertificateObj:', name_='Version', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Issuer is not None or
            self.Serial_Number is not None or
            self.Signature_Algorithm is not None or
            self.Subject is not None or
            self.Subject_Public_Key is not None or
            self.Validity is not None or
            self.Version is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='X509CertificateType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Issuer is not None:
            showIndent(outfile, level)
            outfile.write('Issuer=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Issuer.exportLiteral(outfile, level, name_='Issuer')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Serial_Number is not None:
            showIndent(outfile, level)
            outfile.write('Serial_Number=model_.cybox_common_types_1_0.IntegerObjectAttributeType(\n')
            self.Serial_Number.exportLiteral(outfile, level, name_='Serial_Number')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Signature_Algorithm is not None:
            showIndent(outfile, level)
            outfile.write('Signature_Algorithm=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Signature_Algorithm.exportLiteral(outfile, level, name_='Signature_Algorithm')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Subject is not None:
            showIndent(outfile, level)
            outfile.write('Subject=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Subject.exportLiteral(outfile, level, name_='Subject')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Subject_Public_Key is not None:
            showIndent(outfile, level)
            outfile.write('Subject_Public_Key=model_.SubjectPublicKeyType(\n')
            self.Subject_Public_Key.exportLiteral(outfile, level, name_='Subject_Public_Key')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Validity is not None:
            showIndent(outfile, level)
            outfile.write('Validity=model_.ValidityType(\n')
            self.Validity.exportLiteral(outfile, level, name_='Validity')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('Version=model_.cybox_common_types_1_0.IntegerObjectAttributeType(\n')
            self.Version.exportLiteral(outfile, level, name_='Version')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Issuer':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Issuer(obj_)
        elif nodeName_ == 'Serial_Number':
            obj_ = cybox_common_types_1_0.IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Serial_Number(obj_)
        elif nodeName_ == 'Signature_Algorithm':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Signature_Algorithm(obj_)
        elif nodeName_ == 'Subject':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Subject(obj_)
        elif nodeName_ == 'Subject_Public_Key':
            obj_ = SubjectPublicKeyType.factory()
            obj_.build(child_)
            self.set_Subject_Public_Key(obj_)
        elif nodeName_ == 'Validity':
            obj_ = ValidityType.factory()
            obj_.build(child_)
            self.set_Validity(obj_)
        elif nodeName_ == 'Version':
            obj_ = cybox_common_types_1_0.IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Version(obj_)
# end class X509CertificateType

class X509CertificateSignatureType(GeneratedsSuper):
    """The X509CertificateSignatureType contains the signature and
    signature algorithm of this X.509 certificate."""
    subclass = None
    superclass = None
    def __init__(self, Signature=None, Signature_Algorithm=None):
        self.Signature = Signature
        self.Signature_Algorithm = Signature_Algorithm
    def factory(*args_, **kwargs_):
        if X509CertificateSignatureType.subclass:
            return X509CertificateSignatureType.subclass(*args_, **kwargs_)
        else:
            return X509CertificateSignatureType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Signature(self): return self.Signature
    def set_Signature(self, Signature): self.Signature = Signature
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Signature_Algorithm(self): return self.Signature_Algorithm
    def set_Signature_Algorithm(self, Signature_Algorithm): self.Signature_Algorithm = Signature_Algorithm
    def export(self, outfile, level, namespace_='X509CertificateObj:', name_='X509CertificateSignatureType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='X509CertificateSignatureType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='X509CertificateObj:', name_='X509CertificateSignatureType'):
        pass
    def exportChildren(self, outfile, level, namespace_='X509CertificateObj:', name_='X509CertificateSignatureType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Signature is not None:
            self.Signature.export(outfile, level, 'X509CertificateObj:', name_='Signature', pretty_print=pretty_print)
        if self.Signature_Algorithm is not None:
            self.Signature_Algorithm.export(outfile, level, 'X509CertificateObj:', name_='Signature_Algorithm', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Signature is not None or
            self.Signature_Algorithm is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='X509CertificateSignatureType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Signature is not None:
            showIndent(outfile, level)
            outfile.write('Signature=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Signature.exportLiteral(outfile, level, name_='Signature')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Signature_Algorithm is not None:
            showIndent(outfile, level)
            outfile.write('Signature_Algorithm=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Signature_Algorithm.exportLiteral(outfile, level, name_='Signature_Algorithm')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Signature':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Signature(obj_)
        elif nodeName_ == 'Signature_Algorithm':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Signature_Algorithm(obj_)
# end class X509CertificateSignatureType

class SubjectPublicKeyType(GeneratedsSuper):
    """The SubjectPublicKeyType is used to carry the public key and
    identify the algorithm with which the key is used."""
    subclass = None
    superclass = None
    def __init__(self, Public_Key_Algorithm=None, RSA_Public_Key=None):
        self.Public_Key_Algorithm = Public_Key_Algorithm
        self.RSA_Public_Key = RSA_Public_Key
    def factory(*args_, **kwargs_):
        if SubjectPublicKeyType.subclass:
            return SubjectPublicKeyType.subclass(*args_, **kwargs_)
        else:
            return SubjectPublicKeyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Public_Key_Algorithm(self): return self.Public_Key_Algorithm
    def set_Public_Key_Algorithm(self, Public_Key_Algorithm): self.Public_Key_Algorithm = Public_Key_Algorithm
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_RSA_Public_Key(self): return self.RSA_Public_Key
    def set_RSA_Public_Key(self, RSA_Public_Key): self.RSA_Public_Key = RSA_Public_Key
    def export(self, outfile, level, namespace_='X509CertificateObj:', name_='SubjectPublicKeyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SubjectPublicKeyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='X509CertificateObj:', name_='SubjectPublicKeyType'):
        pass
    def exportChildren(self, outfile, level, namespace_='X509CertificateObj:', name_='SubjectPublicKeyType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Public_Key_Algorithm is not None:
            self.Public_Key_Algorithm.export(outfile, level, 'X509CertificateObj:', name_='Public_Key_Algorithm', pretty_print=pretty_print)
        if self.RSA_Public_Key is not None:
            self.RSA_Public_Key.export(outfile, level, 'X509CertificateObj:', name_='RSA_Public_Key', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Public_Key_Algorithm is not None or
            self.RSA_Public_Key is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SubjectPublicKeyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Public_Key_Algorithm is not None:
            showIndent(outfile, level)
            outfile.write('Public_Key_Algorithm=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Public_Key_Algorithm.exportLiteral(outfile, level, name_='Public_Key_Algorithm')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.RSA_Public_Key is not None:
            showIndent(outfile, level)
            outfile.write('RSA_Public_Key=model_.RSAPublicKeyType(\n')
            self.RSA_Public_Key.exportLiteral(outfile, level, name_='RSA_Public_Key')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Public_Key_Algorithm':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Public_Key_Algorithm(obj_)
        elif nodeName_ == 'RSA_Public_Key':
            obj_ = RSAPublicKeyType.factory()
            obj_.build(child_)
            self.set_RSA_Public_Key(obj_)
# end class SubjectPublicKeyType

class ValidityType(GeneratedsSuper):
    """The ValidityType type is the time interval during which the issuer
    warrants that it will maintain information about the status of
    the certificate."""
    subclass = None
    superclass = None
    def __init__(self, Not_Before=None, Not_After=None):
        self.Not_Before = Not_Before
        self.Not_After = Not_After
    def factory(*args_, **kwargs_):
        if ValidityType.subclass:
            return ValidityType.subclass(*args_, **kwargs_)
        else:
            return ValidityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Not_Before(self): return self.Not_Before
    def set_Not_Before(self, Not_Before): self.Not_Before = Not_Before
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Not_After(self): return self.Not_After
    def set_Not_After(self, Not_After): self.Not_After = Not_After
    def export(self, outfile, level, namespace_='X509CertificateObj:', name_='ValidityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ValidityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='X509CertificateObj:', name_='ValidityType'):
        pass
    def exportChildren(self, outfile, level, namespace_='X509CertificateObj:', name_='ValidityType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Not_Before is not None:
            self.Not_Before.export(outfile, level, 'X509CertificateObj:', name_='Not_Before', pretty_print=pretty_print)
        if self.Not_After is not None:
            self.Not_After.export(outfile, level, 'X509CertificateObj:', name_='Not_After', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Not_Before is not None or
            self.Not_After is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ValidityType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Not_Before is not None:
            showIndent(outfile, level)
            outfile.write('Not_Before=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Not_Before.exportLiteral(outfile, level, name_='Not_Before')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Not_After is not None:
            showIndent(outfile, level)
            outfile.write('Not_After=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Not_After.exportLiteral(outfile, level, name_='Not_After')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Not_Before':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Not_Before(obj_)
        elif nodeName_ == 'Not_After':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Not_After(obj_)
# end class ValidityType

class RSAPublicKeyType(GeneratedsSuper):
    """The RSAPublicKeyType captures details of RSA public keys."""
    subclass = None
    superclass = None
    def __init__(self, Modulus=None, Exponent=None):
        self.Modulus = Modulus
        self.Exponent = Exponent
    def factory(*args_, **kwargs_):
        if RSAPublicKeyType.subclass:
            return RSAPublicKeyType.subclass(*args_, **kwargs_)
        else:
            return RSAPublicKeyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Modulus(self): return self.Modulus
    def set_Modulus(self, Modulus): self.Modulus = Modulus
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Exponent(self): return self.Exponent
    def set_Exponent(self, Exponent): self.Exponent = Exponent
    def export(self, outfile, level, namespace_='X509CertificateObj:', name_='RSAPublicKeyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RSAPublicKeyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='X509CertificateObj:', name_='RSAPublicKeyType'):
        pass
    def exportChildren(self, outfile, level, namespace_='X509CertificateObj:', name_='RSAPublicKeyType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Modulus is not None:
            self.Modulus.export(outfile, level, 'X509CertificateObj:', name_='Modulus', pretty_print=pretty_print)
        if self.Exponent is not None:
            self.Exponent.export(outfile, level, 'X509CertificateObj:', name_='Exponent', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Modulus is not None or
            self.Exponent is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RSAPublicKeyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Modulus is not None:
            showIndent(outfile, level)
            outfile.write('Modulus=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Modulus.exportLiteral(outfile, level, name_='Modulus')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exponent is not None:
            showIndent(outfile, level)
            outfile.write('Exponent=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Exponent.exportLiteral(outfile, level, name_='Exponent')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Modulus':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Modulus(obj_)
        elif nodeName_ == 'Exponent':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Exponent(obj_)
# end class RSAPublicKeyType

class X509CertificateObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The X509CertificateObjectType type is intended to characterize X.509
    certificates."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, Certificate=None, Certificate_Signature=None):
        super(X509CertificateObjectType, self).__init__(object_reference, )
        self.Certificate = Certificate
        self.Certificate_Signature = Certificate_Signature
    def factory(*args_, **kwargs_):
        if X509CertificateObjectType.subclass:
            return X509CertificateObjectType.subclass(*args_, **kwargs_)
        else:
            return X509CertificateObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Certificate(self): return self.Certificate
    def set_Certificate(self, Certificate): self.Certificate = Certificate
    def get_Certificate_Signature(self): return self.Certificate_Signature
    def set_Certificate_Signature(self, Certificate_Signature): self.Certificate_Signature = Certificate_Signature
    def export(self, outfile, level, namespace_='X509CertificateObj:', name_='X509CertificateObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='X509CertificateObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='X509CertificateObj:', name_='X509CertificateObjectType'):
        super(X509CertificateObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='X509CertificateObjectType')
    def exportChildren(self, outfile, level, namespace_='X509CertificateObj:', name_='X509CertificateObjectType', fromsubclass_=False, pretty_print=True):
        super(X509CertificateObjectType, self).exportChildren(outfile, level, 'X509CertificateObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Certificate is not None:
            self.Certificate.export(outfile, level, 'X509CertificateObj:', name_='Certificate', pretty_print=pretty_print)
        if self.Certificate_Signature is not None:
            self.Certificate_Signature.export(outfile, level, 'X509CertificateObj:', name_='Certificate_Signature', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Certificate is not None or
            self.Certificate_Signature is not None or
            super(X509CertificateObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='X509CertificateObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(X509CertificateObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(X509CertificateObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Certificate is not None:
            showIndent(outfile, level)
            outfile.write('Certificate=model_.X509CertificateType(\n')
            self.Certificate.exportLiteral(outfile, level, name_='Certificate')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Certificate_Signature is not None:
            showIndent(outfile, level)
            outfile.write('Certificate_Signature=model_.X509CertificateSignatureType(\n')
            self.Certificate_Signature.exportLiteral(outfile, level, name_='Certificate_Signature')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(X509CertificateObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Certificate':
            obj_ = X509CertificateType.factory()
            obj_.build(child_)
            self.set_Certificate(obj_)
        elif nodeName_ == 'Certificate_Signature':
            obj_ = X509CertificateSignatureType.factory()
            obj_.build(child_)
            self.set_Certificate_Signature(obj_)
        super(X509CertificateObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class X509CertificateObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'X509_Certificate'
        rootClass = X509CertificateObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'X509_Certificate'
        rootClass = X509CertificateObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="X509_Certificate",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'X509_Certificate'
        rootClass = X509CertificateObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "X509CertificateObjectType",
    "X509CertificateType",
    "X509CertificateSignatureType",
    "SubjectPublicKeyType",
    "ValidityType",
    "RSAPublicKeyType"
    ]