#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:02:29 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import file_object_1_3
import address_object_1_2
import uri_object_1_2

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class AttachmentsType(GeneratedsSuper):
    """A list of attachments for an email message"""
    subclass = None
    superclass = None
    def __init__(self, File=None):
        if File is None:
            self.File = []
        else:
            self.File = File
    def factory(*args_, **kwargs_):
        if AttachmentsType.subclass:
            return AttachmentsType.subclass(*args_, **kwargs_)
        else:
            return AttachmentsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def add_File(self, value): self.File.append(value)
    def insert_File(self, index, value): self.File[index] = value
    def export(self, outfile, level, namespace_='EmailMessageObj:', name_='AttachmentsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AttachmentsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='EmailMessageObj:', name_='AttachmentsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='EmailMessageObj:', name_='AttachmentsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for File_ in self.File:
            File_.export(outfile, level, 'EmailMessageObj:', name_='File', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.File
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AttachmentsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('File=[\n')
        level += 1
        for File_ in self.File:
            showIndent(outfile, level)
            outfile.write('model_.file_object_1_3.FileObjectType(\n')
            File_.exportLiteral(outfile, level, name_='file_object_1_3.FileObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File':
            obj_ = file_object_1_3.FileObjectType.factory()
            obj_.build(child_)
            self.File.append(obj_)
# end class AttachmentsType

class EmailHeaderType(GeneratedsSuper):
    """A representation of a standard email header"""
    subclass = None
    superclass = None
    def __init__(self, To=None, CC=None, BCC=None, From=None, Subject=None, In_Reply_To=None, Date=None, Message_ID=None, Sender=None, Reply_To=None, Errors_To=None):
        self.To = To
        self.CC = CC
        self.BCC = BCC
        self.From = From
        self.Subject = Subject
        self.In_Reply_To = In_Reply_To
        self.Date = Date
        self.Message_ID = Message_ID
        self.Sender = Sender
        self.Reply_To = Reply_To
        self.Errors_To = Errors_To
    def factory(*args_, **kwargs_):
        if EmailHeaderType.subclass:
            return EmailHeaderType.subclass(*args_, **kwargs_)
        else:
            return EmailHeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_To(self): return self.To
    def set_To(self, To): self.To = To
    def get_CC(self): return self.CC
    def set_CC(self, CC): self.CC = CC
    def get_BCC(self): return self.BCC
    def set_BCC(self, BCC): self.BCC = BCC
    def get_From(self): return self.From
    def set_From(self, From): self.From = From
    def get_Subject(self): return self.Subject
    def set_Subject(self, Subject): self.Subject = Subject
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_In_Reply_To(self): return self.In_Reply_To
    def set_In_Reply_To(self, In_Reply_To): self.In_Reply_To = In_Reply_To
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Message_ID(self): return self.Message_ID
    def set_Message_ID(self, Message_ID): self.Message_ID = Message_ID
    def get_Sender(self): return self.Sender
    def set_Sender(self, Sender): self.Sender = Sender
    def get_Reply_To(self): return self.Reply_To
    def set_Reply_To(self, Reply_To): self.Reply_To = Reply_To
    def get_Errors_To(self): return self.Errors_To
    def set_Errors_To(self, Errors_To): self.Errors_To = Errors_To
    def export(self, outfile, level, namespace_='EmailMessageObj:', name_='EmailHeaderType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EmailHeaderType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='EmailMessageObj:', name_='EmailHeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='EmailMessageObj:', name_='EmailHeaderType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.To is not None:
            self.To.export(outfile, level, 'EmailMessageObj:', name_='To', pretty_print=pretty_print)
        if self.CC is not None:
            self.CC.export(outfile, level, 'EmailMessageObj:', name_='CC', pretty_print=pretty_print)
        if self.BCC is not None:
            self.BCC.export(outfile, level, 'EmailMessageObj:', name_='BCC', pretty_print=pretty_print)
        if self.From is not None:
            self.From.export(outfile, level, 'EmailMessageObj:', name_='From', pretty_print=pretty_print)
        if self.Subject is not None:
            self.Subject.export(outfile, level, 'EmailMessageObj:', name_='Subject', pretty_print=pretty_print)
        if self.In_Reply_To is not None:
            self.In_Reply_To.export(outfile, level, 'EmailMessageObj:', name_='In_Reply_To', pretty_print=pretty_print)
        if self.Date is not None:
            self.Date.export(outfile, level, 'EmailMessageObj:', name_='Date', pretty_print=pretty_print)
        if self.Message_ID is not None:
            self.Message_ID.export(outfile, level, 'EmailMessageObj:', name_='Message_ID', pretty_print=pretty_print)
        if self.Sender is not None:
            self.Sender.export(outfile, level, 'EmailMessageObj:', name_='Sender', pretty_print=pretty_print)
        if self.Reply_To is not None:
            self.Reply_To.export(outfile, level, 'EmailMessageObj:', name_='Reply_To', pretty_print=pretty_print)
        if self.Errors_To is not None:
            self.Errors_To.export(outfile, level, 'EmailMessageObj:', name_='Errors_To', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.To is not None or
            self.CC is not None or
            self.BCC is not None or
            self.From is not None or
            self.Subject is not None or
            self.In_Reply_To is not None or
            self.Date is not None or
            self.Message_ID is not None or
            self.Sender is not None or
            self.Reply_To is not None or
            self.Errors_To is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EmailHeaderType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.To is not None:
            showIndent(outfile, level)
            outfile.write('To=model_.EmailRecipientsType(\n')
            self.To.exportLiteral(outfile, level, name_='To')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.CC is not None:
            showIndent(outfile, level)
            outfile.write('CC=model_.EmailRecipientsType(\n')
            self.CC.exportLiteral(outfile, level, name_='CC')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.BCC is not None:
            showIndent(outfile, level)
            outfile.write('BCC=model_.EmailRecipientsType(\n')
            self.BCC.exportLiteral(outfile, level, name_='BCC')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.From is not None:
            showIndent(outfile, level)
            outfile.write('From=model_.address_object_1_2.AddressObjectType(\n')
            self.From.exportLiteral(outfile, level, name_='From')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Subject is not None:
            showIndent(outfile, level)
            outfile.write('Subject=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Subject.exportLiteral(outfile, level, name_='Subject')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.In_Reply_To is not None:
            showIndent(outfile, level)
            outfile.write('In_Reply_To=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.In_Reply_To.exportLiteral(outfile, level, name_='In_Reply_To')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Date is not None:
            showIndent(outfile, level)
            outfile.write('Date=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Date.exportLiteral(outfile, level, name_='Date')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Message_ID is not None:
            showIndent(outfile, level)
            outfile.write('Message_ID=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Message_ID.exportLiteral(outfile, level, name_='Message_ID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Sender is not None:
            showIndent(outfile, level)
            outfile.write('Sender=model_.address_object_1_2.AddressObjectType(\n')
            self.Sender.exportLiteral(outfile, level, name_='Sender')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Reply_To is not None:
            showIndent(outfile, level)
            outfile.write('Reply_To=model_.address_object_1_2.AddressObjectType(\n')
            self.Reply_To.exportLiteral(outfile, level, name_='Reply_To')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Errors_To is not None:
            showIndent(outfile, level)
            outfile.write('Errors_To=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Errors_To.exportLiteral(outfile, level, name_='Errors_To')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'To':
            obj_ = EmailRecipientsType.factory()
            obj_.build(child_)
            self.set_To(obj_)
        elif nodeName_ == 'CC':
            obj_ = EmailRecipientsType.factory()
            obj_.build(child_)
            self.set_CC(obj_)
        elif nodeName_ == 'BCC':
            obj_ = EmailRecipientsType.factory()
            obj_.build(child_)
            self.set_BCC(obj_)
        elif nodeName_ == 'From':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_From(obj_)
        elif nodeName_ == 'Subject':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Subject(obj_)
        elif nodeName_ == 'In_Reply_To':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_In_Reply_To(obj_)
        elif nodeName_ == 'Date':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Date(obj_)
        elif nodeName_ == 'Message_ID':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Message_ID(obj_)
        elif nodeName_ == 'Sender':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_Sender(obj_)
        elif nodeName_ == 'Reply_To':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_Reply_To(obj_)
        elif nodeName_ == 'Errors_To':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Errors_To(obj_)
# end class EmailHeaderType

class EmailOptionalHeaderType(GeneratedsSuper):
    """A representation of optional email header members"""
    subclass = None
    superclass = None
    def __init__(self, Boundary=None, Content_Type=None, MIME_Version=None, Precedence=None, X_Mailer=None, X_Originating_IP=None, X_Priority=None):
        self.Boundary = Boundary
        self.Content_Type = Content_Type
        self.MIME_Version = MIME_Version
        self.Precedence = Precedence
        self.X_Mailer = X_Mailer
        self.X_Originating_IP = X_Originating_IP
        self.X_Priority = X_Priority
    def factory(*args_, **kwargs_):
        if EmailOptionalHeaderType.subclass:
            return EmailOptionalHeaderType.subclass(*args_, **kwargs_)
        else:
            return EmailOptionalHeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Boundary(self): return self.Boundary
    def set_Boundary(self, Boundary): self.Boundary = Boundary
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Content_Type(self): return self.Content_Type
    def set_Content_Type(self, Content_Type): self.Content_Type = Content_Type
    def get_MIME_Version(self): return self.MIME_Version
    def set_MIME_Version(self, MIME_Version): self.MIME_Version = MIME_Version
    def get_Precedence(self): return self.Precedence
    def set_Precedence(self, Precedence): self.Precedence = Precedence
    def get_X_Mailer(self): return self.X_Mailer
    def set_X_Mailer(self, X_Mailer): self.X_Mailer = X_Mailer
    def get_X_Originating_IP(self): return self.X_Originating_IP
    def set_X_Originating_IP(self, X_Originating_IP): self.X_Originating_IP = X_Originating_IP
    def get_X_Priority(self): return self.X_Priority
    def set_X_Priority(self, X_Priority): self.X_Priority = X_Priority
    def validate_PositiveIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.PositiveIntegerObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='EmailMessageObj:', name_='EmailOptionalHeaderType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EmailOptionalHeaderType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='EmailMessageObj:', name_='EmailOptionalHeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='EmailMessageObj:', name_='EmailOptionalHeaderType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Boundary is not None:
            self.Boundary.export(outfile, level, 'EmailMessageObj:', name_='Boundary', pretty_print=pretty_print)
        if self.Content_Type is not None:
            self.Content_Type.export(outfile, level, 'EmailMessageObj:', name_='Content-Type', pretty_print=pretty_print)
        if self.MIME_Version is not None:
            self.MIME_Version.export(outfile, level, 'EmailMessageObj:', name_='MIME-Version', pretty_print=pretty_print)
        if self.Precedence is not None:
            self.Precedence.export(outfile, level, 'EmailMessageObj:', name_='Precedence', pretty_print=pretty_print)
        if self.X_Mailer is not None:
            self.X_Mailer.export(outfile, level, 'EmailMessageObj:', name_='X-Mailer', pretty_print=pretty_print)
        if self.X_Originating_IP is not None:
            self.X_Originating_IP.export(outfile, level, 'EmailMessageObj:', name_='X-Originating-IP', pretty_print=pretty_print)
        if self.X_Priority is not None:
            self.X_Priority.export(outfile, level, 'EmailMessageObj:', name_='X-Priority', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Boundary is not None or
            self.Content_Type is not None or
            self.MIME_Version is not None or
            self.Precedence is not None or
            self.X_Mailer is not None or
            self.X_Originating_IP is not None or
            self.X_Priority is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EmailOptionalHeaderType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Boundary is not None:
            showIndent(outfile, level)
            outfile.write('Boundary=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Boundary.exportLiteral(outfile, level, name_='Boundary')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Content_Type is not None:
            showIndent(outfile, level)
            outfile.write('Content_Type=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Content_Type.exportLiteral(outfile, level, name_='Content_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.MIME_Version is not None:
            showIndent(outfile, level)
            outfile.write('MIME_Version=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.MIME_Version.exportLiteral(outfile, level, name_='MIME_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Precedence is not None:
            showIndent(outfile, level)
            outfile.write('Precedence=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Precedence.exportLiteral(outfile, level, name_='Precedence')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.X_Mailer is not None:
            showIndent(outfile, level)
            outfile.write('X_Mailer=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.X_Mailer.exportLiteral(outfile, level, name_='X_Mailer')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.X_Originating_IP is not None:
            showIndent(outfile, level)
            outfile.write('X_Originating_IP=model_.address_object_1_2.AddressObjectType(\n')
            self.X_Originating_IP.exportLiteral(outfile, level, name_='X_Originating_IP')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.X_Priority is not None:
            showIndent(outfile, level)
            outfile.write('X_Priority=model_.cybox_common_types_1_0.PositiveIntegerObjectAttributeType(\n')
            self.X_Priority.exportLiteral(outfile, level, name_='X_Priority')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Boundary':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Boundary(obj_)
        elif nodeName_ == 'Content-Type':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Content_Type(obj_)
        elif nodeName_ == 'MIME-Version':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_MIME_Version(obj_)
        elif nodeName_ == 'Precedence':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Precedence(obj_)
        elif nodeName_ == 'X-Mailer':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_X_Mailer(obj_)
        elif nodeName_ == 'X-Originating-IP':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_X_Originating_IP(obj_)
        elif nodeName_ == 'X-Priority':
            obj_ = cybox_common_types_1_0.PositiveIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_X_Priority(obj_)
# end class EmailOptionalHeaderType

class EmailRecipientsType(GeneratedsSuper):
    """A list of recipients for an email message"""
    subclass = None
    superclass = None
    def __init__(self, Recipient=None):
        if Recipient is None:
            self.Recipient = []
        else:
            self.Recipient = Recipient
    def factory(*args_, **kwargs_):
        if EmailRecipientsType.subclass:
            return EmailRecipientsType.subclass(*args_, **kwargs_)
        else:
            return EmailRecipientsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Recipient(self): return self.Recipient
    def set_Recipient(self, Recipient): self.Recipient = Recipient
    def add_Recipient(self, value): self.Recipient.append(value)
    def insert_Recipient(self, index, value): self.Recipient[index] = value
    def export(self, outfile, level, namespace_='EmailMessageObj:', name_='EmailRecipientsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EmailRecipientsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='EmailMessageObj:', name_='EmailRecipientsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='EmailMessageObj:', name_='EmailRecipientsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Recipient_ in self.Recipient:
            Recipient_.export(outfile, level, 'EmailMessageObj:', name_='Recipient', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Recipient
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EmailRecipientsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Recipient=[\n')
        level += 1
        for Recipient_ in self.Recipient:
            showIndent(outfile, level)
            outfile.write('model_.address_object_1_2.AddressObjectType(\n')
            Recipient_.exportLiteral(outfile, level, name_='address_object_1_2.AddressObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Recipient':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.Recipient.append(obj_)
# end class EmailRecipientsType

class LinksType(GeneratedsSuper):
    """A list of URIs, representing the links contained in the message."""
    subclass = None
    superclass = None
    def __init__(self, Link=None):
        if Link is None:
            self.Link = []
        else:
            self.Link = Link
    def factory(*args_, **kwargs_):
        if LinksType.subclass:
            return LinksType.subclass(*args_, **kwargs_)
        else:
            return LinksType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Link(self): return self.Link
    def set_Link(self, Link): self.Link = Link
    def add_Link(self, value): self.Link.append(value)
    def insert_Link(self, index, value): self.Link[index] = value
    def export(self, outfile, level, namespace_='EmailMessageObj:', name_='LinksType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinksType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='EmailMessageObj:', name_='LinksType'):
        pass
    def exportChildren(self, outfile, level, namespace_='EmailMessageObj:', name_='LinksType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Link_ in self.Link:
            Link_.export(outfile, level, 'EmailMessageObj:', name_='Link', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Link
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='LinksType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Link=[\n')
        level += 1
        for Link_ in self.Link:
            showIndent(outfile, level)
            outfile.write('model_.uri_object_1_2.URIObjectType(\n')
            Link_.exportLiteral(outfile, level, name_='uri_object_1_2.URIObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Link':
            obj_ = uri_object_1_2.URIObjectType.factory()
            obj_.build(child_)
            self.Link.append(obj_)
# end class LinksType

class EmailMessageObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The EmailMessageObjectType type is intended to characterize an
    individual email message."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, Attachments=None, Links=None, Header=None, Optional_Header=None, Email_Server=None, Raw_Body=None, Raw_Header=None):
        super(EmailMessageObjectType, self).__init__(object_reference, )
        self.Attachments = Attachments
        self.Links = Links
        self.Header = Header
        self.Optional_Header = Optional_Header
        self.Email_Server = Email_Server
        self.Raw_Body = Raw_Body
        self.Raw_Header = Raw_Header
    def factory(*args_, **kwargs_):
        if EmailMessageObjectType.subclass:
            return EmailMessageObjectType.subclass(*args_, **kwargs_)
        else:
            return EmailMessageObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Attachments(self): return self.Attachments
    def set_Attachments(self, Attachments): self.Attachments = Attachments
    def get_Links(self): return self.Links
    def set_Links(self, Links): self.Links = Links
    def get_Header(self): return self.Header
    def set_Header(self, Header): self.Header = Header
    def get_Optional_Header(self): return self.Optional_Header
    def set_Optional_Header(self, Optional_Header): self.Optional_Header = Optional_Header
    def get_Email_Server(self): return self.Email_Server
    def set_Email_Server(self, Email_Server): self.Email_Server = Email_Server
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Raw_Body(self): return self.Raw_Body
    def set_Raw_Body(self, Raw_Body): self.Raw_Body = Raw_Body
    def get_Raw_Header(self): return self.Raw_Header
    def set_Raw_Header(self, Raw_Header): self.Raw_Header = Raw_Header
    def export(self, outfile, level, namespace_='EmailMessageObj:', name_='EmailMessageObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EmailMessageObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='EmailMessageObj:', name_='EmailMessageObjectType'):
        super(EmailMessageObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EmailMessageObjectType')
    def exportChildren(self, outfile, level, namespace_='EmailMessageObj:', name_='EmailMessageObjectType', fromsubclass_=False, pretty_print=True):
        super(EmailMessageObjectType, self).exportChildren(outfile, level, 'EmailMessageObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Attachments is not None:
            self.Attachments.export(outfile, level, 'EmailMessageObj:', name_='Attachments', pretty_print=pretty_print)
        if self.Links is not None:
            self.Links.export(outfile, level, 'EmailMessageObj:', name_='Links', pretty_print=pretty_print)
        if self.Header is not None:
            self.Header.export(outfile, level, 'EmailMessageObj:', name_='Header', pretty_print=pretty_print)
        if self.Optional_Header is not None:
            self.Optional_Header.export(outfile, level, 'EmailMessageObj:', name_='Optional_Header', pretty_print=pretty_print)
        if self.Email_Server is not None:
            self.Email_Server.export(outfile, level, 'EmailMessageObj:', name_='Email_Server', pretty_print=pretty_print)
        if self.Raw_Body is not None:
            self.Raw_Body.export(outfile, level, 'EmailMessageObj:', name_='Raw_Body', pretty_print=pretty_print)
        if self.Raw_Header is not None:
            self.Raw_Header.export(outfile, level, 'EmailMessageObj:', name_='Raw_Header', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Attachments is not None or
            self.Links is not None or
            self.Header is not None or
            self.Optional_Header is not None or
            self.Email_Server is not None or
            self.Raw_Body is not None or
            self.Raw_Header is not None or
            super(EmailMessageObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EmailMessageObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(EmailMessageObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EmailMessageObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Attachments is not None:
            showIndent(outfile, level)
            outfile.write('Attachments=model_.AttachmentsType(\n')
            self.Attachments.exportLiteral(outfile, level, name_='Attachments')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Links is not None:
            showIndent(outfile, level)
            outfile.write('Links=model_.LinksType(\n')
            self.Links.exportLiteral(outfile, level, name_='Links')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Header is not None:
            showIndent(outfile, level)
            outfile.write('Header=model_.EmailHeaderType(\n')
            self.Header.exportLiteral(outfile, level, name_='Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Optional_Header is not None:
            showIndent(outfile, level)
            outfile.write('Optional_Header=model_.EmailOptionalHeaderType(\n')
            self.Optional_Header.exportLiteral(outfile, level, name_='Optional_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Email_Server is not None:
            showIndent(outfile, level)
            outfile.write('Email_Server=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Email_Server.exportLiteral(outfile, level, name_='Email_Server')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Raw_Body is not None:
            showIndent(outfile, level)
            outfile.write('Raw_Body=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Raw_Body.exportLiteral(outfile, level, name_='Raw_Body')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Raw_Header is not None:
            showIndent(outfile, level)
            outfile.write('Raw_Header=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Raw_Header.exportLiteral(outfile, level, name_='Raw_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(EmailMessageObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Attachments':
            obj_ = AttachmentsType.factory()
            obj_.build(child_)
            self.set_Attachments(obj_)
        elif nodeName_ == 'Links':
            obj_ = LinksType.factory()
            obj_.build(child_)
            self.set_Links(obj_)
        elif nodeName_ == 'Header':
            obj_ = EmailHeaderType.factory()
            obj_.build(child_)
            self.set_Header(obj_)
        elif nodeName_ == 'Optional_Header':
            obj_ = EmailOptionalHeaderType.factory()
            obj_.build(child_)
            self.set_Optional_Header(obj_)
        elif nodeName_ == 'Email_Server':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Email_Server(obj_)
        elif nodeName_ == 'Raw_Body':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Raw_Body(obj_)
        elif nodeName_ == 'Raw_Header':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Raw_Header(obj_)
        super(EmailMessageObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class EmailMessageObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Email_Message'
        rootClass = EmailMessageObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Email_Message'
        rootClass = EmailMessageObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Email_Message",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Email_Message'
        rootClass = EmailMessageObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "EmailMessageObjectType",
    "AttachmentsType",
    "EmailHeaderType",
    "EmailOptionalHeaderType",
    "EmailRecipientsType",
    "LinksType"
    ]