#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:03:31 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import file_object_1_3

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class UnixFileType(cybox_common_types_1_0.BaseObjectAttributeType):
    """UnixFileType specifies Unix file types, via a union of the
    UnixFileTypeEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(UnixFileType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if UnixFileType.subclass:
            return UnixFileType.subclass(*args_, **kwargs_)
        else:
            return UnixFileType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='UnixFileObj:', name_='UnixFileType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UnixFileType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='UnixFileObj:', name_='UnixFileType'):
        super(UnixFileType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='UnixFileType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='UnixFileObj:', name_='UnixFileType', fromsubclass_=False, pretty_print=True):
        super(UnixFileType, self).exportChildren(outfile, level, 'UnixFileObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(UnixFileType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='UnixFileType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(UnixFileType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(UnixFileType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(UnixFileType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class UnixFileType

class UnixFilePermissionsType(file_object_1_3.FilePermissionsType):
    """The UnixFilePermissionsType type specifies the specific permissions
    used by the Unix family of operating systems.The suid attribute
    specifies whether or not the file may be exectued with the
    privileges of the file's owner.The sgid attribute specifies
    whether or not the file may be executed with the privileges of
    the file's group owner.The uread attribute specifies whether or
    not the owner of the file can read its contents.The uwrite
    attribute specifies whether or not the owner of the file can
    write to it.The uexec attribute specifies whether or not the
    owner of the file can execute it.The gread attribute specifies
    whether or not the group owner of the file can read its
    contents.The gwrite attribute specifies whether or not the group
    owner of the file can write to it.The gexec attribute specifies
    whether or not the group owner of the file can execute it.The
    oread attribute specifies whether or not all other users can
    read the contents of the file.The owrite attribute specifies
    whether or not all other users can write to the file.The oexec
    attribute specifies whether or not all other users can execute
    the file."""
    subclass = None
    superclass = file_object_1_3.FilePermissionsType
    def __init__(self, gwrite=None, suid=None, oexec=None, owrite=None, uwrite=None, gexec=None, gread=None, uexec=None, uread=None, sgid=None, oread=None):
        super(UnixFilePermissionsType, self).__init__()
        self.gwrite = _cast(bool, gwrite)
        self.suid = _cast(bool, suid)
        self.oexec = _cast(bool, oexec)
        self.owrite = _cast(bool, owrite)
        self.uwrite = _cast(bool, uwrite)
        self.gexec = _cast(bool, gexec)
        self.gread = _cast(bool, gread)
        self.uexec = _cast(bool, uexec)
        self.uread = _cast(bool, uread)
        self.sgid = _cast(bool, sgid)
        self.oread = _cast(bool, oread)
        pass
    def factory(*args_, **kwargs_):
        if UnixFilePermissionsType.subclass:
            return UnixFilePermissionsType.subclass(*args_, **kwargs_)
        else:
            return UnixFilePermissionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_gwrite(self): return self.gwrite
    def set_gwrite(self, gwrite): self.gwrite = gwrite
    def get_suid(self): return self.suid
    def set_suid(self, suid): self.suid = suid
    def get_oexec(self): return self.oexec
    def set_oexec(self, oexec): self.oexec = oexec
    def get_owrite(self): return self.owrite
    def set_owrite(self, owrite): self.owrite = owrite
    def get_uwrite(self): return self.uwrite
    def set_uwrite(self, uwrite): self.uwrite = uwrite
    def get_gexec(self): return self.gexec
    def set_gexec(self, gexec): self.gexec = gexec
    def get_gread(self): return self.gread
    def set_gread(self, gread): self.gread = gread
    def get_uexec(self): return self.uexec
    def set_uexec(self, uexec): self.uexec = uexec
    def get_uread(self): return self.uread
    def set_uread(self, uread): self.uread = uread
    def get_sgid(self): return self.sgid
    def set_sgid(self, sgid): self.sgid = sgid
    def get_oread(self): return self.oread
    def set_oread(self, oread): self.oread = oread
    def export(self, outfile, level, namespace_='UnixFileObj:', name_='UnixFilePermissionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UnixFilePermissionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='UnixFileObj:', name_='UnixFilePermissionsType'):
        super(UnixFilePermissionsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='UnixFilePermissionsType')
        if self.gwrite is not None and 'gwrite' not in already_processed:
            already_processed.append('gwrite')
            outfile.write(' gwrite="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.gwrite)), input_name='gwrite'))
        if self.suid is not None and 'suid' not in already_processed:
            already_processed.append('suid')
            outfile.write(' suid="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.suid)), input_name='suid'))
        if self.oexec is not None and 'oexec' not in already_processed:
            already_processed.append('oexec')
            outfile.write(' oexec="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.oexec)), input_name='oexec'))
        if self.owrite is not None and 'owrite' not in already_processed:
            already_processed.append('owrite')
            outfile.write(' owrite="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.owrite)), input_name='owrite'))
        if self.uwrite is not None and 'uwrite' not in already_processed:
            already_processed.append('uwrite')
            outfile.write(' uwrite="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.uwrite)), input_name='uwrite'))
        if self.gexec is not None and 'gexec' not in already_processed:
            already_processed.append('gexec')
            outfile.write(' gexec="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.gexec)), input_name='gexec'))
        if self.gread is not None and 'gread' not in already_processed:
            already_processed.append('gread')
            outfile.write(' gread="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.gread)), input_name='gread'))
        if self.uexec is not None and 'uexec' not in already_processed:
            already_processed.append('uexec')
            outfile.write(' uexec="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.uexec)), input_name='uexec'))
        if self.uread is not None and 'uread' not in already_processed:
            already_processed.append('uread')
            outfile.write(' uread="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.uread)), input_name='uread'))
        if self.sgid is not None and 'sgid' not in already_processed:
            already_processed.append('sgid')
            outfile.write(' sgid="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.sgid)), input_name='sgid'))
        if self.oread is not None and 'oread' not in already_processed:
            already_processed.append('oread')
            outfile.write(' oread="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.oread)), input_name='oread'))
    def exportChildren(self, outfile, level, namespace_='UnixFileObj:', name_='UnixFilePermissionsType', fromsubclass_=False, pretty_print=True):
        super(UnixFilePermissionsType, self).exportChildren(outfile, level, 'UnixFileObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            super(UnixFilePermissionsType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='UnixFilePermissionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.gwrite is not None and 'gwrite' not in already_processed:
            already_processed.append('gwrite')
            showIndent(outfile, level)
            outfile.write('gwrite = %s,\n' % (self.gwrite,))
        if self.suid is not None and 'suid' not in already_processed:
            already_processed.append('suid')
            showIndent(outfile, level)
            outfile.write('suid = %s,\n' % (self.suid,))
        if self.oexec is not None and 'oexec' not in already_processed:
            already_processed.append('oexec')
            showIndent(outfile, level)
            outfile.write('oexec = %s,\n' % (self.oexec,))
        if self.owrite is not None and 'owrite' not in already_processed:
            already_processed.append('owrite')
            showIndent(outfile, level)
            outfile.write('owrite = %s,\n' % (self.owrite,))
        if self.uwrite is not None and 'uwrite' not in already_processed:
            already_processed.append('uwrite')
            showIndent(outfile, level)
            outfile.write('uwrite = %s,\n' % (self.uwrite,))
        if self.gexec is not None and 'gexec' not in already_processed:
            already_processed.append('gexec')
            showIndent(outfile, level)
            outfile.write('gexec = %s,\n' % (self.gexec,))
        if self.gread is not None and 'gread' not in already_processed:
            already_processed.append('gread')
            showIndent(outfile, level)
            outfile.write('gread = %s,\n' % (self.gread,))
        if self.uexec is not None and 'uexec' not in already_processed:
            already_processed.append('uexec')
            showIndent(outfile, level)
            outfile.write('uexec = %s,\n' % (self.uexec,))
        if self.uread is not None and 'uread' not in already_processed:
            already_processed.append('uread')
            showIndent(outfile, level)
            outfile.write('uread = %s,\n' % (self.uread,))
        if self.sgid is not None and 'sgid' not in already_processed:
            already_processed.append('sgid')
            showIndent(outfile, level)
            outfile.write('sgid = %s,\n' % (self.sgid,))
        if self.oread is not None and 'oread' not in already_processed:
            already_processed.append('oread')
            showIndent(outfile, level)
            outfile.write('oread = %s,\n' % (self.oread,))
        super(UnixFilePermissionsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(UnixFilePermissionsType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('gwrite', node)
        if value is not None and 'gwrite' not in already_processed:
            already_processed.append('gwrite')
            if value in ('true', '1'):
                self.gwrite = True
            elif value in ('false', '0'):
                self.gwrite = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('suid', node)
        if value is not None and 'suid' not in already_processed:
            already_processed.append('suid')
            if value in ('true', '1'):
                self.suid = True
            elif value in ('false', '0'):
                self.suid = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('oexec', node)
        if value is not None and 'oexec' not in already_processed:
            already_processed.append('oexec')
            if value in ('true', '1'):
                self.oexec = True
            elif value in ('false', '0'):
                self.oexec = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('owrite', node)
        if value is not None and 'owrite' not in already_processed:
            already_processed.append('owrite')
            if value in ('true', '1'):
                self.owrite = True
            elif value in ('false', '0'):
                self.owrite = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('uwrite', node)
        if value is not None and 'uwrite' not in already_processed:
            already_processed.append('uwrite')
            if value in ('true', '1'):
                self.uwrite = True
            elif value in ('false', '0'):
                self.uwrite = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('gexec', node)
        if value is not None and 'gexec' not in already_processed:
            already_processed.append('gexec')
            if value in ('true', '1'):
                self.gexec = True
            elif value in ('false', '0'):
                self.gexec = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('gread', node)
        if value is not None and 'gread' not in already_processed:
            already_processed.append('gread')
            if value in ('true', '1'):
                self.gread = True
            elif value in ('false', '0'):
                self.gread = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('uexec', node)
        if value is not None and 'uexec' not in already_processed:
            already_processed.append('uexec')
            if value in ('true', '1'):
                self.uexec = True
            elif value in ('false', '0'):
                self.uexec = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('uread', node)
        if value is not None and 'uread' not in already_processed:
            already_processed.append('uread')
            if value in ('true', '1'):
                self.uread = True
            elif value in ('false', '0'):
                self.uread = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('sgid', node)
        if value is not None and 'sgid' not in already_processed:
            already_processed.append('sgid')
            if value in ('true', '1'):
                self.sgid = True
            elif value in ('false', '0'):
                self.sgid = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('oread', node)
        if value is not None and 'oread' not in already_processed:
            already_processed.append('oread')
            if value in ('true', '1'):
                self.oread = True
            elif value in ('false', '0'):
                self.oread = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(UnixFilePermissionsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(UnixFilePermissionsType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class UnixFilePermissionsType

class UnixFileObjectType(file_object_1_3.FileObjectType):
    """The UnixFileObjectType type is intended to characterize Unix files."""
    subclass = None
    superclass = file_object_1_3.FileObjectType
    def __init__(self, object_reference=None, is_packed=None, File_Name=None, File_Path=None, Device_Path=None, Full_Path=None, File_Extension=None, Size_In_Bytes=None, Magic_Number=None, File_Format=None, Hashes=None, Digital_Signatures=None, Modified_Time=None, Accessed_Time=None, Created_Time=None, File_Attributes_List=None, Permissions=None, User_Owner=None, Packer_List=None, Peak_Entropy=None, Sym_Links=None, Byte_Runs=None, Group_Owner=None, INode=None, Type=None):
        super(UnixFileObjectType, self).__init__(object_reference, is_packed, File_Name, File_Path, Device_Path, Full_Path, File_Extension, Size_In_Bytes, Magic_Number, File_Format, Hashes, Digital_Signatures, Modified_Time, Accessed_Time, Created_Time, File_Attributes_List, Permissions, User_Owner, Packer_List, Peak_Entropy, Sym_Links, Byte_Runs, )
        self.Group_Owner = Group_Owner
        self.INode = INode
        self.Type = Type
    def factory(*args_, **kwargs_):
        if UnixFileObjectType.subclass:
            return UnixFileObjectType.subclass(*args_, **kwargs_)
        else:
            return UnixFileObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Group_Owner(self): return self.Group_Owner
    def set_Group_Owner(self, Group_Owner): self.Group_Owner = Group_Owner
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_INode(self): return self.INode
    def set_INode(self, INode): self.INode = INode
    def validate_UnsignedLongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedLongObjectAttributeType, a restriction on None.
        pass
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_UnixFileType(self, value):
        # Validate type UnixFileType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='UnixFileObj:', name_='UnixFileObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UnixFileObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='UnixFileObj:', name_='UnixFileObjectType'):
        super(UnixFileObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='UnixFileObjectType')
    def exportChildren(self, outfile, level, namespace_='UnixFileObj:', name_='UnixFileObjectType', fromsubclass_=False, pretty_print=True):
        super(UnixFileObjectType, self).exportChildren(outfile, level, 'UnixFileObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Group_Owner is not None:
            self.Group_Owner.export(outfile, level, 'UnixFileObj:', name_='Group_Owner', pretty_print=pretty_print)
        if self.INode is not None:
            self.INode.export(outfile, level, 'UnixFileObj:', name_='INode', pretty_print=pretty_print)
        if self.Type is not None:
            self.Type.export(outfile, level, 'UnixFileObj:', name_='Type', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Group_Owner is not None or
            self.INode is not None or
            self.Type is not None or
            super(UnixFileObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='UnixFileObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(UnixFileObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(UnixFileObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Group_Owner is not None:
            showIndent(outfile, level)
            outfile.write('Group_Owner=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Group_Owner.exportLiteral(outfile, level, name_='Group_Owner')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.INode is not None:
            showIndent(outfile, level)
            outfile.write('INode=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.INode.exportLiteral(outfile, level, name_='INode')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Type is not None:
            showIndent(outfile, level)
            outfile.write('Type=model_.UnixFileType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(UnixFileObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Group_Owner':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Group_Owner(obj_)
        elif nodeName_ == 'INode':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_INode(obj_)
        elif nodeName_ == 'Type':
            obj_ = UnixFileType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
        super(UnixFileObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class UnixFileObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Unix_File'
        rootClass = UnixFileObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Unix_File'
        rootClass = UnixFileObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Unix_File",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Unix_File'
        rootClass = UnixFileObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "UnixFileObjectType",
    "UnixFilePermissionsType",
    "UnixFileType"
    ]