#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:03:46 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import uri_object_1_2
import address_object_1_2

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class RegistrarInfoType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, Address=None, Email_Address=None, Phone_Number=None, Whois_Server=None, Referral_URL=None):
        self.Name = Name
        self.Address = Address
        self.Email_Address = Email_Address
        self.Phone_Number = Phone_Number
        self.Whois_Server = Whois_Server
        self.Referral_URL = Referral_URL
    def factory(*args_, **kwargs_):
        if RegistrarInfoType.subclass:
            return RegistrarInfoType.subclass(*args_, **kwargs_)
        else:
            return RegistrarInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def get_Email_Address(self): return self.Email_Address
    def set_Email_Address(self, Email_Address): self.Email_Address = Email_Address
    def get_Phone_Number(self): return self.Phone_Number
    def set_Phone_Number(self, Phone_Number): self.Phone_Number = Phone_Number
    def get_Whois_Server(self): return self.Whois_Server
    def set_Whois_Server(self, Whois_Server): self.Whois_Server = Whois_Server
    def get_Referral_URL(self): return self.Referral_URL
    def set_Referral_URL(self, Referral_URL): self.Referral_URL = Referral_URL
    def export(self, outfile, level, namespace_='WhoisObj:', name_='RegistrarInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RegistrarInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WhoisObj:', name_='RegistrarInfoType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WhoisObj:', name_='RegistrarInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            self.Name.export(outfile, level, 'WhoisObj:', name_='Name', pretty_print=pretty_print)
        if self.Address is not None:
            self.Address.export(outfile, level, 'WhoisObj:', name_='Address', pretty_print=pretty_print)
        if self.Email_Address is not None:
            self.Email_Address.export(outfile, level, 'WhoisObj:', name_='Email_Address', pretty_print=pretty_print)
        if self.Phone_Number is not None:
            self.Phone_Number.export(outfile, level, 'WhoisObj:', name_='Phone_Number', pretty_print=pretty_print)
        if self.Whois_Server is not None:
            self.Whois_Server.export(outfile, level, 'WhoisObj:', name_='Whois_Server', pretty_print=pretty_print)
        if self.Referral_URL is not None:
            self.Referral_URL.export(outfile, level, 'WhoisObj:', name_='Referral_URL', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Address is not None or
            self.Email_Address is not None or
            self.Phone_Number is not None or
            self.Whois_Server is not None or
            self.Referral_URL is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RegistrarInfoType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Address is not None:
            showIndent(outfile, level)
            outfile.write('Address=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Address.exportLiteral(outfile, level, name_='Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Email_Address is not None:
            showIndent(outfile, level)
            outfile.write('Email_Address=model_.address_object_1_2.AddressObjectType(\n')
            self.Email_Address.exportLiteral(outfile, level, name_='Email_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Phone_Number is not None:
            showIndent(outfile, level)
            outfile.write('Phone_Number=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Phone_Number.exportLiteral(outfile, level, name_='Phone_Number')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Whois_Server is not None:
            showIndent(outfile, level)
            outfile.write('Whois_Server=model_.uri_object_1_2.URIObjectType(\n')
            self.Whois_Server.exportLiteral(outfile, level, name_='Whois_Server')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Referral_URL is not None:
            showIndent(outfile, level)
            outfile.write('Referral_URL=model_.uri_object_1_2.URIObjectType(\n')
            self.Referral_URL.exportLiteral(outfile, level, name_='Referral_URL')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Address':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Address(obj_)
        elif nodeName_ == 'Email_Address':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_Email_Address(obj_)
        elif nodeName_ == 'Phone_Number':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Phone_Number(obj_)
        elif nodeName_ == 'Whois_Server':
            obj_ = uri_object_1_2.URIObjectType.factory()
            obj_.build(child_)
            self.set_Whois_Server(obj_)
        elif nodeName_ == 'Referral_URL':
            obj_ = uri_object_1_2.URIObjectType.factory()
            obj_.build(child_)
            self.set_Referral_URL(obj_)
# end class RegistrarInfoType

class RegistrarContactType(GeneratedsSuper):
    """The contact_type attribute specifies what type of contact this is.
    Only values from WhoisObj:RegistrarContactTypeEnum can be used."""
    subclass = None
    superclass = None
    def __init__(self, contact_type=None, Name=None, Email_Address=None, Phone_Number=None):
        self.contact_type = _cast(None, contact_type)
        self.Name = Name
        self.Email_Address = Email_Address
        self.Phone_Number = Phone_Number
    def factory(*args_, **kwargs_):
        if RegistrarContactType.subclass:
            return RegistrarContactType.subclass(*args_, **kwargs_)
        else:
            return RegistrarContactType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Email_Address(self): return self.Email_Address
    def set_Email_Address(self, Email_Address): self.Email_Address = Email_Address
    def get_Phone_Number(self): return self.Phone_Number
    def set_Phone_Number(self, Phone_Number): self.Phone_Number = Phone_Number
    def get_contact_type(self): return self.contact_type
    def set_contact_type(self, contact_type): self.contact_type = contact_type
    def export(self, outfile, level, namespace_='WhoisObj:', name_='RegistrarContactType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RegistrarContactType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WhoisObj:', name_='RegistrarContactType'):
        if self.contact_type is not None and 'contact_type' not in already_processed:
            already_processed.append('contact_type')
            outfile.write(' contact_type=%s' % (quote_attrib(self.contact_type), ))
    def exportChildren(self, outfile, level, namespace_='WhoisObj:', name_='RegistrarContactType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            self.Name.export(outfile, level, 'WhoisObj:', name_='Name', pretty_print=pretty_print)
        if self.Email_Address is not None:
            self.Email_Address.export(outfile, level, 'WhoisObj:', name_='Email_Address', pretty_print=pretty_print)
        if self.Phone_Number is not None:
            self.Phone_Number.export(outfile, level, 'WhoisObj:', name_='Phone_Number', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Email_Address is not None or
            self.Phone_Number is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RegistrarContactType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.contact_type is not None and 'contact_type' not in already_processed:
            already_processed.append('contact_type')
            showIndent(outfile, level)
            outfile.write('contact_type = %s,\n' % (self.contact_type,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Email_Address is not None:
            showIndent(outfile, level)
            outfile.write('Email_Address=model_.address_object_1_2.AddressObjectType(\n')
            self.Email_Address.exportLiteral(outfile, level, name_='Email_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Phone_Number is not None:
            showIndent(outfile, level)
            outfile.write('Phone_Number=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Phone_Number.exportLiteral(outfile, level, name_='Phone_Number')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('contact_type', node)
        if value is not None and 'contact_type' not in already_processed:
            already_processed.append('contact_type')
            self.contact_type = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Email_Address':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_Email_Address(obj_)
        elif nodeName_ == 'Phone_Number':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Phone_Number(obj_)
# end class RegistrarContactType

class WhoisStatusType(cybox_common_types_1_0.BaseObjectAttributeType):
    """The WhoisStatusType specifies a status for a domain as listed in its
    Whois entry. Only statuses defined by WhoisStatusTypeEnum can be
    used."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(WhoisStatusType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if WhoisStatusType.subclass:
            return WhoisStatusType.subclass(*args_, **kwargs_)
        else:
            return WhoisStatusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WhoisObj:', name_='WhoisStatusType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WhoisStatusType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WhoisObj:', name_='WhoisStatusType'):
        super(WhoisStatusType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WhoisStatusType')
    def exportChildren(self, outfile, level, namespace_='WhoisObj:', name_='WhoisStatusType', fromsubclass_=False, pretty_print=True):
        super(WhoisStatusType, self).exportChildren(outfile, level, 'WhoisObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(WhoisStatusType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WhoisStatusType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WhoisStatusType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WhoisStatusType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WhoisStatusType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class WhoisStatusType

class WhoisObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The WhoisObjectType type is intended to characterize Whois
    information for a domain."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, Domain_Name=None, Server_Name=None, IP_Address=None, Nameserver=None, Status=None, Updated_Date=None, Creation_Date=None, Expiration_Date=None, Registrar_Info=None, Registrar_Contact=None):
        super(WhoisObjectType, self).__init__(object_reference, )
        self.Domain_Name = Domain_Name
        self.Server_Name = Server_Name
        self.IP_Address = IP_Address
        if Nameserver is None:
            self.Nameserver = []
        else:
            self.Nameserver = Nameserver
        if Status is None:
            self.Status = []
        else:
            self.Status = Status
        self.Updated_Date = Updated_Date
        self.Creation_Date = Creation_Date
        self.Expiration_Date = Expiration_Date
        self.Registrar_Info = Registrar_Info
        if Registrar_Contact is None:
            self.Registrar_Contact = []
        else:
            self.Registrar_Contact = Registrar_Contact
    def factory(*args_, **kwargs_):
        if WhoisObjectType.subclass:
            return WhoisObjectType.subclass(*args_, **kwargs_)
        else:
            return WhoisObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Domain_Name(self): return self.Domain_Name
    def set_Domain_Name(self, Domain_Name): self.Domain_Name = Domain_Name
    def get_Server_Name(self): return self.Server_Name
    def set_Server_Name(self, Server_Name): self.Server_Name = Server_Name
    def get_IP_Address(self): return self.IP_Address
    def set_IP_Address(self, IP_Address): self.IP_Address = IP_Address
    def get_Nameserver(self): return self.Nameserver
    def set_Nameserver(self, Nameserver): self.Nameserver = Nameserver
    def add_Nameserver(self, value): self.Nameserver.append(value)
    def insert_Nameserver(self, index, value): self.Nameserver[index] = value
    def get_Status(self): return self.Status
    def set_Status(self, Status): self.Status = Status
    def add_Status(self, value): self.Status.append(value)
    def insert_Status(self, index, value): self.Status[index] = value
    def validate_WhoisStatusType(self, value):
        # Validate type WhoisStatusType, a restriction on WhoisObj:WhoisStatusTypeEnum.
        pass
    def get_Updated_Date(self): return self.Updated_Date
    def set_Updated_Date(self, Updated_Date): self.Updated_Date = Updated_Date
    def validate_DateObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateObjectAttributeType, a restriction on None.
        pass
    def get_Creation_Date(self): return self.Creation_Date
    def set_Creation_Date(self, Creation_Date): self.Creation_Date = Creation_Date
    def get_Expiration_Date(self): return self.Expiration_Date
    def set_Expiration_Date(self, Expiration_Date): self.Expiration_Date = Expiration_Date
    def get_Registrar_Info(self): return self.Registrar_Info
    def set_Registrar_Info(self, Registrar_Info): self.Registrar_Info = Registrar_Info
    def get_Registrar_Contact(self): return self.Registrar_Contact
    def set_Registrar_Contact(self, Registrar_Contact): self.Registrar_Contact = Registrar_Contact
    def add_Registrar_Contact(self, value): self.Registrar_Contact.append(value)
    def insert_Registrar_Contact(self, index, value): self.Registrar_Contact[index] = value
    def export(self, outfile, level, namespace_='WhoisObj:', name_='WhoisObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WhoisObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WhoisObj:', name_='WhoisObjectType'):
        super(WhoisObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WhoisObjectType')
    def exportChildren(self, outfile, level, namespace_='WhoisObj:', name_='WhoisObjectType', fromsubclass_=False, pretty_print=True):
        super(WhoisObjectType, self).exportChildren(outfile, level, 'WhoisObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Domain_Name is not None:
            self.Domain_Name.export(outfile, level, 'WhoisObj:', name_='Domain_Name', pretty_print=pretty_print)
        if self.Server_Name is not None:
            self.Server_Name.export(outfile, level, 'WhoisObj:', name_='Server_Name', pretty_print=pretty_print)
        if self.IP_Address is not None:
            self.IP_Address.export(outfile, level, 'WhoisObj:', name_='IP_Address', pretty_print=pretty_print)
        for Nameserver_ in self.Nameserver:
            Nameserver_.export(outfile, level, 'WhoisObj:', name_='Nameserver', pretty_print=pretty_print)
        for Status_ in self.Status:
            Status_.export(outfile, level, 'WhoisObj:', name_='Status', pretty_print=pretty_print)
        if self.Updated_Date is not None:
            self.Updated_Date.export(outfile, level, 'WhoisObj:', name_='Updated_Date', pretty_print=pretty_print)
        if self.Creation_Date is not None:
            self.Creation_Date.export(outfile, level, 'WhoisObj:', name_='Creation_Date', pretty_print=pretty_print)
        if self.Expiration_Date is not None:
            self.Expiration_Date.export(outfile, level, 'WhoisObj:', name_='Expiration_Date', pretty_print=pretty_print)
        if self.Registrar_Info is not None:
            self.Registrar_Info.export(outfile, level, 'WhoisObj:', name_='Registrar_Info', pretty_print=pretty_print)
        for Registrar_Contact_ in self.Registrar_Contact:
            Registrar_Contact_.export(outfile, level, 'WhoisObj:', name_='Registrar_Contact', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Domain_Name is not None or
            self.Server_Name is not None or
            self.IP_Address is not None or
            self.Nameserver or
            self.Status or
            self.Updated_Date is not None or
            self.Creation_Date is not None or
            self.Expiration_Date is not None or
            self.Registrar_Info is not None or
            self.Registrar_Contact or
            super(WhoisObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WhoisObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WhoisObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WhoisObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Domain_Name is not None:
            showIndent(outfile, level)
            outfile.write('Domain_Name=model_.uri_object_1_2.URIObjectType(\n')
            self.Domain_Name.exportLiteral(outfile, level, name_='Domain_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Server_Name is not None:
            showIndent(outfile, level)
            outfile.write('Server_Name=model_.uri_object_1_2.URIObjectType(\n')
            self.Server_Name.exportLiteral(outfile, level, name_='Server_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('IP_Address=model_.address_object_1_2.AddressObjectType(\n')
            self.IP_Address.exportLiteral(outfile, level, name_='IP_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Nameserver=[\n')
        level += 1
        for Nameserver_ in self.Nameserver:
            showIndent(outfile, level)
            outfile.write('model_.uri_object_1_2.URIObjectType(\n')
            Nameserver_.exportLiteral(outfile, level, name_='uri_object_1_2.URIObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Status=[\n')
        level += 1
        for Status_ in self.Status:
            showIndent(outfile, level)
            outfile.write('model_.WhoisStatusType(\n')
            Status_.exportLiteral(outfile, level, name_='WhoisStatusType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Updated_Date is not None:
            showIndent(outfile, level)
            outfile.write('Updated_Date=model_.cybox_common_types_1_0.DateObjectAttributeType(\n')
            self.Updated_Date.exportLiteral(outfile, level, name_='Updated_Date')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Creation_Date is not None:
            showIndent(outfile, level)
            outfile.write('Creation_Date=model_.cybox_common_types_1_0.DateObjectAttributeType(\n')
            self.Creation_Date.exportLiteral(outfile, level, name_='Creation_Date')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Expiration_Date is not None:
            showIndent(outfile, level)
            outfile.write('Expiration_Date=model_.cybox_common_types_1_0.DateObjectAttributeType(\n')
            self.Expiration_Date.exportLiteral(outfile, level, name_='Expiration_Date')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Registrar_Info is not None:
            showIndent(outfile, level)
            outfile.write('Registrar_Info=model_.RegistrarInfoType(\n')
            self.Registrar_Info.exportLiteral(outfile, level, name_='Registrar_Info')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Registrar_Contact=[\n')
        level += 1
        for Registrar_Contact_ in self.Registrar_Contact:
            showIndent(outfile, level)
            outfile.write('model_.RegistrarContactType(\n')
            Registrar_Contact_.exportLiteral(outfile, level, name_='RegistrarContactType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WhoisObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Domain_Name':
            obj_ = uri_object_1_2.URIObjectType.factory()
            obj_.build(child_)
            self.set_Domain_Name(obj_)
        elif nodeName_ == 'Server_Name':
            obj_ = uri_object_1_2.URIObjectType.factory()
            obj_.build(child_)
            self.set_Server_Name(obj_)
        elif nodeName_ == 'IP_Address':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_IP_Address(obj_)
        elif nodeName_ == 'Nameserver':
            obj_ = uri_object_1_2.URIObjectType.factory()
            obj_.build(child_)
            self.Nameserver.append(obj_)
        elif nodeName_ == 'Status':
            obj_ = WhoisStatusType.factory()
            obj_.build(child_)
            self.Status.append(obj_)
        elif nodeName_ == 'Updated_Date':
            obj_ = cybox_common_types_1_0.DateObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Updated_Date(obj_)
        elif nodeName_ == 'Creation_Date':
            obj_ = cybox_common_types_1_0.DateObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Creation_Date(obj_)
        elif nodeName_ == 'Expiration_Date':
            obj_ = cybox_common_types_1_0.DateObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Expiration_Date(obj_)
        elif nodeName_ == 'Registrar_Info':
            obj_ = RegistrarInfoType.factory()
            obj_.build(child_)
            self.set_Registrar_Info(obj_)
        elif nodeName_ == 'Registrar_Contact':
            obj_ = RegistrarContactType.factory()
            obj_.build(child_)
            self.Registrar_Contact.append(obj_)
        super(WhoisObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WhoisObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Whois_Entry'
        rootClass = WhoisObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Whois_Entry'
        rootClass = WhoisObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Whois_Entry",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Whois_Entry'
        rootClass = WhoisObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WhoisObjectType",
    "RegistrarInfoType",
    "RegistrarContactType",
    "WhoisStatusType"
    ]