#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:03:50 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class DeviceObjectStructType(GeneratedsSuper):
    """The DeviceObjectStructType type specifies the attributes of a device
    object. In this context, a device object represents a logical,
    virtual, or physical device for which a driver handles I/O
    requests. See also: http://msdn.microsoft.com/en-
    us/library/windows/hardware/ff543147(v=vs.85).aspx"""
    subclass = None
    superclass = None
    def __init__(self, Attached_Device_Name=None, Attached_Device_Object=None, Attached_To_Device_Name=None, Attached_To_Device_Object=None, Attached_To_Driver_Object=None, Attached_To_Driver_Name=None, Device_Name=None, Device_Object=None):
        self.Attached_Device_Name = Attached_Device_Name
        self.Attached_Device_Object = Attached_Device_Object
        self.Attached_To_Device_Name = Attached_To_Device_Name
        self.Attached_To_Device_Object = Attached_To_Device_Object
        self.Attached_To_Driver_Object = Attached_To_Driver_Object
        self.Attached_To_Driver_Name = Attached_To_Driver_Name
        self.Device_Name = Device_Name
        self.Device_Object = Device_Object
    def factory(*args_, **kwargs_):
        if DeviceObjectStructType.subclass:
            return DeviceObjectStructType.subclass(*args_, **kwargs_)
        else:
            return DeviceObjectStructType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Attached_Device_Name(self): return self.Attached_Device_Name
    def set_Attached_Device_Name(self, Attached_Device_Name): self.Attached_Device_Name = Attached_Device_Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Attached_Device_Object(self): return self.Attached_Device_Object
    def set_Attached_Device_Object(self, Attached_Device_Object): self.Attached_Device_Object = Attached_Device_Object
    def validate_UnsignedLongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedLongObjectAttributeType, a restriction on None.
        pass
    def get_Attached_To_Device_Name(self): return self.Attached_To_Device_Name
    def set_Attached_To_Device_Name(self, Attached_To_Device_Name): self.Attached_To_Device_Name = Attached_To_Device_Name
    def get_Attached_To_Device_Object(self): return self.Attached_To_Device_Object
    def set_Attached_To_Device_Object(self, Attached_To_Device_Object): self.Attached_To_Device_Object = Attached_To_Device_Object
    def get_Attached_To_Driver_Object(self): return self.Attached_To_Driver_Object
    def set_Attached_To_Driver_Object(self, Attached_To_Driver_Object): self.Attached_To_Driver_Object = Attached_To_Driver_Object
    def get_Attached_To_Driver_Name(self): return self.Attached_To_Driver_Name
    def set_Attached_To_Driver_Name(self, Attached_To_Driver_Name): self.Attached_To_Driver_Name = Attached_To_Driver_Name
    def get_Device_Name(self): return self.Device_Name
    def set_Device_Name(self, Device_Name): self.Device_Name = Device_Name
    def get_Device_Object(self): return self.Device_Object
    def set_Device_Object(self, Device_Object): self.Device_Object = Device_Object
    def export(self, outfile, level, namespace_='WinDriverObj:', name_='DeviceObjectStructType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DeviceObjectStructType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinDriverObj:', name_='DeviceObjectStructType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinDriverObj:', name_='DeviceObjectStructType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Attached_Device_Name is not None:
            self.Attached_Device_Name.export(outfile, level, 'WinDriverObj:', name_='Attached_Device_Name', pretty_print=pretty_print)
        if self.Attached_Device_Object is not None:
            self.Attached_Device_Object.export(outfile, level, 'WinDriverObj:', name_='Attached_Device_Object', pretty_print=pretty_print)
        if self.Attached_To_Device_Name is not None:
            self.Attached_To_Device_Name.export(outfile, level, 'WinDriverObj:', name_='Attached_To_Device_Name', pretty_print=pretty_print)
        if self.Attached_To_Device_Object is not None:
            self.Attached_To_Device_Object.export(outfile, level, 'WinDriverObj:', name_='Attached_To_Device_Object', pretty_print=pretty_print)
        if self.Attached_To_Driver_Object is not None:
            self.Attached_To_Driver_Object.export(outfile, level, 'WinDriverObj:', name_='Attached_To_Driver_Object', pretty_print=pretty_print)
        if self.Attached_To_Driver_Name is not None:
            self.Attached_To_Driver_Name.export(outfile, level, 'WinDriverObj:', name_='Attached_To_Driver_Name', pretty_print=pretty_print)
        if self.Device_Name is not None:
            self.Device_Name.export(outfile, level, 'WinDriverObj:', name_='Device_Name', pretty_print=pretty_print)
        if self.Device_Object is not None:
            self.Device_Object.export(outfile, level, 'WinDriverObj:', name_='Device_Object', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Attached_Device_Name is not None or
            self.Attached_Device_Object is not None or
            self.Attached_To_Device_Name is not None or
            self.Attached_To_Device_Object is not None or
            self.Attached_To_Driver_Object is not None or
            self.Attached_To_Driver_Name is not None or
            self.Device_Name is not None or
            self.Device_Object is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DeviceObjectStructType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Attached_Device_Name is not None:
            showIndent(outfile, level)
            outfile.write('Attached_Device_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Attached_Device_Name.exportLiteral(outfile, level, name_='Attached_Device_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Attached_Device_Object is not None:
            showIndent(outfile, level)
            outfile.write('Attached_Device_Object=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.Attached_Device_Object.exportLiteral(outfile, level, name_='Attached_Device_Object')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Attached_To_Device_Name is not None:
            showIndent(outfile, level)
            outfile.write('Attached_To_Device_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Attached_To_Device_Name.exportLiteral(outfile, level, name_='Attached_To_Device_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Attached_To_Device_Object is not None:
            showIndent(outfile, level)
            outfile.write('Attached_To_Device_Object=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.Attached_To_Device_Object.exportLiteral(outfile, level, name_='Attached_To_Device_Object')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Attached_To_Driver_Object is not None:
            showIndent(outfile, level)
            outfile.write('Attached_To_Driver_Object=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.Attached_To_Driver_Object.exportLiteral(outfile, level, name_='Attached_To_Driver_Object')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Attached_To_Driver_Name is not None:
            showIndent(outfile, level)
            outfile.write('Attached_To_Driver_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Attached_To_Driver_Name.exportLiteral(outfile, level, name_='Attached_To_Driver_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Device_Name is not None:
            showIndent(outfile, level)
            outfile.write('Device_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Device_Name.exportLiteral(outfile, level, name_='Device_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Device_Object is not None:
            showIndent(outfile, level)
            outfile.write('Device_Object=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.Device_Object.exportLiteral(outfile, level, name_='Device_Object')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Attached_Device_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Attached_Device_Name(obj_)
        elif nodeName_ == 'Attached_Device_Object':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Attached_Device_Object(obj_)
        elif nodeName_ == 'Attached_To_Device_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Attached_To_Device_Name(obj_)
        elif nodeName_ == 'Attached_To_Device_Object':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Attached_To_Device_Object(obj_)
        elif nodeName_ == 'Attached_To_Driver_Object':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Attached_To_Driver_Object(obj_)
        elif nodeName_ == 'Attached_To_Driver_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Attached_To_Driver_Name(obj_)
        elif nodeName_ == 'Device_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Device_Name(obj_)
        elif nodeName_ == 'Device_Object':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Device_Object(obj_)
# end class DeviceObjectStructType

class DeviceObjectListType(GeneratedsSuper):
    """The DeviceObjectListType specifies a list of device objects."""
    subclass = None
    superclass = None
    def __init__(self, Device_Object_Struct=None):
        if Device_Object_Struct is None:
            self.Device_Object_Struct = []
        else:
            self.Device_Object_Struct = Device_Object_Struct
    def factory(*args_, **kwargs_):
        if DeviceObjectListType.subclass:
            return DeviceObjectListType.subclass(*args_, **kwargs_)
        else:
            return DeviceObjectListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Device_Object_Struct(self): return self.Device_Object_Struct
    def set_Device_Object_Struct(self, Device_Object_Struct): self.Device_Object_Struct = Device_Object_Struct
    def add_Device_Object_Struct(self, value): self.Device_Object_Struct.append(value)
    def insert_Device_Object_Struct(self, index, value): self.Device_Object_Struct[index] = value
    def export(self, outfile, level, namespace_='WinDriverObj:', name_='DeviceObjectListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DeviceObjectListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinDriverObj:', name_='DeviceObjectListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinDriverObj:', name_='DeviceObjectListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Device_Object_Struct_ in self.Device_Object_Struct:
            Device_Object_Struct_.export(outfile, level, 'WinDriverObj:', name_='Device_Object_Struct', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Device_Object_Struct
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DeviceObjectListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Device_Object_Struct=[\n')
        level += 1
        for Device_Object_Struct_ in self.Device_Object_Struct:
            showIndent(outfile, level)
            outfile.write('model_.DeviceObjectStructType(\n')
            Device_Object_Struct_.exportLiteral(outfile, level, name_='DeviceObjectStructType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Device_Object_Struct':
            obj_ = DeviceObjectStructType.factory()
            obj_.build(child_)
            self.Device_Object_Struct.append(obj_)
# end class DeviceObjectListType

class WindowsDriverObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The WindowsDriverObject type is intended to characterize Windows
    device drivers."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, Device_Object_List=None, Driver_Init=None, Driver_Name=None, Driver_Object_Address=None, Driver_Start_IO=None, Driver_Unload=None, Image_Base=None, Image_Size=None, IRP_MJ_CLEANUP=None, IRP_MJ_CLOSE=None, IRP_MJ_CREATE=None, IRP_MJ_CREATE_MAILSLOT=None, IRP_MJ_CREATE_NAMED_PIPE=None, IRP_MJ_DEVICE_CHANGE=None, IRP_MJ_DEVICE_CONTROL=None, IRP_MJ_DIRECTORY_CONTROL=None, IRP_MJ_FILE_SYSTEM_CONTROL=None, IRP_MJ_FLUSH_BUFFERS=None, IRP_MJ_INTERNAL_DEVICE_CONTROL=None, IRP_MJ_LOCK_CONTROL=None, IRP_MJ_PNP=None, IRP_MJ_POWER=None, IRP_MJ_READ=None, IRP_MJ_QUERY_EA=None, IRP_MJ_QUERY_INFORMATION=None, IRP_MJ_QUERY_SECURITY=None, IRP_MJ_QUERY_QUOTA=None, IRP_MJ_QUERY_VOLUME_INFORMATION=None, IRP_MJ_SET_EA=None, IRP_MJ_SET_INFORMATION=None, IRP_MJ_SET_SECURITY=None, IRP_MJ_SET_QUOTA=None, IRP_MJ_SET_VOLUME_INFORMATION=None, IRP_MJ_SHUTDOWN=None, IRP_MJ_SYSTEM_CONTROL=None, IRP_MJ_WRITE=None):
        super(WindowsDriverObjectType, self).__init__(object_reference, )
        self.Device_Object_List = Device_Object_List
        self.Driver_Init = Driver_Init
        self.Driver_Name = Driver_Name
        self.Driver_Object_Address = Driver_Object_Address
        self.Driver_Start_IO = Driver_Start_IO
        self.Driver_Unload = Driver_Unload
        self.Image_Base = Image_Base
        self.Image_Size = Image_Size
        self.IRP_MJ_CLEANUP = IRP_MJ_CLEANUP
        self.IRP_MJ_CLOSE = IRP_MJ_CLOSE
        self.IRP_MJ_CREATE = IRP_MJ_CREATE
        self.IRP_MJ_CREATE_MAILSLOT = IRP_MJ_CREATE_MAILSLOT
        self.IRP_MJ_CREATE_NAMED_PIPE = IRP_MJ_CREATE_NAMED_PIPE
        self.IRP_MJ_DEVICE_CHANGE = IRP_MJ_DEVICE_CHANGE
        self.IRP_MJ_DEVICE_CONTROL = IRP_MJ_DEVICE_CONTROL
        self.IRP_MJ_DIRECTORY_CONTROL = IRP_MJ_DIRECTORY_CONTROL
        self.IRP_MJ_FILE_SYSTEM_CONTROL = IRP_MJ_FILE_SYSTEM_CONTROL
        self.IRP_MJ_FLUSH_BUFFERS = IRP_MJ_FLUSH_BUFFERS
        self.IRP_MJ_INTERNAL_DEVICE_CONTROL = IRP_MJ_INTERNAL_DEVICE_CONTROL
        self.IRP_MJ_LOCK_CONTROL = IRP_MJ_LOCK_CONTROL
        self.IRP_MJ_PNP = IRP_MJ_PNP
        self.IRP_MJ_POWER = IRP_MJ_POWER
        self.IRP_MJ_READ = IRP_MJ_READ
        self.IRP_MJ_QUERY_EA = IRP_MJ_QUERY_EA
        self.IRP_MJ_QUERY_INFORMATION = IRP_MJ_QUERY_INFORMATION
        self.IRP_MJ_QUERY_SECURITY = IRP_MJ_QUERY_SECURITY
        self.IRP_MJ_QUERY_QUOTA = IRP_MJ_QUERY_QUOTA
        self.IRP_MJ_QUERY_VOLUME_INFORMATION = IRP_MJ_QUERY_VOLUME_INFORMATION
        self.IRP_MJ_SET_EA = IRP_MJ_SET_EA
        self.IRP_MJ_SET_INFORMATION = IRP_MJ_SET_INFORMATION
        self.IRP_MJ_SET_SECURITY = IRP_MJ_SET_SECURITY
        self.IRP_MJ_SET_QUOTA = IRP_MJ_SET_QUOTA
        self.IRP_MJ_SET_VOLUME_INFORMATION = IRP_MJ_SET_VOLUME_INFORMATION
        self.IRP_MJ_SHUTDOWN = IRP_MJ_SHUTDOWN
        self.IRP_MJ_SYSTEM_CONTROL = IRP_MJ_SYSTEM_CONTROL
        self.IRP_MJ_WRITE = IRP_MJ_WRITE
    def factory(*args_, **kwargs_):
        if WindowsDriverObjectType.subclass:
            return WindowsDriverObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsDriverObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Device_Object_List(self): return self.Device_Object_List
    def set_Device_Object_List(self, Device_Object_List): self.Device_Object_List = Device_Object_List
    def get_Driver_Init(self): return self.Driver_Init
    def set_Driver_Init(self, Driver_Init): self.Driver_Init = Driver_Init
    def validate_UnsignedLongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedLongObjectAttributeType, a restriction on None.
        pass
    def get_Driver_Name(self): return self.Driver_Name
    def set_Driver_Name(self, Driver_Name): self.Driver_Name = Driver_Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Driver_Object_Address(self): return self.Driver_Object_Address
    def set_Driver_Object_Address(self, Driver_Object_Address): self.Driver_Object_Address = Driver_Object_Address
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Driver_Start_IO(self): return self.Driver_Start_IO
    def set_Driver_Start_IO(self, Driver_Start_IO): self.Driver_Start_IO = Driver_Start_IO
    def get_Driver_Unload(self): return self.Driver_Unload
    def set_Driver_Unload(self, Driver_Unload): self.Driver_Unload = Driver_Unload
    def get_Image_Base(self): return self.Image_Base
    def set_Image_Base(self, Image_Base): self.Image_Base = Image_Base
    def get_Image_Size(self): return self.Image_Size
    def set_Image_Size(self, Image_Size): self.Image_Size = Image_Size
    def get_IRP_MJ_CLEANUP(self): return self.IRP_MJ_CLEANUP
    def set_IRP_MJ_CLEANUP(self, IRP_MJ_CLEANUP): self.IRP_MJ_CLEANUP = IRP_MJ_CLEANUP
    def get_IRP_MJ_CLOSE(self): return self.IRP_MJ_CLOSE
    def set_IRP_MJ_CLOSE(self, IRP_MJ_CLOSE): self.IRP_MJ_CLOSE = IRP_MJ_CLOSE
    def get_IRP_MJ_CREATE(self): return self.IRP_MJ_CREATE
    def set_IRP_MJ_CREATE(self, IRP_MJ_CREATE): self.IRP_MJ_CREATE = IRP_MJ_CREATE
    def get_IRP_MJ_CREATE_MAILSLOT(self): return self.IRP_MJ_CREATE_MAILSLOT
    def set_IRP_MJ_CREATE_MAILSLOT(self, IRP_MJ_CREATE_MAILSLOT): self.IRP_MJ_CREATE_MAILSLOT = IRP_MJ_CREATE_MAILSLOT
    def get_IRP_MJ_CREATE_NAMED_PIPE(self): return self.IRP_MJ_CREATE_NAMED_PIPE
    def set_IRP_MJ_CREATE_NAMED_PIPE(self, IRP_MJ_CREATE_NAMED_PIPE): self.IRP_MJ_CREATE_NAMED_PIPE = IRP_MJ_CREATE_NAMED_PIPE
    def get_IRP_MJ_DEVICE_CHANGE(self): return self.IRP_MJ_DEVICE_CHANGE
    def set_IRP_MJ_DEVICE_CHANGE(self, IRP_MJ_DEVICE_CHANGE): self.IRP_MJ_DEVICE_CHANGE = IRP_MJ_DEVICE_CHANGE
    def get_IRP_MJ_DEVICE_CONTROL(self): return self.IRP_MJ_DEVICE_CONTROL
    def set_IRP_MJ_DEVICE_CONTROL(self, IRP_MJ_DEVICE_CONTROL): self.IRP_MJ_DEVICE_CONTROL = IRP_MJ_DEVICE_CONTROL
    def get_IRP_MJ_DIRECTORY_CONTROL(self): return self.IRP_MJ_DIRECTORY_CONTROL
    def set_IRP_MJ_DIRECTORY_CONTROL(self, IRP_MJ_DIRECTORY_CONTROL): self.IRP_MJ_DIRECTORY_CONTROL = IRP_MJ_DIRECTORY_CONTROL
    def get_IRP_MJ_FILE_SYSTEM_CONTROL(self): return self.IRP_MJ_FILE_SYSTEM_CONTROL
    def set_IRP_MJ_FILE_SYSTEM_CONTROL(self, IRP_MJ_FILE_SYSTEM_CONTROL): self.IRP_MJ_FILE_SYSTEM_CONTROL = IRP_MJ_FILE_SYSTEM_CONTROL
    def get_IRP_MJ_FLUSH_BUFFERS(self): return self.IRP_MJ_FLUSH_BUFFERS
    def set_IRP_MJ_FLUSH_BUFFERS(self, IRP_MJ_FLUSH_BUFFERS): self.IRP_MJ_FLUSH_BUFFERS = IRP_MJ_FLUSH_BUFFERS
    def get_IRP_MJ_INTERNAL_DEVICE_CONTROL(self): return self.IRP_MJ_INTERNAL_DEVICE_CONTROL
    def set_IRP_MJ_INTERNAL_DEVICE_CONTROL(self, IRP_MJ_INTERNAL_DEVICE_CONTROL): self.IRP_MJ_INTERNAL_DEVICE_CONTROL = IRP_MJ_INTERNAL_DEVICE_CONTROL
    def get_IRP_MJ_LOCK_CONTROL(self): return self.IRP_MJ_LOCK_CONTROL
    def set_IRP_MJ_LOCK_CONTROL(self, IRP_MJ_LOCK_CONTROL): self.IRP_MJ_LOCK_CONTROL = IRP_MJ_LOCK_CONTROL
    def get_IRP_MJ_PNP(self): return self.IRP_MJ_PNP
    def set_IRP_MJ_PNP(self, IRP_MJ_PNP): self.IRP_MJ_PNP = IRP_MJ_PNP
    def get_IRP_MJ_POWER(self): return self.IRP_MJ_POWER
    def set_IRP_MJ_POWER(self, IRP_MJ_POWER): self.IRP_MJ_POWER = IRP_MJ_POWER
    def get_IRP_MJ_READ(self): return self.IRP_MJ_READ
    def set_IRP_MJ_READ(self, IRP_MJ_READ): self.IRP_MJ_READ = IRP_MJ_READ
    def get_IRP_MJ_QUERY_EA(self): return self.IRP_MJ_QUERY_EA
    def set_IRP_MJ_QUERY_EA(self, IRP_MJ_QUERY_EA): self.IRP_MJ_QUERY_EA = IRP_MJ_QUERY_EA
    def get_IRP_MJ_QUERY_INFORMATION(self): return self.IRP_MJ_QUERY_INFORMATION
    def set_IRP_MJ_QUERY_INFORMATION(self, IRP_MJ_QUERY_INFORMATION): self.IRP_MJ_QUERY_INFORMATION = IRP_MJ_QUERY_INFORMATION
    def get_IRP_MJ_QUERY_SECURITY(self): return self.IRP_MJ_QUERY_SECURITY
    def set_IRP_MJ_QUERY_SECURITY(self, IRP_MJ_QUERY_SECURITY): self.IRP_MJ_QUERY_SECURITY = IRP_MJ_QUERY_SECURITY
    def get_IRP_MJ_QUERY_QUOTA(self): return self.IRP_MJ_QUERY_QUOTA
    def set_IRP_MJ_QUERY_QUOTA(self, IRP_MJ_QUERY_QUOTA): self.IRP_MJ_QUERY_QUOTA = IRP_MJ_QUERY_QUOTA
    def get_IRP_MJ_QUERY_VOLUME_INFORMATION(self): return self.IRP_MJ_QUERY_VOLUME_INFORMATION
    def set_IRP_MJ_QUERY_VOLUME_INFORMATION(self, IRP_MJ_QUERY_VOLUME_INFORMATION): self.IRP_MJ_QUERY_VOLUME_INFORMATION = IRP_MJ_QUERY_VOLUME_INFORMATION
    def get_IRP_MJ_SET_EA(self): return self.IRP_MJ_SET_EA
    def set_IRP_MJ_SET_EA(self, IRP_MJ_SET_EA): self.IRP_MJ_SET_EA = IRP_MJ_SET_EA
    def get_IRP_MJ_SET_INFORMATION(self): return self.IRP_MJ_SET_INFORMATION
    def set_IRP_MJ_SET_INFORMATION(self, IRP_MJ_SET_INFORMATION): self.IRP_MJ_SET_INFORMATION = IRP_MJ_SET_INFORMATION
    def get_IRP_MJ_SET_SECURITY(self): return self.IRP_MJ_SET_SECURITY
    def set_IRP_MJ_SET_SECURITY(self, IRP_MJ_SET_SECURITY): self.IRP_MJ_SET_SECURITY = IRP_MJ_SET_SECURITY
    def get_IRP_MJ_SET_QUOTA(self): return self.IRP_MJ_SET_QUOTA
    def set_IRP_MJ_SET_QUOTA(self, IRP_MJ_SET_QUOTA): self.IRP_MJ_SET_QUOTA = IRP_MJ_SET_QUOTA
    def get_IRP_MJ_SET_VOLUME_INFORMATION(self): return self.IRP_MJ_SET_VOLUME_INFORMATION
    def set_IRP_MJ_SET_VOLUME_INFORMATION(self, IRP_MJ_SET_VOLUME_INFORMATION): self.IRP_MJ_SET_VOLUME_INFORMATION = IRP_MJ_SET_VOLUME_INFORMATION
    def get_IRP_MJ_SHUTDOWN(self): return self.IRP_MJ_SHUTDOWN
    def set_IRP_MJ_SHUTDOWN(self, IRP_MJ_SHUTDOWN): self.IRP_MJ_SHUTDOWN = IRP_MJ_SHUTDOWN
    def get_IRP_MJ_SYSTEM_CONTROL(self): return self.IRP_MJ_SYSTEM_CONTROL
    def set_IRP_MJ_SYSTEM_CONTROL(self, IRP_MJ_SYSTEM_CONTROL): self.IRP_MJ_SYSTEM_CONTROL = IRP_MJ_SYSTEM_CONTROL
    def get_IRP_MJ_WRITE(self): return self.IRP_MJ_WRITE
    def set_IRP_MJ_WRITE(self, IRP_MJ_WRITE): self.IRP_MJ_WRITE = IRP_MJ_WRITE
    def export(self, outfile, level, namespace_='WinDriverObj:', name_='WindowsDriverObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsDriverObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinDriverObj:', name_='WindowsDriverObjectType'):
        super(WindowsDriverObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsDriverObjectType')
    def exportChildren(self, outfile, level, namespace_='WinDriverObj:', name_='WindowsDriverObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsDriverObjectType, self).exportChildren(outfile, level, 'WinDriverObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Device_Object_List is not None:
            self.Device_Object_List.export(outfile, level, 'WinDriverObj:', name_='Device_Object_List', pretty_print=pretty_print)
        if self.Driver_Init is not None:
            self.Driver_Init.export(outfile, level, 'WinDriverObj:', name_='Driver_Init', pretty_print=pretty_print)
        if self.Driver_Name is not None:
            self.Driver_Name.export(outfile, level, 'WinDriverObj:', name_='Driver_Name', pretty_print=pretty_print)
        if self.Driver_Object_Address is not None:
            self.Driver_Object_Address.export(outfile, level, 'WinDriverObj:', name_='Driver_Object_Address', pretty_print=pretty_print)
        if self.Driver_Start_IO is not None:
            self.Driver_Start_IO.export(outfile, level, 'WinDriverObj:', name_='Driver_Start_IO', pretty_print=pretty_print)
        if self.Driver_Unload is not None:
            self.Driver_Unload.export(outfile, level, 'WinDriverObj:', name_='Driver_Unload', pretty_print=pretty_print)
        if self.Image_Base is not None:
            self.Image_Base.export(outfile, level, 'WinDriverObj:', name_='Image_Base', pretty_print=pretty_print)
        if self.Image_Size is not None:
            self.Image_Size.export(outfile, level, 'WinDriverObj:', name_='Image_Size', pretty_print=pretty_print)
        if self.IRP_MJ_CLEANUP is not None:
            self.IRP_MJ_CLEANUP.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_CLEANUP', pretty_print=pretty_print)
        if self.IRP_MJ_CLOSE is not None:
            self.IRP_MJ_CLOSE.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_CLOSE', pretty_print=pretty_print)
        if self.IRP_MJ_CREATE is not None:
            self.IRP_MJ_CREATE.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_CREATE', pretty_print=pretty_print)
        if self.IRP_MJ_CREATE_MAILSLOT is not None:
            self.IRP_MJ_CREATE_MAILSLOT.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_CREATE_MAILSLOT', pretty_print=pretty_print)
        if self.IRP_MJ_CREATE_NAMED_PIPE is not None:
            self.IRP_MJ_CREATE_NAMED_PIPE.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_CREATE_NAMED_PIPE', pretty_print=pretty_print)
        if self.IRP_MJ_DEVICE_CHANGE is not None:
            self.IRP_MJ_DEVICE_CHANGE.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_DEVICE_CHANGE', pretty_print=pretty_print)
        if self.IRP_MJ_DEVICE_CONTROL is not None:
            self.IRP_MJ_DEVICE_CONTROL.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_DEVICE_CONTROL', pretty_print=pretty_print)
        if self.IRP_MJ_DIRECTORY_CONTROL is not None:
            self.IRP_MJ_DIRECTORY_CONTROL.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_DIRECTORY_CONTROL', pretty_print=pretty_print)
        if self.IRP_MJ_FILE_SYSTEM_CONTROL is not None:
            self.IRP_MJ_FILE_SYSTEM_CONTROL.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_FILE_SYSTEM_CONTROL', pretty_print=pretty_print)
        if self.IRP_MJ_FLUSH_BUFFERS is not None:
            self.IRP_MJ_FLUSH_BUFFERS.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_FLUSH_BUFFERS', pretty_print=pretty_print)
        if self.IRP_MJ_INTERNAL_DEVICE_CONTROL is not None:
            self.IRP_MJ_INTERNAL_DEVICE_CONTROL.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_INTERNAL_DEVICE_CONTROL', pretty_print=pretty_print)
        if self.IRP_MJ_LOCK_CONTROL is not None:
            self.IRP_MJ_LOCK_CONTROL.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_LOCK_CONTROL', pretty_print=pretty_print)
        if self.IRP_MJ_PNP is not None:
            self.IRP_MJ_PNP.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_PNP', pretty_print=pretty_print)
        if self.IRP_MJ_POWER is not None:
            self.IRP_MJ_POWER.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_POWER', pretty_print=pretty_print)
        if self.IRP_MJ_READ is not None:
            self.IRP_MJ_READ.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_READ', pretty_print=pretty_print)
        if self.IRP_MJ_QUERY_EA is not None:
            self.IRP_MJ_QUERY_EA.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_QUERY_EA', pretty_print=pretty_print)
        if self.IRP_MJ_QUERY_INFORMATION is not None:
            self.IRP_MJ_QUERY_INFORMATION.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_QUERY_INFORMATION', pretty_print=pretty_print)
        if self.IRP_MJ_QUERY_SECURITY is not None:
            self.IRP_MJ_QUERY_SECURITY.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_QUERY_SECURITY', pretty_print=pretty_print)
        if self.IRP_MJ_QUERY_QUOTA is not None:
            self.IRP_MJ_QUERY_QUOTA.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_QUERY_QUOTA', pretty_print=pretty_print)
        if self.IRP_MJ_QUERY_VOLUME_INFORMATION is not None:
            self.IRP_MJ_QUERY_VOLUME_INFORMATION.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_QUERY_VOLUME_INFORMATION', pretty_print=pretty_print)
        if self.IRP_MJ_SET_EA is not None:
            self.IRP_MJ_SET_EA.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_SET_EA', pretty_print=pretty_print)
        if self.IRP_MJ_SET_INFORMATION is not None:
            self.IRP_MJ_SET_INFORMATION.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_SET_INFORMATION', pretty_print=pretty_print)
        if self.IRP_MJ_SET_SECURITY is not None:
            self.IRP_MJ_SET_SECURITY.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_SET_SECURITY', pretty_print=pretty_print)
        if self.IRP_MJ_SET_QUOTA is not None:
            self.IRP_MJ_SET_QUOTA.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_SET_QUOTA', pretty_print=pretty_print)
        if self.IRP_MJ_SET_VOLUME_INFORMATION is not None:
            self.IRP_MJ_SET_VOLUME_INFORMATION.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_SET_VOLUME_INFORMATION', pretty_print=pretty_print)
        if self.IRP_MJ_SHUTDOWN is not None:
            self.IRP_MJ_SHUTDOWN.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_SHUTDOWN', pretty_print=pretty_print)
        if self.IRP_MJ_SYSTEM_CONTROL is not None:
            self.IRP_MJ_SYSTEM_CONTROL.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_SYSTEM_CONTROL', pretty_print=pretty_print)
        if self.IRP_MJ_WRITE is not None:
            self.IRP_MJ_WRITE.export(outfile, level, 'WinDriverObj:', name_='IRP_MJ_WRITE', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Device_Object_List is not None or
            self.Driver_Init is not None or
            self.Driver_Name is not None or
            self.Driver_Object_Address is not None or
            self.Driver_Start_IO is not None or
            self.Driver_Unload is not None or
            self.Image_Base is not None or
            self.Image_Size is not None or
            self.IRP_MJ_CLEANUP is not None or
            self.IRP_MJ_CLOSE is not None or
            self.IRP_MJ_CREATE is not None or
            self.IRP_MJ_CREATE_MAILSLOT is not None or
            self.IRP_MJ_CREATE_NAMED_PIPE is not None or
            self.IRP_MJ_DEVICE_CHANGE is not None or
            self.IRP_MJ_DEVICE_CONTROL is not None or
            self.IRP_MJ_DIRECTORY_CONTROL is not None or
            self.IRP_MJ_FILE_SYSTEM_CONTROL is not None or
            self.IRP_MJ_FLUSH_BUFFERS is not None or
            self.IRP_MJ_INTERNAL_DEVICE_CONTROL is not None or
            self.IRP_MJ_LOCK_CONTROL is not None or
            self.IRP_MJ_PNP is not None or
            self.IRP_MJ_POWER is not None or
            self.IRP_MJ_READ is not None or
            self.IRP_MJ_QUERY_EA is not None or
            self.IRP_MJ_QUERY_INFORMATION is not None or
            self.IRP_MJ_QUERY_SECURITY is not None or
            self.IRP_MJ_QUERY_QUOTA is not None or
            self.IRP_MJ_QUERY_VOLUME_INFORMATION is not None or
            self.IRP_MJ_SET_EA is not None or
            self.IRP_MJ_SET_INFORMATION is not None or
            self.IRP_MJ_SET_SECURITY is not None or
            self.IRP_MJ_SET_QUOTA is not None or
            self.IRP_MJ_SET_VOLUME_INFORMATION is not None or
            self.IRP_MJ_SHUTDOWN is not None or
            self.IRP_MJ_SYSTEM_CONTROL is not None or
            self.IRP_MJ_WRITE is not None or
            super(WindowsDriverObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsDriverObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsDriverObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsDriverObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Device_Object_List is not None:
            showIndent(outfile, level)
            outfile.write('Device_Object_List=model_.DeviceObjectListType(\n')
            self.Device_Object_List.exportLiteral(outfile, level, name_='Device_Object_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Driver_Init is not None:
            showIndent(outfile, level)
            outfile.write('Driver_Init=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.Driver_Init.exportLiteral(outfile, level, name_='Driver_Init')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Driver_Name is not None:
            showIndent(outfile, level)
            outfile.write('Driver_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Driver_Name.exportLiteral(outfile, level, name_='Driver_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Driver_Object_Address is not None:
            showIndent(outfile, level)
            outfile.write('Driver_Object_Address=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Driver_Object_Address.exportLiteral(outfile, level, name_='Driver_Object_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Driver_Start_IO is not None:
            showIndent(outfile, level)
            outfile.write('Driver_Start_IO=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Driver_Start_IO.exportLiteral(outfile, level, name_='Driver_Start_IO')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Driver_Unload is not None:
            showIndent(outfile, level)
            outfile.write('Driver_Unload=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Driver_Unload.exportLiteral(outfile, level, name_='Driver_Unload')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Image_Base is not None:
            showIndent(outfile, level)
            outfile.write('Image_Base=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Image_Base.exportLiteral(outfile, level, name_='Image_Base')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Image_Size is not None:
            showIndent(outfile, level)
            outfile.write('Image_Size=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Image_Size.exportLiteral(outfile, level, name_='Image_Size')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_CLEANUP is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_CLEANUP=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_CLEANUP.exportLiteral(outfile, level, name_='IRP_MJ_CLEANUP')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_CLOSE is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_CLOSE=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_CLOSE.exportLiteral(outfile, level, name_='IRP_MJ_CLOSE')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_CREATE is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_CREATE=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_CREATE.exportLiteral(outfile, level, name_='IRP_MJ_CREATE')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_CREATE_MAILSLOT is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_CREATE_MAILSLOT=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_CREATE_MAILSLOT.exportLiteral(outfile, level, name_='IRP_MJ_CREATE_MAILSLOT')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_CREATE_NAMED_PIPE is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_CREATE_NAMED_PIPE=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_CREATE_NAMED_PIPE.exportLiteral(outfile, level, name_='IRP_MJ_CREATE_NAMED_PIPE')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_DEVICE_CHANGE is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_DEVICE_CHANGE=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_DEVICE_CHANGE.exportLiteral(outfile, level, name_='IRP_MJ_DEVICE_CHANGE')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_DEVICE_CONTROL is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_DEVICE_CONTROL=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_DEVICE_CONTROL.exportLiteral(outfile, level, name_='IRP_MJ_DEVICE_CONTROL')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_DIRECTORY_CONTROL is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_DIRECTORY_CONTROL=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_DIRECTORY_CONTROL.exportLiteral(outfile, level, name_='IRP_MJ_DIRECTORY_CONTROL')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_FILE_SYSTEM_CONTROL is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_FILE_SYSTEM_CONTROL=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_FILE_SYSTEM_CONTROL.exportLiteral(outfile, level, name_='IRP_MJ_FILE_SYSTEM_CONTROL')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_FLUSH_BUFFERS is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_FLUSH_BUFFERS=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_FLUSH_BUFFERS.exportLiteral(outfile, level, name_='IRP_MJ_FLUSH_BUFFERS')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_INTERNAL_DEVICE_CONTROL is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_INTERNAL_DEVICE_CONTROL=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_INTERNAL_DEVICE_CONTROL.exportLiteral(outfile, level, name_='IRP_MJ_INTERNAL_DEVICE_CONTROL')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_LOCK_CONTROL is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_LOCK_CONTROL=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_LOCK_CONTROL.exportLiteral(outfile, level, name_='IRP_MJ_LOCK_CONTROL')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_PNP is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_PNP=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_PNP.exportLiteral(outfile, level, name_='IRP_MJ_PNP')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_POWER is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_POWER=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_POWER.exportLiteral(outfile, level, name_='IRP_MJ_POWER')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_READ is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_READ=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_READ.exportLiteral(outfile, level, name_='IRP_MJ_READ')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_QUERY_EA is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_QUERY_EA=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_QUERY_EA.exportLiteral(outfile, level, name_='IRP_MJ_QUERY_EA')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_QUERY_INFORMATION is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_QUERY_INFORMATION=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_QUERY_INFORMATION.exportLiteral(outfile, level, name_='IRP_MJ_QUERY_INFORMATION')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_QUERY_SECURITY is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_QUERY_SECURITY=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_QUERY_SECURITY.exportLiteral(outfile, level, name_='IRP_MJ_QUERY_SECURITY')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_QUERY_QUOTA is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_QUERY_QUOTA=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_QUERY_QUOTA.exportLiteral(outfile, level, name_='IRP_MJ_QUERY_QUOTA')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_QUERY_VOLUME_INFORMATION is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_QUERY_VOLUME_INFORMATION=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_QUERY_VOLUME_INFORMATION.exportLiteral(outfile, level, name_='IRP_MJ_QUERY_VOLUME_INFORMATION')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_SET_EA is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_SET_EA=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_SET_EA.exportLiteral(outfile, level, name_='IRP_MJ_SET_EA')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_SET_INFORMATION is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_SET_INFORMATION=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_SET_INFORMATION.exportLiteral(outfile, level, name_='IRP_MJ_SET_INFORMATION')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_SET_SECURITY is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_SET_SECURITY=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_SET_SECURITY.exportLiteral(outfile, level, name_='IRP_MJ_SET_SECURITY')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_SET_QUOTA is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_SET_QUOTA=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_SET_QUOTA.exportLiteral(outfile, level, name_='IRP_MJ_SET_QUOTA')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_SET_VOLUME_INFORMATION is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_SET_VOLUME_INFORMATION=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_SET_VOLUME_INFORMATION.exportLiteral(outfile, level, name_='IRP_MJ_SET_VOLUME_INFORMATION')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_SHUTDOWN is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_SHUTDOWN=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_SHUTDOWN.exportLiteral(outfile, level, name_='IRP_MJ_SHUTDOWN')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_SYSTEM_CONTROL is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_SYSTEM_CONTROL=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_SYSTEM_CONTROL.exportLiteral(outfile, level, name_='IRP_MJ_SYSTEM_CONTROL')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IRP_MJ_WRITE is not None:
            showIndent(outfile, level)
            outfile.write('IRP_MJ_WRITE=model_.cybox_common_types_1_0.UnsignedLongObjectAttributeType(\n')
            self.IRP_MJ_WRITE.exportLiteral(outfile, level, name_='IRP_MJ_WRITE')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsDriverObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Device_Object_List':
            obj_ = DeviceObjectListType.factory()
            obj_.build(child_)
            self.set_Device_Object_List(obj_)
        elif nodeName_ == 'Driver_Init':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Driver_Init(obj_)
        elif nodeName_ == 'Driver_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Driver_Name(obj_)
        elif nodeName_ == 'Driver_Object_Address':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Driver_Object_Address(obj_)
        elif nodeName_ == 'Driver_Start_IO':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Driver_Start_IO(obj_)
        elif nodeName_ == 'Driver_Unload':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Driver_Unload(obj_)
        elif nodeName_ == 'Image_Base':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Image_Base(obj_)
        elif nodeName_ == 'Image_Size':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Image_Size(obj_)
        elif nodeName_ == 'IRP_MJ_CLEANUP':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_CLEANUP(obj_)
        elif nodeName_ == 'IRP_MJ_CLOSE':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_CLOSE(obj_)
        elif nodeName_ == 'IRP_MJ_CREATE':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_CREATE(obj_)
        elif nodeName_ == 'IRP_MJ_CREATE_MAILSLOT':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_CREATE_MAILSLOT(obj_)
        elif nodeName_ == 'IRP_MJ_CREATE_NAMED_PIPE':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_CREATE_NAMED_PIPE(obj_)
        elif nodeName_ == 'IRP_MJ_DEVICE_CHANGE':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_DEVICE_CHANGE(obj_)
        elif nodeName_ == 'IRP_MJ_DEVICE_CONTROL':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_DEVICE_CONTROL(obj_)
        elif nodeName_ == 'IRP_MJ_DIRECTORY_CONTROL':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_DIRECTORY_CONTROL(obj_)
        elif nodeName_ == 'IRP_MJ_FILE_SYSTEM_CONTROL':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_FILE_SYSTEM_CONTROL(obj_)
        elif nodeName_ == 'IRP_MJ_FLUSH_BUFFERS':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_FLUSH_BUFFERS(obj_)
        elif nodeName_ == 'IRP_MJ_INTERNAL_DEVICE_CONTROL':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_INTERNAL_DEVICE_CONTROL(obj_)
        elif nodeName_ == 'IRP_MJ_LOCK_CONTROL':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_LOCK_CONTROL(obj_)
        elif nodeName_ == 'IRP_MJ_PNP':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_PNP(obj_)
        elif nodeName_ == 'IRP_MJ_POWER':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_POWER(obj_)
        elif nodeName_ == 'IRP_MJ_READ':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_READ(obj_)
        elif nodeName_ == 'IRP_MJ_QUERY_EA':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_QUERY_EA(obj_)
        elif nodeName_ == 'IRP_MJ_QUERY_INFORMATION':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_QUERY_INFORMATION(obj_)
        elif nodeName_ == 'IRP_MJ_QUERY_SECURITY':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_QUERY_SECURITY(obj_)
        elif nodeName_ == 'IRP_MJ_QUERY_QUOTA':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_QUERY_QUOTA(obj_)
        elif nodeName_ == 'IRP_MJ_QUERY_VOLUME_INFORMATION':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_QUERY_VOLUME_INFORMATION(obj_)
        elif nodeName_ == 'IRP_MJ_SET_EA':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_SET_EA(obj_)
        elif nodeName_ == 'IRP_MJ_SET_INFORMATION':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_SET_INFORMATION(obj_)
        elif nodeName_ == 'IRP_MJ_SET_SECURITY':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_SET_SECURITY(obj_)
        elif nodeName_ == 'IRP_MJ_SET_QUOTA':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_SET_QUOTA(obj_)
        elif nodeName_ == 'IRP_MJ_SET_VOLUME_INFORMATION':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_SET_VOLUME_INFORMATION(obj_)
        elif nodeName_ == 'IRP_MJ_SHUTDOWN':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_SHUTDOWN(obj_)
        elif nodeName_ == 'IRP_MJ_SYSTEM_CONTROL':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_SYSTEM_CONTROL(obj_)
        elif nodeName_ == 'IRP_MJ_WRITE':
            obj_ = cybox_common_types_1_0.UnsignedLongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IRP_MJ_WRITE(obj_)
        super(WindowsDriverObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsDriverObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Driver'
        rootClass = WindowsDriverObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Driver'
        rootClass = WindowsDriverObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Driver",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Driver'
        rootClass = WindowsDriverObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsDriverObjectType",
    "DeviceObjectStructType",
    "DeviceObjectListType"
    ]