#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:03:51 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class UnformattedMessageListType(GeneratedsSuper):
    """The UnformattedMessageListType type is a list of unformatted
    messages in the event log entry."""
    subclass = None
    superclass = None
    def __init__(self, Unformatted_Message=None):
        if Unformatted_Message is None:
            self.Unformatted_Message = []
        else:
            self.Unformatted_Message = Unformatted_Message
    def factory(*args_, **kwargs_):
        if UnformattedMessageListType.subclass:
            return UnformattedMessageListType.subclass(*args_, **kwargs_)
        else:
            return UnformattedMessageListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Unformatted_Message(self): return self.Unformatted_Message
    def set_Unformatted_Message(self, Unformatted_Message): self.Unformatted_Message = Unformatted_Message
    def add_Unformatted_Message(self, value): self.Unformatted_Message.append(value)
    def insert_Unformatted_Message(self, index, value): self.Unformatted_Message[index] = value
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinEventLogObj:', name_='UnformattedMessageListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UnformattedMessageListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinEventLogObj:', name_='UnformattedMessageListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinEventLogObj:', name_='UnformattedMessageListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Unformatted_Message_ in self.Unformatted_Message:
            Unformatted_Message_.export(outfile, level, 'WinEventLogObj:', name_='Unformatted_Message', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Unformatted_Message
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='UnformattedMessageListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Unformatted_Message=[\n')
        level += 1
        for Unformatted_Message_ in self.Unformatted_Message:
            showIndent(outfile, level)
            outfile.write('model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            Unformatted_Message_.exportLiteral(outfile, level, name_='cybox_common_types_1_0.StringObjectAttributeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Unformatted_Message':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.Unformatted_Message.append(obj_)
# end class UnformattedMessageListType

class WindowsEventLogObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The WindowsEventLogObjectType type is intended to characterize
    entries in the Windows event log."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, EID=None, Type=None, Log=None, Message=None, Category_Num=None, Category=None, Generation_Time=None, Source=None, Machine=None, User=None, Blob=None, Correlation_Activity_ID=None, Correlation_Related_Activity_ID=None, Execution_Process_ID=None, Execution_Thread_ID=None, Index=None, Reserved=None, Unformatted_Message_List=None, Write_Time=None):
        super(WindowsEventLogObjectType, self).__init__(object_reference, )
        self.EID = EID
        self.Type = Type
        self.Log = Log
        self.Message = Message
        self.Category_Num = Category_Num
        self.Category = Category
        self.Generation_Time = Generation_Time
        self.Source = Source
        self.Machine = Machine
        self.User = User
        self.Blob = Blob
        self.Correlation_Activity_ID = Correlation_Activity_ID
        self.Correlation_Related_Activity_ID = Correlation_Related_Activity_ID
        self.Execution_Process_ID = Execution_Process_ID
        self.Execution_Thread_ID = Execution_Thread_ID
        self.Index = Index
        self.Reserved = Reserved
        self.Unformatted_Message_List = Unformatted_Message_List
        self.Write_Time = Write_Time
    def factory(*args_, **kwargs_):
        if WindowsEventLogObjectType.subclass:
            return WindowsEventLogObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsEventLogObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_EID(self): return self.EID
    def set_EID(self, EID): self.EID = EID
    def validate_LongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.LongObjectAttributeType, a restriction on None.
        pass
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Log(self): return self.Log
    def set_Log(self, Log): self.Log = Log
    def get_Message(self): return self.Message
    def set_Message(self, Message): self.Message = Message
    def get_Category_Num(self): return self.Category_Num
    def set_Category_Num(self, Category_Num): self.Category_Num = Category_Num
    def get_Category(self): return self.Category
    def set_Category(self, Category): self.Category = Category
    def get_Generation_Time(self): return self.Generation_Time
    def set_Generation_Time(self, Generation_Time): self.Generation_Time = Generation_Time
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Source(self): return self.Source
    def set_Source(self, Source): self.Source = Source
    def get_Machine(self): return self.Machine
    def set_Machine(self, Machine): self.Machine = Machine
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def get_Blob(self): return self.Blob
    def set_Blob(self, Blob): self.Blob = Blob
    def validate_Base64BinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.Base64BinaryObjectAttributeType, a restriction on None.
        pass
    def get_Correlation_Activity_ID(self): return self.Correlation_Activity_ID
    def set_Correlation_Activity_ID(self, Correlation_Activity_ID): self.Correlation_Activity_ID = Correlation_Activity_ID
    def get_Correlation_Related_Activity_ID(self): return self.Correlation_Related_Activity_ID
    def set_Correlation_Related_Activity_ID(self, Correlation_Related_Activity_ID): self.Correlation_Related_Activity_ID = Correlation_Related_Activity_ID
    def get_Execution_Process_ID(self): return self.Execution_Process_ID
    def set_Execution_Process_ID(self, Execution_Process_ID): self.Execution_Process_ID = Execution_Process_ID
    def get_Execution_Thread_ID(self): return self.Execution_Thread_ID
    def set_Execution_Thread_ID(self, Execution_Thread_ID): self.Execution_Thread_ID = Execution_Thread_ID
    def get_Index(self): return self.Index
    def set_Index(self, Index): self.Index = Index
    def get_Reserved(self): return self.Reserved
    def set_Reserved(self, Reserved): self.Reserved = Reserved
    def get_Unformatted_Message_List(self): return self.Unformatted_Message_List
    def set_Unformatted_Message_List(self, Unformatted_Message_List): self.Unformatted_Message_List = Unformatted_Message_List
    def get_Write_Time(self): return self.Write_Time
    def set_Write_Time(self, Write_Time): self.Write_Time = Write_Time
    def export(self, outfile, level, namespace_='WinEventLogObj:', name_='WindowsEventLogObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsEventLogObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinEventLogObj:', name_='WindowsEventLogObjectType'):
        super(WindowsEventLogObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsEventLogObjectType')
    def exportChildren(self, outfile, level, namespace_='WinEventLogObj:', name_='WindowsEventLogObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsEventLogObjectType, self).exportChildren(outfile, level, 'WinEventLogObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.EID is not None:
            self.EID.export(outfile, level, 'WinEventLogObj:', name_='EID', pretty_print=pretty_print)
        if self.Type is not None:
            self.Type.export(outfile, level, 'WinEventLogObj:', name_='Type', pretty_print=pretty_print)
        if self.Log is not None:
            self.Log.export(outfile, level, 'WinEventLogObj:', name_='Log', pretty_print=pretty_print)
        if self.Message is not None:
            self.Message.export(outfile, level, 'WinEventLogObj:', name_='Message', pretty_print=pretty_print)
        if self.Category_Num is not None:
            self.Category_Num.export(outfile, level, 'WinEventLogObj:', name_='Category_Num', pretty_print=pretty_print)
        if self.Category is not None:
            self.Category.export(outfile, level, 'WinEventLogObj:', name_='Category', pretty_print=pretty_print)
        if self.Generation_Time is not None:
            self.Generation_Time.export(outfile, level, 'WinEventLogObj:', name_='Generation_Time', pretty_print=pretty_print)
        if self.Source is not None:
            self.Source.export(outfile, level, 'WinEventLogObj:', name_='Source', pretty_print=pretty_print)
        if self.Machine is not None:
            self.Machine.export(outfile, level, 'WinEventLogObj:', name_='Machine', pretty_print=pretty_print)
        if self.User is not None:
            self.User.export(outfile, level, 'WinEventLogObj:', name_='User', pretty_print=pretty_print)
        if self.Blob is not None:
            self.Blob.export(outfile, level, 'WinEventLogObj:', name_='Blob', pretty_print=pretty_print)
        if self.Correlation_Activity_ID is not None:
            self.Correlation_Activity_ID.export(outfile, level, 'WinEventLogObj:', name_='Correlation_Activity_ID', pretty_print=pretty_print)
        if self.Correlation_Related_Activity_ID is not None:
            self.Correlation_Related_Activity_ID.export(outfile, level, 'WinEventLogObj:', name_='Correlation_Related_Activity_ID', pretty_print=pretty_print)
        if self.Execution_Process_ID is not None:
            self.Execution_Process_ID.export(outfile, level, 'WinEventLogObj:', name_='Execution_Process_ID', pretty_print=pretty_print)
        if self.Execution_Thread_ID is not None:
            self.Execution_Thread_ID.export(outfile, level, 'WinEventLogObj:', name_='Execution_Thread_ID', pretty_print=pretty_print)
        if self.Index is not None:
            self.Index.export(outfile, level, 'WinEventLogObj:', name_='Index', pretty_print=pretty_print)
        if self.Reserved is not None:
            self.Reserved.export(outfile, level, 'WinEventLogObj:', name_='Reserved', pretty_print=pretty_print)
        if self.Unformatted_Message_List is not None:
            self.Unformatted_Message_List.export(outfile, level, 'WinEventLogObj:', name_='Unformatted_Message_List', pretty_print=pretty_print)
        if self.Write_Time is not None:
            self.Write_Time.export(outfile, level, 'WinEventLogObj:', name_='Write_Time', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.EID is not None or
            self.Type is not None or
            self.Log is not None or
            self.Message is not None or
            self.Category_Num is not None or
            self.Category is not None or
            self.Generation_Time is not None or
            self.Source is not None or
            self.Machine is not None or
            self.User is not None or
            self.Blob is not None or
            self.Correlation_Activity_ID is not None or
            self.Correlation_Related_Activity_ID is not None or
            self.Execution_Process_ID is not None or
            self.Execution_Thread_ID is not None or
            self.Index is not None or
            self.Reserved is not None or
            self.Unformatted_Message_List is not None or
            self.Write_Time is not None or
            super(WindowsEventLogObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsEventLogObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsEventLogObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsEventLogObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.EID is not None:
            showIndent(outfile, level)
            outfile.write('EID=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.EID.exportLiteral(outfile, level, name_='EID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Type is not None:
            showIndent(outfile, level)
            outfile.write('Type=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Log is not None:
            showIndent(outfile, level)
            outfile.write('Log=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Log.exportLiteral(outfile, level, name_='Log')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Message is not None:
            showIndent(outfile, level)
            outfile.write('Message=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Message.exportLiteral(outfile, level, name_='Message')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Category_Num is not None:
            showIndent(outfile, level)
            outfile.write('Category_Num=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.Category_Num.exportLiteral(outfile, level, name_='Category_Num')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Category is not None:
            showIndent(outfile, level)
            outfile.write('Category=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Category.exportLiteral(outfile, level, name_='Category')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Generation_Time is not None:
            showIndent(outfile, level)
            outfile.write('Generation_Time=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Generation_Time.exportLiteral(outfile, level, name_='Generation_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Source is not None:
            showIndent(outfile, level)
            outfile.write('Source=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Source.exportLiteral(outfile, level, name_='Source')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Machine is not None:
            showIndent(outfile, level)
            outfile.write('Machine=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Machine.exportLiteral(outfile, level, name_='Machine')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.User is not None:
            showIndent(outfile, level)
            outfile.write('User=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.User.exportLiteral(outfile, level, name_='User')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Blob is not None:
            showIndent(outfile, level)
            outfile.write('Blob=model_.cybox_common_types_1_0.Base64BinaryObjectAttributeType(\n')
            self.Blob.exportLiteral(outfile, level, name_='Blob')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Correlation_Activity_ID is not None:
            showIndent(outfile, level)
            outfile.write('Correlation_Activity_ID=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Correlation_Activity_ID.exportLiteral(outfile, level, name_='Correlation_Activity_ID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Correlation_Related_Activity_ID is not None:
            showIndent(outfile, level)
            outfile.write('Correlation_Related_Activity_ID=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Correlation_Related_Activity_ID.exportLiteral(outfile, level, name_='Correlation_Related_Activity_ID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Execution_Process_ID is not None:
            showIndent(outfile, level)
            outfile.write('Execution_Process_ID=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Execution_Process_ID.exportLiteral(outfile, level, name_='Execution_Process_ID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Execution_Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('Execution_Thread_ID=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Execution_Thread_ID.exportLiteral(outfile, level, name_='Execution_Thread_ID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Index is not None:
            showIndent(outfile, level)
            outfile.write('Index=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.Index.exportLiteral(outfile, level, name_='Index')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Reserved is not None:
            showIndent(outfile, level)
            outfile.write('Reserved=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.Reserved.exportLiteral(outfile, level, name_='Reserved')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Unformatted_Message_List is not None:
            showIndent(outfile, level)
            outfile.write('Unformatted_Message_List=model_.UnformattedMessageListType(\n')
            self.Unformatted_Message_List.exportLiteral(outfile, level, name_='Unformatted_Message_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Write_Time is not None:
            showIndent(outfile, level)
            outfile.write('Write_Time=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Write_Time.exportLiteral(outfile, level, name_='Write_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsEventLogObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'EID':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_EID(obj_)
        elif nodeName_ == 'Type':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
        elif nodeName_ == 'Log':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Log(obj_)
        elif nodeName_ == 'Message':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Message(obj_)
        elif nodeName_ == 'Category_Num':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Category_Num(obj_)
        elif nodeName_ == 'Category':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Category(obj_)
        elif nodeName_ == 'Generation_Time':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Generation_Time(obj_)
        elif nodeName_ == 'Source':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Source(obj_)
        elif nodeName_ == 'Machine':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Machine(obj_)
        elif nodeName_ == 'User':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_User(obj_)
        elif nodeName_ == 'Blob':
            obj_ = cybox_common_types_1_0.Base64BinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Blob(obj_)
        elif nodeName_ == 'Correlation_Activity_ID':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Correlation_Activity_ID(obj_)
        elif nodeName_ == 'Correlation_Related_Activity_ID':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Correlation_Related_Activity_ID(obj_)
        elif nodeName_ == 'Execution_Process_ID':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Execution_Process_ID(obj_)
        elif nodeName_ == 'Execution_Thread_ID':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Execution_Thread_ID(obj_)
        elif nodeName_ == 'Index':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Index(obj_)
        elif nodeName_ == 'Reserved':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Reserved(obj_)
        elif nodeName_ == 'Unformatted_Message_List':
            obj_ = UnformattedMessageListType.factory()
            obj_.build(child_)
            self.set_Unformatted_Message_List(obj_)
        elif nodeName_ == 'Write_Time':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Write_Time(obj_)
        super(WindowsEventLogObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsEventLogObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Event_Log'
        rootClass = WindowsEventLogObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Event_Log'
        rootClass = WindowsEventLogObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Event_Log",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Event_Log'
        rootClass = WindowsEventLogObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsEventLogObjectType",
    "UnformattedMessageListType"
    ]