#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:03:28 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import address_object_1_2
import port_object_1_3

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class SocketOptionsType(GeneratedsSuper):
    """The SocketOptionsType type specifies any particular options used by
    the socket. If an options is supported only by specific address
    families or socket types, that's indicated in parentheses."""
    subclass = None
    superclass = None
    def __init__(self, IP_MULTICAST_IF=None, IP_MULTICAST_IF2=None, IP_MULTICAST_LOOP=None, IP_TOS=None, SO_BROADCAST=None, SO_CONDITIONAL_ACCEPT=None, SO_KEEPALIVE=None, SO_DONTROUTE=None, SO_LINGER=None, SO_DONTLINGER=None, SO_OOBINLINE=None, SO_RCVBUF=None, SO_GROUP_PRIORITY=None, SO_REUSEADDR=None, SO_DEBUG=None, SO_RCVTIMEO=None, SO_SNDBUF=None, SO_SNDTIMEO=None, SO_UPDATE_ACCEPT_CONTEXT=None, SO_TIMEOUT=None, TCP_NODELAY=None):
        self.IP_MULTICAST_IF = IP_MULTICAST_IF
        self.IP_MULTICAST_IF2 = IP_MULTICAST_IF2
        self.IP_MULTICAST_LOOP = IP_MULTICAST_LOOP
        self.IP_TOS = IP_TOS
        self.SO_BROADCAST = SO_BROADCAST
        self.SO_CONDITIONAL_ACCEPT = SO_CONDITIONAL_ACCEPT
        self.SO_KEEPALIVE = SO_KEEPALIVE
        self.SO_DONTROUTE = SO_DONTROUTE
        self.SO_LINGER = SO_LINGER
        self.SO_DONTLINGER = SO_DONTLINGER
        self.SO_OOBINLINE = SO_OOBINLINE
        self.SO_RCVBUF = SO_RCVBUF
        self.SO_GROUP_PRIORITY = SO_GROUP_PRIORITY
        self.SO_REUSEADDR = SO_REUSEADDR
        self.SO_DEBUG = SO_DEBUG
        self.SO_RCVTIMEO = SO_RCVTIMEO
        self.SO_SNDBUF = SO_SNDBUF
        self.SO_SNDTIMEO = SO_SNDTIMEO
        self.SO_UPDATE_ACCEPT_CONTEXT = SO_UPDATE_ACCEPT_CONTEXT
        self.SO_TIMEOUT = SO_TIMEOUT
        self.TCP_NODELAY = TCP_NODELAY
    def factory(*args_, **kwargs_):
        if SocketOptionsType.subclass:
            return SocketOptionsType.subclass(*args_, **kwargs_)
        else:
            return SocketOptionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IP_MULTICAST_IF(self): return self.IP_MULTICAST_IF
    def set_IP_MULTICAST_IF(self, IP_MULTICAST_IF): self.IP_MULTICAST_IF = IP_MULTICAST_IF
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_IP_MULTICAST_IF2(self): return self.IP_MULTICAST_IF2
    def set_IP_MULTICAST_IF2(self, IP_MULTICAST_IF2): self.IP_MULTICAST_IF2 = IP_MULTICAST_IF2
    def get_IP_MULTICAST_LOOP(self): return self.IP_MULTICAST_LOOP
    def set_IP_MULTICAST_LOOP(self, IP_MULTICAST_LOOP): self.IP_MULTICAST_LOOP = IP_MULTICAST_LOOP
    def get_IP_TOS(self): return self.IP_TOS
    def set_IP_TOS(self, IP_TOS): self.IP_TOS = IP_TOS
    def get_SO_BROADCAST(self): return self.SO_BROADCAST
    def set_SO_BROADCAST(self, SO_BROADCAST): self.SO_BROADCAST = SO_BROADCAST
    def get_SO_CONDITIONAL_ACCEPT(self): return self.SO_CONDITIONAL_ACCEPT
    def set_SO_CONDITIONAL_ACCEPT(self, SO_CONDITIONAL_ACCEPT): self.SO_CONDITIONAL_ACCEPT = SO_CONDITIONAL_ACCEPT
    def get_SO_KEEPALIVE(self): return self.SO_KEEPALIVE
    def set_SO_KEEPALIVE(self, SO_KEEPALIVE): self.SO_KEEPALIVE = SO_KEEPALIVE
    def get_SO_DONTROUTE(self): return self.SO_DONTROUTE
    def set_SO_DONTROUTE(self, SO_DONTROUTE): self.SO_DONTROUTE = SO_DONTROUTE
    def get_SO_LINGER(self): return self.SO_LINGER
    def set_SO_LINGER(self, SO_LINGER): self.SO_LINGER = SO_LINGER
    def validate_UnsignedIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedIntegerObjectAttributeType, a restriction on None.
        pass
    def get_SO_DONTLINGER(self): return self.SO_DONTLINGER
    def set_SO_DONTLINGER(self, SO_DONTLINGER): self.SO_DONTLINGER = SO_DONTLINGER
    def get_SO_OOBINLINE(self): return self.SO_OOBINLINE
    def set_SO_OOBINLINE(self, SO_OOBINLINE): self.SO_OOBINLINE = SO_OOBINLINE
    def get_SO_RCVBUF(self): return self.SO_RCVBUF
    def set_SO_RCVBUF(self, SO_RCVBUF): self.SO_RCVBUF = SO_RCVBUF
    def get_SO_GROUP_PRIORITY(self): return self.SO_GROUP_PRIORITY
    def set_SO_GROUP_PRIORITY(self, SO_GROUP_PRIORITY): self.SO_GROUP_PRIORITY = SO_GROUP_PRIORITY
    def get_SO_REUSEADDR(self): return self.SO_REUSEADDR
    def set_SO_REUSEADDR(self, SO_REUSEADDR): self.SO_REUSEADDR = SO_REUSEADDR
    def get_SO_DEBUG(self): return self.SO_DEBUG
    def set_SO_DEBUG(self, SO_DEBUG): self.SO_DEBUG = SO_DEBUG
    def get_SO_RCVTIMEO(self): return self.SO_RCVTIMEO
    def set_SO_RCVTIMEO(self, SO_RCVTIMEO): self.SO_RCVTIMEO = SO_RCVTIMEO
    def get_SO_SNDBUF(self): return self.SO_SNDBUF
    def set_SO_SNDBUF(self, SO_SNDBUF): self.SO_SNDBUF = SO_SNDBUF
    def get_SO_SNDTIMEO(self): return self.SO_SNDTIMEO
    def set_SO_SNDTIMEO(self, SO_SNDTIMEO): self.SO_SNDTIMEO = SO_SNDTIMEO
    def get_SO_UPDATE_ACCEPT_CONTEXT(self): return self.SO_UPDATE_ACCEPT_CONTEXT
    def set_SO_UPDATE_ACCEPT_CONTEXT(self, SO_UPDATE_ACCEPT_CONTEXT): self.SO_UPDATE_ACCEPT_CONTEXT = SO_UPDATE_ACCEPT_CONTEXT
    def get_SO_TIMEOUT(self): return self.SO_TIMEOUT
    def set_SO_TIMEOUT(self, SO_TIMEOUT): self.SO_TIMEOUT = SO_TIMEOUT
    def get_TCP_NODELAY(self): return self.TCP_NODELAY
    def set_TCP_NODELAY(self, TCP_NODELAY): self.TCP_NODELAY = TCP_NODELAY
    def export(self, outfile, level, namespace_='SocketObj:', name_='SocketOptionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SocketOptionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='SocketObj:', name_='SocketOptionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='SocketObj:', name_='SocketOptionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IP_MULTICAST_IF is not None:
            self.IP_MULTICAST_IF.export(outfile, level, 'SocketObj:', name_='IP_MULTICAST_IF', pretty_print=pretty_print)
        if self.IP_MULTICAST_IF2 is not None:
            self.IP_MULTICAST_IF2.export(outfile, level, 'SocketObj:', name_='IP_MULTICAST_IF2', pretty_print=pretty_print)
        if self.IP_MULTICAST_LOOP is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIP_MULTICAST_LOOP>%s</%sIP_MULTICAST_LOOP>%s' % ('SocketObj:', self.gds_format_boolean(self.gds_str_lower(str(self.IP_MULTICAST_LOOP)), input_name='IP_MULTICAST_LOOP'), 'SocketObj:', eol_))
        if self.IP_TOS is not None:
            self.IP_TOS.export(outfile, level, 'SocketObj:', name_='IP_TOS', pretty_print=pretty_print)
        if self.SO_BROADCAST is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSO_BROADCAST>%s</%sSO_BROADCAST>%s' % ('SocketObj:', self.gds_format_boolean(self.gds_str_lower(str(self.SO_BROADCAST)), input_name='SO_BROADCAST'), 'SocketObj:', eol_))
        if self.SO_CONDITIONAL_ACCEPT is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSO_CONDITIONAL_ACCEPT>%s</%sSO_CONDITIONAL_ACCEPT>%s' % ('SocketObj:', self.gds_format_boolean(self.gds_str_lower(str(self.SO_CONDITIONAL_ACCEPT)), input_name='SO_CONDITIONAL_ACCEPT'), 'SocketObj:', eol_))
        if self.SO_KEEPALIVE is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSO_KEEPALIVE>%s</%sSO_KEEPALIVE>%s' % ('SocketObj:', self.gds_format_boolean(self.gds_str_lower(str(self.SO_KEEPALIVE)), input_name='SO_KEEPALIVE'), 'SocketObj:', eol_))
        if self.SO_DONTROUTE is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSO_DONTROUTE>%s</%sSO_DONTROUTE>%s' % ('SocketObj:', self.gds_format_boolean(self.gds_str_lower(str(self.SO_DONTROUTE)), input_name='SO_DONTROUTE'), 'SocketObj:', eol_))
        if self.SO_LINGER is not None:
            self.SO_LINGER.export(outfile, level, 'SocketObj:', name_='SO_LINGER', pretty_print=pretty_print)
        if self.SO_DONTLINGER is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSO_DONTLINGER>%s</%sSO_DONTLINGER>%s' % ('SocketObj:', self.gds_format_boolean(self.gds_str_lower(str(self.SO_DONTLINGER)), input_name='SO_DONTLINGER'), 'SocketObj:', eol_))
        if self.SO_OOBINLINE is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSO_OOBINLINE>%s</%sSO_OOBINLINE>%s' % ('SocketObj:', self.gds_format_boolean(self.gds_str_lower(str(self.SO_OOBINLINE)), input_name='SO_OOBINLINE'), 'SocketObj:', eol_))
        if self.SO_RCVBUF is not None:
            self.SO_RCVBUF.export(outfile, level, 'SocketObj:', name_='SO_RCVBUF', pretty_print=pretty_print)
        if self.SO_GROUP_PRIORITY is not None:
            self.SO_GROUP_PRIORITY.export(outfile, level, 'SocketObj:', name_='SO_GROUP_PRIORITY', pretty_print=pretty_print)
        if self.SO_REUSEADDR is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSO_REUSEADDR>%s</%sSO_REUSEADDR>%s' % ('SocketObj:', self.gds_format_boolean(self.gds_str_lower(str(self.SO_REUSEADDR)), input_name='SO_REUSEADDR'), 'SocketObj:', eol_))
        if self.SO_DEBUG is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSO_DEBUG>%s</%sSO_DEBUG>%s' % ('SocketObj:', self.gds_format_boolean(self.gds_str_lower(str(self.SO_DEBUG)), input_name='SO_DEBUG'), 'SocketObj:', eol_))
        if self.SO_RCVTIMEO is not None:
            self.SO_RCVTIMEO.export(outfile, level, 'SocketObj:', name_='SO_RCVTIMEO', pretty_print=pretty_print)
        if self.SO_SNDBUF is not None:
            self.SO_SNDBUF.export(outfile, level, 'SocketObj:', name_='SO_SNDBUF', pretty_print=pretty_print)
        if self.SO_SNDTIMEO is not None:
            self.SO_SNDTIMEO.export(outfile, level, 'SocketObj:', name_='SO_SNDTIMEO', pretty_print=pretty_print)
        if self.SO_UPDATE_ACCEPT_CONTEXT is not None:
            self.SO_UPDATE_ACCEPT_CONTEXT.export(outfile, level, 'SocketObj:', name_='SO_UPDATE_ACCEPT_CONTEXT', pretty_print=pretty_print)
        if self.SO_TIMEOUT is not None:
            self.SO_TIMEOUT.export(outfile, level, 'SocketObj:', name_='SO_TIMEOUT', pretty_print=pretty_print)
        if self.TCP_NODELAY is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTCP_NODELAY>%s</%sTCP_NODELAY>%s' % ('SocketObj:', self.gds_format_boolean(self.gds_str_lower(str(self.TCP_NODELAY)), input_name='TCP_NODELAY'), 'SocketObj:', eol_))
    def hasContent_(self):
        if (
            self.IP_MULTICAST_IF is not None or
            self.IP_MULTICAST_IF2 is not None or
            self.IP_MULTICAST_LOOP is not None or
            self.IP_TOS is not None or
            self.SO_BROADCAST is not None or
            self.SO_CONDITIONAL_ACCEPT is not None or
            self.SO_KEEPALIVE is not None or
            self.SO_DONTROUTE is not None or
            self.SO_LINGER is not None or
            self.SO_DONTLINGER is not None or
            self.SO_OOBINLINE is not None or
            self.SO_RCVBUF is not None or
            self.SO_GROUP_PRIORITY is not None or
            self.SO_REUSEADDR is not None or
            self.SO_DEBUG is not None or
            self.SO_RCVTIMEO is not None or
            self.SO_SNDBUF is not None or
            self.SO_SNDTIMEO is not None or
            self.SO_UPDATE_ACCEPT_CONTEXT is not None or
            self.SO_TIMEOUT is not None or
            self.TCP_NODELAY is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SocketOptionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.IP_MULTICAST_IF is not None:
            showIndent(outfile, level)
            outfile.write('IP_MULTICAST_IF=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.IP_MULTICAST_IF.exportLiteral(outfile, level, name_='IP_MULTICAST_IF')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IP_MULTICAST_IF2 is not None:
            showIndent(outfile, level)
            outfile.write('IP_MULTICAST_IF2=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.IP_MULTICAST_IF2.exportLiteral(outfile, level, name_='IP_MULTICAST_IF2')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IP_MULTICAST_LOOP is not None:
            showIndent(outfile, level)
            outfile.write('IP_MULTICAST_LOOP=%s,\n' % self.IP_MULTICAST_LOOP)
        if self.IP_TOS is not None:
            showIndent(outfile, level)
            outfile.write('IP_TOS=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.IP_TOS.exportLiteral(outfile, level, name_='IP_TOS')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SO_BROADCAST is not None:
            showIndent(outfile, level)
            outfile.write('SO_BROADCAST=%s,\n' % self.SO_BROADCAST)
        if self.SO_CONDITIONAL_ACCEPT is not None:
            showIndent(outfile, level)
            outfile.write('SO_CONDITIONAL_ACCEPT=%s,\n' % self.SO_CONDITIONAL_ACCEPT)
        if self.SO_KEEPALIVE is not None:
            showIndent(outfile, level)
            outfile.write('SO_KEEPALIVE=%s,\n' % self.SO_KEEPALIVE)
        if self.SO_DONTROUTE is not None:
            showIndent(outfile, level)
            outfile.write('SO_DONTROUTE=%s,\n' % self.SO_DONTROUTE)
        if self.SO_LINGER is not None:
            showIndent(outfile, level)
            outfile.write('SO_LINGER=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.SO_LINGER.exportLiteral(outfile, level, name_='SO_LINGER')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SO_DONTLINGER is not None:
            showIndent(outfile, level)
            outfile.write('SO_DONTLINGER=%s,\n' % self.SO_DONTLINGER)
        if self.SO_OOBINLINE is not None:
            showIndent(outfile, level)
            outfile.write('SO_OOBINLINE=%s,\n' % self.SO_OOBINLINE)
        if self.SO_RCVBUF is not None:
            showIndent(outfile, level)
            outfile.write('SO_RCVBUF=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.SO_RCVBUF.exportLiteral(outfile, level, name_='SO_RCVBUF')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SO_GROUP_PRIORITY is not None:
            showIndent(outfile, level)
            outfile.write('SO_GROUP_PRIORITY=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.SO_GROUP_PRIORITY.exportLiteral(outfile, level, name_='SO_GROUP_PRIORITY')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SO_REUSEADDR is not None:
            showIndent(outfile, level)
            outfile.write('SO_REUSEADDR=%s,\n' % self.SO_REUSEADDR)
        if self.SO_DEBUG is not None:
            showIndent(outfile, level)
            outfile.write('SO_DEBUG=%s,\n' % self.SO_DEBUG)
        if self.SO_RCVTIMEO is not None:
            showIndent(outfile, level)
            outfile.write('SO_RCVTIMEO=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.SO_RCVTIMEO.exportLiteral(outfile, level, name_='SO_RCVTIMEO')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SO_SNDBUF is not None:
            showIndent(outfile, level)
            outfile.write('SO_SNDBUF=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.SO_SNDBUF.exportLiteral(outfile, level, name_='SO_SNDBUF')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SO_SNDTIMEO is not None:
            showIndent(outfile, level)
            outfile.write('SO_SNDTIMEO=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.SO_SNDTIMEO.exportLiteral(outfile, level, name_='SO_SNDTIMEO')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SO_UPDATE_ACCEPT_CONTEXT is not None:
            showIndent(outfile, level)
            outfile.write('SO_UPDATE_ACCEPT_CONTEXT=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.SO_UPDATE_ACCEPT_CONTEXT.exportLiteral(outfile, level, name_='SO_UPDATE_ACCEPT_CONTEXT')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SO_TIMEOUT is not None:
            showIndent(outfile, level)
            outfile.write('SO_TIMEOUT=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.SO_TIMEOUT.exportLiteral(outfile, level, name_='SO_TIMEOUT')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.TCP_NODELAY is not None:
            showIndent(outfile, level)
            outfile.write('TCP_NODELAY=%s,\n' % self.TCP_NODELAY)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IP_MULTICAST_IF':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IP_MULTICAST_IF(obj_)
        elif nodeName_ == 'IP_MULTICAST_IF2':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IP_MULTICAST_IF2(obj_)
        elif nodeName_ == 'IP_MULTICAST_LOOP':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IP_MULTICAST_LOOP')
            self.IP_MULTICAST_LOOP = ival_
        elif nodeName_ == 'IP_TOS':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_IP_TOS(obj_)
        elif nodeName_ == 'SO_BROADCAST':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SO_BROADCAST')
            self.SO_BROADCAST = ival_
        elif nodeName_ == 'SO_CONDITIONAL_ACCEPT':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SO_CONDITIONAL_ACCEPT')
            self.SO_CONDITIONAL_ACCEPT = ival_
        elif nodeName_ == 'SO_KEEPALIVE':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SO_KEEPALIVE')
            self.SO_KEEPALIVE = ival_
        elif nodeName_ == 'SO_DONTROUTE':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SO_DONTROUTE')
            self.SO_DONTROUTE = ival_
        elif nodeName_ == 'SO_LINGER':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_SO_LINGER(obj_)
        elif nodeName_ == 'SO_DONTLINGER':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SO_DONTLINGER')
            self.SO_DONTLINGER = ival_
        elif nodeName_ == 'SO_OOBINLINE':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SO_OOBINLINE')
            self.SO_OOBINLINE = ival_
        elif nodeName_ == 'SO_RCVBUF':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_SO_RCVBUF(obj_)
        elif nodeName_ == 'SO_GROUP_PRIORITY':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_SO_GROUP_PRIORITY(obj_)
        elif nodeName_ == 'SO_REUSEADDR':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SO_REUSEADDR')
            self.SO_REUSEADDR = ival_
        elif nodeName_ == 'SO_DEBUG':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SO_DEBUG')
            self.SO_DEBUG = ival_
        elif nodeName_ == 'SO_RCVTIMEO':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_SO_RCVTIMEO(obj_)
        elif nodeName_ == 'SO_SNDBUF':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_SO_SNDBUF(obj_)
        elif nodeName_ == 'SO_SNDTIMEO':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_SO_SNDTIMEO(obj_)
        elif nodeName_ == 'SO_UPDATE_ACCEPT_CONTEXT':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_SO_UPDATE_ACCEPT_CONTEXT(obj_)
        elif nodeName_ == 'SO_TIMEOUT':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_SO_TIMEOUT(obj_)
        elif nodeName_ == 'TCP_NODELAY':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'TCP_NODELAY')
            self.TCP_NODELAY = ival_
# end class SocketOptionsType

class SocketAddressType(GeneratedsSuper):
    """The SocketAddressType type specifies an IP address/port pair."""
    subclass = None
    superclass = None
    def __init__(self, IP_Address=None, Port=None):
        self.IP_Address = IP_Address
        self.Port = Port
    def factory(*args_, **kwargs_):
        if SocketAddressType.subclass:
            return SocketAddressType.subclass(*args_, **kwargs_)
        else:
            return SocketAddressType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IP_Address(self): return self.IP_Address
    def set_IP_Address(self, IP_Address): self.IP_Address = IP_Address
    def get_Port(self): return self.Port
    def set_Port(self, Port): self.Port = Port
    def export(self, outfile, level, namespace_='SocketObj:', name_='SocketAddressType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SocketAddressType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='SocketObj:', name_='SocketAddressType'):
        pass
    def exportChildren(self, outfile, level, namespace_='SocketObj:', name_='SocketAddressType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IP_Address is not None:
            self.IP_Address.export(outfile, level, 'SocketObj:', name_='IP_Address', pretty_print=pretty_print)
        if self.Port is not None:
            self.Port.export(outfile, level, 'SocketObj:', name_='Port', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.IP_Address is not None or
            self.Port is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SocketAddressType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('IP_Address=model_.address_object_1_2.AddressObjectType(\n')
            self.IP_Address.exportLiteral(outfile, level, name_='IP_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Port is not None:
            showIndent(outfile, level)
            outfile.write('Port=model_.port_object_1_3.PortObjectType(\n')
            self.Port.exportLiteral(outfile, level, name_='Port')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IP_Address':
            obj_ = address_object_1_2.AddressObjectType.factory()
            obj_.build(child_)
            self.set_IP_Address(obj_)
        elif nodeName_ == 'Port':
            obj_ = port_object_1_3.PortObjectType.factory()
            obj_.build(child_)
            self.set_Port(obj_)
# end class SocketAddressType

class ProtocolType(cybox_common_types_1_0.BaseObjectAttributeType):
    """ProtocolType specifies protocol types, via a union of the
    ProtocolTypeEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(ProtocolType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ProtocolType.subclass:
            return ProtocolType.subclass(*args_, **kwargs_)
        else:
            return ProtocolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='SocketObj:', name_='ProtocolType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProtocolType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='SocketObj:', name_='ProtocolType'):
        super(ProtocolType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ProtocolType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='SocketObj:', name_='ProtocolType', fromsubclass_=False, pretty_print=True):
        super(ProtocolType, self).exportChildren(outfile, level, 'SocketObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(ProtocolType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ProtocolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(ProtocolType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ProtocolType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(ProtocolType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ProtocolType

class SocketType(cybox_common_types_1_0.BaseObjectAttributeType):
    """SocketType specifies socket types, via a union of the SocketTypeEnum
    type and the atomic xs:string type. Its base type is the CybOX
    Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting complex (i.e.
    regular-expression based) specifications.This attribute is
    optional and specifies the expected type for the value of the
    specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(SocketType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if SocketType.subclass:
            return SocketType.subclass(*args_, **kwargs_)
        else:
            return SocketType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='SocketObj:', name_='SocketType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SocketType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='SocketObj:', name_='SocketType'):
        super(SocketType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SocketType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='SocketObj:', name_='SocketType', fromsubclass_=False, pretty_print=True):
        super(SocketType, self).exportChildren(outfile, level, 'SocketObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(SocketType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SocketType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(SocketType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SocketType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(SocketType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SocketType

class DomainFamilyType(cybox_common_types_1_0.BaseObjectAttributeType):
    """DomainFamilyType specifies domain family types, via a union of the
    DomainTypeEnum type and the atomic xs:string type. Its base type
    is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(DomainFamilyType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if DomainFamilyType.subclass:
            return DomainFamilyType.subclass(*args_, **kwargs_)
        else:
            return DomainFamilyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='SocketObj:', name_='DomainFamilyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DomainFamilyType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='SocketObj:', name_='DomainFamilyType'):
        super(DomainFamilyType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DomainFamilyType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='SocketObj:', name_='DomainFamilyType', fromsubclass_=False, pretty_print=True):
        super(DomainFamilyType, self).exportChildren(outfile, level, 'SocketObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(DomainFamilyType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DomainFamilyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(DomainFamilyType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DomainFamilyType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(DomainFamilyType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DomainFamilyType

class AddressFamilyType(cybox_common_types_1_0.BaseObjectAttributeType):
    """AddressFamilyType specifies address family types, via a union of the
    AddressFamilyTypeEnum type and the atomic xs:string type. Its
    base type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for
    permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(AddressFamilyType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if AddressFamilyType.subclass:
            return AddressFamilyType.subclass(*args_, **kwargs_)
        else:
            return AddressFamilyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='SocketObj:', name_='AddressFamilyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AddressFamilyType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='SocketObj:', name_='AddressFamilyType'):
        super(AddressFamilyType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AddressFamilyType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='SocketObj:', name_='AddressFamilyType', fromsubclass_=False, pretty_print=True):
        super(AddressFamilyType, self).exportChildren(outfile, level, 'SocketObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(AddressFamilyType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AddressFamilyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(AddressFamilyType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AddressFamilyType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(AddressFamilyType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class AddressFamilyType

class SocketObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The SocketObjectType type is intended to characterize network
    sockets.The isblocking attribute specifies whether or not the
    socket is in blocking mode. The islistening attribute specifies
    whether or not the socket is in listening mode."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, is_blocking=None, is_listening=None, Address_Family=None, Domain=None, Local_Address=None, Options=None, Protocol=None, Remote_Address=None, Type=None):
        super(SocketObjectType, self).__init__(object_reference, )
        self.is_blocking = _cast(bool, is_blocking)
        self.is_listening = _cast(bool, is_listening)
        self.Address_Family = Address_Family
        self.Domain = Domain
        self.Local_Address = Local_Address
        self.Options = Options
        self.Protocol = Protocol
        self.Remote_Address = Remote_Address
        self.Type = Type
    def factory(*args_, **kwargs_):
        if SocketObjectType.subclass:
            return SocketObjectType.subclass(*args_, **kwargs_)
        else:
            return SocketObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Address_Family(self): return self.Address_Family
    def set_Address_Family(self, Address_Family): self.Address_Family = Address_Family
    def validate_AddressFamilyType(self, value):
        # Validate type AddressFamilyType, a restriction on None.
        pass
    def get_Domain(self): return self.Domain
    def set_Domain(self, Domain): self.Domain = Domain
    def validate_DomainFamilyType(self, value):
        # Validate type DomainFamilyType, a restriction on None.
        pass
    def get_Local_Address(self): return self.Local_Address
    def set_Local_Address(self, Local_Address): self.Local_Address = Local_Address
    def get_Options(self): return self.Options
    def set_Options(self, Options): self.Options = Options
    def get_Protocol(self): return self.Protocol
    def set_Protocol(self, Protocol): self.Protocol = Protocol
    def validate_ProtocolType(self, value):
        # Validate type ProtocolType, a restriction on None.
        pass
    def get_Remote_Address(self): return self.Remote_Address
    def set_Remote_Address(self, Remote_Address): self.Remote_Address = Remote_Address
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_SocketType(self, value):
        # Validate type SocketType, a restriction on None.
        pass
    def get_is_blocking(self): return self.is_blocking
    def set_is_blocking(self, is_blocking): self.is_blocking = is_blocking
    def get_is_listening(self): return self.is_listening
    def set_is_listening(self, is_listening): self.is_listening = is_listening
    def export(self, outfile, level, namespace_='SocketObj:', name_='SocketObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SocketObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='SocketObj:', name_='SocketObjectType'):
        super(SocketObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SocketObjectType')
        if self.is_blocking is not None and 'is_blocking' not in already_processed:
            already_processed.append('is_blocking')
            outfile.write(' is_blocking="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.is_blocking)), input_name='is_blocking'))
        if self.is_listening is not None and 'is_listening' not in already_processed:
            already_processed.append('is_listening')
            outfile.write(' is_listening="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.is_listening)), input_name='is_listening'))
    def exportChildren(self, outfile, level, namespace_='SocketObj:', name_='SocketObjectType', fromsubclass_=False, pretty_print=True):
        super(SocketObjectType, self).exportChildren(outfile, level, 'SocketObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Address_Family is not None:
            self.Address_Family.export(outfile, level, 'SocketObj:', name_='Address_Family', pretty_print=pretty_print)
        if self.Domain is not None:
            self.Domain.export(outfile, level, 'SocketObj:', name_='Domain', pretty_print=pretty_print)
        if self.Local_Address is not None:
            self.Local_Address.export(outfile, level, 'SocketObj:', name_='Local_Address', pretty_print=pretty_print)
        if self.Options is not None:
            self.Options.export(outfile, level, 'SocketObj:', name_='Options', pretty_print=pretty_print)
        if self.Protocol is not None:
            self.Protocol.export(outfile, level, 'SocketObj:', name_='Protocol', pretty_print=pretty_print)
        if self.Remote_Address is not None:
            self.Remote_Address.export(outfile, level, 'SocketObj:', name_='Remote_Address', pretty_print=pretty_print)
        if self.Type is not None:
            self.Type.export(outfile, level, 'SocketObj:', name_='Type', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Address_Family is not None or
            self.Domain is not None or
            self.Local_Address is not None or
            self.Options is not None or
            self.Protocol is not None or
            self.Remote_Address is not None or
            self.Type is not None or
            super(SocketObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SocketObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_blocking is not None and 'is_blocking' not in already_processed:
            already_processed.append('is_blocking')
            showIndent(outfile, level)
            outfile.write('is_blocking = %s,\n' % (self.is_blocking,))
        if self.is_listening is not None and 'is_listening' not in already_processed:
            already_processed.append('is_listening')
            showIndent(outfile, level)
            outfile.write('is_listening = %s,\n' % (self.is_listening,))
        super(SocketObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SocketObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Address_Family is not None:
            showIndent(outfile, level)
            outfile.write('Address_Family=model_.AddressFamilyType(\n')
            self.Address_Family.exportLiteral(outfile, level, name_='Address_Family')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Domain is not None:
            showIndent(outfile, level)
            outfile.write('Domain=model_.DomainFamilyType(\n')
            self.Domain.exportLiteral(outfile, level, name_='Domain')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Local_Address is not None:
            showIndent(outfile, level)
            outfile.write('Local_Address=model_.SocketAddressType(\n')
            self.Local_Address.exportLiteral(outfile, level, name_='Local_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Options is not None:
            showIndent(outfile, level)
            outfile.write('Options=model_.SocketOptionsType(\n')
            self.Options.exportLiteral(outfile, level, name_='Options')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Protocol=model_.ProtocolType(\n')
            self.Protocol.exportLiteral(outfile, level, name_='Protocol')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Remote_Address is not None:
            showIndent(outfile, level)
            outfile.write('Remote_Address=model_.SocketAddressType(\n')
            self.Remote_Address.exportLiteral(outfile, level, name_='Remote_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Type is not None:
            showIndent(outfile, level)
            outfile.write('Type=model_.SocketType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_blocking', node)
        if value is not None and 'is_blocking' not in already_processed:
            already_processed.append('is_blocking')
            if value in ('true', '1'):
                self.is_blocking = True
            elif value in ('false', '0'):
                self.is_blocking = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('is_listening', node)
        if value is not None and 'is_listening' not in already_processed:
            already_processed.append('is_listening')
            if value in ('true', '1'):
                self.is_listening = True
            elif value in ('false', '0'):
                self.is_listening = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(SocketObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Address_Family':
            obj_ = AddressFamilyType.factory()
            obj_.build(child_)
            self.set_Address_Family(obj_)
        elif nodeName_ == 'Domain':
            obj_ = DomainFamilyType.factory()
            obj_.build(child_)
            self.set_Domain(obj_)
        elif nodeName_ == 'Local_Address':
            obj_ = SocketAddressType.factory()
            obj_.build(child_)
            self.set_Local_Address(obj_)
        elif nodeName_ == 'Options':
            obj_ = SocketOptionsType.factory()
            obj_.build(child_)
            self.set_Options(obj_)
        elif nodeName_ == 'Protocol':
            obj_ = ProtocolType.factory()
            obj_.build(child_)
            self.set_Protocol(obj_)
        elif nodeName_ == 'Remote_Address':
            obj_ = SocketAddressType.factory()
            obj_.build(child_)
            self.set_Remote_Address(obj_)
        elif nodeName_ == 'Type':
            obj_ = SocketType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
        super(SocketObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class SocketObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Socket'
        rootClass = SocketObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Socket'
        rootClass = SocketObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Socket",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Socket'
        rootClass = SocketObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "SocketObjectType",
    "SocketOptionsType",
    "SocketAddressType",
    "AddressFamilyType",
    "DomainFamilyType",
    "SocketType",
    "ProtocolType"
    ]