#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:03:55 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import win_file_object_1_3
import cybox_common_types_1_0

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class PEAttributesType(GeneratedsSuper):
    """The PEAttributesType specifies the attributes of a file in the
    Portable Executable (PE) format, such as execuatbles or
    dynamically loaded libraries."""
    subclass = None
    superclass = None
    def __init__(self, Base_Address=None, Detected_EntryPoint_Signatures=None, Digital_Signature=None, EP_Jump_Codes=None, Exports=None, Extraneous_Bytes=None, Headers=None, Imports=None, PE_Checksum=None, PE_Timestamp=None, Resources=None, Sections=None, Strings=None, Subsystem=None, Type=None):
        self.Base_Address = Base_Address
        self.Detected_EntryPoint_Signatures = Detected_EntryPoint_Signatures
        self.Digital_Signature = Digital_Signature
        self.EP_Jump_Codes = EP_Jump_Codes
        self.Exports = Exports
        self.Extraneous_Bytes = Extraneous_Bytes
        self.Headers = Headers
        self.Imports = Imports
        self.PE_Checksum = PE_Checksum
        self.PE_Timestamp = PE_Timestamp
        self.Resources = Resources
        self.Sections = Sections
        self.Strings = Strings
        self.Subsystem = Subsystem
        self.Type = Type
    def factory(*args_, **kwargs_):
        if PEAttributesType.subclass:
            return PEAttributesType.subclass(*args_, **kwargs_)
        else:
            return PEAttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Base_Address(self): return self.Base_Address
    def set_Base_Address(self, Base_Address): self.Base_Address = Base_Address
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Detected_EntryPoint_Signatures(self): return self.Detected_EntryPoint_Signatures
    def set_Detected_EntryPoint_Signatures(self, Detected_EntryPoint_Signatures): self.Detected_EntryPoint_Signatures = Detected_EntryPoint_Signatures
    def get_Digital_Signature(self): return self.Digital_Signature
    def set_Digital_Signature(self, Digital_Signature): self.Digital_Signature = Digital_Signature
    def get_EP_Jump_Codes(self): return self.EP_Jump_Codes
    def set_EP_Jump_Codes(self, EP_Jump_Codes): self.EP_Jump_Codes = EP_Jump_Codes
    def get_Exports(self): return self.Exports
    def set_Exports(self, Exports): self.Exports = Exports
    def get_Extraneous_Bytes(self): return self.Extraneous_Bytes
    def set_Extraneous_Bytes(self, Extraneous_Bytes): self.Extraneous_Bytes = Extraneous_Bytes
    def validate_IntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.IntegerObjectAttributeType, a restriction on None.
        pass
    def get_Headers(self): return self.Headers
    def set_Headers(self, Headers): self.Headers = Headers
    def get_Imports(self): return self.Imports
    def set_Imports(self, Imports): self.Imports = Imports
    def get_PE_Checksum(self): return self.PE_Checksum
    def set_PE_Checksum(self, PE_Checksum): self.PE_Checksum = PE_Checksum
    def get_PE_Timestamp(self): return self.PE_Timestamp
    def set_PE_Timestamp(self, PE_Timestamp): self.PE_Timestamp = PE_Timestamp
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Resources(self): return self.Resources
    def set_Resources(self, Resources): self.Resources = Resources
    def get_Sections(self): return self.Sections
    def set_Sections(self, Sections): self.Sections = Sections
    def get_Strings(self): return self.Strings
    def set_Strings(self, Strings): self.Strings = Strings
    def get_Subsystem(self): return self.Subsystem
    def set_Subsystem(self, Subsystem): self.Subsystem = Subsystem
    def validate_SubsystemType(self, value):
        # Validate type SubsystemType, a restriction on None.
        pass
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_PEType(self, value):
        # Validate type PEType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEAttributesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEAttributesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEAttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEAttributesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Base_Address is not None:
            self.Base_Address.export(outfile, level, 'WinExecutableFileObj:', name_='Base_Address', pretty_print=pretty_print)
        if self.Detected_EntryPoint_Signatures is not None:
            self.Detected_EntryPoint_Signatures.export(outfile, level, 'WinExecutableFileObj:', name_='Detected_EntryPoint_Signatures', pretty_print=pretty_print)
        if self.Digital_Signature is not None:
            self.Digital_Signature.export(outfile, level, 'WinExecutableFileObj:', name_='Digital_Signature', pretty_print=pretty_print)
        if self.EP_Jump_Codes is not None:
            self.EP_Jump_Codes.export(outfile, level, 'WinExecutableFileObj:', name_='EP_Jump_Codes', pretty_print=pretty_print)
        if self.Exports is not None:
            self.Exports.export(outfile, level, 'WinExecutableFileObj:', name_='Exports', pretty_print=pretty_print)
        if self.Extraneous_Bytes is not None:
            self.Extraneous_Bytes.export(outfile, level, 'WinExecutableFileObj:', name_='Extraneous_Bytes', pretty_print=pretty_print)
        if self.Headers is not None:
            self.Headers.export(outfile, level, 'WinExecutableFileObj:', name_='Headers', pretty_print=pretty_print)
        if self.Imports is not None:
            self.Imports.export(outfile, level, 'WinExecutableFileObj:', name_='Imports', pretty_print=pretty_print)
        if self.PE_Checksum is not None:
            self.PE_Checksum.export(outfile, level, 'WinExecutableFileObj:', name_='PE_Checksum', pretty_print=pretty_print)
        if self.PE_Timestamp is not None:
            self.PE_Timestamp.export(outfile, level, 'WinExecutableFileObj:', name_='PE_Timestamp', pretty_print=pretty_print)
        if self.Resources is not None:
            self.Resources.export(outfile, level, 'WinExecutableFileObj:', name_='Resources', pretty_print=pretty_print)
        if self.Sections is not None:
            self.Sections.export(outfile, level, 'WinExecutableFileObj:', name_='Sections', pretty_print=pretty_print)
        if self.Strings is not None:
            self.Strings.export(outfile, level, 'WinExecutableFileObj:', name_='Strings', pretty_print=pretty_print)
        if self.Subsystem is not None:
            self.Subsystem.export(outfile, level, 'WinExecutableFileObj:', name_='Subsystem', pretty_print=pretty_print)
        if self.Type is not None:
            self.Type.export(outfile, level, 'WinExecutableFileObj:', name_='Type', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Base_Address is not None or
            self.Detected_EntryPoint_Signatures is not None or
            self.Digital_Signature is not None or
            self.EP_Jump_Codes is not None or
            self.Exports is not None or
            self.Extraneous_Bytes is not None or
            self.Headers is not None or
            self.Imports is not None or
            self.PE_Checksum is not None or
            self.PE_Timestamp is not None or
            self.Resources is not None or
            self.Sections is not None or
            self.Strings is not None or
            self.Subsystem is not None or
            self.Type is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEAttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Base_Address is not None:
            showIndent(outfile, level)
            outfile.write('Base_Address=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Base_Address.exportLiteral(outfile, level, name_='Base_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Detected_EntryPoint_Signatures is not None:
            showIndent(outfile, level)
            outfile.write('Detected_EntryPoint_Signatures=model_.EntryPointSignatureListType(\n')
            self.Detected_EntryPoint_Signatures.exportLiteral(outfile, level, name_='Detected_EntryPoint_Signatures')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Digital_Signature is not None:
            showIndent(outfile, level)
            outfile.write('Digital_Signature=model_.cybox_common_types_1_0.DigitalSignatureInfoType(\n')
            self.Digital_Signature.exportLiteral(outfile, level, name_='Digital_Signature')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.EP_Jump_Codes is not None:
            showIndent(outfile, level)
            outfile.write('EP_Jump_Codes=model_.EPJumpCodeType(\n')
            self.EP_Jump_Codes.exportLiteral(outfile, level, name_='EP_Jump_Codes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exports is not None:
            showIndent(outfile, level)
            outfile.write('Exports=model_.PEExportsType(\n')
            self.Exports.exportLiteral(outfile, level, name_='Exports')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Extraneous_Bytes is not None:
            showIndent(outfile, level)
            outfile.write('Extraneous_Bytes=model_.cybox_common_types_1_0.IntegerObjectAttributeType(\n')
            self.Extraneous_Bytes.exportLiteral(outfile, level, name_='Extraneous_Bytes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Headers is not None:
            showIndent(outfile, level)
            outfile.write('Headers=model_.PEHeadersType(\n')
            self.Headers.exportLiteral(outfile, level, name_='Headers')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Imports is not None:
            showIndent(outfile, level)
            outfile.write('Imports=model_.PEImportListType(\n')
            self.Imports.exportLiteral(outfile, level, name_='Imports')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PE_Checksum is not None:
            showIndent(outfile, level)
            outfile.write('PE_Checksum=model_.PEChecksumType(\n')
            self.PE_Checksum.exportLiteral(outfile, level, name_='PE_Checksum')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PE_Timestamp is not None:
            showIndent(outfile, level)
            outfile.write('PE_Timestamp=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.PE_Timestamp.exportLiteral(outfile, level, name_='PE_Timestamp')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Resources is not None:
            showIndent(outfile, level)
            outfile.write('Resources=model_.PEResourceListType(\n')
            self.Resources.exportLiteral(outfile, level, name_='Resources')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Sections is not None:
            showIndent(outfile, level)
            outfile.write('Sections=model_.PESectionListType(\n')
            self.Sections.exportLiteral(outfile, level, name_='Sections')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Strings is not None:
            showIndent(outfile, level)
            outfile.write('Strings=model_.StringListType(\n')
            self.Strings.exportLiteral(outfile, level, name_='Strings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Subsystem is not None:
            showIndent(outfile, level)
            outfile.write('Subsystem=model_.SubsystemType(\n')
            self.Subsystem.exportLiteral(outfile, level, name_='Subsystem')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Type is not None:
            showIndent(outfile, level)
            outfile.write('Type=model_.PEType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Base_Address':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Base_Address(obj_)
        elif nodeName_ == 'Detected_EntryPoint_Signatures':
            obj_ = EntryPointSignatureListType.factory()
            obj_.build(child_)
            self.set_Detected_EntryPoint_Signatures(obj_)
        elif nodeName_ == 'Digital_Signature':
            obj_ = cybox_common_types_1_0.DigitalSignatureInfoType.factory()
            obj_.build(child_)
            self.set_Digital_Signature(obj_)
        elif nodeName_ == 'EP_Jump_Codes':
            obj_ = EPJumpCodeType.factory()
            obj_.build(child_)
            self.set_EP_Jump_Codes(obj_)
        elif nodeName_ == 'Exports':
            obj_ = PEExportsType.factory()
            obj_.build(child_)
            self.set_Exports(obj_)
        elif nodeName_ == 'Extraneous_Bytes':
            obj_ = cybox_common_types_1_0.IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Extraneous_Bytes(obj_)
        elif nodeName_ == 'Headers':
            obj_ = PEHeadersType.factory()
            obj_.build(child_)
            self.set_Headers(obj_)
        elif nodeName_ == 'Imports':
            obj_ = PEImportListType.factory()
            obj_.build(child_)
            self.set_Imports(obj_)
        elif nodeName_ == 'PE_Checksum':
            obj_ = PEChecksumType.factory()
            obj_.build(child_)
            self.set_PE_Checksum(obj_)
        elif nodeName_ == 'PE_Timestamp':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_PE_Timestamp(obj_)
        elif nodeName_ == 'Resources':
            obj_ = PEResourceListType.factory()
            obj_.build(child_)
            self.set_Resources(obj_)
        elif nodeName_ == 'Sections':
            obj_ = PESectionListType.factory()
            obj_.build(child_)
            self.set_Sections(obj_)
        elif nodeName_ == 'Strings':
            obj_ = StringListType.factory()
            obj_.build(child_)
            self.set_Strings(obj_)
        elif nodeName_ == 'Subsystem':
            obj_ = SubsystemType.factory()
            obj_.build(child_)
            self.set_Subsystem(obj_)
        elif nodeName_ == 'Type':
            obj_ = PEType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
# end class PEAttributesType

class PEChecksumType(GeneratedsSuper):
    """The PECheckSumType records the checksum of the PE file, both as
    found in the file and computed."""
    subclass = None
    superclass = None
    def __init__(self, PE_Computed_API=None, PE_File_API=None, PE_File_Raw=None):
        self.PE_Computed_API = PE_Computed_API
        self.PE_File_API = PE_File_API
        self.PE_File_Raw = PE_File_Raw
    def factory(*args_, **kwargs_):
        if PEChecksumType.subclass:
            return PEChecksumType.subclass(*args_, **kwargs_)
        else:
            return PEChecksumType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PE_Computed_API(self): return self.PE_Computed_API
    def set_PE_Computed_API(self, PE_Computed_API): self.PE_Computed_API = PE_Computed_API
    def validate_LongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.LongObjectAttributeType, a restriction on None.
        pass
    def get_PE_File_API(self): return self.PE_File_API
    def set_PE_File_API(self, PE_File_API): self.PE_File_API = PE_File_API
    def get_PE_File_Raw(self): return self.PE_File_Raw
    def set_PE_File_Raw(self, PE_File_Raw): self.PE_File_Raw = PE_File_Raw
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEChecksumType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEChecksumType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEChecksumType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEChecksumType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PE_Computed_API is not None:
            self.PE_Computed_API.export(outfile, level, 'WinExecutableFileObj:', name_='PE_Computed_API', pretty_print=pretty_print)
        if self.PE_File_API is not None:
            self.PE_File_API.export(outfile, level, 'WinExecutableFileObj:', name_='PE_File_API', pretty_print=pretty_print)
        if self.PE_File_Raw is not None:
            self.PE_File_Raw.export(outfile, level, 'WinExecutableFileObj:', name_='PE_File_Raw', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.PE_Computed_API is not None or
            self.PE_File_API is not None or
            self.PE_File_Raw is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEChecksumType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.PE_Computed_API is not None:
            showIndent(outfile, level)
            outfile.write('PE_Computed_API=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.PE_Computed_API.exportLiteral(outfile, level, name_='PE_Computed_API')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PE_File_API is not None:
            showIndent(outfile, level)
            outfile.write('PE_File_API=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.PE_File_API.exportLiteral(outfile, level, name_='PE_File_API')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PE_File_Raw is not None:
            showIndent(outfile, level)
            outfile.write('PE_File_Raw=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.PE_File_Raw.exportLiteral(outfile, level, name_='PE_File_Raw')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PE_Computed_API':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_PE_Computed_API(obj_)
        elif nodeName_ == 'PE_File_API':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_PE_File_API(obj_)
        elif nodeName_ == 'PE_File_Raw':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_PE_File_Raw(obj_)
# end class PEChecksumType

class PEExportsType(GeneratedsSuper):
    """PEExportsType specifies the PE File exports data section. The
    exports data section contains information about symbols exported
    by the PE File (a DLL) which can be dynamically loaded by other
    executables. This type abstracts, and its components, abstract
    the Windows structures."""
    subclass = None
    superclass = None
    def __init__(self, Exported_Functions=None, Exports_Time_Stamp=None, Number_Of_Addresses=None, Number_Of_Names=None):
        self.Exported_Functions = Exported_Functions
        self.Exports_Time_Stamp = Exports_Time_Stamp
        self.Number_Of_Addresses = Number_Of_Addresses
        self.Number_Of_Names = Number_Of_Names
    def factory(*args_, **kwargs_):
        if PEExportsType.subclass:
            return PEExportsType.subclass(*args_, **kwargs_)
        else:
            return PEExportsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Exported_Functions(self): return self.Exported_Functions
    def set_Exported_Functions(self, Exported_Functions): self.Exported_Functions = Exported_Functions
    def get_Exports_Time_Stamp(self): return self.Exports_Time_Stamp
    def set_Exports_Time_Stamp(self, Exports_Time_Stamp): self.Exports_Time_Stamp = Exports_Time_Stamp
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Number_Of_Addresses(self): return self.Number_Of_Addresses
    def set_Number_Of_Addresses(self, Number_Of_Addresses): self.Number_Of_Addresses = Number_Of_Addresses
    def validate_LongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.LongObjectAttributeType, a restriction on None.
        pass
    def get_Number_Of_Names(self): return self.Number_Of_Names
    def set_Number_Of_Names(self, Number_Of_Names): self.Number_Of_Names = Number_Of_Names
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEExportsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEExportsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEExportsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEExportsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Exported_Functions is not None:
            self.Exported_Functions.export(outfile, level, 'WinExecutableFileObj:', name_='Exported_Functions', pretty_print=pretty_print)
        if self.Exports_Time_Stamp is not None:
            self.Exports_Time_Stamp.export(outfile, level, 'WinExecutableFileObj:', name_='Exports_Time_Stamp', pretty_print=pretty_print)
        if self.Number_Of_Addresses is not None:
            self.Number_Of_Addresses.export(outfile, level, 'WinExecutableFileObj:', name_='Number_Of_Addresses', pretty_print=pretty_print)
        if self.Number_Of_Names is not None:
            self.Number_Of_Names.export(outfile, level, 'WinExecutableFileObj:', name_='Number_Of_Names', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Exported_Functions is not None or
            self.Exports_Time_Stamp is not None or
            self.Number_Of_Addresses is not None or
            self.Number_Of_Names is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEExportsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Exported_Functions is not None:
            showIndent(outfile, level)
            outfile.write('Exported_Functions=model_.PEExportedFunctionsType(\n')
            self.Exported_Functions.exportLiteral(outfile, level, name_='Exported_Functions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exports_Time_Stamp is not None:
            showIndent(outfile, level)
            outfile.write('Exports_Time_Stamp=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Exports_Time_Stamp.exportLiteral(outfile, level, name_='Exports_Time_Stamp')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Addresses is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Addresses=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.Number_Of_Addresses.exportLiteral(outfile, level, name_='Number_Of_Addresses')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Names is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Names=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.Number_Of_Names.exportLiteral(outfile, level, name_='Number_Of_Names')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Exported_Functions':
            obj_ = PEExportedFunctionsType.factory()
            obj_.build(child_)
            self.set_Exported_Functions(obj_)
        elif nodeName_ == 'Exports_Time_Stamp':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Exports_Time_Stamp(obj_)
        elif nodeName_ == 'Number_Of_Addresses':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Number_Of_Addresses(obj_)
        elif nodeName_ == 'Number_Of_Names':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Number_Of_Names(obj_)
# end class PEExportsType

class PEExportedFunctionsType(GeneratedsSuper):
    """PEExportedFunctionsType specifies a list of PE exported functions"""
    subclass = None
    superclass = None
    def __init__(self, Exported_Function=None):
        if Exported_Function is None:
            self.Exported_Function = []
        else:
            self.Exported_Function = Exported_Function
    def factory(*args_, **kwargs_):
        if PEExportedFunctionsType.subclass:
            return PEExportedFunctionsType.subclass(*args_, **kwargs_)
        else:
            return PEExportedFunctionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Exported_Function(self): return self.Exported_Function
    def set_Exported_Function(self, Exported_Function): self.Exported_Function = Exported_Function
    def add_Exported_Function(self, value): self.Exported_Function.append(value)
    def insert_Exported_Function(self, index, value): self.Exported_Function[index] = value
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEExportedFunctionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEExportedFunctionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEExportedFunctionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEExportedFunctionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Exported_Function_ in self.Exported_Function:
            Exported_Function_.export(outfile, level, 'WinExecutableFileObj:', name_='Exported_Function', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Exported_Function
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEExportedFunctionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Exported_Function=[\n')
        level += 1
        for Exported_Function_ in self.Exported_Function:
            showIndent(outfile, level)
            outfile.write('model_.PEExportedFunctionType(\n')
            Exported_Function_.exportLiteral(outfile, level, name_='PEExportedFunctionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Exported_Function':
            obj_ = PEExportedFunctionType.factory()
            obj_.build(child_)
            self.Exported_Function.append(obj_)
# end class PEExportedFunctionsType

class StringListType(GeneratedsSuper):
    """StringListType specifies a list of strings contained in the PE File."""
    subclass = None
    superclass = None
    def __init__(self, String=None):
        if String is None:
            self.String = []
        else:
            self.String = String
    def factory(*args_, **kwargs_):
        if StringListType.subclass:
            return StringListType.subclass(*args_, **kwargs_)
        else:
            return StringListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_String(self): return self.String
    def set_String(self, String): self.String = String
    def add_String(self, value): self.String.append(value)
    def insert_String(self, index, value): self.String[index] = value
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='StringListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StringListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='StringListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='StringListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for String_ in self.String:
            String_.export(outfile, level, 'WinExecutableFileObj:', name_='String', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.String
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StringListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('String=[\n')
        level += 1
        for String_ in self.String:
            showIndent(outfile, level)
            outfile.write('model_.PEStringType(\n')
            String_.exportLiteral(outfile, level, name_='PEStringType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'String':
            obj_ = PEStringType.factory()
            obj_.build(child_)
            self.String.append(obj_)
# end class StringListType

class EPJumpCodeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Depth=None, Opcodes=None):
        self.Depth = Depth
        self.Opcodes = Opcodes
    def factory(*args_, **kwargs_):
        if EPJumpCodeType.subclass:
            return EPJumpCodeType.subclass(*args_, **kwargs_)
        else:
            return EPJumpCodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Depth(self): return self.Depth
    def set_Depth(self, Depth): self.Depth = Depth
    def validate_IntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.IntegerObjectAttributeType, a restriction on None.
        pass
    def get_Opcodes(self): return self.Opcodes
    def set_Opcodes(self, Opcodes): self.Opcodes = Opcodes
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='EPJumpCodeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EPJumpCodeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='EPJumpCodeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='EPJumpCodeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Depth is not None:
            self.Depth.export(outfile, level, 'WinExecutableFileObj:', name_='Depth', pretty_print=pretty_print)
        if self.Opcodes is not None:
            self.Opcodes.export(outfile, level, 'WinExecutableFileObj:', name_='Opcodes', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Depth is not None or
            self.Opcodes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EPJumpCodeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Depth is not None:
            showIndent(outfile, level)
            outfile.write('Depth=model_.cybox_common_types_1_0.IntegerObjectAttributeType(\n')
            self.Depth.exportLiteral(outfile, level, name_='Depth')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Opcodes is not None:
            showIndent(outfile, level)
            outfile.write('Opcodes=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Opcodes.exportLiteral(outfile, level, name_='Opcodes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Depth':
            obj_ = cybox_common_types_1_0.IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Depth(obj_)
        elif nodeName_ == 'Opcodes':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Opcodes(obj_)
# end class EPJumpCodeType

class EntryPointSignatureType(GeneratedsSuper):
    """Specifies an entry point signature."""
    subclass = None
    superclass = None
    def __init__(self, Name=None, Type=None):
        self.Name = Name
        self.Type = Type
    def factory(*args_, **kwargs_):
        if EntryPointSignatureType.subclass:
            return EntryPointSignatureType.subclass(*args_, **kwargs_)
        else:
            return EntryPointSignatureType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_DetectedType(self, value):
        # Validate type DetectedType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='EntryPointSignatureType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntryPointSignatureType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='EntryPointSignatureType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='EntryPointSignatureType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            self.Name.export(outfile, level, 'WinExecutableFileObj:', name_='Name', pretty_print=pretty_print)
        if self.Type is not None:
            self.Type.export(outfile, level, 'WinExecutableFileObj:', name_='Type', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Type is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EntryPointSignatureType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Type is not None:
            showIndent(outfile, level)
            outfile.write('Type=model_.DetectedType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Type':
            obj_ = PEType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
# end class EntryPointSignatureType

class EntryPointSignatureListType(GeneratedsSuper):
    """Species a list of entry point signatures."""
    subclass = None
    superclass = None
    def __init__(self, Entry_Point_Signature=None):
        if Entry_Point_Signature is None:
            self.Entry_Point_Signature = []
        else:
            self.Entry_Point_Signature = Entry_Point_Signature
    def factory(*args_, **kwargs_):
        if EntryPointSignatureListType.subclass:
            return EntryPointSignatureListType.subclass(*args_, **kwargs_)
        else:
            return EntryPointSignatureListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Entry_Point_Signature(self): return self.Entry_Point_Signature
    def set_Entry_Point_Signature(self, Entry_Point_Signature): self.Entry_Point_Signature = Entry_Point_Signature
    def add_Entry_Point_Signature(self, value): self.Entry_Point_Signature.append(value)
    def insert_Entry_Point_Signature(self, index, value): self.Entry_Point_Signature[index] = value
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='EntryPointSignatureListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntryPointSignatureListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='EntryPointSignatureListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='EntryPointSignatureListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Entry_Point_Signature_ in self.Entry_Point_Signature:
            Entry_Point_Signature_.export(outfile, level, 'WinExecutableFileObj:', name_='Entry_Point_Signature', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Entry_Point_Signature
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EntryPointSignatureListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Entry_Point_Signature=[\n')
        level += 1
        for Entry_Point_Signature_ in self.Entry_Point_Signature:
            showIndent(outfile, level)
            outfile.write('model_.EntryPointSignatureType(\n')
            Entry_Point_Signature_.exportLiteral(outfile, level, name_='EntryPointSignatureType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Entry_Point_Signature':
            obj_ = EntryPointSignatureType.factory()
            obj_.build(child_)
            self.Entry_Point_Signature.append(obj_)
# end class EntryPointSignatureListType

class PESectionListType(GeneratedsSuper):
    """Specifies a list of sections that appear in the PE file."""
    subclass = None
    superclass = None
    def __init__(self, Section=None):
        if Section is None:
            self.Section = []
        else:
            self.Section = Section
    def factory(*args_, **kwargs_):
        if PESectionListType.subclass:
            return PESectionListType.subclass(*args_, **kwargs_)
        else:
            return PESectionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Section(self): return self.Section
    def set_Section(self, Section): self.Section = Section
    def add_Section(self, value): self.Section.append(value)
    def insert_Section(self, index, value): self.Section[index] = value
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PESectionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PESectionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PESectionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PESectionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Section_ in self.Section:
            Section_.export(outfile, level, 'WinExecutableFileObj:', name_='Section', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Section
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PESectionListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Section=[\n')
        level += 1
        for Section_ in self.Section:
            showIndent(outfile, level)
            outfile.write('model_.PESectionType(\n')
            Section_.exportLiteral(outfile, level, name_='PESectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Section':
            obj_ = PESectionType.factory()
            obj_.build(child_)
            self.Section.append(obj_)
# end class PESectionListType

class EntropyType(GeneratedsSuper):
    """Specifies the result of an entropy computation."""
    subclass = None
    superclass = None
    def __init__(self, Value=None, Min=None, Max=None):
        self.Value = Value
        self.Min = Min
        self.Max = Max
    def factory(*args_, **kwargs_):
        if EntropyType.subclass:
            return EntropyType.subclass(*args_, **kwargs_)
        else:
            return EntropyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def validate_FloatObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.FloatObjectAttributeType, a restriction on None.
        pass
    def get_Min(self): return self.Min
    def set_Min(self, Min): self.Min = Min
    def get_Max(self): return self.Max
    def set_Max(self, Max): self.Max = Max
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='EntropyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntropyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='EntropyType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='EntropyType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            self.Value.export(outfile, level, 'WinExecutableFileObj:', name_='Value', pretty_print=pretty_print)
        if self.Min is not None:
            self.Min.export(outfile, level, 'WinExecutableFileObj:', name_='Min', pretty_print=pretty_print)
        if self.Max is not None:
            self.Max.export(outfile, level, 'WinExecutableFileObj:', name_='Max', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Value is not None or
            self.Min is not None or
            self.Max is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EntropyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=model_.cybox_common_types_1_0.FloatObjectAttributeType(\n')
            self.Value.exportLiteral(outfile, level, name_='Value')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Min is not None:
            showIndent(outfile, level)
            outfile.write('Min=model_.cybox_common_types_1_0.FloatObjectAttributeType(\n')
            self.Min.exportLiteral(outfile, level, name_='Min')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Max is not None:
            showIndent(outfile, level)
            outfile.write('Max=model_.cybox_common_types_1_0.FloatObjectAttributeType(\n')
            self.Max.exportLiteral(outfile, level, name_='Max')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            obj_ = cybox_common_types_1_0.FloatObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Value(obj_)
        elif nodeName_ == 'Min':
            obj_ = cybox_common_types_1_0.FloatObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Min(obj_)
        elif nodeName_ == 'Max':
            obj_ = cybox_common_types_1_0.FloatObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Max(obj_)
# end class EntropyType

class PEStringType(GeneratedsSuper):
    """The PEStringType type is intended as container for strings extracted
    from PE binaries."""
    subclass = None
    superclass = None
    def __init__(self, Encoding=None, Address=None, Hashes=None, Language=None, Length=None, String_Value=None, Translation=None):
        self.Encoding = Encoding
        self.Address = Address
        self.Hashes = Hashes
        self.Language = Language
        self.Length = Length
        self.String_Value = String_Value
        self.Translation = Translation
    def factory(*args_, **kwargs_):
        if PEStringType.subclass:
            return PEStringType.subclass(*args_, **kwargs_)
        else:
            return PEStringType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Encoding(self): return self.Encoding
    def set_Encoding(self, Encoding): self.Encoding = Encoding
    def validate_CharacterEncodingEnum(self, value):
        # Validate type CharacterEncodingEnum, a restriction on xs:string.
        pass
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Language(self): return self.Language
    def set_Language(self, Language): self.Language = Language
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Length(self): return self.Length
    def set_Length(self, Length): self.Length = Length
    def validate_PositiveIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.PositiveIntegerObjectAttributeType, a restriction on None.
        pass
    def get_String_Value(self): return self.String_Value
    def set_String_Value(self, String_Value): self.String_Value = String_Value
    def get_Translation(self): return self.Translation
    def set_Translation(self, Translation): self.Translation = Translation
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEStringType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEStringType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEStringType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEStringType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Encoding is not None:
            self.Encoding.export(outfile, level, 'WinExecutableFileObj:', name_='Encoding', pretty_print=pretty_print)
        if self.Address is not None:
            self.Address.export(outfile, level, 'WinExecutableFileObj:', name_='Address', pretty_print=pretty_print)
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, 'WinExecutableFileObj:', name_='Hashes', pretty_print=pretty_print)
        if self.Language is not None:
            self.Language.export(outfile, level, 'WinExecutableFileObj:', name_='Language', pretty_print=pretty_print)
        if self.Length is not None:
            self.Length.export(outfile, level, 'WinExecutableFileObj:', name_='Length', pretty_print=pretty_print)
        if self.String_Value is not None:
            self.String_Value.export(outfile, level, 'WinExecutableFileObj:', name_='String_Value', pretty_print=pretty_print)
        if self.Translation is not None:
            self.Translation.export(outfile, level, 'WinExecutableFileObj:', name_='Translation', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Encoding is not None or
            self.Address is not None or
            self.Hashes is not None or
            self.Language is not None or
            self.Length is not None or
            self.String_Value is not None or
            self.Translation is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEStringType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Encoding is not None:
            showIndent(outfile, level)
            outfile.write('Encoding=%s,\n' % quote_python(self.Encoding).encode(ExternalEncoding))
        if self.Address is not None:
            showIndent(outfile, level)
            outfile.write('Address=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Address.exportLiteral(outfile, level, name_='Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.cybox_common_types_1_0.HashListType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Language is not None:
            showIndent(outfile, level)
            outfile.write('Language=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Language.exportLiteral(outfile, level, name_='Language')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Length is not None:
            showIndent(outfile, level)
            outfile.write('Length=model_.cybox_common_types_1_0.PositiveIntegerObjectAttributeType(\n')
            self.Length.exportLiteral(outfile, level, name_='Length')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.String_Value is not None:
            showIndent(outfile, level)
            outfile.write('String_Value=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.String_Value.exportLiteral(outfile, level, name_='String_Value')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Translation is not None:
            showIndent(outfile, level)
            outfile.write('Translation=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Translation.exportLiteral(outfile, level, name_='Translation')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Encoding':
            obj_ = CharacterEncodingEnum.factory()
            obj_.build(child_)
            self.set_Encoding(obj_)
        elif nodeName_ == 'Address':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Address(obj_)
        elif nodeName_ == 'Hashes':
            obj_ = cybox_common_types_1_0.HashListType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'Language':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Language(obj_)
        elif nodeName_ == 'Length':
            obj_ = cybox_common_types_1_0.PositiveIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Length(obj_)
        elif nodeName_ == 'String_Value':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_String_Value(obj_)
        elif nodeName_ == 'Translation':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Translation(obj_)
# end class PEStringType

class PEImportType(GeneratedsSuper):
    """The PEImportType type is intended as container for the attributes
    relevant to PE binary imports.The delay_load attribute is a
    boolean value that is intended to describe whether a PE binary
    import is delay-load or not.The initially_visible attribute
    refers to whether the import is initially visible, with regards
    to being initially visible or hidden in relation to PE binary
    packing. A packed binary will typically have few initially
    visible imports, and thus it is necessary to make the
    distinction between those that are visible initially or only
    after the binary is unpacked."""
    subclass = None
    superclass = None
    def __init__(self, initially_visible=None, delay_load=None, File_Name=None, Imported_Functions=None, Virtual_Address=None):
        self.initially_visible = _cast(bool, initially_visible)
        self.delay_load = _cast(bool, delay_load)
        self.File_Name = File_Name
        self.Imported_Functions = Imported_Functions
        self.Virtual_Address = Virtual_Address
    def factory(*args_, **kwargs_):
        if PEImportType.subclass:
            return PEImportType.subclass(*args_, **kwargs_)
        else:
            return PEImportType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File_Name(self): return self.File_Name
    def set_File_Name(self, File_Name): self.File_Name = File_Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Imported_Functions(self): return self.Imported_Functions
    def set_Imported_Functions(self, Imported_Functions): self.Imported_Functions = Imported_Functions
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_initially_visible(self): return self.initially_visible
    def set_initially_visible(self, initially_visible): self.initially_visible = initially_visible
    def get_delay_load(self): return self.delay_load
    def set_delay_load(self, delay_load): self.delay_load = delay_load
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEImportType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEImportType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEImportType'):
        if self.initially_visible is not None and 'initially_visible' not in already_processed:
            already_processed.append('initially_visible')
            outfile.write(' initially_visible="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.initially_visible)), input_name='initially_visible'))
        if self.delay_load is not None and 'delay_load' not in already_processed:
            already_processed.append('delay_load')
            outfile.write(' delay_load="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.delay_load)), input_name='delay_load'))
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEImportType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.File_Name is not None:
            self.File_Name.export(outfile, level, 'WinExecutableFileObj:', name_='File_Name', pretty_print=pretty_print)
        if self.Imported_Functions is not None:
            self.Imported_Functions.export(outfile, level, 'WinExecutableFileObj:', name_='Imported_Functions', pretty_print=pretty_print)
        if self.Virtual_Address is not None:
            self.Virtual_Address.export(outfile, level, 'WinExecutableFileObj:', name_='Virtual_Address', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.File_Name is not None or
            self.Imported_Functions is not None or
            self.Virtual_Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEImportType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.initially_visible is not None and 'initially_visible' not in already_processed:
            already_processed.append('initially_visible')
            showIndent(outfile, level)
            outfile.write('initially_visible = %s,\n' % (self.initially_visible,))
        if self.delay_load is not None and 'delay_load' not in already_processed:
            already_processed.append('delay_load')
            showIndent(outfile, level)
            outfile.write('delay_load = %s,\n' % (self.delay_load,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.File_Name is not None:
            showIndent(outfile, level)
            outfile.write('File_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.File_Name.exportLiteral(outfile, level, name_='File_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Imported_Functions is not None:
            showIndent(outfile, level)
            outfile.write('Imported_Functions=model_.PEImportedFunctionsType(\n')
            self.Imported_Functions.exportLiteral(outfile, level, name_='Imported_Functions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Virtual_Address.exportLiteral(outfile, level, name_='Virtual_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('initially_visible', node)
        if value is not None and 'initially_visible' not in already_processed:
            already_processed.append('initially_visible')
            if value in ('true', '1'):
                self.initially_visible = True
            elif value in ('false', '0'):
                self.initially_visible = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('delay_load', node)
        if value is not None and 'delay_load' not in already_processed:
            already_processed.append('delay_load')
            if value in ('true', '1'):
                self.delay_load = True
            elif value in ('false', '0'):
                self.delay_load = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_File_Name(obj_)
        elif nodeName_ == 'Imported_Functions':
            obj_ = PEImportedFunctionsType.factory()
            obj_.build(child_)
            self.set_Imported_Functions(obj_)
        elif nodeName_ == 'Virtual_Address':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Virtual_Address(obj_)
# end class PEImportType

class PEImportedFunctionsType(GeneratedsSuper):
    """A list of PE imported functions"""
    subclass = None
    superclass = None
    def __init__(self, Imported_Function=None):
        if Imported_Function is None:
            self.Imported_Function = []
        else:
            self.Imported_Function = Imported_Function
    def factory(*args_, **kwargs_):
        if PEImportedFunctionsType.subclass:
            return PEImportedFunctionsType.subclass(*args_, **kwargs_)
        else:
            return PEImportedFunctionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Imported_Function(self): return self.Imported_Function
    def set_Imported_Function(self, Imported_Function): self.Imported_Function = Imported_Function
    def add_Imported_Function(self, value): self.Imported_Function.append(value)
    def insert_Imported_Function(self, index, value): self.Imported_Function[index] = value
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEImportedFunctionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEImportedFunctionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEImportedFunctionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEImportedFunctionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Imported_Function_ in self.Imported_Function:
            Imported_Function_.export(outfile, level, 'WinExecutableFileObj:', name_='Imported_Function', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Imported_Function
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEImportedFunctionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Imported_Function=[\n')
        level += 1
        for Imported_Function_ in self.Imported_Function:
            showIndent(outfile, level)
            outfile.write('model_.PEImportedFunctionType(\n')
            Imported_Function_.exportLiteral(outfile, level, name_='PEImportedFunctionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Imported_Function':
            obj_ = PEImportedFunctionType.factory()
            obj_.build(child_)
            self.Imported_Function.append(obj_)
# end class PEImportedFunctionsType

class PEResourceType(GeneratedsSuper):
    """The PEResourceType type is intended as container for the attributes
    relevant to PE binary resources."""
    subclass = None
    superclass = None
    def __init__(self, Type=None, Name=None, Hashes=None, extensiontype_=None):
        self.Type = Type
        self.Name = Name
        self.Hashes = Hashes
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if PEResourceType.subclass:
            return PEResourceType.subclass(*args_, **kwargs_)
        else:
            return PEResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_PEResourceTypeEnum(self, value):
        # Validate type PEResourceTypeEnum, a restriction on xs:string.
        pass
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEResourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEResourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEResourceType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEResourceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Type is not None:
            self.Type.export(outfile, level, 'WinExecutableFileObj:', name_='Type', pretty_print=pretty_print)
        if self.Name is not None:
            self.Name.export(outfile, level, 'WinExecutableFileObj:', name_='Name', pretty_print=pretty_print)
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, 'WinExecutableFileObj:', name_='Hashes', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Type is not None or
            self.Name is not None or
            self.Hashes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEResourceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Type is not None:
            showIndent(outfile, level)
            outfile.write('Type=%s,\n' % quote_python(self.Type).encode(ExternalEncoding))
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.cybox_common_types_1_0.HashListType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            obj_ = PEType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
        elif nodeName_ == 'Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Hashes':
            obj_ = cybox_common_types_1_0.HashListType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
# end class PEResourceType

class PEVersionInfoResourceType(PEResourceType):
    """The PEVersionInfoResourceType characterizes the special VERSIONINFO
    resource type. For more information please see:
    http://msdn.microsoft.com/en-
    us/library/windows/desktop/aa381058(v=vs.85).aspx"""
    subclass = None
    superclass = PEResourceType
    def __init__(self, Type=None, Name=None, Hashes=None, Comments=None, CompanyName=None, FileDescription=None, FileVersion=None, InternalName=None, LegalCopyright=None, LegalTrademarks=None, OriginalFilename=None, PrivateBuild=None, ProductName=None, ProductVersion=None, SpecialBuild=None):
        super(PEVersionInfoResourceType, self).__init__(Type, Name, Hashes, )
        self.Comments = Comments
        self.CompanyName = CompanyName
        self.FileDescription = FileDescription
        self.FileVersion = FileVersion
        self.InternalName = InternalName
        self.LegalCopyright = LegalCopyright
        self.LegalTrademarks = LegalTrademarks
        self.OriginalFilename = OriginalFilename
        self.PrivateBuild = PrivateBuild
        self.ProductName = ProductName
        self.ProductVersion = ProductVersion
        self.SpecialBuild = SpecialBuild
    def factory(*args_, **kwargs_):
        if PEVersionInfoResourceType.subclass:
            return PEVersionInfoResourceType.subclass(*args_, **kwargs_)
        else:
            return PEVersionInfoResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Comments(self): return self.Comments
    def set_Comments(self, Comments): self.Comments = Comments
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_CompanyName(self): return self.CompanyName
    def set_CompanyName(self, CompanyName): self.CompanyName = CompanyName
    def get_FileDescription(self): return self.FileDescription
    def set_FileDescription(self, FileDescription): self.FileDescription = FileDescription
    def get_FileVersion(self): return self.FileVersion
    def set_FileVersion(self, FileVersion): self.FileVersion = FileVersion
    def get_InternalName(self): return self.InternalName
    def set_InternalName(self, InternalName): self.InternalName = InternalName
    def get_LegalCopyright(self): return self.LegalCopyright
    def set_LegalCopyright(self, LegalCopyright): self.LegalCopyright = LegalCopyright
    def get_LegalTrademarks(self): return self.LegalTrademarks
    def set_LegalTrademarks(self, LegalTrademarks): self.LegalTrademarks = LegalTrademarks
    def get_OriginalFilename(self): return self.OriginalFilename
    def set_OriginalFilename(self, OriginalFilename): self.OriginalFilename = OriginalFilename
    def get_PrivateBuild(self): return self.PrivateBuild
    def set_PrivateBuild(self, PrivateBuild): self.PrivateBuild = PrivateBuild
    def get_ProductName(self): return self.ProductName
    def set_ProductName(self, ProductName): self.ProductName = ProductName
    def get_ProductVersion(self): return self.ProductVersion
    def set_ProductVersion(self, ProductVersion): self.ProductVersion = ProductVersion
    def get_SpecialBuild(self): return self.SpecialBuild
    def set_SpecialBuild(self, SpecialBuild): self.SpecialBuild = SpecialBuild
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEVersionInfoResourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEVersionInfoResourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEVersionInfoResourceType'):
        super(PEVersionInfoResourceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PEVersionInfoResourceType')
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEVersionInfoResourceType', fromsubclass_=False, pretty_print=True):
        super(PEVersionInfoResourceType, self).exportChildren(outfile, level, 'WinExecutableFileObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Comments is not None:
            self.Comments.export(outfile, level, 'WinExecutableFileObj:', name_='Comments', pretty_print=pretty_print)
        if self.CompanyName is not None:
            self.CompanyName.export(outfile, level, 'WinExecutableFileObj:', name_='CompanyName', pretty_print=pretty_print)
        if self.FileDescription is not None:
            self.FileDescription.export(outfile, level, 'WinExecutableFileObj:', name_='FileDescription', pretty_print=pretty_print)
        if self.FileVersion is not None:
            self.FileVersion.export(outfile, level, 'WinExecutableFileObj:', name_='FileVersion', pretty_print=pretty_print)
        if self.InternalName is not None:
            self.InternalName.export(outfile, level, 'WinExecutableFileObj:', name_='InternalName', pretty_print=pretty_print)
        if self.LegalCopyright is not None:
            self.LegalCopyright.export(outfile, level, 'WinExecutableFileObj:', name_='LegalCopyright', pretty_print=pretty_print)
        if self.LegalTrademarks is not None:
            self.LegalTrademarks.export(outfile, level, 'WinExecutableFileObj:', name_='LegalTrademarks', pretty_print=pretty_print)
        if self.OriginalFilename is not None:
            self.OriginalFilename.export(outfile, level, 'WinExecutableFileObj:', name_='OriginalFilename', pretty_print=pretty_print)
        if self.PrivateBuild is not None:
            self.PrivateBuild.export(outfile, level, 'WinExecutableFileObj:', name_='PrivateBuild', pretty_print=pretty_print)
        if self.ProductName is not None:
            self.ProductName.export(outfile, level, 'WinExecutableFileObj:', name_='ProductName', pretty_print=pretty_print)
        if self.ProductVersion is not None:
            self.ProductVersion.export(outfile, level, 'WinExecutableFileObj:', name_='ProductVersion', pretty_print=pretty_print)
        if self.SpecialBuild is not None:
            self.SpecialBuild.export(outfile, level, 'WinExecutableFileObj:', name_='SpecialBuild', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Comments is not None or
            self.CompanyName is not None or
            self.FileDescription is not None or
            self.FileVersion is not None or
            self.InternalName is not None or
            self.LegalCopyright is not None or
            self.LegalTrademarks is not None or
            self.OriginalFilename is not None or
            self.PrivateBuild is not None or
            self.ProductName is not None or
            self.ProductVersion is not None or
            self.SpecialBuild is not None or
            super(PEVersionInfoResourceType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEVersionInfoResourceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(PEVersionInfoResourceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(PEVersionInfoResourceType, self).exportLiteralChildren(outfile, level, name_)
        if self.Comments is not None:
            showIndent(outfile, level)
            outfile.write('Comments=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Comments.exportLiteral(outfile, level, name_='Comments')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.CompanyName is not None:
            showIndent(outfile, level)
            outfile.write('CompanyName=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.CompanyName.exportLiteral(outfile, level, name_='CompanyName')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FileDescription is not None:
            showIndent(outfile, level)
            outfile.write('FileDescription=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.FileDescription.exportLiteral(outfile, level, name_='FileDescription')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FileVersion is not None:
            showIndent(outfile, level)
            outfile.write('FileVersion=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.FileVersion.exportLiteral(outfile, level, name_='FileVersion')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.InternalName is not None:
            showIndent(outfile, level)
            outfile.write('InternalName=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.InternalName.exportLiteral(outfile, level, name_='InternalName')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.LegalCopyright is not None:
            showIndent(outfile, level)
            outfile.write('LegalCopyright=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.LegalCopyright.exportLiteral(outfile, level, name_='LegalCopyright')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.LegalTrademarks is not None:
            showIndent(outfile, level)
            outfile.write('LegalTrademarks=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.LegalTrademarks.exportLiteral(outfile, level, name_='LegalTrademarks')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.OriginalFilename is not None:
            showIndent(outfile, level)
            outfile.write('OriginalFilename=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.OriginalFilename.exportLiteral(outfile, level, name_='OriginalFilename')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PrivateBuild is not None:
            showIndent(outfile, level)
            outfile.write('PrivateBuild=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.PrivateBuild.exportLiteral(outfile, level, name_='PrivateBuild')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ProductName is not None:
            showIndent(outfile, level)
            outfile.write('ProductName=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.ProductName.exportLiteral(outfile, level, name_='ProductName')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ProductVersion is not None:
            showIndent(outfile, level)
            outfile.write('ProductVersion=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.ProductVersion.exportLiteral(outfile, level, name_='ProductVersion')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SpecialBuild is not None:
            showIndent(outfile, level)
            outfile.write('SpecialBuild=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.SpecialBuild.exportLiteral(outfile, level, name_='SpecialBuild')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(PEVersionInfoResourceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Comments':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Comments(obj_)
        elif nodeName_ == 'CompanyName':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_CompanyName(obj_)
        elif nodeName_ == 'FileDescription':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_FileDescription(obj_)
        elif nodeName_ == 'FileVersion':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_FileVersion(obj_)
        elif nodeName_ == 'InternalName':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_InternalName(obj_)
        elif nodeName_ == 'LegalCopyright':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_LegalCopyright(obj_)
        elif nodeName_ == 'LegalTrademarks':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_LegalTrademarks(obj_)
        elif nodeName_ == 'OriginalFilename':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_OriginalFilename(obj_)
        elif nodeName_ == 'PrivateBuild':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_PrivateBuild(obj_)
        elif nodeName_ == 'ProductName':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_ProductName(obj_)
        elif nodeName_ == 'ProductVersion':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_ProductVersion(obj_)
        elif nodeName_ == 'SpecialBuild':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_SpecialBuild(obj_)
        super(PEVersionInfoResourceType, self).buildChildren(child_, node, nodeName_, True)
# end class PEVersionInfoResourceType

class PEExportedFunctionType(GeneratedsSuper):
    """PEExportType sepcifies the type describing exported functions."""
    subclass = None
    superclass = None
    def __init__(self, Function_Name=None, Entry_Point=None, Ordinal=None):
        self.Function_Name = Function_Name
        self.Entry_Point = Entry_Point
        self.Ordinal = Ordinal
    def factory(*args_, **kwargs_):
        if PEExportedFunctionType.subclass:
            return PEExportedFunctionType.subclass(*args_, **kwargs_)
        else:
            return PEExportedFunctionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Function_Name(self): return self.Function_Name
    def set_Function_Name(self, Function_Name): self.Function_Name = Function_Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Entry_Point(self): return self.Entry_Point
    def set_Entry_Point(self, Entry_Point): self.Entry_Point = Entry_Point
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Ordinal(self): return self.Ordinal
    def set_Ordinal(self, Ordinal): self.Ordinal = Ordinal
    def validate_NonNegativeIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEExportedFunctionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEExportedFunctionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEExportedFunctionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEExportedFunctionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Function_Name is not None:
            self.Function_Name.export(outfile, level, 'WinExecutableFileObj:', name_='Function_Name', pretty_print=pretty_print)
        if self.Entry_Point is not None:
            self.Entry_Point.export(outfile, level, 'WinExecutableFileObj:', name_='Entry_Point', pretty_print=pretty_print)
        if self.Ordinal is not None:
            self.Ordinal.export(outfile, level, 'WinExecutableFileObj:', name_='Ordinal', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Function_Name is not None or
            self.Entry_Point is not None or
            self.Ordinal is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEExportedFunctionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('Function_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Function_Name.exportLiteral(outfile, level, name_='Function_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Entry_Point is not None:
            showIndent(outfile, level)
            outfile.write('Entry_Point=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Entry_Point.exportLiteral(outfile, level, name_='Entry_Point')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Ordinal is not None:
            showIndent(outfile, level)
            outfile.write('Ordinal=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.Ordinal.exportLiteral(outfile, level, name_='Ordinal')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Function_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Function_Name(obj_)
        elif nodeName_ == 'Entry_Point':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Entry_Point(obj_)
        elif nodeName_ == 'Ordinal':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Ordinal(obj_)
# end class PEExportedFunctionType

class PEResourceListType(GeneratedsSuper):
    """PEResourceListType specifies a list of resources found in the PE
    file."""
    subclass = None
    superclass = None
    def __init__(self, Resource=None):
        if Resource is None:
            self.Resource = []
        else:
            self.Resource = Resource
    def factory(*args_, **kwargs_):
        if PEResourceListType.subclass:
            return PEResourceListType.subclass(*args_, **kwargs_)
        else:
            return PEResourceListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def add_Resource(self, value): self.Resource.append(value)
    def insert_Resource(self, index, value): self.Resource[index] = value
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEResourceListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEResourceListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEResourceListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEResourceListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Resource_ in self.Resource:
            Resource_.export(outfile, level, 'WinExecutableFileObj:', name_='Resource', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Resource
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEResourceListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Resource=[\n')
        level += 1
        for Resource_ in self.Resource:
            showIndent(outfile, level)
            outfile.write('model_.Resource(\n')
            Resource_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            obj_ = PEResourceType.factory()
            obj_.build(child_)
            self.set_Resource(obj_)
# end class PEResourceListType

class PEImportedFunctionType(GeneratedsSuper):
    """PEImportedFunctionType specifies the type describing imported
    functions."""
    subclass = None
    superclass = None
    def __init__(self, Function_Name=None, Hint=None, Ordinal=None, Bound=None, Virtual_Address=None):
        self.Function_Name = Function_Name
        self.Hint = Hint
        self.Ordinal = Ordinal
        self.Bound = Bound
        self.Virtual_Address = Virtual_Address
    def factory(*args_, **kwargs_):
        if PEImportedFunctionType.subclass:
            return PEImportedFunctionType.subclass(*args_, **kwargs_)
        else:
            return PEImportedFunctionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Function_Name(self): return self.Function_Name
    def set_Function_Name(self, Function_Name): self.Function_Name = Function_Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Hint(self): return self.Hint
    def set_Hint(self, Hint): self.Hint = Hint
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Ordinal(self): return self.Ordinal
    def set_Ordinal(self, Ordinal): self.Ordinal = Ordinal
    def validate_NonNegativeIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType, a restriction on None.
        pass
    def get_Bound(self): return self.Bound
    def set_Bound(self, Bound): self.Bound = Bound
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEImportedFunctionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEImportedFunctionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEImportedFunctionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEImportedFunctionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Function_Name is not None:
            self.Function_Name.export(outfile, level, 'WinExecutableFileObj:', name_='Function_Name', pretty_print=pretty_print)
        if self.Hint is not None:
            self.Hint.export(outfile, level, 'WinExecutableFileObj:', name_='Hint', pretty_print=pretty_print)
        if self.Ordinal is not None:
            self.Ordinal.export(outfile, level, 'WinExecutableFileObj:', name_='Ordinal', pretty_print=pretty_print)
        if self.Bound is not None:
            self.Bound.export(outfile, level, 'WinExecutableFileObj:', name_='Bound', pretty_print=pretty_print)
        if self.Virtual_Address is not None:
            self.Virtual_Address.export(outfile, level, 'WinExecutableFileObj:', name_='Virtual_Address', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Function_Name is not None or
            self.Hint is not None or
            self.Ordinal is not None or
            self.Bound is not None or
            self.Virtual_Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEImportedFunctionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('Function_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Function_Name.exportLiteral(outfile, level, name_='Function_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hint is not None:
            showIndent(outfile, level)
            outfile.write('Hint=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Hint.exportLiteral(outfile, level, name_='Hint')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Ordinal is not None:
            showIndent(outfile, level)
            outfile.write('Ordinal=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.Ordinal.exportLiteral(outfile, level, name_='Ordinal')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Bound is not None:
            showIndent(outfile, level)
            outfile.write('Bound=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Bound.exportLiteral(outfile, level, name_='Bound')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Virtual_Address.exportLiteral(outfile, level, name_='Virtual_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Function_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Function_Name(obj_)
        elif nodeName_ == 'Hint':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Hint(obj_)
        elif nodeName_ == 'Ordinal':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Ordinal(obj_)
        elif nodeName_ == 'Bound':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Bound(obj_)
        elif nodeName_ == 'Virtual_Address':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Virtual_Address(obj_)
# end class PEImportedFunctionType

class PEImportListType(GeneratedsSuper):
    """PEImportListType specifies a list of functions in an import data
    section."""
    subclass = None
    superclass = None
    def __init__(self, Import=None):
        if Import is None:
            self.Import = []
        else:
            self.Import = Import
    def factory(*args_, **kwargs_):
        if PEImportListType.subclass:
            return PEImportListType.subclass(*args_, **kwargs_)
        else:
            return PEImportListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Import(self): return self.Import
    def set_Import(self, Import): self.Import = Import
    def add_Import(self, value): self.Import.append(value)
    def insert_Import(self, index, value): self.Import[index] = value
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEImportListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEImportListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEImportListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEImportListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Import_ in self.Import:
            Import_.export(outfile, level, 'WinExecutableFileObj:', name_='Import', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Import
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEImportListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Import=[\n')
        level += 1
        for Import_ in self.Import:
            showIndent(outfile, level)
            outfile.write('model_.PEImportType(\n')
            Import_.exportLiteral(outfile, level, name_='PEImportType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Import':
            obj_ = PEImportType.factory()
            obj_.build(child_)
            self.Import.append(obj_)
# end class PEImportListType

class PESectionType(GeneratedsSuper):
    """The PESectionType type is intended as container for the attributes
    relevant to PE binary sections. A PE Section consists of a
    header and data. The PESectionType contains attributes that
    describe the Section Header and metadata computed about the
    section (e.g., hashes, entropy)."""
    subclass = None
    superclass = None
    def __init__(self, Section_Header=None, Data_Hashes=None, Entropy=None, Header_Hashes=None, Type=None):
        self.Section_Header = Section_Header
        self.Data_Hashes = Data_Hashes
        self.Entropy = Entropy
        self.Header_Hashes = Header_Hashes
        self.Type = Type
    def factory(*args_, **kwargs_):
        if PESectionType.subclass:
            return PESectionType.subclass(*args_, **kwargs_)
        else:
            return PESectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Section_Header(self): return self.Section_Header
    def set_Section_Header(self, Section_Header): self.Section_Header = Section_Header
    def get_Data_Hashes(self): return self.Data_Hashes
    def set_Data_Hashes(self, Data_Hashes): self.Data_Hashes = Data_Hashes
    def get_Entropy(self): return self.Entropy
    def set_Entropy(self, Entropy): self.Entropy = Entropy
    def get_Header_Hashes(self): return self.Header_Hashes
    def set_Header_Hashes(self, Header_Hashes): self.Header_Hashes = Header_Hashes
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_SectionType(self, value):
        # Validate type SectionType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PESectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PESectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PESectionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PESectionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Section_Header is not None:
            self.Section_Header.export(outfile, level, 'WinExecutableFileObj:', name_='Section_Header', pretty_print=pretty_print)
        if self.Data_Hashes is not None:
            self.Data_Hashes.export(outfile, level, 'WinExecutableFileObj:', name_='Data_Hashes', pretty_print=pretty_print)
        if self.Entropy is not None:
            self.Entropy.export(outfile, level, 'WinExecutableFileObj:', name_='Entropy', pretty_print=pretty_print)
        if self.Header_Hashes is not None:
            self.Header_Hashes.export(outfile, level, 'WinExecutableFileObj:', name_='Header_Hashes', pretty_print=pretty_print)
        if self.Type is not None:
            self.Type.export(outfile, level, 'WinExecutableFileObj:', name_='Type', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Section_Header is not None or
            self.Data_Hashes is not None or
            self.Entropy is not None or
            self.Header_Hashes is not None or
            self.Type is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PESectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Section_Header is not None:
            showIndent(outfile, level)
            outfile.write('Section_Header=model_.PESectionHeaderStructType(\n')
            self.Section_Header.exportLiteral(outfile, level, name_='Section_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Data_Hashes=model_.cybox_common_types_1_0.HashListType(\n')
            self.Data_Hashes.exportLiteral(outfile, level, name_='Data_Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Entropy is not None:
            showIndent(outfile, level)
            outfile.write('Entropy=model_.EntropyType(\n')
            self.Entropy.exportLiteral(outfile, level, name_='Entropy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Header_Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Header_Hashes=model_.cybox_common_types_1_0.HashListType(\n')
            self.Header_Hashes.exportLiteral(outfile, level, name_='Header_Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Type is not None:
            showIndent(outfile, level)
            outfile.write('Type=model_.SectionType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Section_Header':
            obj_ = PESectionHeaderStructType.factory()
            obj_.build(child_)
            self.set_Section_Header(obj_)
        elif nodeName_ == 'Data_Hashes':
            obj_ = cybox_common_types_1_0.HashListType.factory()
            obj_.build(child_)
            self.set_Data_Hashes(obj_)
        elif nodeName_ == 'Entropy':
            obj_ = EntropyType.factory()
            obj_.build(child_)
            self.set_Entropy(obj_)
        elif nodeName_ == 'Header_Hashes':
            obj_ = cybox_common_types_1_0.HashListType.factory()
            obj_.build(child_)
            self.set_Header_Hashes(obj_)
        elif nodeName_ == 'Type':
            obj_ = PEType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
# end class PESectionType

class PEDataDirectoryStructType(GeneratedsSuper):
    """The PEDataDirectoryStruct type is intended as container for the
    attributes present in a PE binary's data directory structure."""
    subclass = None
    superclass = None
    def __init__(self, Virtual_Address=None, Size=None):
        self.Virtual_Address = Virtual_Address
        self.Size = Size
    def factory(*args_, **kwargs_):
        if PEDataDirectoryStructType.subclass:
            return PEDataDirectoryStructType.subclass(*args_, **kwargs_)
        else:
            return PEDataDirectoryStructType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Size(self): return self.Size
    def set_Size(self, Size): self.Size = Size
    def validate_NonNegativeIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEDataDirectoryStructType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEDataDirectoryStructType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEDataDirectoryStructType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEDataDirectoryStructType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Virtual_Address is not None:
            self.Virtual_Address.export(outfile, level, 'WinExecutableFileObj:', name_='Virtual_Address', pretty_print=pretty_print)
        if self.Size is not None:
            self.Size.export(outfile, level, 'WinExecutableFileObj:', name_='Size', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Virtual_Address is not None or
            self.Size is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEDataDirectoryStructType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Virtual_Address.exportLiteral(outfile, level, name_='Virtual_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size is not None:
            showIndent(outfile, level)
            outfile.write('Size=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.Size.exportLiteral(outfile, level, name_='Size')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Virtual_Address':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Virtual_Address(obj_)
        elif nodeName_ == 'Size':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size(obj_)
# end class PEDataDirectoryStructType

class PESectionHeaderStructType(GeneratedsSuper):
    """The PESectionHeaderStruct type is intended as container for the
    attributes present in a PE binary's section header structure."""
    subclass = None
    superclass = None
    def __init__(self, Name=None, Physical_Address=None, Virtual_Address=None, Size_Of_Raw_Data=None, Pointer_To_Raw_Data=None, Pointer_To_Relocations=None, Pointer_To_Linenumbers=None, Number_Of_Relocations=None, Number_Of_Linenumbers=None, Characteristics=None):
        self.Name = Name
        self.Physical_Address = Physical_Address
        self.Virtual_Address = Virtual_Address
        self.Size_Of_Raw_Data = Size_Of_Raw_Data
        self.Pointer_To_Raw_Data = Pointer_To_Raw_Data
        self.Pointer_To_Relocations = Pointer_To_Relocations
        self.Pointer_To_Linenumbers = Pointer_To_Linenumbers
        self.Number_Of_Relocations = Number_Of_Relocations
        self.Number_Of_Linenumbers = Number_Of_Linenumbers
        self.Characteristics = Characteristics
    def factory(*args_, **kwargs_):
        if PESectionHeaderStructType.subclass:
            return PESectionHeaderStructType.subclass(*args_, **kwargs_)
        else:
            return PESectionHeaderStructType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Physical_Address(self): return self.Physical_Address
    def set_Physical_Address(self, Physical_Address): self.Physical_Address = Physical_Address
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Size_Of_Raw_Data(self): return self.Size_Of_Raw_Data
    def set_Size_Of_Raw_Data(self, Size_Of_Raw_Data): self.Size_Of_Raw_Data = Size_Of_Raw_Data
    def get_Pointer_To_Raw_Data(self): return self.Pointer_To_Raw_Data
    def set_Pointer_To_Raw_Data(self, Pointer_To_Raw_Data): self.Pointer_To_Raw_Data = Pointer_To_Raw_Data
    def get_Pointer_To_Relocations(self): return self.Pointer_To_Relocations
    def set_Pointer_To_Relocations(self, Pointer_To_Relocations): self.Pointer_To_Relocations = Pointer_To_Relocations
    def get_Pointer_To_Linenumbers(self): return self.Pointer_To_Linenumbers
    def set_Pointer_To_Linenumbers(self, Pointer_To_Linenumbers): self.Pointer_To_Linenumbers = Pointer_To_Linenumbers
    def get_Number_Of_Relocations(self): return self.Number_Of_Relocations
    def set_Number_Of_Relocations(self, Number_Of_Relocations): self.Number_Of_Relocations = Number_Of_Relocations
    def validate_NonNegativeIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType, a restriction on None.
        pass
    def get_Number_Of_Linenumbers(self): return self.Number_Of_Linenumbers
    def set_Number_Of_Linenumbers(self, Number_Of_Linenumbers): self.Number_Of_Linenumbers = Number_Of_Linenumbers
    def get_Characteristics(self): return self.Characteristics
    def set_Characteristics(self, Characteristics): self.Characteristics = Characteristics
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PESectionHeaderStructType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PESectionHeaderStructType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PESectionHeaderStructType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PESectionHeaderStructType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            self.Name.export(outfile, level, 'WinExecutableFileObj:', name_='Name', pretty_print=pretty_print)
        if self.Physical_Address is not None:
            self.Physical_Address.export(outfile, level, 'WinExecutableFileObj:', name_='Physical_Address', pretty_print=pretty_print)
        if self.Virtual_Address is not None:
            self.Virtual_Address.export(outfile, level, 'WinExecutableFileObj:', name_='Virtual_Address', pretty_print=pretty_print)
        if self.Size_Of_Raw_Data is not None:
            self.Size_Of_Raw_Data.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Raw_Data', pretty_print=pretty_print)
        if self.Pointer_To_Raw_Data is not None:
            self.Pointer_To_Raw_Data.export(outfile, level, 'WinExecutableFileObj:', name_='Pointer_To_Raw_Data', pretty_print=pretty_print)
        if self.Pointer_To_Relocations is not None:
            self.Pointer_To_Relocations.export(outfile, level, 'WinExecutableFileObj:', name_='Pointer_To_Relocations', pretty_print=pretty_print)
        if self.Pointer_To_Linenumbers is not None:
            self.Pointer_To_Linenumbers.export(outfile, level, 'WinExecutableFileObj:', name_='Pointer_To_Linenumbers', pretty_print=pretty_print)
        if self.Number_Of_Relocations is not None:
            self.Number_Of_Relocations.export(outfile, level, 'WinExecutableFileObj:', name_='Number_Of_Relocations', pretty_print=pretty_print)
        if self.Number_Of_Linenumbers is not None:
            self.Number_Of_Linenumbers.export(outfile, level, 'WinExecutableFileObj:', name_='Number_Of_Linenumbers', pretty_print=pretty_print)
        if self.Characteristics is not None:
            self.Characteristics.export(outfile, level, 'WinExecutableFileObj:', name_='Characteristics', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Physical_Address is not None or
            self.Virtual_Address is not None or
            self.Size_Of_Raw_Data is not None or
            self.Pointer_To_Raw_Data is not None or
            self.Pointer_To_Relocations is not None or
            self.Pointer_To_Linenumbers is not None or
            self.Number_Of_Relocations is not None or
            self.Number_Of_Linenumbers is not None or
            self.Characteristics is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PESectionHeaderStructType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Physical_Address is not None:
            showIndent(outfile, level)
            outfile.write('Physical_Address=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Physical_Address.exportLiteral(outfile, level, name_='Physical_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Virtual_Address.exportLiteral(outfile, level, name_='Virtual_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Raw_Data is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Raw_Data=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Raw_Data.exportLiteral(outfile, level, name_='Size_Of_Raw_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pointer_To_Raw_Data is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Raw_Data=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Pointer_To_Raw_Data.exportLiteral(outfile, level, name_='Pointer_To_Raw_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pointer_To_Relocations is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Relocations=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Pointer_To_Relocations.exportLiteral(outfile, level, name_='Pointer_To_Relocations')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pointer_To_Linenumbers is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Linenumbers=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Pointer_To_Linenumbers.exportLiteral(outfile, level, name_='Pointer_To_Linenumbers')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Relocations is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Relocations=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.Number_Of_Relocations.exportLiteral(outfile, level, name_='Number_Of_Relocations')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Linenumbers is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Linenumbers=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.Number_Of_Linenumbers.exportLiteral(outfile, level, name_='Number_Of_Linenumbers')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('Characteristics=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Characteristics.exportLiteral(outfile, level, name_='Characteristics')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Physical_Address':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Physical_Address(obj_)
        elif nodeName_ == 'Virtual_Address':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Virtual_Address(obj_)
        elif nodeName_ == 'Size_Of_Raw_Data':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Raw_Data(obj_)
        elif nodeName_ == 'Pointer_To_Raw_Data':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Pointer_To_Raw_Data(obj_)
        elif nodeName_ == 'Pointer_To_Relocations':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Pointer_To_Relocations(obj_)
        elif nodeName_ == 'Pointer_To_Linenumbers':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Pointer_To_Linenumbers(obj_)
        elif nodeName_ == 'Number_Of_Relocations':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Number_Of_Relocations(obj_)
        elif nodeName_ == 'Number_Of_Linenumbers':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Number_Of_Linenumbers(obj_)
        elif nodeName_ == 'Characteristics':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Characteristics(obj_)
# end class PESectionHeaderStructType

class DOSHeaderType(GeneratedsSuper):
    """The DOSHeaderType type is a container for the attributes present in
    the _IMAGE_DOS_HEADER structure, which can be found in Winnt.h
    and pe.h. See http://www.csn.ul.ie/~caolan/pub/winresdump/winres
    dump/doc/pefile.html for more information about the winnt.h
    file, and http://www.tavi.co.uk/phobos/exeformat.html for even
    more clarification."""
    subclass = None
    superclass = None
    def __init__(self, e_magic=None, e_cblp=None, e_cp=None, e_crlc=None, e_cparhdr=None, e_minalloc=None, e_maxalloc=None, e_ss=None, e_sp=None, e_csum=None, e_ip=None, e_cs=None, e_lfarlc=None, e_ovro=None, reserved1=None, e_oemid=None, e_oeminfo=None, reserved2=None, e_lfanew=None, Hashes=None):
        self.e_magic = e_magic
        self.e_cblp = e_cblp
        self.e_cp = e_cp
        self.e_crlc = e_crlc
        self.e_cparhdr = e_cparhdr
        self.e_minalloc = e_minalloc
        self.e_maxalloc = e_maxalloc
        self.e_ss = e_ss
        self.e_sp = e_sp
        self.e_csum = e_csum
        self.e_ip = e_ip
        self.e_cs = e_cs
        self.e_lfarlc = e_lfarlc
        self.e_ovro = e_ovro
        if reserved1 is None:
            self.reserved1 = []
        else:
            self.reserved1 = reserved1
        self.e_oemid = e_oemid
        self.e_oeminfo = e_oeminfo
        self.reserved2 = reserved2
        self.e_lfanew = e_lfanew
        self.Hashes = Hashes
    def factory(*args_, **kwargs_):
        if DOSHeaderType.subclass:
            return DOSHeaderType.subclass(*args_, **kwargs_)
        else:
            return DOSHeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_e_magic(self): return self.e_magic
    def set_e_magic(self, e_magic): self.e_magic = e_magic
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_e_cblp(self): return self.e_cblp
    def set_e_cblp(self, e_cblp): self.e_cblp = e_cblp
    def get_e_cp(self): return self.e_cp
    def set_e_cp(self, e_cp): self.e_cp = e_cp
    def get_e_crlc(self): return self.e_crlc
    def set_e_crlc(self, e_crlc): self.e_crlc = e_crlc
    def get_e_cparhdr(self): return self.e_cparhdr
    def set_e_cparhdr(self, e_cparhdr): self.e_cparhdr = e_cparhdr
    def get_e_minalloc(self): return self.e_minalloc
    def set_e_minalloc(self, e_minalloc): self.e_minalloc = e_minalloc
    def get_e_maxalloc(self): return self.e_maxalloc
    def set_e_maxalloc(self, e_maxalloc): self.e_maxalloc = e_maxalloc
    def get_e_ss(self): return self.e_ss
    def set_e_ss(self, e_ss): self.e_ss = e_ss
    def get_e_sp(self): return self.e_sp
    def set_e_sp(self, e_sp): self.e_sp = e_sp
    def get_e_csum(self): return self.e_csum
    def set_e_csum(self, e_csum): self.e_csum = e_csum
    def get_e_ip(self): return self.e_ip
    def set_e_ip(self, e_ip): self.e_ip = e_ip
    def get_e_cs(self): return self.e_cs
    def set_e_cs(self, e_cs): self.e_cs = e_cs
    def get_e_lfarlc(self): return self.e_lfarlc
    def set_e_lfarlc(self, e_lfarlc): self.e_lfarlc = e_lfarlc
    def get_e_ovro(self): return self.e_ovro
    def set_e_ovro(self, e_ovro): self.e_ovro = e_ovro
    def get_reserved1(self): return self.reserved1
    def set_reserved1(self, reserved1): self.reserved1 = reserved1
    def add_reserved1(self, value): self.reserved1.append(value)
    def insert_reserved1(self, index, value): self.reserved1[index] = value
    def get_e_oemid(self): return self.e_oemid
    def set_e_oemid(self, e_oemid): self.e_oemid = e_oemid
    def get_e_oeminfo(self): return self.e_oeminfo
    def set_e_oeminfo(self, e_oeminfo): self.e_oeminfo = e_oeminfo
    def get_reserved2(self): return self.reserved2
    def set_reserved2(self, reserved2): self.reserved2 = reserved2
    def get_e_lfanew(self): return self.e_lfanew
    def set_e_lfanew(self, e_lfanew): self.e_lfanew = e_lfanew
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='DOSHeaderType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DOSHeaderType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='DOSHeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='DOSHeaderType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.e_magic is not None:
            self.e_magic.export(outfile, level, 'WinExecutableFileObj:', name_='e_magic', pretty_print=pretty_print)
        if self.e_cblp is not None:
            self.e_cblp.export(outfile, level, 'WinExecutableFileObj:', name_='e_cblp', pretty_print=pretty_print)
        if self.e_cp is not None:
            self.e_cp.export(outfile, level, 'WinExecutableFileObj:', name_='e_cp', pretty_print=pretty_print)
        if self.e_crlc is not None:
            self.e_crlc.export(outfile, level, 'WinExecutableFileObj:', name_='e_crlc', pretty_print=pretty_print)
        if self.e_cparhdr is not None:
            self.e_cparhdr.export(outfile, level, 'WinExecutableFileObj:', name_='e_cparhdr', pretty_print=pretty_print)
        if self.e_minalloc is not None:
            self.e_minalloc.export(outfile, level, 'WinExecutableFileObj:', name_='e_minalloc', pretty_print=pretty_print)
        if self.e_maxalloc is not None:
            self.e_maxalloc.export(outfile, level, 'WinExecutableFileObj:', name_='e_maxalloc', pretty_print=pretty_print)
        if self.e_ss is not None:
            self.e_ss.export(outfile, level, 'WinExecutableFileObj:', name_='e_ss', pretty_print=pretty_print)
        if self.e_sp is not None:
            self.e_sp.export(outfile, level, 'WinExecutableFileObj:', name_='e_sp', pretty_print=pretty_print)
        if self.e_csum is not None:
            self.e_csum.export(outfile, level, 'WinExecutableFileObj:', name_='e_csum', pretty_print=pretty_print)
        if self.e_ip is not None:
            self.e_ip.export(outfile, level, 'WinExecutableFileObj:', name_='e_ip', pretty_print=pretty_print)
        if self.e_cs is not None:
            self.e_cs.export(outfile, level, 'WinExecutableFileObj:', name_='e_cs', pretty_print=pretty_print)
        if self.e_lfarlc is not None:
            self.e_lfarlc.export(outfile, level, 'WinExecutableFileObj:', name_='e_lfarlc', pretty_print=pretty_print)
        if self.e_ovro is not None:
            self.e_ovro.export(outfile, level, 'WinExecutableFileObj:', name_='e_ovro', pretty_print=pretty_print)
        for reserved1_ in self.reserved1:
            reserved1_.export(outfile, level, 'WinExecutableFileObj:', name_='reserved1', pretty_print=pretty_print)
        if self.e_oemid is not None:
            self.e_oemid.export(outfile, level, 'WinExecutableFileObj:', name_='e_oemid', pretty_print=pretty_print)
        if self.e_oeminfo is not None:
            self.e_oeminfo.export(outfile, level, 'WinExecutableFileObj:', name_='e_oeminfo', pretty_print=pretty_print)
        if self.reserved2 is not None:
            self.reserved2.export(outfile, level, 'WinExecutableFileObj:', name_='reserved2', pretty_print=pretty_print)
        if self.e_lfanew is not None:
            self.e_lfanew.export(outfile, level, 'WinExecutableFileObj:', name_='e_lfanew', pretty_print=pretty_print)
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, 'WinExecutableFileObj:', name_='Hashes', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.e_magic is not None or
            self.e_cblp is not None or
            self.e_cp is not None or
            self.e_crlc is not None or
            self.e_cparhdr is not None or
            self.e_minalloc is not None or
            self.e_maxalloc is not None or
            self.e_ss is not None or
            self.e_sp is not None or
            self.e_csum is not None or
            self.e_ip is not None or
            self.e_cs is not None or
            self.e_lfarlc is not None or
            self.e_ovro is not None or
            self.reserved1 or
            self.e_oemid is not None or
            self.e_oeminfo is not None or
            self.reserved2 is not None or
            self.e_lfanew is not None or
            self.Hashes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DOSHeaderType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.e_magic is not None:
            showIndent(outfile, level)
            outfile.write('e_magic=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_magic.exportLiteral(outfile, level, name_='e_magic')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_cblp is not None:
            showIndent(outfile, level)
            outfile.write('e_cblp=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_cblp.exportLiteral(outfile, level, name_='e_cblp')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_cp is not None:
            showIndent(outfile, level)
            outfile.write('e_cp=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_cp.exportLiteral(outfile, level, name_='e_cp')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_crlc is not None:
            showIndent(outfile, level)
            outfile.write('e_crlc=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_crlc.exportLiteral(outfile, level, name_='e_crlc')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_cparhdr is not None:
            showIndent(outfile, level)
            outfile.write('e_cparhdr=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_cparhdr.exportLiteral(outfile, level, name_='e_cparhdr')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_minalloc is not None:
            showIndent(outfile, level)
            outfile.write('e_minalloc=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_minalloc.exportLiteral(outfile, level, name_='e_minalloc')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_maxalloc is not None:
            showIndent(outfile, level)
            outfile.write('e_maxalloc=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_maxalloc.exportLiteral(outfile, level, name_='e_maxalloc')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_ss is not None:
            showIndent(outfile, level)
            outfile.write('e_ss=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_ss.exportLiteral(outfile, level, name_='e_ss')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_sp is not None:
            showIndent(outfile, level)
            outfile.write('e_sp=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_sp.exportLiteral(outfile, level, name_='e_sp')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_csum is not None:
            showIndent(outfile, level)
            outfile.write('e_csum=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_csum.exportLiteral(outfile, level, name_='e_csum')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_ip is not None:
            showIndent(outfile, level)
            outfile.write('e_ip=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_ip.exportLiteral(outfile, level, name_='e_ip')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_cs is not None:
            showIndent(outfile, level)
            outfile.write('e_cs=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_cs.exportLiteral(outfile, level, name_='e_cs')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_lfarlc is not None:
            showIndent(outfile, level)
            outfile.write('e_lfarlc=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_lfarlc.exportLiteral(outfile, level, name_='e_lfarlc')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_ovro is not None:
            showIndent(outfile, level)
            outfile.write('e_ovro=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_ovro.exportLiteral(outfile, level, name_='e_ovro')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('reserved1=[\n')
        level += 1
        for reserved1_ in self.reserved1:
            showIndent(outfile, level)
            outfile.write('model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            reserved1_.exportLiteral(outfile, level, name_='cybox_common_types_1_0.HexBinaryObjectAttributeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.e_oemid is not None:
            showIndent(outfile, level)
            outfile.write('e_oemid=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_oemid.exportLiteral(outfile, level, name_='e_oemid')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_oeminfo is not None:
            showIndent(outfile, level)
            outfile.write('e_oeminfo=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_oeminfo.exportLiteral(outfile, level, name_='e_oeminfo')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.reserved2 is not None:
            showIndent(outfile, level)
            outfile.write('reserved2=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.reserved2.exportLiteral(outfile, level, name_='reserved2')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_lfanew is not None:
            showIndent(outfile, level)
            outfile.write('e_lfanew=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.e_lfanew.exportLiteral(outfile, level, name_='e_lfanew')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.cybox_common_types_1_0.HashListType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'e_magic':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_magic(obj_)
        elif nodeName_ == 'e_cblp':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_cblp(obj_)
        elif nodeName_ == 'e_cp':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_cp(obj_)
        elif nodeName_ == 'e_crlc':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_crlc(obj_)
        elif nodeName_ == 'e_cparhdr':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_cparhdr(obj_)
        elif nodeName_ == 'e_minalloc':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_minalloc(obj_)
        elif nodeName_ == 'e_maxalloc':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_maxalloc(obj_)
        elif nodeName_ == 'e_ss':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_ss(obj_)
        elif nodeName_ == 'e_sp':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_sp(obj_)
        elif nodeName_ == 'e_csum':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_csum(obj_)
        elif nodeName_ == 'e_ip':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_ip(obj_)
        elif nodeName_ == 'e_cs':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_cs(obj_)
        elif nodeName_ == 'e_lfarlc':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_lfarlc(obj_)
        elif nodeName_ == 'e_ovro':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_ovro(obj_)
        elif nodeName_ == 'reserved1':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.reserved1.append(obj_)
        elif nodeName_ == 'e_oemid':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_oemid(obj_)
        elif nodeName_ == 'e_oeminfo':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_oeminfo(obj_)
        elif nodeName_ == 'reserved2':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_reserved2(obj_)
        elif nodeName_ == 'e_lfanew':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_e_lfanew(obj_)
        elif nodeName_ == 'Hashes':
            obj_ = cybox_common_types_1_0.HashListType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
# end class DOSHeaderType

class PEHeadersType(GeneratedsSuper):
    """PEHeaderType specifies the headers found in PE and COFF files."""
    subclass = None
    superclass = None
    def __init__(self, DOS_Header=None, Signature=None, File_Header=None, Optional_Header=None, Entropy=None, Hashes=None):
        self.DOS_Header = DOS_Header
        self.Signature = Signature
        self.File_Header = File_Header
        self.Optional_Header = Optional_Header
        self.Entropy = Entropy
        self.Hashes = Hashes
    def factory(*args_, **kwargs_):
        if PEHeadersType.subclass:
            return PEHeadersType.subclass(*args_, **kwargs_)
        else:
            return PEHeadersType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DOS_Header(self): return self.DOS_Header
    def set_DOS_Header(self, DOS_Header): self.DOS_Header = DOS_Header
    def get_Signature(self): return self.Signature
    def set_Signature(self, Signature): self.Signature = Signature
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_File_Header(self): return self.File_Header
    def set_File_Header(self, File_Header): self.File_Header = File_Header
    def get_Optional_Header(self): return self.Optional_Header
    def set_Optional_Header(self, Optional_Header): self.Optional_Header = Optional_Header
    def get_Entropy(self): return self.Entropy
    def set_Entropy(self, Entropy): self.Entropy = Entropy
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEHeadersType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEHeadersType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEHeadersType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEHeadersType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DOS_Header is not None:
            self.DOS_Header.export(outfile, level, 'WinExecutableFileObj:', name_='DOS_Header', pretty_print=pretty_print)
        if self.Signature is not None:
            self.Signature.export(outfile, level, 'WinExecutableFileObj:', name_='Signature', pretty_print=pretty_print)
        if self.File_Header is not None:
            self.File_Header.export(outfile, level, 'WinExecutableFileObj:', name_='File_Header', pretty_print=pretty_print)
        if self.Optional_Header is not None:
            self.Optional_Header.export(outfile, level, 'WinExecutableFileObj:', name_='Optional_Header', pretty_print=pretty_print)
        if self.Entropy is not None:
            self.Entropy.export(outfile, level, 'WinExecutableFileObj:', name_='Entropy', pretty_print=pretty_print)
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, 'WinExecutableFileObj:', name_='Hashes', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.DOS_Header is not None or
            self.Signature is not None or
            self.File_Header is not None or
            self.Optional_Header is not None or
            self.Entropy is not None or
            self.Hashes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEHeadersType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DOS_Header is not None:
            showIndent(outfile, level)
            outfile.write('DOS_Header=model_.DOSHeaderType(\n')
            self.DOS_Header.exportLiteral(outfile, level, name_='DOS_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Signature is not None:
            showIndent(outfile, level)
            outfile.write('Signature=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Signature.exportLiteral(outfile, level, name_='Signature')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_Header is not None:
            showIndent(outfile, level)
            outfile.write('File_Header=model_.PEFileHeaderType(\n')
            self.File_Header.exportLiteral(outfile, level, name_='File_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Optional_Header is not None:
            showIndent(outfile, level)
            outfile.write('Optional_Header=model_.PEOptionalHeaderType(\n')
            self.Optional_Header.exportLiteral(outfile, level, name_='Optional_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Entropy is not None:
            showIndent(outfile, level)
            outfile.write('Entropy=model_.EntropyType(\n')
            self.Entropy.exportLiteral(outfile, level, name_='Entropy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.cybox_common_types_1_0.HashListType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DOS_Header':
            obj_ = DOSHeaderType.factory()
            obj_.build(child_)
            self.set_DOS_Header(obj_)
        elif nodeName_ == 'Signature':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Signature(obj_)
        elif nodeName_ == 'File_Header':
            obj_ = PEFileHeaderType.factory()
            obj_.build(child_)
            self.set_File_Header(obj_)
        elif nodeName_ == 'Optional_Header':
            obj_ = PEOptionalHeaderType.factory()
            obj_.build(child_)
            self.set_Optional_Header(obj_)
        elif nodeName_ == 'Entropy':
            obj_ = EntropyType.factory()
            obj_.build(child_)
            self.set_Entropy(obj_)
        elif nodeName_ == 'Hashes':
            obj_ = cybox_common_types_1_0.HashListType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
# end class PEHeadersType

class PEFileHeaderType(GeneratedsSuper):
    """The PEFileHeaderType type refers to the PE file header (somtimes
    referred to as the COFF header) and its associated attributes."""
    subclass = None
    superclass = None
    def __init__(self, Machine=None, Number_Of_Sections=None, Time_Date_Stamp=None, Pointer_To_Symbol_Table=None, Number_Of_Symbols=None, Size_Of_Optional_Header=None, Characteristics=None, Hashes=None):
        self.Machine = Machine
        self.Number_Of_Sections = Number_Of_Sections
        self.Time_Date_Stamp = Time_Date_Stamp
        self.Pointer_To_Symbol_Table = Pointer_To_Symbol_Table
        self.Number_Of_Symbols = Number_Of_Symbols
        self.Size_Of_Optional_Header = Size_Of_Optional_Header
        self.Characteristics = Characteristics
        self.Hashes = Hashes
    def factory(*args_, **kwargs_):
        if PEFileHeaderType.subclass:
            return PEFileHeaderType.subclass(*args_, **kwargs_)
        else:
            return PEFileHeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Machine(self): return self.Machine
    def set_Machine(self, Machine): self.Machine = Machine
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Number_Of_Sections(self): return self.Number_Of_Sections
    def set_Number_Of_Sections(self, Number_Of_Sections): self.Number_Of_Sections = Number_Of_Sections
    def validate_NonNegativeIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType, a restriction on None.
        pass
    def get_Time_Date_Stamp(self): return self.Time_Date_Stamp
    def set_Time_Date_Stamp(self, Time_Date_Stamp): self.Time_Date_Stamp = Time_Date_Stamp
    def get_Pointer_To_Symbol_Table(self): return self.Pointer_To_Symbol_Table
    def set_Pointer_To_Symbol_Table(self, Pointer_To_Symbol_Table): self.Pointer_To_Symbol_Table = Pointer_To_Symbol_Table
    def get_Number_Of_Symbols(self): return self.Number_Of_Symbols
    def set_Number_Of_Symbols(self, Number_Of_Symbols): self.Number_Of_Symbols = Number_Of_Symbols
    def get_Size_Of_Optional_Header(self): return self.Size_Of_Optional_Header
    def set_Size_Of_Optional_Header(self, Size_Of_Optional_Header): self.Size_Of_Optional_Header = Size_Of_Optional_Header
    def get_Characteristics(self): return self.Characteristics
    def set_Characteristics(self, Characteristics): self.Characteristics = Characteristics
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEFileHeaderType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEFileHeaderType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEFileHeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEFileHeaderType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Machine is not None:
            self.Machine.export(outfile, level, 'WinExecutableFileObj:', name_='Machine', pretty_print=pretty_print)
        if self.Number_Of_Sections is not None:
            self.Number_Of_Sections.export(outfile, level, 'WinExecutableFileObj:', name_='Number_Of_Sections', pretty_print=pretty_print)
        if self.Time_Date_Stamp is not None:
            self.Time_Date_Stamp.export(outfile, level, 'WinExecutableFileObj:', name_='Time_Date_Stamp', pretty_print=pretty_print)
        if self.Pointer_To_Symbol_Table is not None:
            self.Pointer_To_Symbol_Table.export(outfile, level, 'WinExecutableFileObj:', name_='Pointer_To_Symbol_Table', pretty_print=pretty_print)
        if self.Number_Of_Symbols is not None:
            self.Number_Of_Symbols.export(outfile, level, 'WinExecutableFileObj:', name_='Number_Of_Symbols', pretty_print=pretty_print)
        if self.Size_Of_Optional_Header is not None:
            self.Size_Of_Optional_Header.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Optional_Header', pretty_print=pretty_print)
        if self.Characteristics is not None:
            self.Characteristics.export(outfile, level, 'WinExecutableFileObj:', name_='Characteristics', pretty_print=pretty_print)
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, 'WinExecutableFileObj:', name_='Hashes', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Machine is not None or
            self.Number_Of_Sections is not None or
            self.Time_Date_Stamp is not None or
            self.Pointer_To_Symbol_Table is not None or
            self.Number_Of_Symbols is not None or
            self.Size_Of_Optional_Header is not None or
            self.Characteristics is not None or
            self.Hashes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEFileHeaderType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Machine is not None:
            showIndent(outfile, level)
            outfile.write('Machine=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Machine.exportLiteral(outfile, level, name_='Machine')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Sections is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Sections=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.Number_Of_Sections.exportLiteral(outfile, level, name_='Number_Of_Sections')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Time_Date_Stamp is not None:
            showIndent(outfile, level)
            outfile.write('Time_Date_Stamp=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Time_Date_Stamp.exportLiteral(outfile, level, name_='Time_Date_Stamp')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pointer_To_Symbol_Table is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Symbol_Table=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Pointer_To_Symbol_Table.exportLiteral(outfile, level, name_='Pointer_To_Symbol_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Symbols is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Symbols=model_.cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType(\n')
            self.Number_Of_Symbols.exportLiteral(outfile, level, name_='Number_Of_Symbols')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Optional_Header is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Optional_Header=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Optional_Header.exportLiteral(outfile, level, name_='Size_Of_Optional_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('Characteristics=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Characteristics.exportLiteral(outfile, level, name_='Characteristics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.cybox_common_types_1_0.HashListType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Machine':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Machine(obj_)
        elif nodeName_ == 'Number_Of_Sections':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Number_Of_Sections(obj_)
        elif nodeName_ == 'Time_Date_Stamp':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Time_Date_Stamp(obj_)
        elif nodeName_ == 'Pointer_To_Symbol_Table':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Pointer_To_Symbol_Table(obj_)
        elif nodeName_ == 'Number_Of_Symbols':
            obj_ = cybox_common_types_1_0.NonNegativeIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Number_Of_Symbols(obj_)
        elif nodeName_ == 'Size_Of_Optional_Header':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Optional_Header(obj_)
        elif nodeName_ == 'Characteristics':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Characteristics(obj_)
        elif nodeName_ == 'Hashes':
            obj_ = cybox_common_types_1_0.HashListType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
# end class PEFileHeaderType

class PEOptionalHeaderType(GeneratedsSuper):
    """The PEOptionalHeaderType type describes the PE Optional Header
    structure. Additional computed metadata, e.g., hashes of the
    header, are also included."""
    subclass = None
    superclass = None
    def __init__(self, Magic=None, Major_Linker_Version=None, Minor_Linker_Version=None, Size_Of_Code=None, Size_Of_Initialized_Data=None, Size_Of_Uninitialized_Data=None, Address_Of_Entry_Point=None, Base_Of_Code=None, Base_Of_Data=None, Image_Base=None, Section_Alignment=None, File_Alignment=None, Major_OS_Version=None, Minor_OS_Version=None, Major_Image_Version=None, Minor_Image_Version=None, Major_Subsystem_Version=None, Minor_Subsystem_Version=None, Win32_Version_Value=None, Size_Of_Image=None, Size_Of_Headers=None, Checksum=None, Subsystem=None, DLL_Characteristics=None, Size_Of_Stack_Reserve=None, Size_Of_Stack_Commit=None, Size_Of_Heap_Reserve=None, Size_Of_Heap_Commit=None, Loader_Flags=None, Number_Of_Rva_And_Sizes=None, Data_Directory=None, Hashes=None):
        self.Magic = Magic
        self.Major_Linker_Version = Major_Linker_Version
        self.Minor_Linker_Version = Minor_Linker_Version
        self.Size_Of_Code = Size_Of_Code
        self.Size_Of_Initialized_Data = Size_Of_Initialized_Data
        self.Size_Of_Uninitialized_Data = Size_Of_Uninitialized_Data
        self.Address_Of_Entry_Point = Address_Of_Entry_Point
        self.Base_Of_Code = Base_Of_Code
        self.Base_Of_Data = Base_Of_Data
        self.Image_Base = Image_Base
        self.Section_Alignment = Section_Alignment
        self.File_Alignment = File_Alignment
        self.Major_OS_Version = Major_OS_Version
        self.Minor_OS_Version = Minor_OS_Version
        self.Major_Image_Version = Major_Image_Version
        self.Minor_Image_Version = Minor_Image_Version
        self.Major_Subsystem_Version = Major_Subsystem_Version
        self.Minor_Subsystem_Version = Minor_Subsystem_Version
        self.Win32_Version_Value = Win32_Version_Value
        self.Size_Of_Image = Size_Of_Image
        self.Size_Of_Headers = Size_Of_Headers
        self.Checksum = Checksum
        self.Subsystem = Subsystem
        self.DLL_Characteristics = DLL_Characteristics
        self.Size_Of_Stack_Reserve = Size_Of_Stack_Reserve
        self.Size_Of_Stack_Commit = Size_Of_Stack_Commit
        self.Size_Of_Heap_Reserve = Size_Of_Heap_Reserve
        self.Size_Of_Heap_Commit = Size_Of_Heap_Commit
        self.Loader_Flags = Loader_Flags
        self.Number_Of_Rva_And_Sizes = Number_Of_Rva_And_Sizes
        self.Data_Directory = Data_Directory
        self.Hashes = Hashes
    def factory(*args_, **kwargs_):
        if PEOptionalHeaderType.subclass:
            return PEOptionalHeaderType.subclass(*args_, **kwargs_)
        else:
            return PEOptionalHeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Magic(self): return self.Magic
    def set_Magic(self, Magic): self.Magic = Magic
    def validate_HexBinaryObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.HexBinaryObjectAttributeType, a restriction on None.
        pass
    def get_Major_Linker_Version(self): return self.Major_Linker_Version
    def set_Major_Linker_Version(self, Major_Linker_Version): self.Major_Linker_Version = Major_Linker_Version
    def get_Minor_Linker_Version(self): return self.Minor_Linker_Version
    def set_Minor_Linker_Version(self, Minor_Linker_Version): self.Minor_Linker_Version = Minor_Linker_Version
    def get_Size_Of_Code(self): return self.Size_Of_Code
    def set_Size_Of_Code(self, Size_Of_Code): self.Size_Of_Code = Size_Of_Code
    def get_Size_Of_Initialized_Data(self): return self.Size_Of_Initialized_Data
    def set_Size_Of_Initialized_Data(self, Size_Of_Initialized_Data): self.Size_Of_Initialized_Data = Size_Of_Initialized_Data
    def get_Size_Of_Uninitialized_Data(self): return self.Size_Of_Uninitialized_Data
    def set_Size_Of_Uninitialized_Data(self, Size_Of_Uninitialized_Data): self.Size_Of_Uninitialized_Data = Size_Of_Uninitialized_Data
    def get_Address_Of_Entry_Point(self): return self.Address_Of_Entry_Point
    def set_Address_Of_Entry_Point(self, Address_Of_Entry_Point): self.Address_Of_Entry_Point = Address_Of_Entry_Point
    def get_Base_Of_Code(self): return self.Base_Of_Code
    def set_Base_Of_Code(self, Base_Of_Code): self.Base_Of_Code = Base_Of_Code
    def get_Base_Of_Data(self): return self.Base_Of_Data
    def set_Base_Of_Data(self, Base_Of_Data): self.Base_Of_Data = Base_Of_Data
    def get_Image_Base(self): return self.Image_Base
    def set_Image_Base(self, Image_Base): self.Image_Base = Image_Base
    def get_Section_Alignment(self): return self.Section_Alignment
    def set_Section_Alignment(self, Section_Alignment): self.Section_Alignment = Section_Alignment
    def get_File_Alignment(self): return self.File_Alignment
    def set_File_Alignment(self, File_Alignment): self.File_Alignment = File_Alignment
    def get_Major_OS_Version(self): return self.Major_OS_Version
    def set_Major_OS_Version(self, Major_OS_Version): self.Major_OS_Version = Major_OS_Version
    def get_Minor_OS_Version(self): return self.Minor_OS_Version
    def set_Minor_OS_Version(self, Minor_OS_Version): self.Minor_OS_Version = Minor_OS_Version
    def get_Major_Image_Version(self): return self.Major_Image_Version
    def set_Major_Image_Version(self, Major_Image_Version): self.Major_Image_Version = Major_Image_Version
    def get_Minor_Image_Version(self): return self.Minor_Image_Version
    def set_Minor_Image_Version(self, Minor_Image_Version): self.Minor_Image_Version = Minor_Image_Version
    def get_Major_Subsystem_Version(self): return self.Major_Subsystem_Version
    def set_Major_Subsystem_Version(self, Major_Subsystem_Version): self.Major_Subsystem_Version = Major_Subsystem_Version
    def get_Minor_Subsystem_Version(self): return self.Minor_Subsystem_Version
    def set_Minor_Subsystem_Version(self, Minor_Subsystem_Version): self.Minor_Subsystem_Version = Minor_Subsystem_Version
    def get_Win32_Version_Value(self): return self.Win32_Version_Value
    def set_Win32_Version_Value(self, Win32_Version_Value): self.Win32_Version_Value = Win32_Version_Value
    def get_Size_Of_Image(self): return self.Size_Of_Image
    def set_Size_Of_Image(self, Size_Of_Image): self.Size_Of_Image = Size_Of_Image
    def get_Size_Of_Headers(self): return self.Size_Of_Headers
    def set_Size_Of_Headers(self, Size_Of_Headers): self.Size_Of_Headers = Size_Of_Headers
    def get_Checksum(self): return self.Checksum
    def set_Checksum(self, Checksum): self.Checksum = Checksum
    def get_Subsystem(self): return self.Subsystem
    def set_Subsystem(self, Subsystem): self.Subsystem = Subsystem
    def get_DLL_Characteristics(self): return self.DLL_Characteristics
    def set_DLL_Characteristics(self, DLL_Characteristics): self.DLL_Characteristics = DLL_Characteristics
    def get_Size_Of_Stack_Reserve(self): return self.Size_Of_Stack_Reserve
    def set_Size_Of_Stack_Reserve(self, Size_Of_Stack_Reserve): self.Size_Of_Stack_Reserve = Size_Of_Stack_Reserve
    def get_Size_Of_Stack_Commit(self): return self.Size_Of_Stack_Commit
    def set_Size_Of_Stack_Commit(self, Size_Of_Stack_Commit): self.Size_Of_Stack_Commit = Size_Of_Stack_Commit
    def get_Size_Of_Heap_Reserve(self): return self.Size_Of_Heap_Reserve
    def set_Size_Of_Heap_Reserve(self, Size_Of_Heap_Reserve): self.Size_Of_Heap_Reserve = Size_Of_Heap_Reserve
    def get_Size_Of_Heap_Commit(self): return self.Size_Of_Heap_Commit
    def set_Size_Of_Heap_Commit(self, Size_Of_Heap_Commit): self.Size_Of_Heap_Commit = Size_Of_Heap_Commit
    def get_Loader_Flags(self): return self.Loader_Flags
    def set_Loader_Flags(self, Loader_Flags): self.Loader_Flags = Loader_Flags
    def get_Number_Of_Rva_And_Sizes(self): return self.Number_Of_Rva_And_Sizes
    def set_Number_Of_Rva_And_Sizes(self, Number_Of_Rva_And_Sizes): self.Number_Of_Rva_And_Sizes = Number_Of_Rva_And_Sizes
    def get_Data_Directory(self): return self.Data_Directory
    def set_Data_Directory(self, Data_Directory): self.Data_Directory = Data_Directory
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEOptionalHeaderType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEOptionalHeaderType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEOptionalHeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEOptionalHeaderType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Magic is not None:
            self.Magic.export(outfile, level, 'WinExecutableFileObj:', name_='Magic', pretty_print=pretty_print)
        if self.Major_Linker_Version is not None:
            self.Major_Linker_Version.export(outfile, level, 'WinExecutableFileObj:', name_='Major_Linker_Version', pretty_print=pretty_print)
        if self.Minor_Linker_Version is not None:
            self.Minor_Linker_Version.export(outfile, level, 'WinExecutableFileObj:', name_='Minor_Linker_Version', pretty_print=pretty_print)
        if self.Size_Of_Code is not None:
            self.Size_Of_Code.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Code', pretty_print=pretty_print)
        if self.Size_Of_Initialized_Data is not None:
            self.Size_Of_Initialized_Data.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Initialized_Data', pretty_print=pretty_print)
        if self.Size_Of_Uninitialized_Data is not None:
            self.Size_Of_Uninitialized_Data.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Uninitialized_Data', pretty_print=pretty_print)
        if self.Address_Of_Entry_Point is not None:
            self.Address_Of_Entry_Point.export(outfile, level, 'WinExecutableFileObj:', name_='Address_Of_Entry_Point', pretty_print=pretty_print)
        if self.Base_Of_Code is not None:
            self.Base_Of_Code.export(outfile, level, 'WinExecutableFileObj:', name_='Base_Of_Code', pretty_print=pretty_print)
        if self.Base_Of_Data is not None:
            self.Base_Of_Data.export(outfile, level, 'WinExecutableFileObj:', name_='Base_Of_Data', pretty_print=pretty_print)
        if self.Image_Base is not None:
            self.Image_Base.export(outfile, level, 'WinExecutableFileObj:', name_='Image_Base', pretty_print=pretty_print)
        if self.Section_Alignment is not None:
            self.Section_Alignment.export(outfile, level, 'WinExecutableFileObj:', name_='Section_Alignment', pretty_print=pretty_print)
        if self.File_Alignment is not None:
            self.File_Alignment.export(outfile, level, 'WinExecutableFileObj:', name_='File_Alignment', pretty_print=pretty_print)
        if self.Major_OS_Version is not None:
            self.Major_OS_Version.export(outfile, level, 'WinExecutableFileObj:', name_='Major_OS_Version', pretty_print=pretty_print)
        if self.Minor_OS_Version is not None:
            self.Minor_OS_Version.export(outfile, level, 'WinExecutableFileObj:', name_='Minor_OS_Version', pretty_print=pretty_print)
        if self.Major_Image_Version is not None:
            self.Major_Image_Version.export(outfile, level, 'WinExecutableFileObj:', name_='Major_Image_Version', pretty_print=pretty_print)
        if self.Minor_Image_Version is not None:
            self.Minor_Image_Version.export(outfile, level, 'WinExecutableFileObj:', name_='Minor_Image_Version', pretty_print=pretty_print)
        if self.Major_Subsystem_Version is not None:
            self.Major_Subsystem_Version.export(outfile, level, 'WinExecutableFileObj:', name_='Major_Subsystem_Version', pretty_print=pretty_print)
        if self.Minor_Subsystem_Version is not None:
            self.Minor_Subsystem_Version.export(outfile, level, 'WinExecutableFileObj:', name_='Minor_Subsystem_Version', pretty_print=pretty_print)
        if self.Win32_Version_Value is not None:
            self.Win32_Version_Value.export(outfile, level, 'WinExecutableFileObj:', name_='Win32_Version_Value', pretty_print=pretty_print)
        if self.Size_Of_Image is not None:
            self.Size_Of_Image.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Image', pretty_print=pretty_print)
        if self.Size_Of_Headers is not None:
            self.Size_Of_Headers.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Headers', pretty_print=pretty_print)
        if self.Checksum is not None:
            self.Checksum.export(outfile, level, 'WinExecutableFileObj:', name_='Checksum', pretty_print=pretty_print)
        if self.Subsystem is not None:
            self.Subsystem.export(outfile, level, 'WinExecutableFileObj:', name_='Subsystem', pretty_print=pretty_print)
        if self.DLL_Characteristics is not None:
            self.DLL_Characteristics.export(outfile, level, 'WinExecutableFileObj:', name_='DLL_Characteristics', pretty_print=pretty_print)
        if self.Size_Of_Stack_Reserve is not None:
            self.Size_Of_Stack_Reserve.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Stack_Reserve', pretty_print=pretty_print)
        if self.Size_Of_Stack_Commit is not None:
            self.Size_Of_Stack_Commit.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Stack_Commit', pretty_print=pretty_print)
        if self.Size_Of_Heap_Reserve is not None:
            self.Size_Of_Heap_Reserve.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Heap_Reserve', pretty_print=pretty_print)
        if self.Size_Of_Heap_Commit is not None:
            self.Size_Of_Heap_Commit.export(outfile, level, 'WinExecutableFileObj:', name_='Size_Of_Heap_Commit', pretty_print=pretty_print)
        if self.Loader_Flags is not None:
            self.Loader_Flags.export(outfile, level, 'WinExecutableFileObj:', name_='Loader_Flags', pretty_print=pretty_print)
        if self.Number_Of_Rva_And_Sizes is not None:
            self.Number_Of_Rva_And_Sizes.export(outfile, level, 'WinExecutableFileObj:', name_='Number_Of_Rva_And_Sizes', pretty_print=pretty_print)
        if self.Data_Directory is not None:
            self.Data_Directory.export(outfile, level, 'WinExecutableFileObj:', name_='Data_Directory', pretty_print=pretty_print)
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, 'WinExecutableFileObj:', name_='Hashes', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Magic is not None or
            self.Major_Linker_Version is not None or
            self.Minor_Linker_Version is not None or
            self.Size_Of_Code is not None or
            self.Size_Of_Initialized_Data is not None or
            self.Size_Of_Uninitialized_Data is not None or
            self.Address_Of_Entry_Point is not None or
            self.Base_Of_Code is not None or
            self.Base_Of_Data is not None or
            self.Image_Base is not None or
            self.Section_Alignment is not None or
            self.File_Alignment is not None or
            self.Major_OS_Version is not None or
            self.Minor_OS_Version is not None or
            self.Major_Image_Version is not None or
            self.Minor_Image_Version is not None or
            self.Major_Subsystem_Version is not None or
            self.Minor_Subsystem_Version is not None or
            self.Win32_Version_Value is not None or
            self.Size_Of_Image is not None or
            self.Size_Of_Headers is not None or
            self.Checksum is not None or
            self.Subsystem is not None or
            self.DLL_Characteristics is not None or
            self.Size_Of_Stack_Reserve is not None or
            self.Size_Of_Stack_Commit is not None or
            self.Size_Of_Heap_Reserve is not None or
            self.Size_Of_Heap_Commit is not None or
            self.Loader_Flags is not None or
            self.Number_Of_Rva_And_Sizes is not None or
            self.Data_Directory is not None or
            self.Hashes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEOptionalHeaderType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Magic is not None:
            showIndent(outfile, level)
            outfile.write('Magic=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Magic.exportLiteral(outfile, level, name_='Magic')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Major_Linker_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_Linker_Version=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Major_Linker_Version.exportLiteral(outfile, level, name_='Major_Linker_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Minor_Linker_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_Linker_Version=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Minor_Linker_Version.exportLiteral(outfile, level, name_='Minor_Linker_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Code is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Code=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Code.exportLiteral(outfile, level, name_='Size_Of_Code')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Initialized_Data is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Initialized_Data=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Initialized_Data.exportLiteral(outfile, level, name_='Size_Of_Initialized_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Uninitialized_Data is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Uninitialized_Data=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Uninitialized_Data.exportLiteral(outfile, level, name_='Size_Of_Uninitialized_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Address_Of_Entry_Point is not None:
            showIndent(outfile, level)
            outfile.write('Address_Of_Entry_Point=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Address_Of_Entry_Point.exportLiteral(outfile, level, name_='Address_Of_Entry_Point')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Base_Of_Code is not None:
            showIndent(outfile, level)
            outfile.write('Base_Of_Code=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Base_Of_Code.exportLiteral(outfile, level, name_='Base_Of_Code')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Base_Of_Data is not None:
            showIndent(outfile, level)
            outfile.write('Base_Of_Data=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Base_Of_Data.exportLiteral(outfile, level, name_='Base_Of_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Image_Base is not None:
            showIndent(outfile, level)
            outfile.write('Image_Base=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Image_Base.exportLiteral(outfile, level, name_='Image_Base')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Section_Alignment is not None:
            showIndent(outfile, level)
            outfile.write('Section_Alignment=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Section_Alignment.exportLiteral(outfile, level, name_='Section_Alignment')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_Alignment is not None:
            showIndent(outfile, level)
            outfile.write('File_Alignment=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.File_Alignment.exportLiteral(outfile, level, name_='File_Alignment')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Major_OS_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_OS_Version=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Major_OS_Version.exportLiteral(outfile, level, name_='Major_OS_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Minor_OS_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_OS_Version=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Minor_OS_Version.exportLiteral(outfile, level, name_='Minor_OS_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Major_Image_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_Image_Version=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Major_Image_Version.exportLiteral(outfile, level, name_='Major_Image_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Minor_Image_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_Image_Version=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Minor_Image_Version.exportLiteral(outfile, level, name_='Minor_Image_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Major_Subsystem_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_Subsystem_Version=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Major_Subsystem_Version.exportLiteral(outfile, level, name_='Major_Subsystem_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Minor_Subsystem_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_Subsystem_Version=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Minor_Subsystem_Version.exportLiteral(outfile, level, name_='Minor_Subsystem_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Win32_Version_Value is not None:
            showIndent(outfile, level)
            outfile.write('Win32_Version_Value=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Win32_Version_Value.exportLiteral(outfile, level, name_='Win32_Version_Value')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Image is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Image=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Image.exportLiteral(outfile, level, name_='Size_Of_Image')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Headers is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Headers=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Headers.exportLiteral(outfile, level, name_='Size_Of_Headers')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Checksum is not None:
            showIndent(outfile, level)
            outfile.write('Checksum=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Checksum.exportLiteral(outfile, level, name_='Checksum')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Subsystem is not None:
            showIndent(outfile, level)
            outfile.write('Subsystem=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Subsystem.exportLiteral(outfile, level, name_='Subsystem')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.DLL_Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('DLL_Characteristics=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.DLL_Characteristics.exportLiteral(outfile, level, name_='DLL_Characteristics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Stack_Reserve is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Stack_Reserve=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Stack_Reserve.exportLiteral(outfile, level, name_='Size_Of_Stack_Reserve')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Stack_Commit is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Stack_Commit=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Stack_Commit.exportLiteral(outfile, level, name_='Size_Of_Stack_Commit')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Heap_Reserve is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Heap_Reserve=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Heap_Reserve.exportLiteral(outfile, level, name_='Size_Of_Heap_Reserve')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Heap_Commit is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Heap_Commit=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Size_Of_Heap_Commit.exportLiteral(outfile, level, name_='Size_Of_Heap_Commit')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Loader_Flags is not None:
            showIndent(outfile, level)
            outfile.write('Loader_Flags=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Loader_Flags.exportLiteral(outfile, level, name_='Loader_Flags')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Rva_And_Sizes is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Rva_And_Sizes=model_.cybox_common_types_1_0.HexBinaryObjectAttributeType(\n')
            self.Number_Of_Rva_And_Sizes.exportLiteral(outfile, level, name_='Number_Of_Rva_And_Sizes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Directory is not None:
            showIndent(outfile, level)
            outfile.write('Data_Directory=model_.DataDirectoryType(\n')
            self.Data_Directory.exportLiteral(outfile, level, name_='Data_Directory')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.cybox_common_types_1_0.HashListType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Magic':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Magic(obj_)
        elif nodeName_ == 'Major_Linker_Version':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Major_Linker_Version(obj_)
        elif nodeName_ == 'Minor_Linker_Version':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Minor_Linker_Version(obj_)
        elif nodeName_ == 'Size_Of_Code':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Code(obj_)
        elif nodeName_ == 'Size_Of_Initialized_Data':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Initialized_Data(obj_)
        elif nodeName_ == 'Size_Of_Uninitialized_Data':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Uninitialized_Data(obj_)
        elif nodeName_ == 'Address_Of_Entry_Point':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Address_Of_Entry_Point(obj_)
        elif nodeName_ == 'Base_Of_Code':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Base_Of_Code(obj_)
        elif nodeName_ == 'Base_Of_Data':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Base_Of_Data(obj_)
        elif nodeName_ == 'Image_Base':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Image_Base(obj_)
        elif nodeName_ == 'Section_Alignment':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Section_Alignment(obj_)
        elif nodeName_ == 'File_Alignment':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_File_Alignment(obj_)
        elif nodeName_ == 'Major_OS_Version':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Major_OS_Version(obj_)
        elif nodeName_ == 'Minor_OS_Version':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Minor_OS_Version(obj_)
        elif nodeName_ == 'Major_Image_Version':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Major_Image_Version(obj_)
        elif nodeName_ == 'Minor_Image_Version':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Minor_Image_Version(obj_)
        elif nodeName_ == 'Major_Subsystem_Version':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Major_Subsystem_Version(obj_)
        elif nodeName_ == 'Minor_Subsystem_Version':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Minor_Subsystem_Version(obj_)
        elif nodeName_ == 'Win32_Version_Value':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Win32_Version_Value(obj_)
        elif nodeName_ == 'Size_Of_Image':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Image(obj_)
        elif nodeName_ == 'Size_Of_Headers':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Headers(obj_)
        elif nodeName_ == 'Checksum':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Checksum(obj_)
        elif nodeName_ == 'Subsystem':
            obj_ = SubsystemType.factory()
            obj_.build(child_)
            self.set_Subsystem(obj_)
        elif nodeName_ == 'DLL_Characteristics':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_DLL_Characteristics(obj_)
        elif nodeName_ == 'Size_Of_Stack_Reserve':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Stack_Reserve(obj_)
        elif nodeName_ == 'Size_Of_Stack_Commit':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Stack_Commit(obj_)
        elif nodeName_ == 'Size_Of_Heap_Reserve':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Heap_Reserve(obj_)
        elif nodeName_ == 'Size_Of_Heap_Commit':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Size_Of_Heap_Commit(obj_)
        elif nodeName_ == 'Loader_Flags':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Loader_Flags(obj_)
        elif nodeName_ == 'Number_Of_Rva_And_Sizes':
            obj_ = cybox_common_types_1_0.HexBinaryObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Number_Of_Rva_And_Sizes(obj_)
        elif nodeName_ == 'Data_Directory':
            obj_ = DataDirectoryType.factory()
            obj_.build(child_)
            self.set_Data_Directory(obj_)
        elif nodeName_ == 'Hashes':
            obj_ = cybox_common_types_1_0.HashListType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
# end class PEOptionalHeaderType

class DataDirectoryType(GeneratedsSuper):
    """The DataDirectoryType specifies the data directories that can appear
    in the PE file's optional header. The data directories, except
    the Certificate Table, are loaded into memory so they can be
    used at runtime."""
    subclass = None
    superclass = None
    def __init__(self, Export_Table=None, Import_Table=None, Resource_Table=None, Exception_Table=None, Certificate_Table=None, Base_Relocation_Table=None, Debug=None, Architecture=None, Global_Ptr=None, TLS_Table=None, Load_Config_Table=None, Bound_Import=None, Import_Address_Table=None, Delay_Import_Descriptor=None, CLR_Runtime_Header=None, Reserved=None):
        self.Export_Table = Export_Table
        self.Import_Table = Import_Table
        self.Resource_Table = Resource_Table
        self.Exception_Table = Exception_Table
        self.Certificate_Table = Certificate_Table
        self.Base_Relocation_Table = Base_Relocation_Table
        self.Debug = Debug
        self.Architecture = Architecture
        self.Global_Ptr = Global_Ptr
        self.TLS_Table = TLS_Table
        self.Load_Config_Table = Load_Config_Table
        self.Bound_Import = Bound_Import
        self.Import_Address_Table = Import_Address_Table
        self.Delay_Import_Descriptor = Delay_Import_Descriptor
        self.CLR_Runtime_Header = CLR_Runtime_Header
        self.Reserved = Reserved
    def factory(*args_, **kwargs_):
        if DataDirectoryType.subclass:
            return DataDirectoryType.subclass(*args_, **kwargs_)
        else:
            return DataDirectoryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Export_Table(self): return self.Export_Table
    def set_Export_Table(self, Export_Table): self.Export_Table = Export_Table
    def get_Import_Table(self): return self.Import_Table
    def set_Import_Table(self, Import_Table): self.Import_Table = Import_Table
    def get_Resource_Table(self): return self.Resource_Table
    def set_Resource_Table(self, Resource_Table): self.Resource_Table = Resource_Table
    def get_Exception_Table(self): return self.Exception_Table
    def set_Exception_Table(self, Exception_Table): self.Exception_Table = Exception_Table
    def get_Certificate_Table(self): return self.Certificate_Table
    def set_Certificate_Table(self, Certificate_Table): self.Certificate_Table = Certificate_Table
    def get_Base_Relocation_Table(self): return self.Base_Relocation_Table
    def set_Base_Relocation_Table(self, Base_Relocation_Table): self.Base_Relocation_Table = Base_Relocation_Table
    def get_Debug(self): return self.Debug
    def set_Debug(self, Debug): self.Debug = Debug
    def get_Architecture(self): return self.Architecture
    def set_Architecture(self, Architecture): self.Architecture = Architecture
    def get_Global_Ptr(self): return self.Global_Ptr
    def set_Global_Ptr(self, Global_Ptr): self.Global_Ptr = Global_Ptr
    def get_TLS_Table(self): return self.TLS_Table
    def set_TLS_Table(self, TLS_Table): self.TLS_Table = TLS_Table
    def get_Load_Config_Table(self): return self.Load_Config_Table
    def set_Load_Config_Table(self, Load_Config_Table): self.Load_Config_Table = Load_Config_Table
    def get_Bound_Import(self): return self.Bound_Import
    def set_Bound_Import(self, Bound_Import): self.Bound_Import = Bound_Import
    def get_Import_Address_Table(self): return self.Import_Address_Table
    def set_Import_Address_Table(self, Import_Address_Table): self.Import_Address_Table = Import_Address_Table
    def get_Delay_Import_Descriptor(self): return self.Delay_Import_Descriptor
    def set_Delay_Import_Descriptor(self, Delay_Import_Descriptor): self.Delay_Import_Descriptor = Delay_Import_Descriptor
    def get_CLR_Runtime_Header(self): return self.CLR_Runtime_Header
    def set_CLR_Runtime_Header(self, CLR_Runtime_Header): self.CLR_Runtime_Header = CLR_Runtime_Header
    def get_Reserved(self): return self.Reserved
    def set_Reserved(self, Reserved): self.Reserved = Reserved
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='DataDirectoryType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataDirectoryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='DataDirectoryType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='DataDirectoryType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Export_Table is not None:
            self.Export_Table.export(outfile, level, 'WinExecutableFileObj:', name_='Export_Table', pretty_print=pretty_print)
        if self.Import_Table is not None:
            self.Import_Table.export(outfile, level, 'WinExecutableFileObj:', name_='Import_Table', pretty_print=pretty_print)
        if self.Resource_Table is not None:
            self.Resource_Table.export(outfile, level, 'WinExecutableFileObj:', name_='Resource_Table', pretty_print=pretty_print)
        if self.Exception_Table is not None:
            self.Exception_Table.export(outfile, level, 'WinExecutableFileObj:', name_='Exception_Table', pretty_print=pretty_print)
        if self.Certificate_Table is not None:
            self.Certificate_Table.export(outfile, level, 'WinExecutableFileObj:', name_='Certificate_Table', pretty_print=pretty_print)
        if self.Base_Relocation_Table is not None:
            self.Base_Relocation_Table.export(outfile, level, 'WinExecutableFileObj:', name_='Base_Relocation_Table', pretty_print=pretty_print)
        if self.Debug is not None:
            self.Debug.export(outfile, level, 'WinExecutableFileObj:', name_='Debug', pretty_print=pretty_print)
        if self.Architecture is not None:
            self.Architecture.export(outfile, level, 'WinExecutableFileObj:', name_='Architecture', pretty_print=pretty_print)
        if self.Global_Ptr is not None:
            self.Global_Ptr.export(outfile, level, 'WinExecutableFileObj:', name_='Global_Ptr', pretty_print=pretty_print)
        if self.TLS_Table is not None:
            self.TLS_Table.export(outfile, level, 'WinExecutableFileObj:', name_='TLS_Table', pretty_print=pretty_print)
        if self.Load_Config_Table is not None:
            self.Load_Config_Table.export(outfile, level, 'WinExecutableFileObj:', name_='Load_Config_Table', pretty_print=pretty_print)
        if self.Bound_Import is not None:
            self.Bound_Import.export(outfile, level, 'WinExecutableFileObj:', name_='Bound_Import', pretty_print=pretty_print)
        if self.Import_Address_Table is not None:
            self.Import_Address_Table.export(outfile, level, 'WinExecutableFileObj:', name_='Import_Address_Table', pretty_print=pretty_print)
        if self.Delay_Import_Descriptor is not None:
            self.Delay_Import_Descriptor.export(outfile, level, 'WinExecutableFileObj:', name_='Delay_Import_Descriptor', pretty_print=pretty_print)
        if self.CLR_Runtime_Header is not None:
            self.CLR_Runtime_Header.export(outfile, level, 'WinExecutableFileObj:', name_='CLR_Runtime_Header', pretty_print=pretty_print)
        if self.Reserved is not None:
            self.Reserved.export(outfile, level, 'WinExecutableFileObj:', name_='Reserved', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Export_Table is not None or
            self.Import_Table is not None or
            self.Resource_Table is not None or
            self.Exception_Table is not None or
            self.Certificate_Table is not None or
            self.Base_Relocation_Table is not None or
            self.Debug is not None or
            self.Architecture is not None or
            self.Global_Ptr is not None or
            self.TLS_Table is not None or
            self.Load_Config_Table is not None or
            self.Bound_Import is not None or
            self.Import_Address_Table is not None or
            self.Delay_Import_Descriptor is not None or
            self.CLR_Runtime_Header is not None or
            self.Reserved is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DataDirectoryType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Export_Table is not None:
            showIndent(outfile, level)
            outfile.write('Export_Table=model_.PEDataDirectoryStructType(\n')
            self.Export_Table.exportLiteral(outfile, level, name_='Export_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Import_Table is not None:
            showIndent(outfile, level)
            outfile.write('Import_Table=model_.PEDataDirectoryStructType(\n')
            self.Import_Table.exportLiteral(outfile, level, name_='Import_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Resource_Table is not None:
            showIndent(outfile, level)
            outfile.write('Resource_Table=model_.PEDataDirectoryStructType(\n')
            self.Resource_Table.exportLiteral(outfile, level, name_='Resource_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exception_Table is not None:
            showIndent(outfile, level)
            outfile.write('Exception_Table=model_.PEDataDirectoryStructType(\n')
            self.Exception_Table.exportLiteral(outfile, level, name_='Exception_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Certificate_Table is not None:
            showIndent(outfile, level)
            outfile.write('Certificate_Table=model_.PEDataDirectoryStructType(\n')
            self.Certificate_Table.exportLiteral(outfile, level, name_='Certificate_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Base_Relocation_Table is not None:
            showIndent(outfile, level)
            outfile.write('Base_Relocation_Table=model_.PEDataDirectoryStructType(\n')
            self.Base_Relocation_Table.exportLiteral(outfile, level, name_='Base_Relocation_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Debug is not None:
            showIndent(outfile, level)
            outfile.write('Debug=model_.PEDataDirectoryStructType(\n')
            self.Debug.exportLiteral(outfile, level, name_='Debug')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Architecture is not None:
            showIndent(outfile, level)
            outfile.write('Architecture=model_.PEDataDirectoryStructType(\n')
            self.Architecture.exportLiteral(outfile, level, name_='Architecture')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Global_Ptr is not None:
            showIndent(outfile, level)
            outfile.write('Global_Ptr=model_.PEDataDirectoryStructType(\n')
            self.Global_Ptr.exportLiteral(outfile, level, name_='Global_Ptr')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.TLS_Table is not None:
            showIndent(outfile, level)
            outfile.write('TLS_Table=model_.PEDataDirectoryStructType(\n')
            self.TLS_Table.exportLiteral(outfile, level, name_='TLS_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Load_Config_Table is not None:
            showIndent(outfile, level)
            outfile.write('Load_Config_Table=model_.PEDataDirectoryStructType(\n')
            self.Load_Config_Table.exportLiteral(outfile, level, name_='Load_Config_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Bound_Import is not None:
            showIndent(outfile, level)
            outfile.write('Bound_Import=model_.PEDataDirectoryStructType(\n')
            self.Bound_Import.exportLiteral(outfile, level, name_='Bound_Import')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Import_Address_Table is not None:
            showIndent(outfile, level)
            outfile.write('Import_Address_Table=model_.PEDataDirectoryStructType(\n')
            self.Import_Address_Table.exportLiteral(outfile, level, name_='Import_Address_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Delay_Import_Descriptor is not None:
            showIndent(outfile, level)
            outfile.write('Delay_Import_Descriptor=model_.PEDataDirectoryStructType(\n')
            self.Delay_Import_Descriptor.exportLiteral(outfile, level, name_='Delay_Import_Descriptor')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.CLR_Runtime_Header is not None:
            showIndent(outfile, level)
            outfile.write('CLR_Runtime_Header=model_.PEDataDirectoryStructType(\n')
            self.CLR_Runtime_Header.exportLiteral(outfile, level, name_='CLR_Runtime_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Reserved is not None:
            showIndent(outfile, level)
            outfile.write('Reserved=model_.PEDataDirectoryStructType(\n')
            self.Reserved.exportLiteral(outfile, level, name_='Reserved')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Export_Table':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Export_Table(obj_)
        elif nodeName_ == 'Import_Table':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Import_Table(obj_)
        elif nodeName_ == 'Resource_Table':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Resource_Table(obj_)
        elif nodeName_ == 'Exception_Table':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Exception_Table(obj_)
        elif nodeName_ == 'Certificate_Table':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Certificate_Table(obj_)
        elif nodeName_ == 'Base_Relocation_Table':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Base_Relocation_Table(obj_)
        elif nodeName_ == 'Debug':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Debug(obj_)
        elif nodeName_ == 'Architecture':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Architecture(obj_)
        elif nodeName_ == 'Global_Ptr':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Global_Ptr(obj_)
        elif nodeName_ == 'TLS_Table':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_TLS_Table(obj_)
        elif nodeName_ == 'Load_Config_Table':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Load_Config_Table(obj_)
        elif nodeName_ == 'Bound_Import':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Bound_Import(obj_)
        elif nodeName_ == 'Import_Address_Table':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Import_Address_Table(obj_)
        elif nodeName_ == 'Delay_Import_Descriptor':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Delay_Import_Descriptor(obj_)
        elif nodeName_ == 'CLR_Runtime_Header':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_CLR_Runtime_Header(obj_)
        elif nodeName_ == 'Reserved':
            obj_ = PEDataDirectoryStructType.factory()
            obj_.build(child_)
            self.set_Reserved(obj_)
# end class DataDirectoryType

class SectionType(cybox_common_types_1_0.BaseObjectAttributeType):
    """SectionTypes specifies PE section types via a union of the
    SectionTypeEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(SectionType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if SectionType.subclass:
            return SectionType.subclass(*args_, **kwargs_)
        else:
            return SectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='SectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SectionType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='SectionType'):
        super(SectionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SectionType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='SectionType', fromsubclass_=False, pretty_print=True):
        super(SectionType, self).exportChildren(outfile, level, 'WinExecutableFileObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(SectionType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(SectionType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SectionType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(SectionType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SectionType

class PEType(cybox_common_types_1_0.BaseObjectAttributeType):
    """PEType specifies PE file types via a union of the PETypeEnum type
    and the atomic xs:string type. Its base type is the CybOX Core
    cybox_common_types_1_0.BaseObjectAttributeType, for permitting complex (i.e. regular-
    expression based) specifications.This attribute is optional and
    specifies the expected type for the value of the specified
    element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(PEType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if PEType.subclass:
            return PEType.subclass(*args_, **kwargs_)
        else:
            return PEType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='PEType'):
        super(PEType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PEType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='PEType', fromsubclass_=False, pretty_print=True):
        super(PEType, self).exportChildren(outfile, level, 'WinExecutableFileObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(PEType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(PEType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(PEType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(PEType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class PEType

class DetectedType(cybox_common_types_1_0.BaseObjectAttributeType):
    """DetectedType specifies the type of entrypoint that was detected via
    a union of the DetectedTypeEnum type and the atomic xs:string
    type. Its base type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType,
    for permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(DetectedType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if DetectedType.subclass:
            return DetectedType.subclass(*args_, **kwargs_)
        else:
            return DetectedType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='DetectedType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DetectedType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='DetectedType'):
        super(DetectedType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DetectedType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='DetectedType', fromsubclass_=False, pretty_print=True):
        super(DetectedType, self).exportChildren(outfile, level, 'WinExecutableFileObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(DetectedType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DetectedType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(DetectedType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DetectedType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(DetectedType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DetectedType

class SubsystemType(cybox_common_types_1_0.BaseObjectAttributeType):
    """SubsystemTypes specifies subsystem types via a union of the
    SubsystemTypeEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(SubsystemType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if SubsystemType.subclass:
            return SubsystemType.subclass(*args_, **kwargs_)
        else:
            return SubsystemType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='SubsystemType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SubsystemType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='SubsystemType'):
        super(SubsystemType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SubsystemType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='SubsystemType', fromsubclass_=False, pretty_print=True):
        super(SubsystemType, self).exportChildren(outfile, level, 'WinExecutableFileObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(SubsystemType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SubsystemType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(SubsystemType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SubsystemType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(SubsystemType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SubsystemType

class WindowsExecutableFileObjectType(win_file_object_1_3.WindowsFileObjectType):
    """The WindowsExecutableFileObjectType type is intended to characterize
    Windows PE (Portable Executable) files."""
    subclass = None
    superclass = win_file_object_1_3.WindowsFileObjectType
    def __init__(self, object_reference=None, is_packed=None, File_Name=None, File_Path=None, Device_Path=None, Full_Path=None, File_Extension=None, Size_In_Bytes=None, Magic_Number=None, File_Format=None, Hashes=None, Digital_Signatures=None, Modified_Time=None, Accessed_Time=None, Created_Time=None, File_Attributes_List=None, Permissions=None, User_Owner=None, Packer_List=None, Peak_Entropy=None, Sym_Links=None, Byte_Runs=None, Filename_Accessed_Time=None, Filename_Created_Time=None, Filename_Modified_Time=None, Drive=None, Security_ID=None, Security_Type=None, Stream_List=None, Peak_Code_Entropy=None, PE_Attributes=None):
        super(WindowsExecutableFileObjectType, self).__init__(object_reference, is_packed, File_Name, File_Path, Device_Path, Full_Path, File_Extension, Size_In_Bytes, Magic_Number, File_Format, Hashes, Digital_Signatures, Modified_Time, Accessed_Time, Created_Time, File_Attributes_List, Permissions, User_Owner, Packer_List, Peak_Entropy, Sym_Links, Byte_Runs, Filename_Accessed_Time, Filename_Created_Time, Filename_Modified_Time, Drive, Security_ID, Security_Type, Stream_List, )
        self.Peak_Code_Entropy = Peak_Code_Entropy
        self.PE_Attributes = PE_Attributes
    def factory(*args_, **kwargs_):
        if WindowsExecutableFileObjectType.subclass:
            return WindowsExecutableFileObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsExecutableFileObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Peak_Code_Entropy(self): return self.Peak_Code_Entropy
    def set_Peak_Code_Entropy(self, Peak_Code_Entropy): self.Peak_Code_Entropy = Peak_Code_Entropy
    def get_PE_Attributes(self): return self.PE_Attributes
    def set_PE_Attributes(self, PE_Attributes): self.PE_Attributes = PE_Attributes
    def export(self, outfile, level, namespace_='WinExecutableFileObj:', name_='WindowsExecutableFileObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsExecutableFileObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinExecutableFileObj:', name_='WindowsExecutableFileObjectType'):
        super(WindowsExecutableFileObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsExecutableFileObjectType')
    def exportChildren(self, outfile, level, namespace_='WinExecutableFileObj:', name_='WindowsExecutableFileObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsExecutableFileObjectType, self).exportChildren(outfile, level, 'WinExecutableFileObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Peak_Code_Entropy is not None:
            self.Peak_Code_Entropy.export(outfile, level, 'WinExecutableFileObj:', name_='Peak_Code_Entropy', pretty_print=pretty_print)
        if self.PE_Attributes is not None:
            self.PE_Attributes.export(outfile, level, 'WinExecutableFileObj:', name_='PE_Attributes', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Peak_Code_Entropy is not None or
            self.PE_Attributes is not None or
            super(WindowsExecutableFileObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsExecutableFileObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsExecutableFileObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsExecutableFileObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Peak_Code_Entropy is not None:
            showIndent(outfile, level)
            outfile.write('Peak_Code_Entropy=model_.EntropyType(\n')
            self.Peak_Code_Entropy.exportLiteral(outfile, level, name_='Peak_Code_Entropy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PE_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('PE_Attributes=model_.PEAttributesType(\n')
            self.PE_Attributes.exportLiteral(outfile, level, name_='PE_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsExecutableFileObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Peak_Code_Entropy':
            obj_ = EntropyType.factory()
            obj_.build(child_)
            self.set_Peak_Code_Entropy(obj_)
        elif nodeName_ == 'PE_Attributes':
            obj_ = PEAttributesType.factory()
            obj_.build(child_)
            self.set_PE_Attributes(obj_)
        super(WindowsExecutableFileObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsExecutableFileObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Executable_File'
        rootClass = WindowsExecutableFileObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Executable_File'
        rootClass = WindowsExecutableFileObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Executable_File",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Executable_File'
        rootClass = WindowsExecutableFileObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsExecutableFileObjectType",
    "PEAttributesType",
    "PEChecksumType",
    "PEExportsType",
    "PEExportedFunctionsType",
    "StringListType",
    "EPJumpCodeType",
    "EntryPointSignatureType",
    "EntryPointSignatureListType",
    "PESectionListType",
    "EntropyType",
    "PEStringType",
    "PEImportType",
    "PEImportedFunctionsType",
    "PEResourceType",
    "PEVersionInfoResourceType",
    "PEExportedFunctionType",
    "PEResourceListType",
    "PEImportedFunctionType",
    "PEImportListType",
    "PESectionType",
    "PEDataDirectoryStructType",
    "PESectionHeaderStructType",
    "DOSHeaderType",
    "PEHeadersType",
    "PEFileHeaderType",
    "SubsystemType",
    "DetectedType",
    "PEType",
    "SectionType",
    "PEOptionalHeaderType",
    "DataDirectoryType"
    ]