#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:04:19 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import win_handle_object_1_3
import memory_object_1_2
import process_object_1_3
import cybox_common_types_1_0

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class MemorySectionListType(GeneratedsSuper):
    """The MemorySectionListType type specifies a list of memory sections
    used by the process."""
    subclass = None
    superclass = None
    def __init__(self, Memory_Section=None):
        if Memory_Section is None:
            self.Memory_Section = []
        else:
            self.Memory_Section = Memory_Section
    def factory(*args_, **kwargs_):
        if MemorySectionListType.subclass:
            return MemorySectionListType.subclass(*args_, **kwargs_)
        else:
            return MemorySectionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Memory_Section(self): return self.Memory_Section
    def set_Memory_Section(self, Memory_Section): self.Memory_Section = Memory_Section
    def add_Memory_Section(self, value): self.Memory_Section.append(value)
    def insert_Memory_Section(self, index, value): self.Memory_Section[index] = value
    def export(self, outfile, level, namespace_='WinProcessObj:', name_='MemorySectionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MemorySectionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinProcessObj:', name_='MemorySectionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinProcessObj:', name_='MemorySectionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Memory_Section_ in self.Memory_Section:
            Memory_Section_.export(outfile, level, 'WinProcessObj:', name_='Memory_Section', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Memory_Section
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MemorySectionListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Memory_Section=[\n')
        level += 1
        for Memory_Section_ in self.Memory_Section:
            showIndent(outfile, level)
            outfile.write('model_.memory_object_1_2.MemoryObjectType(\n')
            Memory_Section_.exportLiteral(outfile, level, name_='memory_object_1_2.MemoryObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Memory_Section':
            obj_ = memory_object_1_2.MemoryObjectType.factory()
            obj_.build(child_)
            self.Memory_Section.append(obj_)
# end class MemorySectionListType

class StartupInfoType(GeneratedsSuper):
    """The StartupInfoType type encapsulates the information contained in
    the STARTUPINFO struct for the process."""
    subclass = None
    superclass = None
    def __init__(self, lpDesktop=None, lpTitle=None, dwX=None, dwY=None, dwXSize=None, dwYSize=None, dwXCountChars=None, dwYCountChars=None, dwFillAttribute=None, dwFlags=None, wShowWindow=None, hStdInput=None, hStdOutput=None, hStdError=None):
        self.lpDesktop = lpDesktop
        self.lpTitle = lpTitle
        self.dwX = dwX
        self.dwY = dwY
        self.dwXSize = dwXSize
        self.dwYSize = dwYSize
        self.dwXCountChars = dwXCountChars
        self.dwYCountChars = dwYCountChars
        self.dwFillAttribute = dwFillAttribute
        self.dwFlags = dwFlags
        self.wShowWindow = wShowWindow
        self.hStdInput = hStdInput
        self.hStdOutput = hStdOutput
        self.hStdError = hStdError
    def factory(*args_, **kwargs_):
        if StartupInfoType.subclass:
            return StartupInfoType.subclass(*args_, **kwargs_)
        else:
            return StartupInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_lpDesktop(self): return self.lpDesktop
    def set_lpDesktop(self, lpDesktop): self.lpDesktop = lpDesktop
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_lpTitle(self): return self.lpTitle
    def set_lpTitle(self, lpTitle): self.lpTitle = lpTitle
    def get_dwX(self): return self.dwX
    def set_dwX(self, dwX): self.dwX = dwX
    def validate_IntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.IntegerObjectAttributeType, a restriction on None.
        pass
    def get_dwY(self): return self.dwY
    def set_dwY(self, dwY): self.dwY = dwY
    def get_dwXSize(self): return self.dwXSize
    def set_dwXSize(self, dwXSize): self.dwXSize = dwXSize
    def validate_PositiveIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.PositiveIntegerObjectAttributeType, a restriction on None.
        pass
    def get_dwYSize(self): return self.dwYSize
    def set_dwYSize(self, dwYSize): self.dwYSize = dwYSize
    def get_dwXCountChars(self): return self.dwXCountChars
    def set_dwXCountChars(self, dwXCountChars): self.dwXCountChars = dwXCountChars
    def get_dwYCountChars(self): return self.dwYCountChars
    def set_dwYCountChars(self, dwYCountChars): self.dwYCountChars = dwYCountChars
    def get_dwFillAttribute(self): return self.dwFillAttribute
    def set_dwFillAttribute(self, dwFillAttribute): self.dwFillAttribute = dwFillAttribute
    def get_dwFlags(self): return self.dwFlags
    def set_dwFlags(self, dwFlags): self.dwFlags = dwFlags
    def get_wShowWindow(self): return self.wShowWindow
    def set_wShowWindow(self, wShowWindow): self.wShowWindow = wShowWindow
    def get_hStdInput(self): return self.hStdInput
    def set_hStdInput(self, hStdInput): self.hStdInput = hStdInput
    def get_hStdOutput(self): return self.hStdOutput
    def set_hStdOutput(self, hStdOutput): self.hStdOutput = hStdOutput
    def get_hStdError(self): return self.hStdError
    def set_hStdError(self, hStdError): self.hStdError = hStdError
    def export(self, outfile, level, namespace_='WinProcessObj:', name_='StartupInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StartupInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinProcessObj:', name_='StartupInfoType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinProcessObj:', name_='StartupInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.lpDesktop is not None:
            self.lpDesktop.export(outfile, level, 'WinProcessObj:', name_='lpDesktop', pretty_print=pretty_print)
        if self.lpTitle is not None:
            self.lpTitle.export(outfile, level, 'WinProcessObj:', name_='lpTitle', pretty_print=pretty_print)
        if self.dwX is not None:
            self.dwX.export(outfile, level, 'WinProcessObj:', name_='dwX', pretty_print=pretty_print)
        if self.dwY is not None:
            self.dwY.export(outfile, level, 'WinProcessObj:', name_='dwY', pretty_print=pretty_print)
        if self.dwXSize is not None:
            self.dwXSize.export(outfile, level, 'WinProcessObj:', name_='dwXSize', pretty_print=pretty_print)
        if self.dwYSize is not None:
            self.dwYSize.export(outfile, level, 'WinProcessObj:', name_='dwYSize', pretty_print=pretty_print)
        if self.dwXCountChars is not None:
            self.dwXCountChars.export(outfile, level, 'WinProcessObj:', name_='dwXCountChars', pretty_print=pretty_print)
        if self.dwYCountChars is not None:
            self.dwYCountChars.export(outfile, level, 'WinProcessObj:', name_='dwYCountChars', pretty_print=pretty_print)
        if self.dwFillAttribute is not None:
            self.dwFillAttribute.export(outfile, level, 'WinProcessObj:', name_='dwFillAttribute', pretty_print=pretty_print)
        if self.dwFlags is not None:
            self.dwFlags.export(outfile, level, 'WinProcessObj:', name_='dwFlags', pretty_print=pretty_print)
        if self.wShowWindow is not None:
            self.wShowWindow.export(outfile, level, 'WinProcessObj:', name_='wShowWindow', pretty_print=pretty_print)
        if self.hStdInput is not None:
            self.hStdInput.export(outfile, level, 'WinProcessObj:', name_='hStdInput', pretty_print=pretty_print)
        if self.hStdOutput is not None:
            self.hStdOutput.export(outfile, level, 'WinProcessObj:', name_='hStdOutput', pretty_print=pretty_print)
        if self.hStdError is not None:
            self.hStdError.export(outfile, level, 'WinProcessObj:', name_='hStdError', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.lpDesktop is not None or
            self.lpTitle is not None or
            self.dwX is not None or
            self.dwY is not None or
            self.dwXSize is not None or
            self.dwYSize is not None or
            self.dwXCountChars is not None or
            self.dwYCountChars is not None or
            self.dwFillAttribute is not None or
            self.dwFlags is not None or
            self.wShowWindow is not None or
            self.hStdInput is not None or
            self.hStdOutput is not None or
            self.hStdError is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StartupInfoType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.lpDesktop is not None:
            showIndent(outfile, level)
            outfile.write('lpDesktop=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.lpDesktop.exportLiteral(outfile, level, name_='lpDesktop')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.lpTitle is not None:
            showIndent(outfile, level)
            outfile.write('lpTitle=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.lpTitle.exportLiteral(outfile, level, name_='lpTitle')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dwX is not None:
            showIndent(outfile, level)
            outfile.write('dwX=model_.cybox_common_types_1_0.IntegerObjectAttributeType(\n')
            self.dwX.exportLiteral(outfile, level, name_='dwX')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dwY is not None:
            showIndent(outfile, level)
            outfile.write('dwY=model_.cybox_common_types_1_0.IntegerObjectAttributeType(\n')
            self.dwY.exportLiteral(outfile, level, name_='dwY')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dwXSize is not None:
            showIndent(outfile, level)
            outfile.write('dwXSize=model_.cybox_common_types_1_0.PositiveIntegerObjectAttributeType(\n')
            self.dwXSize.exportLiteral(outfile, level, name_='dwXSize')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dwYSize is not None:
            showIndent(outfile, level)
            outfile.write('dwYSize=model_.cybox_common_types_1_0.PositiveIntegerObjectAttributeType(\n')
            self.dwYSize.exportLiteral(outfile, level, name_='dwYSize')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dwXCountChars is not None:
            showIndent(outfile, level)
            outfile.write('dwXCountChars=model_.cybox_common_types_1_0.PositiveIntegerObjectAttributeType(\n')
            self.dwXCountChars.exportLiteral(outfile, level, name_='dwXCountChars')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dwYCountChars is not None:
            showIndent(outfile, level)
            outfile.write('dwYCountChars=model_.cybox_common_types_1_0.PositiveIntegerObjectAttributeType(\n')
            self.dwYCountChars.exportLiteral(outfile, level, name_='dwYCountChars')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dwFillAttribute is not None:
            showIndent(outfile, level)
            outfile.write('dwFillAttribute=model_.cybox_common_types_1_0.IntegerObjectAttributeType(\n')
            self.dwFillAttribute.exportLiteral(outfile, level, name_='dwFillAttribute')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dwFlags is not None:
            showIndent(outfile, level)
            outfile.write('dwFlags=model_.cybox_common_types_1_0.IntegerObjectAttributeType(\n')
            self.dwFlags.exportLiteral(outfile, level, name_='dwFlags')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.wShowWindow is not None:
            showIndent(outfile, level)
            outfile.write('wShowWindow=model_.cybox_common_types_1_0.IntegerObjectAttributeType(\n')
            self.wShowWindow.exportLiteral(outfile, level, name_='wShowWindow')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hStdInput is not None:
            showIndent(outfile, level)
            outfile.write('hStdInput=model_.win_handle_object_1_3.WindowsHandleObjectType(\n')
            self.hStdInput.exportLiteral(outfile, level, name_='hStdInput')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hStdOutput is not None:
            showIndent(outfile, level)
            outfile.write('hStdOutput=model_.win_handle_object_1_3.WindowsHandleObjectType(\n')
            self.hStdOutput.exportLiteral(outfile, level, name_='hStdOutput')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hStdError is not None:
            showIndent(outfile, level)
            outfile.write('hStdError=model_.win_handle_object_1_3.WindowsHandleObjectType(\n')
            self.hStdError.exportLiteral(outfile, level, name_='hStdError')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'lpDesktop':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_lpDesktop(obj_)
        elif nodeName_ == 'lpTitle':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_lpTitle(obj_)
        elif nodeName_ == 'dwX':
            obj_ = cybox_common_types_1_0.IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_dwX(obj_)
        elif nodeName_ == 'dwY':
            obj_ = cybox_common_types_1_0.IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_dwY(obj_)
        elif nodeName_ == 'dwXSize':
            obj_ = cybox_common_types_1_0.PositiveIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_dwXSize(obj_)
        elif nodeName_ == 'dwYSize':
            obj_ = cybox_common_types_1_0.PositiveIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_dwYSize(obj_)
        elif nodeName_ == 'dwXCountChars':
            obj_ = cybox_common_types_1_0.PositiveIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_dwXCountChars(obj_)
        elif nodeName_ == 'dwYCountChars':
            obj_ = cybox_common_types_1_0.PositiveIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_dwYCountChars(obj_)
        elif nodeName_ == 'dwFillAttribute':
            obj_ = cybox_common_types_1_0.IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_dwFillAttribute(obj_)
        elif nodeName_ == 'dwFlags':
            obj_ = cybox_common_types_1_0.IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_dwFlags(obj_)
        elif nodeName_ == 'wShowWindow':
            obj_ = cybox_common_types_1_0.IntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_wShowWindow(obj_)
        elif nodeName_ == 'hStdInput':
            obj_ = win_handle_object_1_3.WindowsHandleObjectType.factory()
            obj_.build(child_)
            self.set_hStdInput(obj_)
        elif nodeName_ == 'hStdOutput':
            obj_ = win_handle_object_1_3.WindowsHandleObjectType.factory()
            obj_.build(child_)
            self.set_hStdOutput(obj_)
        elif nodeName_ == 'hStdError':
            obj_ = win_handle_object_1_3.WindowsHandleObjectType.factory()
            obj_.build(child_)
            self.set_hStdError(obj_)
# end class StartupInfoType

class WindowsProcessObjectType(process_object_1_3.ProcessObjectType):
    """The WindowsProcessObjectType type is intended to characterize
    Windows processes.The aslr_enabled attribute specifies whether
    Address Space Layout Randomization (ASLR) is enabled for the
    process.The dep_enabled attribute specifies whether Data
    Execution Prevention (DEP) is enabled for the process."""
    subclass = None
    superclass = process_object_1_3.ProcessObjectType
    def __init__(self, object_reference=None, is_hidden=None, PID=None, Name=None, Creation_Time=None, Parent_PID=None, Child_PID_List=None, Image_Info=None, Argument_List=None, Environment_Variable_List=None, Kernel_Time=None, Port_List=None, Network_Connection_List=None, Start_Time=None, Status=None, String_List=None, Username=None, User_Time=None, aslr_enabled=None, dep_enabled=None, Handle_List=None, Priority=None, Section_List=None, Security_ID=None, Startup_Info=None, Security_Type=None, Window_Title=None):
        super(WindowsProcessObjectType, self).__init__(object_reference, is_hidden, PID, Name, Creation_Time, Parent_PID, Child_PID_List, Image_Info, Argument_List, Environment_Variable_List, Kernel_Time, Port_List, Network_Connection_List, Start_Time, Status, String_List, Username, User_Time, )
        self.aslr_enabled = _cast(bool, aslr_enabled)
        self.dep_enabled = _cast(bool, dep_enabled)
        self.Handle_List = Handle_List
        self.Priority = Priority
        self.Section_List = Section_List
        self.Security_ID = Security_ID
        self.Startup_Info = Startup_Info
        self.Security_Type = Security_Type
        self.Window_Title = Window_Title
    def factory(*args_, **kwargs_):
        if WindowsProcessObjectType.subclass:
            return WindowsProcessObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsProcessObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Handle_List(self): return self.Handle_List
    def set_Handle_List(self, Handle_List): self.Handle_List = Handle_List
    def get_Priority(self): return self.Priority
    def set_Priority(self, Priority): self.Priority = Priority
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Section_List(self): return self.Section_List
    def set_Section_List(self, Section_List): self.Section_List = Section_List
    def get_Security_ID(self): return self.Security_ID
    def set_Security_ID(self, Security_ID): self.Security_ID = Security_ID
    def get_Startup_Info(self): return self.Startup_Info
    def set_Startup_Info(self, Startup_Info): self.Startup_Info = Startup_Info
    def get_Security_Type(self): return self.Security_Type
    def set_Security_Type(self, Security_Type): self.Security_Type = Security_Type
    def validate_SIDType(self, value):
        # Validate type cybox_common_types_1_0.SIDType, a restriction on None.
        pass
    def get_Window_Title(self): return self.Window_Title
    def set_Window_Title(self, Window_Title): self.Window_Title = Window_Title
    def get_aslr_enabled(self): return self.aslr_enabled
    def set_aslr_enabled(self, aslr_enabled): self.aslr_enabled = aslr_enabled
    def get_dep_enabled(self): return self.dep_enabled
    def set_dep_enabled(self, dep_enabled): self.dep_enabled = dep_enabled
    def export(self, outfile, level, namespace_='WinProcessObj:', name_='WindowsProcessObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsProcessObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinProcessObj:', name_='WindowsProcessObjectType'):
        super(WindowsProcessObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsProcessObjectType')
        if self.aslr_enabled is not None and 'aslr_enabled' not in already_processed:
            already_processed.append('aslr_enabled')
            outfile.write(' aslr_enabled="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.aslr_enabled)), input_name='aslr_enabled'))
        if self.dep_enabled is not None and 'dep_enabled' not in already_processed:
            already_processed.append('dep_enabled')
            outfile.write(' dep_enabled="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.dep_enabled)), input_name='dep_enabled'))
    def exportChildren(self, outfile, level, namespace_='WinProcessObj:', name_='WindowsProcessObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsProcessObjectType, self).exportChildren(outfile, level, 'WinProcessObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Handle_List is not None:
            self.Handle_List.export(outfile, level, 'WinProcessObj:', name_='Handle_List', pretty_print=pretty_print)
        if self.Priority is not None:
            self.Priority.export(outfile, level, 'WinProcessObj:', name_='Priority', pretty_print=pretty_print)
        if self.Section_List is not None:
            self.Section_List.export(outfile, level, 'WinProcessObj:', name_='Section_List', pretty_print=pretty_print)
        if self.Security_ID is not None:
            self.Security_ID.export(outfile, level, 'WinProcessObj:', name_='Security_ID', pretty_print=pretty_print)
        if self.Startup_Info is not None:
            self.Startup_Info.export(outfile, level, 'WinProcessObj:', name_='Startup_Info', pretty_print=pretty_print)
        if self.Security_Type is not None:
            self.Security_Type.export(outfile, level, 'WinProcessObj:', name_='Security_Type', pretty_print=pretty_print)
        if self.Window_Title is not None:
            self.Window_Title.export(outfile, level, 'WinProcessObj:', name_='Window_Title', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Handle_List is not None or
            self.Priority is not None or
            self.Section_List is not None or
            self.Security_ID is not None or
            self.Startup_Info is not None or
            self.Security_Type is not None or
            self.Window_Title is not None or
            super(WindowsProcessObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsProcessObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.aslr_enabled is not None and 'aslr_enabled' not in already_processed:
            already_processed.append('aslr_enabled')
            showIndent(outfile, level)
            outfile.write('aslr_enabled = %s,\n' % (self.aslr_enabled,))
        if self.dep_enabled is not None and 'dep_enabled' not in already_processed:
            already_processed.append('dep_enabled')
            showIndent(outfile, level)
            outfile.write('dep_enabled = %s,\n' % (self.dep_enabled,))
        super(WindowsProcessObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsProcessObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Handle_List is not None:
            showIndent(outfile, level)
            outfile.write('Handle_List=model_.win_handle_object_1_3.WindowsHandleListType(\n')
            self.Handle_List.exportLiteral(outfile, level, name_='Handle_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Priority is not None:
            showIndent(outfile, level)
            outfile.write('Priority=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Priority.exportLiteral(outfile, level, name_='Priority')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Section_List is not None:
            showIndent(outfile, level)
            outfile.write('Section_List=model_.MemorySectionListType(\n')
            self.Section_List.exportLiteral(outfile, level, name_='Section_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Security_ID is not None:
            showIndent(outfile, level)
            outfile.write('Security_ID=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Security_ID.exportLiteral(outfile, level, name_='Security_ID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Startup_Info is not None:
            showIndent(outfile, level)
            outfile.write('Startup_Info=model_.StartupInfoType(\n')
            self.Startup_Info.exportLiteral(outfile, level, name_='Startup_Info')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Security_Type is not None:
            showIndent(outfile, level)
            outfile.write('Security_Type=model_.cybox_common_types_1_0.SIDType(\n')
            self.Security_Type.exportLiteral(outfile, level, name_='Security_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Window_Title is not None:
            showIndent(outfile, level)
            outfile.write('Window_Title=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Window_Title.exportLiteral(outfile, level, name_='Window_Title')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('aslr_enabled', node)
        if value is not None and 'aslr_enabled' not in already_processed:
            already_processed.append('aslr_enabled')
            if value in ('true', '1'):
                self.aslr_enabled = True
            elif value in ('false', '0'):
                self.aslr_enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('dep_enabled', node)
        if value is not None and 'dep_enabled' not in already_processed:
            already_processed.append('dep_enabled')
            if value in ('true', '1'):
                self.dep_enabled = True
            elif value in ('false', '0'):
                self.dep_enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(WindowsProcessObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Handle_List':
            obj_ = win_handle_object_1_3.WindowsHandleListType.factory()
            obj_.build(child_)
            self.set_Handle_List(obj_)
        elif nodeName_ == 'Priority':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Priority(obj_)
        elif nodeName_ == 'Section_List':
            obj_ = MemorySectionListType.factory()
            obj_.build(child_)
            self.set_Section_List(obj_)
        elif nodeName_ == 'Security_ID':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Security_ID(obj_)
        elif nodeName_ == 'Startup_Info':
            obj_ = StartupInfoType.factory()
            obj_.build(child_)
            self.set_Startup_Info(obj_)
        elif nodeName_ == 'Security_Type':
            obj_ = cybox_common_types_1_0.SIDType.factory()
            obj_.build(child_)
            self.set_Security_Type(obj_)
        elif nodeName_ == 'Window_Title':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Window_Title(obj_)
        super(WindowsProcessObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsProcessObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Process'
        rootClass = WindowsProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Process'
        rootClass = WindowsProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Process",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Process'
        rootClass = WindowsProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsProcessObjectType",
    "MemorySectionListType",
    "StartupInfoType"
    ]