#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:04:20 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0
import win_handle_object_1_3

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class RegistryValueType(GeneratedsSuper):
    """The RegistryValueType type is intended to characterize Windows
    registry Value name/data pairs."""
    subclass = None
    superclass = None
    def __init__(self, Name=None, Data=None, Datatype=None, Byte_Runs=None):
        self.Name = Name
        self.Data = Data
        self.Datatype = Datatype
        self.Byte_Runs = Byte_Runs
    def factory(*args_, **kwargs_):
        if RegistryValueType.subclass:
            return RegistryValueType.subclass(*args_, **kwargs_)
        else:
            return RegistryValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Data(self): return self.Data
    def set_Data(self, Data): self.Data = Data
    def get_Datatype(self): return self.Datatype
    def set_Datatype(self, Datatype): self.Datatype = Datatype
    def validate_RegistryDatatypeType(self, value):
        # Validate type RegistryDatatypeType, a restriction on None.
        pass
    def get_Byte_Runs(self): return self.Byte_Runs
    def set_Byte_Runs(self, Byte_Runs): self.Byte_Runs = Byte_Runs
    def export(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='RegistryValueType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RegistryValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinRegistryKeyObj:', name_='RegistryValueType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='RegistryValueType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            self.Name.export(outfile, level, 'WinRegistryKeyObj:', name_='Name', pretty_print=pretty_print)
        if self.Data is not None:
            self.Data.export(outfile, level, 'WinRegistryKeyObj:', name_='Data', pretty_print=pretty_print)
        if self.Datatype is not None:
            self.Datatype.export(outfile, level, 'WinRegistryKeyObj:', name_='Datatype', pretty_print=pretty_print)
        if self.Byte_Runs is not None:
            self.Byte_Runs.export(outfile, level, 'WinRegistryKeyObj:', name_='Byte_Runs', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Data is not None or
            self.Datatype is not None or
            self.Byte_Runs is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RegistryValueType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data is not None:
            showIndent(outfile, level)
            outfile.write('Data=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Data.exportLiteral(outfile, level, name_='Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Datatype is not None:
            showIndent(outfile, level)
            outfile.write('Datatype=model_.RegistryDatatypeType(\n')
            self.Datatype.exportLiteral(outfile, level, name_='Datatype')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Byte_Runs is not None:
            showIndent(outfile, level)
            outfile.write('Byte_Runs=model_.cybox_common_types_1_0.ByteRunsType(\n')
            self.Byte_Runs.exportLiteral(outfile, level, name_='Byte_Runs')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Data':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Data(obj_)
        elif nodeName_ == 'Datatype':
            obj_ = RegistryDatatypeType.factory()
            obj_.build(child_)
            self.set_Datatype(obj_)
        elif nodeName_ == 'Byte_Runs':
            obj_ = cybox_common_types_1_0.ByteRunsType.factory()
            obj_.build(child_)
            self.set_Byte_Runs(obj_)
# end class RegistryValueType

class RegistryValuesType(GeneratedsSuper):
    """The RegistryValuesType type specifies the values (with their
    name/data pairs) held within the registry key."""
    subclass = None
    superclass = None
    def __init__(self, Value=None):
        if Value is None:
            self.Value = []
        else:
            self.Value = Value
    def factory(*args_, **kwargs_):
        if RegistryValuesType.subclass:
            return RegistryValuesType.subclass(*args_, **kwargs_)
        else:
            return RegistryValuesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def add_Value(self, value): self.Value.append(value)
    def insert_Value(self, index, value): self.Value[index] = value
    def export(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='RegistryValuesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RegistryValuesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinRegistryKeyObj:', name_='RegistryValuesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='RegistryValuesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Value_ in self.Value:
            Value_.export(outfile, level, 'WinRegistryKeyObj:', name_='Value', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Value
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RegistryValuesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Value=[\n')
        level += 1
        for Value_ in self.Value:
            showIndent(outfile, level)
            outfile.write('model_.RegistryValueType(\n')
            Value_.exportLiteral(outfile, level, name_='RegistryValueType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            obj_ = RegistryValueType.factory()
            obj_.build(child_)
            self.Value.append(obj_)
# end class RegistryValuesType

class RegistrySubkeysType(GeneratedsSuper):
    """The RegistrySubkeysType specifies the set of subkeys contained under
    the registry key."""
    subclass = None
    superclass = None
    def __init__(self, Subkey=None):
        if Subkey is None:
            self.Subkey = []
        else:
            self.Subkey = Subkey
    def factory(*args_, **kwargs_):
        if RegistrySubkeysType.subclass:
            return RegistrySubkeysType.subclass(*args_, **kwargs_)
        else:
            return RegistrySubkeysType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Subkey(self): return self.Subkey
    def set_Subkey(self, Subkey): self.Subkey = Subkey
    def add_Subkey(self, value): self.Subkey.append(value)
    def insert_Subkey(self, index, value): self.Subkey[index] = value
    def export(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='RegistrySubkeysType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RegistrySubkeysType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinRegistryKeyObj:', name_='RegistrySubkeysType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='RegistrySubkeysType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Subkey_ in self.Subkey:
            Subkey_.export(outfile, level, 'WinRegistryKeyObj:', name_='Subkey', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Subkey
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RegistrySubkeysType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Subkey=[\n')
        level += 1
        for Subkey_ in self.Subkey:
            showIndent(outfile, level)
            outfile.write('model_.WindowsRegistryKeyObjectType(\n')
            Subkey_.exportLiteral(outfile, level, name_='WindowsRegistryKeyObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Subkey':
            obj_ = WindowsRegistryKeyObjectType.factory()
            obj_.build(child_)
            self.Subkey.append(obj_)
# end class RegistrySubkeysType

class RegistryHiveType(cybox_common_types_1_0.BaseObjectAttributeType):
    """RegistryHiveType specifies Windows registry hive types via a union
    of the RegistryHiveEnum type and the atomic xs:string type. Its
    base type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for
    permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(RegistryHiveType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if RegistryHiveType.subclass:
            return RegistryHiveType.subclass(*args_, **kwargs_)
        else:
            return RegistryHiveType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='RegistryHiveType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RegistryHiveType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinRegistryKeyObj:', name_='RegistryHiveType'):
        super(RegistryHiveType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RegistryHiveType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='RegistryHiveType', fromsubclass_=False, pretty_print=True):
        super(RegistryHiveType, self).exportChildren(outfile, level, 'WinRegistryKeyObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(RegistryHiveType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RegistryHiveType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(RegistryHiveType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RegistryHiveType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(RegistryHiveType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class RegistryHiveType

class RegistryDatatypeType(cybox_common_types_1_0.BaseObjectAttributeType):
    """Registry_Datatype specifies Windows registry datatypes via a union
    of the RegistryDataTypesEnum type and the atomic xs:string type.
    Its base type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for
    permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(RegistryDatatypeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if RegistryDatatypeType.subclass:
            return RegistryDatatypeType.subclass(*args_, **kwargs_)
        else:
            return RegistryDatatypeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='RegistryDatatypeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RegistryDatatypeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinRegistryKeyObj:', name_='RegistryDatatypeType'):
        super(RegistryDatatypeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RegistryDatatypeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='RegistryDatatypeType', fromsubclass_=False, pretty_print=True):
        super(RegistryDatatypeType, self).exportChildren(outfile, level, 'WinRegistryKeyObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(RegistryDatatypeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RegistryDatatypeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(RegistryDatatypeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RegistryDatatypeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(RegistryDatatypeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class RegistryDatatypeType

class WindowsRegistryKeyObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The WindowsRegistryObjectType type is intended to characterize
    Windows registry objects, including Keys and Key/Value pairs."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, Key=None, Hive=None, Number_Values=None, Values=None, Modified_Time=None, Creator_Username=None, Handle_List=None, Number_Subkeys=None, Subkeys=None, Byte_Runs=None):
        super(WindowsRegistryKeyObjectType, self).__init__(object_reference, )
        self.Key = Key
        self.Hive = Hive
        self.Number_Values = Number_Values
        self.Values = Values
        self.Modified_Time = Modified_Time
        self.Creator_Username = Creator_Username
        self.Handle_List = Handle_List
        self.Number_Subkeys = Number_Subkeys
        self.Subkeys = Subkeys
        self.Byte_Runs = Byte_Runs
    def factory(*args_, **kwargs_):
        if WindowsRegistryKeyObjectType.subclass:
            return WindowsRegistryKeyObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsRegistryKeyObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Key(self): return self.Key
    def set_Key(self, Key): self.Key = Key
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Hive(self): return self.Hive
    def set_Hive(self, Hive): self.Hive = Hive
    def validate_RegistryHiveType(self, value):
        # Validate type RegistryHiveType, a restriction on None.
        pass
    def get_Number_Values(self): return self.Number_Values
    def set_Number_Values(self, Number_Values): self.Number_Values = Number_Values
    def validate_UnsignedIntegerObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.UnsignedIntegerObjectAttributeType, a restriction on None.
        pass
    def get_Values(self): return self.Values
    def set_Values(self, Values): self.Values = Values
    def get_Modified_Time(self): return self.Modified_Time
    def set_Modified_Time(self, Modified_Time): self.Modified_Time = Modified_Time
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_Creator_Username(self): return self.Creator_Username
    def set_Creator_Username(self, Creator_Username): self.Creator_Username = Creator_Username
    def get_Handle_List(self): return self.Handle_List
    def set_Handle_List(self, Handle_List): self.Handle_List = Handle_List
    def get_Number_Subkeys(self): return self.Number_Subkeys
    def set_Number_Subkeys(self, Number_Subkeys): self.Number_Subkeys = Number_Subkeys
    def get_Subkeys(self): return self.Subkeys
    def set_Subkeys(self, Subkeys): self.Subkeys = Subkeys
    def get_Byte_Runs(self): return self.Byte_Runs
    def set_Byte_Runs(self, Byte_Runs): self.Byte_Runs = Byte_Runs
    def export(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='WindowsRegistryKeyObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsRegistryKeyObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinRegistryKeyObj:', name_='WindowsRegistryKeyObjectType'):
        super(WindowsRegistryKeyObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsRegistryKeyObjectType')
    def exportChildren(self, outfile, level, namespace_='WinRegistryKeyObj:', name_='WindowsRegistryKeyObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsRegistryKeyObjectType, self).exportChildren(outfile, level, 'WinRegistryKeyObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Key is not None:
            self.Key.export(outfile, level, 'WinRegistryKeyObj:', name_='Key', pretty_print=pretty_print)
        if self.Hive is not None:
            self.Hive.export(outfile, level, 'WinRegistryKeyObj:', name_='Hive', pretty_print=pretty_print)
        if self.Number_Values is not None:
            self.Number_Values.export(outfile, level, 'WinRegistryKeyObj:', name_='Number_Values', pretty_print=pretty_print)
        if self.Values is not None:
            self.Values.export(outfile, level, 'WinRegistryKeyObj:', name_='Values', pretty_print=pretty_print)
        if self.Modified_Time is not None:
            self.Modified_Time.export(outfile, level, 'WinRegistryKeyObj:', name_='Modified_Time', pretty_print=pretty_print)
        if self.Creator_Username is not None:
            self.Creator_Username.export(outfile, level, 'WinRegistryKeyObj:', name_='Creator_Username', pretty_print=pretty_print)
        if self.Handle_List is not None:
            self.Handle_List.export(outfile, level, 'WinRegistryKeyObj:', name_='Handle_List', pretty_print=pretty_print)
        if self.Number_Subkeys is not None:
            self.Number_Subkeys.export(outfile, level, 'WinRegistryKeyObj:', name_='Number_Subkeys', pretty_print=pretty_print)
        if self.Subkeys is not None:
            self.Subkeys.export(outfile, level, 'WinRegistryKeyObj:', name_='Subkeys', pretty_print=pretty_print)
        if self.Byte_Runs is not None:
            self.Byte_Runs.export(outfile, level, 'WinRegistryKeyObj:', name_='Byte_Runs', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Key is not None or
            self.Hive is not None or
            self.Number_Values is not None or
            self.Values is not None or
            self.Modified_Time is not None or
            self.Creator_Username is not None or
            self.Handle_List is not None or
            self.Number_Subkeys is not None or
            self.Subkeys is not None or
            self.Byte_Runs is not None or
            super(WindowsRegistryKeyObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsRegistryKeyObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsRegistryKeyObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsRegistryKeyObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Key is not None:
            showIndent(outfile, level)
            outfile.write('Key=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Key.exportLiteral(outfile, level, name_='Key')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hive is not None:
            showIndent(outfile, level)
            outfile.write('Hive=model_.RegistryHiveType(\n')
            self.Hive.exportLiteral(outfile, level, name_='Hive')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Values is not None:
            showIndent(outfile, level)
            outfile.write('Number_Values=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.Number_Values.exportLiteral(outfile, level, name_='Number_Values')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Values is not None:
            showIndent(outfile, level)
            outfile.write('Values=model_.RegistryValuesType(\n')
            self.Values.exportLiteral(outfile, level, name_='Values')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Modified_Time is not None:
            showIndent(outfile, level)
            outfile.write('Modified_Time=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Modified_Time.exportLiteral(outfile, level, name_='Modified_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Creator_Username is not None:
            showIndent(outfile, level)
            outfile.write('Creator_Username=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Creator_Username.exportLiteral(outfile, level, name_='Creator_Username')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Handle_List is not None:
            showIndent(outfile, level)
            outfile.write('Handle_List=model_.win_handle_object_1_3.WindowsHandleListType(\n')
            self.Handle_List.exportLiteral(outfile, level, name_='Handle_List')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Subkeys is not None:
            showIndent(outfile, level)
            outfile.write('Number_Subkeys=model_.cybox_common_types_1_0.UnsignedIntegerObjectAttributeType(\n')
            self.Number_Subkeys.exportLiteral(outfile, level, name_='Number_Subkeys')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Subkeys is not None:
            showIndent(outfile, level)
            outfile.write('Subkeys=model_.RegistrySubkeysType(\n')
            self.Subkeys.exportLiteral(outfile, level, name_='Subkeys')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Byte_Runs is not None:
            showIndent(outfile, level)
            outfile.write('Byte_Runs=model_.cybox_common_types_1_0.ByteRunsType(\n')
            self.Byte_Runs.exportLiteral(outfile, level, name_='Byte_Runs')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsRegistryKeyObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Key':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Key(obj_)
        elif nodeName_ == 'Hive':
            obj_ = RegistryHiveType.factory()
            obj_.build(child_)
            self.set_Hive(obj_)
        elif nodeName_ == 'Number_Values':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Number_Values(obj_)
        elif nodeName_ == 'Values':
            obj_ = RegistryValuesType.factory()
            obj_.build(child_)
            self.set_Values(obj_)
        elif nodeName_ == 'Modified_Time':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Modified_Time(obj_)
        elif nodeName_ == 'Creator_Username':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Creator_Username(obj_)
        elif nodeName_ == 'Handle_List':
            obj_ = win_handle_object_1_3.WindowsHandleListType.factory()
            obj_.build(child_)
            self.set_Handle_List(obj_)
        elif nodeName_ == 'Number_Subkeys':
            obj_ = cybox_common_types_1_0.UnsignedIntegerObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Number_Subkeys(obj_)
        elif nodeName_ == 'Subkeys':
            obj_ = RegistrySubkeysType.factory()
            obj_.build(child_)
            self.set_Subkeys(obj_)
        elif nodeName_ == 'Byte_Runs':
            obj_ = cybox_common_types_1_0.ByteRunsType.factory()
            obj_.build(child_)
            self.set_Byte_Runs(obj_)
        super(WindowsRegistryKeyObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsRegistryKeyObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Registry_Key'
        rootClass = WindowsRegistryKeyObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Registry_Key'
        rootClass = WindowsRegistryKeyObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Registry_Key",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Registry_Key'
        rootClass = WindowsRegistryKeyObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsRegistryKeyObjectType",
    "RegistryValueType",
    "RegistryDatatypeType",
    "RegistryHiveType",
    "RegistryValuesType",
    "RegistrySubkeysType"
    ]