#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue Nov 06 14:04:26 2012 by generateDS.py version 2.7c.
#

import sys
import getopt
import re as re_

import cybox_common_types_1_0

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    if Verbose_import_:
        print('Error: LXML version 2.3+ required for parsing files')

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class HiveListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hive=None):
        if Hive is None:
            self.Hive = []
        else:
            self.Hive = Hive
    def factory(*args_, **kwargs_):
        if HiveListType.subclass:
            return HiveListType.subclass(*args_, **kwargs_)
        else:
            return HiveListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hive(self): return self.Hive
    def set_Hive(self, Hive): self.Hive = Hive
    def add_Hive(self, value): self.Hive.append(value)
    def insert_Hive(self, index, value): self.Hive[index] = value
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def export(self, outfile, level, namespace_='WinSystemRestoreObj:', name_='HiveListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HiveListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinSystemRestoreObj:', name_='HiveListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinSystemRestoreObj:', name_='HiveListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Hive_ in self.Hive:
            Hive_.export(outfile, level, 'WinSystemRestoreObj:', name_='Hive', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Hive
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HiveListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hive=[\n')
        level += 1
        for Hive_ in self.Hive:
            showIndent(outfile, level)
            outfile.write('model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            Hive_.exportLiteral(outfile, level, name_='cybox_common_types_1_0.StringObjectAttributeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hive':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.Hive.append(obj_)
# end class HiveListType

class ChangeLogEntryTypeType(cybox_common_types_1_0.BaseObjectAttributeType):
    """ChangeLogEntryTypeType types, via a union of the
    ChangeLogEntryTypeEnum type and the atomic xs:string type. Its
    base type is the CybOX Core cybox_common_types_1_0.BaseObjectAttributeType, for
    permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified element."""
    subclass = None
    superclass = cybox_common_types_1_0.BaseObjectAttributeType
    def __init__(self, end_range=None, pattern_type=None, has_changed=None, value_set=None, datatype='String', refanging_transform=None, refanging_transform_type=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, obfuscation_algorithm_ref=None, start_range=None, idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(ChangeLogEntryTypeType, self).__init__(end_range, pattern_type, has_changed, value_set, datatype, refanging_transform, refanging_transform_type, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, obfuscation_algorithm_ref, start_range, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ChangeLogEntryTypeType.subclass:
            return ChangeLogEntryTypeType.subclass(*args_, **kwargs_)
        else:
            return ChangeLogEntryTypeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='WinSystemRestoreObj:', name_='ChangeLogEntryTypeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChangeLogEntryTypeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinSystemRestoreObj:', name_='ChangeLogEntryTypeType'):
        super(ChangeLogEntryTypeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChangeLogEntryTypeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinSystemRestoreObj:', name_='ChangeLogEntryTypeType', fromsubclass_=False, pretty_print=True):
        super(ChangeLogEntryTypeType, self).exportChildren(outfile, level, 'WinSystemRestoreObj:', name_, True, pretty_print=pretty_print)
        pass
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(ChangeLogEntryTypeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ChangeLogEntryTypeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(ChangeLogEntryTypeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ChangeLogEntryTypeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        super(ChangeLogEntryTypeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ChangeLogEntryTypeType

class WindowsSystemRestoreObjectType(cybox_common_types_1_0.DefinedObjectType):
    """The WindowsSystemRestoreObjectType is intended to characterize
    Windows system restore points."""
    subclass = None
    superclass = cybox_common_types_1_0.DefinedObjectType
    def __init__(self, object_reference=None, Restore_Point_Description=None, Restore_Point_Full_Path=None, Restore_Point_Name=None, Restore_Point_Type=None, ACL_Change_SID=None, ACL_Change_Username=None, Backup_File_Name=None, Change_Event=None, ChangeLog_Entry_Flags=None, ChangeLog_Entry_Sequence_Number=None, ChangeLog_Entry_Type=None, Change_Log_File_Name=None, Created=None, File_Attributes=None, New_File_Name=None, Original_File_Name=None, Original_Short_File_Name=None, Process_Name=None, Registry_Hive_List=None):
        super(WindowsSystemRestoreObjectType, self).__init__(object_reference, )
        self.Restore_Point_Description = Restore_Point_Description
        self.Restore_Point_Full_Path = Restore_Point_Full_Path
        self.Restore_Point_Name = Restore_Point_Name
        self.Restore_Point_Type = Restore_Point_Type
        self.ACL_Change_SID = ACL_Change_SID
        self.ACL_Change_Username = ACL_Change_Username
        self.Backup_File_Name = Backup_File_Name
        self.Change_Event = Change_Event
        self.ChangeLog_Entry_Flags = ChangeLog_Entry_Flags
        self.ChangeLog_Entry_Sequence_Number = ChangeLog_Entry_Sequence_Number
        self.ChangeLog_Entry_Type = ChangeLog_Entry_Type
        self.Change_Log_File_Name = Change_Log_File_Name
        self.Created = Created
        self.File_Attributes = File_Attributes
        self.New_File_Name = New_File_Name
        self.Original_File_Name = Original_File_Name
        self.Original_Short_File_Name = Original_Short_File_Name
        self.Process_Name = Process_Name
        self.Registry_Hive_List = Registry_Hive_List
    def factory(*args_, **kwargs_):
        if WindowsSystemRestoreObjectType.subclass:
            return WindowsSystemRestoreObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsSystemRestoreObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Restore_Point_Description(self): return self.Restore_Point_Description
    def set_Restore_Point_Description(self, Restore_Point_Description): self.Restore_Point_Description = Restore_Point_Description
    def validate_StringObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.StringObjectAttributeType, a restriction on None.
        pass
    def get_Restore_Point_Full_Path(self): return self.Restore_Point_Full_Path
    def set_Restore_Point_Full_Path(self, Restore_Point_Full_Path): self.Restore_Point_Full_Path = Restore_Point_Full_Path
    def get_Restore_Point_Name(self): return self.Restore_Point_Name
    def set_Restore_Point_Name(self, Restore_Point_Name): self.Restore_Point_Name = Restore_Point_Name
    def get_Restore_Point_Type(self): return self.Restore_Point_Type
    def set_Restore_Point_Type(self, Restore_Point_Type): self.Restore_Point_Type = Restore_Point_Type
    def get_ACL_Change_SID(self): return self.ACL_Change_SID
    def set_ACL_Change_SID(self, ACL_Change_SID): self.ACL_Change_SID = ACL_Change_SID
    def get_ACL_Change_Username(self): return self.ACL_Change_Username
    def set_ACL_Change_Username(self, ACL_Change_Username): self.ACL_Change_Username = ACL_Change_Username
    def get_Backup_File_Name(self): return self.Backup_File_Name
    def set_Backup_File_Name(self, Backup_File_Name): self.Backup_File_Name = Backup_File_Name
    def get_Change_Event(self): return self.Change_Event
    def set_Change_Event(self, Change_Event): self.Change_Event = Change_Event
    def validate_ChangeLogEntryTypeType(self, value):
        # Validate type ChangeLogEntryTypeType, a restriction on None.
        pass
    def get_ChangeLog_Entry_Flags(self): return self.ChangeLog_Entry_Flags
    def set_ChangeLog_Entry_Flags(self, ChangeLog_Entry_Flags): self.ChangeLog_Entry_Flags = ChangeLog_Entry_Flags
    def get_ChangeLog_Entry_Sequence_Number(self): return self.ChangeLog_Entry_Sequence_Number
    def set_ChangeLog_Entry_Sequence_Number(self, ChangeLog_Entry_Sequence_Number): self.ChangeLog_Entry_Sequence_Number = ChangeLog_Entry_Sequence_Number
    def validate_LongObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.LongObjectAttributeType, a restriction on None.
        pass
    def get_ChangeLog_Entry_Type(self): return self.ChangeLog_Entry_Type
    def set_ChangeLog_Entry_Type(self, ChangeLog_Entry_Type): self.ChangeLog_Entry_Type = ChangeLog_Entry_Type
    def get_Change_Log_File_Name(self): return self.Change_Log_File_Name
    def set_Change_Log_File_Name(self, Change_Log_File_Name): self.Change_Log_File_Name = Change_Log_File_Name
    def get_Created(self): return self.Created
    def set_Created(self, Created): self.Created = Created
    def validate_DateTimeObjectAttributeType(self, value):
        # Validate type cybox_common_types_1_0.DateTimeObjectAttributeType, a restriction on None.
        pass
    def get_File_Attributes(self): return self.File_Attributes
    def set_File_Attributes(self, File_Attributes): self.File_Attributes = File_Attributes
    def get_New_File_Name(self): return self.New_File_Name
    def set_New_File_Name(self, New_File_Name): self.New_File_Name = New_File_Name
    def get_Original_File_Name(self): return self.Original_File_Name
    def set_Original_File_Name(self, Original_File_Name): self.Original_File_Name = Original_File_Name
    def get_Original_Short_File_Name(self): return self.Original_Short_File_Name
    def set_Original_Short_File_Name(self, Original_Short_File_Name): self.Original_Short_File_Name = Original_Short_File_Name
    def get_Process_Name(self): return self.Process_Name
    def set_Process_Name(self, Process_Name): self.Process_Name = Process_Name
    def get_Registry_Hive_List(self): return self.Registry_Hive_List
    def set_Registry_Hive_List(self, Registry_Hive_List): self.Registry_Hive_List = Registry_Hive_List
    def export(self, outfile, level, namespace_='WinSystemRestoreObj:', name_='WindowsSystemRestoreObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsSystemRestoreObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinSystemRestoreObj:', name_='WindowsSystemRestoreObjectType'):
        super(WindowsSystemRestoreObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsSystemRestoreObjectType')
    def exportChildren(self, outfile, level, namespace_='WinSystemRestoreObj:', name_='WindowsSystemRestoreObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsSystemRestoreObjectType, self).exportChildren(outfile, level, 'WinSystemRestoreObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Restore_Point_Description is not None:
            self.Restore_Point_Description.export(outfile, level, 'WinSystemRestoreObj:', name_='Restore_Point_Description', pretty_print=pretty_print)
        if self.Restore_Point_Full_Path is not None:
            self.Restore_Point_Full_Path.export(outfile, level, 'WinSystemRestoreObj:', name_='Restore_Point_Full_Path', pretty_print=pretty_print)
        if self.Restore_Point_Name is not None:
            self.Restore_Point_Name.export(outfile, level, 'WinSystemRestoreObj:', name_='Restore_Point_Name', pretty_print=pretty_print)
        if self.Restore_Point_Type is not None:
            self.Restore_Point_Type.export(outfile, level, 'WinSystemRestoreObj:', name_='Restore_Point_Type', pretty_print=pretty_print)
        if self.ACL_Change_SID is not None:
            self.ACL_Change_SID.export(outfile, level, 'WinSystemRestoreObj:', name_='ACL_Change_SID', pretty_print=pretty_print)
        if self.ACL_Change_Username is not None:
            self.ACL_Change_Username.export(outfile, level, 'WinSystemRestoreObj:', name_='ACL_Change_Username', pretty_print=pretty_print)
        if self.Backup_File_Name is not None:
            self.Backup_File_Name.export(outfile, level, 'WinSystemRestoreObj:', name_='Backup_File_Name', pretty_print=pretty_print)
        if self.Change_Event is not None:
            self.Change_Event.export(outfile, level, 'WinSystemRestoreObj:', name_='Change_Event', pretty_print=pretty_print)
        if self.ChangeLog_Entry_Flags is not None:
            self.ChangeLog_Entry_Flags.export(outfile, level, 'WinSystemRestoreObj:', name_='ChangeLog_Entry_Flags', pretty_print=pretty_print)
        if self.ChangeLog_Entry_Sequence_Number is not None:
            self.ChangeLog_Entry_Sequence_Number.export(outfile, level, 'WinSystemRestoreObj:', name_='ChangeLog_Entry_Sequence_Number', pretty_print=pretty_print)
        if self.ChangeLog_Entry_Type is not None:
            self.ChangeLog_Entry_Type.export(outfile, level, 'WinSystemRestoreObj:', name_='ChangeLog_Entry_Type', pretty_print=pretty_print)
        if self.Change_Log_File_Name is not None:
            self.Change_Log_File_Name.export(outfile, level, 'WinSystemRestoreObj:', name_='Change_Log_File_Name', pretty_print=pretty_print)
        if self.Created is not None:
            self.Created.export(outfile, level, 'WinSystemRestoreObj:', name_='Created', pretty_print=pretty_print)
        if self.File_Attributes is not None:
            self.File_Attributes.export(outfile, level, 'WinSystemRestoreObj:', name_='File_Attributes', pretty_print=pretty_print)
        if self.New_File_Name is not None:
            self.New_File_Name.export(outfile, level, 'WinSystemRestoreObj:', name_='New_File_Name', pretty_print=pretty_print)
        if self.Original_File_Name is not None:
            self.Original_File_Name.export(outfile, level, 'WinSystemRestoreObj:', name_='Original_File_Name', pretty_print=pretty_print)
        if self.Original_Short_File_Name is not None:
            self.Original_Short_File_Name.export(outfile, level, 'WinSystemRestoreObj:', name_='Original_Short_File_Name', pretty_print=pretty_print)
        if self.Process_Name is not None:
            self.Process_Name.export(outfile, level, 'WinSystemRestoreObj:', name_='Process_Name', pretty_print=pretty_print)
        if self.Registry_Hive_List is not None:
            self.Registry_Hive_List.export(outfile, level, 'WinSystemRestoreObj:', name_='Registry_Hive_List', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.Restore_Point_Description is not None or
            self.Restore_Point_Full_Path is not None or
            self.Restore_Point_Name is not None or
            self.Restore_Point_Type is not None or
            self.ACL_Change_SID is not None or
            self.ACL_Change_Username is not None or
            self.Backup_File_Name is not None or
            self.Change_Event is not None or
            self.ChangeLog_Entry_Flags is not None or
            self.ChangeLog_Entry_Sequence_Number is not None or
            self.ChangeLog_Entry_Type is not None or
            self.Change_Log_File_Name is not None or
            self.Created is not None or
            self.File_Attributes is not None or
            self.New_File_Name is not None or
            self.Original_File_Name is not None or
            self.Original_Short_File_Name is not None or
            self.Process_Name is not None or
            self.Registry_Hive_List is not None or
            super(WindowsSystemRestoreObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsSystemRestoreObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsSystemRestoreObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsSystemRestoreObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Restore_Point_Description is not None:
            showIndent(outfile, level)
            outfile.write('Restore_Point_Description=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Restore_Point_Description.exportLiteral(outfile, level, name_='Restore_Point_Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Restore_Point_Full_Path is not None:
            showIndent(outfile, level)
            outfile.write('Restore_Point_Full_Path=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Restore_Point_Full_Path.exportLiteral(outfile, level, name_='Restore_Point_Full_Path')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Restore_Point_Name is not None:
            showIndent(outfile, level)
            outfile.write('Restore_Point_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Restore_Point_Name.exportLiteral(outfile, level, name_='Restore_Point_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Restore_Point_Type is not None:
            showIndent(outfile, level)
            outfile.write('Restore_Point_Type=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Restore_Point_Type.exportLiteral(outfile, level, name_='Restore_Point_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ACL_Change_SID is not None:
            showIndent(outfile, level)
            outfile.write('ACL_Change_SID=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.ACL_Change_SID.exportLiteral(outfile, level, name_='ACL_Change_SID')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ACL_Change_Username is not None:
            showIndent(outfile, level)
            outfile.write('ACL_Change_Username=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.ACL_Change_Username.exportLiteral(outfile, level, name_='ACL_Change_Username')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Backup_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Backup_File_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Backup_File_Name.exportLiteral(outfile, level, name_='Backup_File_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Change_Event is not None:
            showIndent(outfile, level)
            outfile.write('Change_Event=model_.ChangeLogEntryTypeType(\n')
            self.Change_Event.exportLiteral(outfile, level, name_='Change_Event')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ChangeLog_Entry_Flags is not None:
            showIndent(outfile, level)
            outfile.write('ChangeLog_Entry_Flags=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.ChangeLog_Entry_Flags.exportLiteral(outfile, level, name_='ChangeLog_Entry_Flags')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ChangeLog_Entry_Sequence_Number is not None:
            showIndent(outfile, level)
            outfile.write('ChangeLog_Entry_Sequence_Number=model_.cybox_common_types_1_0.LongObjectAttributeType(\n')
            self.ChangeLog_Entry_Sequence_Number.exportLiteral(outfile, level, name_='ChangeLog_Entry_Sequence_Number')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ChangeLog_Entry_Type is not None:
            showIndent(outfile, level)
            outfile.write('ChangeLog_Entry_Type=model_.ChangeLogEntryTypeType(\n')
            self.ChangeLog_Entry_Type.exportLiteral(outfile, level, name_='ChangeLog_Entry_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Change_Log_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Change_Log_File_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Change_Log_File_Name.exportLiteral(outfile, level, name_='Change_Log_File_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Created is not None:
            showIndent(outfile, level)
            outfile.write('Created=model_.cybox_common_types_1_0.DateTimeObjectAttributeType(\n')
            self.Created.exportLiteral(outfile, level, name_='Created')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('File_Attributes=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.File_Attributes.exportLiteral(outfile, level, name_='File_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.New_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('New_File_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.New_File_Name.exportLiteral(outfile, level, name_='New_File_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Original_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Original_File_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Original_File_Name.exportLiteral(outfile, level, name_='Original_File_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Original_Short_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Original_Short_File_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Original_Short_File_Name.exportLiteral(outfile, level, name_='Original_Short_File_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Process_Name is not None:
            showIndent(outfile, level)
            outfile.write('Process_Name=model_.cybox_common_types_1_0.StringObjectAttributeType(\n')
            self.Process_Name.exportLiteral(outfile, level, name_='Process_Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Registry_Hive_List is not None:
            showIndent(outfile, level)
            outfile.write('Registry_Hive_List=model_.HiveListType(\n')
            self.Registry_Hive_List.exportLiteral(outfile, level, name_='Registry_Hive_List')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsSystemRestoreObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Restore_Point_Description':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Restore_Point_Description(obj_)
        elif nodeName_ == 'Restore_Point_Full_Path':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Restore_Point_Full_Path(obj_)
        elif nodeName_ == 'Restore_Point_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Restore_Point_Name(obj_)
        elif nodeName_ == 'Restore_Point_Type':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Restore_Point_Type(obj_)
        elif nodeName_ == 'ACL_Change_SID':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_ACL_Change_SID(obj_)
        elif nodeName_ == 'ACL_Change_Username':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_ACL_Change_Username(obj_)
        elif nodeName_ == 'Backup_File_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Backup_File_Name(obj_)
        elif nodeName_ == 'Change_Event':
            obj_ = ChangeLogEntryTypeType.factory()
            obj_.build(child_)
            self.set_Change_Event(obj_)
        elif nodeName_ == 'ChangeLog_Entry_Flags':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_ChangeLog_Entry_Flags(obj_)
        elif nodeName_ == 'ChangeLog_Entry_Sequence_Number':
            obj_ = cybox_common_types_1_0.LongObjectAttributeType.factory()
            obj_.build(child_)
            self.set_ChangeLog_Entry_Sequence_Number(obj_)
        elif nodeName_ == 'ChangeLog_Entry_Type':
            obj_ = ChangeLogEntryTypeType.factory()
            obj_.build(child_)
            self.set_ChangeLog_Entry_Type(obj_)
        elif nodeName_ == 'Change_Log_File_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Change_Log_File_Name(obj_)
        elif nodeName_ == 'Created':
            obj_ = cybox_common_types_1_0.DateTimeObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Created(obj_)
        elif nodeName_ == 'File_Attributes':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_File_Attributes(obj_)
        elif nodeName_ == 'New_File_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_New_File_Name(obj_)
        elif nodeName_ == 'Original_File_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Original_File_Name(obj_)
        elif nodeName_ == 'Original_Short_File_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Original_Short_File_Name(obj_)
        elif nodeName_ == 'Process_Name':
            obj_ = cybox_common_types_1_0.StringObjectAttributeType.factory()
            obj_.build(child_)
            self.set_Process_Name(obj_)
        elif nodeName_ == 'Registry_Hive_List':
            obj_ = HiveListType.factory()
            obj_.build(child_)
            self.set_Registry_Hive_List(obj_)
        super(WindowsSystemRestoreObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsSystemRestoreObjectType

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_System_Restore_Entry'
        rootClass = WindowsSystemRestoreObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_System_Restore_Entry'
        rootClass = WindowsSystemRestoreObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_System_Restore_Entry",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_System_Restore_Entry'
        rootClass = WindowsSystemRestoreObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsSystemRestoreObjectType",
    "HiveListType",
    "ChangeLogEntryTypeType"
    ]