#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2013, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

#
# Generated Tue Apr 09 11:10:07 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import cybox_common
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser(huge_tree=True)
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return unicode(s1).encode(ExternalEncoding)

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return unicode(s1).encode(ExternalEncoding)

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class FilePathType(cybox_common.StringObjectPropertyType):
    """The FilePathType type specifies the path to the file, not including
    the device. Whether the path is relative or fully-qualified can
    be specified via the 'fully_qualified' attribute.The
    fully_qualified field specifies whether the path is fully
    qualified."""
    member_data_items_ = {
        'fully_qualified': MemberSpec_('fully_qualified', 'xs:boolean', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None, extensiontype_=None, fully_qualified=None):
        super(FilePathType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, extensiontype_)
        self.fully_qualified = _cast(bool, fully_qualified)
        pass
    def factory(*args_, **kwargs_):
        if FilePathType.subclass:
            return FilePathType.subclass(*args_, **kwargs_)
        else:
            return FilePathType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fully_qualified(self): return self.fully_qualified
    def set_fully_qualified(self, fully_qualified): self.fully_qualified = fully_qualified
    def hasContent_(self):
        if (
            super(FilePathType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='FilePathType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FilePathType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(unicode(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='FilePathType'):
        super(FilePathType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FilePathType')
        if self.fully_qualified is not None and 'fully_qualified' not in already_processed:
            already_processed.add('fully_qualified')
            outfile.write(' fully_qualified="%s"' % self.gds_format_boolean(self.fully_qualified, input_name='fully_qualified'))
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='FilePathType', fromsubclass_=False, pretty_print=True):
        super(FilePathType, self).exportChildren(outfile, level, 'FileObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='FilePathType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.fully_qualified is not None and 'fully_qualified' not in already_processed:
            already_processed.add('fully_qualified')
            showIndent(outfile, level)
            outfile.write('fully_qualified = %s,\n' % (self.fully_qualified,))
        super(FilePathType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FilePathType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fully_qualified', node)
        if value is not None and 'fully_qualified' not in already_processed:
            already_processed.add('fully_qualified')
            if value in ('true', '1'):
                self.fully_qualified = True
            elif value in ('false', '0'):
                self.fully_qualified = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(FilePathType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FilePathType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class FilePathType

class FileAttributeType(GeneratedsSuper):
    """The FileAttributeType type specifies attribute(s) of a file. Since
    this Object property(ies) is platform-specific, it is defined
    here as an abstract type."""
    member_data_items_ = {
        }
    subclass = None
    superclass = None
    def __init__(self, xsi_type = None):
        self.xsi_type = xsi_type
    def factory(*args_, **kwargs_):
        if FileAttributeType.subclass:
            return FileAttributeType.subclass(*args_, **kwargs_)
        else:
            return FileAttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_xsi_type(self): return self.xsi_type
    def set_xsi_type(self, xsi_type): self.xsi_type = xsi_type
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='FileAttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FileAttributeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='FileAttributeType'):
        if self.xsi_type is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xsi:type="%s"' % self.xsi_type)
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='FileAttributeType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='FileAttributeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.xsi_type = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class FileAttributeType

class FilePermissionsType(GeneratedsSuper):
    """The FilePermissionsType type specifies a permission of a file. Since
    this is a platform-specific Object property, it is defined here
    as an abstract type and then implemented in any platform
    specific derived file objects."""
    member_data_items_ = {
        }
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if FilePermissionsType.subclass:
            return FilePermissionsType.subclass(*args_, **kwargs_)
        else:
            return FilePermissionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='FilePermissionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FilePermissionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='FilePermissionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='FilePermissionsType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='FilePermissionsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class FilePermissionsType

class PackerListType(GeneratedsSuper):
    """The PackerListType type specifies a list of file packers."""
    member_data_items_ = {
        'Packer': MemberSpec_('Packer', 'PackerType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Packer=None):
        if Packer is None:
            self.Packer = []
        else:
            self.Packer = Packer
    def factory(*args_, **kwargs_):
        if PackerListType.subclass:
            return PackerListType.subclass(*args_, **kwargs_)
        else:
            return PackerListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Packer(self): return self.Packer
    def set_Packer(self, Packer): self.Packer = Packer
    def add_Packer(self, value): self.Packer.append(value)
    def insert_Packer(self, index, value): self.Packer[index] = value
    def hasContent_(self):
        if (
            self.Packer
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='PackerListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PackerListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='PackerListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='PackerListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Packer_ in self.Packer:
            Packer_.export(outfile, level, 'FileObj:', name_='Packer', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PackerListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Packer=[\n')
        level += 1
        for Packer_ in self.Packer:
            outfile.write('model_.PackerType(\n')
            Packer_.exportLiteral(outfile, level, name_='PackerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Packer':
            obj_ = PackerType.factory()
            obj_.build(child_)
            self.Packer.append(obj_)
# end class PackerListType

class PackerType(GeneratedsSuper):
    """The PackerType specifies the fields that characterize a particular
    file packer, such as name and version."""
    member_data_items_ = {
        'Name': MemberSpec_('Name', 'cybox_common.StringObjectPropertyType', 0),
        'Version': MemberSpec_('Version', 'cybox_common.StringObjectPropertyType', 0),
        'Entry_Point': MemberSpec_('Entry_Point', 'cybox_common.HexBinaryObjectPropertyType', 0),
        'Signature': MemberSpec_('Signature', 'cybox_common.StringObjectPropertyType', 0),
        'Type': MemberSpec_('Type', 'PackerClassType', 0),
        'Detected_Entrypoint_Signatures': MemberSpec_('Detected_Entrypoint_Signatures', 'EntryPointSignatureListType', 0),
        'EP_Jump_Codes': MemberSpec_('EP_Jump_Codes', 'EPJumpCodeType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Name=None, Version=None, Entry_Point=None, Signature=None, Type=None, Detected_Entrypoint_Signatures=None, EP_Jump_Codes=None):
        self.Name = Name
        self.Version = Version
        self.Entry_Point = Entry_Point
        self.Signature = Signature
        self.Type = Type
        self.Detected_Entrypoint_Signatures = Detected_Entrypoint_Signatures
        self.EP_Jump_Codes = EP_Jump_Codes
    def factory(*args_, **kwargs_):
        if PackerType.subclass:
            return PackerType.subclass(*args_, **kwargs_)
        else:
            return PackerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_Entry_Point(self): return self.Entry_Point
    def set_Entry_Point(self, Entry_Point): self.Entry_Point = Entry_Point
    def validate_HexBinaryObjectPropertyType(self, value):
        # Validate type cybox_common.HexBinaryObjectPropertyType, a restriction on None.
        pass
    def get_Signature(self): return self.Signature
    def set_Signature(self, Signature): self.Signature = Signature
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_PackerClassType(self, value):
        # Validate type PackerClassType, a restriction on None.
        pass
    def get_Detected_Entrypoint_Signatures(self): return self.Detected_Entrypoint_Signatures
    def set_Detected_Entrypoint_Signatures(self, Detected_Entrypoint_Signatures): self.Detected_Entrypoint_Signatures = Detected_Entrypoint_Signatures
    def get_EP_Jump_Codes(self): return self.EP_Jump_Codes
    def set_EP_Jump_Codes(self, EP_Jump_Codes): self.EP_Jump_Codes = EP_Jump_Codes
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Version is not None or
            self.Entry_Point is not None or
            self.Signature is not None or
            self.Type is not None or
            self.Detected_Entrypoint_Signatures is not None or
            self.EP_Jump_Codes is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='PackerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PackerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='PackerType'):
        pass
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='PackerType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            self.Name.export(outfile, level, 'FileObj:', name_='Name', pretty_print=pretty_print)
        if self.Version is not None:
            self.Version.export(outfile, level, 'FileObj:', name_='Version', pretty_print=pretty_print)
        if self.Entry_Point is not None:
            self.Entry_Point.export(outfile, level, 'FileObj:', name_='Entry_Point', pretty_print=pretty_print)
        if self.Signature is not None:
            self.Signature.export(outfile, level, 'FileObj:', name_='Signature', pretty_print=pretty_print)
        if self.Type is not None:
            self.Type.export(outfile, level, 'FileObj:', name_='Type', pretty_print=pretty_print)
        if self.Detected_Entrypoint_Signatures is not None:
            self.Detected_Entrypoint_Signatures.export(outfile, level, 'FileObj:', name_='Detected_Entrypoint_Signatures', pretty_print=pretty_print)
        if self.EP_Jump_Codes is not None:
            self.EP_Jump_Codes.export(outfile, level, 'FileObj:', name_='EP_Jump_Codes', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PackerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            outfile.write('Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            outfile.write('),\n')
        if self.Version is not None:
            outfile.write('Version=model_.cybox_common.StringObjectPropertyType(\n')
            self.Version.exportLiteral(outfile, level, name_='Version')
            outfile.write('),\n')
        if self.Entry_Point is not None:
            outfile.write('Entry_Point=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Entry_Point.exportLiteral(outfile, level, name_='Entry_Point')
            outfile.write('),\n')
        if self.Signature is not None:
            outfile.write('Signature=model_.cybox_common.StringObjectPropertyType(\n')
            self.Signature.exportLiteral(outfile, level, name_='Signature')
            outfile.write('),\n')
        if self.Type is not None:
            outfile.write('Type=model_.PackerClassType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            outfile.write('),\n')
        if self.Detected_Entrypoint_Signatures is not None:
            outfile.write('Detected_Entrypoint_Signatures=model_.EntryPointSignatureListType(\n')
            self.Detected_Entrypoint_Signatures.exportLiteral(outfile, level, name_='Detected_Entrypoint_Signatures')
            outfile.write('),\n')
        if self.EP_Jump_Codes is not None:
            outfile.write('EP_Jump_Codes=model_.EPJumpCodeType(\n')
            self.EP_Jump_Codes.exportLiteral(outfile, level, name_='EP_Jump_Codes')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Version':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Version(obj_)
        elif nodeName_ == 'Entry_Point':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Entry_Point(obj_)
        elif nodeName_ == 'Signature':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Signature(obj_)
        elif nodeName_ == 'Type':
            obj_ = PackerClassType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
        elif nodeName_ == 'Detected_Entrypoint_Signatures':
            obj_ = EntryPointSignatureListType.factory()
            obj_.build(child_)
            self.set_Detected_Entrypoint_Signatures(obj_)
        elif nodeName_ == 'EP_Jump_Codes':
            obj_ = EPJumpCodeType.factory()
            obj_.build(child_)
            self.set_EP_Jump_Codes(obj_)
# end class PackerType

class EPJumpCodeType(GeneratedsSuper):
    """Specifies an entry-point jump code used by a packer."""
    member_data_items_ = {
        'Depth': MemberSpec_('Depth', 'cybox_common.IntegerObjectPropertyType', 0),
        'Opcodes': MemberSpec_('Opcodes', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Depth=None, Opcodes=None):
        self.Depth = Depth
        self.Opcodes = Opcodes
    def factory(*args_, **kwargs_):
        if EPJumpCodeType.subclass:
            return EPJumpCodeType.subclass(*args_, **kwargs_)
        else:
            return EPJumpCodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Depth(self): return self.Depth
    def set_Depth(self, Depth): self.Depth = Depth
    def validate_IntegerObjectPropertyType(self, value):
        # Validate type cybox_common.IntegerObjectPropertyType, a restriction on None.
        pass
    def get_Opcodes(self): return self.Opcodes
    def set_Opcodes(self, Opcodes): self.Opcodes = Opcodes
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.Depth is not None or
            self.Opcodes is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='EPJumpCodeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EPJumpCodeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='EPJumpCodeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='EPJumpCodeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Depth is not None:
            self.Depth.export(outfile, level, 'FileObj:', name_='Depth', pretty_print=pretty_print)
        if self.Opcodes is not None:
            self.Opcodes.export(outfile, level, 'FileObj:', name_='Opcodes', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EPJumpCodeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Depth is not None:
            outfile.write('Depth=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.Depth.exportLiteral(outfile, level, name_='Depth')
            outfile.write('),\n')
        if self.Opcodes is not None:
            outfile.write('Opcodes=model_.cybox_common.StringObjectPropertyType(\n')
            self.Opcodes.exportLiteral(outfile, level, name_='Opcodes')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Depth':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Depth(obj_)
        elif nodeName_ == 'Opcodes':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Opcodes(obj_)
# end class EPJumpCodeType

class EntryPointSignatureType(GeneratedsSuper):
    """Specifies an entry point signature for a packer."""
    member_data_items_ = {
        'Name': MemberSpec_('Name', 'cybox_common.StringObjectPropertyType', 0),
        'Type': MemberSpec_('Type', ['DetectedTypeEnum', 'xs:string'], 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Name=None, Type=None):
        self.Name = Name
        self.Type = Type
    def factory(*args_, **kwargs_):
        if EntryPointSignatureType.subclass:
            return EntryPointSignatureType.subclass(*args_, **kwargs_)
        else:
            return EntryPointSignatureType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_DetectedTypeEnum(self, value):
        # Validate type DetectedTypeEnum, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Type is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='EntryPointSignatureType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntryPointSignatureType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='EntryPointSignatureType'):
        pass
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='EntryPointSignatureType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            self.Name.export(outfile, level, 'FileObj:', name_='Name', pretty_print=pretty_print)
        if self.Type is not None:
            outfile.write('<%sType>%s</%sType>%s' % ('FileObj:', self.gds_format_string(quote_xml(self.Type).encode(ExternalEncoding), input_name='Type'), 'FileObj:', eol_))
    def exportLiteral(self, outfile, level, name_='EntryPointSignatureType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            outfile.write('Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            outfile.write('),\n')
        if self.Type is not None:
            outfile.write('Type=%s,\n' % quote_python(self.Type).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Type':
            obj_ = PackerClassType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
# end class EntryPointSignatureType

class EntryPointSignatureListType(GeneratedsSuper):
    """Species a list of entry point signatures for a packer."""
    member_data_items_ = {
        'Entry_Point_Signature': MemberSpec_('Entry_Point_Signature', 'EntryPointSignatureType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Entry_Point_Signature=None):
        if Entry_Point_Signature is None:
            self.Entry_Point_Signature = []
        else:
            self.Entry_Point_Signature = Entry_Point_Signature
    def factory(*args_, **kwargs_):
        if EntryPointSignatureListType.subclass:
            return EntryPointSignatureListType.subclass(*args_, **kwargs_)
        else:
            return EntryPointSignatureListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Entry_Point_Signature(self): return self.Entry_Point_Signature
    def set_Entry_Point_Signature(self, Entry_Point_Signature): self.Entry_Point_Signature = Entry_Point_Signature
    def add_Entry_Point_Signature(self, value): self.Entry_Point_Signature.append(value)
    def insert_Entry_Point_Signature(self, index, value): self.Entry_Point_Signature[index] = value
    def hasContent_(self):
        if (
            self.Entry_Point_Signature
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='EntryPointSignatureListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntryPointSignatureListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='EntryPointSignatureListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='EntryPointSignatureListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Entry_Point_Signature_ in self.Entry_Point_Signature:
            Entry_Point_Signature_.export(outfile, level, 'FileObj:', name_='Entry_Point_Signature', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntryPointSignatureListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Entry_Point_Signature=[\n')
        level += 1
        for Entry_Point_Signature_ in self.Entry_Point_Signature:
            outfile.write('model_.EntryPointSignatureType(\n')
            Entry_Point_Signature_.exportLiteral(outfile, level, name_='EntryPointSignatureType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Entry_Point_Signature':
            obj_ = EntryPointSignatureType.factory()
            obj_.build(child_)
            self.Entry_Point_Signature.append(obj_)
# end class EntryPointSignatureListType

class SymLinksListType(GeneratedsSuper):
    """The SymLinksListType specifies a list of symbolic links."""
    member_data_items_ = {
        'Sym_Link': MemberSpec_('Sym_Link', 'cybox_common.StringObjectPropertyType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Sym_Link=None):
        if Sym_Link is None:
            self.Sym_Link = []
        else:
            self.Sym_Link = Sym_Link
    def factory(*args_, **kwargs_):
        if SymLinksListType.subclass:
            return SymLinksListType.subclass(*args_, **kwargs_)
        else:
            return SymLinksListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Sym_Link(self): return self.Sym_Link
    def set_Sym_Link(self, Sym_Link): self.Sym_Link = Sym_Link
    def add_Sym_Link(self, value): self.Sym_Link.append(value)
    def insert_Sym_Link(self, index, value): self.Sym_Link[index] = value
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.Sym_Link
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='SymLinksListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SymLinksListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='SymLinksListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='SymLinksListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Sym_Link_ in self.Sym_Link:
            Sym_Link_.export(outfile, level, 'FileObj:', name_='Sym_Link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SymLinksListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Sym_Link=[\n')
        level += 1
        for Sym_Link_ in self.Sym_Link:
            outfile.write('model_.cybox_common.StringObjectPropertyType(\n')
            Sym_Link_.exportLiteral(outfile, level, name_='cybox_common.StringObjectPropertyType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Sym_Link':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.Sym_Link.append(obj_)
# end class SymLinksListType

class PackerClassType(cybox_common.BaseObjectPropertyType):
    """PackerCassType specifies packer classes, via a union of the
    PackerTypeEnum type and the atomic xs:string type. Its base type
    is the CybOX Core cybox_common.BaseObjectPropertyType, for permitting complex
    (i.e. regular-expression based) specifications.This field is
    optional and specifies the expected type for the value of the
    specified field."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['PackerClassType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(PackerClassType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if PackerClassType.subclass:
            return PackerClassType.subclass(*args_, **kwargs_)
        else:
            return PackerClassType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(PackerClassType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='PackerClassType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PackerClassType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(unicode(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='PackerClassType'):
        super(PackerClassType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PackerClassType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='PackerClassType', fromsubclass_=False, pretty_print=True):
        super(PackerClassType, self).exportChildren(outfile, level, 'FileObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='PackerClassType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(PackerClassType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(PackerClassType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(PackerClassType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class PackerClassType

class FileObjectType(cybox_common.ObjectPropertiesType):
    """The File_ObjectType type is intended to characterize generic
    files.The ispacked field is used to indicate whether the file is
    packed or not."""
    member_data_items_ = {
        'is_packed': MemberSpec_('is_packed', 'xs:boolean', 0),
        'File_Name': MemberSpec_('File_Name', 'cybox_common.StringObjectPropertyType', 0),
        'File_Path': MemberSpec_('File_Path', 'FilePathType', 0),
        'Device_Path': MemberSpec_('Device_Path', 'cybox_common.StringObjectPropertyType', 0),
        'Full_Path': MemberSpec_('Full_Path', 'cybox_common.StringObjectPropertyType', 0),
        'File_Extension': MemberSpec_('File_Extension', 'cybox_common.StringObjectPropertyType', 0),
        'Size_In_Bytes': MemberSpec_('Size_In_Bytes', 'cybox_common.UnsignedLongObjectPropertyType', 0),
        'Magic_Number': MemberSpec_('Magic_Number', 'cybox_common.HexBinaryObjectPropertyType', 0),
        'File_Format': MemberSpec_('File_Format', 'cybox_common.StringObjectPropertyType', 0),
        'Hashes': MemberSpec_('Hashes', 'cybox_common.HashListType', 0),
        'Digital_Signatures': MemberSpec_('Digital_Signatures', 'cybox_common.DigitalSignaturesType', 0),
        'Modified_Time': MemberSpec_('Modified_Time', 'cybox_common.StringObjectPropertyType', 0),
        'Accessed_Time': MemberSpec_('Accessed_Time', 'cybox_common.StringObjectPropertyType', 0),
        'Created_Time': MemberSpec_('Created_Time', 'cybox_common.DateTimeObjectPropertyType', 0),
        'File_Attributes_List': MemberSpec_('File_Attributes_List', 'FileAttributeType', 0),
        'Permissions': MemberSpec_('Permissions', 'FilePermissionsType', 0),
        'User_Owner': MemberSpec_('User_Owner', 'cybox_common.StringObjectPropertyType', 0),
        'Packer_List': MemberSpec_('Packer_List', 'PackerListType', 0),
        'Peak_Entropy': MemberSpec_('Peak_Entropy', 'cybox_common.DoubleObjectPropertyType', 0),
        'Sym_Links': MemberSpec_('Sym_Links', 'SymLinksListType', 0),
        'Byte_Runs': MemberSpec_('Byte_Runs', 'cybox_common.ByteRunsType', 0),
        'Extracted_Features': MemberSpec_('Extracted_Features', 'cybox_common.ExtractedFeaturesType', 0),
        }
    subclass = None
    superclass = cybox_common.ObjectPropertiesType
    def __init__(self, object_reference=None, Custom_Properties=None, xsi_type=None, is_packed=None, File_Name=None, File_Path=None, Device_Path=None, Full_Path=None, File_Extension=None, Size_In_Bytes=None, Magic_Number=None, File_Format=None, Hashes=None, Digital_Signatures=None, Modified_Time=None, Accessed_Time=None, Created_Time=None, File_Attributes_List=None, Permissions=None, User_Owner=None, Packer_List=None, Peak_Entropy=None, Sym_Links=None, Byte_Runs=None, Extracted_Features=None):
        super(FileObjectType, self).__init__(object_reference, Custom_Properties, xsi_type )
        self.is_packed = _cast(bool, is_packed)
        self.File_Name = File_Name
        self.File_Path = File_Path
        self.Device_Path = Device_Path
        self.Full_Path = Full_Path
        self.File_Extension = File_Extension
        self.Size_In_Bytes = Size_In_Bytes
        self.Magic_Number = Magic_Number
        self.File_Format = File_Format
        self.Hashes = Hashes
        self.Digital_Signatures = Digital_Signatures
        self.Modified_Time = Modified_Time
        self.Accessed_Time = Accessed_Time
        self.Created_Time = Created_Time
        self.File_Attributes_List = File_Attributes_List
        self.Permissions = Permissions
        self.User_Owner = User_Owner
        self.Packer_List = Packer_List
        self.Peak_Entropy = Peak_Entropy
        self.Sym_Links = Sym_Links
        self.Byte_Runs = Byte_Runs
        self.Extracted_Features = Extracted_Features
    def factory(*args_, **kwargs_):
        if FileObjectType.subclass:
            return FileObjectType.subclass(*args_, **kwargs_)
        else:
            return FileObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File_Name(self): return self.File_Name
    def set_File_Name(self, File_Name): self.File_Name = File_Name
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_File_Path(self): return self.File_Path
    def set_File_Path(self, File_Path): self.File_Path = File_Path
    def get_Device_Path(self): return self.Device_Path
    def set_Device_Path(self, Device_Path): self.Device_Path = Device_Path
    def get_Full_Path(self): return self.Full_Path
    def set_Full_Path(self, Full_Path): self.Full_Path = Full_Path
    def get_File_Extension(self): return self.File_Extension
    def set_File_Extension(self, File_Extension): self.File_Extension = File_Extension
    def get_Size_In_Bytes(self): return self.Size_In_Bytes
    def set_Size_In_Bytes(self, Size_In_Bytes): self.Size_In_Bytes = Size_In_Bytes
    def validate_UnsignedLongObjectPropertyType(self, value):
        # Validate type cybox_common.UnsignedLongObjectPropertyType, a restriction on None.
        pass
    def get_Magic_Number(self): return self.Magic_Number
    def set_Magic_Number(self, Magic_Number): self.Magic_Number = Magic_Number
    def validate_HexBinaryObjectPropertyType(self, value):
        # Validate type cybox_common.HexBinaryObjectPropertyType, a restriction on None.
        pass
    def get_File_Format(self): return self.File_Format
    def set_File_Format(self, File_Format): self.File_Format = File_Format
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Digital_Signatures(self): return self.Digital_Signatures
    def set_Digital_Signatures(self, Digital_Signatures): self.Digital_Signatures = Digital_Signatures
    def get_Modified_Time(self): return self.Modified_Time
    def set_Modified_Time(self, Modified_Time): self.Modified_Time = Modified_Time
    def get_Accessed_Time(self): return self.Accessed_Time
    def set_Accessed_Time(self, Accessed_Time): self.Accessed_Time = Accessed_Time
    def get_Created_Time(self): return self.Created_Time
    def set_Created_Time(self, Created_Time): self.Created_Time = Created_Time
    def validate_DateTimeObjectPropertyType(self, value):
        # Validate type cybox_common.DateTimeObjectPropertyType, a restriction on None.
        pass
    def get_File_Attributes_List(self): return self.File_Attributes_List
    def set_File_Attributes_List(self, File_Attributes_List): self.File_Attributes_List = File_Attributes_List
    def get_Permissions(self): return self.Permissions
    def set_Permissions(self, Permissions): self.Permissions = Permissions
    def get_User_Owner(self): return self.User_Owner
    def set_User_Owner(self, User_Owner): self.User_Owner = User_Owner
    def get_Packer_List(self): return self.Packer_List
    def set_Packer_List(self, Packer_List): self.Packer_List = Packer_List
    def get_Peak_Entropy(self): return self.Peak_Entropy
    def set_Peak_Entropy(self, Peak_Entropy): self.Peak_Entropy = Peak_Entropy
    def validate_DoubleObjectPropertyType(self, value):
        # Validate type cybox_common.DoubleObjectPropertyType, a restriction on None.
        pass
    def get_Sym_Links(self): return self.Sym_Links
    def set_Sym_Links(self, Sym_Links): self.Sym_Links = Sym_Links
    def get_Byte_Runs(self): return self.Byte_Runs
    def set_Byte_Runs(self, Byte_Runs): self.Byte_Runs = Byte_Runs
    def get_Extracted_Features(self): return self.Extracted_Features
    def set_Extracted_Features(self, Extracted_Features): self.Extracted_Features = Extracted_Features
    def get_is_packed(self): return self.is_packed
    def set_is_packed(self, is_packed): self.is_packed = is_packed
    def hasContent_(self):
        if (
            self.File_Name is not None or
            self.File_Path is not None or
            self.Device_Path is not None or
            self.Full_Path is not None or
            self.File_Extension is not None or
            self.Size_In_Bytes is not None or
            self.Magic_Number is not None or
            self.File_Format is not None or
            self.Hashes is not None or
            self.Digital_Signatures is not None or
            self.Modified_Time is not None or
            self.Accessed_Time is not None or
            self.Created_Time is not None or
            self.File_Attributes_List is not None or
            self.Permissions is not None or
            self.User_Owner is not None or
            self.Packer_List is not None or
            self.Peak_Entropy is not None or
            self.Sym_Links is not None or
            self.Byte_Runs is not None or
            self.Extracted_Features is not None or
            super(FileObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='FileObj:', name_='FileObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FileObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='FileObj:', name_='FileObjectType'):
        super(FileObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FileObjectType')
        if self.is_packed is not None and 'is_packed' not in already_processed:
            already_processed.add('is_packed')
            outfile.write(' is_packed="%s"' % self.gds_format_boolean(self.is_packed, input_name='is_packed'))
    def exportChildren(self, outfile, level, namespace_='FileObj:', name_='FileObjectType', fromsubclass_=False, pretty_print=True):
        super(FileObjectType, self).exportChildren(outfile, level, 'FileObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.File_Name is not None:
            self.File_Name.export(outfile, level, 'FileObj:', name_='File_Name', pretty_print=pretty_print)
        if self.File_Path is not None:
            self.File_Path.export(outfile, level, 'FileObj:', name_='File_Path', pretty_print=pretty_print)
        if self.Device_Path is not None:
            self.Device_Path.export(outfile, level, 'FileObj:', name_='Device_Path', pretty_print=pretty_print)
        if self.Full_Path is not None:
            self.Full_Path.export(outfile, level, 'FileObj:', name_='Full_Path', pretty_print=pretty_print)
        if self.File_Extension is not None:
            self.File_Extension.export(outfile, level, 'FileObj:', name_='File_Extension', pretty_print=pretty_print)
        if self.Size_In_Bytes is not None:
            self.Size_In_Bytes.export(outfile, level, 'FileObj:', name_='Size_In_Bytes', pretty_print=pretty_print)
        if self.Magic_Number is not None:
            self.Magic_Number.export(outfile, level, 'FileObj:', name_='Magic_Number', pretty_print=pretty_print)
        if self.File_Format is not None:
            self.File_Format.export(outfile, level, 'FileObj:', name_='File_Format', pretty_print=pretty_print)
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, 'FileObj:', name_='Hashes', pretty_print=pretty_print)
        if self.Digital_Signatures is not None:
            self.Digital_Signatures.export(outfile, level, 'FileObj:', name_='Digital_Signatures', pretty_print=pretty_print)
        if self.Modified_Time is not None:
            self.Modified_Time.export(outfile, level, 'FileObj:', name_='Modified_Time', pretty_print=pretty_print)
        if self.Accessed_Time is not None:
            self.Accessed_Time.export(outfile, level, 'FileObj:', name_='Accessed_Time', pretty_print=pretty_print)
        if self.Created_Time is not None:
            self.Created_Time.export(outfile, level, 'FileObj:', name_='Created_Time', pretty_print=pretty_print)
        if self.File_Attributes_List is not None:
            self.File_Attributes_List.export(outfile, level, 'FileObj:', name_='File_Attributes_List', pretty_print=pretty_print)
        if self.Permissions is not None:
            self.Permissions.export(outfile, level, 'FileObj:', name_='Permissions', pretty_print=pretty_print)
        if self.User_Owner is not None:
            self.User_Owner.export(outfile, level, 'FileObj:', name_='User_Owner', pretty_print=pretty_print)
        if self.Packer_List is not None:
            self.Packer_List.export(outfile, level, 'FileObj:', name_='Packer_List', pretty_print=pretty_print)
        if self.Peak_Entropy is not None:
            self.Peak_Entropy.export(outfile, level, 'FileObj:', name_='Peak_Entropy', pretty_print=pretty_print)
        if self.Sym_Links is not None:
            self.Sym_Links.export(outfile, level, 'FileObj:', name_='Sym_Links', pretty_print=pretty_print)
        if self.Byte_Runs is not None:
            self.Byte_Runs.export(outfile, level, 'FileObj:', name_='Byte_Runs', pretty_print=pretty_print)
        if self.Extracted_Features is not None:
            self.Extracted_Features.export(outfile, level, 'FileObj:', name_='Extracted_Features', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FileObjectType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_packed is not None and 'is_packed' not in already_processed:
            already_processed.add('is_packed')
            showIndent(outfile, level)
            outfile.write('is_packed = %s,\n' % (self.is_packed,))
        super(FileObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FileObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.File_Name is not None:
            outfile.write('File_Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.File_Name.exportLiteral(outfile, level, name_='File_Name')
            outfile.write('),\n')
        if self.File_Path is not None:
            outfile.write('File_Path=model_.FilePathType(\n')
            self.File_Path.exportLiteral(outfile, level, name_='File_Path')
            outfile.write('),\n')
        if self.Device_Path is not None:
            outfile.write('Device_Path=model_.cybox_common.StringObjectPropertyType(\n')
            self.Device_Path.exportLiteral(outfile, level, name_='Device_Path')
            outfile.write('),\n')
        if self.Full_Path is not None:
            outfile.write('Full_Path=model_.cybox_common.StringObjectPropertyType(\n')
            self.Full_Path.exportLiteral(outfile, level, name_='Full_Path')
            outfile.write('),\n')
        if self.File_Extension is not None:
            outfile.write('File_Extension=model_.cybox_common.StringObjectPropertyType(\n')
            self.File_Extension.exportLiteral(outfile, level, name_='File_Extension')
            outfile.write('),\n')
        if self.Size_In_Bytes is not None:
            outfile.write('Size_In_Bytes=model_.cybox_common.UnsignedLongObjectPropertyType(\n')
            self.Size_In_Bytes.exportLiteral(outfile, level, name_='Size_In_Bytes')
            outfile.write('),\n')
        if self.Magic_Number is not None:
            outfile.write('Magic_Number=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Magic_Number.exportLiteral(outfile, level, name_='Magic_Number')
            outfile.write('),\n')
        if self.File_Format is not None:
            outfile.write('File_Format=model_.cybox_common.StringObjectPropertyType(\n')
            self.File_Format.exportLiteral(outfile, level, name_='File_Format')
            outfile.write('),\n')
        if self.Hashes is not None:
            outfile.write('Hashes=model_.cybox_common.HashListType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            outfile.write('),\n')
        if self.Digital_Signatures is not None:
            outfile.write('Digital_Signatures=model_.cybox_common.DigitalSignaturesType(\n')
            self.Digital_Signatures.exportLiteral(outfile, level, name_='Digital_Signatures')
            outfile.write('),\n')
        if self.Modified_Time is not None:
            outfile.write('Modified_Time=model_.cybox_common.StringObjectPropertyType(\n')
            self.Modified_Time.exportLiteral(outfile, level, name_='Modified_Time')
            outfile.write('),\n')
        if self.Accessed_Time is not None:
            outfile.write('Accessed_Time=model_.cybox_common.StringObjectPropertyType(\n')
            self.Accessed_Time.exportLiteral(outfile, level, name_='Accessed_Time')
            outfile.write('),\n')
        if self.Created_Time is not None:
            outfile.write('Created_Time=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Created_Time.exportLiteral(outfile, level, name_='Created_Time')
            outfile.write('),\n')
        if self.FileAttributeType is not None:
            showIndent(outfile, level)
            outfile.write('FileAttributeType=model_.FileAttributeType(\n')
            self.FileAttributeType.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FilePermissionsType is not None:
            showIndent(outfile, level)
            outfile.write('FilePermissionsType=model_.FilePermissionsType(\n')
            self.FilePermissionsType.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.User_Owner is not None:
            outfile.write('User_Owner=model_.cybox_common.StringObjectPropertyType(\n')
            self.User_Owner.exportLiteral(outfile, level, name_='User_Owner')
            outfile.write('),\n')
        if self.Packer_List is not None:
            outfile.write('Packer_List=model_.PackerListType(\n')
            self.Packer_List.exportLiteral(outfile, level, name_='Packer_List')
            outfile.write('),\n')
        if self.Peak_Entropy is not None:
            outfile.write('Peak_Entropy=model_.cybox_common.DoubleObjectPropertyType(\n')
            self.Peak_Entropy.exportLiteral(outfile, level, name_='Peak_Entropy')
            outfile.write('),\n')
        if self.Sym_Links is not None:
            outfile.write('Sym_Links=model_.SymLinksListType(\n')
            self.Sym_Links.exportLiteral(outfile, level, name_='Sym_Links')
            outfile.write('),\n')
        if self.Byte_Runs is not None:
            outfile.write('Byte_Runs=model_.cybox_common.ByteRunsType(\n')
            self.Byte_Runs.exportLiteral(outfile, level, name_='Byte_Runs')
            outfile.write('),\n')
        if self.Extracted_Features is not None:
            outfile.write('Extracted_Features=model_.cybox_common.ExtractedFeaturesType(\n')
            self.Extracted_Features.exportLiteral(outfile, level, name_='Extracted_Features')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_packed', node)
        if value is not None and 'is_packed' not in already_processed:
            already_processed.add('is_packed')
            if value in ('true', '1'):
                self.is_packed = True
            elif value in ('false', '0'):
                self.is_packed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(FileObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File_Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_File_Name(obj_)
        elif nodeName_ == 'File_Path':
            obj_ = FilePathType.factory()
            obj_.build(child_)
            self.set_File_Path(obj_)
        elif nodeName_ == 'Device_Path':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Device_Path(obj_)
        elif nodeName_ == 'Full_Path':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Full_Path(obj_)
        elif nodeName_ == 'File_Extension':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_File_Extension(obj_)
        elif nodeName_ == 'Size_In_Bytes':
            obj_ = cybox_common.UnsignedLongObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Size_In_Bytes(obj_)
        elif nodeName_ == 'Magic_Number':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Magic_Number(obj_)
        elif nodeName_ == 'File_Format':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_File_Format(obj_)
        elif nodeName_ == 'Hashes':
            obj_ = cybox_common.HashListType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'Digital_Signatures':
            obj_ = cybox_common.DigitalSignaturesType.factory()
            obj_.build(child_)
            self.set_Digital_Signatures(obj_)
        elif nodeName_ == 'Modified_Time':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Modified_Time(obj_)
        elif nodeName_ == 'Accessed_Time':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Accessed_Time(obj_)
        elif nodeName_ == 'Created_Time':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Created_Time(obj_)
        elif nodeName_ == 'File_Attributes_List':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <File_Attributes_List> element')
            self.set_File_Attributes_List(obj_)
        elif nodeName_ == 'Permissions':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <Permissions> element')
            self.set_Permissions(obj_)
        elif nodeName_ == 'User_Owner':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_User_Owner(obj_)
        elif nodeName_ == 'Packer_List':
            obj_ = PackerListType.factory()
            obj_.build(child_)
            self.set_Packer_List(obj_)
        elif nodeName_ == 'Peak_Entropy':
            obj_ = cybox_common.DoubleObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Peak_Entropy(obj_)
        elif nodeName_ == 'Sym_Links':
            obj_ = SymLinksListType.factory()
            obj_.build(child_)
            self.set_Sym_Links(obj_)
        elif nodeName_ == 'Byte_Runs':
            obj_ = cybox_common.ByteRunsType.factory()
            obj_.build(child_)
            self.set_Byte_Runs(obj_)
        elif nodeName_ == 'Extracted_Features':
            obj_ = cybox_common.ExtractedFeaturesType.factory()
            obj_.build(child_)
            self.set_Extracted_Features(obj_)
        super(FileObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class FileObjectType

GDSClassesMapping = {
    'Build_Utility': cybox_common.BuildUtilityType,
    'Device_Path': cybox_common.StringObjectPropertyType,
    'File_Extension': cybox_common.StringObjectPropertyType,
    'Error': cybox_common.ErrorType,
    'Opcodes': cybox_common.StringObjectPropertyType,
    'Errors': cybox_common.ErrorsType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'Size_In_Bytes': cybox_common.UnsignedLongObjectPropertyType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'Byte_Runs': cybox_common.ByteRunsType,
    'SubDatum': cybox_common.MetadataType,
    'Segment_Hash': cybox_common.HashValueType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'Value': cybox_common.StringObjectPropertyType,
    'Length': cybox_common.IntegerObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'User_Owner': cybox_common.StringObjectPropertyType,
    'Functions': cybox_common.FunctionsType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'System': cybox_common.ObjectPropertiesType,
    'Platform': cybox_common.PlatformSpecificationType,
    'Version': cybox_common.StringObjectPropertyType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'Created_Time': cybox_common.DateTimeObjectPropertyType,
    'Extracted_Features': cybox_common.ExtractedFeaturesType,
    'Compilers': cybox_common.CompilersType,
    'Digital_Signatures': cybox_common.DigitalSignaturesType,
    'String': cybox_common.ExtractedStringType,
    'File_Format': cybox_common.StringObjectPropertyType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
    'Build_Information': cybox_common.BuildInformationType,
    'Tool_Hashes': cybox_common.HashListType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Signature': cybox_common.StringObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'Contributors': cybox_common.PersonnelType,
    'Reference_Description': cybox_common.StructuredTextType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'Instance': cybox_common.ObjectPropertiesType,
    'Import': cybox_common.StringObjectPropertyType,
    'Accessed_Time': cybox_common.StringObjectPropertyType,
    'Sym_Link': cybox_common.StringObjectPropertyType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Dependencies': cybox_common.DependenciesType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Date': cybox_common.DateRangeType,
    'Hashes': cybox_common.HashListType,
    'Segments': cybox_common.HashSegmentsType,
    'Language': cybox_common.StringObjectPropertyType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'Dependency': cybox_common.DependencyType,
    'Time': cybox_common.TimeType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'Byte_Run': cybox_common.ByteRunType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'Imports': cybox_common.ImportsType,
    'Library': cybox_common.LibraryType,
    'References': cybox_common.ToolReferencesType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'File_Name': cybox_common.StringObjectPropertyType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'Modified_Time': cybox_common.StringObjectPropertyType,
    'Libraries': cybox_common.LibrariesType,
    'Function': cybox_common.StringObjectPropertyType,
    'Description': cybox_common.StructuredTextType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'Type': cybox_common.ControlledVocabularyStringType,
    'Magic_Number': cybox_common.HexBinaryObjectPropertyType,
    'Address': cybox_common.HexBinaryObjectPropertyType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'Full_Path': cybox_common.StringObjectPropertyType,
    'Compiler': cybox_common.CompilerType,
    'Name': cybox_common.StringObjectPropertyType,
    'Depth': cybox_common.IntegerObjectPropertyType,
    'Entry_Point': cybox_common.HexBinaryObjectPropertyType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Data_Size': cybox_common.DataSizeType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'Contributor': cybox_common.ContributorType,
    'Peak_Entropy': cybox_common.DoubleObjectPropertyType,
    'Tools': cybox_common.ToolsInformationType,
    'Tool': cybox_common.ToolInformationType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'File'
        rootClass = FileObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_=rootTag,
#        namespacedef_='',
#        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'File'
        rootClass = FileObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'File'
        rootClass = FileObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_="File",
#        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'File'
        rootClass = FileObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "FileObjectType",
    "FilePathType",
    "FileAttributeType",
    "FilePermissionsType",
    "PackerListType",
    "PackerType",
    "PackerClassType",
    "EPJumpCodeType",
    "EntryPointSignatureType",
    "EntryPointSignatureListType",
    "SymLinksListType"
    ]
