#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Apr 09 11:10:18 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import cybox_common
import http_session_object
import dns_query_object
import socket_address_object
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class Layer7ConnectionsType(GeneratedsSuper):
    """The Layer7ConnectionsType specifies the different types of
    application (layer 7 in the OSI model) connections that may be
    initiated as part of the network connection."""
    member_data_items_ = {
        'HTTP_Session': MemberSpec_('HTTP_Session', 'http_session_object.HTTPSessionObjectType', 0),
        'DNS_Query': MemberSpec_('DNS_Query', 'dns_query_object.DNSQueryObjectType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, HTTP_Session=None, DNS_Query=None):
        self.HTTP_Session = HTTP_Session
        if DNS_Query is None:
            self.DNS_Query = []
        else:
            self.DNS_Query = DNS_Query
    def factory(*args_, **kwargs_):
        if Layer7ConnectionsType.subclass:
            return Layer7ConnectionsType.subclass(*args_, **kwargs_)
        else:
            return Layer7ConnectionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_HTTP_Session(self): return self.HTTP_Session
    def set_HTTP_Session(self, HTTP_Session): self.HTTP_Session = HTTP_Session
    def get_DNS_Query(self): return self.DNS_Query
    def set_DNS_Query(self, DNS_Query): self.DNS_Query = DNS_Query
    def add_DNS_Query(self, value): self.DNS_Query.append(value)
    def insert_DNS_Query(self, index, value): self.DNS_Query[index] = value
    def hasContent_(self):
        if (
            self.HTTP_Session is not None or
            self.DNS_Query
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer7ConnectionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Layer7ConnectionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='NetworkConnectionObj:', name_='Layer7ConnectionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer7ConnectionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.HTTP_Session is not None:
            self.HTTP_Session.export(outfile, level, 'NetworkConnectionObj:', name_='HTTP_Session', pretty_print=pretty_print)
        for DNS_Query_ in self.DNS_Query:
            DNS_Query_.export(outfile, level, 'NetworkConnectionObj:', name_='DNS_Query', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Layer7ConnectionsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.HTTP_Session is not None:
            outfile.write('HTTP_Session=model_.http_session_object.HTTPSessionObjectType(\n')
            self.HTTP_Session.exportLiteral(outfile, level, name_='HTTP_Session')
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('DNS_Query=[\n')
        level += 1
        for DNS_Query_ in self.DNS_Query:
            outfile.write('model_.dns_query_object.DNSQueryObjectType(\n')
            DNS_Query_.exportLiteral(outfile, level, name_='dns_query_object.DNSQueryObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'HTTP_Session':
            obj_ = http_session_object.HTTPSessionObjectType.factory()
            obj_.build(child_)
            self.set_HTTP_Session(obj_)
        elif nodeName_ == 'DNS_Query':
            obj_ = dns_query_object.DNSQueryObjectType.factory()
            obj_.build(child_)
            self.DNS_Query.append(obj_)
# end class Layer7ConnectionsType

class Layer4ProtocolType(cybox_common.BaseObjectPropertyType):
    """Layer4ProtocolType specifies Layer 4 (OSI model) protocols, via a
    union of the Layer4ProtocolEnum type and the atomic xs:string
    type. Its base type is the CybOX Core cybox_common.BaseObjectPropertyType,
    for permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['Layer4ProtocolType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(Layer4ProtocolType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Layer4ProtocolType.subclass:
            return Layer4ProtocolType.subclass(*args_, **kwargs_)
        else:
            return Layer4ProtocolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(Layer4ProtocolType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer4ProtocolType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Layer4ProtocolType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='NetworkConnectionObj:', name_='Layer4ProtocolType'):
        super(Layer4ProtocolType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Layer4ProtocolType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer4ProtocolType', fromsubclass_=False, pretty_print=True):
        super(Layer4ProtocolType, self).exportChildren(outfile, level, 'NetworkConnectionObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='Layer4ProtocolType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(Layer4ProtocolType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Layer4ProtocolType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(Layer4ProtocolType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Layer4ProtocolType

class Layer7ProtocolType(cybox_common.BaseObjectPropertyType):
    """Layer7ProtocolType specifies Layer 7 protocol types, via a union of
    the Layer7ProtocolEnum type and the atomic xs:string type. Its
    base type is the CybOX Core cybox_common.BaseObjectPropertyType, for
    permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['Layer7ProtocolType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(Layer7ProtocolType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Layer7ProtocolType.subclass:
            return Layer7ProtocolType.subclass(*args_, **kwargs_)
        else:
            return Layer7ProtocolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(Layer7ProtocolType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer7ProtocolType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Layer7ProtocolType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='NetworkConnectionObj:', name_='Layer7ProtocolType'):
        super(Layer7ProtocolType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Layer7ProtocolType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer7ProtocolType', fromsubclass_=False, pretty_print=True):
        super(Layer7ProtocolType, self).exportChildren(outfile, level, 'NetworkConnectionObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='Layer7ProtocolType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(Layer7ProtocolType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Layer7ProtocolType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(Layer7ProtocolType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Layer7ProtocolType

class Layer3ProtocolType(cybox_common.BaseObjectPropertyType):
    """Layer3ProtocolType specifies Layer 3 protocol types, via a union of
    the Layer3ProtocolEnum type and the atomic xs:string type. Its
    base type is the CybOX Core cybox_common.BaseObjectPropertyType, for
    permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['Layer3ProtocolType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(Layer3ProtocolType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Layer3ProtocolType.subclass:
            return Layer3ProtocolType.subclass(*args_, **kwargs_)
        else:
            return Layer3ProtocolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(Layer3ProtocolType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer3ProtocolType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Layer3ProtocolType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='NetworkConnectionObj:', name_='Layer3ProtocolType'):
        super(Layer3ProtocolType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Layer3ProtocolType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='NetworkConnectionObj:', name_='Layer3ProtocolType', fromsubclass_=False, pretty_print=True):
        super(Layer3ProtocolType, self).exportChildren(outfile, level, 'NetworkConnectionObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='Layer3ProtocolType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(Layer3ProtocolType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Layer3ProtocolType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(Layer3ProtocolType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Layer3ProtocolType

class NetworkConnectionObjectType(cybox_common.ObjectPropertiesType):
    """The NetworkConnectionObjectType is intended as a way of
    characterizing local or remote (i.e. Internet) network
    connections.The tls_used field specifies whether or not
    Transport Layer Security (TLS) is used in the network
    connection."""
    member_data_items_ = {
        'tls_used': MemberSpec_('tls_used', 'xs:boolean', 0),
        'Creation_Time': MemberSpec_('Creation_Time', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Layer3_Protocol': MemberSpec_('Layer3_Protocol', 'Layer3ProtocolType', 0),
        'Layer4_Protocol': MemberSpec_('Layer4_Protocol', 'Layer4ProtocolType', 0),
        'Layer7_Protocol': MemberSpec_('Layer7_Protocol', 'Layer7ProtocolType', 0),
        'Source_Socket_Address': MemberSpec_('Source_Socket_Address', 'socket_address_object.SocketAddressObjectType', 0),
        'Source_TCP_State': MemberSpec_('Source_TCP_State', ['TCPStateEnum', 'xs:string'], 0),
        'Destination_Socket_Address': MemberSpec_('Destination_Socket_Address', 'socket_address_object.SocketAddressObjectType', 0),
        'Destination_TCP_State': MemberSpec_('Destination_TCP_State', ['TCPStateEnum', 'xs:string'], 0),
        'Layer7_Connections': MemberSpec_('Layer7_Connections', 'Layer7ConnectionsType', 0),
        }
    subclass = None
    superclass = cybox_common.ObjectPropertiesType
    def __init__(self, object_reference=None, Custom_Properties=None, xsi_type=None, tls_used=None, Creation_Time=None, Layer3_Protocol=None, Layer4_Protocol=None, Layer7_Protocol=None, Source_Socket_Address=None, Source_TCP_State=None, Destination_Socket_Address=None, Destination_TCP_State=None, Layer7_Connections=None):
        super(NetworkConnectionObjectType, self).__init__(object_reference, Custom_Properties, xsi_type )
        self.tls_used = _cast(bool, tls_used)
        self.Creation_Time = Creation_Time
        self.Layer3_Protocol = Layer3_Protocol
        self.Layer4_Protocol = Layer4_Protocol
        self.Layer7_Protocol = Layer7_Protocol
        self.Source_Socket_Address = Source_Socket_Address
        self.Source_TCP_State = Source_TCP_State
        self.Destination_Socket_Address = Destination_Socket_Address
        self.Destination_TCP_State = Destination_TCP_State
        self.Layer7_Connections = Layer7_Connections
    def factory(*args_, **kwargs_):
        if NetworkConnectionObjectType.subclass:
            return NetworkConnectionObjectType.subclass(*args_, **kwargs_)
        else:
            return NetworkConnectionObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Creation_Time(self): return self.Creation_Time
    def set_Creation_Time(self, Creation_Time): self.Creation_Time = Creation_Time
    def validate_DateTimeObjectPropertyType(self, value):
        # Validate type cybox_common.DateTimeObjectPropertyType, a restriction on None.
        pass
    def get_Layer3_Protocol(self): return self.Layer3_Protocol
    def set_Layer3_Protocol(self, Layer3_Protocol): self.Layer3_Protocol = Layer3_Protocol
    def validate_Layer3ProtocolType(self, value):
        # Validate type Layer3ProtocolType, a restriction on None.
        pass
    def get_Layer4_Protocol(self): return self.Layer4_Protocol
    def set_Layer4_Protocol(self, Layer4_Protocol): self.Layer4_Protocol = Layer4_Protocol
    def validate_Layer4ProtocolType(self, value):
        # Validate type Layer4ProtocolType, a restriction on None.
        pass
    def get_Layer7_Protocol(self): return self.Layer7_Protocol
    def set_Layer7_Protocol(self, Layer7_Protocol): self.Layer7_Protocol = Layer7_Protocol
    def validate_Layer7ProtocolType(self, value):
        # Validate type Layer7ProtocolType, a restriction on None.
        pass
    def get_Source_Socket_Address(self): return self.Source_Socket_Address
    def set_Source_Socket_Address(self, Source_Socket_Address): self.Source_Socket_Address = Source_Socket_Address
    def get_Source_TCP_State(self): return self.Source_TCP_State
    def set_Source_TCP_State(self, Source_TCP_State): self.Source_TCP_State = Source_TCP_State
    def validate_TCPStateEnum(self, value):
        # Validate type TCPStateEnum, a restriction on xs:string.
        pass
    def get_Destination_Socket_Address(self): return self.Destination_Socket_Address
    def set_Destination_Socket_Address(self, Destination_Socket_Address): self.Destination_Socket_Address = Destination_Socket_Address
    def get_Destination_TCP_State(self): return self.Destination_TCP_State
    def set_Destination_TCP_State(self, Destination_TCP_State): self.Destination_TCP_State = Destination_TCP_State
    def get_Layer7_Connections(self): return self.Layer7_Connections
    def set_Layer7_Connections(self, Layer7_Connections): self.Layer7_Connections = Layer7_Connections
    def get_tls_used(self): return self.tls_used
    def set_tls_used(self, tls_used): self.tls_used = tls_used
    def hasContent_(self):
        if (
            self.Creation_Time is not None or
            self.Layer3_Protocol is not None or
            self.Layer4_Protocol is not None or
            self.Layer7_Protocol is not None or
            self.Source_Socket_Address is not None or
            self.Source_TCP_State is not None or
            self.Destination_Socket_Address is not None or
            self.Destination_TCP_State is not None or
            self.Layer7_Connections is not None or
            super(NetworkConnectionObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='NetworkConnectionObj:', name_='NetworkConnectionObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkConnectionObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='NetworkConnectionObj:', name_='NetworkConnectionObjectType'):
        super(NetworkConnectionObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkConnectionObjectType')
        if self.tls_used is not None and 'tls_used' not in already_processed:
            already_processed.add('tls_used')
            outfile.write(' tls_used="%s"' % self.gds_format_boolean(self.tls_used, input_name='tls_used'))
    def exportChildren(self, outfile, level, namespace_='NetworkConnectionObj:', name_='NetworkConnectionObjectType', fromsubclass_=False, pretty_print=True):
        super(NetworkConnectionObjectType, self).exportChildren(outfile, level, 'NetworkConnectionObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Creation_Time is not None:
            self.Creation_Time.export(outfile, level, 'NetworkConnectionObj:', name_='Creation_Time', pretty_print=pretty_print)
        if self.Layer3_Protocol is not None:
            self.Layer3_Protocol.export(outfile, level, 'NetworkConnectionObj:', name_='Layer3_Protocol', pretty_print=pretty_print)
        if self.Layer4_Protocol is not None:
            self.Layer4_Protocol.export(outfile, level, 'NetworkConnectionObj:', name_='Layer4_Protocol', pretty_print=pretty_print)
        if self.Layer7_Protocol is not None:
            self.Layer7_Protocol.export(outfile, level, 'NetworkConnectionObj:', name_='Layer7_Protocol', pretty_print=pretty_print)
        if self.Source_Socket_Address is not None:
            self.Source_Socket_Address.export(outfile, level, 'NetworkConnectionObj:', name_='Source_Socket_Address', pretty_print=pretty_print)
        if self.Source_TCP_State is not None:
            outfile.write('<%sSource_TCP_State>%s</%sSource_TCP_State>%s' % ('NetworkConnectionObj:', self.gds_format_string(quote_xml(self.Source_TCP_State).encode(ExternalEncoding), input_name='Source_TCP_State'), 'NetworkConnectionObj:', eol_))
        if self.Destination_Socket_Address is not None:
            self.Destination_Socket_Address.export(outfile, level, 'NetworkConnectionObj:', name_='Destination_Socket_Address', pretty_print=pretty_print)
        if self.Destination_TCP_State is not None:
            outfile.write('<%sDestination_TCP_State>%s</%sDestination_TCP_State>%s' % ('NetworkConnectionObj:', self.gds_format_string(quote_xml(self.Destination_TCP_State).encode(ExternalEncoding), input_name='Destination_TCP_State'), 'NetworkConnectionObj:', eol_))
        if self.Layer7_Connections is not None:
            self.Layer7_Connections.export(outfile, level, 'NetworkConnectionObj:', name_='Layer7_Connections', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NetworkConnectionObjectType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tls_used is not None and 'tls_used' not in already_processed:
            already_processed.add('tls_used')
            showIndent(outfile, level)
            outfile.write('tls_used = %s,\n' % (self.tls_used,))
        super(NetworkConnectionObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NetworkConnectionObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Creation_Time is not None:
            outfile.write('Creation_Time=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Creation_Time.exportLiteral(outfile, level, name_='Creation_Time')
            outfile.write('),\n')
        if self.Layer3_Protocol is not None:
            outfile.write('Layer3_Protocol=model_.Layer3ProtocolType(\n')
            self.Layer3_Protocol.exportLiteral(outfile, level, name_='Layer3_Protocol')
            outfile.write('),\n')
        if self.Layer4_Protocol is not None:
            outfile.write('Layer4_Protocol=model_.Layer4ProtocolType(\n')
            self.Layer4_Protocol.exportLiteral(outfile, level, name_='Layer4_Protocol')
            outfile.write('),\n')
        if self.Layer7_Protocol is not None:
            outfile.write('Layer7_Protocol=model_.Layer7ProtocolType(\n')
            self.Layer7_Protocol.exportLiteral(outfile, level, name_='Layer7_Protocol')
            outfile.write('),\n')
        if self.Source_Socket_Address is not None:
            outfile.write('Source_Socket_Address=model_.socket_address_object.SocketAddressObjectType(\n')
            self.Source_Socket_Address.exportLiteral(outfile, level, name_='Source_Socket_Address')
            outfile.write('),\n')
        if self.Source_TCP_State is not None:
            outfile.write('Source_TCP_State=%s,\n' % quote_python(self.Source_TCP_State).encode(ExternalEncoding))
        if self.Destination_Socket_Address is not None:
            outfile.write('Destination_Socket_Address=model_.socket_address_object.SocketAddressObjectType(\n')
            self.Destination_Socket_Address.exportLiteral(outfile, level, name_='Destination_Socket_Address')
            outfile.write('),\n')
        if self.Destination_TCP_State is not None:
            outfile.write('Destination_TCP_State=%s,\n' % quote_python(self.Destination_TCP_State).encode(ExternalEncoding))
        if self.Layer7_Connections is not None:
            outfile.write('Layer7_Connections=model_.Layer7ConnectionsType(\n')
            self.Layer7_Connections.exportLiteral(outfile, level, name_='Layer7_Connections')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tls_used', node)
        if value is not None and 'tls_used' not in already_processed:
            already_processed.add('tls_used')
            if value in ('true', '1'):
                self.tls_used = True
            elif value in ('false', '0'):
                self.tls_used = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(NetworkConnectionObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Creation_Time':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Creation_Time(obj_)
        elif nodeName_ == 'Layer3_Protocol':
            obj_ = Layer3ProtocolType.factory()
            obj_.build(child_)
            self.set_Layer3_Protocol(obj_)
        elif nodeName_ == 'Layer4_Protocol':
            obj_ = Layer4ProtocolType.factory()
            obj_.build(child_)
            self.set_Layer4_Protocol(obj_)
        elif nodeName_ == 'Layer7_Protocol':
            obj_ = Layer7ProtocolType.factory()
            obj_.build(child_)
            self.set_Layer7_Protocol(obj_)
        elif nodeName_ == 'Source_Socket_Address':
            obj_ = socket_address_object.SocketAddressObjectType.factory()
            obj_.build(child_)
            self.set_Source_Socket_Address(obj_)
        elif nodeName_ == 'Source_TCP_State':
            obj_ = TCPStateEnum.factory()
            obj_.build(child_)
            self.set_Source_TCP_State(obj_)
        elif nodeName_ == 'Destination_Socket_Address':
            obj_ = socket_address_object.SocketAddressObjectType.factory()
            obj_.build(child_)
            self.set_Destination_Socket_Address(obj_)
        elif nodeName_ == 'Destination_TCP_State':
            obj_ = TCPStateEnum.factory()
            obj_.build(child_)
            self.set_Destination_TCP_State(obj_)
        elif nodeName_ == 'Layer7_Connections':
            obj_ = Layer7ConnectionsType.factory()
            obj_.build(child_)
            self.set_Layer7_Connections(obj_)
        super(NetworkConnectionObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class NetworkConnectionObjectType

GDSClassesMapping = {
    'Build_Utility': cybox_common.BuildUtilityType,
    'Errors': cybox_common.ErrorsType,
    'Accept_Charset': cybox_common.StringObjectPropertyType,
    'Time': cybox_common.TimeType,
    'Parsed_Header': http_session_object.HTTPResponseHeaderFieldsType,
    'Answer_Resource_Records': dns_query_object.DNSResourceRecordsType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'Max_Forwards': cybox_common.IntegerObjectPropertyType,
    'Proxy_Authorization': cybox_common.StringObjectPropertyType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'Entry_Type': cybox_common.StringObjectPropertyType,
    'Host': http_session_object.HostFieldType,
    'Authority_Resource_Records': dns_query_object.DNSResourceRecordsType,
    'User_Agent': cybox_common.StringObjectPropertyType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'SubDatum': cybox_common.MetadataType,
    'Record_Name': cybox_common.StringObjectPropertyType,
    'Segment_Hash': cybox_common.HashValueType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'X_Forwarded_Proto': cybox_common.StringObjectPropertyType,
    'X_ATT_DeviceId': cybox_common.StringObjectPropertyType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'Value': cybox_common.AnyURIObjectPropertyType,
    'Length': cybox_common.PositiveIntegerObjectPropertyType,
    'If_Range': cybox_common.StringObjectPropertyType,
    'HTTP_Server_Response': http_session_object.HTTPServerResponseType,
    'TE': cybox_common.StringObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Warning': cybox_common.StringObjectPropertyType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Segments': cybox_common.HashSegmentsType,
    'Content_Length': cybox_common.IntegerObjectPropertyType,
    'X_UA_Compatible': cybox_common.StringObjectPropertyType,
    'Functions': cybox_common.FunctionsType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'Question': dns_query_object.DNSQuestionType,
    'System': cybox_common.ObjectPropertiesType,
    'HTTP_Request_Line': http_session_object.HTTPRequestLineType,
    'Platform': cybox_common.PlatformSpecificationType,
    'Version': cybox_common.StringObjectPropertyType,
    'DNS_Query': dns_query_object.DNSQueryObjectType,
    'Accept_Language': cybox_common.StringObjectPropertyType,
    'Raw_Header': cybox_common.StringObjectPropertyType,
    'Type': cybox_common.ControlledVocabularyStringType,
    'Compilers': cybox_common.CompilersType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'String': cybox_common.ExtractedStringType,
    'Tool': cybox_common.ToolInformationType,
    'Build_Information': cybox_common.BuildInformationType,
    'Additional_Records': dns_query_object.DNSResourceRecordsType,
    'Link': cybox_common.StringObjectPropertyType,
    'Tool_Hashes': cybox_common.HashListType,
    'TTL': cybox_common.IntegerObjectPropertyType,
    'X_Frame_Options': cybox_common.StringObjectPropertyType,
    'Message_Body': cybox_common.StringObjectPropertyType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'Age': cybox_common.IntegerObjectPropertyType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'Server': cybox_common.StringObjectPropertyType,
    'Range': cybox_common.StringObjectPropertyType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Language': cybox_common.StringObjectPropertyType,
    'Retry_After': cybox_common.IntegerObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'WWW_Authenticate': cybox_common.StringObjectPropertyType,
    'Via': cybox_common.StringObjectPropertyType,
    'X_Requested_For': cybox_common.StringObjectPropertyType,
    'Contributors': cybox_common.PersonnelType,
    'Transfer_Encoding': cybox_common.StringObjectPropertyType,
    'Reference_Description': cybox_common.StructuredTextType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Expect': cybox_common.StringObjectPropertyType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'Destination_Socket_Address': socket_address_object.SocketAddressObjectType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'Reason_Phrase': cybox_common.StringObjectPropertyType,
    'Record_Type': cybox_common.StringObjectPropertyType,
    'Instance': cybox_common.ObjectPropertiesType,
    'Import': cybox_common.StringObjectPropertyType,
    'HTTP_Client_Request': http_session_object.HTTPClientRequestType,
    'Authorization': cybox_common.StringObjectPropertyType,
    'Accept_Encoding': cybox_common.StringObjectPropertyType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'HTTP_Session': http_session_object.HTTPSessionObjectType,
    'If_Modified_Since': cybox_common.DateTimeObjectPropertyType,
    'X_Content_Type_Options': cybox_common.StringObjectPropertyType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Dependencies': cybox_common.DependenciesType,
    'Cookie': cybox_common.StringObjectPropertyType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Date': cybox_common.DateTimeObjectPropertyType,
    'Content_Range': cybox_common.StringObjectPropertyType,
    'Hashes': cybox_common.HashListType,
    'Strict_Transport_Security': cybox_common.StringObjectPropertyType,
    'Content_Disposition': cybox_common.StringObjectPropertyType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'Address_Class': cybox_common.StringObjectPropertyType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Creation_Time': cybox_common.DateTimeObjectPropertyType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'Dependency': cybox_common.DependencyType,
    'Connection': cybox_common.StringObjectPropertyType,
    'X_Requested_With': cybox_common.StringObjectPropertyType,
    'Error': cybox_common.ErrorType,
    'P3P': cybox_common.StringObjectPropertyType,
    'If_Unmodified_Since': cybox_common.DateTimeObjectPropertyType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'Byte_Run': cybox_common.ByteRunType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'Imports': cybox_common.ImportsType,
    'X_Powered_By': cybox_common.StringObjectPropertyType,
    'Library': cybox_common.LibraryType,
    'Cache_Control': cybox_common.StringObjectPropertyType,
    'References': cybox_common.ToolReferencesType,
    'Service_Used': cybox_common.StringObjectPropertyType,
    'Access_Control_Allow_Origin': cybox_common.StringObjectPropertyType,
    'HTTP_Response_Header': http_session_object.HTTPResponseHeaderType,
    'X_XSS_Protection': cybox_common.StringObjectPropertyType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'Trailer': cybox_common.StringObjectPropertyType,
    'Status_Code': cybox_common.PositiveIntegerObjectPropertyType,
    'Libraries': cybox_common.LibrariesType,
    'QClass': cybox_common.StringObjectPropertyType,
    'Content_Language': cybox_common.StringObjectPropertyType,
    'Source_Socket_Address': socket_address_object.SocketAddressObjectType,
    'Content_Location': cybox_common.StringObjectPropertyType,
    'Content_MD5': cybox_common.StringObjectPropertyType,
    'QType': dns_query_object.DNSRecordType,
    'Function': cybox_common.StringObjectPropertyType,
    'Description': cybox_common.StructuredTextType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'Expires': cybox_common.DateTimeObjectPropertyType,
    'VLAN_Name': cybox_common.StringObjectPropertyType,
    'Socket_Address': socket_address_object.SocketAddressObjectType,
    'HTTP_Method': http_session_object.HTTPMethodType,
    'Content_Encoding': cybox_common.StringObjectPropertyType,
    'Pragma': cybox_common.StringObjectPropertyType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'Port_Value': cybox_common.PositiveIntegerObjectPropertyType,
    'Compiler': cybox_common.CompilerType,
    'Name': cybox_common.StringObjectPropertyType,
    'HTTP_Status_Line': http_session_object.HTTPStatusLineType,
    'Set_Cookie': cybox_common.StringObjectPropertyType,
    'Address_Value': cybox_common.StringObjectPropertyType,
    'Accept_Datetime': cybox_common.StringObjectPropertyType,
    'HTTP_Message_Body': http_session_object.HTTPMessageType,
    'Last_Modified': cybox_common.DateTimeObjectPropertyType,
    'Flags': cybox_common.HexBinaryObjectPropertyType,
    'Refresh': cybox_common.IntegerObjectPropertyType,
    'Content_Type': cybox_common.StringObjectPropertyType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Proxy_Authenticate': cybox_common.StringObjectPropertyType,
    'If_None_Match': cybox_common.StringObjectPropertyType,
    'HTTP_Request_Response': http_session_object.HTTPRequestResponseType,
    'Accept_Ranges': cybox_common.StringObjectPropertyType,
    'Data_Length': cybox_common.IntegerObjectPropertyType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Accept': cybox_common.StringObjectPropertyType,
    'Data_Size': cybox_common.DataSizeType,
    'HTTP_Request_Header': http_session_object.HTTPRequestHeaderType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'ETag': cybox_common.StringObjectPropertyType,
    'Date_Ran': cybox_common.DateTimeObjectPropertyType,
    'Contributor': cybox_common.ContributorType,
    'If_Match': cybox_common.StringObjectPropertyType,
    'Tools': cybox_common.ToolsInformationType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
    'VLAN_Num': cybox_common.IntegerObjectPropertyType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Network_Connection'
        rootClass = NetworkConnectionObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Network_Connection'
        rootClass = NetworkConnectionObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Network_Connection'
        rootClass = NetworkConnectionObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Network_Connection",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Network_Connection'
        rootClass = NetworkConnectionObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "NetworkConnectionObjectType",
    "Layer7ConnectionsType",
    "Layer3ProtocolType",
    "Layer4ProtocolType",
    "Layer7ProtocolType"
    ]