#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Apr 09 11:13:40 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import cybox_common
import port_object
import network_connection_object
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class NetworkConnectionListType(GeneratedsSuper):
    """The NetworkConnectionListType type is a list of network connections."""
    member_data_items_ = {
        'Network_Connection': MemberSpec_('Network_Connection', 'network_connection_object.NetworkConnectionObjectType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Network_Connection=None):
        if Network_Connection is None:
            self.Network_Connection = []
        else:
            self.Network_Connection = Network_Connection
    def factory(*args_, **kwargs_):
        if NetworkConnectionListType.subclass:
            return NetworkConnectionListType.subclass(*args_, **kwargs_)
        else:
            return NetworkConnectionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Network_Connection(self): return self.Network_Connection
    def set_Network_Connection(self, Network_Connection): self.Network_Connection = Network_Connection
    def add_Network_Connection(self, value): self.Network_Connection.append(value)
    def insert_Network_Connection(self, index, value): self.Network_Connection[index] = value
    def hasContent_(self):
        if (
            self.Network_Connection
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ProcessObj:', name_='NetworkConnectionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkConnectionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='NetworkConnectionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='NetworkConnectionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Network_Connection_ in self.Network_Connection:
            Network_Connection_.export(outfile, level, 'ProcessObj:', name_='Network_Connection', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NetworkConnectionListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Network_Connection=[\n')
        level += 1
        for Network_Connection_ in self.Network_Connection:
            outfile.write('model_.network_connection_object.NetworkConnectionObjectType(\n')
            Network_Connection_.exportLiteral(outfile, level, name_='network_connection_object.NetworkConnectionObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Network_Connection':
            obj_ = network_connection_object.NetworkConnectionObjectType.factory()
            obj_.build(child_)
            self.Network_Connection.append(obj_)
# end class NetworkConnectionListType

class ImageInfoType(GeneratedsSuper):
    """The ImageInfoType type captures information about the process image."""
    member_data_items_ = {
        'File_Name': MemberSpec_('File_Name', 'cybox_common.StringObjectPropertyType', 0),
        'Command_Line': MemberSpec_('Command_Line', 'cybox_common.StringObjectPropertyType', 0),
        'Current_Directory': MemberSpec_('Current_Directory', 'cybox_common.StringObjectPropertyType', 0),
        'Path': MemberSpec_('Path', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, File_Name=None, Command_Line=None, Current_Directory=None, Path=None):
        self.File_Name = File_Name
        self.Command_Line = Command_Line
        self.Current_Directory = Current_Directory
        self.Path = Path
    def factory(*args_, **kwargs_):
        if ImageInfoType.subclass:
            return ImageInfoType.subclass(*args_, **kwargs_)
        else:
            return ImageInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File_Name(self): return self.File_Name
    def set_File_Name(self, File_Name): self.File_Name = File_Name
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Command_Line(self): return self.Command_Line
    def set_Command_Line(self, Command_Line): self.Command_Line = Command_Line
    def get_Current_Directory(self): return self.Current_Directory
    def set_Current_Directory(self, Current_Directory): self.Current_Directory = Current_Directory
    def get_Path(self): return self.Path
    def set_Path(self, Path): self.Path = Path
    def hasContent_(self):
        if (
            self.File_Name is not None or
            self.Command_Line is not None or
            self.Current_Directory is not None or
            self.Path is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ImageInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImageInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ImageInfoType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ImageInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.File_Name is not None:
            self.File_Name.export(outfile, level, 'ProcessObj:', name_='File_Name', pretty_print=pretty_print)
        if self.Command_Line is not None:
            self.Command_Line.export(outfile, level, 'ProcessObj:', name_='Command_Line', pretty_print=pretty_print)
        if self.Current_Directory is not None:
            self.Current_Directory.export(outfile, level, 'ProcessObj:', name_='Current_Directory', pretty_print=pretty_print)
        if self.Path is not None:
            self.Path.export(outfile, level, 'ProcessObj:', name_='Path', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ImageInfoType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.File_Name is not None:
            outfile.write('File_Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.File_Name.exportLiteral(outfile, level, name_='File_Name')
            outfile.write('),\n')
        if self.Command_Line is not None:
            outfile.write('Command_Line=model_.cybox_common.StringObjectPropertyType(\n')
            self.Command_Line.exportLiteral(outfile, level, name_='Command_Line')
            outfile.write('),\n')
        if self.Current_Directory is not None:
            outfile.write('Current_Directory=model_.cybox_common.StringObjectPropertyType(\n')
            self.Current_Directory.exportLiteral(outfile, level, name_='Current_Directory')
            outfile.write('),\n')
        if self.Path is not None:
            outfile.write('Path=model_.cybox_common.StringObjectPropertyType(\n')
            self.Path.exportLiteral(outfile, level, name_='Path')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File_Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_File_Name(obj_)
        elif nodeName_ == 'Command_Line':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Command_Line(obj_)
        elif nodeName_ == 'Current_Directory':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Current_Directory(obj_)
        elif nodeName_ == 'Path':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Path(obj_)
# end class ImageInfoType

class ProcessStatusType(GeneratedsSuper):
    """The ProcessStatusType is used for specifying the status of a running
    or terminated process. Since this property is platform-specific,
    it is created here as an abstract type and then used in the
    platform-specific process CybOX objects."""
    member_data_items_ = {
        }
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if ProcessStatusType.subclass:
            return ProcessStatusType.subclass(*args_, **kwargs_)
        else:
            return ProcessStatusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ProcessStatusType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProcessStatusType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ProcessStatusType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ProcessStatusType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='ProcessStatusType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ProcessStatusType

class ChildPIDListType(GeneratedsSuper):
    """The ChildPIDListType type captures the PID's of the children of the
    process in a list format."""
    member_data_items_ = {
        'Child_PID': MemberSpec_('Child_PID', 'cybox_common.UnsignedIntegerObjectPropertyType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Child_PID=None):
        if Child_PID is None:
            self.Child_PID = []
        else:
            self.Child_PID = Child_PID
    def factory(*args_, **kwargs_):
        if ChildPIDListType.subclass:
            return ChildPIDListType.subclass(*args_, **kwargs_)
        else:
            return ChildPIDListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Child_PID(self): return self.Child_PID
    def set_Child_PID(self, Child_PID): self.Child_PID = Child_PID
    def add_Child_PID(self, value): self.Child_PID.append(value)
    def insert_Child_PID(self, index, value): self.Child_PID[index] = value
    def validate_UnsignedIntegerObjectPropertyType(self, value):
        # Validate type cybox_common.UnsignedIntegerObjectPropertyType, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.Child_PID
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ChildPIDListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChildPIDListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ChildPIDListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ChildPIDListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Child_PID_ in self.Child_PID:
            Child_PID_.export(outfile, level, 'ProcessObj:', name_='Child_PID', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ChildPIDListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Child_PID=[\n')
        level += 1
        for Child_PID_ in self.Child_PID:
            outfile.write('model_.cybox_common.UnsignedIntegerObjectPropertyType(\n')
            Child_PID_.exportLiteral(outfile, level, name_='cybox_common.UnsignedIntegerObjectPropertyType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Child_PID':
            obj_ = cybox_common.UnsignedIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.Child_PID.append(obj_)
# end class ChildPIDListType

class ArgumentListType(GeneratedsSuper):
    """The ArgumentListType is intended to specify a list of arguments
    utlized in intiating the process."""
    member_data_items_ = {
        'Argument': MemberSpec_('Argument', 'cybox_common.StringObjectPropertyType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Argument=None):
        if Argument is None:
            self.Argument = []
        else:
            self.Argument = Argument
    def factory(*args_, **kwargs_):
        if ArgumentListType.subclass:
            return ArgumentListType.subclass(*args_, **kwargs_)
        else:
            return ArgumentListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Argument(self): return self.Argument
    def set_Argument(self, Argument): self.Argument = Argument
    def add_Argument(self, value): self.Argument.append(value)
    def insert_Argument(self, index, value): self.Argument[index] = value
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.Argument
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ArgumentListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ArgumentListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ArgumentListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ArgumentListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Argument_ in self.Argument:
            Argument_.export(outfile, level, 'ProcessObj:', name_='Argument', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ArgumentListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Argument=[\n')
        level += 1
        for Argument_ in self.Argument:
            outfile.write('model_.cybox_common.StringObjectPropertyType(\n')
            Argument_.exportLiteral(outfile, level, name_='cybox_common.StringObjectPropertyType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Argument':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.Argument.append(obj_)
# end class ArgumentListType

class PortListType(GeneratedsSuper):
    """The PortListType is intended to specify a list of network ports."""
    member_data_items_ = {
        'Port': MemberSpec_('Port', 'port_object.PortObjectType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Port=None):
        if Port is None:
            self.Port = []
        else:
            self.Port = Port
    def factory(*args_, **kwargs_):
        if PortListType.subclass:
            return PortListType.subclass(*args_, **kwargs_)
        else:
            return PortListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Port(self): return self.Port
    def set_Port(self, Port): self.Port = Port
    def add_Port(self, value): self.Port.append(value)
    def insert_Port(self, index, value): self.Port[index] = value
    def hasContent_(self):
        if (
            self.Port
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ProcessObj:', name_='PortListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PortListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='PortListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='PortListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Port_ in self.Port:
            Port_.export(outfile, level, 'ProcessObj:', name_='Port', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PortListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Port=[\n')
        level += 1
        for Port_ in self.Port:
            outfile.write('model_.port_object.PortObjectType(\n')
            Port_.exportLiteral(outfile, level, name_='port_object.PortObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Port':
            obj_ = port_object.PortObjectType.factory()
            obj_.build(child_)
            self.Port.append(obj_)
# end class PortListType

class ProcessObjectType(cybox_common.ObjectPropertiesType):
    """The ProcessObjectType type is intended to characterize system
    processes.The is_hidden field specifies whether the process is
    hidden or not."""
    member_data_items_ = {
        'is_hidden': MemberSpec_('is_hidden', 'xs:boolean', 0),
        'PID': MemberSpec_('PID', 'cybox_common.UnsignedIntegerObjectPropertyType', 0),
        'Name': MemberSpec_('Name', 'cybox_common.StringObjectPropertyType', 0),
        'Creation_Time': MemberSpec_('Creation_Time', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Parent_PID': MemberSpec_('Parent_PID', 'cybox_common.UnsignedIntegerObjectPropertyType', 0),
        'Child_PID_List': MemberSpec_('Child_PID_List', 'ChildPIDListType', 0),
        'Image_Info': MemberSpec_('Image_Info', 'ImageInfoType', 0),
        'Argument_List': MemberSpec_('Argument_List', 'ArgumentListType', 0),
        'Environment_Variable_List': MemberSpec_('Environment_Variable_List', 'cybox_common.EnvironmentVariableListType', 0),
        'Kernel_Time': MemberSpec_('Kernel_Time', 'cybox_common.DurationObjectPropertyType', 0),
        'Port_List': MemberSpec_('Port_List', 'PortListType', 0),
        'Network_Connection_List': MemberSpec_('Network_Connection_List', 'NetworkConnectionListType', 0),
        'Start_Time': MemberSpec_('Start_Time', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Status': MemberSpec_('Status', 'ProcessStatusType', 0),
        'Username': MemberSpec_('Username', 'cybox_common.StringObjectPropertyType', 0),
        'User_Time': MemberSpec_('User_Time', 'cybox_common.DurationObjectPropertyType', 0),
        'Extracted_Features': MemberSpec_('Extracted_Features', 'cybox_common.ExtractedFeaturesType', 0),
        }
    subclass = None
    superclass = cybox_common.ObjectPropertiesType
    def __init__(self, object_reference=None, Custom_Properties=None, xsi_type=None, is_hidden=None, PID=None, Name=None, Creation_Time=None, Parent_PID=None, Child_PID_List=None, Image_Info=None, Argument_List=None, Environment_Variable_List=None, Kernel_Time=None, Port_List=None, Network_Connection_List=None, Start_Time=None, Status=None, Username=None, User_Time=None, Extracted_Features=None):
        super(ProcessObjectType, self).__init__(object_reference, Custom_Properties, xsi_type )
        self.is_hidden = _cast(bool, is_hidden)
        self.PID = PID
        self.Name = Name
        self.Creation_Time = Creation_Time
        self.Parent_PID = Parent_PID
        self.Child_PID_List = Child_PID_List
        self.Image_Info = Image_Info
        self.Argument_List = Argument_List
        self.Environment_Variable_List = Environment_Variable_List
        self.Kernel_Time = Kernel_Time
        self.Port_List = Port_List
        self.Network_Connection_List = Network_Connection_List
        self.Start_Time = Start_Time
        self.Status = Status
        self.Username = Username
        self.User_Time = User_Time
        self.Extracted_Features = Extracted_Features
    def factory(*args_, **kwargs_):
        if ProcessObjectType.subclass:
            return ProcessObjectType.subclass(*args_, **kwargs_)
        else:
            return ProcessObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PID(self): return self.PID
    def set_PID(self, PID): self.PID = PID
    def validate_UnsignedIntegerObjectPropertyType(self, value):
        # Validate type cybox_common.UnsignedIntegerObjectPropertyType, a restriction on None.
        pass
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Creation_Time(self): return self.Creation_Time
    def set_Creation_Time(self, Creation_Time): self.Creation_Time = Creation_Time
    def validate_DateTimeObjectPropertyType(self, value):
        # Validate type cybox_common.DateTimeObjectPropertyType, a restriction on None.
        pass
    def get_Parent_PID(self): return self.Parent_PID
    def set_Parent_PID(self, Parent_PID): self.Parent_PID = Parent_PID
    def get_Child_PID_List(self): return self.Child_PID_List
    def set_Child_PID_List(self, Child_PID_List): self.Child_PID_List = Child_PID_List
    def get_Image_Info(self): return self.Image_Info
    def set_Image_Info(self, Image_Info): self.Image_Info = Image_Info
    def get_Argument_List(self): return self.Argument_List
    def set_Argument_List(self, Argument_List): self.Argument_List = Argument_List
    def get_Environment_Variable_List(self): return self.Environment_Variable_List
    def set_Environment_Variable_List(self, Environment_Variable_List): self.Environment_Variable_List = Environment_Variable_List
    def get_Kernel_Time(self): return self.Kernel_Time
    def set_Kernel_Time(self, Kernel_Time): self.Kernel_Time = Kernel_Time
    def validate_DurationObjectPropertyType(self, value):
        # Validate type cybox_common.DurationObjectPropertyType, a restriction on None.
        pass
    def get_Port_List(self): return self.Port_List
    def set_Port_List(self, Port_List): self.Port_List = Port_List
    def get_Network_Connection_List(self): return self.Network_Connection_List
    def set_Network_Connection_List(self, Network_Connection_List): self.Network_Connection_List = Network_Connection_List
    def get_Start_Time(self): return self.Start_Time
    def set_Start_Time(self, Start_Time): self.Start_Time = Start_Time
    def get_Status(self): return self.Status
    def set_Status(self, Status): self.Status = Status
    def get_Username(self): return self.Username
    def set_Username(self, Username): self.Username = Username
    def get_User_Time(self): return self.User_Time
    def set_User_Time(self, User_Time): self.User_Time = User_Time
    def get_Extracted_Features(self): return self.Extracted_Features
    def set_Extracted_Features(self, Extracted_Features): self.Extracted_Features = Extracted_Features
    def get_is_hidden(self): return self.is_hidden
    def set_is_hidden(self, is_hidden): self.is_hidden = is_hidden
    def hasContent_(self):
        if (
            self.PID is not None or
            self.Name is not None or
            self.Creation_Time is not None or
            self.Parent_PID is not None or
            self.Child_PID_List is not None or
            self.Image_Info is not None or
            self.Argument_List is not None or
            self.Environment_Variable_List is not None or
            self.Kernel_Time is not None or
            self.Port_List is not None or
            self.Network_Connection_List is not None or
            self.Start_Time is not None or
            self.Status is not None or
            self.Username is not None or
            self.User_Time is not None or
            self.Extracted_Features is not None or
            super(ProcessObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ProcessObj:', name_='ProcessObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProcessObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ProcessObj:', name_='ProcessObjectType'):
        super(ProcessObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ProcessObjectType')
        if self.is_hidden is not None and 'is_hidden' not in already_processed:
            already_processed.add('is_hidden')
            outfile.write(' is_hidden="%s"' % self.gds_format_boolean(self.is_hidden, input_name='is_hidden'))
    def exportChildren(self, outfile, level, namespace_='ProcessObj:', name_='ProcessObjectType', fromsubclass_=False, pretty_print=True):
        super(ProcessObjectType, self).exportChildren(outfile, level, 'ProcessObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PID is not None:
            self.PID.export(outfile, level, 'ProcessObj:', name_='PID', pretty_print=pretty_print)
        if self.Name is not None:
            self.Name.export(outfile, level, 'ProcessObj:', name_='Name', pretty_print=pretty_print)
        if self.Creation_Time is not None:
            self.Creation_Time.export(outfile, level, 'ProcessObj:', name_='Creation_Time', pretty_print=pretty_print)
        if self.Parent_PID is not None:
            self.Parent_PID.export(outfile, level, 'ProcessObj:', name_='Parent_PID', pretty_print=pretty_print)
        if self.Child_PID_List is not None:
            self.Child_PID_List.export(outfile, level, 'ProcessObj:', name_='Child_PID_List', pretty_print=pretty_print)
        if self.Image_Info is not None:
            self.Image_Info.export(outfile, level, 'ProcessObj:', name_='Image_Info', pretty_print=pretty_print)
        if self.Argument_List is not None:
            self.Argument_List.export(outfile, level, 'ProcessObj:', name_='Argument_List', pretty_print=pretty_print)
        if self.Environment_Variable_List is not None:
            self.Environment_Variable_List.export(outfile, level, 'ProcessObj:', name_='Environment_Variable_List', pretty_print=pretty_print)
        if self.Kernel_Time is not None:
            self.Kernel_Time.export(outfile, level, 'ProcessObj:', name_='Kernel_Time', pretty_print=pretty_print)
        if self.Port_List is not None:
            self.Port_List.export(outfile, level, 'ProcessObj:', name_='Port_List', pretty_print=pretty_print)
        if self.Network_Connection_List is not None:
            self.Network_Connection_List.export(outfile, level, 'ProcessObj:', name_='Network_Connection_List', pretty_print=pretty_print)
        if self.Start_Time is not None:
            self.Start_Time.export(outfile, level, 'ProcessObj:', name_='Start_Time', pretty_print=pretty_print)
        if self.Status is not None:
            self.Status.export(outfile, level, 'ProcessObj:', name_='Status', pretty_print=pretty_print)
        if self.Username is not None:
            self.Username.export(outfile, level, 'ProcessObj:', name_='Username', pretty_print=pretty_print)
        if self.User_Time is not None:
            self.User_Time.export(outfile, level, 'ProcessObj:', name_='User_Time', pretty_print=pretty_print)
        if self.Extracted_Features is not None:
            self.Extracted_Features.export(outfile, level, 'ProcessObj:', name_='Extracted_Features', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ProcessObjectType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_hidden is not None and 'is_hidden' not in already_processed:
            already_processed.add('is_hidden')
            showIndent(outfile, level)
            outfile.write('is_hidden = %s,\n' % (self.is_hidden,))
        super(ProcessObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ProcessObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.PID is not None:
            outfile.write('PID=model_.cybox_common.UnsignedIntegerObjectPropertyType(\n')
            self.PID.exportLiteral(outfile, level, name_='PID')
            outfile.write('),\n')
        if self.Name is not None:
            outfile.write('Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            outfile.write('),\n')
        if self.Creation_Time is not None:
            outfile.write('Creation_Time=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Creation_Time.exportLiteral(outfile, level, name_='Creation_Time')
            outfile.write('),\n')
        if self.Parent_PID is not None:
            outfile.write('Parent_PID=model_.cybox_common.UnsignedIntegerObjectPropertyType(\n')
            self.Parent_PID.exportLiteral(outfile, level, name_='Parent_PID')
            outfile.write('),\n')
        if self.Child_PID_List is not None:
            outfile.write('Child_PID_List=model_.ChildPIDListType(\n')
            self.Child_PID_List.exportLiteral(outfile, level, name_='Child_PID_List')
            outfile.write('),\n')
        if self.Image_Info is not None:
            outfile.write('Image_Info=model_.ImageInfoType(\n')
            self.Image_Info.exportLiteral(outfile, level, name_='Image_Info')
            outfile.write('),\n')
        if self.Argument_List is not None:
            outfile.write('Argument_List=model_.ArgumentListType(\n')
            self.Argument_List.exportLiteral(outfile, level, name_='Argument_List')
            outfile.write('),\n')
        if self.Environment_Variable_List is not None:
            outfile.write('Environment_Variable_List=model_.cybox_common.EnvironmentVariableListType(\n')
            self.Environment_Variable_List.exportLiteral(outfile, level, name_='Environment_Variable_List')
            outfile.write('),\n')
        if self.Kernel_Time is not None:
            outfile.write('Kernel_Time=model_.cybox_common.DurationObjectPropertyType(\n')
            self.Kernel_Time.exportLiteral(outfile, level, name_='Kernel_Time')
            outfile.write('),\n')
        if self.Port_List is not None:
            outfile.write('Port_List=model_.PortListType(\n')
            self.Port_List.exportLiteral(outfile, level, name_='Port_List')
            outfile.write('),\n')
        if self.Network_Connection_List is not None:
            outfile.write('Network_Connection_List=model_.NetworkConnectionListType(\n')
            self.Network_Connection_List.exportLiteral(outfile, level, name_='Network_Connection_List')
            outfile.write('),\n')
        if self.Start_Time is not None:
            outfile.write('Start_Time=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Start_Time.exportLiteral(outfile, level, name_='Start_Time')
            outfile.write('),\n')
        if self.ProcessStatusType is not None:
            showIndent(outfile, level)
            outfile.write('ProcessStatusType=model_.ProcessStatusType(\n')
            self.ProcessStatusType.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Username is not None:
            outfile.write('Username=model_.cybox_common.StringObjectPropertyType(\n')
            self.Username.exportLiteral(outfile, level, name_='Username')
            outfile.write('),\n')
        if self.User_Time is not None:
            outfile.write('User_Time=model_.cybox_common.DurationObjectPropertyType(\n')
            self.User_Time.exportLiteral(outfile, level, name_='User_Time')
            outfile.write('),\n')
        if self.Extracted_Features is not None:
            outfile.write('Extracted_Features=model_.cybox_common.ExtractedFeaturesType(\n')
            self.Extracted_Features.exportLiteral(outfile, level, name_='Extracted_Features')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_hidden', node)
        if value is not None and 'is_hidden' not in already_processed:
            already_processed.add('is_hidden')
            if value in ('true', '1'):
                self.is_hidden = True
            elif value in ('false', '0'):
                self.is_hidden = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(ProcessObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PID':
            obj_ = cybox_common.UnsignedIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_PID(obj_)
        elif nodeName_ == 'Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Creation_Time':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Creation_Time(obj_)
        elif nodeName_ == 'Parent_PID':
            obj_ = cybox_common.UnsignedIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Parent_PID(obj_)
        elif nodeName_ == 'Child_PID_List':
            obj_ = ChildPIDListType.factory()
            obj_.build(child_)
            self.set_Child_PID_List(obj_)
        elif nodeName_ == 'Image_Info':
            obj_ = ImageInfoType.factory()
            obj_.build(child_)
            self.set_Image_Info(obj_)
        elif nodeName_ == 'Argument_List':
            obj_ = ArgumentListType.factory()
            obj_.build(child_)
            self.set_Argument_List(obj_)
        elif nodeName_ == 'Environment_Variable_List':
            obj_ = cybox_common.EnvironmentVariableListType.factory()
            obj_.build(child_)
            self.set_Environment_Variable_List(obj_)
        elif nodeName_ == 'Kernel_Time':
            obj_ = cybox_common.DurationObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Kernel_Time(obj_)
        elif nodeName_ == 'Port_List':
            obj_ = PortListType.factory()
            obj_.build(child_)
            self.set_Port_List(obj_)
        elif nodeName_ == 'Network_Connection_List':
            obj_ = NetworkConnectionListType.factory()
            obj_.build(child_)
            self.set_Network_Connection_List(obj_)
        elif nodeName_ == 'Start_Time':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Start_Time(obj_)
        elif nodeName_ == 'Status':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <Status> element')
            self.set_Status(obj_)
        elif nodeName_ == 'Username':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Username(obj_)
        elif nodeName_ == 'User_Time':
            obj_ = cybox_common.DurationObjectPropertyType.factory()
            obj_.build(child_)
            self.set_User_Time(obj_)
        elif nodeName_ == 'Extracted_Features':
            obj_ = cybox_common.ExtractedFeaturesType.factory()
            obj_.build(child_)
            self.set_Extracted_Features(obj_)
        super(ProcessObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class ProcessObjectType

GDSClassesMapping = {
    'Build_Utility': cybox_common.BuildUtilityType,
    'Errors': cybox_common.ErrorsType,
    'Accept_Charset': cybox_common.StringObjectPropertyType,
    'Time': cybox_common.TimeType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'Max_Forwards': cybox_common.IntegerObjectPropertyType,
    'Proxy_Authorization': cybox_common.StringObjectPropertyType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'Entry_Type': cybox_common.StringObjectPropertyType,
    'PID': cybox_common.UnsignedIntegerObjectPropertyType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'Path': cybox_common.StringObjectPropertyType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'SubDatum': cybox_common.MetadataType,
    'Record_Name': cybox_common.StringObjectPropertyType,
    'Segment_Hash': cybox_common.HashValueType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'X_Forwarded_Proto': cybox_common.StringObjectPropertyType,
    'X_ATT_DeviceId': cybox_common.StringObjectPropertyType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'Value': cybox_common.AnyURIObjectPropertyType,
    'Length': cybox_common.PositiveIntegerObjectPropertyType,
    'Expect': cybox_common.StringObjectPropertyType,
    'If_Range': cybox_common.StringObjectPropertyType,
    'Layer3_Protocol': network_connection_object.Layer3ProtocolType,
    'TE': cybox_common.StringObjectPropertyType,
    'Parent_PID': cybox_common.UnsignedIntegerObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Status_Code': cybox_common.PositiveIntegerObjectPropertyType,
    'Warning': cybox_common.StringObjectPropertyType,
    'Compiler': cybox_common.CompilerType,
    'Layer4_Protocol': port_object.Layer4ProtocolType,
    'Content_Length': cybox_common.IntegerObjectPropertyType,
    'X_UA_Compatible': cybox_common.StringObjectPropertyType,
    'Functions': cybox_common.FunctionsType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'Current_Directory': cybox_common.StringObjectPropertyType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'Start_Time': cybox_common.DateTimeObjectPropertyType,
    'System': cybox_common.ObjectPropertiesType,
    'Platform': cybox_common.PlatformSpecificationType,
    'Version': cybox_common.StringObjectPropertyType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'Accept_Language': cybox_common.StringObjectPropertyType,
    'Raw_Header': cybox_common.StringObjectPropertyType,
    'Extracted_Features': cybox_common.ExtractedFeaturesType,
    'Compilers': cybox_common.CompilersType,
    'Username': cybox_common.StringObjectPropertyType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'String': cybox_common.ExtractedStringType,
    'Tool': cybox_common.ToolInformationType,
    'Refresh': cybox_common.IntegerObjectPropertyType,
    'Build_Information': cybox_common.BuildInformationType,
    'Link': cybox_common.StringObjectPropertyType,
    'Tool_Hashes': cybox_common.HashListType,
    'TTL': cybox_common.IntegerObjectPropertyType,
    'X_Frame_Options': cybox_common.StringObjectPropertyType,
    'Message_Body': cybox_common.StringObjectPropertyType,
    'Address_Value': cybox_common.StringObjectPropertyType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'Age': cybox_common.IntegerObjectPropertyType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'Server': cybox_common.StringObjectPropertyType,
    'Access_Control_Allow_Origin': cybox_common.StringObjectPropertyType,
    'Range': cybox_common.StringObjectPropertyType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Retry_After': cybox_common.IntegerObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'WWW_Authenticate': cybox_common.StringObjectPropertyType,
    'Via': cybox_common.StringObjectPropertyType,
    'X_Requested_For': cybox_common.StringObjectPropertyType,
    'Contributors': cybox_common.PersonnelType,
    'Transfer_Encoding': cybox_common.StringObjectPropertyType,
    'Command_Line': cybox_common.StringObjectPropertyType,
    'Argument': cybox_common.StringObjectPropertyType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Child_PID': cybox_common.UnsignedIntegerObjectPropertyType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'User_Time': cybox_common.DurationObjectPropertyType,
    'Reason_Phrase': cybox_common.StringObjectPropertyType,
    'Record_Type': cybox_common.StringObjectPropertyType,
    'Instance': cybox_common.ObjectPropertiesType,
    'Import': cybox_common.StringObjectPropertyType,
    'Authorization': cybox_common.StringObjectPropertyType,
    'Accept_Encoding': cybox_common.StringObjectPropertyType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'If_Modified_Since': cybox_common.DateTimeObjectPropertyType,
    'X_Content_Type_Options': cybox_common.StringObjectPropertyType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Dependencies': cybox_common.DependenciesType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Date': cybox_common.DateTimeObjectPropertyType,
    'Cookie': cybox_common.StringObjectPropertyType,
    'Hashes': cybox_common.HashListType,
    'Strict_Transport_Security': cybox_common.StringObjectPropertyType,
    'Content_Disposition': cybox_common.StringObjectPropertyType,
    'Segments': cybox_common.HashSegmentsType,
    'User_Agent': cybox_common.StringObjectPropertyType,
    'Address_Class': cybox_common.StringObjectPropertyType,
    'Language': cybox_common.StringObjectPropertyType,
    'Creation_Time': cybox_common.DateTimeObjectPropertyType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'Dependency': cybox_common.DependencyType,
    'Connection': cybox_common.StringObjectPropertyType,
    'X_Requested_With': cybox_common.StringObjectPropertyType,
    'Kernel_Time': cybox_common.DurationObjectPropertyType,
    'Error': cybox_common.ErrorType,
    'P3P': cybox_common.StringObjectPropertyType,
    'If_Unmodified_Since': cybox_common.DateTimeObjectPropertyType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'Byte_Run': cybox_common.ByteRunType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'Imports': cybox_common.ImportsType,
    'X_Powered_By': cybox_common.StringObjectPropertyType,
    'Library': cybox_common.LibraryType,
    'Cache_Control': cybox_common.StringObjectPropertyType,
    'References': cybox_common.ToolReferencesType,
    'Service_Used': cybox_common.StringObjectPropertyType,
    'X_XSS_Protection': cybox_common.StringObjectPropertyType,
    'Layer7_Connections': network_connection_object.Layer7ConnectionsType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Trailer': cybox_common.StringObjectPropertyType,
    'File_Name': cybox_common.StringObjectPropertyType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'Data_Size': cybox_common.DataSizeType,
    'Reference_Description': cybox_common.StructuredTextType,
    'Libraries': cybox_common.LibrariesType,
    'QClass': cybox_common.StringObjectPropertyType,
    'Content_Language': cybox_common.StringObjectPropertyType,
    'Content_Location': cybox_common.StringObjectPropertyType,
    'Content_MD5': cybox_common.StringObjectPropertyType,
    'Function': cybox_common.StringObjectPropertyType,
    'Description': cybox_common.StructuredTextType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'Type': cybox_common.ControlledVocabularyStringType,
    'Expires': cybox_common.DateTimeObjectPropertyType,
    'VLAN_Name': cybox_common.StringObjectPropertyType,
    'Content_Range': cybox_common.StringObjectPropertyType,
    'Content_Encoding': cybox_common.StringObjectPropertyType,
    'Pragma': cybox_common.StringObjectPropertyType,
    'Layer7_Protocol': network_connection_object.Layer7ProtocolType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'Port_Value': cybox_common.PositiveIntegerObjectPropertyType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Name': cybox_common.StringObjectPropertyType,
    'Set_Cookie': cybox_common.StringObjectPropertyType,
    'Accept_Datetime': cybox_common.StringObjectPropertyType,
    'Environment_Variable_List': cybox_common.EnvironmentVariableListType,
    'Last_Modified': cybox_common.DateTimeObjectPropertyType,
    'Flags': cybox_common.HexBinaryObjectPropertyType,
    'Content_Type': cybox_common.StringObjectPropertyType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'Proxy_Authenticate': cybox_common.StringObjectPropertyType,
    'If_None_Match': cybox_common.StringObjectPropertyType,
    'Accept_Ranges': cybox_common.StringObjectPropertyType,
    'Network_Connection': network_connection_object.NetworkConnectionObjectType,
    'Data_Length': cybox_common.IntegerObjectPropertyType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Accept': cybox_common.StringObjectPropertyType,
    'Port': port_object.PortObjectType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'ETag': cybox_common.StringObjectPropertyType,
    'Date_Ran': cybox_common.DateTimeObjectPropertyType,
    'Contributor': cybox_common.ContributorType,
    'If_Match': cybox_common.StringObjectPropertyType,
    'Tools': cybox_common.ToolsInformationType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
    'VLAN_Num': cybox_common.IntegerObjectPropertyType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Process'
        rootClass = ProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Process'
        rootClass = ProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Process'
        rootClass = ProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Process",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Process'
        rootClass = ProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "ProcessObjectType",
    "NetworkConnectionListType",
    "ImageInfoType",
    "ProcessStatusType",
    "ChildPIDListType",
    "ArgumentListType",
    "PortListType"
    ]