#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Apr 09 11:14:57 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import win_handle_object
import memory_object
import process_object
import cybox_common
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class MemorySectionListType(GeneratedsSuper):
    """The MemorySectionListType type specifies a list of memory sections
    used by the process."""
    member_data_items_ = {
        'Memory_Section': MemberSpec_('Memory_Section', 'memory_object.MemoryObjectType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Memory_Section=None):
        if Memory_Section is None:
            self.Memory_Section = []
        else:
            self.Memory_Section = Memory_Section
    def factory(*args_, **kwargs_):
        if MemorySectionListType.subclass:
            return MemorySectionListType.subclass(*args_, **kwargs_)
        else:
            return MemorySectionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Memory_Section(self): return self.Memory_Section
    def set_Memory_Section(self, Memory_Section): self.Memory_Section = Memory_Section
    def add_Memory_Section(self, value): self.Memory_Section.append(value)
    def insert_Memory_Section(self, index, value): self.Memory_Section[index] = value
    def hasContent_(self):
        if (
            self.Memory_Section
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinProcessObj:', name_='MemorySectionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MemorySectionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinProcessObj:', name_='MemorySectionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinProcessObj:', name_='MemorySectionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Memory_Section_ in self.Memory_Section:
            Memory_Section_.export(outfile, level, 'WinProcessObj:', name_='Memory_Section', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MemorySectionListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Memory_Section=[\n')
        level += 1
        for Memory_Section_ in self.Memory_Section:
            outfile.write('model_.memory_object.MemoryObjectType(\n')
            Memory_Section_.exportLiteral(outfile, level, name_='memory_object.MemoryObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Memory_Section':
            obj_ = memory_object.MemoryObjectType.factory()
            obj_.build(child_)
            self.Memory_Section.append(obj_)
# end class MemorySectionListType

class StartupInfoType(GeneratedsSuper):
    """The StartupInfoType type encapsulates the information contained in
    the STARTUPINFO struct for the process."""
    member_data_items_ = {
        'lpDesktop': MemberSpec_('lpDesktop', 'cybox_common.StringObjectPropertyType', 0),
        'lpTitle': MemberSpec_('lpTitle', 'cybox_common.StringObjectPropertyType', 0),
        'dwX': MemberSpec_('dwX', 'cybox_common.IntegerObjectPropertyType', 0),
        'dwY': MemberSpec_('dwY', 'cybox_common.IntegerObjectPropertyType', 0),
        'dwXSize': MemberSpec_('dwXSize', 'cybox_common.PositiveIntegerObjectPropertyType', 0),
        'dwYSize': MemberSpec_('dwYSize', 'cybox_common.PositiveIntegerObjectPropertyType', 0),
        'dwXCountChars': MemberSpec_('dwXCountChars', 'cybox_common.PositiveIntegerObjectPropertyType', 0),
        'dwYCountChars': MemberSpec_('dwYCountChars', 'cybox_common.PositiveIntegerObjectPropertyType', 0),
        'dwFillAttribute': MemberSpec_('dwFillAttribute', 'cybox_common.IntegerObjectPropertyType', 0),
        'dwFlags': MemberSpec_('dwFlags', 'cybox_common.IntegerObjectPropertyType', 0),
        'wShowWindow': MemberSpec_('wShowWindow', 'cybox_common.IntegerObjectPropertyType', 0),
        'hStdInput': MemberSpec_('hStdInput', 'win_handle_object.WindowsHandleObjectType', 0),
        'hStdOutput': MemberSpec_('hStdOutput', 'win_handle_object.WindowsHandleObjectType', 0),
        'hStdError': MemberSpec_('hStdError', 'win_handle_object.WindowsHandleObjectType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, lpDesktop=None, lpTitle=None, dwX=None, dwY=None, dwXSize=None, dwYSize=None, dwXCountChars=None, dwYCountChars=None, dwFillAttribute=None, dwFlags=None, wShowWindow=None, hStdInput=None, hStdOutput=None, hStdError=None):
        self.lpDesktop = lpDesktop
        self.lpTitle = lpTitle
        self.dwX = dwX
        self.dwY = dwY
        self.dwXSize = dwXSize
        self.dwYSize = dwYSize
        self.dwXCountChars = dwXCountChars
        self.dwYCountChars = dwYCountChars
        self.dwFillAttribute = dwFillAttribute
        self.dwFlags = dwFlags
        self.wShowWindow = wShowWindow
        self.hStdInput = hStdInput
        self.hStdOutput = hStdOutput
        self.hStdError = hStdError
    def factory(*args_, **kwargs_):
        if StartupInfoType.subclass:
            return StartupInfoType.subclass(*args_, **kwargs_)
        else:
            return StartupInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_lpDesktop(self): return self.lpDesktop
    def set_lpDesktop(self, lpDesktop): self.lpDesktop = lpDesktop
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_lpTitle(self): return self.lpTitle
    def set_lpTitle(self, lpTitle): self.lpTitle = lpTitle
    def get_dwX(self): return self.dwX
    def set_dwX(self, dwX): self.dwX = dwX
    def validate_IntegerObjectPropertyType(self, value):
        # Validate type cybox_common.IntegerObjectPropertyType, a restriction on None.
        pass
    def get_dwY(self): return self.dwY
    def set_dwY(self, dwY): self.dwY = dwY
    def get_dwXSize(self): return self.dwXSize
    def set_dwXSize(self, dwXSize): self.dwXSize = dwXSize
    def validate_PositiveIntegerObjectPropertyType(self, value):
        # Validate type cybox_common.PositiveIntegerObjectPropertyType, a restriction on None.
        pass
    def get_dwYSize(self): return self.dwYSize
    def set_dwYSize(self, dwYSize): self.dwYSize = dwYSize
    def get_dwXCountChars(self): return self.dwXCountChars
    def set_dwXCountChars(self, dwXCountChars): self.dwXCountChars = dwXCountChars
    def get_dwYCountChars(self): return self.dwYCountChars
    def set_dwYCountChars(self, dwYCountChars): self.dwYCountChars = dwYCountChars
    def get_dwFillAttribute(self): return self.dwFillAttribute
    def set_dwFillAttribute(self, dwFillAttribute): self.dwFillAttribute = dwFillAttribute
    def get_dwFlags(self): return self.dwFlags
    def set_dwFlags(self, dwFlags): self.dwFlags = dwFlags
    def get_wShowWindow(self): return self.wShowWindow
    def set_wShowWindow(self, wShowWindow): self.wShowWindow = wShowWindow
    def get_hStdInput(self): return self.hStdInput
    def set_hStdInput(self, hStdInput): self.hStdInput = hStdInput
    def get_hStdOutput(self): return self.hStdOutput
    def set_hStdOutput(self, hStdOutput): self.hStdOutput = hStdOutput
    def get_hStdError(self): return self.hStdError
    def set_hStdError(self, hStdError): self.hStdError = hStdError
    def hasContent_(self):
        if (
            self.lpDesktop is not None or
            self.lpTitle is not None or
            self.dwX is not None or
            self.dwY is not None or
            self.dwXSize is not None or
            self.dwYSize is not None or
            self.dwXCountChars is not None or
            self.dwYCountChars is not None or
            self.dwFillAttribute is not None or
            self.dwFlags is not None or
            self.wShowWindow is not None or
            self.hStdInput is not None or
            self.hStdOutput is not None or
            self.hStdError is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinProcessObj:', name_='StartupInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StartupInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinProcessObj:', name_='StartupInfoType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinProcessObj:', name_='StartupInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.lpDesktop is not None:
            self.lpDesktop.export(outfile, level, 'WinProcessObj:', name_='lpDesktop', pretty_print=pretty_print)
        if self.lpTitle is not None:
            self.lpTitle.export(outfile, level, 'WinProcessObj:', name_='lpTitle', pretty_print=pretty_print)
        if self.dwX is not None:
            self.dwX.export(outfile, level, 'WinProcessObj:', name_='dwX', pretty_print=pretty_print)
        if self.dwY is not None:
            self.dwY.export(outfile, level, 'WinProcessObj:', name_='dwY', pretty_print=pretty_print)
        if self.dwXSize is not None:
            self.dwXSize.export(outfile, level, 'WinProcessObj:', name_='dwXSize', pretty_print=pretty_print)
        if self.dwYSize is not None:
            self.dwYSize.export(outfile, level, 'WinProcessObj:', name_='dwYSize', pretty_print=pretty_print)
        if self.dwXCountChars is not None:
            self.dwXCountChars.export(outfile, level, 'WinProcessObj:', name_='dwXCountChars', pretty_print=pretty_print)
        if self.dwYCountChars is not None:
            self.dwYCountChars.export(outfile, level, 'WinProcessObj:', name_='dwYCountChars', pretty_print=pretty_print)
        if self.dwFillAttribute is not None:
            self.dwFillAttribute.export(outfile, level, 'WinProcessObj:', name_='dwFillAttribute', pretty_print=pretty_print)
        if self.dwFlags is not None:
            self.dwFlags.export(outfile, level, 'WinProcessObj:', name_='dwFlags', pretty_print=pretty_print)
        if self.wShowWindow is not None:
            self.wShowWindow.export(outfile, level, 'WinProcessObj:', name_='wShowWindow', pretty_print=pretty_print)
        if self.hStdInput is not None:
            self.hStdInput.export(outfile, level, 'WinProcessObj:', name_='hStdInput', pretty_print=pretty_print)
        if self.hStdOutput is not None:
            self.hStdOutput.export(outfile, level, 'WinProcessObj:', name_='hStdOutput', pretty_print=pretty_print)
        if self.hStdError is not None:
            self.hStdError.export(outfile, level, 'WinProcessObj:', name_='hStdError', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='StartupInfoType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.lpDesktop is not None:
            outfile.write('lpDesktop=model_.cybox_common.StringObjectPropertyType(\n')
            self.lpDesktop.exportLiteral(outfile, level, name_='lpDesktop')
            outfile.write('),\n')
        if self.lpTitle is not None:
            outfile.write('lpTitle=model_.cybox_common.StringObjectPropertyType(\n')
            self.lpTitle.exportLiteral(outfile, level, name_='lpTitle')
            outfile.write('),\n')
        if self.dwX is not None:
            outfile.write('dwX=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.dwX.exportLiteral(outfile, level, name_='dwX')
            outfile.write('),\n')
        if self.dwY is not None:
            outfile.write('dwY=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.dwY.exportLiteral(outfile, level, name_='dwY')
            outfile.write('),\n')
        if self.dwXSize is not None:
            outfile.write('dwXSize=model_.cybox_common.PositiveIntegerObjectPropertyType(\n')
            self.dwXSize.exportLiteral(outfile, level, name_='dwXSize')
            outfile.write('),\n')
        if self.dwYSize is not None:
            outfile.write('dwYSize=model_.cybox_common.PositiveIntegerObjectPropertyType(\n')
            self.dwYSize.exportLiteral(outfile, level, name_='dwYSize')
            outfile.write('),\n')
        if self.dwXCountChars is not None:
            outfile.write('dwXCountChars=model_.cybox_common.PositiveIntegerObjectPropertyType(\n')
            self.dwXCountChars.exportLiteral(outfile, level, name_='dwXCountChars')
            outfile.write('),\n')
        if self.dwYCountChars is not None:
            outfile.write('dwYCountChars=model_.cybox_common.PositiveIntegerObjectPropertyType(\n')
            self.dwYCountChars.exportLiteral(outfile, level, name_='dwYCountChars')
            outfile.write('),\n')
        if self.dwFillAttribute is not None:
            outfile.write('dwFillAttribute=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.dwFillAttribute.exportLiteral(outfile, level, name_='dwFillAttribute')
            outfile.write('),\n')
        if self.dwFlags is not None:
            outfile.write('dwFlags=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.dwFlags.exportLiteral(outfile, level, name_='dwFlags')
            outfile.write('),\n')
        if self.wShowWindow is not None:
            outfile.write('wShowWindow=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.wShowWindow.exportLiteral(outfile, level, name_='wShowWindow')
            outfile.write('),\n')
        if self.hStdInput is not None:
            outfile.write('hStdInput=model_.win_handle_object.WindowsHandleObjectType(\n')
            self.hStdInput.exportLiteral(outfile, level, name_='hStdInput')
            outfile.write('),\n')
        if self.hStdOutput is not None:
            outfile.write('hStdOutput=model_.win_handle_object.WindowsHandleObjectType(\n')
            self.hStdOutput.exportLiteral(outfile, level, name_='hStdOutput')
            outfile.write('),\n')
        if self.hStdError is not None:
            outfile.write('hStdError=model_.win_handle_object.WindowsHandleObjectType(\n')
            self.hStdError.exportLiteral(outfile, level, name_='hStdError')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'lpDesktop':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_lpDesktop(obj_)
        elif nodeName_ == 'lpTitle':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_lpTitle(obj_)
        elif nodeName_ == 'dwX':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_dwX(obj_)
        elif nodeName_ == 'dwY':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_dwY(obj_)
        elif nodeName_ == 'dwXSize':
            obj_ = cybox_common.PositiveIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_dwXSize(obj_)
        elif nodeName_ == 'dwYSize':
            obj_ = cybox_common.PositiveIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_dwYSize(obj_)
        elif nodeName_ == 'dwXCountChars':
            obj_ = cybox_common.PositiveIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_dwXCountChars(obj_)
        elif nodeName_ == 'dwYCountChars':
            obj_ = cybox_common.PositiveIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_dwYCountChars(obj_)
        elif nodeName_ == 'dwFillAttribute':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_dwFillAttribute(obj_)
        elif nodeName_ == 'dwFlags':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_dwFlags(obj_)
        elif nodeName_ == 'wShowWindow':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_wShowWindow(obj_)
        elif nodeName_ == 'hStdInput':
            obj_ = win_handle_object.WindowsHandleObjectType.factory()
            obj_.build(child_)
            self.set_hStdInput(obj_)
        elif nodeName_ == 'hStdOutput':
            obj_ = win_handle_object.WindowsHandleObjectType.factory()
            obj_.build(child_)
            self.set_hStdOutput(obj_)
        elif nodeName_ == 'hStdError':
            obj_ = win_handle_object.WindowsHandleObjectType.factory()
            obj_.build(child_)
            self.set_hStdError(obj_)
# end class StartupInfoType

class WindowsProcessObjectType(process_object.ProcessObjectType):
    """The WindowsProcessObjectType type is intended to characterize
    Windows processes.The aslr_enabled field specifies whether
    Address Space Layout Randomization (ASLR) is enabled for the
    process.The dep_enabled field specifies whether Data Execution
    Prevention (DEP) is enabled for the process."""
    member_data_items_ = {
        'aslr_enabled': MemberSpec_('aslr_enabled', 'xs:boolean', 0),
        'dep_enabled': MemberSpec_('dep_enabled', 'xs:boolean', 0),
        'Handle_List': MemberSpec_('Handle_List', 'win_handle_object.WindowsHandleListType', 0),
        'Priority': MemberSpec_('Priority', 'cybox_common.StringObjectPropertyType', 0),
        'Section_List': MemberSpec_('Section_List', 'MemorySectionListType', 0),
        'Security_ID': MemberSpec_('Security_ID', 'cybox_common.StringObjectPropertyType', 0),
        'Startup_Info': MemberSpec_('Startup_Info', 'StartupInfoType', 0),
        'Security_Type': MemberSpec_('Security_Type', 'cybox_common.SIDType', 0),
        'Window_Title': MemberSpec_('Window_Title', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = process_object.ProcessObjectType
    def __init__(self, object_reference=None, Custom_Properties=None, xsi_type=None, is_hidden=None, PID=None, Name=None, Creation_Time=None, Parent_PID=None, Child_PID_List=None, Image_Info=None, Argument_List=None, Environment_Variable_List=None, Kernel_Time=None, Port_List=None, Network_Connection_List=None, Start_Time=None, Status=None, Username=None, User_Time=None, Extracted_Features=None, aslr_enabled=None, dep_enabled=None, Handle_List=None, Priority=None, Section_List=None, Security_ID=None, Startup_Info=None, Security_Type=None, Window_Title=None):
        super(WindowsProcessObjectType, self).__init__(object_reference, Custom_Properties, is_hidden, PID, Name, Creation_Time, Parent_PID, Child_PID_List, Image_Info, Argument_List, Environment_Variable_List, Kernel_Time, Port_List, Network_Connection_List, Start_Time, Status, Username, User_Time, Extracted_Features, )
        self.aslr_enabled = _cast(bool, aslr_enabled)
        self.dep_enabled = _cast(bool, dep_enabled)
        self.Handle_List = Handle_List
        self.Priority = Priority
        self.Section_List = Section_List
        self.Security_ID = Security_ID
        self.Startup_Info = Startup_Info
        self.Security_Type = Security_Type
        self.Window_Title = Window_Title
    def factory(*args_, **kwargs_):
        if WindowsProcessObjectType.subclass:
            return WindowsProcessObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsProcessObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Handle_List(self): return self.Handle_List
    def set_Handle_List(self, Handle_List): self.Handle_List = Handle_List
    def get_Priority(self): return self.Priority
    def set_Priority(self, Priority): self.Priority = Priority
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Section_List(self): return self.Section_List
    def set_Section_List(self, Section_List): self.Section_List = Section_List
    def get_Security_ID(self): return self.Security_ID
    def set_Security_ID(self, Security_ID): self.Security_ID = Security_ID
    def get_Startup_Info(self): return self.Startup_Info
    def set_Startup_Info(self, Startup_Info): self.Startup_Info = Startup_Info
    def get_Security_Type(self): return self.Security_Type
    def set_Security_Type(self, Security_Type): self.Security_Type = Security_Type
    def validate_SIDType(self, value):
        # Validate type cybox_common.SIDType, a restriction on None.
        pass
    def get_Window_Title(self): return self.Window_Title
    def set_Window_Title(self, Window_Title): self.Window_Title = Window_Title
    def get_aslr_enabled(self): return self.aslr_enabled
    def set_aslr_enabled(self, aslr_enabled): self.aslr_enabled = aslr_enabled
    def get_dep_enabled(self): return self.dep_enabled
    def set_dep_enabled(self, dep_enabled): self.dep_enabled = dep_enabled
    def hasContent_(self):
        if (
            self.Handle_List is not None or
            self.Priority is not None or
            self.Section_List is not None or
            self.Security_ID is not None or
            self.Startup_Info is not None or
            self.Security_Type is not None or
            self.Window_Title is not None or
            super(WindowsProcessObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinProcessObj:', name_='WindowsProcessObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsProcessObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinProcessObj:', name_='WindowsProcessObjectType'):
        super(WindowsProcessObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsProcessObjectType')
        if self.aslr_enabled is not None and 'aslr_enabled' not in already_processed:
            already_processed.add('aslr_enabled')
            outfile.write(' aslr_enabled="%s"' % self.gds_format_boolean(self.aslr_enabled, input_name='aslr_enabled'))
        if self.dep_enabled is not None and 'dep_enabled' not in already_processed:
            already_processed.add('dep_enabled')
            outfile.write(' dep_enabled="%s"' % self.gds_format_boolean(self.dep_enabled, input_name='dep_enabled'))
    def exportChildren(self, outfile, level, namespace_='WinProcessObj:', name_='WindowsProcessObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsProcessObjectType, self).exportChildren(outfile, level, 'WinProcessObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Handle_List is not None:
            self.Handle_List.export(outfile, level, 'WinProcessObj:', name_='Handle_List', pretty_print=pretty_print)
        if self.Priority is not None:
            self.Priority.export(outfile, level, 'WinProcessObj:', name_='Priority', pretty_print=pretty_print)
        if self.Section_List is not None:
            self.Section_List.export(outfile, level, 'WinProcessObj:', name_='Section_List', pretty_print=pretty_print)
        if self.Security_ID is not None:
            self.Security_ID.export(outfile, level, 'WinProcessObj:', name_='Security_ID', pretty_print=pretty_print)
        if self.Startup_Info is not None:
            self.Startup_Info.export(outfile, level, 'WinProcessObj:', name_='Startup_Info', pretty_print=pretty_print)
        if self.Security_Type is not None:
            self.Security_Type.export(outfile, level, 'WinProcessObj:', name_='Security_Type', pretty_print=pretty_print)
        if self.Window_Title is not None:
            self.Window_Title.export(outfile, level, 'WinProcessObj:', name_='Window_Title', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='WindowsProcessObjectType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.aslr_enabled is not None and 'aslr_enabled' not in already_processed:
            already_processed.add('aslr_enabled')
            showIndent(outfile, level)
            outfile.write('aslr_enabled = %s,\n' % (self.aslr_enabled,))
        if self.dep_enabled is not None and 'dep_enabled' not in already_processed:
            already_processed.add('dep_enabled')
            showIndent(outfile, level)
            outfile.write('dep_enabled = %s,\n' % (self.dep_enabled,))
        super(WindowsProcessObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsProcessObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Handle_List is not None:
            outfile.write('Handle_List=model_.win_handle_object.WindowsHandleListType(\n')
            self.Handle_List.exportLiteral(outfile, level, name_='Handle_List')
            outfile.write('),\n')
        if self.Priority is not None:
            outfile.write('Priority=model_.cybox_common.StringObjectPropertyType(\n')
            self.Priority.exportLiteral(outfile, level, name_='Priority')
            outfile.write('),\n')
        if self.Section_List is not None:
            outfile.write('Section_List=model_.MemorySectionListType(\n')
            self.Section_List.exportLiteral(outfile, level, name_='Section_List')
            outfile.write('),\n')
        if self.Security_ID is not None:
            outfile.write('Security_ID=model_.cybox_common.StringObjectPropertyType(\n')
            self.Security_ID.exportLiteral(outfile, level, name_='Security_ID')
            outfile.write('),\n')
        if self.Startup_Info is not None:
            outfile.write('Startup_Info=model_.StartupInfoType(\n')
            self.Startup_Info.exportLiteral(outfile, level, name_='Startup_Info')
            outfile.write('),\n')
        if self.Security_Type is not None:
            outfile.write('Security_Type=model_.cybox_common.SIDType(\n')
            self.Security_Type.exportLiteral(outfile, level, name_='Security_Type')
            outfile.write('),\n')
        if self.Window_Title is not None:
            outfile.write('Window_Title=model_.cybox_common.StringObjectPropertyType(\n')
            self.Window_Title.exportLiteral(outfile, level, name_='Window_Title')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('aslr_enabled', node)
        if value is not None and 'aslr_enabled' not in already_processed:
            already_processed.add('aslr_enabled')
            if value in ('true', '1'):
                self.aslr_enabled = True
            elif value in ('false', '0'):
                self.aslr_enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('dep_enabled', node)
        if value is not None and 'dep_enabled' not in already_processed:
            already_processed.add('dep_enabled')
            if value in ('true', '1'):
                self.dep_enabled = True
            elif value in ('false', '0'):
                self.dep_enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(WindowsProcessObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Handle_List':
            obj_ = win_handle_object.WindowsHandleListType.factory()
            obj_.build(child_)
            self.set_Handle_List(obj_)
        elif nodeName_ == 'Priority':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Priority(obj_)
        elif nodeName_ == 'Section_List':
            obj_ = MemorySectionListType.factory()
            obj_.build(child_)
            self.set_Section_List(obj_)
        elif nodeName_ == 'Security_ID':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Security_ID(obj_)
        elif nodeName_ == 'Startup_Info':
            obj_ = StartupInfoType.factory()
            obj_.build(child_)
            self.set_Startup_Info(obj_)
        elif nodeName_ == 'Security_Type':
            obj_ = cybox_common.SIDType.factory()
            obj_.build(child_)
            self.set_Security_Type(obj_)
        elif nodeName_ == 'Window_Title':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Window_Title(obj_)
        super(WindowsProcessObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsProcessObjectType

GDSClassesMapping = {
    'Build_Utility': cybox_common.BuildUtilityType,
    'Errors': cybox_common.ErrorsType,
    'Accept_Charset': cybox_common.StringObjectPropertyType,
    'Time': cybox_common.TimeType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'Max_Forwards': cybox_common.IntegerObjectPropertyType,
    'Proxy_Authorization': cybox_common.StringObjectPropertyType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'Entry_Type': cybox_common.StringObjectPropertyType,
    'PID': cybox_common.UnsignedIntegerObjectPropertyType,
    'lpDesktop': cybox_common.StringObjectPropertyType,
    'Argument_List': process_object.ArgumentListType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'Path': cybox_common.StringObjectPropertyType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'Byte_Run': cybox_common.ByteRunType,
    'SubDatum': cybox_common.MetadataType,
    'Record_Name': cybox_common.StringObjectPropertyType,
    'Segment_Hash': cybox_common.HashValueType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'X_Forwarded_Proto': cybox_common.StringObjectPropertyType,
    'Region_Start_Address': cybox_common.HexBinaryObjectPropertyType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'Value': cybox_common.AnyURIObjectPropertyType,
    'Length': cybox_common.PositiveIntegerObjectPropertyType,
    'Expect': cybox_common.StringObjectPropertyType,
    'If_Range': cybox_common.StringObjectPropertyType,
    'TE': cybox_common.StringObjectPropertyType,
    'Parent_PID': cybox_common.UnsignedIntegerObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Status_Code': cybox_common.PositiveIntegerObjectPropertyType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'Warning': cybox_common.StringObjectPropertyType,
    'Memory_Region': memory_object.MemoryObjectType,
    'Object_Address': cybox_common.UnsignedLongObjectPropertyType,
    'Memory_Section': memory_object.MemoryObjectType,
    'Segments': cybox_common.HashSegmentsType,
    'Content_Length': cybox_common.IntegerObjectPropertyType,
    'X_UA_Compatible': cybox_common.StringObjectPropertyType,
    'Functions': cybox_common.FunctionsType,
    'X_Powered_By': cybox_common.StringObjectPropertyType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'Pointer_Count': cybox_common.UnsignedLongObjectPropertyType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'Start_Time': cybox_common.DateTimeObjectPropertyType,
    'System': cybox_common.ObjectPropertiesType,
    'Priority': cybox_common.StringObjectPropertyType,
    'Platform': cybox_common.PlatformSpecificationType,
    'Version': cybox_common.StringObjectPropertyType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'Accept_Language': cybox_common.StringObjectPropertyType,
    'Import': cybox_common.StringObjectPropertyType,
    'Raw_Header': cybox_common.StringObjectPropertyType,
    'Type': cybox_common.ControlledVocabularyStringType,
    'Compilers': cybox_common.CompilersType,
    'Username': cybox_common.StringObjectPropertyType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'String': cybox_common.ExtractedStringType,
    'lpTitle': cybox_common.StringObjectPropertyType,
    'Tool': cybox_common.ToolInformationType,
    'Refresh': cybox_common.IntegerObjectPropertyType,
    'Build_Information': cybox_common.BuildInformationType,
    'hStdOutput': win_handle_object.WindowsHandleObjectType,
    'Link': cybox_common.StringObjectPropertyType,
    'Tool_Hashes': cybox_common.HashListType,
    'TTL': cybox_common.IntegerObjectPropertyType,
    'X_Frame_Options': cybox_common.StringObjectPropertyType,
    'Age': cybox_common.IntegerObjectPropertyType,
    'Message_Body': cybox_common.StringObjectPropertyType,
    'Address_Value': cybox_common.StringObjectPropertyType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'dwFlags': cybox_common.IntegerObjectPropertyType,
    'Access_Control_Allow_Origin': cybox_common.StringObjectPropertyType,
    'Range': cybox_common.StringObjectPropertyType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Content_Location': cybox_common.StringObjectPropertyType,
    'Retry_After': cybox_common.IntegerObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'WWW_Authenticate': cybox_common.StringObjectPropertyType,
    'Via': cybox_common.StringObjectPropertyType,
    'X_Requested_For': cybox_common.StringObjectPropertyType,
    'Contributors': cybox_common.PersonnelType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'Transfer_Encoding': cybox_common.StringObjectPropertyType,
    'Security_Type': cybox_common.SIDType,
    'Reference_Description': cybox_common.StructuredTextType,
    'Server': cybox_common.StringObjectPropertyType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Child_PID': cybox_common.UnsignedIntegerObjectPropertyType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'wShowWindow': cybox_common.IntegerObjectPropertyType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'User_Time': cybox_common.DurationObjectPropertyType,
    'dwYSize': cybox_common.PositiveIntegerObjectPropertyType,
    'Reason_Phrase': cybox_common.StringObjectPropertyType,
    'Handle_List': win_handle_object.WindowsHandleListType,
    'Record_Type': cybox_common.StringObjectPropertyType,
    'Instance': cybox_common.ObjectPropertiesType,
    'dwXSize': cybox_common.PositiveIntegerObjectPropertyType,
    'Access_Mask': cybox_common.UnsignedLongObjectPropertyType,
    'dwFillAttribute': cybox_common.IntegerObjectPropertyType,
    'Authorization': cybox_common.StringObjectPropertyType,
    'Accept_Encoding': cybox_common.StringObjectPropertyType,
    'Status': process_object.ProcessStatusType,
    'Window_Title': cybox_common.StringObjectPropertyType,
    'Current_Directory': cybox_common.StringObjectPropertyType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'If_Modified_Since': cybox_common.DateTimeObjectPropertyType,
    'X_Content_Type_Options': cybox_common.StringObjectPropertyType,
    'hStdError': win_handle_object.WindowsHandleObjectType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Child_PID_List': process_object.ChildPIDListType,
    'Dependencies': cybox_common.DependenciesType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Date': cybox_common.DateTimeObjectPropertyType,
    'Cookie': cybox_common.StringObjectPropertyType,
    'Hashes': cybox_common.HashListType,
    'Strict_Transport_Security': cybox_common.StringObjectPropertyType,
    'Content_Disposition': cybox_common.StringObjectPropertyType,
    'dwX': cybox_common.IntegerObjectPropertyType,
    'User_Agent': cybox_common.StringObjectPropertyType,
    'Address_Class': cybox_common.StringObjectPropertyType,
    'hStdInput': win_handle_object.WindowsHandleObjectType,
    'Command_Line': cybox_common.StringObjectPropertyType,
    'Language': cybox_common.StringObjectPropertyType,
    'Creation_Time': cybox_common.DateTimeObjectPropertyType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'Dependency': cybox_common.DependencyType,
    'Connection': cybox_common.StringObjectPropertyType,
    'X_Requested_With': cybox_common.StringObjectPropertyType,
    'Kernel_Time': cybox_common.DurationObjectPropertyType,
    'Error': cybox_common.ErrorType,
    'P3P': cybox_common.StringObjectPropertyType,
    'If_Unmodified_Since': cybox_common.DateTimeObjectPropertyType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'dwXCountChars': cybox_common.PositiveIntegerObjectPropertyType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'Process': process_object.ProcessObjectType,
    'Imports': cybox_common.ImportsType,
    'Library': cybox_common.LibraryType,
    'Cache_Control': cybox_common.StringObjectPropertyType,
    'References': cybox_common.ToolReferencesType,
    'Service_Used': cybox_common.StringObjectPropertyType,
    'Image_Info': process_object.ImageInfoType,
    'X_XSS_Protection': cybox_common.StringObjectPropertyType,
    'Windows_Handle': win_handle_object.WindowsHandleObjectType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Trailer': cybox_common.StringObjectPropertyType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'File_Name': cybox_common.StringObjectPropertyType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'dwY': cybox_common.IntegerObjectPropertyType,
    'Argument': cybox_common.StringObjectPropertyType,
    'Libraries': cybox_common.LibrariesType,
    'QClass': cybox_common.StringObjectPropertyType,
    'Content_Language': cybox_common.StringObjectPropertyType,
    'Content_MD5': cybox_common.StringObjectPropertyType,
    'Security_ID': cybox_common.StringObjectPropertyType,
    'Function': cybox_common.StringObjectPropertyType,
    'Handle': win_handle_object.WindowsHandleObjectType,
    'Description': cybox_common.StructuredTextType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'Extracted_Features': cybox_common.ExtractedFeaturesType,
    'Expires': cybox_common.DateTimeObjectPropertyType,
    'VLAN_Name': cybox_common.StringObjectPropertyType,
    'Content_Range': cybox_common.StringObjectPropertyType,
    'X_ATT_DeviceId': cybox_common.StringObjectPropertyType,
    'Content_Encoding': cybox_common.StringObjectPropertyType,
    'Pragma': cybox_common.StringObjectPropertyType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'Port_Value': cybox_common.PositiveIntegerObjectPropertyType,
    'Compiler': cybox_common.CompilerType,
    'Name': cybox_common.StringObjectPropertyType,
    'Set_Cookie': cybox_common.StringObjectPropertyType,
    'Network_Connection_List': process_object.NetworkConnectionListType,
    'Accept_Datetime': cybox_common.StringObjectPropertyType,
    'Environment_Variable_List': cybox_common.EnvironmentVariableListType,
    'Last_Modified': cybox_common.DateTimeObjectPropertyType,
    'Flags': cybox_common.HexBinaryObjectPropertyType,
    'Port_List': process_object.PortListType,
    'Content_Type': cybox_common.StringObjectPropertyType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'ID': cybox_common.UnsignedIntegerObjectPropertyType,
    'Proxy_Authenticate': cybox_common.StringObjectPropertyType,
    'If_None_Match': cybox_common.StringObjectPropertyType,
    'Accept_Ranges': cybox_common.StringObjectPropertyType,
    'Region_Size': cybox_common.UnsignedLongObjectPropertyType,
    'Data_Length': cybox_common.IntegerObjectPropertyType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Accept': cybox_common.StringObjectPropertyType,
    'Data_Size': cybox_common.DataSizeType,
    'dwYCountChars': cybox_common.PositiveIntegerObjectPropertyType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'ETag': cybox_common.StringObjectPropertyType,
    'Date_Ran': cybox_common.DateTimeObjectPropertyType,
    'Contributor': cybox_common.ContributorType,
    'If_Match': cybox_common.StringObjectPropertyType,
    'Tools': cybox_common.ToolsInformationType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
    'VLAN_Num': cybox_common.IntegerObjectPropertyType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Process'
        rootClass = WindowsProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Process'
        rootClass = WindowsProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Process'
        rootClass = WindowsProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Process",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Process'
        rootClass = WindowsProcessObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsProcessObjectType",
    "MemorySectionListType",
    "StartupInfoType"
    ]