#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Apr 09 11:15:04 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import win_handle_object
import system_object
import cybox_common
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class GlobalFlagListType(GeneratedsSuper):
    """The GlobalFlagListType type is a listing of all Windows global
    flags."""
    member_data_items_ = {
        'Global_Flag': MemberSpec_('Global_Flag', 'GlobalFlagType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Global_Flag=None):
        if Global_Flag is None:
            self.Global_Flag = []
        else:
            self.Global_Flag = Global_Flag
    def factory(*args_, **kwargs_):
        if GlobalFlagListType.subclass:
            return GlobalFlagListType.subclass(*args_, **kwargs_)
        else:
            return GlobalFlagListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Global_Flag(self): return self.Global_Flag
    def set_Global_Flag(self, Global_Flag): self.Global_Flag = Global_Flag
    def add_Global_Flag(self, value): self.Global_Flag.append(value)
    def insert_Global_Flag(self, index, value): self.Global_Flag[index] = value
    def hasContent_(self):
        if (
            self.Global_Flag
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinSystemObj:', name_='GlobalFlagListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GlobalFlagListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinSystemObj:', name_='GlobalFlagListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinSystemObj:', name_='GlobalFlagListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Global_Flag_ in self.Global_Flag:
            Global_Flag_.export(outfile, level, 'WinSystemObj:', name_='Global_Flag', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GlobalFlagListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Global_Flag=[\n')
        level += 1
        for Global_Flag_ in self.Global_Flag:
            outfile.write('model_.GlobalFlagType(\n')
            Global_Flag_.exportLiteral(outfile, level, name_='GlobalFlagType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Global_Flag':
            obj_ = GlobalFlagType.factory()
            obj_.build(child_)
            self.Global_Flag.append(obj_)
# end class GlobalFlagListType

class GlobalFlagType(GeneratedsSuper):
    """The GlobalFlagType type is intended to characterize Windows global
    flags."""
    member_data_items_ = {
        'Abbreviation': MemberSpec_('Abbreviation', 'cybox_common.StringObjectPropertyType', 0),
        'Destination': MemberSpec_('Destination', 'cybox_common.StringObjectPropertyType', 0),
        'Hexadecimal_Value': MemberSpec_('Hexadecimal_Value', 'cybox_common.HexBinaryObjectPropertyType', 0),
        'Symbolic_Name': MemberSpec_('Symbolic_Name', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Abbreviation=None, Destination=None, Hexadecimal_Value=None, Symbolic_Name=None):
        self.Abbreviation = Abbreviation
        self.Destination = Destination
        self.Hexadecimal_Value = Hexadecimal_Value
        self.Symbolic_Name = Symbolic_Name
    def factory(*args_, **kwargs_):
        if GlobalFlagType.subclass:
            return GlobalFlagType.subclass(*args_, **kwargs_)
        else:
            return GlobalFlagType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Abbreviation(self): return self.Abbreviation
    def set_Abbreviation(self, Abbreviation): self.Abbreviation = Abbreviation
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Destination(self): return self.Destination
    def set_Destination(self, Destination): self.Destination = Destination
    def get_Hexadecimal_Value(self): return self.Hexadecimal_Value
    def set_Hexadecimal_Value(self, Hexadecimal_Value): self.Hexadecimal_Value = Hexadecimal_Value
    def validate_HexBinaryObjectPropertyType(self, value):
        # Validate type cybox_common.HexBinaryObjectPropertyType, a restriction on None.
        pass
    def get_Symbolic_Name(self): return self.Symbolic_Name
    def set_Symbolic_Name(self, Symbolic_Name): self.Symbolic_Name = Symbolic_Name
    def hasContent_(self):
        if (
            self.Abbreviation is not None or
            self.Destination is not None or
            self.Hexadecimal_Value is not None or
            self.Symbolic_Name is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinSystemObj:', name_='GlobalFlagType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GlobalFlagType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinSystemObj:', name_='GlobalFlagType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinSystemObj:', name_='GlobalFlagType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Abbreviation is not None:
            self.Abbreviation.export(outfile, level, 'WinSystemObj:', name_='Abbreviation', pretty_print=pretty_print)
        if self.Destination is not None:
            self.Destination.export(outfile, level, 'WinSystemObj:', name_='Destination', pretty_print=pretty_print)
        if self.Hexadecimal_Value is not None:
            self.Hexadecimal_Value.export(outfile, level, 'WinSystemObj:', name_='Hexadecimal_Value', pretty_print=pretty_print)
        if self.Symbolic_Name is not None:
            self.Symbolic_Name.export(outfile, level, 'WinSystemObj:', name_='Symbolic_Name', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GlobalFlagType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Abbreviation is not None:
            outfile.write('Abbreviation=model_.cybox_common.StringObjectPropertyType(\n')
            self.Abbreviation.exportLiteral(outfile, level, name_='Abbreviation')
            outfile.write('),\n')
        if self.Destination is not None:
            outfile.write('Destination=model_.cybox_common.StringObjectPropertyType(\n')
            self.Destination.exportLiteral(outfile, level, name_='Destination')
            outfile.write('),\n')
        if self.Hexadecimal_Value is not None:
            outfile.write('Hexadecimal_Value=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Hexadecimal_Value.exportLiteral(outfile, level, name_='Hexadecimal_Value')
            outfile.write('),\n')
        if self.Symbolic_Name is not None:
            outfile.write('Symbolic_Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.Symbolic_Name.exportLiteral(outfile, level, name_='Symbolic_Name')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Abbreviation':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Abbreviation(obj_)
        elif nodeName_ == 'Destination':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Destination(obj_)
        elif nodeName_ == 'Hexadecimal_Value':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Hexadecimal_Value(obj_)
        elif nodeName_ == 'Symbolic_Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Symbolic_Name(obj_)
# end class GlobalFlagType

class WindowsSystemObjectType(system_object.SystemObjectType):
    """The WindowsSystemObjectType type is intended to characterize Windows
    systems."""
    member_data_items_ = {
        'Domain': MemberSpec_('Domain', 'cybox_common.StringObjectPropertyType', 1),
        'Global_Flag_List': MemberSpec_('Global_Flag_List', 'GlobalFlagListType', 0),
        'NetBIOS_Name': MemberSpec_('NetBIOS_Name', 'cybox_common.StringObjectPropertyType', 0),
        'Open_Handle_List': MemberSpec_('Open_Handle_List', 'win_handle_object.WindowsHandleListType', 0),
        'Product_ID': MemberSpec_('Product_ID', 'cybox_common.StringObjectPropertyType', 0),
        'Product_Name': MemberSpec_('Product_Name', 'cybox_common.StringObjectPropertyType', 0),
        'Registered_Organization': MemberSpec_('Registered_Organization', 'cybox_common.StringObjectPropertyType', 0),
        'Registered_Owner': MemberSpec_('Registered_Owner', 'cybox_common.StringObjectPropertyType', 0),
        'Windows_Directory': MemberSpec_('Windows_Directory', 'cybox_common.StringObjectPropertyType', 0),
        'Windows_System_Directory': MemberSpec_('Windows_System_Directory', 'cybox_common.StringObjectPropertyType', 0),
        'Windows_Temp_Directory': MemberSpec_('Windows_Temp_Directory', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = system_object.SystemObjectType
    def __init__(self, object_reference=None, Custom_Properties=None, xsi_type=None, Available_Physical_Memory=None, BIOS_Info=None, Date=None, Hostname=None, Local_Time=None, Network_Interface_List=None, OS=None, Processor=None, Processor_Architecture=None, System_Time=None, Timezone_DST=None, Timezone_Standard=None, Total_Physical_Memory=None, Uptime=None, Username=None, Domain=None, Global_Flag_List=None, NetBIOS_Name=None, Open_Handle_List=None, Product_ID=None, Product_Name=None, Registered_Organization=None, Registered_Owner=None, Windows_Directory=None, Windows_System_Directory=None, Windows_Temp_Directory=None):
        super(WindowsSystemObjectType, self).__init__(object_reference, Custom_Properties, Available_Physical_Memory, BIOS_Info, Date, Hostname, Local_Time, Network_Interface_List, OS, Processor, Processor_Architecture, System_Time, Timezone_DST, Timezone_Standard, Total_Physical_Memory, Uptime, Username, )
        if Domain is None:
            self.Domain = []
        else:
            self.Domain = Domain
        self.Global_Flag_List = Global_Flag_List
        self.NetBIOS_Name = NetBIOS_Name
        self.Open_Handle_List = Open_Handle_List
        self.Product_ID = Product_ID
        self.Product_Name = Product_Name
        self.Registered_Organization = Registered_Organization
        self.Registered_Owner = Registered_Owner
        self.Windows_Directory = Windows_Directory
        self.Windows_System_Directory = Windows_System_Directory
        self.Windows_Temp_Directory = Windows_Temp_Directory
    def factory(*args_, **kwargs_):
        if WindowsSystemObjectType.subclass:
            return WindowsSystemObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsSystemObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Domain(self): return self.Domain
    def set_Domain(self, Domain): self.Domain = Domain
    def add_Domain(self, value): self.Domain.append(value)
    def insert_Domain(self, index, value): self.Domain[index] = value
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Global_Flag_List(self): return self.Global_Flag_List
    def set_Global_Flag_List(self, Global_Flag_List): self.Global_Flag_List = Global_Flag_List
    def get_NetBIOS_Name(self): return self.NetBIOS_Name
    def set_NetBIOS_Name(self, NetBIOS_Name): self.NetBIOS_Name = NetBIOS_Name
    def get_Open_Handle_List(self): return self.Open_Handle_List
    def set_Open_Handle_List(self, Open_Handle_List): self.Open_Handle_List = Open_Handle_List
    def get_Product_ID(self): return self.Product_ID
    def set_Product_ID(self, Product_ID): self.Product_ID = Product_ID
    def get_Product_Name(self): return self.Product_Name
    def set_Product_Name(self, Product_Name): self.Product_Name = Product_Name
    def get_Registered_Organization(self): return self.Registered_Organization
    def set_Registered_Organization(self, Registered_Organization): self.Registered_Organization = Registered_Organization
    def get_Registered_Owner(self): return self.Registered_Owner
    def set_Registered_Owner(self, Registered_Owner): self.Registered_Owner = Registered_Owner
    def get_Windows_Directory(self): return self.Windows_Directory
    def set_Windows_Directory(self, Windows_Directory): self.Windows_Directory = Windows_Directory
    def get_Windows_System_Directory(self): return self.Windows_System_Directory
    def set_Windows_System_Directory(self, Windows_System_Directory): self.Windows_System_Directory = Windows_System_Directory
    def get_Windows_Temp_Directory(self): return self.Windows_Temp_Directory
    def set_Windows_Temp_Directory(self, Windows_Temp_Directory): self.Windows_Temp_Directory = Windows_Temp_Directory
    def hasContent_(self):
        if (
            self.Domain or
            self.Global_Flag_List is not None or
            self.NetBIOS_Name is not None or
            self.Open_Handle_List is not None or
            self.Product_ID is not None or
            self.Product_Name is not None or
            self.Registered_Organization is not None or
            self.Registered_Owner is not None or
            self.Windows_Directory is not None or
            self.Windows_System_Directory is not None or
            self.Windows_Temp_Directory is not None or
            super(WindowsSystemObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinSystemObj:', name_='WindowsSystemObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsSystemObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinSystemObj:', name_='WindowsSystemObjectType'):
        super(WindowsSystemObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsSystemObjectType')
    def exportChildren(self, outfile, level, namespace_='WinSystemObj:', name_='WindowsSystemObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsSystemObjectType, self).exportChildren(outfile, level, 'WinSystemObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Domain_ in self.Domain:
            Domain_.export(outfile, level, 'WinSystemObj:', name_='Domain', pretty_print=pretty_print)
        if self.Global_Flag_List is not None:
            self.Global_Flag_List.export(outfile, level, 'WinSystemObj:', name_='Global_Flag_List', pretty_print=pretty_print)
        if self.NetBIOS_Name is not None:
            self.NetBIOS_Name.export(outfile, level, 'WinSystemObj:', name_='NetBIOS_Name', pretty_print=pretty_print)
        if self.Open_Handle_List is not None:
            self.Open_Handle_List.export(outfile, level, 'WinSystemObj:', name_='Open_Handle_List', pretty_print=pretty_print)
        if self.Product_ID is not None:
            self.Product_ID.export(outfile, level, 'WinSystemObj:', name_='Product_ID', pretty_print=pretty_print)
        if self.Product_Name is not None:
            self.Product_Name.export(outfile, level, 'WinSystemObj:', name_='Product_Name', pretty_print=pretty_print)
        if self.Registered_Organization is not None:
            self.Registered_Organization.export(outfile, level, 'WinSystemObj:', name_='Registered_Organization', pretty_print=pretty_print)
        if self.Registered_Owner is not None:
            self.Registered_Owner.export(outfile, level, 'WinSystemObj:', name_='Registered_Owner', pretty_print=pretty_print)
        if self.Windows_Directory is not None:
            self.Windows_Directory.export(outfile, level, 'WinSystemObj:', name_='Windows_Directory', pretty_print=pretty_print)
        if self.Windows_System_Directory is not None:
            self.Windows_System_Directory.export(outfile, level, 'WinSystemObj:', name_='Windows_System_Directory', pretty_print=pretty_print)
        if self.Windows_Temp_Directory is not None:
            self.Windows_Temp_Directory.export(outfile, level, 'WinSystemObj:', name_='Windows_Temp_Directory', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='WindowsSystemObjectType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsSystemObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsSystemObjectType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Domain=[\n')
        level += 1
        for Domain_ in self.Domain:
            outfile.write('model_.cybox_common.StringObjectPropertyType(\n')
            Domain_.exportLiteral(outfile, level, name_='cybox_common.StringObjectPropertyType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Global_Flag_List is not None:
            outfile.write('Global_Flag_List=model_.GlobalFlagListType(\n')
            self.Global_Flag_List.exportLiteral(outfile, level, name_='Global_Flag_List')
            outfile.write('),\n')
        if self.NetBIOS_Name is not None:
            outfile.write('NetBIOS_Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.NetBIOS_Name.exportLiteral(outfile, level, name_='NetBIOS_Name')
            outfile.write('),\n')
        if self.Open_Handle_List is not None:
            outfile.write('Open_Handle_List=model_.win_handle_object.WindowsHandleListType(\n')
            self.Open_Handle_List.exportLiteral(outfile, level, name_='Open_Handle_List')
            outfile.write('),\n')
        if self.Product_ID is not None:
            outfile.write('Product_ID=model_.cybox_common.StringObjectPropertyType(\n')
            self.Product_ID.exportLiteral(outfile, level, name_='Product_ID')
            outfile.write('),\n')
        if self.Product_Name is not None:
            outfile.write('Product_Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.Product_Name.exportLiteral(outfile, level, name_='Product_Name')
            outfile.write('),\n')
        if self.Registered_Organization is not None:
            outfile.write('Registered_Organization=model_.cybox_common.StringObjectPropertyType(\n')
            self.Registered_Organization.exportLiteral(outfile, level, name_='Registered_Organization')
            outfile.write('),\n')
        if self.Registered_Owner is not None:
            outfile.write('Registered_Owner=model_.cybox_common.StringObjectPropertyType(\n')
            self.Registered_Owner.exportLiteral(outfile, level, name_='Registered_Owner')
            outfile.write('),\n')
        if self.Windows_Directory is not None:
            outfile.write('Windows_Directory=model_.cybox_common.StringObjectPropertyType(\n')
            self.Windows_Directory.exportLiteral(outfile, level, name_='Windows_Directory')
            outfile.write('),\n')
        if self.Windows_System_Directory is not None:
            outfile.write('Windows_System_Directory=model_.cybox_common.StringObjectPropertyType(\n')
            self.Windows_System_Directory.exportLiteral(outfile, level, name_='Windows_System_Directory')
            outfile.write('),\n')
        if self.Windows_Temp_Directory is not None:
            outfile.write('Windows_Temp_Directory=model_.cybox_common.StringObjectPropertyType(\n')
            self.Windows_Temp_Directory.exportLiteral(outfile, level, name_='Windows_Temp_Directory')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsSystemObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Domain':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.Domain.append(obj_)
        elif nodeName_ == 'Global_Flag_List':
            obj_ = GlobalFlagListType.factory()
            obj_.build(child_)
            self.set_Global_Flag_List(obj_)
        elif nodeName_ == 'NetBIOS_Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_NetBIOS_Name(obj_)
        elif nodeName_ == 'Open_Handle_List':
            obj_ = win_handle_object.WindowsHandleListType.factory()
            obj_.build(child_)
            self.set_Open_Handle_List(obj_)
        elif nodeName_ == 'Product_ID':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Product_ID(obj_)
        elif nodeName_ == 'Product_Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Product_Name(obj_)
        elif nodeName_ == 'Registered_Organization':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Registered_Organization(obj_)
        elif nodeName_ == 'Registered_Owner':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Registered_Owner(obj_)
        elif nodeName_ == 'Windows_Directory':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Windows_Directory(obj_)
        elif nodeName_ == 'Windows_System_Directory':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Windows_System_Directory(obj_)
        elif nodeName_ == 'Windows_Temp_Directory':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Windows_Temp_Directory(obj_)
        super(WindowsSystemObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsSystemObjectType

GDSClassesMapping = {
    'Build_Utility': cybox_common.BuildUtilityType,
    'Errors': cybox_common.ErrorsType,
    'Open_Handle_List': win_handle_object.WindowsHandleListType,
    'DHCP_Lease_Expires': cybox_common.DateTimeObjectPropertyType,
    'Destination': cybox_common.StringObjectPropertyType,
    'Processor_Architecture': system_object.ProcessorArchType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'Hexadecimal_Value': cybox_common.HexBinaryObjectPropertyType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'BIOS_Date': cybox_common.DateObjectPropertyType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'SubDatum': cybox_common.MetadataType,
    'Segment_Hash': cybox_common.HashValueType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'Network_Interface_List': system_object.NetworkInterfaceListType,
    'NetBIOS_Name': cybox_common.StringObjectPropertyType,
    'Length': cybox_common.IntegerObjectPropertyType,
    'IP_Gateway_List': system_object.IPGatewayListType,
    'Windows_System_Directory': cybox_common.StringObjectPropertyType,
    'Registered_Owner': cybox_common.StringObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Abbreviation': cybox_common.StringObjectPropertyType,
    'MAC': cybox_common.StringObjectPropertyType,
    'Object_Address': cybox_common.UnsignedLongObjectPropertyType,
    'Compiler': cybox_common.CompilerType,
    'OS': system_object.OSType,
    'Functions': cybox_common.FunctionsType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'Pointer_Count': cybox_common.UnsignedLongObjectPropertyType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'System': system_object.SystemObjectType,
    'Platform': cybox_common.PlatformSpecificationType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'Type': cybox_common.ControlledVocabularyStringType,
    'Compilers': cybox_common.CompilersType,
    'Username': cybox_common.StringObjectPropertyType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'String': cybox_common.ExtractedStringType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
    'Build_Information': cybox_common.BuildInformationType,
    'Tool_Hashes': cybox_common.HashListType,
    'Product_Name': cybox_common.StringObjectPropertyType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'BIOS_Info': system_object.BIOSInfoType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'Registered_Organization': cybox_common.StringObjectPropertyType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'Domain': cybox_common.StringObjectPropertyType,
    'Contributors': cybox_common.PersonnelType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'BIOS_Manufacturer': cybox_common.StringObjectPropertyType,
    'Reference_Description': cybox_common.StructuredTextType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Available_Physical_Memory': cybox_common.UnsignedLongObjectPropertyType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'Uptime': cybox_common.DurationObjectPropertyType,
    'IP_List': system_object.IPInfoListType,
    'Timezone_DST': cybox_common.StringObjectPropertyType,
    'Hostname': cybox_common.StringObjectPropertyType,
    'Instance': cybox_common.ObjectPropertiesType,
    'Bitness': system_object.BitnessType,
    'BIOS_Version': cybox_common.StringObjectPropertyType,
    'Import': cybox_common.StringObjectPropertyType,
    'Access_Mask': cybox_common.UnsignedLongObjectPropertyType,
    'IP_Info': system_object.IPInfoType,
    'System_Time': cybox_common.TimeObjectPropertyType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'Build_Number': cybox_common.StringObjectPropertyType,
    'Adapter': cybox_common.StringObjectPropertyType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'Patch_Level': cybox_common.StringObjectPropertyType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Dependencies': cybox_common.DependenciesType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Date': cybox_common.DateObjectPropertyType,
    'Hashes': cybox_common.HashListType,
    'Segments': cybox_common.HashSegmentsType,
    'Windows_Directory': cybox_common.StringObjectPropertyType,
    'DHCP_Server_List': system_object.DHCPServerListType,
    'Language': cybox_common.StringObjectPropertyType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'Dependency': cybox_common.DependencyType,
    'Error': cybox_common.ErrorType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'Byte_Run': cybox_common.ByteRunType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'Imports': cybox_common.ImportsType,
    'Install_Date': cybox_common.DateObjectPropertyType,
    'Total_Physical_Memory': cybox_common.UnsignedLongObjectPropertyType,
    'Library': cybox_common.LibraryType,
    'DHCP_Lease_Obtained': cybox_common.DateTimeObjectPropertyType,
    'References': cybox_common.ToolReferencesType,
    'Network_Interface': system_object.NetworkInterfaceType,
    'Windows_Handle': win_handle_object.WindowsHandleObjectType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Time': cybox_common.TimeType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'Data_Size': cybox_common.DataSizeType,
    'Libraries': cybox_common.LibrariesType,
    'Function': cybox_common.StringObjectPropertyType,
    'Timezone_Standard': cybox_common.StringObjectPropertyType,
    'Handle': win_handle_object.WindowsHandleObjectType,
    'Description': cybox_common.StringObjectPropertyType,
    'BIOS_Serial_Number': cybox_common.StringObjectPropertyType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'Symbolic_Name': cybox_common.StringObjectPropertyType,
    'VLAN_Name': cybox_common.StringObjectPropertyType,
    'Local_Time': cybox_common.TimeObjectPropertyType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Name': cybox_common.StringObjectPropertyType,
    'Processor': cybox_common.StringObjectPropertyType,
    'Address_Value': cybox_common.StringObjectPropertyType,
    'Environment_Variable_List': cybox_common.EnvironmentVariableListType,
    'VLAN_Num': cybox_common.IntegerObjectPropertyType,
    'Value': cybox_common.StringObjectPropertyType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'ID': cybox_common.UnsignedIntegerObjectPropertyType,
    'Windows_Temp_Directory': cybox_common.StringObjectPropertyType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'BIOS_Release_Date': cybox_common.DateObjectPropertyType,
    'Contributor': cybox_common.ContributorType,
    'Product_ID': cybox_common.StringObjectPropertyType,
    'Tools': cybox_common.ToolsInformationType,
    'Tool': cybox_common.ToolInformationType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_System'
        rootClass = WindowsSystemObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_System'
        rootClass = WindowsSystemObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_System'
        rootClass = WindowsSystemObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_System",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_System'
        rootClass = WindowsSystemObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsSystemObjectType",
    "GlobalFlagListType",
    "GlobalFlagType"
    ]