#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Apr 09 11:15:06 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import cybox_common
import email_message_object
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class TriggerListType(GeneratedsSuper):
    """The TriggerListType type specifies a set of triggers associated with
    the scheduled task."""
    member_data_items_ = {
        'Trigger': MemberSpec_('Trigger', 'TriggerType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Trigger=None):
        if Trigger is None:
            self.Trigger = []
        else:
            self.Trigger = Trigger
    def factory(*args_, **kwargs_):
        if TriggerListType.subclass:
            return TriggerListType.subclass(*args_, **kwargs_)
        else:
            return TriggerListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Trigger(self): return self.Trigger
    def set_Trigger(self, Trigger): self.Trigger = Trigger
    def add_Trigger(self, value): self.Trigger.append(value)
    def insert_Trigger(self, index, value): self.Trigger[index] = value
    def hasContent_(self):
        if (
            self.Trigger
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TriggerListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TriggerListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TriggerListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TriggerListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Trigger_ in self.Trigger:
            Trigger_.export(outfile, level, 'WinTaskObj:', name_='Trigger', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='TriggerListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Trigger=[\n')
        level += 1
        for Trigger_ in self.Trigger:
            outfile.write('model_.TriggerType(\n')
            Trigger_.exportLiteral(outfile, level, name_='TriggerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Trigger':
            obj_ = TriggerType.factory()
            obj_.build(child_)
            self.Trigger.append(obj_)
# end class TriggerListType

class TriggerType(GeneratedsSuper):
    """The TriggerType type characterizes task triggers. See also:
    http://msdn.microsoft.com/en-
    us/library/windows/desktop/aa383868(v=vs.85).aspxThe enabled
    field specifies whether the trigger is enabled."""
    member_data_items_ = {
        'enabled': MemberSpec_('enabled', 'xs:boolean', 0),
        'Trigger_Begin': MemberSpec_('Trigger_Begin', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Trigger_Delay': MemberSpec_('Trigger_Delay', 'cybox_common.DurationObjectPropertyType', 0),
        'Trigger_End': MemberSpec_('Trigger_End', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Trigger_Frequency': MemberSpec_('Trigger_Frequency', 'TaskTriggerFrequencyType', 0),
        'Trigger_Max_Run_Time': MemberSpec_('Trigger_Max_Run_Time', 'cybox_common.DurationObjectPropertyType', 0),
        'Trigger_Session_Change_Type': MemberSpec_('Trigger_Session_Change_Type', 'cybox_common.StringObjectPropertyType', 0),
        'Trigger_Type': MemberSpec_('Trigger_Type', 'TriggerType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, enabled=None, Trigger_Begin=None, Trigger_Delay=None, Trigger_End=None, Trigger_Frequency=None, Trigger_Max_Run_Time=None, Trigger_Session_Change_Type=None, Trigger_Type=None):
        self.enabled = _cast(bool, enabled)
        self.Trigger_Begin = Trigger_Begin
        self.Trigger_Delay = Trigger_Delay
        self.Trigger_End = Trigger_End
        self.Trigger_Frequency = Trigger_Frequency
        self.Trigger_Max_Run_Time = Trigger_Max_Run_Time
        self.Trigger_Session_Change_Type = Trigger_Session_Change_Type
        self.Trigger_Type = Trigger_Type
    def factory(*args_, **kwargs_):
        if TriggerType.subclass:
            return TriggerType.subclass(*args_, **kwargs_)
        else:
            return TriggerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Trigger_Begin(self): return self.Trigger_Begin
    def set_Trigger_Begin(self, Trigger_Begin): self.Trigger_Begin = Trigger_Begin
    def validate_DateTimeObjectPropertyType(self, value):
        # Validate type cybox_common.DateTimeObjectPropertyType, a restriction on None.
        pass
    def get_Trigger_Delay(self): return self.Trigger_Delay
    def set_Trigger_Delay(self, Trigger_Delay): self.Trigger_Delay = Trigger_Delay
    def validate_DurationObjectPropertyType(self, value):
        # Validate type cybox_common.DurationObjectPropertyType, a restriction on None.
        pass
    def get_Trigger_End(self): return self.Trigger_End
    def set_Trigger_End(self, Trigger_End): self.Trigger_End = Trigger_End
    def get_Trigger_Frequency(self): return self.Trigger_Frequency
    def set_Trigger_Frequency(self, Trigger_Frequency): self.Trigger_Frequency = Trigger_Frequency
    def validate_TaskTriggerFrequencyType(self, value):
        # Validate type TaskTriggerFrequencyType, a restriction on None.
        pass
    def get_Trigger_Max_Run_Time(self): return self.Trigger_Max_Run_Time
    def set_Trigger_Max_Run_Time(self, Trigger_Max_Run_Time): self.Trigger_Max_Run_Time = Trigger_Max_Run_Time
    def get_Trigger_Session_Change_Type(self): return self.Trigger_Session_Change_Type
    def set_Trigger_Session_Change_Type(self, Trigger_Session_Change_Type): self.Trigger_Session_Change_Type = Trigger_Session_Change_Type
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Trigger_Type(self): return self.Trigger_Type
    def set_Trigger_Type(self, Trigger_Type): self.Trigger_Type = Trigger_Type
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def hasContent_(self):
        if (
            self.Trigger_Begin is not None or
            self.Trigger_Delay is not None or
            self.Trigger_End is not None or
            self.Trigger_Frequency is not None or
            self.Trigger_Max_Run_Time is not None or
            self.Trigger_Session_Change_Type is not None or
            self.Trigger_Type is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TriggerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TriggerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TriggerType'):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            outfile.write(' enabled="%s"' % self.gds_format_boolean(self.enabled, input_name='enabled'))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TriggerType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Trigger_Begin is not None:
            self.Trigger_Begin.export(outfile, level, 'WinTaskObj:', name_='Trigger_Begin', pretty_print=pretty_print)
        if self.Trigger_Delay is not None:
            self.Trigger_Delay.export(outfile, level, 'WinTaskObj:', name_='Trigger_Delay', pretty_print=pretty_print)
        if self.Trigger_End is not None:
            self.Trigger_End.export(outfile, level, 'WinTaskObj:', name_='Trigger_End', pretty_print=pretty_print)
        if self.Trigger_Frequency is not None:
            self.Trigger_Frequency.export(outfile, level, 'WinTaskObj:', name_='Trigger_Frequency', pretty_print=pretty_print)
        if self.Trigger_Max_Run_Time is not None:
            self.Trigger_Max_Run_Time.export(outfile, level, 'WinTaskObj:', name_='Trigger_Max_Run_Time', pretty_print=pretty_print)
        if self.Trigger_Session_Change_Type is not None:
            self.Trigger_Session_Change_Type.export(outfile, level, 'WinTaskObj:', name_='Trigger_Session_Change_Type', pretty_print=pretty_print)
        if self.Trigger_Type is not None:
            self.Trigger_Type.export(outfile, level, 'WinTaskObj:', name_='Trigger_Type', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='TriggerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            showIndent(outfile, level)
            outfile.write('enabled = %s,\n' % (self.enabled,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Trigger_Begin is not None:
            outfile.write('Trigger_Begin=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Trigger_Begin.exportLiteral(outfile, level, name_='Trigger_Begin')
            outfile.write('),\n')
        if self.Trigger_Delay is not None:
            outfile.write('Trigger_Delay=model_.cybox_common.DurationObjectPropertyType(\n')
            self.Trigger_Delay.exportLiteral(outfile, level, name_='Trigger_Delay')
            outfile.write('),\n')
        if self.Trigger_End is not None:
            outfile.write('Trigger_End=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Trigger_End.exportLiteral(outfile, level, name_='Trigger_End')
            outfile.write('),\n')
        if self.Trigger_Frequency is not None:
            outfile.write('Trigger_Frequency=model_.TaskTriggerFrequencyType(\n')
            self.Trigger_Frequency.exportLiteral(outfile, level, name_='Trigger_Frequency')
            outfile.write('),\n')
        if self.Trigger_Max_Run_Time is not None:
            outfile.write('Trigger_Max_Run_Time=model_.cybox_common.DurationObjectPropertyType(\n')
            self.Trigger_Max_Run_Time.exportLiteral(outfile, level, name_='Trigger_Max_Run_Time')
            outfile.write('),\n')
        if self.Trigger_Session_Change_Type is not None:
            outfile.write('Trigger_Session_Change_Type=model_.cybox_common.StringObjectPropertyType(\n')
            self.Trigger_Session_Change_Type.exportLiteral(outfile, level, name_='Trigger_Session_Change_Type')
            outfile.write('),\n')
        if self.Trigger_Type is not None:
            outfile.write('Trigger_Type=model_.TriggerType(\n')
            self.Trigger_Type.exportLiteral(outfile, level, name_='Trigger_Type')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('enabled', node)
        if value is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            if value in ('true', '1'):
                self.enabled = True
            elif value in ('false', '0'):
                self.enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Trigger_Begin':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Trigger_Begin(obj_)
        elif nodeName_ == 'Trigger_Delay':
            obj_ = cybox_common.DurationObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Trigger_Delay(obj_)
        elif nodeName_ == 'Trigger_End':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Trigger_End(obj_)
        elif nodeName_ == 'Trigger_Frequency':
            obj_ = TaskTriggerFrequencyType.factory()
            obj_.build(child_)
            self.set_Trigger_Frequency(obj_)
        elif nodeName_ == 'Trigger_Max_Run_Time':
            obj_ = cybox_common.DurationObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Trigger_Max_Run_Time(obj_)
        elif nodeName_ == 'Trigger_Session_Change_Type':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Trigger_Session_Change_Type(obj_)
        elif nodeName_ == 'Trigger_Type':
            obj_ = TriggerType.factory()
            obj_.build(child_)
            self.set_Trigger_Type(obj_)
# end class TriggerType

class TaskActionListType(GeneratedsSuper):
    """The TaskActionListType type specifies a list of task actions."""
    member_data_items_ = {
        'Action': MemberSpec_('Action', 'TaskActionType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, Action=None):
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
    def factory(*args_, **kwargs_):
        if TaskActionListType.subclass:
            return TaskActionListType.subclass(*args_, **kwargs_)
        else:
            return TaskActionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def hasContent_(self):
        if (
            self.Action
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskActionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskActionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Action_ in self.Action:
            Action_.export(outfile, level, 'WinTaskObj:', name_='Action', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='TaskActionListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            outfile.write('model_.TaskActionType(\n')
            Action_.exportLiteral(outfile, level, name_='TaskActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action':
            obj_ = TaskActionType.factory()
            obj_.build(child_)
            self.Action.append(obj_)
# end class TaskActionListType

class TaskActionType(GeneratedsSuper):
    """The TaskActionType type characterizes scheduled task actions."""
    member_data_items_ = {
        'Action_Type': MemberSpec_('Action_Type', 'TaskActionTypeType', 0),
        'Action_ID': MemberSpec_('Action_ID', 'cybox_common.StringObjectPropertyType', 0),
        'IEmailAction': MemberSpec_('IEmailAction', 'email_message_object.EmailMessageObjectType', 0),
        'IComHandlerAction': MemberSpec_('IComHandlerAction', 'IComHandlerActionType', 0),
        'IExecAction': MemberSpec_('IExecAction', 'IExecActionType', 0),
        'IShowMessageAction': MemberSpec_('IShowMessageAction', 'IShowMessageActionType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Action_Type=None, Action_ID=None, IEmailAction=None, IComHandlerAction=None, IExecAction=None, IShowMessageAction=None):
        self.Action_Type = Action_Type
        self.Action_ID = Action_ID
        self.IEmailAction = IEmailAction
        self.IComHandlerAction = IComHandlerAction
        self.IExecAction = IExecAction
        self.IShowMessageAction = IShowMessageAction
    def factory(*args_, **kwargs_):
        if TaskActionType.subclass:
            return TaskActionType.subclass(*args_, **kwargs_)
        else:
            return TaskActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_Type(self): return self.Action_Type
    def set_Action_Type(self, Action_Type): self.Action_Type = Action_Type
    def validate_TaskActionTypeType(self, value):
        # Validate type TaskActionTypeType, a restriction on None.
        pass
    def get_Action_ID(self): return self.Action_ID
    def set_Action_ID(self, Action_ID): self.Action_ID = Action_ID
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_IEmailAction(self): return self.IEmailAction
    def set_IEmailAction(self, IEmailAction): self.IEmailAction = IEmailAction
    def get_IComHandlerAction(self): return self.IComHandlerAction
    def set_IComHandlerAction(self, IComHandlerAction): self.IComHandlerAction = IComHandlerAction
    def get_IExecAction(self): return self.IExecAction
    def set_IExecAction(self, IExecAction): self.IExecAction = IExecAction
    def get_IShowMessageAction(self): return self.IShowMessageAction
    def set_IShowMessageAction(self, IShowMessageAction): self.IShowMessageAction = IShowMessageAction
    def hasContent_(self):
        if (
            self.Action_Type is not None or
            self.Action_ID is not None or
            self.IEmailAction is not None or
            self.IComHandlerAction is not None or
            self.IExecAction is not None or
            self.IShowMessageAction is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskActionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Action_Type is not None:
            self.Action_Type.export(outfile, level, 'WinTaskObj:', name_='Action_Type', pretty_print=pretty_print)
        if self.Action_ID is not None:
            self.Action_ID.export(outfile, level, 'WinTaskObj:', name_='Action_ID', pretty_print=pretty_print)
        if self.IEmailAction is not None:
            self.IEmailAction.export(outfile, level, 'WinTaskObj:', name_='IEmailAction', pretty_print=pretty_print)
        if self.IComHandlerAction is not None:
            self.IComHandlerAction.export(outfile, level, 'WinTaskObj:', name_='IComHandlerAction', pretty_print=pretty_print)
        if self.IExecAction is not None:
            self.IExecAction.export(outfile, level, 'WinTaskObj:', name_='IExecAction', pretty_print=pretty_print)
        if self.IShowMessageAction is not None:
            self.IShowMessageAction.export(outfile, level, 'WinTaskObj:', name_='IShowMessageAction', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='TaskActionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Action_Type is not None:
            outfile.write('Action_Type=model_.TaskActionTypeType(\n')
            self.Action_Type.exportLiteral(outfile, level, name_='Action_Type')
            outfile.write('),\n')
        if self.Action_ID is not None:
            outfile.write('Action_ID=model_.cybox_common.StringObjectPropertyType(\n')
            self.Action_ID.exportLiteral(outfile, level, name_='Action_ID')
            outfile.write('),\n')
        if self.IEmailAction is not None:
            outfile.write('IEmailAction=model_.email_message_object.EmailMessageObjectType(\n')
            self.IEmailAction.exportLiteral(outfile, level, name_='IEmailAction')
            outfile.write('),\n')
        if self.IComHandlerAction is not None:
            outfile.write('IComHandlerAction=model_.IComHandlerActionType(\n')
            self.IComHandlerAction.exportLiteral(outfile, level, name_='IComHandlerAction')
            outfile.write('),\n')
        if self.IExecAction is not None:
            outfile.write('IExecAction=model_.IExecActionType(\n')
            self.IExecAction.exportLiteral(outfile, level, name_='IExecAction')
            outfile.write('),\n')
        if self.IShowMessageAction is not None:
            outfile.write('IShowMessageAction=model_.IShowMessageActionType(\n')
            self.IShowMessageAction.exportLiteral(outfile, level, name_='IShowMessageAction')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action_Type':
            obj_ = TaskActionTypeType.factory()
            obj_.build(child_)
            self.set_Action_Type(obj_)
        elif nodeName_ == 'Action_ID':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Action_ID(obj_)
        elif nodeName_ == 'IEmailAction':
            obj_ = email_message_object.EmailMessageObjectType.factory()
            obj_.build(child_)
            self.set_IEmailAction(obj_)
        elif nodeName_ == 'IComHandlerAction':
            obj_ = IComHandlerActionType.factory()
            obj_.build(child_)
            self.set_IComHandlerAction(obj_)
        elif nodeName_ == 'IExecAction':
            obj_ = IExecActionType.factory()
            obj_.build(child_)
            self.set_IExecAction(obj_)
        elif nodeName_ == 'IShowMessageAction':
            obj_ = IShowMessageActionType.factory()
            obj_.build(child_)
            self.set_IShowMessageAction(obj_)
# end class TaskActionType

class IComHandlerActionType(GeneratedsSuper):
    """The IComHandlerActionType type characterizes IComHandler actions."""
    member_data_items_ = {
        'COM_Data': MemberSpec_('COM_Data', 'cybox_common.StringObjectPropertyType', 0),
        'COM_Class_ID': MemberSpec_('COM_Class_ID', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, COM_Data=None, COM_Class_ID=None):
        self.COM_Data = COM_Data
        self.COM_Class_ID = COM_Class_ID
    def factory(*args_, **kwargs_):
        if IComHandlerActionType.subclass:
            return IComHandlerActionType.subclass(*args_, **kwargs_)
        else:
            return IComHandlerActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_COM_Data(self): return self.COM_Data
    def set_COM_Data(self, COM_Data): self.COM_Data = COM_Data
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_COM_Class_ID(self): return self.COM_Class_ID
    def set_COM_Class_ID(self, COM_Class_ID): self.COM_Class_ID = COM_Class_ID
    def hasContent_(self):
        if (
            self.COM_Data is not None or
            self.COM_Class_ID is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='IComHandlerActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IComHandlerActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='IComHandlerActionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='IComHandlerActionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.COM_Data is not None:
            self.COM_Data.export(outfile, level, 'WinTaskObj:', name_='COM_Data', pretty_print=pretty_print)
        if self.COM_Class_ID is not None:
            self.COM_Class_ID.export(outfile, level, 'WinTaskObj:', name_='COM_Class_ID', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IComHandlerActionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.COM_Data is not None:
            outfile.write('COM_Data=model_.cybox_common.StringObjectPropertyType(\n')
            self.COM_Data.exportLiteral(outfile, level, name_='COM_Data')
            outfile.write('),\n')
        if self.COM_Class_ID is not None:
            outfile.write('COM_Class_ID=model_.cybox_common.StringObjectPropertyType(\n')
            self.COM_Class_ID.exportLiteral(outfile, level, name_='COM_Class_ID')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'COM_Data':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_COM_Data(obj_)
        elif nodeName_ == 'COM_Class_ID':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_COM_Class_ID(obj_)
# end class IComHandlerActionType

class IExecActionType(GeneratedsSuper):
    """The IExecActionType type characterizes IExec actions."""
    member_data_items_ = {
        'Exec_Arguments': MemberSpec_('Exec_Arguments', 'cybox_common.StringObjectPropertyType', 0),
        'Exec_Program_Path': MemberSpec_('Exec_Program_Path', 'cybox_common.StringObjectPropertyType', 0),
        'Exec_Working_Directory': MemberSpec_('Exec_Working_Directory', 'cybox_common.StringObjectPropertyType', 0),
        'Exec_Program_Hashes': MemberSpec_('Exec_Program_Hashes', 'cybox_common.HashListType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Exec_Arguments=None, Exec_Program_Path=None, Exec_Working_Directory=None, Exec_Program_Hashes=None):
        self.Exec_Arguments = Exec_Arguments
        self.Exec_Program_Path = Exec_Program_Path
        self.Exec_Working_Directory = Exec_Working_Directory
        self.Exec_Program_Hashes = Exec_Program_Hashes
    def factory(*args_, **kwargs_):
        if IExecActionType.subclass:
            return IExecActionType.subclass(*args_, **kwargs_)
        else:
            return IExecActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Exec_Arguments(self): return self.Exec_Arguments
    def set_Exec_Arguments(self, Exec_Arguments): self.Exec_Arguments = Exec_Arguments
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Exec_Program_Path(self): return self.Exec_Program_Path
    def set_Exec_Program_Path(self, Exec_Program_Path): self.Exec_Program_Path = Exec_Program_Path
    def get_Exec_Working_Directory(self): return self.Exec_Working_Directory
    def set_Exec_Working_Directory(self, Exec_Working_Directory): self.Exec_Working_Directory = Exec_Working_Directory
    def get_Exec_Program_Hashes(self): return self.Exec_Program_Hashes
    def set_Exec_Program_Hashes(self, Exec_Program_Hashes): self.Exec_Program_Hashes = Exec_Program_Hashes
    def hasContent_(self):
        if (
            self.Exec_Arguments is not None or
            self.Exec_Program_Path is not None or
            self.Exec_Working_Directory is not None or
            self.Exec_Program_Hashes is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='IExecActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IExecActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='IExecActionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='IExecActionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Exec_Arguments is not None:
            self.Exec_Arguments.export(outfile, level, 'WinTaskObj:', name_='Exec_Arguments', pretty_print=pretty_print)
        if self.Exec_Program_Path is not None:
            self.Exec_Program_Path.export(outfile, level, 'WinTaskObj:', name_='Exec_Program_Path', pretty_print=pretty_print)
        if self.Exec_Working_Directory is not None:
            self.Exec_Working_Directory.export(outfile, level, 'WinTaskObj:', name_='Exec_Working_Directory', pretty_print=pretty_print)
        if self.Exec_Program_Hashes is not None:
            self.Exec_Program_Hashes.export(outfile, level, 'WinTaskObj:', name_='Exec_Program_Hashes', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IExecActionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Exec_Arguments is not None:
            outfile.write('Exec_Arguments=model_.cybox_common.StringObjectPropertyType(\n')
            self.Exec_Arguments.exportLiteral(outfile, level, name_='Exec_Arguments')
            outfile.write('),\n')
        if self.Exec_Program_Path is not None:
            outfile.write('Exec_Program_Path=model_.cybox_common.StringObjectPropertyType(\n')
            self.Exec_Program_Path.exportLiteral(outfile, level, name_='Exec_Program_Path')
            outfile.write('),\n')
        if self.Exec_Working_Directory is not None:
            outfile.write('Exec_Working_Directory=model_.cybox_common.StringObjectPropertyType(\n')
            self.Exec_Working_Directory.exportLiteral(outfile, level, name_='Exec_Working_Directory')
            outfile.write('),\n')
        if self.Exec_Program_Hashes is not None:
            outfile.write('Exec_Program_Hashes=model_.cybox_common.HashListType(\n')
            self.Exec_Program_Hashes.exportLiteral(outfile, level, name_='Exec_Program_Hashes')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Exec_Arguments':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Exec_Arguments(obj_)
        elif nodeName_ == 'Exec_Program_Path':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Exec_Program_Path(obj_)
        elif nodeName_ == 'Exec_Working_Directory':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Exec_Working_Directory(obj_)
        elif nodeName_ == 'Exec_Program_Hashes':
            obj_ = cybox_common.HashListType.factory()
            obj_.build(child_)
            self.set_Exec_Program_Hashes(obj_)
# end class IExecActionType

class IShowMessageActionType(GeneratedsSuper):
    """The IShowMessageActionType type characterizes IShowMessage actions."""
    member_data_items_ = {
        'Show_Message_Body': MemberSpec_('Show_Message_Body', 'cybox_common.StringObjectPropertyType', 0),
        'Show_Message_Title': MemberSpec_('Show_Message_Title', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Show_Message_Body=None, Show_Message_Title=None):
        self.Show_Message_Body = Show_Message_Body
        self.Show_Message_Title = Show_Message_Title
    def factory(*args_, **kwargs_):
        if IShowMessageActionType.subclass:
            return IShowMessageActionType.subclass(*args_, **kwargs_)
        else:
            return IShowMessageActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Show_Message_Body(self): return self.Show_Message_Body
    def set_Show_Message_Body(self, Show_Message_Body): self.Show_Message_Body = Show_Message_Body
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Show_Message_Title(self): return self.Show_Message_Title
    def set_Show_Message_Title(self, Show_Message_Title): self.Show_Message_Title = Show_Message_Title
    def hasContent_(self):
        if (
            self.Show_Message_Body is not None or
            self.Show_Message_Title is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='IShowMessageActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IShowMessageActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='IShowMessageActionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='IShowMessageActionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Show_Message_Body is not None:
            self.Show_Message_Body.export(outfile, level, 'WinTaskObj:', name_='Show_Message_Body', pretty_print=pretty_print)
        if self.Show_Message_Title is not None:
            self.Show_Message_Title.export(outfile, level, 'WinTaskObj:', name_='Show_Message_Title', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IShowMessageActionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Show_Message_Body is not None:
            outfile.write('Show_Message_Body=model_.cybox_common.StringObjectPropertyType(\n')
            self.Show_Message_Body.exportLiteral(outfile, level, name_='Show_Message_Body')
            outfile.write('),\n')
        if self.Show_Message_Title is not None:
            outfile.write('Show_Message_Title=model_.cybox_common.StringObjectPropertyType(\n')
            self.Show_Message_Title.exportLiteral(outfile, level, name_='Show_Message_Title')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Show_Message_Body':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Show_Message_Body(obj_)
        elif nodeName_ == 'Show_Message_Title':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Show_Message_Title(obj_)
# end class IShowMessageActionType

class TaskStatusType(cybox_common.BaseObjectPropertyType):
    """The TaskStatusType type specifies Windows Task states via a union of
    the TaskStatusEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common.BaseObjectPropertyType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['TaskStatusType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskStatusType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskStatusType.subclass:
            return TaskStatusType.subclass(*args_, **kwargs_)
        else:
            return TaskStatusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskStatusType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskStatusType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskStatusType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskStatusType'):
        super(TaskStatusType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskStatusType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskStatusType', fromsubclass_=False, pretty_print=True):
        super(TaskStatusType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='TaskStatusType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskStatusType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskStatusType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(TaskStatusType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskStatusType

class TaskTriggerType(cybox_common.BaseObjectPropertyType):
    """The TaskTriggerType type specifies Windows Task trigger types via a
    union of the TriggerTypeEnum enumeration and the atomic
    xs:string type. Its base type is the CybOX Core
    cybox_common.BaseObjectPropertyType, for permitting complex (i.e. regular-
    expression based) specifications.This attribute is optional and
    specifies the expected type for the value of the specified
    property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['TaskTriggerType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskTriggerType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskTriggerType.subclass:
            return TaskTriggerType.subclass(*args_, **kwargs_)
        else:
            return TaskTriggerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskTriggerType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskTriggerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskTriggerType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskTriggerType'):
        super(TaskTriggerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskTriggerType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskTriggerType', fromsubclass_=False, pretty_print=True):
        super(TaskTriggerType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='TaskTriggerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskTriggerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskTriggerType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(TaskTriggerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskTriggerType

class TaskTriggerFrequencyType(cybox_common.BaseObjectPropertyType):
    """The TaskTriggerFrequencyType type specifies Windows Task trigger
    frequency types via a union of the TriggerFrequencyEnum type and
    the atomic xs:string type. Its base type is the CybOX Core
    cybox_common.BaseObjectPropertyType, for permitting complex (i.e. regular-
    expression based) specifications.This attribute is optional and
    specifies the expected type for the value of the specified
    property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['TaskTriggerFrequencyType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskTriggerFrequencyType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskTriggerFrequencyType.subclass:
            return TaskTriggerFrequencyType.subclass(*args_, **kwargs_)
        else:
            return TaskTriggerFrequencyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskTriggerFrequencyType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskTriggerFrequencyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskTriggerFrequencyType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskTriggerFrequencyType'):
        super(TaskTriggerFrequencyType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskTriggerFrequencyType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskTriggerFrequencyType', fromsubclass_=False, pretty_print=True):
        super(TaskTriggerFrequencyType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='TaskTriggerFrequencyType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskTriggerFrequencyType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskTriggerFrequencyType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(TaskTriggerFrequencyType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskTriggerFrequencyType

class TaskPriorityType(cybox_common.BaseObjectPropertyType):
    """The TaskPriorityType type specifies Windows Task priority types via
    a union of the TaskPriorityEnum type and the atomic xs:string
    type. Its base type is the CybOX Core cybox_common.BaseObjectPropertyType,
    for permitting complex (i.e. regular-expression based)
    specifications.This attribute is optional and specifies the
    expected type for the value of the specified property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['TaskPriorityType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskPriorityType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskPriorityType.subclass:
            return TaskPriorityType.subclass(*args_, **kwargs_)
        else:
            return TaskPriorityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskPriorityType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskPriorityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskPriorityType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskPriorityType'):
        super(TaskPriorityType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskPriorityType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskPriorityType', fromsubclass_=False, pretty_print=True):
        super(TaskPriorityType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='TaskPriorityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskPriorityType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskPriorityType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(TaskPriorityType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskPriorityType

class TaskFlagType(cybox_common.BaseObjectPropertyType):
    """The TaskFlagType type specifies Windows Task flag types via a union
    of the TaskFlagEnum type and the atomic xs:string type. Its base
    type is the CybOX Core cybox_common.BaseObjectPropertyType, for permitting
    complex (i.e. regular-expression based) specifications.This
    attribute is optional and specifies the expected type for the
    value of the specified property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['TaskFlagType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskFlagType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskFlagType.subclass:
            return TaskFlagType.subclass(*args_, **kwargs_)
        else:
            return TaskFlagType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskFlagType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskFlagType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskFlagType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskFlagType'):
        super(TaskFlagType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskFlagType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskFlagType', fromsubclass_=False, pretty_print=True):
        super(TaskFlagType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='TaskFlagType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskFlagType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskFlagType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(TaskFlagType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskFlagType

class TaskActionTypeType(cybox_common.BaseObjectPropertyType):
    """The TaskActionTypeType characterizes the specific types of task
    actions.This attribute is optional and specifies the expected
    type for the value of the specified property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['TaskActionTypeType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(TaskActionTypeType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TaskActionTypeType.subclass:
            return TaskActionTypeType.subclass(*args_, **kwargs_)
        else:
            return TaskActionTypeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(TaskActionTypeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionTypeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskActionTypeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='TaskActionTypeType'):
        super(TaskActionTypeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskActionTypeType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='TaskActionTypeType', fromsubclass_=False, pretty_print=True):
        super(TaskActionTypeType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='TaskActionTypeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(TaskActionTypeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskActionTypeType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(TaskActionTypeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TaskActionTypeType

class WindowsTaskObjectType(cybox_common.ObjectPropertiesType):
    """The WindowsTaskObjectType type is intended to characterize Windows
    task scheduler tasks. See Also: http://msdn.microsoft.com/en-
    us/library/windows/desktop/aa381311(v=vs.85).aspx"""
    member_data_items_ = {
        'Status': MemberSpec_('Status', 'TaskStatusType', 0),
        'Priority': MemberSpec_('Priority', 'TaskPriorityType', 0),
        'Name': MemberSpec_('Name', 'cybox_common.StringObjectPropertyType', 0),
        'Application_Name': MemberSpec_('Application_Name', 'cybox_common.StringObjectPropertyType', 0),
        'Parameters': MemberSpec_('Parameters', 'cybox_common.StringObjectPropertyType', 0),
        'Flags': MemberSpec_('Flags', 'TaskFlagType', 0),
        'Account_Name': MemberSpec_('Account_Name', 'cybox_common.StringObjectPropertyType', 0),
        'Account_Run_Level': MemberSpec_('Account_Run_Level', 'cybox_common.StringObjectPropertyType', 0),
        'Account_Logon_Type': MemberSpec_('Account_Logon_Type', 'cybox_common.StringObjectPropertyType', 0),
        'Creator': MemberSpec_('Creator', 'cybox_common.StringObjectPropertyType', 0),
        'Creation_Date': MemberSpec_('Creation_Date', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Most_Recent_Run_Time': MemberSpec_('Most_Recent_Run_Time', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Exit_Code': MemberSpec_('Exit_Code', 'cybox_common.LongObjectPropertyType', 0),
        'Max_Run_Time': MemberSpec_('Max_Run_Time', 'cybox_common.UnsignedLongObjectPropertyType', 0),
        'Next_Run_Time': MemberSpec_('Next_Run_Time', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Action_List': MemberSpec_('Action_List', 'TaskActionListType', 0),
        'Trigger_List': MemberSpec_('Trigger_List', 'TriggerListType', 0),
        'Comment': MemberSpec_('Comment', 'cybox_common.StringObjectPropertyType', 0),
        'Working_Directory': MemberSpec_('Working_Directory', 'cybox_common.StringObjectPropertyType', 0),
        'Work_Item_Data': MemberSpec_('Work_Item_Data', 'cybox_common.Base64BinaryObjectPropertyType', 0),
        }
    subclass = None
    superclass = cybox_common.ObjectPropertiesType
    def __init__(self, object_reference=None, Custom_Properties=None, xsi_type=None, Status=None, Priority=None, Name=None, Application_Name=None, Parameters=None, Flags=None, Account_Name=None, Account_Run_Level=None, Account_Logon_Type=None, Creator=None, Creation_Date=None, Most_Recent_Run_Time=None, Exit_Code=None, Max_Run_Time=None, Next_Run_Time=None, Action_List=None, Trigger_List=None, Comment=None, Working_Directory=None, Work_Item_Data=None):
        super(WindowsTaskObjectType, self).__init__(object_reference, Custom_Properties, xsi_type )
        self.Status = Status
        self.Priority = Priority
        self.Name = Name
        self.Application_Name = Application_Name
        self.Parameters = Parameters
        self.Flags = Flags
        self.Account_Name = Account_Name
        self.Account_Run_Level = Account_Run_Level
        self.Account_Logon_Type = Account_Logon_Type
        self.Creator = Creator
        self.Creation_Date = Creation_Date
        self.Most_Recent_Run_Time = Most_Recent_Run_Time
        self.Exit_Code = Exit_Code
        self.Max_Run_Time = Max_Run_Time
        self.Next_Run_Time = Next_Run_Time
        self.Action_List = Action_List
        self.Trigger_List = Trigger_List
        self.Comment = Comment
        self.Working_Directory = Working_Directory
        self.Work_Item_Data = Work_Item_Data
    def factory(*args_, **kwargs_):
        if WindowsTaskObjectType.subclass:
            return WindowsTaskObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsTaskObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Status(self): return self.Status
    def set_Status(self, Status): self.Status = Status
    def validate_TaskStatusType(self, value):
        # Validate type TaskStatusType, a restriction on None.
        pass
    def get_Priority(self): return self.Priority
    def set_Priority(self, Priority): self.Priority = Priority
    def validate_TaskPriorityType(self, value):
        # Validate type TaskPriorityType, a restriction on None.
        pass
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Application_Name(self): return self.Application_Name
    def set_Application_Name(self, Application_Name): self.Application_Name = Application_Name
    def get_Parameters(self): return self.Parameters
    def set_Parameters(self, Parameters): self.Parameters = Parameters
    def get_Flags(self): return self.Flags
    def set_Flags(self, Flags): self.Flags = Flags
    def validate_TaskFlagType(self, value):
        # Validate type TaskFlagType, a restriction on None.
        pass
    def get_Account_Name(self): return self.Account_Name
    def set_Account_Name(self, Account_Name): self.Account_Name = Account_Name
    def get_Account_Run_Level(self): return self.Account_Run_Level
    def set_Account_Run_Level(self, Account_Run_Level): self.Account_Run_Level = Account_Run_Level
    def get_Account_Logon_Type(self): return self.Account_Logon_Type
    def set_Account_Logon_Type(self, Account_Logon_Type): self.Account_Logon_Type = Account_Logon_Type
    def get_Creator(self): return self.Creator
    def set_Creator(self, Creator): self.Creator = Creator
    def get_Creation_Date(self): return self.Creation_Date
    def set_Creation_Date(self, Creation_Date): self.Creation_Date = Creation_Date
    def validate_DateTimeObjectPropertyType(self, value):
        # Validate type cybox_common.DateTimeObjectPropertyType, a restriction on None.
        pass
    def get_Most_Recent_Run_Time(self): return self.Most_Recent_Run_Time
    def set_Most_Recent_Run_Time(self, Most_Recent_Run_Time): self.Most_Recent_Run_Time = Most_Recent_Run_Time
    def get_Exit_Code(self): return self.Exit_Code
    def set_Exit_Code(self, Exit_Code): self.Exit_Code = Exit_Code
    def validate_LongObjectPropertyType(self, value):
        # Validate type cybox_common.LongObjectPropertyType, a restriction on None.
        pass
    def get_Max_Run_Time(self): return self.Max_Run_Time
    def set_Max_Run_Time(self, Max_Run_Time): self.Max_Run_Time = Max_Run_Time
    def validate_UnsignedLongObjectPropertyType(self, value):
        # Validate type cybox_common.UnsignedLongObjectPropertyType, a restriction on None.
        pass
    def get_Next_Run_Time(self): return self.Next_Run_Time
    def set_Next_Run_Time(self, Next_Run_Time): self.Next_Run_Time = Next_Run_Time
    def get_Action_List(self): return self.Action_List
    def set_Action_List(self, Action_List): self.Action_List = Action_List
    def get_Trigger_List(self): return self.Trigger_List
    def set_Trigger_List(self, Trigger_List): self.Trigger_List = Trigger_List
    def get_Comment(self): return self.Comment
    def set_Comment(self, Comment): self.Comment = Comment
    def get_Working_Directory(self): return self.Working_Directory
    def set_Working_Directory(self, Working_Directory): self.Working_Directory = Working_Directory
    def get_Work_Item_Data(self): return self.Work_Item_Data
    def set_Work_Item_Data(self, Work_Item_Data): self.Work_Item_Data = Work_Item_Data
    def validate_Base64BinaryObjectPropertyType(self, value):
        # Validate type cybox_common.Base64BinaryObjectPropertyType, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.Status is not None or
            self.Priority is not None or
            self.Name is not None or
            self.Application_Name is not None or
            self.Parameters is not None or
            self.Flags is not None or
            self.Account_Name is not None or
            self.Account_Run_Level is not None or
            self.Account_Logon_Type is not None or
            self.Creator is not None or
            self.Creation_Date is not None or
            self.Most_Recent_Run_Time is not None or
            self.Exit_Code is not None or
            self.Max_Run_Time is not None or
            self.Next_Run_Time is not None or
            self.Action_List is not None or
            self.Trigger_List is not None or
            self.Comment is not None or
            self.Working_Directory is not None or
            self.Work_Item_Data is not None or
            super(WindowsTaskObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinTaskObj:', name_='WindowsTaskObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsTaskObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinTaskObj:', name_='WindowsTaskObjectType'):
        super(WindowsTaskObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsTaskObjectType')
    def exportChildren(self, outfile, level, namespace_='WinTaskObj:', name_='WindowsTaskObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsTaskObjectType, self).exportChildren(outfile, level, 'WinTaskObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Status is not None:
            self.Status.export(outfile, level, 'WinTaskObj:', name_='Status', pretty_print=pretty_print)
        if self.Priority is not None:
            self.Priority.export(outfile, level, 'WinTaskObj:', name_='Priority', pretty_print=pretty_print)
        if self.Name is not None:
            self.Name.export(outfile, level, 'WinTaskObj:', name_='Name', pretty_print=pretty_print)
        if self.Application_Name is not None:
            self.Application_Name.export(outfile, level, 'WinTaskObj:', name_='Application_Name', pretty_print=pretty_print)
        if self.Parameters is not None:
            self.Parameters.export(outfile, level, 'WinTaskObj:', name_='Parameters', pretty_print=pretty_print)
        if self.Flags is not None:
            self.Flags.export(outfile, level, 'WinTaskObj:', name_='Flags', pretty_print=pretty_print)
        if self.Account_Name is not None:
            self.Account_Name.export(outfile, level, 'WinTaskObj:', name_='Account_Name', pretty_print=pretty_print)
        if self.Account_Run_Level is not None:
            self.Account_Run_Level.export(outfile, level, 'WinTaskObj:', name_='Account_Run_Level', pretty_print=pretty_print)
        if self.Account_Logon_Type is not None:
            self.Account_Logon_Type.export(outfile, level, 'WinTaskObj:', name_='Account_Logon_Type', pretty_print=pretty_print)
        if self.Creator is not None:
            self.Creator.export(outfile, level, 'WinTaskObj:', name_='Creator', pretty_print=pretty_print)
        if self.Creation_Date is not None:
            self.Creation_Date.export(outfile, level, 'WinTaskObj:', name_='Creation_Date', pretty_print=pretty_print)
        if self.Most_Recent_Run_Time is not None:
            self.Most_Recent_Run_Time.export(outfile, level, 'WinTaskObj:', name_='Most_Recent_Run_Time', pretty_print=pretty_print)
        if self.Exit_Code is not None:
            self.Exit_Code.export(outfile, level, 'WinTaskObj:', name_='Exit_Code', pretty_print=pretty_print)
        if self.Max_Run_Time is not None:
            self.Max_Run_Time.export(outfile, level, 'WinTaskObj:', name_='Max_Run_Time', pretty_print=pretty_print)
        if self.Next_Run_Time is not None:
            self.Next_Run_Time.export(outfile, level, 'WinTaskObj:', name_='Next_Run_Time', pretty_print=pretty_print)
        if self.Action_List is not None:
            self.Action_List.export(outfile, level, 'WinTaskObj:', name_='Action_List', pretty_print=pretty_print)
        if self.Trigger_List is not None:
            self.Trigger_List.export(outfile, level, 'WinTaskObj:', name_='Trigger_List', pretty_print=pretty_print)
        if self.Comment is not None:
            self.Comment.export(outfile, level, 'WinTaskObj:', name_='Comment', pretty_print=pretty_print)
        if self.Working_Directory is not None:
            self.Working_Directory.export(outfile, level, 'WinTaskObj:', name_='Working_Directory', pretty_print=pretty_print)
        if self.Work_Item_Data is not None:
            self.Work_Item_Data.export(outfile, level, 'WinTaskObj:', name_='Work_Item_Data', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='WindowsTaskObjectType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsTaskObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsTaskObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Status is not None:
            outfile.write('Status=model_.TaskStatusType(\n')
            self.Status.exportLiteral(outfile, level, name_='Status')
            outfile.write('),\n')
        if self.Priority is not None:
            outfile.write('Priority=model_.TaskPriorityType(\n')
            self.Priority.exportLiteral(outfile, level, name_='Priority')
            outfile.write('),\n')
        if self.Name is not None:
            outfile.write('Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            outfile.write('),\n')
        if self.Application_Name is not None:
            outfile.write('Application_Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.Application_Name.exportLiteral(outfile, level, name_='Application_Name')
            outfile.write('),\n')
        if self.Parameters is not None:
            outfile.write('Parameters=model_.cybox_common.StringObjectPropertyType(\n')
            self.Parameters.exportLiteral(outfile, level, name_='Parameters')
            outfile.write('),\n')
        if self.Flags is not None:
            outfile.write('Flags=model_.TaskFlagType(\n')
            self.Flags.exportLiteral(outfile, level, name_='Flags')
            outfile.write('),\n')
        if self.Account_Name is not None:
            outfile.write('Account_Name=model_.cybox_common.StringObjectPropertyType(\n')
            self.Account_Name.exportLiteral(outfile, level, name_='Account_Name')
            outfile.write('),\n')
        if self.Account_Run_Level is not None:
            outfile.write('Account_Run_Level=model_.cybox_common.StringObjectPropertyType(\n')
            self.Account_Run_Level.exportLiteral(outfile, level, name_='Account_Run_Level')
            outfile.write('),\n')
        if self.Account_Logon_Type is not None:
            outfile.write('Account_Logon_Type=model_.cybox_common.StringObjectPropertyType(\n')
            self.Account_Logon_Type.exportLiteral(outfile, level, name_='Account_Logon_Type')
            outfile.write('),\n')
        if self.Creator is not None:
            outfile.write('Creator=model_.cybox_common.StringObjectPropertyType(\n')
            self.Creator.exportLiteral(outfile, level, name_='Creator')
            outfile.write('),\n')
        if self.Creation_Date is not None:
            outfile.write('Creation_Date=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Creation_Date.exportLiteral(outfile, level, name_='Creation_Date')
            outfile.write('),\n')
        if self.Most_Recent_Run_Time is not None:
            outfile.write('Most_Recent_Run_Time=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Most_Recent_Run_Time.exportLiteral(outfile, level, name_='Most_Recent_Run_Time')
            outfile.write('),\n')
        if self.Exit_Code is not None:
            outfile.write('Exit_Code=model_.cybox_common.LongObjectPropertyType(\n')
            self.Exit_Code.exportLiteral(outfile, level, name_='Exit_Code')
            outfile.write('),\n')
        if self.Max_Run_Time is not None:
            outfile.write('Max_Run_Time=model_.cybox_common.UnsignedLongObjectPropertyType(\n')
            self.Max_Run_Time.exportLiteral(outfile, level, name_='Max_Run_Time')
            outfile.write('),\n')
        if self.Next_Run_Time is not None:
            outfile.write('Next_Run_Time=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Next_Run_Time.exportLiteral(outfile, level, name_='Next_Run_Time')
            outfile.write('),\n')
        if self.Action_List is not None:
            outfile.write('Action_List=model_.TaskActionListType(\n')
            self.Action_List.exportLiteral(outfile, level, name_='Action_List')
            outfile.write('),\n')
        if self.Trigger_List is not None:
            outfile.write('Trigger_List=model_.TriggerListType(\n')
            self.Trigger_List.exportLiteral(outfile, level, name_='Trigger_List')
            outfile.write('),\n')
        if self.Comment is not None:
            outfile.write('Comment=model_.cybox_common.StringObjectPropertyType(\n')
            self.Comment.exportLiteral(outfile, level, name_='Comment')
            outfile.write('),\n')
        if self.Working_Directory is not None:
            outfile.write('Working_Directory=model_.cybox_common.StringObjectPropertyType(\n')
            self.Working_Directory.exportLiteral(outfile, level, name_='Working_Directory')
            outfile.write('),\n')
        if self.Work_Item_Data is not None:
            outfile.write('Work_Item_Data=model_.cybox_common.Base64BinaryObjectPropertyType(\n')
            self.Work_Item_Data.exportLiteral(outfile, level, name_='Work_Item_Data')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsTaskObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Status':
            obj_ = TaskStatusType.factory()
            obj_.build(child_)
            self.set_Status(obj_)
        elif nodeName_ == 'Priority':
            obj_ = TaskPriorityType.factory()
            obj_.build(child_)
            self.set_Priority(obj_)
        elif nodeName_ == 'Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Name(obj_)
        elif nodeName_ == 'Application_Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Application_Name(obj_)
        elif nodeName_ == 'Parameters':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Parameters(obj_)
        elif nodeName_ == 'Flags':
            obj_ = TaskFlagType.factory()
            obj_.build(child_)
            self.set_Flags(obj_)
        elif nodeName_ == 'Account_Name':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Account_Name(obj_)
        elif nodeName_ == 'Account_Run_Level':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Account_Run_Level(obj_)
        elif nodeName_ == 'Account_Logon_Type':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Account_Logon_Type(obj_)
        elif nodeName_ == 'Creator':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Creator(obj_)
        elif nodeName_ == 'Creation_Date':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Creation_Date(obj_)
        elif nodeName_ == 'Most_Recent_Run_Time':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Most_Recent_Run_Time(obj_)
        elif nodeName_ == 'Exit_Code':
            obj_ = cybox_common.LongObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Exit_Code(obj_)
        elif nodeName_ == 'Max_Run_Time':
            obj_ = cybox_common.UnsignedLongObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Max_Run_Time(obj_)
        elif nodeName_ == 'Next_Run_Time':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Next_Run_Time(obj_)
        elif nodeName_ == 'Action_List':
            obj_ = TaskActionListType.factory()
            obj_.build(child_)
            self.set_Action_List(obj_)
        elif nodeName_ == 'Trigger_List':
            obj_ = TriggerListType.factory()
            obj_.build(child_)
            self.set_Trigger_List(obj_)
        elif nodeName_ == 'Comment':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Comment(obj_)
        elif nodeName_ == 'Working_Directory':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Working_Directory(obj_)
        elif nodeName_ == 'Work_Item_Data':
            obj_ = cybox_common.Base64BinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Work_Item_Data(obj_)
        super(WindowsTaskObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsTaskObjectType

GDSClassesMapping = {
    'Build_Utility': cybox_common.BuildUtilityType,
    'Next_Run_Time': cybox_common.DateTimeObjectPropertyType,
    'Errors': cybox_common.ErrorsType,
    'Time': cybox_common.TimeType,
    'Working_Directory': cybox_common.StringObjectPropertyType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'COM_Data': cybox_common.StringObjectPropertyType,
    'Exit_Code': cybox_common.LongObjectPropertyType,
    'User_Agent': cybox_common.StringObjectPropertyType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'Application_Name': cybox_common.StringObjectPropertyType,
    'By': cybox_common.StringObjectPropertyType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'SubDatum': cybox_common.MetadataType,
    'Segment_Hash': cybox_common.HashValueType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'Trigger_Delay': cybox_common.DurationObjectPropertyType,
    'Value': cybox_common.StringObjectPropertyType,
    'Length': cybox_common.IntegerObjectPropertyType,
    'Account_Run_Level': cybox_common.StringObjectPropertyType,
    'Attachments': email_message_object.AttachmentsType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Most_Recent_Run_Time': cybox_common.DateTimeObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Creator': cybox_common.StringObjectPropertyType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'Trigger_Begin': cybox_common.DateTimeObjectPropertyType,
    'Subject': cybox_common.StringObjectPropertyType,
    'Functions': cybox_common.FunctionsType,
    'From': cybox_common.StringObjectPropertyType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'Parameters': cybox_common.StringObjectPropertyType,
    'Trigger_Max_Run_Time': cybox_common.DurationObjectPropertyType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'System': cybox_common.ObjectPropertiesType,
    'Platform': cybox_common.PlatformSpecificationType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'MIME_Version': cybox_common.StringObjectPropertyType,
    'Raw_Header': cybox_common.StringObjectPropertyType,
    'Type': cybox_common.ControlledVocabularyStringType,
    'Compilers': cybox_common.CompilersType,
    'Message_ID': cybox_common.StringObjectPropertyType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'String': cybox_common.ExtractedStringType,
    'Raw_Body': cybox_common.StringObjectPropertyType,
    'Tool': cybox_common.ToolInformationType,
    'Build_Information': cybox_common.BuildInformationType,
    'Link': email_message_object.LinkReferenceType,
    'Tool_Hashes': cybox_common.HashListType,
    'X_Priority': cybox_common.PositiveIntegerObjectPropertyType,
    'COM_Class_ID': cybox_common.StringObjectPropertyType,
    'Exec_Arguments': cybox_common.StringObjectPropertyType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'Trigger_End': cybox_common.DateTimeObjectPropertyType,
    'Show_Message_Body': cybox_common.StringObjectPropertyType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'Comment': cybox_common.StringObjectPropertyType,
    'Contributors': cybox_common.PersonnelType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'X_Mailer': cybox_common.StringObjectPropertyType,
    'Reference_Description': cybox_common.StructuredTextType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Received': email_message_object.EmailReceivedLineType,
    'Timestamp': cybox_common.DateTimeObjectPropertyType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'In_Reply_To': cybox_common.StringObjectPropertyType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'Content_Type': cybox_common.StringObjectPropertyType,
    'BCC': email_message_object.EmailRecipientsType,
    'Instance': cybox_common.ObjectPropertiesType,
    'Import': cybox_common.StringObjectPropertyType,
    'Boundary': cybox_common.StringObjectPropertyType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'For': cybox_common.StringObjectPropertyType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Dependencies': cybox_common.DependenciesType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Exec_Working_Directory': cybox_common.StringObjectPropertyType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Date': cybox_common.DateTimeObjectPropertyType,
    'Received_Lines': email_message_object.EmailReceivedLineListType,
    'Hashes': cybox_common.HashListType,
    'Segments': cybox_common.HashSegmentsType,
    'Language': cybox_common.StringObjectPropertyType,
    'CC': email_message_object.EmailRecipientsType,
    'Errors_To': cybox_common.StringObjectPropertyType,
    'Creation_Date': cybox_common.DateTimeObjectPropertyType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'Dependency': cybox_common.DependencyType,
    'Error': cybox_common.ErrorType,
    'ID': cybox_common.StringObjectPropertyType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'Byte_Run': cybox_common.ByteRunType,
    'Trigger_Session_Change_Type': cybox_common.StringObjectPropertyType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Precedence': cybox_common.StringObjectPropertyType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'Imports': cybox_common.ImportsType,
    'Library': cybox_common.LibraryType,
    'Header': email_message_object.EmailHeaderType,
    'References': cybox_common.ToolReferencesType,
    'IEmailAction': email_message_object.EmailMessageObjectType,
    'Exec_Program_Hashes': cybox_common.HashListType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Max_Run_Time': cybox_common.UnsignedLongObjectPropertyType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'Libraries': cybox_common.LibrariesType,
    'To': email_message_object.EmailRecipientsType,
    'Email_Server': cybox_common.StringObjectPropertyType,
    'Action_ID': cybox_common.StringObjectPropertyType,
    'Function': cybox_common.StringObjectPropertyType,
    'Description': cybox_common.StructuredTextType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'With': cybox_common.StringObjectPropertyType,
    'Links': email_message_object.LinksType,
    'VLAN_Name': cybox_common.StringObjectPropertyType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'Compiler': cybox_common.CompilerType,
    'Name': cybox_common.StringObjectPropertyType,
    'Address_Value': cybox_common.StringObjectPropertyType,
    'VLAN_Num': cybox_common.IntegerObjectPropertyType,
    'Work_Item_Data': cybox_common.Base64BinaryObjectPropertyType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'Account_Name': cybox_common.StringObjectPropertyType,
    'Account_Logon_Type': cybox_common.StringObjectPropertyType,
    'Exec_Program_Path': cybox_common.StringObjectPropertyType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Show_Message_Title': cybox_common.StringObjectPropertyType,
    'Data_Size': cybox_common.DataSizeType,
    'Email_Message': email_message_object.EmailMessageObjectType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'File': email_message_object.AttachmentReferenceType,
    'Contributor': cybox_common.ContributorType,
    'Tools': cybox_common.ToolsInformationType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Task'
        rootClass = WindowsTaskObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Task'
        rootClass = WindowsTaskObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Task'
        rootClass = WindowsTaskObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Windows_Task",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Task'
        rootClass = WindowsTaskObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsTaskObjectType",
    "TriggerListType",
    "TriggerType",
    "TaskActionListType",
    "TaskActionType",
    "TaskActionTypeType",
    "IComHandlerActionType",
    "IExecActionType",
    "IShowMessageActionType",
    "TaskFlagType",
    "TaskPriorityType",
    "TaskTriggerFrequencyType",
    "TaskTriggerType",
    "TaskStatusType"
    ]