#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2013, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

#
# Generated Tue Apr 09 11:14:48 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import cybox_common
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class SSDTEntryListType(GeneratedsSuper):
    """The SSDTEntryListType type specifies a listing of the entries in the
    System Service Descriptor Table (SSDT)."""
    member_data_items_ = {
        'SSDT_Entry': MemberSpec_('SSDT_Entry', 'SSDTEntryType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, SSDT_Entry=None):
        if SSDT_Entry is None:
            self.SSDT_Entry = []
        else:
            self.SSDT_Entry = SSDT_Entry
    def factory(*args_, **kwargs_):
        if SSDTEntryListType.subclass:
            return SSDTEntryListType.subclass(*args_, **kwargs_)
        else:
            return SSDTEntryListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SSDT_Entry(self): return self.SSDT_Entry
    def set_SSDT_Entry(self, SSDT_Entry): self.SSDT_Entry = SSDT_Entry
    def add_SSDT_Entry(self, value): self.SSDT_Entry.append(value)
    def insert_SSDT_Entry(self, index, value): self.SSDT_Entry[index] = value
    def hasContent_(self):
        if (
            self.SSDT_Entry
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinKernelObj:', name_='SSDTEntryListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SSDTEntryListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinKernelObj:', name_='SSDTEntryListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinKernelObj:', name_='SSDTEntryListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for SSDT_Entry_ in self.SSDT_Entry:
            SSDT_Entry_.export(outfile, level, 'WinKernelObj:', name_='SSDT_Entry', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SSDTEntryListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('SSDT_Entry=[\n')
        level += 1
        for SSDT_Entry_ in self.SSDT_Entry:
            outfile.write('model_.SSDTEntryType(\n')
            SSDT_Entry_.exportLiteral(outfile, level, name_='SSDTEntryType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SSDT_Entry':
            obj_ = SSDTEntryType.factory()
            obj_.build(child_)
            self.SSDT_Entry.append(obj_)
# end class SSDTEntryListType

class SSDTEntryType(GeneratedsSuper):
    """The SSDTEntryType type specifies a single entry in the System
    Service Descriptor Table (SSDT).The hooked attribute specifies
    whether the SSDT entry is hooked."""
    member_data_items_ = {
        'hooked': MemberSpec_('hooked', 'xs:boolean', 0),
        'Service_Table_Base': MemberSpec_('Service_Table_Base', 'cybox_common.HexBinaryObjectPropertyType', 0),
        'Service_Counter_Table_Base': MemberSpec_('Service_Counter_Table_Base', 'cybox_common.HexBinaryObjectPropertyType', 0),
        'Number_Of_Services': MemberSpec_('Number_Of_Services', 'cybox_common.NonNegativeIntegerObjectPropertyType', 0),
        'Argument_Table_Base': MemberSpec_('Argument_Table_Base', 'cybox_common.HexBinaryObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, hooked=None, Service_Table_Base=None, Service_Counter_Table_Base=None, Number_Of_Services=None, Argument_Table_Base=None):
        self.hooked = _cast(bool, hooked)
        self.Service_Table_Base = Service_Table_Base
        self.Service_Counter_Table_Base = Service_Counter_Table_Base
        self.Number_Of_Services = Number_Of_Services
        self.Argument_Table_Base = Argument_Table_Base
    def factory(*args_, **kwargs_):
        if SSDTEntryType.subclass:
            return SSDTEntryType.subclass(*args_, **kwargs_)
        else:
            return SSDTEntryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Service_Table_Base(self): return self.Service_Table_Base
    def set_Service_Table_Base(self, Service_Table_Base): self.Service_Table_Base = Service_Table_Base
    def validate_HexBinaryObjectPropertyType(self, value):
        # Validate type cybox_common.HexBinaryObjectPropertyType, a restriction on None.
        pass
    def get_Service_Counter_Table_Base(self): return self.Service_Counter_Table_Base
    def set_Service_Counter_Table_Base(self, Service_Counter_Table_Base): self.Service_Counter_Table_Base = Service_Counter_Table_Base
    def get_Number_Of_Services(self): return self.Number_Of_Services
    def set_Number_Of_Services(self, Number_Of_Services): self.Number_Of_Services = Number_Of_Services
    def validate_NonNegativeIntegerObjectPropertyType(self, value):
        # Validate type cybox_common.NonNegativeIntegerObjectPropertyType, a restriction on None.
        pass
    def get_Argument_Table_Base(self): return self.Argument_Table_Base
    def set_Argument_Table_Base(self, Argument_Table_Base): self.Argument_Table_Base = Argument_Table_Base
    def get_hooked(self): return self.hooked
    def set_hooked(self, hooked): self.hooked = hooked
    def hasContent_(self):
        if (
            self.Service_Table_Base is not None or
            self.Service_Counter_Table_Base is not None or
            self.Number_Of_Services is not None or
            self.Argument_Table_Base is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinKernelObj:', name_='SSDTEntryType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SSDTEntryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinKernelObj:', name_='SSDTEntryType'):
        if self.hooked is not None and 'hooked' not in already_processed:
            already_processed.add('hooked')
            outfile.write(' hooked="%s"' % self.gds_format_boolean(self.hooked, input_name='hooked'))
    def exportChildren(self, outfile, level, namespace_='WinKernelObj:', name_='SSDTEntryType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Service_Table_Base is not None:
            self.Service_Table_Base.export(outfile, level, 'WinKernelObj:', name_='Service_Table_Base', pretty_print=pretty_print)
        if self.Service_Counter_Table_Base is not None:
            self.Service_Counter_Table_Base.export(outfile, level, 'WinKernelObj:', name_='Service_Counter_Table_Base', pretty_print=pretty_print)
        if self.Number_Of_Services is not None:
            self.Number_Of_Services.export(outfile, level, 'WinKernelObj:', name_='Number_Of_Services', pretty_print=pretty_print)
        if self.Argument_Table_Base is not None:
            self.Argument_Table_Base.export(outfile, level, 'WinKernelObj:', name_='Argument_Table_Base', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SSDTEntryType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.hooked is not None and 'hooked' not in already_processed:
            already_processed.add('hooked')
            showIndent(outfile, level)
            outfile.write('hooked = %s,\n' % (self.hooked,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Service_Table_Base is not None:
            outfile.write('Service_Table_Base=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Service_Table_Base.exportLiteral(outfile, level, name_='Service_Table_Base')
            outfile.write('),\n')
        if self.Service_Counter_Table_Base is not None:
            outfile.write('Service_Counter_Table_Base=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Service_Counter_Table_Base.exportLiteral(outfile, level, name_='Service_Counter_Table_Base')
            outfile.write('),\n')
        if self.Number_Of_Services is not None:
            outfile.write('Number_Of_Services=model_.cybox_common.NonNegativeIntegerObjectPropertyType(\n')
            self.Number_Of_Services.exportLiteral(outfile, level, name_='Number_Of_Services')
            outfile.write('),\n')
        if self.Argument_Table_Base is not None:
            outfile.write('Argument_Table_Base=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Argument_Table_Base.exportLiteral(outfile, level, name_='Argument_Table_Base')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('hooked', node)
        if value is not None and 'hooked' not in already_processed:
            already_processed.add('hooked')
            if value in ('true', '1'):
                self.hooked = True
            elif value in ('false', '0'):
                self.hooked = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Service_Table_Base':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Service_Table_Base(obj_)
        elif nodeName_ == 'Service_Counter_Table_Base':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Service_Counter_Table_Base(obj_)
        elif nodeName_ == 'Number_Of_Services':
            obj_ = cybox_common.NonNegativeIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Number_Of_Services(obj_)
        elif nodeName_ == 'Argument_Table_Base':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Argument_Table_Base(obj_)
# end class SSDTEntryType

class IDTEntryListType(GeneratedsSuper):
    """The IDTEntryListType type specifies a listing of the entries in the
    Interrupt Descriptor Table (IDT). The IDT is specific to the
    I386 architecture, indicating where the Prtoetcted mode
    Interrupt Service Routines (ISR) are located. See
    http://wiki.osdev.org/Interrupt_Descriptor_Table"""
    member_data_items_ = {
        'IDT_Entry': MemberSpec_('IDT_Entry', 'IDTEntryType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, IDT_Entry=None):
        if IDT_Entry is None:
            self.IDT_Entry = []
        else:
            self.IDT_Entry = IDT_Entry
    def factory(*args_, **kwargs_):
        if IDTEntryListType.subclass:
            return IDTEntryListType.subclass(*args_, **kwargs_)
        else:
            return IDTEntryListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IDT_Entry(self): return self.IDT_Entry
    def set_IDT_Entry(self, IDT_Entry): self.IDT_Entry = IDT_Entry
    def add_IDT_Entry(self, value): self.IDT_Entry.append(value)
    def insert_IDT_Entry(self, index, value): self.IDT_Entry[index] = value
    def hasContent_(self):
        if (
            self.IDT_Entry
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinKernelObj:', name_='IDTEntryListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IDTEntryListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinKernelObj:', name_='IDTEntryListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinKernelObj:', name_='IDTEntryListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for IDT_Entry_ in self.IDT_Entry:
            IDT_Entry_.export(outfile, level, 'WinKernelObj:', name_='IDT_Entry', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IDTEntryListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('IDT_Entry=[\n')
        level += 1
        for IDT_Entry_ in self.IDT_Entry:
            outfile.write('model_.IDTEntryType(\n')
            IDT_Entry_.exportLiteral(outfile, level, name_='IDTEntryType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IDT_Entry':
            obj_ = IDTEntryType.factory()
            obj_.build(child_)
            self.IDT_Entry.append(obj_)
# end class IDTEntryListType

class IDTEntryType(GeneratedsSuper):
    """The IDTEntryType type specifies a single entry in the Interrupt
    Descriptor Table (IDT). Entries can be interrupt gates, task
    gates, and trap gates."""
    member_data_items_ = {
        'Type_Attr': MemberSpec_('Type_Attr', 'cybox_common.HexBinaryObjectPropertyType', 0),
        'Offset_High': MemberSpec_('Offset_High', 'cybox_common.HexBinaryObjectPropertyType', 0),
        'Offset_Low': MemberSpec_('Offset_Low', 'cybox_common.HexBinaryObjectPropertyType', 0),
        'Offset_Middle': MemberSpec_('Offset_Middle', 'cybox_common.HexBinaryObjectPropertyType', 0),
        'Selector': MemberSpec_('Selector', 'cybox_common.HexBinaryObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Type_Attr=None, Offset_High=None, Offset_Low=None, Offset_Middle=None, Selector=None):
        self.Type_Attr = Type_Attr
        self.Offset_High = Offset_High
        self.Offset_Low = Offset_Low
        self.Offset_Middle = Offset_Middle
        self.Selector = Selector
    def factory(*args_, **kwargs_):
        if IDTEntryType.subclass:
            return IDTEntryType.subclass(*args_, **kwargs_)
        else:
            return IDTEntryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type_Attr(self): return self.Type_Attr
    def set_Type_Attr(self, Type_Attr): self.Type_Attr = Type_Attr
    def validate_HexBinaryObjectPropertyType(self, value):
        # Validate type cybox_common.HexBinaryObjectPropertyType, a restriction on None.
        pass
    def get_Offset_High(self): return self.Offset_High
    def set_Offset_High(self, Offset_High): self.Offset_High = Offset_High
    def get_Offset_Low(self): return self.Offset_Low
    def set_Offset_Low(self, Offset_Low): self.Offset_Low = Offset_Low
    def get_Offset_Middle(self): return self.Offset_Middle
    def set_Offset_Middle(self, Offset_Middle): self.Offset_Middle = Offset_Middle
    def get_Selector(self): return self.Selector
    def set_Selector(self, Selector): self.Selector = Selector
    def hasContent_(self):
        if (
            self.Type_Attr is not None or
            self.Offset_High is not None or
            self.Offset_Low is not None or
            self.Offset_Middle is not None or
            self.Selector is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinKernelObj:', name_='IDTEntryType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IDTEntryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinKernelObj:', name_='IDTEntryType'):
        pass
    def exportChildren(self, outfile, level, namespace_='WinKernelObj:', name_='IDTEntryType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Type_Attr is not None:
            self.Type_Attr.export(outfile, level, 'WinKernelObj:', name_='Type_Attr', pretty_print=pretty_print)
        if self.Offset_High is not None:
            self.Offset_High.export(outfile, level, 'WinKernelObj:', name_='Offset_High', pretty_print=pretty_print)
        if self.Offset_Low is not None:
            self.Offset_Low.export(outfile, level, 'WinKernelObj:', name_='Offset_Low', pretty_print=pretty_print)
        if self.Offset_Middle is not None:
            self.Offset_Middle.export(outfile, level, 'WinKernelObj:', name_='Offset_Middle', pretty_print=pretty_print)
        if self.Selector is not None:
            self.Selector.export(outfile, level, 'WinKernelObj:', name_='Selector', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IDTEntryType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Type_Attr is not None:
            outfile.write('Type_Attr=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Type_Attr.exportLiteral(outfile, level, name_='Type_Attr')
            outfile.write('),\n')
        if self.Offset_High is not None:
            outfile.write('Offset_High=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Offset_High.exportLiteral(outfile, level, name_='Offset_High')
            outfile.write('),\n')
        if self.Offset_Low is not None:
            outfile.write('Offset_Low=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Offset_Low.exportLiteral(outfile, level, name_='Offset_Low')
            outfile.write('),\n')
        if self.Offset_Middle is not None:
            outfile.write('Offset_Middle=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Offset_Middle.exportLiteral(outfile, level, name_='Offset_Middle')
            outfile.write('),\n')
        if self.Selector is not None:
            outfile.write('Selector=model_.cybox_common.HexBinaryObjectPropertyType(\n')
            self.Selector.exportLiteral(outfile, level, name_='Selector')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type_Attr':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Type_Attr(obj_)
        elif nodeName_ == 'Offset_High':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Offset_High(obj_)
        elif nodeName_ == 'Offset_Low':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Offset_Low(obj_)
        elif nodeName_ == 'Offset_Middle':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Offset_Middle(obj_)
        elif nodeName_ == 'Selector':
            obj_ = cybox_common.HexBinaryObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Selector(obj_)
# end class IDTEntryType

class WindowsKernelObjectType(cybox_common.ObjectPropertiesType):
    """The WindowsKernelObjectType type is intended to characterize Windows
    Kernel structures."""
    member_data_items_ = {
        'IDT': MemberSpec_('IDT', 'IDTEntryListType', 0),
        'SSDT': MemberSpec_('SSDT', 'SSDTEntryListType', 0),
        }
    subclass = None
    superclass = cybox_common.ObjectPropertiesType
    def __init__(self, object_reference=None, Custom_Properties=None, xsi_type=None, IDT=None, SSDT=None):
        super(WindowsKernelObjectType, self).__init__(object_reference, Custom_Properties, xsi_type )
        self.IDT = IDT
        self.SSDT = SSDT
    def factory(*args_, **kwargs_):
        if WindowsKernelObjectType.subclass:
            return WindowsKernelObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsKernelObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IDT(self): return self.IDT
    def set_IDT(self, IDT): self.IDT = IDT
    def get_SSDT(self): return self.SSDT
    def set_SSDT(self, SSDT): self.SSDT = SSDT
    def hasContent_(self):
        if (
            self.IDT is not None or
            self.SSDT is not None or
            super(WindowsKernelObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinKernelObj:', name_='WindowsKernelObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsKernelObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinKernelObj:', name_='WindowsKernelObjectType'):
        super(WindowsKernelObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsKernelObjectType')
    def exportChildren(self, outfile, level, namespace_='WinKernelObj:', name_='WindowsKernelObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsKernelObjectType, self).exportChildren(outfile, level, 'WinKernelObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IDT is not None:
            self.IDT.export(outfile, level, 'WinKernelObj:', name_='IDT', pretty_print=pretty_print)
        if self.SSDT is not None:
            self.SSDT.export(outfile, level, 'WinKernelObj:', name_='SSDT', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='WindowsKernelObjectType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(WindowsKernelObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsKernelObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.IDT is not None:
            outfile.write('IDT=model_.IDTEntryListType(\n')
            self.IDT.exportLiteral(outfile, level, name_='IDT')
            outfile.write('),\n')
        if self.SSDT is not None:
            outfile.write('SSDT=model_.SSDTEntryListType(\n')
            self.SSDT.exportLiteral(outfile, level, name_='SSDT')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(WindowsKernelObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IDT':
            obj_ = IDTEntryListType.factory()
            obj_.build(child_)
            self.set_IDT(obj_)
        elif nodeName_ == 'SSDT':
            obj_ = SSDTEntryListType.factory()
            obj_.build(child_)
            self.set_SSDT(obj_)
        super(WindowsKernelObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsKernelObjectType

GDSClassesMapping = {
    'Build_Utility': cybox_common.BuildUtilityType,
    'Errors': cybox_common.ErrorsType,
    'Time': cybox_common.TimeType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'SubDatum': cybox_common.MetadataType,
    'Segment_Hash': cybox_common.HashValueType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'Value': cybox_common.StringObjectPropertyType,
    'Length': cybox_common.IntegerObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Segments': cybox_common.HashSegmentsType,
    'Functions': cybox_common.FunctionsType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'System': cybox_common.ObjectPropertiesType,
    'Platform': cybox_common.PlatformSpecificationType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'Type': cybox_common.ControlledVocabularyStringType,
    'Compilers': cybox_common.CompilersType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'String': cybox_common.ExtractedStringType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
    'Build_Information': cybox_common.BuildInformationType,
    'Selector': cybox_common.HexBinaryObjectPropertyType,
    'Tool_Hashes': cybox_common.HashListType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'Argument_Table_Base': cybox_common.HexBinaryObjectPropertyType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Language': cybox_common.StringObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'Number_Of_Services': cybox_common.NonNegativeIntegerObjectPropertyType,
    'Contributors': cybox_common.PersonnelType,
    'Reference_Description': cybox_common.StructuredTextType,
    'Type_Attr': cybox_common.HexBinaryObjectPropertyType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Data_Size': cybox_common.DataSizeType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'Offset_High': cybox_common.HexBinaryObjectPropertyType,
    'Instance': cybox_common.ObjectPropertiesType,
    'Import': cybox_common.StringObjectPropertyType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Dependencies': cybox_common.DependenciesType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Offset_Low': cybox_common.HexBinaryObjectPropertyType,
    'Hashes': cybox_common.HashListType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'Dependency': cybox_common.DependencyType,
    'Error': cybox_common.ErrorType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'Byte_Run': cybox_common.ByteRunType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'Offset_Middle': cybox_common.HexBinaryObjectPropertyType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Imports': cybox_common.ImportsType,
    'Service_Counter_Table_Base': cybox_common.HexBinaryObjectPropertyType,
    'Library': cybox_common.LibraryType,
    'References': cybox_common.ToolReferencesType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'Service_Table_Base': cybox_common.HexBinaryObjectPropertyType,
    'Libraries': cybox_common.LibrariesType,
    'Function': cybox_common.StringObjectPropertyType,
    'Description': cybox_common.StructuredTextType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'Address': cybox_common.HexBinaryObjectPropertyType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'Compiler': cybox_common.CompilerType,
    'Name': cybox_common.StringObjectPropertyType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Date': cybox_common.DateRangeType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'Contributor': cybox_common.ContributorType,
    'Tools': cybox_common.ToolsInformationType,
    'Tool': cybox_common.ToolInformationType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Kernel'
        rootClass = WindowsKernelObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_=rootTag,
#        namespacedef_='',
#        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Kernel'
        rootClass = WindowsKernelObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Kernel'
        rootClass = WindowsKernelObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_="Windows_Kernel",
#        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Kernel'
        rootClass = WindowsKernelObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsKernelObjectType",
    "SSDTEntryListType",
    "SSDTEntryType",
    "IDTEntryListType",
    "IDTEntryType"
    ]
