const GLchar interactive_frag_str [] = "#version 330\n"
"\n"
"uniform sampler2D texture_image;\n"
"smooth in vec2 tcoord;\n"
"smooth in float interpColor;\n"
"\n"
"layout(location = 0) out vec3 outputColor;\n"
"\n"
"void main()\n"
"{\n"
"outputColor = interpColor*interpColor*texture(texture_image, tcoord).rgb;\n"
"}\n"
"\n"
;
const GLchar interactive_vert_str [] = "#version 330\n"
"\n"
"layout(location = 0) in vec4 position;\n"
"layout(location = 1) in vec2 textureCoord;\n"
"layout(location = 2) in vec3 vertexNormal;\n"
"\n"
"smooth out vec2 tcoord;\n"
"smooth out float interpColor;\n"
"\n"
"uniform mat4 perspectiveMatrix;\n"
"uniform mat4 rotationMatrix;\n"
"uniform vec4 translationVector;\n"
"uniform vec3 lightDirection;\n"
"\n"
"void main()\n"
"{\n"
"vec4 cameraPos = rotationMatrix*position + translationVector;\n"
"gl_Position = perspectiveMatrix*cameraPos;\n"
"tcoord = textureCoord;\n"
"vec4 cameraNormal = rotationMatrix*vec4(vertexNormal,1.0);\n"
"vec3 camNormalised = normalize(cameraNormal.xyz);\n"
"float cosAngIncidence = dot(camNormalised,lightDirection);\n"
"interpColor = camNormalised.z;\n"
"}\n"
"\n"
;
const GLchar texture_shader_frag_str [] = "#version 330\n"
"#extension GL_ARB_explicit_attrib_location : require\n"
"\n"
"uniform sampler2D textureImage;\n"
"smooth in vec2 tcoord;\n"
"smooth in vec3 linearMappingCoord;\n"
"\n"
"layout(location = 0) out vec4 outputColor;\n"
"layout(location = 1) out vec3 outputLinearMapping;\n"
"\n"
"void main() {\n"
"outputColor = texture(textureImage, tcoord);\n"
"outputLinearMapping = linearMappingCoord;\n"
"}\n"
;
const GLchar texture_shader_vert_str [] = "#version 330\n"
"#extension GL_ARB_explicit_attrib_location : require\n"
"\n"
"uniform mat4 projectionMatrix;\n"
"uniform mat4 viewMatrix;\n"
"uniform mat4 modelMatrix;\n"
"uniform vec4 lightDirection;\n"
"\n"
"layout(location = 0) in vec4 point;\n"
"layout(location = 1) in vec2 tcoordIn;\n"
"layout(location = 2) in vec3 linearMappingCoordIn;\n"
"\n"
"smooth out vec2 tcoord;\n"
"smooth out vec3 linearMappingCoord;\n"
"\n"
"void main() {\n"
"// position is what we would normally pass straight through\n"
"vec4 position = projectionMatrix * viewMatrix * modelMatrix * point;\n"
"// flip the y axis to deal with textures being passed in flipped!\n"
"// note that this in effect 'flips' the triangles from being CCW to CW.\n"
"// this will only work when used with the global flag glFrontFace(GL_CW)\n"
"// set.\n"
"position.y = -1.0 * position.y;\n"
"gl_Position = position;\n"
"// same idea, but for the texture space. This deals with the texuture\n"
"// being upside down\n"
"tcoord = vec2(tcoordIn.s, 1.0 - tcoordIn.t);\n"
"linearMappingCoord = linearMappingCoordIn;\n"
"}\n"
"\n"
;
