import requests
import click

ESV_BASEURL = 'http://www.esvapi.org/v2/rest/readingPlanQuery?key=IP&reading-\
               plan-one-year-tract=through-the-bible&include-headings=true\
               &include-verse-numbers=false&include-footnotes=false'

class ESVClient(object):
    def __init__(self, format='plain-text'):
        self.output_format = format

    def get(self, start_date, current_date):
        """Requests Bible passages from ESV API and returns response
        as a string.
        """
        url_components = [ESV_BASEURL]
        url_components.append('&start-date=%s' % (start_date))
        url_components.append('&date=%s' % (current_date))
        url_components.append('&output-format=%s' % (self.output_format))
        url = "".join(url_components)
        r = requests.get(url)
        return r.text
