"""
Read the Bible in a year (command line application).
"""
from setuptools import find_packages, setup
from dailybible import dailybible

dependencies = ['click', 'requests']

setup(
    name='dailybible',
    version=dailybible.VERSION,
    url='https://github.com/jonbeebe/python3-dailybible',
    license='BSD',
    author='Jonathan Beebe',
    author_email='me@jonbeebe.net',
    description='Read the Bible in a year (command line application).',
    long_description=__doc__,
    packages=find_packages(exclude=['tests']),
    include_package_data=True,
    zip_safe=False,
    platforms='any',
    install_requires=dependencies,
    entry_points='''
        [console_scripts]
        dailybible=dailybible.dailybible:cli
    ''',
    classifiers=[
        # As from http://pypi.python.org/pypi?%3Aaction=list_classifiers
        # 'Development Status :: 1 - Planning',
        # 'Development Status :: 2 - Pre-Alpha',
        # 'Development Status :: 3 - Alpha',
        #'Development Status :: 4 - Beta',
        'Development Status :: 5 - Production/Stable',
        # 'Development Status :: 6 - Mature',
        # 'Development Status :: 7 - Inactive',
        'Environment :: Console',
        'Intended Audience :: Religion',
        'License :: OSI Approved :: BSD License',
        'Operating System :: POSIX',
        'Operating System :: Unix',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: Microsoft',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 3',
    ]
)

